/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.runtime;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.VariableInstanceEntity;
import kd.bos.workflow.engine.impl.variable.ValueFields;
import kd.bos.workflow.engine.impl.variable.VariableType;
import org.apache.commons.lang.StringUtils;

public class VariableInstanceEntityImpl
extends AbstractEntity
implements VariableInstanceEntity,
ValueFields,
Serializable {
    private static final long serialVersionUID = 1L;
    protected transient VariableType type;
    protected transient Object cachedValue;
    protected boolean forcedUpdate;

    public VariableInstanceEntityImpl() {
    }

    public VariableInstanceEntityImpl(DynamicObject dynamicObject) {
        super(dynamicObject);
        if (WfUtils.isNotEmpty(this.getTypeName()) && Context.getCommandContext() != null && Context.getCommandContext().getProcessEngineConfiguration() != null) {
            this.type = Context.getCommandContext().getProcessEngineConfiguration().getVariableTypes().getVariableType(this.getTypeName());
        }
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        persistentState.put("longValue", this.getLongValue());
        persistentState.put("doubleValue", this.getDoubleValue());
        persistentState.put("textValue", this.getTextValue());
        persistentState.put("taskId", this.getTaskId());
        persistentState.put("actInstId", this.getActInstId());
        persistentState.put("typeName", this.getTypeName());
        if (this.forcedUpdate) {
            persistentState.put("forcedUpdate", Boolean.TRUE);
        }
        return persistentState;
    }

    @Override
    public void forceUpdate() {
        this.forcedUpdate = true;
    }

    @Override
    public Object getValue() {
        if (!this.type.isCachable() || this.cachedValue == null) {
            this.cachedValue = this.type.getValue(this);
        }
        return this.cachedValue;
    }

    @Override
    public void setValue(Object value) {
        this.type.setValue(value, this);
        this.dynamicObject.set("typeName", (Object)this.type.getTypeName());
        this.cachedValue = value;
    }

    @Override
    @SimplePropertyAttribute(name="name")
    public String getName() {
        return this.dynamicObject.getString("name");
    }

    @Override
    public void setName(String name) {
        this.dynamicObject.set("name", (Object)name);
    }

    @Override
    @SimplePropertyAttribute(name="typeName")
    public final String getTypeName() {
        String typeName = this.dynamicObject.getString("typeName");
        if (WfUtils.isEmpty(typeName) && this.type != null) {
            typeName = this.type.getTypeName();
        }
        return typeName;
    }

    @Override
    public void setTypeName(String typeName) {
        this.dynamicObject.set("typeName", (Object)typeName);
        if (Context.getCommandContext() != null && Context.getCommandContext().getProcessEngineConfiguration() != null) {
            this.type = Context.getCommandContext().getProcessEngineConfiguration().getVariableTypes().getVariableType(typeName);
        }
    }

    @Override
    public VariableType getType() {
        return this.type;
    }

    @Override
    public void setType(VariableType type) {
        this.type = type;
    }

    @Override
    @SimplePropertyAttribute(name="processInstanceId")
    public Long getProcessInstanceId() {
        return this.normalizeId(this.dynamicObject.getLong("processInstanceId"));
    }

    @Override
    public void setProcessInstanceId(Long processInstanceId) {
        this.dynamicObject.set("processInstanceId", (Object)processInstanceId);
    }

    @Override
    @SimplePropertyAttribute(name="executionId")
    public Long getExecutionId() {
        return this.normalizeId(this.dynamicObject.getLong("executionId"));
    }

    @Override
    public void setExecutionId(Long executionId) {
        this.dynamicObject.set("executionId", (Object)executionId);
    }

    @Override
    public void setExecution(ExecutionEntity execution) {
        this.dynamicObject.set("executionId", (Object)execution.getId());
        this.dynamicObject.set("processInstanceId", (Object)execution.getProcessInstanceId());
        this.forceUpdate();
    }

    @Override
    @SimplePropertyAttribute(name="taskId")
    public Long getTaskId() {
        return this.normalizeId(this.dynamicObject.getLong("taskId"));
    }

    @Override
    public void setTaskId(Long taskId) {
        this.dynamicObject.set("taskId", (Object)taskId);
    }

    @Override
    @SimplePropertyAttribute(name="actInstId")
    public Long getActInstId() {
        return this.normalizeId(this.dynamicObject.getLong("actInstId"));
    }

    @Override
    public void setActInstId(Long actInstId) {
        this.dynamicObject.set("actInstId", (Object)actInstId);
    }

    @Override
    @SimplePropertyAttribute(name="longValue")
    public Long getLongValue() {
        return this.dynamicObject.getLong("longValue");
    }

    @Override
    public void setLongValue(Long longValue) {
        this.dynamicObject.set("longValue", (Object)longValue);
    }

    @Override
    @SimplePropertyAttribute(name="doubleValue")
    public Double getDoubleValue() {
        BigDecimal ret = this.dynamicObject.getBigDecimal("doubleValue");
        if (ret != null) {
            return ret.doubleValue();
        }
        return null;
    }

    @Override
    public void setDoubleValue(Double doubleValue) {
        this.dynamicObject.set("doubleValue", (Object)doubleValue);
    }

    @Override
    @SimplePropertyAttribute(name="textValue")
    public String getTextValue() {
        return this.dynamicObject.getString("textValue");
    }

    @Override
    public void setTextValue(String textValue) {
        this.dynamicObject.set("textValue", (Object)textValue);
    }

    @Override
    @SimplePropertyAttribute(name="textValue2")
    public String getTextValue2() {
        return this.dynamicObject.getString("textValue2");
    }

    @Override
    public void setTextValue2(String textValue2) {
        this.dynamicObject.set("textValue2", (Object)textValue2);
    }

    @Override
    public Object getCachedValue() {
        return this.cachedValue;
    }

    @Override
    public void setCachedValue(Object cachedValue) {
        this.cachedValue = cachedValue;
    }

    @Override
    public String getDynObjTypeName() {
        return "wf_variableinstance";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("VariableInstanceEntity[");
        sb.append("id=").append(this.getId());
        sb.append(", name=").append(this.getName());
        sb.append(", type=").append(this.type != null ? this.type.getTypeName() : "null");
        if (this.getLongValue() != null) {
            sb.append(", longValue=").append(this.getLongValue());
        }
        if (this.getDoubleValue() != null) {
            sb.append(", doubleValue=").append(this.getDoubleValue());
        }
        if (this.getTextValue() != null) {
            sb.append(", textValue=").append(StringUtils.abbreviate((String)this.getTextValue(), (int)40));
        }
        if (this.getTextValue2() != null) {
            sb.append(", textValue2=").append(StringUtils.abbreviate((String)this.getTextValue2(), (int)40));
        }
        sb.append(']');
        return sb.toString();
    }
}

