/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.persistence.CachedEntityMatcher;
import kd.bos.workflow.engine.impl.persistence.CountingExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.VariableByExecutionIdMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.VariableByFilterMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.VariableInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.VariableInstanceEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.VariableInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.variable.ValueFields;
import kd.bos.workflow.engine.impl.variable.VariableType;

public class VariableInstanceEntityManagerImpl
extends AbstractEntityManager<VariableInstanceEntity>
implements VariableInstanceEntityManager {
    protected CachedEntityMatcher<VariableInstanceEntity> variableInstanceEntity = new VariableByExecutionIdMatcher();
    protected CachedEntityMatcher<VariableInstanceEntity> variableByFilterMatcher = new VariableByFilterMatcher();

    public VariableInstanceEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public Class<? extends VariableInstanceEntity> getManagedEntityClass() {
        return VariableInstanceEntityImpl.class;
    }

    @Override
    public String getSelectFields() {
        return "id,typeName,name,processInstanceId,executionId,taskId,doubleValue,longValue,textValue,description,actInstId,createDate,modifyDate,textvalue2";
    }

    @Override
    public VariableInstanceEntity create(String name, VariableType type, Object value) {
        VariableInstanceEntity variableInstance = (VariableInstanceEntity)this.create();
        variableInstance.setName(name);
        variableInstance.setType(type);
        variableInstance.setTypeName(type.getTypeName());
        variableInstance.setValue(value);
        return variableInstance;
    }

    @Override
    public void insert(VariableInstanceEntity entity, boolean fireCreateEvent) {
        CountingExecutionEntity executionEntity;
        super.insert(entity, fireCreateEvent);
        if (entity.getExecutionId() != null && this.isExecutionRelatedEntityCountEnabledGlobally() && this.isExecutionRelatedEntityCountEnabled(executionEntity = (CountingExecutionEntity)this.getExecutionEntityManager().findById(entity.getExecutionId()))) {
            executionEntity.setVariableCount(executionEntity.getVariableCount() + 1);
        }
    }

    @Override
    public List<VariableInstanceEntity> findVariableInstancesByTaskId(Long taskId) {
        if (WfUtils.isEmpty(taskId)) {
            return Collections.emptyList();
        }
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("taskId", taskId);
        return this.findByQueryBuilder(eb);
    }

    @Override
    public List<VariableInstanceEntity> findVariableInstancesByTaskIds(Set<Long> taskIds) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("taskId", "in", taskIds);
        return this.findByQueryBuilder(eb);
    }

    @Override
    public List<VariableInstanceEntity> findVariableInstancesByExecutionId(Long executionId) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("executionId", executionId);
        List variables = this.findByQueryBuilder(eb);
        ArrayList<VariableInstanceEntity> ret = new ArrayList<VariableInstanceEntity>();
        if (WfUtils.isNotEmptyForCollection(variables)) {
            for (VariableInstanceEntity entity : variables) {
                if (!WfUtils.isEmpty(entity.getTaskId())) continue;
                ret.add(entity);
            }
        }
        return ret;
    }

    @Override
    public VariableInstanceEntity findVariableInstanceByExecutionAndName(Long executionId, String variableName) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("executionId", executionId).addFilter("name", variableName);
        return (VariableInstanceEntity)this.findOneByCondition(eb.getFilters(), null, null);
    }

    @Override
    public List<VariableInstanceEntity> findVariableInstancesByExecutionAndNames(Long executionId, Collection<String> names) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("executionId", executionId).addFilter("name", "in", names).addFilter("taskId", "=", 0);
        return this.findByQueryBuilder(eb);
    }

    @Override
    public VariableInstanceEntity findVariableInstanceByTaskAndName(Long taskId, String variableName) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("taskId", taskId).addFilter("name", variableName);
        return (VariableInstanceEntity)this.findOneByCondition(eb.getFilters(), null, null);
    }

    @Override
    public List<VariableInstanceEntity> findVariableInstancesByTaskAndNames(Long taskId, Collection<String> names) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("taskId", taskId).addFilter("name", "in", names);
        return this.findByQueryBuilder(eb);
    }

    @Override
    public List<VariableInstanceEntity> findVariableInstancesByProcessInstanceId(Long processInstanceId) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("processInstanceId", processInstanceId);
        return this.findByQueryBuilder(eb);
    }

    @Override
    public List<VariableInstanceEntity> findVariableInstancesByFilters(QFilter[] filters, Object parameter, boolean checkCache) {
        EntityQueryBuilder qb = new EntityQueryBuilder(this.getEntityName(), filters, this.getSelectFields(), this.getManagedEntityClass());
        return this.getList(qb, this.variableByFilterMatcher, parameter, checkCache);
    }

    @Override
    public Map<String, String> findBizApplierInfoByProcessInstanceId(Long processInstanceId) {
        List<VariableInstanceEntity> entities = this.findVariableInstancesByProcessInstanceId(processInstanceId);
        HashMap<String, String> bizApplierInfo = new HashMap<String, String>();
        for (VariableInstanceEntity variableInstanceEntity : entities) {
            String variableName = variableInstanceEntity.getName();
            if (variableName.equals("bizApplier")) {
                bizApplierInfo.put("bizApplier", variableInstanceEntity.getTextValue());
            }
            if (!variableName.equals("bizApplierName")) continue;
            bizApplierInfo.put("bizApplierName", variableInstanceEntity.getTextValue());
        }
        return bizApplierInfo;
    }

    @Override
    public void delete(VariableInstanceEntity entity, boolean fireDeleteEvent) {
        CountingExecutionEntity executionEntity;
        super.delete(entity, false);
        entity.setDeleted(true);
        if (entity.getExecutionId() != null && this.isExecutionRelatedEntityCountEnabledGlobally() && this.isExecutionRelatedEntityCountEnabled(executionEntity = (CountingExecutionEntity)this.getExecutionEntityManager().findById(entity.getExecutionId()))) {
            executionEntity.setVariableCount(executionEntity.getVariableCount() - 1);
        }
    }

    @Override
    public void deleteVariableInstanceByTask(TaskEntity task) {
        Map<String, VariableInstanceEntity> variableInstances = task.getVariableInstanceEntities();
        if (variableInstances != null) {
            for (VariableInstanceEntity variableInstance : variableInstances.values()) {
                this.delete(variableInstance);
            }
        }
    }

    @Override
    protected void fixSpecialProp(VariableInstanceEntity t) {
        super.fixSpecialProp(t);
        String typeName = t.getTypeName();
        if (WfUtils.isNotEmpty(typeName)) {
            t.setType(this.processEngineConfiguration.getVariableTypes().getVariableType(typeName));
        }
    }

    @Override
    public String getEntityName() {
        return "wf_variableinstance";
    }

    @Override
    public Map<String, Object> findVariableInstancesByExecutionAndNames(Long executionId, String[] names) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("executionId", executionId).addFilter("name", "in", names).addFilter("taskId", "=", 0);
        List variableInstanceEntities = this.findByQueryBuilder(eb);
        if (WfUtils.isNotEmptyForCollection(variableInstanceEntities)) {
            for (VariableInstanceEntity t : variableInstanceEntities) {
                variables.put(t.getName(), t.getValue());
            }
        }
        return variables;
    }

    @Override
    public Map<String, Object> findVariablesByTaskId(Long taskId) {
        List<VariableInstanceEntity> col = this.findVariableInstancesByTaskId(taskId);
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (col != null) {
            for (VariableInstanceEntity var : col) {
                ret.put(var.getName(), var.getValue());
            }
        }
        return ret;
    }

    @Override
    public List<ValueFields> findVariableInstancesByProcessInstanceId(Long procInstanceId, String[] name) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("processInstanceId", procInstanceId).addFilter("name", "in", name);
        List o = this.findByQueryBuilder(eb);
        ArrayList<ValueFields> tmp = new ArrayList<ValueFields>(o == null ? 0 : o.size());
        if (o != null && o.size() > 0) {
            for (VariableInstanceEntity t : o) {
                tmp.add(t);
            }
        }
        return tmp;
    }

    @Override
    public List<VariableInstanceEntity> findVariableInstancesByProcessInstanceIdsAndnames(List<Long> procInstanceIds, List<String> variableNames) {
        if (WfUtils.isEmptyForCollection(procInstanceIds) || WfUtils.isEmptyForCollection(variableNames)) {
            return new ArrayList<VariableInstanceEntity>();
        }
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("processInstanceId", "in", procInstanceIds).addFilter("name", "in", variableNames);
        return this.findByQueryBuilder(eb);
    }
}

