/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.runtime;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.el.ELContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.script.annotations.KSMethod;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.TransientVariableInstance;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.VariableInstance;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.VariableInstanceEntity;
import kd.bos.workflow.engine.impl.variable.VariableType;
import kd.bos.workflow.engine.impl.variable.VariableTypes;
import kd.bos.workflow.exception.WFEngineException;

public abstract class VariableScopeImpl
extends AbstractEntity
implements Serializable,
VariableScope {
    private static final long serialVersionUID = 1L;
    protected transient Map<String, VariableInstanceEntity> variableInstances;
    protected transient Map<String, VariableInstanceEntity> usedVariablesCache = new HashMap<String, VariableInstanceEntity>();
    protected transient Map<String, VariableInstance> transientVariabes;
    protected transient ELContext cachedElContext;

    public VariableScopeImpl() {
    }

    public VariableScopeImpl(DynamicObject dynamicObject) {
        super(dynamicObject);
    }

    protected abstract Collection<VariableInstanceEntity> loadVariableInstances();

    protected abstract VariableScopeImpl getParentVariableScope();

    protected abstract void initializeVariableInstanceBackPointer(VariableInstanceEntity var1);

    protected void ensureVariableInstancesInitialized() {
        if (this.variableInstances == null) {
            CommandContext commandContext = Context.getCommandContext();
            if (commandContext == null) {
                throw new WFEngineException("lazy loading outside command context");
            }
            Collection<VariableInstanceEntity> variableInstancesList = this.loadVariableInstances();
            this.variableInstances = variableInstancesList == null || variableInstancesList.isEmpty() ? new HashMap<String, VariableInstanceEntity>(5) : new HashMap<String, VariableInstanceEntity>(variableInstancesList.size());
            if (variableInstancesList != null) {
                for (VariableInstanceEntity variableInstance : variableInstancesList) {
                    this.variableInstances.put(variableInstance.getName(), variableInstance);
                }
            }
        }
    }

    @Override
    public Map<String, Object> getVariables() {
        return this.collectVariables(new HashMap<String, Object>());
    }

    @Override
    public Map<String, VariableInstance> getVariableInstances() {
        return this.collectVariableInstances(new HashMap<String, VariableInstance>());
    }

    @Override
    public Map<String, Object> getVariables(Collection<String> variableNames) {
        return this.getVariables(variableNames, true);
    }

    @Override
    public Map<String, VariableInstance> getVariableInstances(Collection<String> variableNames) {
        return this.getVariableInstances(variableNames, true);
    }

    @Override
    public Map<String, Object> getVariables(Collection<String> variableNames, boolean fetchAllVariables) {
        if (variableNames == null) {
            return new HashMap<String, Object>(0);
        }
        HashMap<String, Object> requestedVariables = new HashMap<String, Object>(variableNames.size());
        HashSet<String> variableNamesToFetch = new HashSet<String>(variableNames);
        for (String string : variableNames) {
            if (this.transientVariabes != null && this.transientVariabes.containsKey(string)) {
                requestedVariables.put(string, this.transientVariabes.get(string).getValue());
                variableNamesToFetch.remove(string);
                continue;
            }
            if (!this.usedVariablesCache.containsKey(string)) continue;
            requestedVariables.put(string, this.usedVariablesCache.get(string).getValue());
            variableNamesToFetch.remove(string);
        }
        if (fetchAllVariables) {
            Map<String, Object> allVariables = this.getVariables();
            for (String variableName : variableNamesToFetch) {
                requestedVariables.put(variableName, allVariables.get(variableName));
            }
            return requestedVariables;
        }
        VariableScopeImpl parent = this.getParentVariableScope();
        if (parent != null) {
            requestedVariables.putAll(parent.getVariables(variableNamesToFetch, fetchAllVariables));
        }
        List<VariableInstanceEntity> list = this.getSpecificVariables(variableNamesToFetch);
        for (VariableInstanceEntity variable : list) {
            requestedVariables.put(variable.getName(), variable.getValue());
        }
        return requestedVariables;
    }

    @Override
    public Map<String, VariableInstance> getVariableInstances(Collection<String> variableNames, boolean fetchAllVariables) {
        if (variableNames == null) {
            return new HashMap<String, VariableInstance>(0);
        }
        HashMap<String, VariableInstance> requestedVariables = new HashMap<String, VariableInstance>(variableNames.size());
        HashSet<String> variableNamesToFetch = new HashSet<String>(variableNames);
        for (String string : variableNames) {
            if (this.transientVariabes != null && this.transientVariabes.containsKey(string)) {
                requestedVariables.put(string, this.transientVariabes.get(string));
                variableNamesToFetch.remove(string);
                continue;
            }
            if (!this.usedVariablesCache.containsKey(string)) continue;
            requestedVariables.put(string, this.usedVariablesCache.get(string));
            variableNamesToFetch.remove(string);
        }
        if (fetchAllVariables) {
            Map<String, VariableInstance> allVariables = this.getVariableInstances();
            for (String variableName : variableNamesToFetch) {
                requestedVariables.put(variableName, allVariables.get(variableName));
            }
            return requestedVariables;
        }
        VariableScopeImpl parent = this.getParentVariableScope();
        if (parent != null) {
            requestedVariables.putAll(parent.getVariableInstances(variableNamesToFetch, fetchAllVariables));
        }
        List<VariableInstanceEntity> list = this.getSpecificVariables(variableNamesToFetch);
        for (VariableInstanceEntity variable : list) {
            requestedVariables.put(variable.getName(), variable);
        }
        return requestedVariables;
    }

    protected Map<String, Object> collectVariables(HashMap<String, Object> variables) {
        this.ensureVariableInstancesInitialized();
        VariableScopeImpl parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            variables.putAll(parentScope.collectVariables(variables));
        }
        for (VariableInstanceEntity variableInstanceEntity : this.variableInstances.values()) {
            variables.put(variableInstanceEntity.getName(), variableInstanceEntity.getValue());
        }
        for (Map.Entry entry : this.usedVariablesCache.entrySet()) {
            variables.put((String)entry.getKey(), ((VariableInstanceEntity)entry.getValue()).getValue());
        }
        if (this.transientVariabes != null) {
            for (Map.Entry entry : this.transientVariabes.entrySet()) {
                variables.put((String)entry.getKey(), ((VariableInstance)entry.getValue()).getValue());
            }
        }
        return variables;
    }

    protected Map<String, VariableInstance> collectVariableInstances(HashMap<String, VariableInstance> variables) {
        this.ensureVariableInstancesInitialized();
        VariableScopeImpl parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            variables.putAll(parentScope.collectVariableInstances(variables));
        }
        for (VariableInstance variableInstance : this.variableInstances.values()) {
            variables.put(variableInstance.getName(), variableInstance);
        }
        for (Map.Entry entry : this.usedVariablesCache.entrySet()) {
            variables.put((String)entry.getKey(), (VariableInstance)entry.getValue());
        }
        if (this.transientVariabes != null) {
            variables.putAll(this.transientVariabes);
        }
        return variables;
    }

    @Override
    public Object getVariableIgnoreCase(String variableName) {
        if (this.hasVariable(variableName)) {
            return this.getVariable(variableName, true);
        }
        if (this.hasVariable(variableName.toLowerCase())) {
            return this.getVariable(variableName.toLowerCase(), true);
        }
        return null;
    }

    @Override
    @KSMethod
    public Object getVariable(String variableName) {
        return this.getVariable(variableName, true);
    }

    @Override
    public VariableInstance getVariableInstance(String variableName) {
        return this.getVariableInstance(variableName, true);
    }

    @Override
    public Object getVariable(String variableName, boolean fetchAllVariables) {
        Object value = null;
        VariableInstance variable = this.getVariableInstance(variableName, fetchAllVariables);
        if (variable != null) {
            value = variable.getValue();
        }
        return value;
    }

    @Override
    public VariableInstance getVariableInstance(String variableName, boolean fetchAllVariables) {
        if (this.transientVariabes != null && this.transientVariabes.containsKey(variableName)) {
            return this.transientVariabes.get(variableName);
        }
        if (this.usedVariablesCache.containsKey(variableName)) {
            return this.usedVariablesCache.get(variableName);
        }
        if (fetchAllVariables) {
            this.ensureVariableInstancesInitialized();
            VariableInstanceEntity variableInstance = this.variableInstances.get(variableName);
            if (variableInstance != null) {
                return variableInstance;
            }
            VariableScopeImpl parentScope = this.getParentVariableScope();
            if (parentScope != null) {
                return parentScope.getVariableInstance(variableName, true);
            }
            return null;
        }
        if (this.variableInstances != null && this.variableInstances.containsKey(variableName)) {
            return this.variableInstances.get(variableName);
        }
        VariableInstanceEntity variable = this.getSpecificVariable(variableName);
        if (variable != null) {
            this.usedVariablesCache.put(variableName, variable);
            return variable;
        }
        VariableScopeImpl parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            return parentScope.getVariableInstance(variableName, false);
        }
        return null;
    }

    protected abstract VariableInstanceEntity getSpecificVariable(String var1);

    @Override
    public Object getVariableLocalIgnoreCase(String variableName) {
        if (this.hasVariableLocal(variableName)) {
            return this.getVariableLocal(variableName, true);
        }
        if (this.hasVariableLocal(variableName.toLowerCase())) {
            return this.getVariableLocal(variableName.toLowerCase(), true);
        }
        return null;
    }

    @Override
    public Object getVariableLocal(String variableName) {
        return this.getVariableLocal(variableName, true);
    }

    @Override
    public VariableInstance getVariableInstanceLocal(String variableName) {
        return this.getVariableInstanceLocal(variableName, true);
    }

    @Override
    public Object getVariableLocal(String variableName, boolean fetchAllVariables) {
        Object value = null;
        VariableInstance variable = this.getVariableInstanceLocal(variableName, fetchAllVariables);
        if (variable != null) {
            value = variable.getValue();
        }
        return value;
    }

    @Override
    public VariableInstance getVariableInstanceLocal(String variableName, boolean fetchAllVariables) {
        VariableInstanceEntity variable;
        if (this.transientVariabes != null && this.transientVariabes.containsKey(variableName)) {
            return this.transientVariabes.get(variableName);
        }
        if (this.usedVariablesCache.containsKey(variableName)) {
            return this.usedVariablesCache.get(variableName);
        }
        if (fetchAllVariables) {
            this.ensureVariableInstancesInitialized();
            VariableInstanceEntity variableInstance = this.variableInstances.get(variableName);
            if (variableInstance != null) {
                return variableInstance;
            }
            return null;
        }
        if (this.variableInstances != null && this.variableInstances.containsKey(variableName) && (variable = this.variableInstances.get(variableName)) != null) {
            return this.variableInstances.get(variableName);
        }
        variable = this.getSpecificVariable(variableName);
        if (variable != null) {
            this.usedVariablesCache.put(variableName, variable);
            return variable;
        }
        return null;
    }

    @Override
    public boolean hasVariables() {
        if (this.transientVariabes != null && !this.transientVariabes.isEmpty()) {
            return true;
        }
        this.ensureVariableInstancesInitialized();
        if (!this.variableInstances.isEmpty()) {
            return true;
        }
        VariableScopeImpl parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            return parentScope.hasVariables();
        }
        return false;
    }

    @Override
    public boolean hasVariablesLocal() {
        if (this.transientVariabes != null && !this.transientVariabes.isEmpty()) {
            return true;
        }
        this.ensureVariableInstancesInitialized();
        return !this.variableInstances.isEmpty();
    }

    @Override
    public boolean hasVariableIgnoreCase(String variableName) {
        return this.hasVariable(variableName) || this.hasVariable(variableName.toLowerCase());
    }

    @Override
    public boolean hasVariable(String variableName) {
        if (this.hasVariableLocal(variableName)) {
            return true;
        }
        VariableScopeImpl parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            return parentScope.hasVariable(variableName);
        }
        return false;
    }

    @Override
    public boolean hasVariableLocalIgnoreCase(String variableName) {
        return this.hasVariableLocal(variableName) || this.hasVariableLocal(variableName.toLowerCase());
    }

    @Override
    public boolean hasVariableLocal(String variableName) {
        if (this.transientVariabes != null && this.transientVariabes.containsKey(variableName)) {
            return true;
        }
        this.ensureVariableInstancesInitialized();
        return this.variableInstances.containsKey(variableName);
    }

    protected Set<String> collectVariableNames(Set<String> variableNames) {
        if (this.transientVariabes != null) {
            variableNames.addAll(this.transientVariabes.keySet());
        }
        this.ensureVariableInstancesInitialized();
        VariableScopeImpl parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            variableNames.addAll(parentScope.collectVariableNames(variableNames));
        }
        for (VariableInstanceEntity variableInstance : this.variableInstances.values()) {
            variableNames.add(variableInstance.getName());
        }
        return variableNames;
    }

    @Override
    public Set<String> getVariableNames() {
        return this.collectVariableNames(new HashSet<String>());
    }

    @Override
    public Map<String, Object> getVariablesLocal() {
        int size = 0;
        if (this.usedVariablesCache != null && !this.usedVariablesCache.isEmpty()) {
            size += this.usedVariablesCache.size();
        }
        if (this.variableInstances != null && !this.variableInstances.isEmpty()) {
            size += this.variableInstances.size();
        }
        HashMap<String, Object> variables = new HashMap<String, Object>(size);
        this.ensureVariableInstancesInitialized();
        if (this.variableInstances != null) {
            for (VariableInstanceEntity variableInstanceEntity : this.variableInstances.values()) {
                variables.put(variableInstanceEntity.getName(), variableInstanceEntity.getValue());
            }
        }
        if (this.usedVariablesCache != null) {
            for (Map.Entry entry : this.usedVariablesCache.entrySet()) {
                variables.put((String)entry.getKey(), ((VariableInstanceEntity)entry.getValue()).getValue());
            }
        }
        if (this.transientVariabes != null) {
            for (Map.Entry entry : this.transientVariabes.entrySet()) {
                variables.put((String)entry.getKey(), ((VariableInstance)entry.getValue()).getValue());
            }
        }
        return variables;
    }

    @Override
    public Map<String, VariableInstance> getVariableInstancesLocal() {
        int size = 0;
        if (this.usedVariablesCache != null && !this.usedVariablesCache.isEmpty()) {
            size += this.usedVariablesCache.size();
        }
        if (this.variableInstances != null && !this.variableInstances.isEmpty()) {
            size += this.variableInstances.size();
        }
        HashMap<String, VariableInstance> variables = new HashMap<String, VariableInstance>(size);
        this.ensureVariableInstancesInitialized();
        if (this.variableInstances != null) {
            for (VariableInstanceEntity variableInstanceEntity : this.variableInstances.values()) {
                variables.put(variableInstanceEntity.getName(), variableInstanceEntity);
            }
        }
        if (this.usedVariablesCache != null) {
            for (Map.Entry entry : this.usedVariablesCache.entrySet()) {
                variables.put((String)entry.getKey(), (VariableInstance)entry.getValue());
            }
        }
        if (this.transientVariabes != null) {
            variables.putAll(this.transientVariabes);
        }
        return variables;
    }

    @Override
    public Map<String, Object> getVariablesLocal(Collection<String> variableNames) {
        return this.getVariablesLocal(variableNames, true);
    }

    @Override
    public Map<String, VariableInstance> getVariableInstancesLocal(Collection<String> variableNames) {
        return this.getVariableInstancesLocal(variableNames, true);
    }

    @Override
    public Map<String, Object> getVariablesLocal(Collection<String> variableNames, boolean fetchAllVariables) {
        HashMap<String, Object> requestedVariables = new HashMap<String, Object>();
        HashSet<String> variableNamesToFetch = new HashSet<String>(variableNames);
        for (String variableName : variableNames) {
            if (this.transientVariabes != null && this.transientVariabes.containsKey(variableName)) {
                requestedVariables.put(variableName, this.transientVariabes.get(variableName).getValue());
                variableNamesToFetch.remove(variableName);
                continue;
            }
            if (!this.usedVariablesCache.containsKey(variableName)) continue;
            requestedVariables.put(variableName, this.usedVariablesCache.get(variableName).getValue());
            variableNamesToFetch.remove(variableName);
        }
        if (fetchAllVariables) {
            Map<String, Object> allVariables = this.getVariablesLocal();
            for (String variableName : variableNamesToFetch) {
                requestedVariables.put(variableName, allVariables.get(variableName));
            }
        } else {
            List<VariableInstanceEntity> variables = this.getSpecificVariables(variableNamesToFetch);
            for (VariableInstanceEntity variable : variables) {
                requestedVariables.put(variable.getName(), variable.getValue());
            }
        }
        return requestedVariables;
    }

    @Override
    public Map<String, VariableInstance> getVariableInstancesLocal(Collection<String> variableNames, boolean fetchAllVariables) {
        HashMap<String, VariableInstance> requestedVariables = new HashMap<String, VariableInstance>();
        HashSet<String> variableNamesToFetch = new HashSet<String>(variableNames);
        for (String variableName : variableNames) {
            if (this.transientVariabes != null && this.transientVariabes.containsKey(variableName)) {
                requestedVariables.put(variableName, this.transientVariabes.get(variableName));
                variableNamesToFetch.remove(variableName);
                continue;
            }
            if (!this.usedVariablesCache.containsKey(variableName)) continue;
            requestedVariables.put(variableName, this.usedVariablesCache.get(variableName));
            variableNamesToFetch.remove(variableName);
        }
        if (fetchAllVariables) {
            Map<String, VariableInstance> allVariables = this.getVariableInstancesLocal();
            for (String variableName : variableNamesToFetch) {
                requestedVariables.put(variableName, allVariables.get(variableName));
            }
        } else {
            List<VariableInstanceEntity> variables = this.getSpecificVariables(variableNamesToFetch);
            for (VariableInstanceEntity variable : variables) {
                requestedVariables.put(variable.getName(), variable);
            }
        }
        return requestedVariables;
    }

    protected abstract List<VariableInstanceEntity> getSpecificVariables(Collection<String> var1);

    @Override
    public Set<String> getVariableNamesLocal() {
        HashSet<String> variableNames = new HashSet<String>();
        if (this.transientVariabes != null) {
            variableNames.addAll(this.transientVariabes.keySet());
        }
        this.ensureVariableInstancesInitialized();
        variableNames.addAll(this.variableInstances.keySet());
        return variableNames;
    }

    public Map<String, VariableInstanceEntity> getVariableInstanceEntities() {
        this.ensureVariableInstancesInitialized();
        return Collections.unmodifiableMap(this.variableInstances);
    }

    public Map<String, VariableInstanceEntity> getUsedVariablesCache() {
        return this.usedVariablesCache;
    }

    public void createVariablesLocal(Map<String, ? extends Object> variables) {
        if (variables != null) {
            for (Map.Entry<String, ? extends Object> entry : variables.entrySet()) {
                this.createVariableLocal(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public void setVariables(Map<String, ? extends Object> variables) {
        if (variables != null) {
            for (Map.Entry<String, ? extends Object> entry : variables.entrySet()) {
                this.setVariable(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public void setVariablesLocal(Map<String, ? extends Object> variables) {
        if (variables != null) {
            for (Map.Entry<String, ? extends Object> entry : variables.entrySet()) {
                this.setVariableLocal(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public void removeVariables() {
        this.ensureVariableInstancesInitialized();
        HashSet<String> variableNames = new HashSet<String>(this.variableInstances.keySet());
        for (String variableName : variableNames) {
            this.removeVariable(variableName);
        }
    }

    @Override
    public void removeVariablesLocal() {
        ArrayList<String> variableNames = new ArrayList<String>(this.getVariableNamesLocal());
        for (String variableName : variableNames) {
            this.removeVariableLocal(variableName);
        }
    }

    @Override
    public void removeVariables(Collection<String> variableNames) {
        if (variableNames != null) {
            for (String variableName : variableNames) {
                this.removeVariable(variableName);
            }
        }
    }

    @Override
    public void removeVariablesLocal(Collection<String> variableNames) {
        if (variableNames != null) {
            for (String variableName : variableNames) {
                this.removeVariableLocal(variableName);
            }
        }
    }

    @Override
    @KSMethod
    public void setVariable(String variableName, Object value) {
        this.setVariable(variableName, value, this.getSourceActivityExecution(), true);
    }

    @Override
    public void setVariable(String variableName, Object value, boolean fetchAllVariables) {
        this.setVariable(variableName, value, this.getSourceActivityExecution(), fetchAllVariables);
    }

    protected void setVariable(String variableName, Object value, ExecutionEntity sourceExecution, boolean fetchAllVariables) {
        if (fetchAllVariables) {
            if (this.usedVariablesCache.containsKey(variableName)) {
                this.updateVariableInstance(this.usedVariablesCache.get(variableName), value, sourceExecution);
            }
            if (this.hasVariableLocal(variableName)) {
                this.setVariableLocal(variableName, value, sourceExecution, true);
                return;
            }
            VariableScopeImpl parentVariableScope = this.getParentVariableScope();
            if (parentVariableScope != null) {
                if (sourceExecution == null) {
                    parentVariableScope.setVariable(variableName, value);
                } else {
                    parentVariableScope.setVariable(variableName, value, sourceExecution, true);
                }
                return;
            }
            if (sourceExecution != null) {
                this.createVariableLocal(variableName, value, sourceExecution);
            } else {
                this.createVariableLocal(variableName, value);
            }
        } else if (this.usedVariablesCache.containsKey(variableName)) {
            this.updateVariableInstance(this.usedVariablesCache.get(variableName), value, sourceExecution);
        } else if (this.variableInstances != null && this.variableInstances.containsKey(variableName)) {
            this.updateVariableInstance(this.variableInstances.get(variableName), value, sourceExecution);
        } else {
            VariableInstanceEntity variable = this.getSpecificVariable(variableName);
            if (variable != null) {
                this.updateVariableInstance(variable, value, sourceExecution);
                this.usedVariablesCache.put(variableName, variable);
            } else {
                VariableScopeImpl parent = this.getParentVariableScope();
                if (parent != null) {
                    if (sourceExecution == null) {
                        parent.setVariable(variableName, value, fetchAllVariables);
                    } else {
                        parent.setVariable(variableName, value, sourceExecution, fetchAllVariables);
                    }
                    return;
                }
                variable = this.createVariableInstance(variableName, value, sourceExecution);
                this.usedVariablesCache.put(variableName, variable);
            }
        }
    }

    @Override
    public Object setVariableLocal(String variableName, Object value) {
        return this.setVariableLocal(variableName, value, this.getSourceActivityExecution(), true);
    }

    @Override
    public Object setVariableLocal(String variableName, Object value, boolean fetchAllVariables) {
        return this.setVariableLocal(variableName, value, this.getSourceActivityExecution(), fetchAllVariables);
    }

    public Object setVariableLocal(String variableName, Object value, ExecutionEntity sourceActivityExecution, boolean fetchAllVariables) {
        if (fetchAllVariables) {
            if (this.usedVariablesCache.containsKey(variableName)) {
                this.updateVariableInstance(this.usedVariablesCache.get(variableName), value, sourceActivityExecution);
            }
            this.ensureVariableInstancesInitialized();
            VariableInstanceEntity variableInstance = this.variableInstances.get(variableName);
            if (variableInstance == null) {
                variableInstance = this.usedVariablesCache.get(variableName);
            }
            if (variableInstance == null) {
                this.createVariableLocal(variableName, value);
            } else {
                this.updateVariableInstance(variableInstance, value, sourceActivityExecution);
            }
            return null;
        }
        if (this.usedVariablesCache.containsKey(variableName)) {
            this.updateVariableInstance(this.usedVariablesCache.get(variableName), value, sourceActivityExecution);
        } else if (this.variableInstances != null && this.variableInstances.containsKey(variableName)) {
            this.updateVariableInstance(this.variableInstances.get(variableName), value, sourceActivityExecution);
        } else {
            VariableInstanceEntity variable = this.getSpecificVariable(variableName);
            if (variable != null) {
                this.updateVariableInstance(variable, value, sourceActivityExecution);
            } else {
                variable = this.createVariableInstance(variableName, value, sourceActivityExecution);
            }
            this.usedVariablesCache.put(variableName, variable);
        }
        return null;
    }

    public void createVariableLocal(String variableName, Object value) {
        this.createVariableLocal(variableName, value, this.getSourceActivityExecution());
    }

    protected void createVariableLocal(String variableName, Object value, ExecutionEntity sourceActivityExecution) {
        this.ensureVariableInstancesInitialized();
        if (this.variableInstances.containsKey(variableName)) {
            throw new WFEngineException("variable '" + variableName + "' already exists. Use setVariableLocal if you want to overwrite the value");
        }
        this.createVariableInstance(variableName, value, sourceActivityExecution);
    }

    @Override
    public void removeVariable(String variableName) {
        this.removeVariable(variableName, this.getSourceActivityExecution());
    }

    protected void removeVariable(String variableName, ExecutionEntity sourceActivityExecution) {
        this.ensureVariableInstancesInitialized();
        if (this.variableInstances.containsKey(variableName)) {
            this.removeVariableLocal(variableName);
            return;
        }
        VariableScopeImpl parentVariableScope = this.getParentVariableScope();
        if (parentVariableScope != null) {
            if (sourceActivityExecution == null) {
                parentVariableScope.removeVariable(variableName);
            } else {
                parentVariableScope.removeVariable(variableName, sourceActivityExecution);
            }
        }
    }

    @Override
    public void removeVariableLocal(String variableName) {
        this.removeVariableLocal(variableName, this.getSourceActivityExecution());
    }

    @Override
    public void removeVariableLocalIgnoreCase(String variableName) {
        if (this.hasVariableLocal(variableName)) {
            this.removeVariableLocal(variableName, this.getSourceActivityExecution());
        } else if (this.hasVariableLocal(variableName.toLowerCase())) {
            this.removeVariableLocal(variableName.toLowerCase(), this.getSourceActivityExecution());
        }
    }

    protected ExecutionEntity getSourceActivityExecution() {
        return null;
    }

    protected void removeVariableLocal(String variableName, ExecutionEntity sourceActivityExecution) {
        this.ensureVariableInstancesInitialized();
        VariableInstanceEntity variableInstance = this.variableInstances.remove(variableName);
        if (variableInstance != null) {
            this.deleteVariableInstanceForExplicitUserCall(variableInstance, sourceActivityExecution);
        }
    }

    protected void deleteVariableInstanceForExplicitUserCall(VariableInstanceEntity variableInstance, ExecutionEntity sourceActivityExecution) {
        Context.getCommandContext().getVariableInstanceEntityManager().delete(variableInstance);
        variableInstance.setValue(null);
        Context.getCommandContext().getHistoryManager().recordVariableRemoved(variableInstance);
    }

    protected void updateVariableInstance(VariableInstanceEntity variableInstance, Object value, ExecutionEntity sourceActivityExecution) {
        if (variableInstance != null) {
            VariableTypes variableTypes = Context.getProcessEngineConfiguration().getVariableTypes();
            VariableType newType = variableTypes.findVariableType(value);
            if (!variableInstance.getType().equals(newType)) {
                variableInstance.setValue(null);
                variableInstance.setType(newType);
                variableInstance.forceUpdate();
                variableInstance.setValue(value);
            } else {
                variableInstance.setValue(value);
            }
            Context.getCommandContext().getHistoryManager().recordVariableUpdate(variableInstance);
            Context.getCommandContext().getVariableInstanceEntityManager().update(variableInstance);
        }
    }

    protected VariableInstanceEntity createVariableInstance(String variableName, Object value, ExecutionEntity sourceActivityExecution) {
        VariableTypes variableTypes = Context.getProcessEngineConfiguration().getVariableTypes();
        VariableType type = variableTypes.findVariableType(value);
        VariableInstanceEntity variableInstance = Context.getCommandContext().getVariableInstanceEntityManager().create(variableName, type, value);
        this.initializeVariableInstanceBackPointer(variableInstance);
        Context.getCommandContext().getVariableInstanceEntityManager().insert(variableInstance);
        if (this.variableInstances != null) {
            this.variableInstances.put(variableName, variableInstance);
        }
        Context.getCommandContext().getHistoryManager().recordVariableCreate(variableInstance);
        return variableInstance;
    }

    @Override
    public void setTransientVariablesLocal(Map<String, Object> transientVariables) {
        for (Map.Entry<String, Object> entry : transientVariables.entrySet()) {
            this.setTransientVariableLocal(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void setTransientVariableLocal(String variableName, Object variableValue) {
        if (this.transientVariabes == null) {
            this.transientVariabes = new HashMap<String, VariableInstance>();
        }
        this.transientVariabes.put(variableName, new TransientVariableInstance(variableName, variableValue));
    }

    @Override
    public void setTransientVariables(Map<String, Object> transientVariables) {
        for (Map.Entry<String, Object> entry : transientVariables.entrySet()) {
            this.setTransientVariable(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void setTransientVariable(String variableName, Object variableValue) {
        VariableScopeImpl parentVariableScope = this.getParentVariableScope();
        if (parentVariableScope != null) {
            parentVariableScope.setTransientVariable(variableName, variableValue);
            return;
        }
        this.setTransientVariableLocal(variableName, variableValue);
    }

    @Override
    public Object getTransientVariableLocal(String variableName) {
        if (this.transientVariabes != null && this.transientVariabes.get(variableName) != null) {
            return this.transientVariabes.get(variableName).getValue();
        }
        return null;
    }

    @Override
    public Map<String, Object> getTransientVariablesLocal() {
        if (this.transientVariabes != null) {
            HashMap<String, Object> variables = new HashMap<String, Object>(this.transientVariabes.size());
            for (Map.Entry<String, VariableInstance> entry : this.transientVariabes.entrySet()) {
                variables.put(entry.getKey(), entry.getValue().getValue());
            }
            return variables;
        }
        return Collections.emptyMap();
    }

    @Override
    public Object getTransientVariable(String variableName) {
        if (this.transientVariabes != null && this.transientVariabes.containsKey(variableName)) {
            return this.transientVariabes.get(variableName).getValue();
        }
        VariableScopeImpl parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            return parentScope.getTransientVariable(variableName);
        }
        return null;
    }

    @Override
    public Map<String, Object> getTransientVariables() {
        return this.collectTransientVariables(new HashMap<String, Object>());
    }

    protected Map<String, Object> collectTransientVariables(HashMap<String, Object> variables) {
        VariableScopeImpl parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            variables.putAll(parentScope.collectVariables(variables));
        }
        if (this.transientVariabes != null) {
            for (Map.Entry<String, VariableInstance> entry : this.transientVariabes.entrySet()) {
                variables.put(entry.getKey(), entry.getValue().getValue());
            }
        }
        return variables;
    }

    @Override
    public void removeTransientVariableLocal(String variableName) {
        if (this.transientVariabes != null) {
            this.transientVariabes.remove(variableName);
        }
    }

    @Override
    public void removeTransientVariablesLocal() {
        if (this.transientVariabes != null) {
            this.transientVariabes.clear();
        }
    }

    @Override
    public void removeTransientVariable(String variableName) {
        if (this.transientVariabes != null && this.transientVariabes.containsKey(variableName)) {
            this.removeTransientVariableLocal(variableName);
            return;
        }
        VariableScopeImpl parentVariableScope = this.getParentVariableScope();
        if (parentVariableScope != null) {
            parentVariableScope.removeTransientVariable(variableName);
        }
    }

    @Override
    public void removeTransientVariables() {
        this.removeTransientVariablesLocal();
        VariableScopeImpl parentVariableScope = this.getParentVariableScope();
        if (parentVariableScope != null) {
            parentVariableScope.removeTransientVariablesLocal();
        }
    }

    protected boolean isActivityIdUsedForDetails() {
        return true;
    }

    public ELContext getCachedElContext() {
        return this.cachedElContext;
    }

    public void setCachedElContext(ELContext cachedElContext) {
        this.cachedElContext = cachedElContext;
    }

    @Override
    public <T> T getVariable(String variableName, Class<T> variableClass) {
        return variableClass.cast(this.getVariable(variableName));
    }

    @Override
    public <T> T getVariableLocal(String variableName, Class<T> variableClass) {
        return variableClass.cast(this.getVariableLocal(variableName));
    }
}

