/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.system;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.system.AdministratorEntity;
import kd.bos.workflow.engine.impl.persistence.entity.system.AdministratorEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.system.AdministratorEntityManager;

public class AdministratorEntityManagerImpl
extends AbstractEntityManager<AdministratorEntity>
implements AdministratorEntityManager {
    private static Log logger = LogFactory.getLog(AdministratorEntityManagerImpl.class);

    public AdministratorEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public Class<? extends AdministratorEntity> getManagedEntityClass() {
        return AdministratorEntityImpl.class;
    }

    @Override
    public String getEntityName() {
        return "wf_administrator";
    }

    @Override
    public String getSelectFields() {
        return "id, userid, type, busappid, busprocessid, status, createdate, modifydate, orgentry.orgid, orgentry.includesuborg, orgentry.orgtype";
    }

    @Override
    public Set<Long> findAdminsByProcessDefinitionId(Long id) {
        HashSet<Long> userIds = new HashSet<Long>();
        ProcessDefinitionEntity processDefinitionEntity = (ProcessDefinitionEntity)this.processEngineConfiguration.getProcessDefinitionEntityManager().findById(id);
        if (processDefinitionEntity != null) {
            Long orgId = processDefinitionEntity.getOrgUnitId();
            if (WfUtils.isEmpty(orgId)) {
                return userIds;
            }
            List<Long> orgUserIds = this.findAdminsByOrgId(orgId, false);
            userIds.addAll(orgUserIds);
            int level = 0;
            this.addRelateAdminsWithoutGlobal(userIds, orgId, level);
        }
        if (userIds.isEmpty()) {
            List<Long> globalUserIds = this.findAdminsByOrgId(0L, false);
            userIds.addAll(globalUserIds);
        }
        return userIds;
    }

    private void addRelateAdminsWithoutGlobal(Set<Long> userIds, Long orgId, int level) {
        ++level;
        List<Long> orgUserIds = this.findAdminsByOrgId(orgId, true);
        userIds.addAll(orgUserIds);
        List superiorOrgIds = OrgServiceHelper.getSuperiorOrgs((long)orgId);
        if (superiorOrgIds != null && !superiorOrgIds.isEmpty()) {
            for (Long superiorOrgId : superiorOrgIds) {
                if (superiorOrgId == 0L) continue;
                if (level >= 10) {
                    logger.warn(String.format("%s: %s %s", "\u67e5\u627e\u76f8\u5173\u7ba1\u7406\u5458\u9012\u5f52\u81f3\u6700\u5927\u5141\u8bb8\u7ea7\u6570", level, "\u9000\u51fa"));
                    return;
                }
                this.addRelateAdminsWithoutGlobal(userIds, superiorOrgId, level);
            }
        }
    }

    private List<Long> findAdminsByOrgId(Long orgId, boolean isSuperOrg) {
        ArrayList<Long> userIds = new ArrayList<Long>();
        EntityQueryBuilder queryBuilder = this.createQueryBuilder();
        if (WfUtils.isNotEmpty(orgId)) {
            queryBuilder.addFilter("orgentry.orgid", "=", orgId);
        }
        queryBuilder.addFilter("status", "=", Character.valueOf('1'));
        List administratorEntities = this.findByQueryBuilder(queryBuilder);
        if (administratorEntities == null || administratorEntities.isEmpty()) {
            return userIds;
        }
        for (AdministratorEntity administratorEntity : administratorEntities) {
            DynamicObjectCollection entries = administratorEntity.getOrgEntry();
            if (entries == null || entries.isEmpty()) {
                userIds.add(administratorEntity.getUserId());
                continue;
            }
            if (!WfUtils.isNotEmpty(orgId)) continue;
            for (DynamicObject entry : entries) {
                if (!orgId.equals(((DynamicObject)entry.get("orgid")).get("id")) || isSuperOrg && !entry.getBoolean("includesuborg")) continue;
                userIds.add(administratorEntity.getUserId());
            }
        }
        return userIds;
    }
}

