/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.engine.task.AttributeModifyRecord;

@KSObject
public class CommentEntityImpl
extends AbstractEntity
implements CommentEntity,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String TERMINALWAY = "terminalway";
    public static final String TYPE_MESSAGE = "message";
    public static final String TYPE_SUGGESTION = "suggestion";
    public static final String TYPE_COORDINATE = "coordinate";
    public static final String TYPE_CONVERTED = "converted";
    public static final String TYPE_COMMENT = "comment";
    public static final String TYPE_FORCECOMMENT = "forceReject";
    public static final String TYPE_EVENT = "event";
    public static final String STEP = "step";
    public static final String COORDINVITEOPINION = "coordinviteopinion";
    public static final String USERNAMEFORMATTER = "usernameformatter";
    public static final String ISPUBLIC = "ispublic";
    public static final String BIZIDENTIFYKEY = "bizIdentifyKey";
    public static final String OWNERID = "ownerId";
    public static final String BUSINESSKEY = "businessKey";
    public static final String ENTITYNUMBER = "entityNumber";
    public static final String SUBACTIVITYNAME = "subactivityname";
    public static final String ACTIVITYNAME = "activityName";
    public static final String BACKTOBACK = "backToBack";
    public static final String GROUPID = "groupId";
    public static final String ASSIGNEE = "assignee";
    public static final String DECISIONTYPE = "decisionType";
    public static final String RESULTNUMBER = "resultNumber";
    public static final String RESULTNAME = "resultName";
    public static final String MESSAGE = "message";
    public static final String RICHTEXTMESSAGE = "richTextMessage";
    public static final String TIME = "time";
    public static final String ACTIVITYID = "activityId";
    public static final String SUBPROCESSINSTANCEID = "subProcessInstanceId";
    public static final String PROCESSINSTANCEID = "processInstanceId";
    public static final String TASKID = "taskId";
    public static final String USERID = "userId";
    public static final String ASSIGNORNAME = "assignorname";
    public static final String CURRENTSUBJECT = "currentsubject";
    public static final String BILLNO = "billno";
    public static final String ENTITYNAME = "entityname";
    public static final String SENDERNAMEFORMAT = "sendernameformat";
    public static final String STARTERID = "starterid";
    public static final String PRESENTASSIGNEE = "presentassignee";
    public static final String PROCESSINGPAGE = "processingpage";
    public static final String PROCESSINGMOBILEPAGE = "processingmobilepage";
    public static final String HANDLESTATE = "handlestate";
    public static final String CATEGORY = "category";
    public static final String SENDERNAME = "sendername";
    public static final String DURATIONINMILLIS = "durationinmillis";
    public static final String CREATEDATE = "createdate";
    public static final String EXECUTIONTYPE = "executiontype";
    public static final String DISPLAY = "display";
    public static final String ENDTYPE = "endtype";
    public static final String BILLTYPE = "billtype";
    public static final String TRUSTNAMEFORMAT = "trustnameformat";
    public static final String DELEGATEID = "delegateid";
    public static final String STARTNAMEFORMAT = "startnameformat";
    public static final String STARTNAME = "startname";
    public static final String TYPE = "type";
    public static final String SENSITIVEFIELDCHANGE = "sensitivefieldchange";
    public static final String BUSINESS_DATE = "biz_date";
    public static final String BUSINESS_NUMBER = "biz_number";
    public static final String BUSINESS_FORMAT = "bizformat";
    public static final String BUSINESS_STR1 = "biz_str1";
    public static final String BUSINESS_STR2 = "biz_str2";
    public static final String BUSINESS_STR3 = "biz_str3";
    public static final String BUSINESS_STR4 = "biz_str4";
    public static final String BUSINESS_STR5 = "biz_str5";
    public static final String BUSINESS_DATE2 = "biz_date2";
    public static final String BUSINESS_NUMBER2 = "biz_number2";
    public static final String BUSINESS_MULSTR1 = "biz_strmul1";
    public static final String BUSINESS_MULSTR2 = "biz_strmul2";
    public static final String PROCESSTYPE = "processtype";
    public static final String SIGNATURE = "signature";
    public static final String MESSAGE_PARTS_MARKER = "_|_";
    public static final Pattern MESSAGE_PARTS_MARKER_REGEX = Pattern.compile("_\\|_");
    public String avatar;
    Map<String, AttributeModifyRecord> attributeModifyRecords = new HashMap<String, AttributeModifyRecord>();

    public CommentEntityImpl() {
    }

    public CommentEntityImpl(DynamicObject dynamicObject) {
        super(dynamicObject);
    }

    @Override
    public Object getPersistentState() {
        return CommentEntityImpl.class;
    }

    @Override
    public void setMessage(String[] messageParts) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String part : messageParts) {
            if (part != null) {
                stringBuilder.append(part.replace(MESSAGE_PARTS_MARKER, " | "));
                stringBuilder.append(MESSAGE_PARTS_MARKER);
                continue;
            }
            stringBuilder.append("null");
            stringBuilder.append(MESSAGE_PARTS_MARKER);
        }
        for (int i = 0; i < MESSAGE_PARTS_MARKER.length(); ++i) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        this.setMessage(WfUtils.getMultiLangValue(stringBuilder.toString()));
    }

    public List<String> getMessageParts() {
        ArrayList<String> messageParts = new ArrayList<String>();
        if (this.getMessage() != null) {
            String[] parts;
            for (String part : parts = MESSAGE_PARTS_MARKER_REGEX.split(this.getMessage())) {
                if ("null".equals(part)) {
                    messageParts.add(null);
                    continue;
                }
                messageParts.add(part);
            }
        }
        return messageParts;
    }

    public String getAvatar() {
        return this.avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    @KSMethod
    @SimplePropertyAttribute(name="userId")
    public Long getUserId() {
        return this.normalizeId(this.dynamicObject.getLong(USERID));
    }

    public void setUserId(Long userId) {
        this.gatherAttributeModifyRecord(USERID, userId);
        this.dynamicObject.set(USERID, (Object)userId);
    }

    @KSMethod
    @SimplePropertyAttribute(name="taskId")
    public Long getTaskId() {
        return this.normalizeId(this.dynamicObject.getLong(TASKID));
    }

    public void setTaskId(Long taskId) {
        this.dynamicObject.set(TASKID, (Object)taskId);
    }

    @KSMethod
    public String getMessage() {
        return this.dynamicObject.getString("message");
    }

    @SimplePropertyAttribute(name="message")
    public ILocaleString getCommentMessage() {
        return this.dynamicObject.getLocaleString("message");
    }

    @Deprecated
    public void setMessage(String message) {
        this.dynamicObject.set("message", (Object)message);
    }

    public void setMessage(ILocaleString message) {
        this.dynamicObject.set("message", (Object)WfUtils.subILocaleString(message, 2000));
    }

    @Override
    public void setCoordInviteOpinion(ILocaleString coordInviteOpinion) {
        this.dynamicObject.set(COORDINVITEOPINION, (Object)coordInviteOpinion);
    }

    @Override
    @SimplePropertyAttribute(name="coordinviteopinion")
    public ILocaleString getCoordInviteOpinion() {
        return this.dynamicObject.getLocaleString(COORDINVITEOPINION);
    }

    @KSMethod
    @SimplePropertyAttribute(name="time")
    public Date getTime() {
        return this.dynamicObject.getDate(TIME);
    }

    public void setTime(Date time) {
        this.dynamicObject.set(TIME, (Object)time);
    }

    @KSMethod
    @SimplePropertyAttribute(name="processInstanceId")
    public Long getProcessInstanceId() {
        return this.normalizeId(this.dynamicObject.getLong(PROCESSINSTANCEID));
    }

    @Override
    public void setProcessInstanceId(Long processInstanceId) {
        this.dynamicObject.set(PROCESSINSTANCEID, (Object)processInstanceId);
    }

    @Override
    public void setSubProcessInstanceId(Long subProcessInstanceId) {
        this.dynamicObject.set(SUBPROCESSINSTANCEID, (Object)subProcessInstanceId);
    }

    @Override
    @SimplePropertyAttribute(name="subProcessInstanceId")
    public Long getSubProcessInstanceId() {
        return this.normalizeId(this.dynamicObject.getLong(SUBPROCESSINSTANCEID));
    }

    @KSMethod
    @SimplePropertyAttribute(name="type")
    public String getType() {
        return this.dynamicObject.getString(TYPE);
    }

    @Override
    public void setType(String type) {
        this.gatherAttributeModifyRecord(TYPE, type);
        this.dynamicObject.set(TYPE, (Object)type);
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute(name="activityId")
    public String getActivityId() {
        return this.dynamicObject.getString(ACTIVITYID);
    }

    @Override
    public void setActivityId(String activityId) {
        this.dynamicObject.set(ACTIVITYID, (Object)activityId);
    }

    @KSMethod
    public String getResultName() {
        return this.dynamicObject.getString(RESULTNAME);
    }

    @SimplePropertyAttribute(name="resultName")
    public ILocaleString getCommentResult() {
        return this.dynamicObject.getLocaleString(RESULTNAME);
    }

    public void setResultName(ILocaleString resultName) {
        this.dynamicObject.set(RESULTNAME, (Object)resultName);
    }

    @Deprecated
    public void setResultName(String resultName) {
        this.dynamicObject.set(RESULTNAME, (Object)resultName);
    }

    @KSMethod
    @SimplePropertyAttribute(name="resultNumber")
    public String getResultNumber() {
        return this.dynamicObject.getString(RESULTNUMBER);
    }

    public void setResultNumber(String resultNumber) {
        this.dynamicObject.set(RESULTNUMBER, (Object)resultNumber);
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute(name="decisionType")
    public String getDecisionType() {
        return this.dynamicObject.getString(DECISIONTYPE);
    }

    public void setDecisionType(String decisionType) {
        this.dynamicObject.set(DECISIONTYPE, (Object)decisionType);
    }

    @KSMethod
    @SimplePropertyAttribute(name="assignee")
    public ILocaleString getTaskAssignee() {
        return this.dynamicObject.getLocaleString(ASSIGNEE);
    }

    public String getAssignee() {
        return this.dynamicObject.getString(ASSIGNEE);
    }

    public void setAssignee(ILocaleString assignee) {
        assignee = WfUtils.substringLocaleStr(assignee, 490, "");
        this.dynamicObject.set(ASSIGNEE, (Object)assignee);
    }

    public void setAssignee(String assignee) {
        assignee = WfUtils.substring(assignee, 490, "");
        this.dynamicObject.set(ASSIGNEE, (Object)assignee);
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute(name="groupId")
    public String getGroupId() {
        return this.dynamicObject.getString(GROUPID);
    }

    @Override
    public void setGroupId(String groupId) {
        this.dynamicObject.set(GROUPID, (Object)groupId);
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute(name="backToBack")
    public Boolean getBackToBack() {
        return this.dynamicObject.getBoolean(BACKTOBACK);
    }

    @Override
    public void setBackToBack(Boolean backToBack) {
        this.dynamicObject.set(BACKTOBACK, (Object)backToBack);
    }

    public void setActivityName(String activityName) {
        this.dynamicObject.set(ACTIVITYNAME, (Object)activityName);
    }

    public void setActivityName(ILocaleString activityName) {
        this.dynamicObject.set(ACTIVITYNAME, (Object)activityName);
    }

    @KSMethod
    public String getActivityName() {
        return this.dynamicObject.getString(ACTIVITYNAME);
    }

    @SimplePropertyAttribute(name="activityName")
    public ILocaleString getNodeName() {
        return this.dynamicObject.getLocaleString(ACTIVITYNAME);
    }

    public void setSubactivityname(String subactivityname) {
        this.dynamicObject.set(SUBACTIVITYNAME, (Object)subactivityname);
    }

    @KSMethod
    @SimplePropertyAttribute(name="subactivityname")
    public String getSubactivityname() {
        return this.dynamicObject.getString(SUBACTIVITYNAME);
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute(name="entityNumber")
    public String getEntityNumber() {
        return this.dynamicObject.getString(ENTITYNUMBER);
    }

    @Override
    public void setEntityNumber(String entityNumber) {
        this.dynamicObject.set(ENTITYNUMBER, (Object)entityNumber);
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute(name="businessKey")
    public String getBusinessKey() {
        return this.dynamicObject.getString(BUSINESSKEY);
    }

    @Override
    public void setBusinessKey(String businessKey) {
        this.dynamicObject.set(BUSINESSKEY, (Object)businessKey);
    }

    @Override
    public String getDynObjTypeName() {
        return "wf_hicomment";
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute(name="ownerId")
    public Long getOwnerId() {
        return this.normalizeId(this.dynamicObject.getLong(OWNERID));
    }

    @Override
    public void setOwnerId(Long ownerId) {
        this.dynamicObject.set(OWNERID, (Object)ownerId);
    }

    @Override
    @SimplePropertyAttribute(name="bizIdentifyKey")
    public String getBizIdentifyKey() {
        return this.dynamicObject.getString(BIZIDENTIFYKEY);
    }

    @Override
    public void setBizIdentifyKey(String bizIdentifyKey) {
        this.dynamicObject.set(BIZIDENTIFYKEY, (Object)bizIdentifyKey);
    }

    @Override
    @SimplePropertyAttribute(name="ispublic")
    @KSMethod
    public Boolean getIsPublic() {
        return this.dynamicObject.getBoolean(ISPUBLIC);
    }

    @Override
    public void setIsPublic(Boolean ispublic) {
        this.dynamicObject.set(ISPUBLIC, (Object)ispublic);
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute(name="step")
    public int getStep() {
        return this.dynamicObject.getInt(STEP);
    }

    @Override
    public void setStep(int step) {
        this.dynamicObject.set(STEP, (Object)step);
    }

    @Override
    public void setUserNameFormatter(ILocaleString userNameFormatter) {
        this.dynamicObject.set(USERNAMEFORMATTER, (Object)WfUtils.subILocaleString(userNameFormatter, 500));
    }

    @Override
    public ILocaleString getUserNameFormatter() {
        ILocaleString userNameFormat = this.dynamicObject.getLocaleString(USERNAMEFORMATTER);
        if (WfUtils.isEmpty(userNameFormat)) {
            userNameFormat = this.getTaskAssignee();
        }
        return userNameFormat;
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute(name="terminalway")
    public String getTerminalWay() {
        return this.dynamicObject.getString(TERMINALWAY);
    }

    @Override
    public void setTerminalWay(String terminalWay) {
        this.dynamicObject.set(TERMINALWAY, (Object)terminalWay);
    }

    @Override
    @SimplePropertyAttribute(name="assignorname")
    public ILocaleString getAssignorName() {
        return this.dynamicObject.getLocaleString(ASSIGNORNAME);
    }

    @Override
    public void setAssignorName(ILocaleString assignorName) {
        this.dynamicObject.set(ASSIGNORNAME, (Object)assignorName);
    }

    @Override
    public void setRichTextMessage(String richTextMessage) {
        this.dynamicObject.set(RICHTEXTMESSAGE, (Object)richTextMessage);
    }

    @Override
    public String getRichTextMessage() {
        return this.dynamicObject.getString(RICHTEXTMESSAGE);
    }

    @Override
    @SimplePropertyAttribute(name="currentsubject")
    public ILocaleString getCurrentSubject() {
        return this.dynamicObject.getLocaleString(CURRENTSUBJECT);
    }

    @Override
    public void setCurrentSubject(ILocaleString currentSubject) {
        this.dynamicObject.set(CURRENTSUBJECT, (Object)WfUtils.subILocaleString(currentSubject, 2990));
    }

    @Override
    public void setSensitivefieldchange(ILocaleString assignorName) {
        this.dynamicObject.set(SENSITIVEFIELDCHANGE, (Object)assignorName);
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute(name="sensitivefieldchange")
    public ILocaleString getSensitivefieldchange() {
        return this.dynamicObject.getLocaleString(SENSITIVEFIELDCHANGE);
    }

    @Override
    public ILocaleString getPresentAssignee() {
        return this.dynamicObject.getLocaleString(PRESENTASSIGNEE);
    }

    @Override
    public void setPresentAssignee(ILocaleString presentAssignee) {
        this.dynamicObject.set(PRESENTASSIGNEE, (Object)WfUtils.subILocaleString(presentAssignee, 990));
    }

    @Override
    public String getBillNo() {
        return this.dynamicObject.getString(BILLNO);
    }

    @Override
    public void setBillNo(String billNo) {
        this.dynamicObject.set(BILLNO, (Object)billNo);
    }

    @Override
    public ILocaleString getEntityName() {
        return this.dynamicObject.getLocaleString(ENTITYNAME);
    }

    @Override
    public void setEntityName(ILocaleString entityName) {
        this.dynamicObject.set(ENTITYNAME, (Object)entityName);
    }

    @Override
    public ILocaleString getSenderNameFormat() {
        return this.dynamicObject.getLocaleString(SENDERNAMEFORMAT);
    }

    @Override
    public void setSenderNameFormat(ILocaleString senderNameFormat) {
        this.dynamicObject.set(SENDERNAMEFORMAT, (Object)WfUtils.subILocaleString(senderNameFormat, 249));
    }

    @Override
    public Long getStarterId() {
        return this.dynamicObject.getLong(STARTERID);
    }

    @Override
    public void setStarterId(Long starterId) {
        this.dynamicObject.set(STARTERID, (Object)starterId);
    }

    @Override
    public String getProcessingPage() {
        return this.dynamicObject.getString(PROCESSINGPAGE);
    }

    @Override
    public void setProcessingPage(String processingPage) {
        this.dynamicObject.set(PROCESSINGPAGE, (Object)processingPage);
    }

    @Override
    public String getProcessingMobilePage() {
        return this.dynamicObject.getString(PROCESSINGMOBILEPAGE);
    }

    @Override
    public void setProcessingMobilePage(String processingMobilePage) {
        this.dynamicObject.set(PROCESSINGMOBILEPAGE, (Object)processingMobilePage);
    }

    @Override
    public String getHandleState() {
        return this.dynamicObject.getString(HANDLESTATE);
    }

    @Override
    public void setHandleState(String handleState) {
        this.dynamicObject.set(HANDLESTATE, (Object)handleState);
    }

    @Override
    public String getCategory() {
        return this.dynamicObject.getString(CATEGORY);
    }

    @Override
    public void setCategory(String category) {
        this.dynamicObject.set(CATEGORY, (Object)category);
    }

    @Override
    public ILocaleString getSenderName() {
        return this.dynamicObject.getLocaleString(SENDERNAME);
    }

    @Override
    public void setSenderName(ILocaleString senderName) {
        this.dynamicObject.set(SENDERNAME, (Object)senderName);
    }

    @Override
    public String getExecutionType() {
        return this.dynamicObject.getString(EXECUTIONTYPE);
    }

    @Override
    public void setExecutionType(String executionType) {
        this.dynamicObject.set(EXECUTIONTYPE, (Object)executionType);
    }

    @Override
    public boolean isDisplay() {
        return this.dynamicObject.getBoolean(DISPLAY);
    }

    @Override
    public void setDisplay(boolean isDisplay) {
        this.dynamicObject.set(DISPLAY, (Object)isDisplay);
    }

    @Override
    public String getEndType() {
        return this.dynamicObject.getString(ENDTYPE);
    }

    @Override
    public void setEndType(String endType) {
        this.dynamicObject.set(ENDTYPE, (Object)endType);
    }

    @Override
    public String getBillType() {
        return this.dynamicObject.getString(BILLTYPE);
    }

    @Override
    public void setBillType(String billType) {
        this.dynamicObject.set(BILLTYPE, (Object)billType);
    }

    @Override
    public ILocaleString getStartNameFormat() {
        return this.dynamicObject.getLocaleString(STARTNAMEFORMAT);
    }

    @Override
    public void setStartNameFormat(ILocaleString startNameFormat) {
        this.dynamicObject.set(STARTNAMEFORMAT, (Object)WfUtils.subILocaleString(startNameFormat, 249));
    }

    @Override
    public Long getDelegateId() {
        return this.dynamicObject.getLong(DELEGATEID);
    }

    @Override
    public void setDelegateId(Long delegateId) {
        this.dynamicObject.set(DELEGATEID, (Object)delegateId);
    }

    @Override
    public ILocaleString getStartName() {
        return this.dynamicObject.getLocaleString(STARTNAME);
    }

    @Override
    public void setStartName(ILocaleString startName) {
        this.dynamicObject.set(STARTNAME, (Object)startName);
    }

    @Override
    @SimplePropertyAttribute(name="biz_date")
    public Date getBusinessDate() {
        return this.dynamicObject.getDate(BUSINESS_DATE);
    }

    @Override
    public void setBusinessDate(Date businessDate) {
        this.dynamicObject.set(BUSINESS_DATE, (Object)businessDate);
    }

    @Override
    @SimplePropertyAttribute(name="biz_number")
    public double getBusinessNumber() {
        return this.dynamicObject.getBigDecimal(BUSINESS_NUMBER).doubleValue();
    }

    @Override
    public void setBusinessNumber(double businessNumber) {
        this.dynamicObject.set(BUSINESS_NUMBER, (Object)businessNumber);
    }

    @Override
    @SimplePropertyAttribute(name="bizformat")
    public String getBusinessFormat() {
        return this.dynamicObject.getString(BUSINESS_FORMAT);
    }

    @Override
    public void setBusinessFormat(String businessFormat) {
        this.dynamicObject.set(BUSINESS_FORMAT, (Object)businessFormat);
    }

    @Override
    @SimplePropertyAttribute(name="biz_str1")
    public String getBusinessStr1() {
        return this.dynamicObject.getString(BUSINESS_STR1);
    }

    @Override
    public void setBusinessStr1(String businessStr1) {
        this.dynamicObject.set(BUSINESS_STR1, (Object)businessStr1);
    }

    @Override
    @SimplePropertyAttribute(name="biz_str2")
    public String getBusinessStr2() {
        return this.dynamicObject.getString(BUSINESS_STR2);
    }

    @Override
    public void setBusinessStr2(String businessStr2) {
        this.dynamicObject.set(BUSINESS_STR2, (Object)businessStr2);
    }

    @Override
    public Map<String, AttributeModifyRecord> getAttributesModifyRecords() {
        return this.attributeModifyRecords;
    }

    @Override
    public void clearAttributesModifyRecords() {
        this.attributeModifyRecords = new HashMap<String, AttributeModifyRecord>();
    }

    private void gatherAttributeModifyRecord(String attribute, Object newValue) {
        this.gatherAttributeModifyRecord(this.dynamicObject, attribute, newValue);
    }

    @Override
    @SimplePropertyAttribute(name="biz_date2")
    public Date getBusinessDate2() {
        return this.dynamicObject.getDate(BUSINESS_DATE2);
    }

    @Override
    public void setBusinessDate2(Date businessDate) {
        this.dynamicObject.set(BUSINESS_DATE2, (Object)businessDate);
    }

    @Override
    @SimplePropertyAttribute(name="biz_number2")
    public double getBusinessNumber2() {
        return this.dynamicObject.getBigDecimal(BUSINESS_NUMBER2).doubleValue();
    }

    @Override
    public void setBusinessNumber2(double businessNumber) {
        this.dynamicObject.set(BUSINESS_NUMBER2, (Object)businessNumber);
    }

    @Override
    @SimplePropertyAttribute(name="biz_strmul1")
    public ILocaleString getBusinessMulStr1() {
        return this.dynamicObject.getLocaleString(BUSINESS_MULSTR1);
    }

    @Override
    public void setBusinessMulStr1(ILocaleString businessStr) {
        this.dynamicObject.set(BUSINESS_MULSTR1, (Object)businessStr);
    }

    @Override
    @SimplePropertyAttribute(name="biz_strmul2")
    public ILocaleString getBusinessMulStr2() {
        return this.dynamicObject.getLocaleString(BUSINESS_MULSTR2);
    }

    @Override
    public void setBusinessMulStr2(ILocaleString businessStr) {
        this.dynamicObject.set(BUSINESS_MULSTR2, (Object)businessStr);
    }

    @Override
    @SimplePropertyAttribute(name="processtype")
    public String getProcessType() {
        return this.dynamicObject.getString(PROCESSTYPE);
    }

    @Override
    public void setProcessType(String processType) {
        this.dynamicObject.set(PROCESSTYPE, (Object)processType);
    }

    @Override
    public void setSource(String source) {
        this.dynamicObject.set("source", (Object)source);
    }

    @Override
    @SimplePropertyAttribute(name="source")
    public String getSource() {
        return this.dynamicObject.getString("source");
    }

    @Override
    public void setSourceName(ILocaleString sourceName) {
        this.dynamicObject.set("sourcename", (Object)sourceName);
    }

    @Override
    @SimplePropertyAttribute(name="sourcename")
    public ILocaleString getSourceName() {
        return this.dynamicObject.getLocaleString("sourcename");
    }

    @Override
    @SimplePropertyAttribute(name="signature")
    public String getSignature() {
        return this.dynamicObject.getString(SIGNATURE);
    }

    @Override
    public void setSignature(String signature) {
        this.dynamicObject.set(SIGNATURE, (Object)signature);
    }
}

