/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.event.ActivitiEventDispatcher;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.extitf.ExtItfCallerType;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.CachedEntityMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.CommentsByProcInstIdAndActivityIdMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.CommentsByTaskIdMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.task.AttributeModifyRecord;
import kd.bos.workflow.engine.task.Comment;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.feature.taskfield.util.TaskExtendFieldUtil;

public class CommentEntityManagerImpl
extends AbstractEntityManager<CommentEntity>
implements CommentEntityManager {
    public static final int STARTSTEP = 9;
    protected CachedEntityMatcher<CommentEntity> commentsByTaskIdMatcher = new CommentsByTaskIdMatcher();
    protected CachedEntityMatcher<CommentEntity> commentsByProcInstIdAndActivityIdMatcher = new CommentsByProcInstIdAndActivityIdMatcher();
    private String QUERYTIMEDESC = "time desc";

    public CommentEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public Class<? extends CommentEntity> getManagedEntityClass() {
        return CommentEntityImpl.class;
    }

    @Override
    public CommentEntity create() {
        return new CommentEntityImpl();
    }

    @Override
    public CommentEntity create(DynamicObject dynamicObject) {
        return new CommentEntityImpl(dynamicObject);
    }

    @Override
    public String getEntityName() {
        return "wf_hicomment";
    }

    @Override
    public String getTableName() {
        return "t_wf_hicomment";
    }

    @Override
    public String getMultiLangTableName() {
        return "t_wf_hicomment_l";
    }

    @Override
    public String getSelectFields() {
        String extBusinessFieldBy = TaskExtendFieldUtil.getExtBusinessFieldByEntityNumber(this.getEntityName());
        return "id,type,userId,taskId,processInstanceId,activityId,message,resultNumber,resultName,time,assignee,decisionType,groupId,backToBack,activityName,subactivityname,entityNumber,businessKey,ownerId,bizidentifykey,step,usernameformatter,terminalway,assignorname,ispublic,coordinviteopinion,subprocessinstanceid,currentsubject,billno,entityname,sendernameformat,starterid,presentassignee,processingpage,processingmobilepage,handlestate,category,sendername,createdate,executiontype,display,endtype,billtype,delegateid,startname,startnameformat,sourcename,source,signature,biz_date,biz_number,bizformat,biz_str1,biz_str2,biz_date2,biz_number2,biz_strmul1,biz_strmul2" + extBusinessFieldBy;
    }

    @Override
    public void insert(CommentEntity entity, boolean fireCreateEvent) {
        this.getDbSqlSession().insert(entity);
        ActivitiEventDispatcher eventDispatcher = this.getEventDispatcher();
        if (eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_CREATED, entity));
        }
    }

    @Override
    public void insert(CommentEntity commentEntity) {
        TaskEntity entity;
        this.checkHistoryEnabled();
        ILocaleString activityName = commentEntity.getNodeName();
        if (WfUtils.isEmpty(activityName)) {
            CommandContext commandContext = Context.getCommandContext();
            Long proinstId = commentEntity.getProcessInstanceId();
            HistoricProcessInstanceEntity processInstanceEntity = (HistoricProcessInstanceEntity)commandContext.getHistoricProcessInstanceEntityManager().findById(proinstId);
            if (processInstanceEntity != null) {
                Long processDefinitionId = processInstanceEntity.getProcessDefinitionId();
                BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(processDefinitionId, proinstId);
                FlowElement element = bpmnModel.getMainProcess().getFlowElement(commentEntity.getActivityId(), true);
                if (element instanceof UserTask) {
                    String bizIdentifyKey = ((UserTask)element).getBizIdentifyKey();
                    if (WfUtils.isNotEmpty(bizIdentifyKey)) {
                        commentEntity.setBizIdentifyKey(bizIdentifyKey);
                    }
                    String resultNumber = commentEntity.getResultNumber();
                    String resultName = commentEntity.getResultName();
                    if (WfUtils.isEmpty(resultName)) {
                        List decisionOptions = element.getDecisionOptions();
                        for (DecisionOption decision : decisionOptions) {
                            if (!resultNumber.equalsIgnoreCase(decision.getNumber())) continue;
                            String designMultiKey = BpmnModelUtil.getDecisionNameMultiKey(element.getId(), decision.getId());
                            ILocaleString decisionName = BpmnModelUtil.getMultiLangFieldValue(proinstId, designMultiKey, decision.getName());
                            commentEntity.setResultName(decisionName);
                            break;
                        }
                    }
                }
                String multiKey = BpmnModelUtil.getActivityNameMultiKey(commentEntity.getActivityId());
                commentEntity.setActivityName(BpmnModelUtil.getMultiLangFieldValue(proinstId, multiKey, element.getName()));
                if (element instanceof YunzhijiaTask) {
                    YunzhijiaTask yunzhijiaTask = (YunzhijiaTask)element;
                    commentEntity.setBackToBack(yunzhijiaTask.getBackToBackVote());
                }
            }
        }
        if (WfUtils.isNotEmpty(commentEntity.getTaskId()) && (entity = (TaskEntity)this.getTaskEntityManager().findById(commentEntity.getTaskId())) != null) {
            commentEntity.setBusinessKey(entity.getBusinessKey());
            commentEntity.setEntityNumber(entity.getEntityNumber());
            if (WfUtils.isEmpty(commentEntity.getCurrentSubject())) {
                commentEntity.setCurrentSubject(entity.getSubject());
            }
            if (WfUtils.isEmpty(commentEntity.getActivityName())) {
                commentEntity.setActivityName(entity.getName());
            }
        }
        this.insert(commentEntity, false);
        CommentEntity comment = commentEntity;
        if (this.getEventDispatcher().isEnabled()) {
            ExecutionEntity process;
            Long processDefinitionId = null;
            Long processInstanceId = comment.getProcessInstanceId();
            if (comment.getProcessInstanceId() != null && (process = (ExecutionEntity)this.getExecutionEntityManager().findById(comment.getProcessInstanceId())) != null) {
                processDefinitionId = process.getProcessDefinitionId();
            }
            this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_INITIALIZED, commentEntity, processInstanceId, processInstanceId, processDefinitionId));
        }
    }

    @Override
    public List<CommentEntity> findCommentsByTaskId(Long taskId) {
        this.checkHistoryEnabled();
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("taskId", taskId).addFilter("type", "comment");
        HashMap<String, Object> parameters = new HashMap<String, Object>(2);
        parameters.put("taskId", taskId);
        parameters.put("type", "comment");
        return this.getList(eb, this.commentsByTaskIdMatcher, parameters, true);
    }

    private List<CommentEntity> findAllCommentsByTaskId(Long taskId) {
        this.checkHistoryEnabled();
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("taskId", taskId);
        HashMap<String, Long> parameters = new HashMap<String, Long>(1);
        parameters.put("taskId", taskId);
        return this.getList(eb, this.commentsByTaskIdMatcher, parameters, true);
    }

    @Override
    public List<CommentEntity> findCommentsByTaskIdAndType(Long taskId, String type) {
        this.checkHistoryEnabled();
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("taskId", taskId).addFilter("type", type).orderBy(this.QUERYTIMEDESC);
        return this.findByQueryBuilder(eb);
    }

    @Override
    public void delete(Long id) {
        CommentEntity entity = (CommentEntity)this.findById(id);
        if (entity != null) {
            this.delete(entity);
        }
    }

    @Override
    public void delete(CommentEntity entity, boolean fireDeleteEvent) {
        if (entity == null) {
            return;
        }
        boolean isTwiceDelete = entity.isDeleted();
        this.getDbSqlSession().delete(entity);
        ActivitiEventDispatcher eventDispatcher = this.getEventDispatcher();
        if (this.getEventDispatcher().isEnabled() && !isTwiceDelete) {
            eventDispatcher.dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_DELETED, entity));
        }
    }

    @Override
    public void deleteByFilters(QFilter[] qFilters) {
        List comments = this.findByQueryFilters(qFilters);
        for (CommentEntity comment : comments) {
            this.delete(comment, true);
        }
    }

    @Override
    public void deleteCommentsByTaskId(Long taskId) {
        this.checkHistoryEnabled();
        List<CommentEntity> comments = this.findCommentsByTaskId(taskId);
        for (Comment comment : comments) {
            this.delete((CommentEntity)comment);
        }
    }

    @Override
    public void deleteCommentsByProcessInstanceId(Long processInstanceId) {
        this.checkHistoryEnabled();
        QFilter q = new QFilter("processInstanceId", "=", (Object)processInstanceId);
        QFilter[] qFilters = new QFilter[]{q};
        this.deleteByFilters(qFilters);
    }

    @Override
    public List<CommentEntity> findCommentsByProcessInstanceId(Long processInstanceId) {
        this.checkHistoryEnabled();
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("processInstanceId", processInstanceId).orderBy(this.QUERYTIMEDESC);
        return this.findByQueryBuilder(eb);
    }

    @Override
    public CommentEntity findComment(Long commentId) {
        return (CommentEntity)this.findById(commentId);
    }

    @Override
    public void delete(CommentEntity commentEntity) {
        this.checkHistoryEnabled();
        this.delete(commentEntity, false);
    }

    protected void checkHistoryEnabled() {
        if (!this.getHistoryManager().isHistoryEnabled()) {
            throw new WFEngineException("In order to use comments, history should be enabled");
        }
    }

    @Override
    public List<CommentEntity> findCommentsByProcessInstanceIdAndActivityId(Long processInstanceId, String activityId) {
        this.checkHistoryEnabled();
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("processInstanceId", processInstanceId).addFilter("activityId", activityId).orderBy(this.QUERYTIMEDESC);
        HashMap<String, Object> parameters = new HashMap<String, Object>(2);
        parameters.put("processInstanceId", processInstanceId);
        parameters.put("activityId", activityId);
        return this.getList(eb, this.commentsByProcInstIdAndActivityIdMatcher, parameters, true);
    }

    @Override
    public int calculateStep(Long processInstanceId) {
        int step = 9;
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT fstep FROM ").append(this.getTableName()).append(" WHERE fprocinstid = ? ORDER BY fstep DESC");
        Object[] params = new Object[]{processInstanceId};
        try (DataSet ds = DB.queryDataSet((String)"wf.calculateStep", (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])params);){
            Iterator iter = ds.iterator();
            if (iter.hasNext()) {
                Row row = (Row)iter.next();
                step = Math.max(step, row.getInteger("fstep"));
            }
        }
        return ++step;
    }

    @Override
    public List<CommentEntity> findByTaskIds(List<Long> taskIds) {
        QFilter filter = new QFilter("taskId", "in", taskIds);
        return this.findByQueryFilters(new QFilter[]{filter});
    }

    @Override
    public List<CommentEntity> findApprovalRecordByAuth(QFilter[] qFilters, String orderBy) {
        List<CommentEntity> comments = this.findByQueryFilters(qFilters, this.getSelectFields() + "," + "richTextMessage", orderBy);
        return this.filterComments(comments);
    }

    @Override
    public List<CommentEntity> findApprovalRecordByAuth(QFilter[] qFilters, String orderBy, boolean fetchWhole) {
        if (!fetchWhole) {
            return this.findApprovalRecordByAuth(qFilters, orderBy);
        }
        List<CommentEntity> comments = this.findByQueryFilters(qFilters, this.getSelectFields() + "," + "richTextMessage", orderBy);
        List<CommentEntity> commentEntities = this.filterComments(new ArrayList<CommentEntity>(comments));
        HashMap<Long, CommentEntity> map = new HashMap<Long, CommentEntity>();
        for (CommentEntity comment : commentEntities) {
            map.put(comment.getId(), comment);
        }
        for (CommentEntity item : comments) {
            CommentEntity recordItem = (CommentEntity)map.get(item.getId());
            if (recordItem != null) {
                item.setResultName(recordItem.getCommentResult());
                item.setUserNameFormatter(recordItem.getUserNameFormatter());
                item.setAssignorName(recordItem.getAssignorName());
                item.setMessage(recordItem.getCommentMessage());
                if (!(item instanceof CommentEntityImpl)) continue;
                ((CommentEntityImpl)item).setAvatar(((CommentEntityImpl)recordItem).getAvatar());
                continue;
            }
            item.setResultName((ILocaleString)new LocaleString(""));
            item.setAssignee((ILocaleString)new LocaleString(""));
            item.setUserNameFormatter((ILocaleString)new LocaleString(""));
            item.setAssignorName((ILocaleString)new LocaleString(""));
            item.setMessage((ILocaleString)new LocaleString(""));
        }
        return comments;
    }

    private List<CommentEntity> filterComments(List<CommentEntity> comments) {
        if (comments == null || comments.isEmpty()) {
            return comments;
        }
        CommentEntity comment = comments.get(0);
        String entityNumber = comment.getEntityNumber();
        String plugin = this.fetchPlugin(entityNumber);
        if (StringUtils.isBlank((CharSequence)plugin)) {
            return comments;
        }
        Object o = ExternalInterfaceUtil.executeExtItf(ExtItfCallerType.FILTERAPPROVALRECORDBYAUTH, plugin, comments);
        if (o == null) {
            return new ArrayList<CommentEntity>(0);
        }
        return (List)o;
    }

    private String fetchPlugin(String entityNumber) {
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            return "";
        }
        String plugin = WfConfigurationUtil.fetchFilterApprovalRecordPlugin(entityNumber);
        if (StringUtils.isNotBlank((CharSequence)plugin)) {
            return plugin;
        }
        return this.fetchPluginByBillSubjectModel(entityNumber);
    }

    private String fetchPluginByBillSubjectModel(String entityNumber) {
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            return "";
        }
        QFilter qFilter = new QFilter("entitynumber", "=", (Object)entityNumber);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"wf_billsubjectmodel", (String)"id,filterapprovalrecordplg", (QFilter[])qFilter.toArray());
        if (dynamicObject == null) {
            return "";
        }
        String plugin = dynamicObject.getString("filterapprovalrecordplg");
        if (StringUtils.isEmpty((CharSequence)plugin)) {
            return "";
        }
        return plugin;
    }

    @Override
    public void updateCommentByHisTask(Map<String, AttributeModifyRecord> records, Long taskId) {
        String handleState;
        String executionType = records.get("executionType") == null ? null : (String)records.get("executionType").getNewValue();
        String string = handleState = records.get("handleState") == null ? null : (String)records.get("handleState").getNewValue();
        if (executionType != null || handleState != null) {
            List<CommentEntity> comments = this.findAllCommentsByTaskId(taskId);
            comments.forEach(comment -> {
                if (executionType != null) {
                    comment.setExecutionType(executionType);
                }
                if (handleState != null) {
                    comment.setHandleState(handleState);
                }
                this.update(comment);
            });
        }
    }
}

