/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.task;

import java.util.ArrayList;
import java.util.List;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.FeedbackEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.FeedbackEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.FeedbackEntityManager;

public class FeedbackEntityManagerImpl
extends AbstractEntityManager<FeedbackEntity>
implements FeedbackEntityManager {
    public FeedbackEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public Class<? extends FeedbackEntity> getManagedEntityClass() {
        return FeedbackEntityImpl.class;
    }

    @Override
    public String getSelectFields() {
        return "id,processInstanceId,businessKey,feedbackMsg,feedbackImg,feedbackAttach,creatorId,createDate,modifierId,modifyDate";
    }

    @Override
    public String getEntityName() {
        return "wf_feedback";
    }

    @Override
    public List<FeedbackEntity> findFeedbacksByProcessInstanceId(String processInstanceId) {
        if (WfUtils.isNotEmpty(processInstanceId)) {
            EntityQueryBuilder eb = this.createQueryBuilder().addFilter("processInstanceId", Long.parseLong(processInstanceId)).orderBy("createDate");
            return this.findByQueryBuilder(eb);
        }
        return new ArrayList<FeedbackEntity>();
    }

    @Override
    public void insert(FeedbackEntity entity, boolean fireCreateEvent) {
        super.insert(entity, fireCreateEvent);
        this.getHistoryManager().recordFeedbackEntityCreated(entity);
    }

    @Override
    public void delete(Long id) {
        super.delete(id);
        this.getHistoryManager().recordFeedbackEntityDelete(id);
    }
}

