/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.event.ActivitiEventDispatcher;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.persistence.CachedEntityMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.RuleTaskRelationsByFieldTypeMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.RuleTaskRelationsByTaskIdAndTypeMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.task.RuleTaskRelationEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.RuleTaskRelationEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.RuleTaskRelationEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;

public class RuleTaskRelationEntityManagerImpl
extends AbstractEntityManager<RuleTaskRelationEntity>
implements RuleTaskRelationEntityManager {
    protected CachedEntityMatcher<RuleTaskRelationEntity> cachedEntityMatcher = new RuleTaskRelationsByTaskIdAndTypeMatcher();
    protected CachedEntityMatcher<RuleTaskRelationEntity> insertCachedEntityMatcher = new RuleTaskRelationsByFieldTypeMatcher();

    public RuleTaskRelationEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public Class<? extends RuleTaskRelationEntity> getManagedEntityClass() {
        return RuleTaskRelationEntityImpl.class;
    }

    @Override
    public String getSelectFields() {
        return "taskid,ruleid,ruletype,markid,userid,priority,currentsubject,processinstanceid";
    }

    @Override
    public String getEntityName() {
        return "wf_ruletaskrelation";
    }

    @Override
    public RuleTaskRelationEntity getRelationEntityByTaskIdAndType(Long taskId, String type, Long userId) {
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(userId);
        List<RuleTaskRelationEntity> entitys = this.getRelationEntitysByTaskIdAndType(taskId, type, userIds);
        if (entitys != null && entitys.size() > 0) {
            return entitys.get(0);
        }
        return null;
    }

    @Override
    public List<RuleTaskRelationEntity> getRelationEntitysByTaskIdAndType(Long taskId, String type, List<Long> userIds) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("taskid", "=", taskId).addFilter("ruletype", "=", type).addFilter("userid", "in", userIds);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("taskid", taskId);
        map.put("ruletype", type);
        map.put("userid", userIds);
        List<RuleTaskRelationEntity> entitys = this.getList(eb, this.cachedEntityMatcher, map, true);
        return entitys;
    }

    @Override
    public List<RuleTaskRelationEntity> getRelationEntityByParams(String type, Long taskId, Long markid, Long userid, Long ruleid) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("taskid", "=", taskId).addFilter("userid", "=", userid).addFilter("ruleid", "=", ruleid).addFilter("ruletype", "=", type).addFilter("markid", "=", markid);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("taskid", taskId);
        map.put("ruletype", type);
        map.put("markid", markid);
        map.put("userid", userid);
        map.put("ruleid", ruleid);
        List<RuleTaskRelationEntity> entitys = this.getList(eb, this.insertCachedEntityMatcher, map, true);
        return entitys;
    }

    @Override
    public void insert(RuleTaskRelationEntity entity, boolean fireCreateEvent) {
        this.getDbSqlSession().insert(entity);
        ActivitiEventDispatcher eventDispatcher = this.getEventDispatcher();
        if (eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_CREATED, entity));
        }
    }

    @Override
    public void insert(RuleTaskRelationEntity entity) {
        List<RuleTaskRelationEntity> entitys = this.getRelationEntityByParams(entity.getRuletype(), entity.getTaskid(), entity.getMarkid(), entity.getUserid(), entity.getRuleid());
        if (entitys == null || entitys.isEmpty()) {
            if (WfUtils.isNotEmpty(entity.getTaskid())) {
                TaskEntity task = (TaskEntity)this.getTaskEntityManager().findById(entity.getTaskid());
                if (task != null && WfUtils.isEmpty(entity.getCurrentSubject())) {
                    entity.setCurrentSubject(task.getSubject());
                }
                if (task != null && WfUtils.isEmpty(entity.getProcinstId())) {
                    entity.setProcinstId(task.getProcessInstanceId());
                }
            }
            this.insert(entity, true);
        }
    }

    @Override
    public void delete(Long id) {
        RuleTaskRelationEntity entity = (RuleTaskRelationEntity)this.findById(id);
        if (entity != null) {
            this.delete(entity);
        }
    }

    @Override
    public void delete(RuleTaskRelationEntity entity) {
        this.delete(entity, true);
    }

    @Override
    public void delete(RuleTaskRelationEntity entity, boolean fireDeleteEvent) {
        if (entity == null) {
            return;
        }
        boolean isTwiceDelete = entity.isDeleted();
        this.getDbSqlSession().delete(entity);
        ActivitiEventDispatcher eventDispatcher = this.getEventDispatcher();
        if (this.getEventDispatcher().isEnabled() && !isTwiceDelete) {
            eventDispatcher.dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_DELETED, entity));
        }
    }

    @Override
    public void deleteByFilters(QFilter[] qFilters) {
        this.innerDelete(qFilters);
    }

    @Override
    public void deleteEntitiesByTaskIdAndType(Long taskId, String type) {
        QFilter[] qFilters = new QFilter[]{new QFilter("taskid", "=", (Object)taskId), new QFilter("ruletype", "=", (Object)type)};
        this.innerDelete(qFilters);
    }

    @Override
    public void deleteEntitiesByTaskIdAndUid(Long taskId, List<Long> uids) {
        QFilter[] qFilters = new QFilter[]{new QFilter("taskid", "=", (Object)taskId), new QFilter("userid", "in", uids)};
        this.innerDelete(qFilters);
    }

    @Override
    public void deleteEntitiesByTaskIdAndTypeAndUserId(Long taskId, String type, String userId) {
        QFilter[] qFilters = new QFilter[]{new QFilter("taskid", "=", (Object)taskId), new QFilter("ruletype", "=", (Object)type), new QFilter("userid", "=", (Object)Long.valueOf(userId))};
        this.innerDelete(qFilters);
    }

    @Override
    public void deleteEntitiesByTaskIdAndUserId(Long taskId, String userId) {
        QFilter[] qFilters = new QFilter[]{new QFilter("taskid", "=", (Object)taskId), new QFilter("userid", "=", (Object)Long.valueOf(userId))};
        this.innerDelete(qFilters);
    }

    private void innerDelete(QFilter[] qFilters) {
        List ruleTaskRelationEntities = this.findByQueryFilters(qFilters);
        if (ruleTaskRelationEntities != null && !ruleTaskRelationEntities.isEmpty()) {
            for (RuleTaskRelationEntity ruleTaskRelationEntity : ruleTaskRelationEntities) {
                this.delete(ruleTaskRelationEntity, true);
            }
        }
    }
}

