/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.task;

import java.util.List;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskCenterNavigationEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskCenterNavigationEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskCenterNavigationEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskCenterOperationMetaEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskCenterRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskCenterRuleEntityManager;

public class TaskCenterNavigationEntityManagerImpl
extends AbstractEntityManager<TaskCenterNavigationEntity>
implements TaskCenterNavigationEntityManager {
    public TaskCenterNavigationEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public Class<? extends TaskCenterNavigationEntity> getManagedEntityClass() {
        return TaskCenterNavigationEntityImpl.class;
    }

    @Override
    public String getSelectFields() {
        return "number,name,userid,parentid,taskcenterruleid,activitstate,createDate,modifyDate";
    }

    @Override
    public String getEntityName() {
        return "wf_tasknavigation";
    }

    @Override
    public TaskCenterNavigationEntity findById(Long entityId) {
        TaskCenterNavigationEntity entity = (TaskCenterNavigationEntity)super.findById(entityId);
        if (entity == null) {
            return null;
        }
        Long taskCenterRuleId = entity.getTaskcenterruleid();
        if (WfUtils.isNotEmpty(taskCenterRuleId)) {
            TaskCenterRuleEntity ruleEntity = (TaskCenterRuleEntity)this.processEngineConfiguration.getTaskCenterRuleEntityManager().findById(taskCenterRuleId);
            entity.setTaskCenterRuleEntity(ruleEntity);
        }
        return entity;
    }

    @Override
    public void insert(TaskCenterNavigationEntity entity) {
        TaskCenterRuleEntity taskCenterRule = entity.getTaskCenterRuleEntity();
        super.insert(entity);
        if (taskCenterRule != null) {
            this.processEngineConfiguration.getTaskCenterRuleEntityManager().insert(taskCenterRule);
            List<TaskCenterOperationMetaEntity> operationMetas = taskCenterRule.getOperationMetas();
            String operateparams = "{\"folderId\":\"" + entity.getId() + "\"}";
            operationMetas.get(0).setOperateparams(operateparams);
            taskCenterRule.setOperationMetas(operationMetas);
            entity.setTaskcenterruleid(taskCenterRule.getId());
        }
    }

    @Override
    public TaskCenterNavigationEntity update(TaskCenterNavigationEntity entity) {
        Long taskCenterRuleId = entity.getTaskcenterruleid();
        TaskCenterRuleEntityManager manager = this.processEngineConfiguration.getTaskCenterRuleEntityManager();
        TaskCenterRuleEntity taskCenterRule = entity.getTaskCenterRuleEntity();
        if (WfUtils.isEmpty(taskCenterRuleId) && taskCenterRule != null) {
            manager.insert(taskCenterRule);
        }
        if (WfUtils.isNotEmpty(taskCenterRuleId)) {
            if (taskCenterRule != null) {
                manager.update(taskCenterRule, true);
            } else {
                manager.delete(taskCenterRuleId);
                entity.setTaskcenterruleid(null);
            }
        }
        return super.update(entity);
    }

    @Override
    public void delete(Long id) {
        TaskCenterNavigationEntity entity = this.findById(id);
        if (entity == null) {
            return;
        }
        Long taskCenterRuleId = entity.getTaskcenterruleid();
        if (WfUtils.isNotEmpty(taskCenterRuleId)) {
            this.processEngineConfiguration.getTaskCenterRuleEntityManager().delete(taskCenterRuleId);
        }
        QFilter filter = new QFilter("ruleid", "=", (Object)id);
        this.processEngineConfiguration.getRuleTaskRelationEntityManager().deleteByFilters(new QFilter[]{filter});
        super.delete(id);
    }

    @Override
    public List<TaskCenterNavigationEntity> getNavigationByUserid(long userId) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("userid", "=", userId);
        List<TaskCenterNavigationEntity> entitys = this.findByQueryBuilder(eb);
        for (TaskCenterNavigationEntity entity : entitys) {
            Long taskCenterRuleId = entity.getTaskcenterruleid();
            if (taskCenterRuleId == null || taskCenterRuleId <= 0L) continue;
            TaskCenterRuleEntity taskCenterRuleEntity = (TaskCenterRuleEntity)this.processEngineConfiguration.getTaskCenterRuleEntityManager().findById(taskCenterRuleId);
            entity.setTaskCenterRuleEntity(taskCenterRuleEntity);
        }
        return entitys;
    }
}

