/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.task;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskCenterRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskCenterRuleEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskCenterRuleEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.condition.ConditionUtil;

public class TaskCenterRuleEntityManagerImpl
extends AbstractEntityManager<TaskCenterRuleEntity>
implements TaskCenterRuleEntityManager {
    public TaskCenterRuleEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public Class<? extends TaskCenterRuleEntity> getManagedEntityClass() {
        return TaskCenterRuleEntityImpl.class;
    }

    @Override
    public String getSelectFields() {
        return "name,number,conditionalruleid,userid,activitstate,expression,type,entryentity.operationkey,entryentity.operateparams,modifydate,createdate,autoexenexttask";
    }

    @Override
    public String getEntityName() {
        return "wf_taskattributerule";
    }

    @Override
    public void insert(TaskCenterRuleEntity entity) {
        ConditionalRuleEntity conditionalRuleEntity = entity.getConditionalRuleModel();
        if (conditionalRuleEntity != null) {
            conditionalRuleEntity.setType(ConditionalRuleType.taskCenter.toString());
            this.processEngineConfiguration.getConditionalRuleEntityManager().insert(conditionalRuleEntity, true);
            entity.setConditionalruleid(conditionalRuleEntity.getId());
        }
        super.insert(entity);
    }

    @Override
    public TaskCenterRuleEntity findById(Long entityId) {
        TaskCenterRuleEntity entity = (TaskCenterRuleEntity)super.findById(entityId);
        if (entity == null) {
            return null;
        }
        Long conditionalRuleId = entity.getConditionalruleid();
        ConditionalRuleEntity conditionalRule = WfUtils.isNotEmpty(conditionalRuleId) ? (ConditionalRuleEntity)this.processEngineConfiguration.getConditionalRuleEntityManager().findById(conditionalRuleId) : new ConditionalRuleEntityImpl();
        entity.setConditionalRuleModel(conditionalRule);
        return entity;
    }

    @Override
    public TaskCenterRuleEntity update(TaskCenterRuleEntity entity, boolean fireUpdateEvent) {
        ConditionalRuleEntity conditionalRuleEntity = entity.getConditionalRuleModel();
        Long conditionalRuleId = entity.getConditionalruleid();
        if (WfUtils.isEmpty(conditionalRuleId) && conditionalRuleEntity != null) {
            conditionalRuleEntity.setType(ConditionalRuleType.taskCenter.toString());
            this.processEngineConfiguration.getConditionalRuleEntityManager().insert(conditionalRuleEntity, fireUpdateEvent);
            entity.setConditionalruleid(conditionalRuleEntity.getId());
        }
        if (WfUtils.isNotEmpty(conditionalRuleId)) {
            if (conditionalRuleEntity != null) {
                conditionalRuleEntity.setType(ConditionalRuleType.taskCenter.toString());
                this.processEngineConfiguration.getConditionalRuleEntityManager().update(conditionalRuleEntity, fireUpdateEvent);
            } else {
                this.processEngineConfiguration.getConditionalRuleEntityManager().delete(conditionalRuleId);
                entity.setConditionalruleid(null);
            }
        }
        return super.update(entity, fireUpdateEvent);
    }

    @Override
    public void delete(TaskCenterRuleEntity entity, boolean fireDeleteEvent) {
        this.processEngineConfiguration.getConditionalRuleEntityManager().delete(entity.getConditionalruleid());
        super.delete(entity, fireDeleteEvent);
    }

    @Override
    public List<TaskCenterRuleEntity> getTaskCenterRulesByUserId(Long userId) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("userid", "=", userId);
        List<TaskCenterRuleEntity> taskCenterRuleEntitys = this.findByQueryBuilder(eb);
        for (TaskCenterRuleEntity entity : taskCenterRuleEntitys) {
            Long conditionalRuleId = entity.getConditionalruleid();
            if (conditionalRuleId == null || conditionalRuleId <= 0L) continue;
            ConditionalRuleEntity conditionalRuleModel = (ConditionalRuleEntity)this.processEngineConfiguration.getConditionalRuleEntityManager().findById(conditionalRuleId);
            entity.setConditionalRuleModel(conditionalRuleModel);
        }
        return taskCenterRuleEntitys;
    }

    @Override
    public List<TaskCenterRuleEntity> getNoFolderTaskCenterRulesByUserId(Long userId) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("userid", "=", userId).addFilter("type", "!=", "folder");
        List<TaskCenterRuleEntity> taskCenterRuleEntitys = this.findByQueryBuilder(eb);
        for (TaskCenterRuleEntity entity : taskCenterRuleEntitys) {
            Long conditionalRuleId = entity.getConditionalruleid();
            if (conditionalRuleId == null || conditionalRuleId <= 0L) continue;
            ConditionalRuleEntity conditionalRuleModel = (ConditionalRuleEntity)this.processEngineConfiguration.getConditionalRuleEntityManager().findById(conditionalRuleId);
            entity.setConditionalRuleModel(conditionalRuleModel);
        }
        return taskCenterRuleEntitys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Long, Boolean> matchAutoTransferRule(TaskEntity task, List<Long> userIds) {
        if (userIds == null || userIds.isEmpty() || task == null) {
            return Collections.emptyMap();
        }
        String ids = WfUtils.listToString(userIds, ",");
        String sql = String.format("select fexpression,fuserid from t_wf_taskattributerule a,t_wf_taskoperationmeta b where a.fid=b.fid and a.fuserid in (%s) and factivitstate = ? and b.foperationkey = ?", ids);
        Map expressions = (Map)DB.query((DBRoute)WfUtils.WFS, (String)sql, (Object[])new Object[]{"enable", "Transfer"}, (ResultSetHandler)new ResultSetHandler<Map<Long, List<String>>>(){

            public Map<Long, List<String>> handle(ResultSet rs) throws Exception {
                HashMap<Long, List<String>> expressions = new HashMap<Long, List<String>>();
                while (rs.next()) {
                    Long id = rs.getLong("fuserid");
                    ArrayList<String> exps = (ArrayList<String>)expressions.get(id);
                    if (exps == null) {
                        exps = new ArrayList<String>();
                        expressions.put(id, exps);
                    }
                    exps.add(rs.getString("fexpression"));
                }
                return expressions;
            }
        });
        if (expressions != null && !expressions.isEmpty()) {
            HashMap<Long, Boolean> ret = new HashMap<Long, Boolean>(userIds.size());
            for (Map.Entry entry : expressions.entrySet()) {
                String key = ConditionUtil.getConInstKey(task.getId() + "_" + entry.getKey(), "taskAutoRule");
                boolean pass = false;
                try {
                    task.setTransientVariable("taskRuleParticipant", entry.getKey());
                    for (String express : (List)entry.getValue()) {
                        if (!ConditionUtil.hasTrueCondition(express, (VariableScope)task, key)) continue;
                        pass = true;
                        break;
                    }
                }
                catch (Exception e) {
                    this.logger.info(String.format("error occur for rule[%s],exception is [%s]", entry.getValue(), e.getMessage()));
                }
                finally {
                    task.removeTransientVariable("taskRuleParticipant");
                }
                ret.put((Long)entry.getKey(), pass);
            }
            return ret;
        }
        return Collections.emptyMap();
    }
}

