/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.lang.Lang;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.workflow.bpmn.model.ActivitiListener;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.bpmn.helper.BPMNUtil;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ManagementConstants;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.PreComputatorExecutionEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.VariableInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.VariableScopeImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ParticipantHelper;
import kd.bos.workflow.engine.task.AttributeModifyRecord;
import kd.bos.workflow.engine.task.IdentityLink;
import kd.bos.workflow.engine.task.TaskUtils;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.feature.taskfield.util.TaskExtendFieldUtil;

@KSObject
public class TaskEntityImpl
extends VariableScopeImpl
implements TaskEntity,
Serializable {
    private static final long serialVersionUID = 1L;
    protected ExecutionEntity processInstance;
    protected ExecutionEntity execution;
    protected TaskEntity parentTaskInstance;
    protected boolean identityLinksInitialized;
    private List<IdentityLinkEntity> taskIdentityLinkEntities = new ArrayList<IdentityLinkEntity>();
    protected String eventName;
    protected ActivitiListener currentActivitiListener;
    private String wfPlugin;
    private Map<String, Object> wfPluginParams;
    private List<VariableInstanceEntity> queryVariables;
    protected boolean forcedUpdate;
    private boolean fromHistory = false;
    public static final String SENDERNAME = "senderName";
    public static final String SENDERID = "senderId";
    public static final String STARTERNAME = "startName";
    public static final String STARTNAMEFORMAT = "startnameformat";
    public static final String SENDERNAMEFORMAT = "sendernameformat";
    public static final String STARTERID = "starterId";
    public static final String HANDLESTATE = "handleState";
    public static final String PROCESSINGMOBILEPAGE = "processingMobilePage";
    public static final String PROCESSINGPAGE = "processingPage";
    public static final String YZJGROUPID = "yzjGroupId";
    public static final String EXECUTIONTYPE = "executionType";
    public static final String BUSINESSKEY = "businessKey";
    public static final String SUBJECT = "subject";
    public static final String ENTITYNAME = "entityName";
    public static final String BILLTYPE = "billType";
    public static final String ENTITYNUMBER = "entityNumber";
    public static final String DISPLAY = "display";
    public static final String PRIORITY = "priority";
    public static final String SUSPENSIONSTATE = "suspensionState";
    public static final String CLAIMTIME = "claimTime";
    public static final String DUEDATE = "dueDate";
    public static final String CATEGORY = "category";
    public static final String MOBILEFORMKEY = "mobileFormKey";
    public static final String FORMKEY = "formKey";
    public static final String TASKDEFINITIONKEY = "taskDefinitionKey";
    public static final String DELEGATIONSTATE = "delegationState";
    public static final String DESCRIPTION = "description";
    public static final String NAME = "name";
    public static final String PARENTTASKID = "parentTaskId";
    public static final String EXECUTIONID = "executionId";
    public static final String PROCESSINSTANCEID = "processInstanceId";
    public static final String PROCESSDEFINITIONID = "processDefinitionId";
    public static final String ASSIGNEEID = "assigneeId";
    public static final String ASSIGNEE = "assignee";
    public static final String OWNERID = "ownerId";
    public static final String OWNER = "owner";
    public static final String ACTIVE = "active";
    public static final String BILLNO = "billNo";
    public static final String SUBACTIVITYNAME = "subactivityname";
    public static final String ENDTYPE = "endType";
    public static final String SOURCE = "source";
    public static final String URL = "url";
    public static final String MOBILEURL = "mobileurl";
    public static final String PARTICIPANTNAME = "participantName";
    public static final String VALIDATEOPERATION = "validateoperation";
    public static final String TOHANDLEGROUPNO = "groupnumber";
    public static final String BATCHOP = "batchOp";
    public static final String ORGUNITID = "orgUnitId";
    public static final String ORGVIEWID = "orgviewid";
    public static final String PROCESSTYPE = "processtype";
    public static final String CONTROL = "control";
    public static final String BUSINESS_DATE = "biz_date";
    public static final String BUSINESS_NUMBER = "biz_number";
    public static final String BUSINESS_FORMAT = "bizformat";
    public static final String BUSINESS_STR1 = "biz_str1";
    public static final String BUSINESS_STR2 = "biz_str2";
    public static final String BUSINESS_STR3 = "biz_str3";
    public static final String BUSINESS_STR4 = "biz_str4";
    public static final String BUSINESS_STR5 = "biz_str5";
    public static final String BUSINESS_DATE2 = "biz_date2";
    public static final String BUSINESS_NUMBER2 = "biz_number2";
    public static final String BUSINESS_MULSTR1 = "biz_strmul1";
    public static final String BUSINESS_MULSTR2 = "biz_strmul2";
    public static final String TASKSTATE = "taskstate";
    public static final String END_ALL = "all";
    public static final String END_PC = "pc";
    public static final String END_MOBILE = "mobile";
    public static final String DELETE_REASON_COMPLETED = "completed";
    public static final String DELETE_REASON_DELETED = "deleted";
    public static final String EXECUTION_TYPE_BYHAND = "byHand";
    public static final String EXECUTION_TYPE_BYAUTO = "byAuto";
    public static final String EXECUTION_TYPE_SKIP = "skip";
    public static final String EXECUTION_TYPE_JUMP = "jump";
    public static final String EXECUTION_TYPE_ENTERBOUNDARY = "enterBoundary";
    public static final String EXECUTION_TYPE_MANUALPUSH = "manualpush";
    public static final String HANLDLE_STATE_DISMISSED = "dismissed";
    public static final String HANLDLE_STATE_WILLAPPROVAL = "willApproval";
    public static final String HANLDLE_STATE_WILLHandled = "willHandled";
    public static final String HANLDLE_STATE_FREEZE = "freeze";
    public static final String HANLDLE_STATE_APPROVED = "approved";
    public static final String HANLDLE_STATE_SUSPENDED = "suspended";
    public static final String HANLDLE_STATE_MANUALSUSPENDED = "manualSuspended";
    public static final String HANLDLE_STATE_UNCONVERTED = "unConverted";
    public static final String HANLDLE_STATE_CONVERTED = "converted";
    public static final String HANLDLE_STATE_CONVERTING = "converting";
    public static final String CONVERSION_MODE_PUSH = "manualpush";
    public static final String CONVERSION_MODE_DRAW = "manualdraw";
    public static final String BIZTRACENO = "biztraceno";
    Map<String, AttributeModifyRecord> attributeModifyRecords = new HashMap<String, AttributeModifyRecord>();

    public TaskEntityImpl() {
        this.dynamicObject.set(SUSPENSIONSTATE, (Object)ManagementConstants.ACTIVE.getStateCode());
        this.dynamicObject.set(PRIORITY, (Object)50);
        this.dynamicObject.set(DISPLAY, (Object)Boolean.TRUE);
        this.dynamicObject.set(EXECUTIONTYPE, (Object)EXECUTION_TYPE_BYHAND);
        this.dynamicObject.set(ACTIVE, (Object)Boolean.TRUE);
    }

    public TaskEntityImpl(DynamicObject dynamicObject) {
        super(dynamicObject);
    }

    public TaskEntityImpl(HistoricTaskInstanceEntity historicTask) {
        this.setId(historicTask.getId());
        this.dynamicObject.set(PROCESSDEFINITIONID, (Object)historicTask.getProcessDefinitionId());
        this.dynamicObject.set(PROCESSINSTANCEID, (Object)historicTask.getProcessInstanceId());
        this.dynamicObject.set(EXECUTIONID, (Object)historicTask.getExecutionId());
        this.dynamicObject.set(NAME, (Object)WfUtils.subILocaleString(historicTask.getName(), 500));
        this.dynamicObject.set(PARENTTASKID, (Object)historicTask.getParentTaskId());
        this.dynamicObject.set(DESCRIPTION, (Object)(historicTask.getDescription() == null ? "" : historicTask.getDescription().getLocaleValue()));
        this.dynamicObject.set(OWNER, (Object)historicTask.getOwner());
        this.dynamicObject.set(ASSIGNEE, (Object)historicTask.getTaskAssignee());
        this.dynamicObject.set(TASKDEFINITIONKEY, (Object)historicTask.getTaskDefinitionKey());
        this.dynamicObject.set(DISPLAY, (Object)historicTask.isDisplay());
        this.dynamicObject.set(STARTERID, (Object)historicTask.getStarterId());
        this.dynamicObject.set(SENDERID, (Object)String.valueOf(historicTask.getSenderId()));
        this.dynamicObject.set(SUBJECT, (Object)BPMNUtil.subStringSubject(historicTask.getSubject()));
        this.dynamicObject.set(ASSIGNEEID, (Object)historicTask.getAssigneeId());
        this.dynamicObject.set(OWNERID, (Object)historicTask.getOwnerId());
        this.dynamicObject.set(EXECUTIONTYPE, (Object)historicTask.getExecutionType());
        this.dynamicObject.set(ENTITYNUMBER, (Object)historicTask.getEntityNumber());
        this.dynamicObject.set(ENTITYNAME, (Object)historicTask.getEntityName());
        this.dynamicObject.set(STARTERNAME, (Object)historicTask.getStartName());
        this.dynamicObject.set(SENDERNAME, (Object)historicTask.getSenderName());
        this.dynamicObject.set(STARTNAMEFORMAT, (Object)historicTask.getStartNameFormat());
        this.dynamicObject.set(SENDERNAMEFORMAT, (Object)historicTask.getSenderNameFormat());
        this.dynamicObject.set(BUSINESSKEY, (Object)historicTask.getBusinessKey());
        this.dynamicObject.set(BILLNO, (Object)historicTask.getBillNo());
        this.dynamicObject.set(DELEGATIONSTATE, (Object)historicTask.getDelegationState());
        this.dynamicObject.set(FORMKEY, (Object)historicTask.getFormKey());
        this.dynamicObject.set(MOBILEFORMKEY, (Object)historicTask.getMobileFormKey());
        this.dynamicObject.set(YZJGROUPID, (Object)historicTask.getYzjGroupId());
        this.dynamicObject.set(PROCESSINGPAGE, (Object)historicTask.getProcessingPage());
        this.dynamicObject.set(PROCESSINGMOBILEPAGE, (Object)historicTask.getProcessingMobilePage());
        this.dynamicObject.set(HANDLESTATE, (Object)historicTask.getHandleState());
        this.dynamicObject.set(PRIORITY, (Object)historicTask.getPriority());
        this.dynamicObject.set(DUEDATE, (Object)historicTask.getDueDate());
        this.dynamicObject.set(CATEGORY, (Object)historicTask.getCategory());
        this.dynamicObject.set(SUSPENSIONSTATE, (Object)ManagementConstants.ACTIVE.getStateCode());
        this.dynamicObject.set(ACTIVE, (Object)true);
        this.dynamicObject.set(PARTICIPANTNAME, (Object)historicTask.getParticipantName());
        this.dynamicObject.set(SOURCE, (Object)historicTask.getSource());
        this.dynamicObject.set(ENDTYPE, (Object)historicTask.getEndType());
        this.dynamicObject.set(CLAIMTIME, (Object)historicTask.getClaimTime());
        this.dynamicObject.set(VALIDATEOPERATION, (Object)historicTask.getValidateOperation());
        this.dynamicObject.set(BATCHOP, (Object)historicTask.getBatchOp());
        this.dynamicObject.set(BILLTYPE, (Object)historicTask.getBillType());
        this.dynamicObject.set(ORGUNITID, (Object)historicTask.getOrgUnitId());
        this.dynamicObject.set(ORGVIEWID, (Object)historicTask.getOrgViewId());
        String bizTraceNo = historicTask.getBizTraceNo();
        if (WfUtils.isNotEmpty(bizTraceNo)) {
            this.dynamicObject.set(BIZTRACENO, (Object)bizTraceNo);
        }
        this.dynamicObject.set(PROCESSTYPE, (Object)historicTask.getProcessType());
        this.dynamicObject.set(CONTROL, (Object)historicTask.getControl());
        this.dynamicObject.set(BUSINESS_DATE, (Object)historicTask.getBusinessDate());
        this.dynamicObject.set(BUSINESS_NUMBER, (Object)historicTask.getBusinessNumber());
        this.dynamicObject.set(BUSINESS_FORMAT, (Object)historicTask.getBusinessFormat());
        this.dynamicObject.set(BUSINESS_STR1, (Object)historicTask.getBusinessStr1());
        this.dynamicObject.set(BUSINESS_STR2, (Object)historicTask.getBusinessStr2());
        this.dynamicObject.set(BUSINESS_DATE2, (Object)historicTask.getBusinessDate2());
        this.dynamicObject.set(BUSINESS_NUMBER2, (Object)historicTask.getBusinessNumber2());
        this.dynamicObject.set(BUSINESS_MULSTR1, (Object)historicTask.getBusinessMulStr1());
        this.dynamicObject.set(BUSINESS_MULSTR2, (Object)historicTask.getBusinessMulStr2());
        this.dynamicObject.set("captionpc", (Object)historicTask.getCaptionPC());
        this.dynamicObject.set("captionmob", (Object)historicTask.getCaptionMob());
        this.dynamicObject.set("resourceid", (Object)historicTask.getResourceId());
        this.dynamicObject.set("sourcename", (Object)historicTask.getSourceName());
        this.dynamicObject.set(URL, (Object)historicTask.getUrl());
        this.dynamicObject.set(MOBILEURL, (Object)historicTask.getUrl());
        TaskExtendFieldUtil.setExtendTaskBusinessField(this.dynamicObject, historicTask.getDynamicObject());
        this.fromHistory = true;
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>(22);
        persistentState.put(ASSIGNEEID, this.getAssigneeId());
        persistentState.put(ASSIGNEE, this.getAssignee());
        persistentState.put(OWNERID, this.getOwnerId());
        persistentState.put(OWNER, this.getOwner());
        persistentState.put(NAME, this.getName());
        persistentState.put(PRIORITY, this.getPriority());
        persistentState.put(EXECUTIONID, this.getExecutionId());
        persistentState.put(PROCESSDEFINITIONID, this.getProcessDefinitionId());
        persistentState.put(DESCRIPTION, this.getDescription());
        persistentState.put(DUEDATE, this.getDueDate());
        persistentState.put(PARENTTASKID, this.getParentTaskId());
        persistentState.put(DELEGATIONSTATE, this.getDelegationState());
        persistentState.put(SUSPENSIONSTATE, this.getSuspensionState());
        persistentState.put(CLAIMTIME, this.getClaimTime());
        persistentState.put(SUBACTIVITYNAME, this.getSubactivityname());
        persistentState.put(ENDTYPE, this.getEndType());
        persistentState.put(ACTIVE, this.isActive());
        persistentState.put(HANDLESTATE, this.getHandleState());
        persistentState.put(EXECUTIONTYPE, this.getExecutionType());
        persistentState.put(PARTICIPANTNAME, this.getParticipantName());
        persistentState.put(SOURCE, this.getSource());
        persistentState.put(BIZTRACENO, this.getBizTraceNo());
        persistentState.put(ORGUNITID, this.getOrgUnitId());
        persistentState.put(ORGVIEWID, this.getOrgViewId());
        persistentState.put("captionpc", this.getCaptionPC());
        persistentState.put("captionmob", this.getCaptionMob());
        persistentState.put("resourceid", this.getResourceId());
        persistentState.put("sourcename", this.getSourceName());
        persistentState.put(URL, this.getUrl());
        persistentState.put(MOBILEURL, this.getMobileUrl());
        if (this.forcedUpdate) {
            persistentState.put("forcedUpdate", Boolean.TRUE);
        }
        return persistentState;
    }

    @Override
    public void forceUpdate() {
        this.forcedUpdate = true;
    }

    @Override
    protected VariableScopeImpl getParentVariableScope() {
        if (this.getExecution() != null) {
            if (this.execution instanceof ExecutionEntityImpl) {
                return (ExecutionEntityImpl)this.execution;
            }
            if (this.execution instanceof PreComputatorExecutionEntityImpl) {
                return (PreComputatorExecutionEntityImpl)this.execution;
            }
        }
        return null;
    }

    @Override
    public void setExecutionVariables(Map<String, Object> parameters) {
        if (this.getExecution() != null) {
            this.execution.setVariables(parameters);
        }
    }

    @Override
    protected void initializeVariableInstanceBackPointer(VariableInstanceEntity variableInstance) {
        variableInstance.setTaskId(this.getId());
        variableInstance.setExecutionId(this.getExecutionId());
        variableInstance.setProcessInstanceId(this.getProcessInstanceId());
        variableInstance.setActInstId(this.getExecution() != null ? this.getExecution().getCurrentActInstId() : null);
    }

    protected List<VariableInstanceEntity> loadVariableInstances() {
        return Context.getCommandContext().getVariableInstanceEntityManager().findVariableInstancesByTaskId(this.getId());
    }

    @Override
    public Map<String, VariableInstanceEntity> getVariableInstanceEntities() {
        this.ensureVariableInstancesInitialized();
        return this.variableInstances;
    }

    @Override
    protected VariableInstanceEntity createVariableInstance(String variableName, Object value, ExecutionEntity sourceActivityExecution) {
        VariableInstanceEntity result = super.createVariableInstance(variableName, value, sourceActivityExecution);
        return result;
    }

    @Override
    protected void updateVariableInstance(VariableInstanceEntity variableInstance, Object value, ExecutionEntity sourceActivityExecution) {
        super.updateVariableInstance(variableInstance, value, sourceActivityExecution);
    }

    @KSMethod
    public Map<String, Object> getTaskLocalVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (this.queryVariables != null) {
            for (VariableInstanceEntity variableInstance : this.queryVariables) {
                if (variableInstance.getId() == null || variableInstance.getTaskId() == null) continue;
                variables.put(variableInstance.getName(), variableInstance.getValue());
            }
        }
        return variables;
    }

    @KSMethod
    public Map<String, Object> getProcessVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (this.queryVariables != null) {
            for (VariableInstanceEntity variableInstance : this.queryVariables) {
                if (variableInstance.getId() == null || variableInstance.getTaskId() != null) continue;
                variables.put(variableInstance.getName(), variableInstance.getValue());
            }
        }
        return variables;
    }

    public void setQueryVariables(List<VariableInstanceEntity> queryVariables) {
        this.queryVariables = queryVariables;
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute(name="executionId")
    public Long getExecutionId() {
        return this.normalizeId(this.dynamicObject.getLong(EXECUTIONID));
    }

    @Override
    public void setExecutionId(Long executionId) {
        this.dynamicObject.set(EXECUTIONID, (Object)executionId);
    }

    @Override
    @KSMethod
    public ExecutionEntity getExecution() {
        if (this.execution == null && WfUtils.isNotEmpty(this.getExecutionId())) {
            this.execution = (ExecutionEntity)Context.getCommandContext().getExecutionEntityManager().findById(this.getExecutionId());
        }
        return this.execution;
    }

    @Override
    public void setExecution(ExecutionEntity execution) {
        this.execution = execution;
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute(name="processInstanceId")
    public Long getProcessInstanceId() {
        return this.normalizeId(this.dynamicObject.getLong(PROCESSINSTANCEID));
    }

    @Override
    public void setProcessInstanceId(Long processInstanceId) {
        this.dynamicObject.set(PROCESSINSTANCEID, (Object)processInstanceId);
    }

    @Override
    public ExecutionEntity getProcessInstance() {
        if (this.processInstance == null && WfUtils.isNotEmpty(this.getProcessInstanceId())) {
            this.processInstance = (ExecutionEntity)Context.getCommandContext().getExecutionEntityManager().findById(this.getProcessInstanceId());
        }
        return this.processInstance;
    }

    public void setProcessInstance(ExecutionEntity processInstance) {
        this.processInstance = processInstance;
    }

    @KSMethod
    @SimplePropertyAttribute(name="parentTaskId")
    public Long getParentTaskId() {
        return this.normalizeId(this.dynamicObject.getLong(PARENTTASKID));
    }

    @Override
    public void setParentTaskId(Long parentTaskId) {
        this.dynamicObject.set(PARENTTASKID, (Object)parentTaskId);
    }

    @Override
    public TaskEntity getParentTaskInstance() {
        if (this.parentTaskInstance == null && WfUtils.isNotEmpty(this.getParentTaskId())) {
            this.parentTaskInstance = (TaskEntity)Context.getCommandContext().getTaskEntityManager().findById(this.getParentTaskId());
        }
        return this.parentTaskInstance;
    }

    @Override
    public void setParentTaskInstance(TaskEntity parentTaskInstance) {
        this.parentTaskInstance = parentTaskInstance;
    }

    @Override
    public void addCandidateUser(Long userId) {
        Context.getCommandContext().getIdentityLinkEntityManager().addCandidateUser(this, userId);
    }

    @Override
    public void addCandidateUsers(Collection<Long> candidateUsers) {
        Context.getCommandContext().getIdentityLinkEntityManager().addCandidateUsers(this, candidateUsers);
    }

    @Override
    public Map<Long, IdentityLinkEntity> addUserIdentityLinks(List<Long> userIds, String identityLinkType) {
        Map<Long, IdentityLinkEntity> participantMap = Context.getCommandContext().getIdentityLinkEntityManager().addIdentityLinks(this, userIds, identityLinkType);
        for (Long userId : userIds) {
            if (userId <= 0L) continue;
            ILocaleString nameFormat = ParticipantHelper.getParticipantDisplayInfo((TaskEntity)this, Collections.singletonList(userId)).get(userId);
            IdentityLinkEntity participant = participantMap.get(userId);
            this.setOneParticipantName(userId, participant, nameFormat);
        }
        return participantMap;
    }

    @Override
    public IdentityLinkEntity addUserIdentityLink(Long userId, String identityLinkType) {
        IdentityLinkEntity participant = Context.getCommandContext().getIdentityLinkEntityManager().addUserIdentityLink(this, userId, identityLinkType);
        if (userId > 0L) {
            ILocaleString nameFormat = ParticipantHelper.getParticipantDisplayInfo((TaskEntity)this, Collections.singletonList(userId)).get(userId);
            this.setOneParticipantName(userId, participant, nameFormat);
        }
        return participant;
    }

    private void setOneParticipantName(Long userId, IdentityLinkEntity participant, ILocaleString nameFormat) {
        ILocaleString name = WfUtils.findUserName(userId);
        ILocaleString participantName = this.getParticipantName();
        ILocaleString participantNameFormat = participant.getUserNameFormatter();
        ILocaleString ret = null;
        if (WfConfigurationUtil.isDisplaySetting()) {
            LocaleString participantNameForSupportLangs = new LocaleString();
            for (Lang lang : WfUtils.getSupportLangs()) {
                String participantNameStr = participantName != null ? (String)participantName.getItem(lang.toString()) : "";
                participantNameForSupportLangs.put((Object)lang.toString(), (Object)participantNameStr);
            }
            if (WfUtils.isEmpty((ILocaleString)participantNameForSupportLangs)) {
                ret = nameFormat;
            } else {
                ret = new LocaleString();
                String newValueFormat = null;
                for (String key : participantNameFormat.keySet()) {
                    String valueFormat = participantName != null ? (String)participantName.get((Object)key) : "";
                    String newNameFormat = (String)nameFormat.get((Object)key);
                    if (!WfUtils.isNotEmpty(valueFormat) || !WfUtils.isNotEmpty(newNameFormat)) continue;
                    newValueFormat = String.format("%s,%s", valueFormat, newNameFormat);
                    ret.put((Object)key, (Object)newValueFormat);
                }
            }
        } else if (WfUtils.isEmpty(participantName)) {
            ret = name;
        } else {
            ret = participantName;
            String newValue = null;
            for (String key : ret.keySet()) {
                String value = (String)participantName.get((Object)key);
                String newName = (String)name.get((Object)key);
                if (!WfUtils.isNotEmpty(value) || !WfUtils.isNotEmpty(newName)) continue;
                newValue = String.format("%s,%s", value, newName);
                ret.put((Object)key, (Object)newValue);
            }
        }
        this.setParticipantName(ret);
        HistoricTaskInstanceEntity his = (HistoricTaskInstanceEntity)Context.getCommandContext().getHistoricTaskInstanceEntityManager().findById(this.getId());
        his.setParticipantName(ret);
    }

    @Override
    public Set<IdentityLink> getCandidates() {
        HashSet<IdentityLink> potentialOwners = new HashSet<IdentityLink>();
        for (IdentityLinkEntity identityLinkEntity : this.getIdentityLinks()) {
            if (!"participant".equals(identityLinkEntity.getType())) continue;
            potentialOwners.add(identityLinkEntity);
        }
        return potentialOwners;
    }

    @Override
    public void deleteUserIdentityLink(Long userId, String identityLinkType) {
        if (userId != null) {
            Context.getCommandContext().getIdentityLinkEntityManager().deleteIdentityLink(this, userId, identityLinkType);
            if (WfUtils.isNotEmpty(userId)) {
                ILocaleString name = WfUtils.findUserName(userId);
                ILocaleString participantName = this.getParticipantName();
                if (name != null && participantName != null) {
                    WfUtils.replaceLocaleString(participantName, name, "");
                    this.setParticipantName(participantName);
                    HistoricTaskInstanceEntity his = (HistoricTaskInstanceEntity)Context.getCommandContext().getHistoricTaskInstanceEntityManager().findById(this.getId());
                    his.setParticipantName(this.getParticipantName());
                }
            }
        }
    }

    @Override
    public List<IdentityLinkEntity> getIdentityLinks() {
        if (!this.identityLinksInitialized) {
            this.taskIdentityLinkEntities = Context.getCommandContext().getIdentityLinkEntityManager().findIdentityLinksByTaskId(this.getId());
            this.identityLinksInitialized = true;
        }
        return this.taskIdentityLinkEntities;
    }

    @Override
    protected boolean isActivityIdUsedForDetails() {
        return false;
    }

    @Override
    protected VariableInstanceEntity getSpecificVariable(String variableName) {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext == null) {
            throw new WFEngineException("lazy loading outside command context");
        }
        VariableInstanceEntity variableInstance = commandContext.getVariableInstanceEntityManager().findVariableInstanceByTaskAndName(this.getId(), variableName);
        return variableInstance;
    }

    @Override
    protected List<VariableInstanceEntity> getSpecificVariables(Collection<String> variableNames) {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext == null) {
            throw new WFEngineException("lazy loading outside command context");
        }
        return commandContext.getVariableInstanceEntityManager().findVariableInstancesByTaskAndNames(this.getId(), variableNames);
    }

    @Override
    public Map<String, AttributeModifyRecord> getAttributesModifyRecords() {
        return this.attributeModifyRecords;
    }

    @Override
    public void clearAttributesModifyRecords() {
        this.attributeModifyRecords = new HashMap<String, AttributeModifyRecord>();
    }

    private void gatherAttributeModifyRecord(String attribute, Object newValue) {
        this.gatherAttributeModifyRecord(this.dynamicObject, attribute, newValue);
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute(name="name")
    public ILocaleString getName() {
        return this.dynamicObject.getLocaleString(NAME);
    }

    public void setName(String taskName) {
        this.dynamicObject.set(NAME, (Object)WfUtils.subStringForMax(taskName, 500));
    }

    @Override
    public void setName(ILocaleString name) {
        this.dynamicObject.set(NAME, (Object)WfUtils.subILocaleString(name, 500));
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute(name="description")
    public ILocaleString getDescription() {
        return this.dynamicObject.getLocaleString(DESCRIPTION);
    }

    @Override
    public void setDescription(String description) {
        this.dynamicObject.set(DESCRIPTION, (Object)description);
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute(name="processDefinitionId")
    public Long getProcessDefinitionId() {
        return this.normalizeId(this.dynamicObject.getLong(PROCESSDEFINITIONID));
    }

    @Override
    public void setProcessDefinitionId(Long processDefinitionId) {
        this.dynamicObject.set(PROCESSDEFINITIONID, (Object)processDefinitionId);
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute(name="taskDefinitionKey")
    public String getTaskDefinitionKey() {
        return this.dynamicObject.getString(TASKDEFINITIONKEY);
    }

    @Override
    public void setTaskDefinitionKey(String taskDefinitionKey) {
        this.dynamicObject.set(TASKDEFINITIONKEY, (Object)taskDefinitionKey);
    }

    @KSMethod
    @Deprecated
    public String getAssignee() {
        return this.dynamicObject.getString(ASSIGNEE);
    }

    @SimplePropertyAttribute(name="assignee")
    public ILocaleString getTaskAssignee() {
        return this.dynamicObject.getLocaleString(ASSIGNEE);
    }

    @Override
    public void setAssignee(ILocaleString assignee) {
        this.dynamicObject.set(ASSIGNEE, (Object)assignee);
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute(name="owner")
    public String getOwner() {
        return this.dynamicObject.getString(OWNER);
    }

    @Override
    public void setOwner(String owner) {
        this.dynamicObject.set(OWNER, (Object)owner);
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute(name="category")
    public String getCategory() {
        return this.dynamicObject.getString(CATEGORY);
    }

    @Override
    public void setCategory(String category) {
        this.dynamicObject.set(CATEGORY, (Object)category);
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute(name="formKey")
    public String getFormKey() {
        return this.dynamicObject.getString(FORMKEY);
    }

    @Override
    public void setFormKey(String formKey) {
        this.dynamicObject.set(FORMKEY, (Object)formKey);
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute(name="dueDate")
    public Date getDueDate() {
        return this.dynamicObject.getDate(DUEDATE);
    }

    @Override
    public void setDueDate(Date dueDate) {
        this.dynamicObject.set(DUEDATE, (Object)dueDate);
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute(name="claimTime")
    public Date getClaimTime() {
        return this.dynamicObject.getDate(CLAIMTIME);
    }

    @Override
    public void setClaimTime(Date claimTime) {
        this.dynamicObject.set(CLAIMTIME, (Object)claimTime);
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute(name="priority")
    public int getPriority() {
        return this.dynamicObject.getInt(PRIORITY);
    }

    @Override
    public void setPriority(int priority) {
        this.dynamicObject.set(PRIORITY, (Object)priority);
    }

    @Override
    @SimplePropertyAttribute(name="delegationState")
    public String getDelegationState() {
        return this.dynamicObject.getString(DELEGATIONSTATE);
    }

    @Override
    public void setDelegationState(String delegationState) {
        this.dynamicObject.set(DELEGATIONSTATE, (Object)delegationState);
    }

    @Override
    @SimplePropertyAttribute(name="suspensionState")
    public String getSuspensionState() {
        return this.dynamicObject.getString(SUSPENSIONSTATE);
    }

    @Override
    public void setSuspensionState(String suspensionState) {
        this.dynamicObject.set(SUSPENSIONSTATE, (Object)suspensionState);
    }

    @Override
    public boolean isSuspended() {
        return !this.getSuspensionState().equals(ManagementConstants.ACTIVE.getStateCode());
    }

    @Override
    @SimplePropertyAttribute(name="display")
    public boolean isDisplay() {
        return this.dynamicObject.getBoolean(DISPLAY);
    }

    @Override
    public void setDisplay(boolean isDisplay) {
        this.gatherAttributeModifyRecord(DISPLAY, isDisplay);
        this.dynamicObject.set(DISPLAY, (Object)isDisplay);
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute(name="starterId")
    public Long getStarterId() {
        return this.normalizeId(this.dynamicObject.getLong(STARTERID));
    }

    @Override
    public void setStarterId(Long starterId) {
        this.dynamicObject.set(STARTERID, (Object)starterId);
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute(name="senderId")
    public String getSenderId() {
        return this.dynamicObject.getString(SENDERID);
    }

    @Override
    public void setSenderId(String senderId) {
        this.dynamicObject.set(SENDERID, (Object)senderId);
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute(name="entityName")
    public ILocaleString getEntityName() {
        return this.dynamicObject.getLocaleString(ENTITYNAME);
    }

    @Override
    public void setEntityName(ILocaleString entityName) {
        this.dynamicObject.set(ENTITYNAME, (Object)entityName);
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute(name="subject")
    public ILocaleString getSubject() {
        return this.dynamicObject.getLocaleString(SUBJECT);
    }

    public void setSubject(String subject) {
        this.dynamicObject.set(SUBJECT, (Object)BPMNUtil.getInterceptedString(subject, 1000));
    }

    public void setSubject(ILocaleString subject) {
        this.dynamicObject.set(SUBJECT, (Object)BPMNUtil.subStringSubject(subject));
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute(name="assigneeId")
    public Long getAssigneeId() {
        return this.normalizeId(this.dynamicObject.getLong(ASSIGNEEID));
    }

    @Override
    public void setAssigneeId(Long assigneeId) {
        this.dynamicObject.set(ASSIGNEEID, (Object)assigneeId);
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute(name="ownerId")
    public Long getOwnerId() {
        return this.normalizeId(this.dynamicObject.getLong(OWNERID));
    }

    @Override
    public void setOwnerId(Long ownerId) {
        this.dynamicObject.set(OWNERID, (Object)ownerId);
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute(name="executionType")
    public String getExecutionType() {
        return this.dynamicObject.getString(EXECUTIONTYPE);
    }

    @Override
    public void setExecutionType(String executionType) {
        this.dynamicObject.set(EXECUTIONTYPE, (Object)executionType);
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute(name="entityNumber")
    public String getEntityNumber() {
        return this.dynamicObject.getString(ENTITYNUMBER);
    }

    @Override
    public void setEntityNumber(String entityNumber) {
        this.dynamicObject.set(ENTITYNUMBER, (Object)entityNumber);
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute(name="businessKey")
    public String getBusinessKey() {
        return this.dynamicObject.getString(BUSINESSKEY);
    }

    @Override
    public void setBusinessKey(String businessKey) {
        this.dynamicObject.set(BUSINESSKEY, (Object)businessKey);
    }

    @Override
    @SimplePropertyAttribute(name="yzjGroupId")
    public String getYzjGroupId() {
        return this.dynamicObject.getString(YZJGROUPID);
    }

    @Override
    public void setYzjGroupId(String yzjGroupId) {
        this.dynamicObject.set(YZJGROUPID, (Object)yzjGroupId);
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute(name="processingPage")
    public String getProcessingPage() {
        return this.dynamicObject.getString(PROCESSINGPAGE);
    }

    public void setProcessingPage(String processingPage) {
        this.dynamicObject.set(PROCESSINGPAGE, (Object)processingPage);
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute(name="processingMobilePage")
    public String getProcessingMobilePage() {
        return this.dynamicObject.getString(PROCESSINGMOBILEPAGE);
    }

    public void setProcessingMobilePage(String processingMobilePage) {
        this.dynamicObject.set(PROCESSINGMOBILEPAGE, (Object)processingMobilePage);
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute(name="senderName")
    public ILocaleString getSenderName() {
        return this.dynamicObject.getLocaleString(SENDERNAME);
    }

    @Override
    public void setSenderName(ILocaleString senderName) {
        this.dynamicObject.set(SENDERNAME, (Object)senderName);
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute(name="startName")
    public ILocaleString getStartName() {
        return this.dynamicObject.getLocaleString(STARTERNAME);
    }

    @Override
    public void setStartName(ILocaleString startName) {
        this.dynamicObject.set(STARTERNAME, (Object)startName);
    }

    @Override
    public void setStartNameFormat(ILocaleString startNameFormat) {
        this.dynamicObject.set(STARTNAMEFORMAT, (Object)WfUtils.subILocaleString(startNameFormat, 490));
    }

    @Override
    public ILocaleString getStartNameFormat() {
        return this.dynamicObject.getLocaleString(STARTNAMEFORMAT);
    }

    @Override
    public void setSenderNameFormat(ILocaleString senderNameFormat) {
        this.dynamicObject.set(SENDERNAMEFORMAT, (Object)WfUtils.subILocaleString(senderNameFormat, 490));
    }

    @Override
    public ILocaleString getSenderNameFormat() {
        return this.dynamicObject.getLocaleString(SENDERNAMEFORMAT);
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute(name="handleState")
    public String getHandleState() {
        return this.dynamicObject.getString(HANDLESTATE);
    }

    public void setHandleState(String handleState) {
        this.dynamicObject.set(HANDLESTATE, (Object)handleState);
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute(name="mobileFormKey")
    public String getMobileFormKey() {
        return this.dynamicObject.getString(MOBILEFORMKEY);
    }

    public void setMobileFormKey(String mobileFormKey) {
        this.dynamicObject.set(MOBILEFORMKEY, (Object)mobileFormKey);
    }

    @Override
    @SimplePropertyAttribute(name="active")
    public boolean isActive() {
        return this.dynamicObject.getBoolean(ACTIVE);
    }

    @Override
    public void setActive(boolean active) {
        this.dynamicObject.set(ACTIVE, (Object)active);
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute(name="billNo")
    public String getBillNo() {
        return this.dynamicObject.getString(BILLNO);
    }

    @Override
    public void setBillNo(String billNo) {
        this.dynamicObject.set(BILLNO, (Object)billNo);
    }

    public void setSubactivityname(String subactivityname) {
        this.dynamicObject.set(SUBACTIVITYNAME, (Object)subactivityname);
    }

    @Override
    @SimplePropertyAttribute(name="subactivityname")
    public ILocaleString getSubactivityname() {
        return this.dynamicObject.getLocaleString(SUBACTIVITYNAME);
    }

    @Override
    public void setEndType(String endType) {
        this.dynamicObject.set(ENDTYPE, (Object)endType);
    }

    @Override
    @SimplePropertyAttribute(name="endType")
    public String getEndType() {
        return this.dynamicObject.getString(ENDTYPE);
    }

    @Override
    @KSMethod
    public String getEventName() {
        return this.eventName;
    }

    @Override
    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    @Override
    public ActivitiListener getCurrentActivitiListener() {
        return this.currentActivitiListener;
    }

    @Override
    public void setCurrentActivitiListener(ActivitiListener currentActivitiListener) {
        this.currentActivitiListener = currentActivitiListener;
    }

    @KSMethod
    public boolean isFromHistory() {
        return this.fromHistory;
    }

    public String toString() {
        return "Task[id=" + this.getId() + ", name=" + this.getName() + "]";
    }

    @Override
    @KSMethod
    public String getCurrentWFPlugin() {
        return this.wfPlugin;
    }

    @Override
    public void setCurrentWFPlugin(String implementation) {
        this.wfPlugin = implementation;
    }

    @Override
    @KSMethod
    public Map<String, Object> getCurrentWFPluginParams() {
        return this.wfPluginParams;
    }

    @Override
    public void setCurrentWFPluginParams(Map<String, Object> wfPluginParams) {
        this.wfPluginParams = wfPluginParams;
    }

    @KSMethod
    public Set<Long> getParticipants() {
        HashSet<Long> userIds = new HashSet<Long>();
        if (BpmnModelUtil.instanceofYunzhijiaTask(this.getCategory()) && WfUtils.isEmpty(this.getParentTaskId())) {
            String ids = (String)this.getVariableLocal("teamMembers");
            if (WfUtils.isNotEmpty(ids)) {
                return new HashSet<Long>(WfUtils.stringToCollection(ids, ","));
            }
        } else if (this.getIdentityLinks() != null && this.getIdentityLinks().size() > 0) {
            for (IdentityLinkEntity u : this.getIdentityLinks()) {
                if (userIds.contains(u.getUserId())) continue;
                userIds.add(u.getUserId());
            }
        }
        return userIds;
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute(name="participantName")
    public ILocaleString getParticipantName() {
        return this.dynamicObject.getLocaleString(PARTICIPANTNAME);
    }

    @KSMethod
    public ILocaleString getAllParticipantName() {
        if (BpmnModelUtil.instanceofYunzhijiaTask(this.getCategory()) && WfUtils.isEmpty(this.getParentTaskId())) {
            String ids = (String)this.getVariableLocal("teamMemberNames");
            if (WfUtils.isNotEmpty(ids)) {
                LocaleString ret = (LocaleString)SerializationUtils.fromJsonString((String)ids, LocaleString.class);
                return ret;
            }
            return null;
        }
        return this.dynamicObject.getLocaleString(PARTICIPANTNAME);
    }

    @Override
    public void setParticipantName(ILocaleString participantName) {
        this.dynamicObject.set(PARTICIPANTNAME, (Object)WfUtils.subILocaleString(participantName, 490));
    }

    @Override
    public void setSource(String source) {
        this.dynamicObject.set(SOURCE, (Object)source);
    }

    @Override
    @SimplePropertyAttribute(name="source")
    public String getSource() {
        return this.dynamicObject.getString(SOURCE);
    }

    @Override
    @SimplePropertyAttribute(name="validateoperation")
    public String getValidateOperation() {
        return this.dynamicObject.getString(VALIDATEOPERATION);
    }

    @Override
    public void setValidateOperation(String validate) {
        this.dynamicObject.set(VALIDATEOPERATION, (Object)validate);
    }

    @Override
    @SimplePropertyAttribute(name="groupnumber")
    public Long getGroupNumber() {
        Object groupNumber = this.dynamicObject.get(TOHANDLEGROUPNO);
        if (groupNumber instanceof DynamicObject) {
            return ((DynamicObject)groupNumber).getLong("id");
        }
        return this.dynamicObject.getLong(TOHANDLEGROUPNO);
    }

    @Override
    public void setGroupNumber(Long number) {
        this.dynamicObject.set(TOHANDLEGROUPNO, (Object)number);
    }

    @Override
    @SimplePropertyAttribute(name="batchOp")
    public String getBatchOp() {
        return this.dynamicObject.getString(BATCHOP);
    }

    @Override
    public void setBatchOp(String batchOp) {
        this.dynamicObject.set(BATCHOP, (Object)batchOp);
    }

    @Override
    @SimplePropertyAttribute(name="biztraceno")
    public String getBizTraceNo() {
        return this.dynamicObject.getString(BIZTRACENO);
    }

    @Override
    public void setBizTraceNo(String bizTraceNo) {
        this.dynamicObject.set(BIZTRACENO, (Object)bizTraceNo);
    }

    @Override
    public void setBillType(String billType) {
        this.dynamicObject.set(BILLTYPE, (Object)billType);
    }

    @Override
    @SimplePropertyAttribute(name="billType")
    public String getBillType() {
        return this.dynamicObject.getString(BILLTYPE);
    }

    @Override
    public void setOrgUnitId(Long id) {
        this.dynamicObject.set(ORGUNITID, (Object)id);
    }

    @Override
    @SimplePropertyAttribute(name="orgUnitId")
    public Long getOrgUnitId() {
        return this.dynamicObject.getLong(ORGUNITID);
    }

    @Override
    @SimplePropertyAttribute(name="orgviewid")
    public String getOrgViewId() {
        return this.dynamicObject.getString(ORGVIEWID);
    }

    @Override
    public void setOrgViewId(String orgViewId) {
        this.dynamicObject.set(ORGVIEWID, (Object)orgViewId);
    }

    @Override
    @SimplePropertyAttribute(name="processtype")
    public String getProcessType() {
        return this.dynamicObject.getString(PROCESSTYPE);
    }

    @Override
    public void setProcessType(String processType) {
        this.dynamicObject.set(PROCESSTYPE, (Object)processType);
    }

    @Override
    @SimplePropertyAttribute(name="control")
    public String getControl() {
        return this.dynamicObject.getString(CONTROL);
    }

    @Override
    public void setControl(String control) {
        this.dynamicObject.set(CONTROL, (Object)control);
    }

    @Override
    @SimplePropertyAttribute(name="biz_date")
    public Date getBusinessDate() {
        return this.dynamicObject.getDate(BUSINESS_DATE);
    }

    @Override
    public void setBusinessDate(Date businessDate) {
        this.dynamicObject.set(BUSINESS_DATE, (Object)businessDate);
    }

    @Override
    @SimplePropertyAttribute(name="biz_number")
    public double getBusinessNumber() {
        return this.dynamicObject.getBigDecimal(BUSINESS_NUMBER).doubleValue();
    }

    @Override
    public void setBusinessNumber(double businessNumber) {
        this.dynamicObject.set(BUSINESS_NUMBER, (Object)businessNumber);
    }

    @Override
    @SimplePropertyAttribute(name="bizformat")
    public String getBusinessFormat() {
        return this.dynamicObject.getString(BUSINESS_FORMAT);
    }

    @Override
    public void setBusinessFormat(String businessFormat) {
        this.dynamicObject.set(BUSINESS_FORMAT, (Object)businessFormat);
    }

    @Override
    @SimplePropertyAttribute(name="biz_str1")
    public String getBusinessStr1() {
        return this.dynamicObject.getString(BUSINESS_STR1);
    }

    @Override
    public void setBusinessStr1(String businessStr1) {
        this.dynamicObject.set(BUSINESS_STR1, (Object)businessStr1);
    }

    @Override
    @SimplePropertyAttribute(name="biz_str2")
    public String getBusinessStr2() {
        return this.dynamicObject.getString(BUSINESS_STR2);
    }

    @Override
    public void setBusinessStr2(String businessStr2) {
        this.dynamicObject.set(BUSINESS_STR2, (Object)businessStr2);
    }

    @Override
    @SimplePropertyAttribute(name="biz_date2")
    public Date getBusinessDate2() {
        return this.dynamicObject.getDate(BUSINESS_DATE2);
    }

    @Override
    public void setBusinessDate2(Date businessDate) {
        this.dynamicObject.set(BUSINESS_DATE2, (Object)businessDate);
    }

    @Override
    @SimplePropertyAttribute(name="biz_number2")
    public double getBusinessNumber2() {
        return this.dynamicObject.getBigDecimal(BUSINESS_NUMBER2).doubleValue();
    }

    @Override
    public void setBusinessNumber2(double businessNumber) {
        this.dynamicObject.set(BUSINESS_NUMBER2, (Object)businessNumber);
    }

    @Override
    @SimplePropertyAttribute(name="biz_strmul1")
    public ILocaleString getBusinessMulStr1() {
        return this.dynamicObject.getLocaleString(BUSINESS_MULSTR1);
    }

    @Override
    public void setBusinessMulStr1(ILocaleString businessStr) {
        this.dynamicObject.set(BUSINESS_MULSTR1, (Object)businessStr);
    }

    @Override
    @SimplePropertyAttribute(name="biz_strmul2")
    public ILocaleString getBusinessMulStr2() {
        return this.dynamicObject.getLocaleString(BUSINESS_MULSTR2);
    }

    @Override
    public void setBusinessMulStr2(ILocaleString businessStr) {
        this.dynamicObject.set(BUSINESS_MULSTR2, (Object)businessStr);
    }

    @Override
    public void setCaptionPC(ILocaleString captionPC) {
        this.dynamicObject.set("captionpc", (Object)captionPC);
    }

    @SimplePropertyAttribute(name="captionpc")
    public ILocaleString getCaptionPC() {
        return this.dynamicObject.getLocaleString("captionpc");
    }

    @Override
    public void setCaptionMob(ILocaleString captionMob) {
        this.dynamicObject.set("captionmob", (Object)captionMob);
    }

    @SimplePropertyAttribute(name="captionmob")
    public ILocaleString getCaptionMob() {
        return this.dynamicObject.getLocaleString("captionmob");
    }

    public boolean isBizTask() {
        return TaskUtils.isBizTask(this.getSource());
    }

    @Override
    public void setTaskState(String taskState) {
        this.gatherAttributeModifyRecord(TASKSTATE, taskState);
        this.dynamicObject.set(TASKSTATE, (Object)taskState);
    }

    @Override
    @SimplePropertyAttribute(name="taskstate")
    public String getTaskState() {
        return this.dynamicObject.getString(TASKSTATE);
    }

    @Override
    public void setResourceId(String resourceId) {
        this.dynamicObject.set("resourceid", (Object)resourceId);
    }

    @Override
    @SimplePropertyAttribute(name="resourceid")
    public String getResourceId() {
        return this.dynamicObject.getString("resourceid");
    }

    @Override
    public void setSourceName(ILocaleString sourceName) {
        this.dynamicObject.set("sourcename", (Object)sourceName);
    }

    @Override
    @SimplePropertyAttribute(name="sourcename")
    public ILocaleString getSourceName() {
        return this.dynamicObject.getLocaleString("sourcename");
    }

    @Override
    public void setUrl(String url) {
        this.dynamicObject.set(URL, (Object)url);
    }

    @Override
    @SimplePropertyAttribute(name="url")
    public String getUrl() {
        return this.dynamicObject.getString(URL);
    }

    @Override
    public void setMobileUrl(String mobileUrl) {
        this.dynamicObject.set(MOBILEURL, (Object)mobileUrl);
    }

    @Override
    @SimplePropertyAttribute(name="mobileurl")
    public String getMobileUrl() {
        return this.dynamicObject.getString(MOBILEURL);
    }
}

