/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.event.ActivitiEventDispatcher;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntityManager;
import kd.bos.workflow.engine.task.AttributeModifyRecord;

public class TaskHandleLogEntityManagerImpl
extends AbstractEntityManager<TaskHandleLogEntity>
implements TaskHandleLogEntityManager {
    public TaskHandleLogEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public Class<? extends TaskHandleLogEntity> getManagedEntityClass() {
        return TaskHandleLogEntityImpl.class;
    }

    @Override
    public String getSelectFields() {
        return "id,ownerId,assigneeid,opinion,taskId,assignee,type,status,scenes,createDate,modifyDate,subscribe,processDefinitionId,processInstanceId,businessKey,billNo,activityid,activityname,bizidentifykey,note,terminalway,owner,ownerformat,assigneeformat,isadminforward,currentsubject,originalparticipant,entityname,groupnumber,biztraceno,startname,startnameformat,presentassignee,endtime,display,endtype,processtype,executiontype,priority,compositetaskid,sendername,sendernameformat,taskstate,source,biztype,delegateid,sourcename";
    }

    @Override
    public String getEntityName() {
        return "wf_taskhandlelog";
    }

    @Override
    public void insert(TaskHandleLogEntity entity) {
        this.insert(entity, true);
    }

    @Override
    public void insert(TaskHandleLogEntity entity, boolean fireCreateEvent) {
        TaskEntity task;
        if (WfUtils.isNotEmpty(entity.getTaskId()) && (task = (TaskEntity)this.getTaskEntityManager().findById(entity.getTaskId())) != null) {
            if (WfUtils.isEmpty(entity.getCurrentSubject())) {
                entity.setCurrentSubject(task.getSubject());
            }
            entity.setEntityName(task.getEntityName());
            entity.setStartName(task.getStartName());
            entity.setStartNameFormat(task.getStartNameFormat());
            entity.setDisplay(task.isDisplay());
            entity.setEndType(task.getEndType());
            entity.setProcessType(task.getProcessType());
            entity.setExecutionType(task.getExecutionType());
            entity.setSenderName(task.getSenderName());
            entity.setSenderNameFormat(task.getSenderNameFormat());
            entity.setTaskState(task.getTaskState());
            entity.setSource(task.getSource());
            entity.setSourceName(task.getSourceName());
            entity.setBizType(task.getYzjGroupId());
            entity.setBizTraceNo(task.getBizTraceNo());
            entity.setGroupNumber(task.getGroupNumber());
            List linkEntities = this.getIdentityLinkEntityManager().findByQueryFilters(new QFilter[]{new QFilter("taskid", "=", (Object)entity.getTaskId()), new QFilter("userid", "=", (Object)entity.getOwnerId())});
            if (linkEntities != null && linkEntities.size() > 0) {
                entity.setPriority(((IdentityLinkEntity)linkEntities.get(0)).getPriority());
                entity.setCompositeTaskId(((IdentityLinkEntity)linkEntities.get(0)).getCompositeTaskId());
            }
        }
        if (WfUtils.isEmpty(entity.getScenes())) {
            entity.setScenes("task");
        }
        this.getDbSqlSession().insert(entity);
        ActivitiEventDispatcher eventDispatcher = this.getEventDispatcher();
        if (eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_CREATED, entity));
        }
    }

    @Override
    public List<TaskHandleLogEntity> findEntitiesByTaskIdAndType(Long taskId, String type) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("taskId", "=", taskId).addFilter("type", "=", type).orderBy("createDate");
        return this.findByQueryBuilder(eb);
    }

    @Override
    public List<TaskHandleLogEntity> getTaskHandleLogs(Long taskId, String orderBy, String ... types) {
        EntityQueryBuilder queryBuilder = this.createQueryBuilder().addFilter("taskId", "=", taskId).addFilter("isadminforward", "=", Boolean.FALSE);
        if (WfUtils.isEmpty(orderBy)) {
            queryBuilder.orderBy(String.format("%s ASC, %s ASC", "createDate", "id"));
        } else {
            queryBuilder.orderBy(orderBy);
        }
        if (types != null && types.length > 0) {
            if (types.length == 1) {
                queryBuilder.addFilter("type", "=", types[0]);
            } else {
                queryBuilder.addFilter("type", "in", types);
            }
        }
        return this.findByQueryBuilder(queryBuilder);
    }

    @Override
    public List<TaskHandleLogEntity> getUserTaskTransferLogs(Long taskId, Long userId) {
        List<TaskHandleLogEntity> entities;
        EntityQueryBuilder queryBuilder = this.createQueryBuilder().addFilter("taskId", taskId).addFilter("type", "transfer").addFilter("isadminforward", Boolean.FALSE).orderBy(String.format("%s DESC, %s DESC", "createDate", "id"));
        boolean hasUserId = WfUtils.isNotEmpty(userId);
        if (hasUserId) {
            queryBuilder.addFilter("scenes", "task");
        }
        if ((entities = this.findByQueryBuilder(queryBuilder)).isEmpty() || !hasUserId) {
            return entities;
        }
        ArrayList<TaskHandleLogEntity> result = new ArrayList<TaskHandleLogEntity>();
        for (TaskHandleLogEntity entity : entities) {
            if (userId.equals(entity.getAssigneeid())) {
                userId = entity.getOwnerId();
                result.add(entity);
                continue;
            }
            if (!userId.equals(entity.getOwnerId())) continue;
            result.add(entity);
            break;
        }
        return result;
    }

    @Override
    public TaskHandleLogEntity getTaskLatestTransferLog(Long taskId, Long userId) {
        EntityQueryBuilder queryBuilder = this.createQueryBuilder().addFilter("taskId", taskId).addFilter("assigneeid", userId).addFilter("isadminforward", Boolean.FALSE).addFilter("type", "transfer").addFilter("scenes", "task").orderBy(String.format("%s DESC, %s DESC", "createDate", "id"));
        List entities = this.findByQueryBuilder(queryBuilder);
        if (entities == null || entities.isEmpty()) {
            return null;
        }
        return (TaskHandleLogEntity)entities.get(0);
    }

    @Override
    public Map<String, TaskHandleLogEntity> getTasksLatestTransferLogs(Map<Long, Long> idMap) {
        HashMap<String, TaskHandleLogEntity> ret = new HashMap<String, TaskHandleLogEntity>();
        EntityQueryBuilder queryBuilder = this.createQueryBuilder().addFilter("isadminforward", Boolean.FALSE).addFilter("taskId", "in", idMap.keySet()).addFilter("type", "transfer").addFilter("scenes", "task").orderBy(String.format("%s ASC", "createDate"));
        List entities = this.findByQueryBuilder(queryBuilder);
        if (entities == null || entities.isEmpty()) {
            return ret;
        }
        for (TaskHandleLogEntity entity : entities) {
            Long taskId = entity.getTaskId();
            Long userId = entity.getAssigneeid();
            if (!idMap.get(taskId).equals(userId)) continue;
            ret.put(String.format("%s-%s", taskId, userId), entity);
        }
        return ret;
    }

    @Override
    public void deleteEntitiesByTaskHandleLogIds(List<Long> taskHandleLogIds) {
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", taskHandleLogIds)};
        this.deleteByFilters(qFilters);
    }

    @Override
    public void deleteByFilters(QFilter[] qFilters) {
        List taskHandleLogEntities = this.findByQueryFilters(qFilters);
        for (TaskHandleLogEntity taskHandleLogEntity : taskHandleLogEntities) {
            this.delete(taskHandleLogEntity);
        }
    }

    @Override
    public void delete(Long id) {
        TaskHandleLogEntity entity = (TaskHandleLogEntity)this.findById(id);
        if (entity != null) {
            this.delete(entity);
        }
    }

    @Override
    public void delete(TaskHandleLogEntity entity) {
        this.delete(entity, true);
    }

    @Override
    public void delete(TaskHandleLogEntity entity, boolean fireDeleteEvent) {
        if (entity == null) {
            return;
        }
        boolean isTwiceDelete = entity.isDeleted();
        this.getDbSqlSession().delete(entity);
        ActivitiEventDispatcher eventDispatcher = this.getEventDispatcher();
        if (this.getEventDispatcher().isEnabled() && !isTwiceDelete) {
            eventDispatcher.dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_DELETED, entity));
        }
    }

    @Override
    public boolean isOperationChangeHisNodeAssignee(Long taskId, Long assigneeId) {
        QFilter[] qFilters = new QFilter[]{new QFilter("taskId", "=", (Object)taskId), new QFilter("type", "=", (Object)"transfer"), new QFilter("scenes", "=", (Object)"task"), new QFilter("assigneeid", "=", (Object)assigneeId)};
        return QueryServiceHelper.exists((String)this.getEntityName(), (QFilter[])qFilters);
    }

    @Override
    public void updateTaskHandleByTaskId(Map<String, AttributeModifyRecord> records, Long taskId) {
        List<TaskHandleLogEntity> taskHandleLogEntities;
        Boolean display;
        String handleState = records.get("handleState") == null ? null : (String)records.get("handleState").getNewValue();
        String taskState = records.get("taskstate") == null ? null : (String)records.get("taskstate").getNewValue();
        String executionType = records.get("executionType") == null ? null : (String)records.get("executionType").getNewValue();
        boolean updateEndTime = records.get("endTime") != null;
        Date endTime = records.get("endTime") == null ? null : (Date)records.get("endTime").getNewValue();
        ILocaleString presentAssignee = records.get("presentassignee") == null ? null : (ILocaleString)records.get("presentassignee").getNewValue();
        Boolean bl = display = records.get("display") == null ? null : (Boolean)records.get("display").getNewValue();
        if (taskState != null || display != null) {
            taskHandleLogEntities = this.findByQueryFilters(new QFilter[]{new QFilter("taskid", "=", (Object)taskId)});
            for (TaskHandleLogEntity taskHandleLogEntity2 : taskHandleLogEntities) {
                if (taskState != null) {
                    taskHandleLogEntity2.setTaskState(taskState);
                }
                if (display != null) {
                    taskHandleLogEntity2.setDisplay(display);
                }
                this.update(taskHandleLogEntity2);
            }
        }
        if ((executionType != null || handleState != null || updateEndTime || presentAssignee != null) && (taskHandleLogEntities = this.findByQueryFilters(new QFilter[]{new QFilter("taskid", "=", (Object)taskId)})) != null && taskHandleLogEntities.size() > 0) {
            taskHandleLogEntities.forEach(taskHandleLogEntity -> {
                if (executionType != null) {
                    taskHandleLogEntity.setExecutionType(executionType);
                }
                if (handleState != null) {
                    taskHandleLogEntity.setTaskState(handleState);
                }
                if (updateEndTime) {
                    taskHandleLogEntity.setEndTime(endTime);
                    if (endTime == null) {
                        taskHandleLogEntity.setDisplay(true);
                    }
                }
                if (presentAssignee != null) {
                    taskHandleLogEntity.setPresentAssignee(presentAssignee);
                }
                this.update(taskHandleLogEntity);
            });
        }
    }

    @Override
    public void updateTaskHandleByTaskIdAndUserId(Map<String, AttributeModifyRecord> records, Long taskId, Long userId) {
        Long compositeTaskId;
        Long l = compositeTaskId = records.get("compositetaskid") == null ? null : (Long)records.get("compositetaskid").getNewValue();
        if (compositeTaskId == null) {
            return;
        }
        List taskHandleLogEntities = this.findByQueryFilters(new QFilter[]{new QFilter("taskid", "=", (Object)taskId), new QFilter("userid", "=", (Object)userId)});
        if (taskHandleLogEntities != null && taskHandleLogEntities.size() > 0) {
            for (TaskHandleLogEntity taskHandleLogEntity : taskHandleLogEntities) {
                if (compositeTaskId != null) {
                    taskHandleLogEntity.setCompositeTaskId(compositeTaskId);
                }
                this.update(taskHandleLogEntity);
            }
        }
    }

    @Override
    public void deleteTaskHandleLogByTaskId(Long taskId) {
        QFilter[] qFilters = new QFilter[]{new QFilter("taskid", "=", (Object)taskId)};
        this.deleteByFilters(qFilters);
    }
}

