/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.task;

import java.util.List;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskMarkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskMarkEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskMarkEntityManager;

public class TaskMarkEntityManagerImpl
extends AbstractEntityManager<TaskMarkEntity>
implements TaskMarkEntityManager {
    public TaskMarkEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public Class<? extends TaskMarkEntity> getManagedEntityClass() {
        return TaskMarkEntityImpl.class;
    }

    @Override
    public String getSelectFields() {
        return "userid,name,number,categoryname,categorynumber,color,icon,value";
    }

    @Override
    public String getEntityName() {
        return "wf_taskmark";
    }

    @Override
    public List<TaskMarkEntity> getTaskMarksByUserIdAndType(Long userId, String categorynumber) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("categorynumber", "=", categorynumber);
        List<TaskMarkEntity> entitys = this.findByQueryBuilder(eb);
        return entitys;
    }

    @Override
    public TaskMarkEntity getReminderMark(String categorynumber) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("categorynumber", "=", categorynumber);
        List entitys = this.findByQueryBuilder(eb);
        if (entitys != null && entitys.size() > 0) {
            return (TaskMarkEntity)entitys.get(0);
        }
        return null;
    }

    @Override
    public TaskMarkEntity getTaskMarkEntityByNumber(String number) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("number", "=", number);
        List entitys = this.findByQueryBuilder(eb);
        if (entitys != null && entitys.size() > 0) {
            return (TaskMarkEntity)entitys.get(0);
        }
        return null;
    }
}

