/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.task;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.extitf.ExtItfCallerType;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.CachedEntityMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.CommentsByTaskIdMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.ThirdCommentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.ThirdCommentEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.ThirdCommentEntityManager;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;

public class ThirdCommentEntityManagerImpl
extends AbstractEntityManager<ThirdCommentEntity>
implements ThirdCommentEntityManager {
    public static final int STARTSTEP = 9;
    protected CachedEntityMatcher<CommentEntity> commentsByTaskIdMatcher = new CommentsByTaskIdMatcher();

    public ThirdCommentEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public ThirdCommentEntity create() {
        return new ThirdCommentEntityImpl();
    }

    @Override
    public ThirdCommentEntity create(DynamicObject dynamicObject) {
        return new ThirdCommentEntityImpl(dynamicObject);
    }

    @Override
    public String getEntityName() {
        return "wf_trdhicomment";
    }

    @Override
    public String getSelectFields() {
        return "id,type,userId,taskId,processInstanceId,activityId,message,resultNumber,resultName,time,assignee,decisionType,groupId,backToBack,activityName,subactivityname,entityNumber,businessKey,ownerId,source,sourcename,bizidentifykey,step,usernameformatter,terminalway,assignorname,sourcesystem,sourceapp,ispublic,subprocessinstanceid,signature";
    }

    @Override
    public void insert(ThirdCommentEntity trdCommentEntity) {
        TaskEntity entity;
        ILocaleString activityName = trdCommentEntity.getNodeName();
        if (WfUtils.isEmpty(activityName)) {
            CommandContext commandContext = Context.getCommandContext();
            Long proinstId = trdCommentEntity.getProcessInstanceId();
            HistoricProcessInstanceEntity processInstanceEntity = (HistoricProcessInstanceEntity)commandContext.getHistoricProcessInstanceEntityManager().findById(proinstId);
            if (processInstanceEntity != null) {
                String activityId;
                Long processDefinitionId = processInstanceEntity.getProcessDefinitionId();
                BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(processDefinitionId, proinstId);
                FlowElement element = bpmnModel.getMainProcess().getFlowElement(trdCommentEntity.getActivityId(), true);
                if (element instanceof UserTask) {
                    String bizIdentifyKey = ((UserTask)element).getBizIdentifyKey();
                    if (WfUtils.isNotEmpty(bizIdentifyKey)) {
                        trdCommentEntity.setBizIdentifyKey(bizIdentifyKey);
                    }
                    String resultNumber = trdCommentEntity.getResultNumber();
                    String resultName = trdCommentEntity.getResultName();
                    if (WfUtils.isEmpty(resultName)) {
                        List decisionOptions = element.getDecisionOptions();
                        for (DecisionOption decision : decisionOptions) {
                            if (!resultNumber.equalsIgnoreCase(decision.getNumber())) continue;
                            String designMultiKey = BpmnModelUtil.getDecisionNameMultiKey(element.getId(), decision.getId());
                            ILocaleString decisionName = BpmnModelUtil.getMultiLangFieldValue(proinstId, designMultiKey, decision.getName());
                            trdCommentEntity.setResultName(decisionName);
                            break;
                        }
                    }
                }
                if (WfUtils.isNotEmpty(activityId = trdCommentEntity.getActivityId())) {
                    String multiKey = BpmnModelUtil.getActivityNameMultiKey(activityId);
                    trdCommentEntity.setActivityName(BpmnModelUtil.getMultiLangFieldValue(proinstId, multiKey, element.getName()));
                }
                if (element instanceof YunzhijiaTask) {
                    YunzhijiaTask yunzhijiaTask = (YunzhijiaTask)element;
                    trdCommentEntity.setBackToBack(yunzhijiaTask.getBackToBackVote());
                }
            }
        }
        if (WfUtils.isNotEmpty(trdCommentEntity.getTaskId()) && (entity = (TaskEntity)this.getTaskEntityManager().findById(trdCommentEntity.getTaskId())) != null) {
            trdCommentEntity.setBusinessKey(entity.getBusinessKey());
            trdCommentEntity.setEntityNumber(entity.getEntityNumber());
        }
        this.insert(trdCommentEntity, false);
        if (this.getEventDispatcher().isEnabled()) {
            ExecutionEntity process;
            Long processDefinitionId = null;
            Long processInstanceId = trdCommentEntity.getProcessInstanceId();
            if (trdCommentEntity.getProcessInstanceId() != null && (process = (ExecutionEntity)this.getExecutionEntityManager().findById(trdCommentEntity.getProcessInstanceId())) != null) {
                processDefinitionId = process.getProcessDefinitionId();
            }
            this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_CREATED, trdCommentEntity, processInstanceId, processInstanceId, processDefinitionId));
            this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_INITIALIZED, trdCommentEntity, processInstanceId, processInstanceId, processDefinitionId));
        }
    }

    @Override
    public int calculateStep(Long processInstanceId) {
        int step = 9;
        String sql = "SELECT fstep FROM t_wf_trdhicomment WHERE fprocinstid = ? ORDER BY fstep DESC";
        Object[] params = new Object[]{processInstanceId};
        try (DataSet ds = DB.queryDataSet((String)"wf.calculateStep", (DBRoute)DBRoute.workflow, (String)sql, (Object[])params);){
            Iterator iter = ds.iterator();
            if (iter.hasNext()) {
                Row row = (Row)iter.next();
                step = Math.max(step, row.getInteger("fstep"));
            }
        }
        return ++step;
    }

    @Override
    public Class<? extends ThirdCommentEntity> getManagedEntityClass() {
        return ThirdCommentEntityImpl.class;
    }

    @Override
    public List<CommentEntity> findApprovalRecordByAuth(QFilter[] qfs, String orderBy) {
        List comments = this.findByQueryFilters(qfs, this.getSelectFields() + "," + "richTextMessage", orderBy);
        if (comments == null) {
            return null;
        }
        if (comments.isEmpty()) {
            return new ArrayList<CommentEntity>(0);
        }
        CommentEntity comment = (CommentEntity)comments.get(0);
        String entityNumber = comment.getEntityNumber();
        String plugin = this.fetchPlugin(entityNumber);
        if (StringUtils.isBlank((CharSequence)plugin)) {
            return new ArrayList<CommentEntity>(comments);
        }
        Object o = ExternalInterfaceUtil.executeExtItf(ExtItfCallerType.FILTERAPPROVALRECORDBYAUTH, plugin, comments);
        List res = (List)o;
        return res;
    }

    private String fetchPlugin(String entityNumber) {
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            return "";
        }
        String plugin = WfConfigurationUtil.fetchFilterApprovalRecordPlugin(entityNumber);
        if (StringUtils.isNotBlank((CharSequence)plugin)) {
            return plugin;
        }
        return this.fetchPluginByBillSubjectModel(entityNumber);
    }

    private String fetchPluginByBillSubjectModel(String entityNumber) {
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            return "";
        }
        QFilter qFilter = new QFilter("entitynumber", "=", (Object)entityNumber);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"wf_billsubjectmodel", (String)"id,filterapprovalrecordplg", (QFilter[])qFilter.toArray());
        if (dynamicObject == null) {
            return "";
        }
        String plugin = dynamicObject.getString("filterapprovalrecordplg");
        if (StringUtils.isEmpty((CharSequence)plugin)) {
            return "";
        }
        return plugin;
    }

    @Override
    public void delete(Long taskId) {
        List thirdCommentEntities = this.findByQueryFilters(new QFilter[]{new QFilter("taskid", "=", (Object)taskId)});
        if (thirdCommentEntities != null && !thirdCommentEntities.isEmpty()) {
            for (ThirdCommentEntity thirdCommentEntity : thirdCommentEntities) {
                this.delete(thirdCommentEntity, true);
            }
        }
    }
}

