/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.separatestorage;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.thread.ThreadTruck;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.separatestorage.EntityTableMappingModel;
import kd.bos.workflow.engine.impl.persistence.separatestorage.SeparateStorageType;
import kd.bos.workflow.engine.impl.persistence.separatestorage.SeparateStorageUtil;

public class EntityMappingConvertFactory {
    private static EntityMappingConvertFactory instance;
    private Map<String, EntityTableMappingModel> entityNumberMap = new HashMap<String, EntityTableMappingModel>(16);
    private Map<String, EntityTableMappingModel> tableNameMap = new HashMap<String, EntityTableMappingModel>(16);

    private EntityMappingConvertFactory() {
        this.initEntityMappingList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EntityMappingConvertFactory get() {
        if (instance != null) {
            return instance;
        }
        Class<EntityMappingConvertFactory> clazz = EntityMappingConvertFactory.class;
        synchronized (EntityMappingConvertFactory.class) {
            if (instance == null) {
                instance = new EntityMappingConvertFactory();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public String convertEntityNumber(String entityNumber) {
        String separateStorageKey = (String)ThreadTruck.get((Object)"separateStorageKey");
        return this.convertEntityNumber(entityNumber, separateStorageKey);
    }

    public String convertEntityNumber(String entityNumber, String separateStorageKey) {
        Map<String, String> sEntityNumberMap;
        if (!WfConfigurationUtil.enableSeparateStorage() || StringUtils.isBlank((CharSequence)separateStorageKey) || SeparateStorageType.ORIGINAL.getKey().equals(separateStorageKey)) {
            return entityNumber;
        }
        EntityTableMappingModel model = this.entityNumberMap.get(entityNumber);
        if (model != null && WfUtils.isNotEmptyForMap(sEntityNumberMap = model.getSeparateEntityNumberMap())) {
            return StringUtils.isNotBlank((CharSequence)sEntityNumberMap.get(separateStorageKey)) ? sEntityNumberMap.get(separateStorageKey) : entityNumber;
        }
        return entityNumber;
    }

    public String convertTableName(String tableName) {
        String separateStorageKey = (String)ThreadTruck.get((Object)"separateStorageKey");
        return this.convertTableName(tableName, separateStorageKey);
    }

    public String convertTableName(String tableName, String separateStorageKey) {
        Map<String, String> sTableNameMap;
        if (!WfConfigurationUtil.enableSeparateStorage() || StringUtils.isBlank((CharSequence)separateStorageKey) || SeparateStorageType.ORIGINAL.getKey().equals(separateStorageKey)) {
            return tableName;
        }
        EntityTableMappingModel model = this.tableNameMap.get(tableName);
        if (model != null && WfUtils.isNotEmptyForMap(sTableNameMap = model.getSeparateTableNameMap())) {
            return StringUtils.isNotBlank((CharSequence)sTableNameMap.get(separateStorageKey)) ? sTableNameMap.get(separateStorageKey) : tableName;
        }
        return tableName;
    }

    public Map<String, String> getAllConvertedEntityNumber(String entityNumber) {
        HashMap<String, String> result = new HashMap<String, String>();
        List<String> storageKeys = SeparateStorageUtil.getSeparateStorageKeys();
        storageKeys.forEach(key -> result.put((String)key, this.convertEntityNumber(entityNumber, (String)key)));
        return result;
    }

    private void initEntityMappingList() {
        HashMap<String, String> hiProcInstEntityNumberMap = new HashMap<String, String>(1);
        hiProcInstEntityNumberMap.put(SeparateStorageType.NOCODE.getKey(), "wf_nocode_hiprocinst");
        HashMap<String, String> hiProcInstTableNameMap = new HashMap<String, String>(1);
        hiProcInstTableNameMap.put(SeparateStorageType.NOCODE.getKey(), "t_wf_nocode_hiprocinst");
        EntityTableMappingModel hiProcInstMappingModel = new EntityTableMappingModel("wf_hiprocinst", "t_wf_hiprocinst", hiProcInstEntityNumberMap, hiProcInstTableNameMap);
        this.entityNumberMap.put("wf_hiprocinst", hiProcInstMappingModel);
        this.tableNameMap.put("t_wf_hiprocinst", hiProcInstMappingModel);
        HashMap<String, String> hiTaskInstEntityNumberMap = new HashMap<String, String>(1);
        hiTaskInstEntityNumberMap.put(SeparateStorageType.NOCODE.getKey(), "wf_nocode_hitaskinst");
        HashMap<String, String> hiTaskInstTableNameMap = new HashMap<String, String>(1);
        hiTaskInstTableNameMap.put(SeparateStorageType.NOCODE.getKey(), "t_wf_nocode_hitaskinst");
        EntityTableMappingModel hiTaskInstMappingModel = new EntityTableMappingModel("wf_hitaskinst", "t_wf_hitaskinst", hiTaskInstEntityNumberMap, hiTaskInstTableNameMap);
        this.entityNumberMap.put("wf_hitaskinst", hiTaskInstMappingModel);
        this.tableNameMap.put("t_wf_hitaskinst", hiTaskInstMappingModel);
        HashMap<String, String> hiActInstEntityNumberMap = new HashMap<String, String>(1);
        hiActInstEntityNumberMap.put(SeparateStorageType.NOCODE.getKey(), "wf_nocode_hiactinst");
        HashMap<String, String> hiActInstTableNameMap = new HashMap<String, String>(1);
        hiActInstTableNameMap.put(SeparateStorageType.NOCODE.getKey(), "t_wf_nocode_hiactinst");
        EntityTableMappingModel hiActInstMappingModel = new EntityTableMappingModel("wf_hiactinst", "t_wf_hiactinst", hiActInstEntityNumberMap, hiActInstTableNameMap);
        this.entityNumberMap.put("wf_hiactinst", hiActInstMappingModel);
        this.tableNameMap.put("t_wf_hiactinst", hiActInstMappingModel);
        HashMap<String, String> hiIdentityLinkEntityNumberMap = new HashMap<String, String>(1);
        hiIdentityLinkEntityNumberMap.put(SeparateStorageType.NOCODE.getKey(), "wf_nocode_hiparticipant");
        HashMap<String, String> hiIdentityLinkTableNameMap = new HashMap<String, String>(1);
        hiIdentityLinkTableNameMap.put(SeparateStorageType.NOCODE.getKey(), "t_wf_nocode_hiparticipant");
        EntityTableMappingModel hiIdentityLinkMappingModel = new EntityTableMappingModel("wf_hiparticipant", "t_wf_hiparticipant", hiIdentityLinkEntityNumberMap, hiIdentityLinkTableNameMap);
        this.entityNumberMap.put("wf_hiparticipant", hiIdentityLinkMappingModel);
        this.tableNameMap.put("t_wf_hiparticipant", hiIdentityLinkMappingModel);
        HashMap<String, String> hiVarInstEntityNumberMap = new HashMap<String, String>(1);
        hiVarInstEntityNumberMap.put(SeparateStorageType.NOCODE.getKey(), "wf_nocode_hivarinst");
        HashMap<String, String> hiVarInstTableNameMap = new HashMap<String, String>(1);
        hiVarInstTableNameMap.put(SeparateStorageType.NOCODE.getKey(), "t_wf_nocode_hivarinst");
        EntityTableMappingModel hiVarInstMappingModel = new EntityTableMappingModel("wf_hivarinst", "t_wf_hivarinst", hiVarInstEntityNumberMap, hiVarInstTableNameMap);
        this.entityNumberMap.put("wf_hivarinst", hiVarInstMappingModel);
        this.tableNameMap.put("t_wf_hivarinst", hiVarInstMappingModel);
        HashMap<String, String> hiUserActInstEntityNumberMap = new HashMap<String, String>(1);
        hiUserActInstEntityNumberMap.put(SeparateStorageType.NOCODE.getKey(), "wf_nocode_hiuseractinst");
        HashMap<String, String> hiUserActInstTableNameMap = new HashMap<String, String>(1);
        hiUserActInstTableNameMap.put(SeparateStorageType.NOCODE.getKey(), "t_wf_nocode_hiuseractinst");
        EntityTableMappingModel hiUserActInstMappingModel = new EntityTableMappingModel("wf_hiuseractinst", "t_wf_hiuseractinst", hiUserActInstEntityNumberMap, hiUserActInstTableNameMap);
        this.entityNumberMap.put("wf_hiuseractinst", hiUserActInstMappingModel);
        this.tableNameMap.put("t_wf_hiuseractinst", hiUserActInstMappingModel);
        HashMap<String, String> commentEntityNumberMap = new HashMap<String, String>(1);
        commentEntityNumberMap.put(SeparateStorageType.NOCODE.getKey(), "wf_nocode_hicomment");
        HashMap<String, String> commentEntityTableNameMap = new HashMap<String, String>(1);
        commentEntityTableNameMap.put(SeparateStorageType.NOCODE.getKey(), "t_wf_nocode_hicomment");
        EntityTableMappingModel commentEntityMappingModel = new EntityTableMappingModel("wf_hicomment", "t_wf_hicomment", commentEntityNumberMap, commentEntityTableNameMap);
        this.entityNumberMap.put("wf_hicomment", commentEntityMappingModel);
        this.tableNameMap.put("t_wf_hicomment", commentEntityMappingModel);
        HashMap<String, String> hiDynResourceEntityNumberMap = new HashMap<String, String>(1);
        hiDynResourceEntityNumberMap.put(SeparateStorageType.NOCODE.getKey(), "wf_nocode_hidynresource");
        HashMap<String, String> hiDynResourceTableNameMap = new HashMap<String, String>(1);
        hiDynResourceTableNameMap.put(SeparateStorageType.NOCODE.getKey(), "t_wf_nocode_hidynresource");
        EntityTableMappingModel hiDynResourceMappingModel = new EntityTableMappingModel("wf_hidynamicresource", "t_wf_hidynresource", hiDynResourceEntityNumberMap, hiDynResourceTableNameMap);
        this.entityNumberMap.put("wf_hidynamicresource", hiDynResourceMappingModel);
        this.tableNameMap.put("t_wf_hidynresource", hiDynResourceMappingModel);
        HashMap<String, String> taskJobEntityNumberMap = new HashMap<String, String>(1);
        taskJobEntityNumberMap.put(SeparateStorageType.NOCODE.getKey(), "wf_nocode_taskjob");
        HashMap<String, String> taskJobTableNameMap = new HashMap<String, String>(1);
        taskJobTableNameMap.put(SeparateStorageType.NOCODE.getKey(), "t_wf_nocode_taskjob");
        EntityTableMappingModel taskJobMappingModel = new EntityTableMappingModel("wf_taskjob", "t_wf_taskjob", taskJobEntityNumberMap, taskJobTableNameMap);
        this.entityNumberMap.put("wf_taskjob", taskJobMappingModel);
        this.tableNameMap.put("t_wf_taskjob", taskJobMappingModel);
    }
}

