/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.separatestorage;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.feature.taskfield.util.TaskExtendFieldUtil;

public class FieldNameAliasMapper {
    private static final String ENDTIME = "endtime";
    private static final String CREATEDATE = "createdate";
    private static final String SENDERNAME = "sendername";
    private static final String HANDLESTATE = "handlestate";
    private static final String SUBJECT = "subject";
    private static final String STARTNAME = "startname";
    private static final String ENTITYNAME = "entityname";
    private static final String BILLNO = "billno";
    private static final String PRESENTASSIGNEE = "presentassignee";
    private static final String B_FENTRABILLNAME = "b.fentrabillname";
    private static final String B_FSUBJECT = "b.FSUBJECT";
    private static final String PROANDVERSION = "proandversion";
    private static final String SUBJECTSHOW = "subjectshow";
    private static final String ENTRABILLNAMESHOW = "entrabillnameshow";
    private static Map<String, Map<String, String>> fieldNameAliasMap = new HashMap<String, Map<String, String>>();
    private static Map<String, Map<String, String>> aliasFieldNameMap = new HashMap<String, Map<String, String>>();

    public static Map<String, String> getFieldNameAliasMap(String type) {
        if (WfUtils.isEmptyForMap(fieldNameAliasMap)) {
            FieldNameAliasMapper.init();
        }
        return fieldNameAliasMap.get(type);
    }

    public static Map<String, String> getAliasFieldNameMap(String type) {
        if (WfUtils.isEmptyForMap(aliasFieldNameMap)) {
            FieldNameAliasMapper.init();
        }
        return aliasFieldNameMap.get(type);
    }

    private static void init() {
        HashMap<String, String> handledFieldNameAliasMap = new HashMap<String, String>();
        handledFieldNameAliasMap.put("id", "a.fid");
        handledFieldNameAliasMap.put(CREATEDATE, "a.fcreatedate");
        handledFieldNameAliasMap.put(ENDTIME, "a.fendtime");
        handledFieldNameAliasMap.put(BILLNO, "a.fbillno");
        handledFieldNameAliasMap.put("entitynumber", "a.FENTITYNUMBER");
        handledFieldNameAliasMap.put(SUBJECT, SUBJECT);
        handledFieldNameAliasMap.put(ENTITYNAME, ENTITYNAME);
        handledFieldNameAliasMap.put(STARTNAME, STARTNAME);
        handledFieldNameAliasMap.put(HANDLESTATE, "a.fhandlestate");
        handledFieldNameAliasMap.put(SENDERNAME, SENDERNAME);
        handledFieldNameAliasMap.put("name", "name");
        handledFieldNameAliasMap.put(PRESENTASSIGNEE, "a.fpresentassignee");
        if (WfConfigurationUtil.isHiTaskSingleTableQuery().booleanValue() && WfConfigurationUtil.isUpdateHiTaskToHiCommentComplete().booleanValue()) {
            handledFieldNameAliasMap.put(ENDTIME, "a.ftime");
            handledFieldNameAliasMap.putAll(FieldNameAliasMapper.getTaskBusinessSelectFields("wf_hicomment", "a", "f", "b"));
        } else {
            handledFieldNameAliasMap.putAll(FieldNameAliasMapper.getTaskBusinessSelectFields("wf_hitaskinst", "a", "f", "b"));
        }
        fieldNameAliasMap.put("handled", handledFieldNameAliasMap);
        aliasFieldNameMap.put("handled", FieldNameAliasMapper.getExchangeKeyValueResult(handledFieldNameAliasMap));
        HashMap<String, String> applyedFieldNameAliasMap = new HashMap<String, String>();
        applyedFieldNameAliasMap.put("id", "a.fid");
        applyedFieldNameAliasMap.put(CREATEDATE, "a.fcreatedate");
        applyedFieldNameAliasMap.put(ENDTIME, "a.fendtime");
        applyedFieldNameAliasMap.put("entitynumber", "a.FENTITYNUMBER");
        applyedFieldNameAliasMap.put(SUBJECTSHOW, B_FSUBJECT);
        applyedFieldNameAliasMap.put(ENTRABILLNAMESHOW, B_FENTRABILLNAME);
        applyedFieldNameAliasMap.put("handletime", "a.fduration");
        applyedFieldNameAliasMap.put(PROANDVERSION, "b.FNAME");
        applyedFieldNameAliasMap.put(BILLNO, "a.fbillno");
        fieldNameAliasMap.put("applyed", applyedFieldNameAliasMap);
        aliasFieldNameMap.put("applyed", FieldNameAliasMapper.getExchangeKeyValueResult(applyedFieldNameAliasMap));
    }

    private static Map<String, String> getExchangeKeyValueResult(Map<String, String> sourceMap) {
        HashMap<String, String> targetMap = new HashMap<String, String>(sourceMap.size());
        sourceMap.forEach((key, value) -> targetMap.put((String)value, (String)key));
        return targetMap;
    }

    private static Map<String, String> getTaskBusinessSelectFields(String entityNumber, String tableAlias, String tableGroupAlias, String mulAlias) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (WfUtils.isNotEmpty(entityNumber)) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            Map allFields = dataEntityType.getAllFields();
            Boolean allowExtendTaskFields = WfConfigurationUtil.isAllowExtendTaskFields();
            for (Map.Entry entry : allFields.entrySet()) {
                if (!TaskExtendFieldUtil.isBusinessMappingField((IDataEntityProperty)entry.getValue()) && (!allowExtendTaskFields.booleanValue() || !TaskExtendFieldUtil.isBusinessMappingExtField((IDataEntityProperty)entry.getValue()))) continue;
                IDataEntityProperty property = (IDataEntityProperty)entry.getValue();
                String alias = tableAlias;
                if (entry.getValue() instanceof MuliLangTextProp) {
                    alias = mulAlias;
                }
                if (((IDataEntityProperty)entry.getValue()).getTableGroup() != null) {
                    alias = tableGroupAlias;
                }
                String field = alias != null ? alias + "." + property.getAlias() : property.getAlias();
                map.put((String)entry.getKey(), field);
            }
        }
        return map;
    }
}

