/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.repository;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.orm.ORM;
import kd.bos.workflow.engine.impl.RepositoryServiceImpl;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.DeploymentEntity;
import kd.bos.workflow.engine.repository.Deployment;
import kd.bos.workflow.engine.repository.DeploymentBuilder;
import kd.bos.workflow.exception.WFIllegalArgumentException;

public class DeploymentBuilderImpl
implements DeploymentBuilder,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final String DEFAULT_ENCODING = "UTF-8";
    protected transient RepositoryServiceImpl repositoryService;
    protected transient ResourceEntityManager resourceEntityManager;
    protected transient DeploymentEntity deployment;
    protected boolean bpmn20XsdValidationEnabled = true;
    protected boolean processValidationEnabled = true;
    protected boolean duplicateFilterEnabled;
    protected boolean processDefinitionsActivated = false;
    protected Date processDefinitionsActivationDate;
    protected transient Map<String, Object> deploymentProperties = new HashMap<String, Object>();

    public DeploymentBuilderImpl(RepositoryServiceImpl repositoryService) {
        this.repositoryService = repositoryService;
        this.deployment = (DeploymentEntity)Context.getProcessEngineConfiguration().getDeploymentEntityManager().create();
        this.resourceEntityManager = Context.getProcessEngineConfiguration().getResourceEntityManager();
    }

    @Override
    public DeploymentBuilder addString(String resourceName, String text) {
        if (text == null) {
            throw new WFIllegalArgumentException("text is null");
        }
        ResourceEntity resource = (ResourceEntity)this.resourceEntityManager.create();
        resource.setName(resourceName);
        resource.setData(text);
        this.deployment.addResource(resource);
        return this;
    }

    @Override
    public DeploymentBuilder addString(String resourceName, Long modelId, ResourceEntity resource) {
        if (resource == null) {
            throw new WFIllegalArgumentException("resource is null");
        }
        ResourceEntity resourceEntity = (ResourceEntity)this.resourceEntityManager.create();
        Long id = ORM.create().genLongId("wf_resource");
        resourceEntity.setId(id);
        resourceEntity.setModelId(modelId);
        resourceEntity.setName(resourceName);
        resourceEntity.setDeploymentId(resource.getDeploymentId());
        resourceEntity.setData(resource.getData());
        resourceEntity.setGenerated(resource.isGenerated());
        resourceEntity.setCurrentLanguage(resource.getCurrentLanguage());
        resourceEntity.setContent(resource.getContent());
        this.deployment.addResource(resourceEntity);
        return this;
    }

    @Override
    public DeploymentBuilder addBytes(String resourceName, byte[] bytes) {
        if (bytes == null) {
            throw new WFIllegalArgumentException("bytes is null");
        }
        ResourceEntity resource = (ResourceEntity)this.resourceEntityManager.create();
        resource.setName(resourceName);
        try {
            resource.setData(new String(bytes, StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException e) {
            throw new WFIllegalArgumentException(Arrays.toString(bytes));
        }
        this.deployment.addResource(resource);
        return this;
    }

    @Override
    public DeploymentBuilder name(String name) {
        this.deployment.setName(name);
        return this;
    }

    @Override
    public DeploymentBuilder category(String category) {
        this.deployment.setCategory(category);
        return this;
    }

    @Override
    public DeploymentBuilder key(String key) {
        this.deployment.setKey(key);
        return this;
    }

    @Override
    public DeploymentBuilder disableBpmnValidation() {
        this.processValidationEnabled = false;
        return this;
    }

    @Override
    public DeploymentBuilder disableSchemaValidation() {
        this.bpmn20XsdValidationEnabled = false;
        return this;
    }

    @Override
    public DeploymentBuilder enableDuplicateFiltering() {
        this.duplicateFilterEnabled = true;
        return this;
    }

    @Override
    public DeploymentBuilder activateProcessDefinitionsOn(Date date) {
        this.processDefinitionsActivationDate = date;
        return this;
    }

    @Override
    public DeploymentBuilder deploymentProperty(String propertyKey, Object propertyValue) {
        this.deploymentProperties.put(propertyKey, propertyValue);
        return this;
    }

    @Override
    public Deployment deploy() {
        return this.repositoryService.deploy(this);
    }

    public DeploymentEntity getDeployment() {
        return this.deployment;
    }

    public boolean isProcessValidationEnabled() {
        return this.processValidationEnabled;
    }

    public boolean isBpmn20XsdValidationEnabled() {
        return this.bpmn20XsdValidationEnabled;
    }

    public boolean isDuplicateFilterEnabled() {
        return this.duplicateFilterEnabled;
    }

    public Date getProcessDefinitionsActivationDate() {
        return this.processDefinitionsActivationDate;
    }

    public Map<String, Object> getDeploymentProperties() {
        return this.deploymentProperties;
    }

    public boolean isProcessDefinitionsActivated() {
        return this.processDefinitionsActivated;
    }

    @Override
    public void activateProcessDefinitions() {
        this.processDefinitionsActivated = true;
    }
}

