/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.util;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.workflow.bizflow.util.BizFlowUtil;
import kd.bos.workflow.bpmn.model.AutoTask;
import kd.bos.workflow.bpmn.model.BillCloseConfig;
import kd.bos.workflow.bpmn.model.BillRelationshipModel;
import kd.bos.workflow.bpmn.model.BillTask;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.IEntitySupport;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.StartEvent;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.WaitCloseOperation;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.bpm.calculator.BillCalculatorExecutor;
import kd.bos.workflow.engine.impl.bpm.calculator.billrelation.BillRelationHelper;
import kd.bos.workflow.engine.impl.bpmn.behavior.TaskBehaviorUtil;
import kd.bos.workflow.engine.impl.cmd.monitor.RecoverProcessInstanceCmd;
import kd.bos.workflow.engine.impl.cmd.startup.BusinessModelVariableScope;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.log.builder.AddressLogger;
import kd.bos.workflow.engine.impl.model.ProcessDefinitionStartInfo;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.DeadLetterJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionInfoEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityManager;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.condition.ConditionUtil;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFMountException;

public class AddressProcessUtils {
    private static Log logger = LogFactory.getLog(AddressProcessUtils.class);

    public static ProcessDefinitionStartInfo address(CommandContext commandContext, DynamicObject businessModel, String operation, Long parentProcDefId) {
        return AddressProcessUtils.address(commandContext, businessModel, operation, parentProcDefId, null);
    }

    public static ProcessDefinitionStartInfo address(CommandContext commandContext, DynamicObject businessModel, String operation, Long parentProcDefId, Long processDefinitionId) {
        StringBuilder sb = new StringBuilder();
        ProcessDefinitionStartInfo processDefinitionInfo = null;
        AddressLogger addressLogger = AddressLogger.get(commandContext);
        try {
            sb.append(String.format("AddressProcess-start:args[%s,%s,%s,%s,%s];", businessModel.getDataEntityType().getName(), businessModel.getPkValue(), operation, parentProcDefId, WfConfigurationUtil.isFindTheOnlyProcess()));
            boolean processAddressByOrg = WfConfigurationUtil.isProcessAddressByOrg();
            addressLogger.logAddressByOrgStatus(processAddressByOrg);
            if (processAddressByOrg) {
                sb.append(String.format(ResManager.loadKDString((String)"\u5bfb\u5740\u7c7b\u578b\uff1a%s;", (String)"AddressProcessUtils_1", (String)"bos-wf-engine", (Object[])new Object[0]), "PROCESSADDRESSBYORG"));
                processDefinitionInfo = AddressProcessUtils.findProcdefByOrg(commandContext, businessModel, operation, parentProcDefId, sb, processDefinitionId);
            } else {
                sb.append(String.format(ResManager.loadKDString((String)"\u5bfb\u5740\u7c7b\u578b\uff1a%s;", (String)"AddressProcessUtils_1", (String)"bos-wf-engine", (Object[])new Object[0]), "normal"));
                processDefinitionInfo = AddressProcessUtils.findAppropriateProcessDefinitionInfo(commandContext, businessModel, operation, parentProcDefId, sb, processDefinitionId);
            }
        }
        catch (Exception e) {
            sb.append("\r\n").append(WfUtils.getExceptionStacktrace(e));
            logger.error(sb.toString());
            throw e;
        }
        return processDefinitionInfo;
    }

    public static void restartAddress(CommandContext commandContext, String businessKey, String operation, String entityNumber, Map<String, Object> variables, Long processDefinitionId, Long procInstId, DynamicObject businessModel) {
        AddressLogger addressLogger = AddressLogger.get(commandContext);
        if (variables.get("nextNodeId") != null && "dynBackToRejectNode".equals(variables.get("dynType")) && WfConfigurationUtil.isNotNeedRestartByRejectBackToNode()) {
            return;
        }
        ProcessDefinitionStartInfo processDefinition = AddressProcessUtils.address(commandContext, businessModel, operation, (Long)variables.get("parentProcDefId"), processDefinitionId);
        addressLogger.logEnteredProcess(processDefinition);
        if (processDefinition == null) {
            return;
        }
        HashMap<String, Object> target = new HashMap<String, Object>();
        target.put("id", processDefinition.getId());
        target.put("number", processDefinition.getNumber());
        target.put("version", processDefinition.getVersion());
        target.put("processType", processDefinition.getProcessType());
        BusinessModelVariableScope bizScope = new BusinessModelVariableScope(businessModel);
        Long schemeId = BpmnModelUtil.filterSchemeByCondition(commandContext, target, bizScope);
        if (processDefinition.getId().equals(processDefinitionId)) {
            if (!WfConfigurationUtil.restartAddressByTime()) {
                return;
            }
            ExecutionEntity procinst = commandContext.getExecutionEntityManager().findProcessInstanceById(procInstId);
            if (procinst == null || WfUtils.isEmpty(schemeId) || schemeId.equals(procinst.getSchemeId())) {
                logger.info("\u9a73\u56de\u91cd\u65b0\u5bfb\u5740\u6ca1\u6709\u627e\u5230\u65b9\u6848id\u6216\u8005\u4e0e\u4e4b\u524d\u7684\u65b9\u6848id\u76f8\u540c\uff1a" + schemeId);
                return;
            }
        }
        variables.put("newprocessdefinitionid", processDefinition.getId());
        variables.put("newschmeid", schemeId);
    }

    private static ProcessDefinitionStartInfo findAppropriateProcessDefinitionInfo(CommandContext commandContext, DynamicObject businessModel, String operation, Long parentProcDefId, StringBuilder sb) {
        return AddressProcessUtils.findAppropriateProcessDefinitionInfo(commandContext, businessModel, operation, parentProcDefId, sb, null);
    }

    private static ProcessDefinitionStartInfo findAppropriateProcessDefinitionInfo(CommandContext commandContext, DynamicObject businessModel, String operation, Long parentProcDefId, StringBuilder sb, Long processDefinitionId) {
        ProcessDefinitionStartInfo curProcess;
        AddressLogger addressLogger = AddressLogger.get(commandContext);
        String entityNumber = businessModel.getDataEntityType().getName();
        String businessKey = String.valueOf(businessModel.getPkValue());
        QFilter[] filters = new QFilter[]{new QFilter("businessKey", "=", (Object)businessKey), new QFilter("endTime", "is null", null)};
        List hiPorcInsts = commandContext.getHistoricProcessInstanceEntityManager().findByQueryFilters(filters);
        HashSet<Long> procDefIds = new HashSet<Long>(hiPorcInsts.size());
        for (HistoricProcessInstanceEntity h : hiPorcInsts) {
            if (h.getProcessDefinitionId().equals(processDefinitionId)) continue;
            procDefIds.add(h.getProcessDefinitionId());
        }
        BusinessModelVariableScope bizScope = new BusinessModelVariableScope(businessModel);
        if (!WfConfigurationUtil.restartAddressByTime() && WfUtils.isNotEmpty(processDefinitionId) && (curProcess = commandContext.getProcessDefinitionEntityManager().findStartInfoByDefinitionId(processDefinitionId)) != null) {
            String startCondition = curProcess.getStartCondition();
            if (WfUtils.isEmpty(startCondition)) {
                return curProcess;
            }
            String key = String.format("BizFlow: %s: entityNumber: %s, businessKey: %s, operation: %s", "addressProcess", entityNumber, businessKey, operation);
            bizScope.setVariable("processDefinitionId", curProcess.getId());
            String billNo = TaskBehaviorUtil.getTaskBillNo(entityNumber, businessModel);
            bizScope.setVariable("processName", billNo + '/' + curProcess.getNumber() + '/' + curProcess.getVersion());
            boolean ret = ConditionUtil.hasTrueCondition(startCondition, (VariableScope)bizScope, key);
            if (ret) {
                return curProcess;
            }
        }
        List<ProcessDefinitionStartInfo> infos = commandContext.getProcessDefinitionEntityManager().findLatestEnabledProcessDefinitions(entityNumber, operation, parentProcDefId);
        sb.append(String.format(ResManager.loadKDString((String)"\u5de5\u4f5c\u6d41\u6309\u7167\u5355\u636e\u548c\u64cd\u4f5c\u8fc7\u6ee4\u51fa\u6d41\u7a0b[%s]\u4e2a\uff1a", (String)"AddressProcessUtils_31", (String)"bos-wf-engine", (Object[])new Object[0]), infos.size()));
        if (infos.isEmpty()) {
            return null;
        }
        boolean onlyOne = WfConfigurationUtil.isFindTheOnlyProcess();
        addressLogger.logFindTheOnlyProcessStatus(onlyOne);
        ProcessDefinitionStartInfo startInfo = null;
        ProcessDefinitionStartInfo startInfoWithCondition = null;
        ArrayList<ProcessDefinitionStartInfo> startInfos = new ArrayList<ProcessDefinitionStartInfo>(infos.size());
        ArrayList<ProcessDefinitionStartInfo> startInfoWithConditions = new ArrayList<ProcessDefinitionStartInfo>(infos.size());
        ProcessDefinitionStartInfo bizStartInfo = null;
        for (ProcessDefinitionStartInfo info : infos) {
            String key;
            if (procDefIds.contains(info.getId())) continue;
            if (ModelType.BizFlow.name().equals(info.getProcessType())) {
                sb.append(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u6d41\u7a0b[%1$s]\u7684\u542f\u52a8\u6761\u4ef6\u4e3a[%2$s]\uff0c", (String)"AddressProcessUtils_2", (String)"bos-wf-engine", (Object[])new Object[0]), info.getNumber(), info.getStartCondition()));
                if (WfUtils.isEmpty(info.getStartCondition())) {
                    if (bizStartInfo == null) {
                        sb.append(String.format(ResManager.loadKDString((String)"\u65e0\u6761\u4ef6\u542f\u52a8\u7684\u4e1a\u52a1\u6d41\u7a0b\u4e3a[%s] \uff01", (String)"AddressProcessUtils_3", (String)"bos-wf-engine", (Object[])new Object[0]), info.getNumber()));
                        bizStartInfo = info;
                    }
                    addressLogger.logAlternativeProcesses(info);
                    continue;
                }
                key = String.format("BizFlow: %s: entityNumber: %s, businessKey: %s, operation: %s", "addressProcess", entityNumber, businessKey, operation);
                bizScope.setVariable("processDefinitionId", info.getId());
                String billNo = TaskBehaviorUtil.getTaskBillNo(entityNumber, businessModel);
                bizScope.setVariable("processName", billNo + '/' + info.getNumber() + '/' + info.getVersion());
                boolean ret = ConditionUtil.hasTrueCondition(info.getStartCondition(), (VariableScope)bizScope, key);
                addressLogger.logAlternativeProcesses(info, ret, bizScope);
                if (!ret) continue;
                sb.append(String.format(ResManager.loadKDString((String)"\u6ee1\u8db3\u542f\u52a8\u6761\u4ef6\u7684\u4e1a\u52a1\u6d41\u7a0b\u4e3a[%s] \uff01", (String)"AddressProcessUtils_4", (String)"bos-wf-engine", (Object[])new Object[0]), info.getNumber()));
                return info;
            }
            if (startInfoWithCondition != null && !onlyOne) continue;
            sb.append(String.format(ResManager.loadKDString((String)"\u5ba1\u6279\u6d41\u7a0b[%1$s]\u7684\u542f\u52a8\u6761\u4ef6\u4e3a[%2$s]\uff0c", (String)"AddressProcessUtils_5", (String)"bos-wf-engine", (Object[])new Object[0]), info.getNumber(), info.getStartCondition()));
            if (WfUtils.isEmpty(info.getStartCondition())) {
                addressLogger.logAlternativeProcesses(info);
                if (startInfo == null) {
                    startInfo = info;
                }
                sb.append(String.format(ResManager.loadKDString((String)"\u65e0\u6761\u4ef6\u542f\u52a8\u7684\u5ba1\u6279\u6d41\u7a0b\u52a0\u5165[%s] \uff01", (String)"AddressProcessUtils_6", (String)"bos-wf-engine", (Object[])new Object[0]), info.getNumber()));
                startInfos.add(info);
                continue;
            }
            key = String.format("AuditFlow: %s: entityNumber: %s, businessKey: %s, operation: %s", "addressProcess", entityNumber, businessKey, operation);
            boolean ret = false;
            try {
                bizScope.setVariable("processDefinitionId", info.getId());
                String billNo = TaskBehaviorUtil.getTaskBillNo(entityNumber, businessModel);
                bizScope.setVariable("processName", billNo + '/' + info.getNumber() + '/' + info.getVersion());
                ret = ConditionUtil.hasTrueCondition(info.getStartCondition(), (VariableScope)bizScope, key);
                addressLogger.logAlternativeProcesses(info, ret, bizScope);
            }
            catch (WFEngineException e) {
                e.setProcessDefId(info.getId());
                throw e;
            }
            if (ret) {
                if (startInfoWithCondition == null) {
                    startInfoWithCondition = info;
                }
                sb.append(String.format(ResManager.loadKDString((String)"\u8be5\u6d41\u7a0b\u6ee1\u8db3\u6761\u4ef6,\u8bb0\u5f55\u6d41\u7a0b\u8ba1\u7b97\u7ed3\u679c%s\u3002", (String)"AddressProcessUtils_7", (String)"bos-wf-engine", (Object[])new Object[0]), info.getNumber()));
                startInfoWithConditions.add(info);
                continue;
            }
            sb.append(ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3\u6761\u4ef6\uff01", (String)"AddressProcessUtils_9", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        if (bizStartInfo != null) {
            sb.append(ResManager.loadKDString((String)"\u5b58\u5728\u65e0\u6761\u4ef6\u7684\u4e1a\u52a1\u6d41\u7a0b\uff0c\u8fd4\u56de\u6d41\u7a0b\u7ed3\u679c", (String)"AddressProcessUtils_10", (String)"bos-wf-engine", (Object[])new Object[0])).append("[").append(bizStartInfo.getNumber()).append("]\uff01");
            return bizStartInfo;
        }
        if (onlyOne) {
            sb.append(String.format(ResManager.loadKDString((String)"\u73b0\u5728\u5bfb\u5740\u6a21\u5f0f\u4e3a\u201c\u552f\u4e00\u6d41\u7a0b\u201d\uff0c\u6ee1\u8db3\u6761\u4ef6\u7684\u6d41\u7a0b\u6709[%1$s]\u4e2a\uff0c\u6ca1\u6709\u6761\u4ef6\u7684\u6d41\u7a0b[%2$s]\u4e2a\uff1b", (String)"AddressProcessUtils_11", (String)"bos-wf-engine", (Object[])new Object[0]), startInfoWithConditions.size(), startInfos.size()));
            if (startInfoWithConditions.size() == 1) {
                return (ProcessDefinitionStartInfo)startInfoWithConditions.get(0);
            }
            if (startInfoWithConditions.isEmpty() && startInfos.size() == 1) {
                return (ProcessDefinitionStartInfo)startInfos.get(0);
            }
        } else {
            sb.append(String.format(ResManager.loadKDString((String)"\u73b0\u5728\u5bfb\u5740\u6a21\u5f0f\u4e0d\u662f\u201c\u552f\u4e00\u6d41\u7a0b\u201d\uff0c\u6ee1\u8db3\u6761\u4ef6\u7684\u6d41\u7a0b\u6709[%1$s]\u4e2a\uff0c\u6ca1\u6709\u6761\u4ef6\u7684\u6d41\u7a0b[%2$s]\u4e2a\uff1b", (String)"AddressProcessUtils_12", (String)"bos-wf-engine", (Object[])new Object[0]), startInfoWithConditions.size(), startInfos.size()));
            return startInfoWithCondition != null ? startInfoWithCondition : startInfo;
        }
        sb.append(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u6d41\u7a0b \uff01", (String)"AddressProcessUtils_13", (String)"bos-wf-engine", (Object[])new Object[0]));
        return null;
    }

    private static ProcessDefinitionStartInfo findProcdefByOrg(CommandContext commandContext, DynamicObject businessModel, String operation, Long parentProcDefId, StringBuilder sb) {
        return AddressProcessUtils.findProcdefByOrg(commandContext, businessModel, operation, parentProcDefId, sb, null);
    }

    private static ProcessDefinitionStartInfo findProcdefByOrg(CommandContext commandContext, DynamicObject businessModel, String operation, Long parentProcDefId, StringBuilder sb, Long processDefinitionId) {
        AddressLogger addressLogger = AddressLogger.get(commandContext);
        ProcessDefinitionStartInfo processDefinition = null;
        IDataEntityType dt = businessModel.getDataEntityType();
        String businessKey = String.valueOf(businessModel.getPkValue());
        QFilter[] filters = new QFilter[]{new QFilter("businessKey", "=", (Object)businessKey), new QFilter("endTime", "is null", null)};
        List hiPorcInsts = commandContext.getHistoricProcessInstanceEntityManager().findByQueryFilters(filters);
        HashSet<Long> procDefIds = new HashSet<Long>(hiPorcInsts.size());
        for (HistoricProcessInstanceEntity h : hiPorcInsts) {
            if (h.getProcessDefinitionId().equals(processDefinitionId)) continue;
            procDefIds.add(h.getProcessDefinitionId());
        }
        String entityNumber = dt.getName();
        String mainOrgFieldNumber = "";
        if (dt instanceof BillEntityType && WfUtils.isNotEmpty(mainOrgFieldNumber = ((BillEntityType)dt).getMainOrg())) {
            DynamicObject billMainOrg;
            BusinessModelVariableScope bizScope = new BusinessModelVariableScope(businessModel);
            MainOrgProp orgProp = (MainOrgProp)((BillEntityType)dt).getProperty(mainOrgFieldNumber);
            String orgFunc = orgProp.getOrgFunc();
            if (WfUtils.isEmpty(orgFunc)) {
                orgFunc = "15";
            }
            if ((billMainOrg = businessModel.getDynamicObject((IDataEntityProperty)orgProp)) == null) {
                logger.info(String.format("billMainOrg is null! BusinessKey: %s, Operation: %s", businessKey, operation));
                return AddressProcessUtils.findAppropriateProcessDefinitionInfo(commandContext, businessModel, operation, parentProcDefId, sb);
            }
            Long billMainOrgId = (Long)billMainOrg.getPkValue();
            sb.append(String.format(ResManager.loadKDString((String)"\u4e3b\u7ec4\u7ec7\u5b57\u6bb5[%1$s]id[%2$s]\uff1b", (String)"AddressProcessUtils_14", (String)"bos-wf-engine", (Object[])new Object[0]), mainOrgFieldNumber, orgFunc));
            addressLogger.logBillMainOrgId(billMainOrgId);
            List parentIds = OrgUnitServiceHelper.getAllSuperiorOrgs((String)orgFunc, (long)billMainOrgId);
            addressLogger.logParentOrgIds(parentIds);
            sb.append(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u4e0a\u7ea7\u7ec4\u7ec7[%s]\uff1b", (String)"AddressProcessUtils_15", (String)"bos-wf-engine", (Object[])new Object[0]), WfUtils.listToString(parentIds, ",")));
            List<ProcessDefinitionStartInfo> startInfos = commandContext.getProcessDefinitionEntityManager().findLatestEnabledProcessDefinitions(entityNumber, operation, parentProcDefId);
            LinkedHashMap orgGroupProcdefs = new LinkedHashMap(startInfos.size() + 1);
            orgGroupProcdefs.put(billMainOrgId, new ArrayList());
            for (int i = parentIds.size() - 1; i >= 0; --i) {
                Long parentOrgId = (Long)parentIds.get(i);
                orgGroupProcdefs.put(parentOrgId, new ArrayList());
            }
            sb.append(String.format(ResManager.loadKDString((String)"\u5de5\u4f5c\u6d41\u6309\u7167\u5355\u636e\u548c\u64cd\u4f5c\u8fc7\u6ee4\u51fa\u6d41\u7a0b[%s]\u4e2a\uff1a", (String)"AddressProcessUtils_16", (String)"bos-wf-engine", (Object[])new Object[0]), startInfos.size()));
            ProcessDefinitionStartInfo curProcessDefinition = null;
            for (ProcessDefinitionStartInfo psi : startInfos) {
                if (procDefIds.contains(psi.getId())) continue;
                Long orgId = psi.getOrgId();
                sb.append(String.format(ResManager.loadKDString((String)"{\u7ec4\u7ec7id[%1$s]-\u6d41\u7a0b\u5b9a\u4e49[%2$s]}\uff0c", (String)"AddressProcessUtils_17", (String)"bos-wf-engine", (Object[])new Object[0]), orgId, psi.getNumber()));
                List procdefs = (List)orgGroupProcdefs.get(orgId);
                if (procdefs == null) continue;
                procdefs.add(psi);
                if (!psi.getId().equals(processDefinitionId)) continue;
                curProcessDefinition = psi;
            }
            if (curProcessDefinition != null && !WfConfigurationUtil.restartAddressByTime()) {
                sb.append(ResManager.loadKDString((String)"\u4f18\u5148\u5bfb\u539f\u6d41\u7a0b\u5f00\u5173\u6253\u5f00", (String)"AddressProcessUtils_18", (String)"bos-wf-engine", (Object[])new Object[0]));
                String startCondition = curProcessDefinition.getStartCondition();
                if (WfUtils.isEmpty(startCondition)) {
                    return curProcessDefinition;
                }
                String key = String.format("AuditFlow: %s: entityNumber: %s, businessKey: %s, operation: %s", "addressProcess", entityNumber, businessKey, operation);
                bizScope.setVariable("processDefinitionId", curProcessDefinition.getId());
                String billNo = TaskBehaviorUtil.getTaskBillNo(entityNumber, businessModel);
                bizScope.setVariable("processName", (String)billNo + '/' + curProcessDefinition.getNumber() + '/' + curProcessDefinition.getVersion());
                boolean ret = ConditionUtil.hasTrueCondition(startCondition, (VariableScope)bizScope, key);
                if (ret) {
                    return curProcessDefinition;
                }
            }
            ArrayList<ProcessDefinitionStartInfo> meetStartConditionProcdefs = new ArrayList<ProcessDefinitionStartInfo>();
            ArrayList<ProcessDefinitionStartInfo> noStartConditionProcdefs = new ArrayList<ProcessDefinitionStartInfo>();
            block3: for (Map.Entry procdefsEntry : orgGroupProcdefs.entrySet()) {
                List procdefs = (List)procdefsEntry.getValue();
                sb.append(String.format(ResManager.loadKDString((String)"\u8ba1\u7b97[%s]\u7ec4\uff1a", (String)"AddressProcessUtils_19", (String)"bos-wf-engine", (Object[])new Object[0]), procdefsEntry.getKey()));
                if (procdefs.isEmpty()) continue;
                for (ProcessDefinitionStartInfo info : procdefs) {
                    String startCondition = info.getStartCondition();
                    sb.append(String.format(ResManager.loadKDString((String)"\u6d41\u7a0b[%1$s]\u7684\u542f\u52a8\u6761\u4ef6\u4e3a[%2$s]\uff0c", (String)"AddressProcessUtils_20", (String)"bos-wf-engine", (Object[])new Object[0]), info.getNumber(), startCondition));
                    if (WfUtils.isEmpty(startCondition)) {
                        noStartConditionProcdefs.add(info);
                        sb.append(ResManager.loadKDString((String)"\u6dfb\u52a0\u5230\u65e0\u542f\u52a8\u6761\u4ef6\u6d41\u7a0b\u805a\u5408\u4e2d\uff1b", (String)"AddressProcessUtils_21", (String)"bos-wf-engine", (Object[])new Object[0]));
                        addressLogger.logAlternativeProcesses(info, (Long)procdefsEntry.getKey());
                        continue;
                    }
                    String key = String.format("AuditFlow: %s: entityNumber: %s, businessKey: %s, operation: %s", "addressProcess", entityNumber, businessKey, operation);
                    bizScope.setVariable("processDefinitionId", info.getId());
                    String billNo = TaskBehaviorUtil.getTaskBillNo(entityNumber, businessModel);
                    bizScope.setVariable("processName", billNo + '/' + info.getNumber() + '/' + info.getVersion());
                    boolean ret = ConditionUtil.hasTrueCondition(startCondition, (VariableScope)bizScope, key);
                    addressLogger.logAlternativeProcesses(info, (Long)procdefsEntry.getKey(), ret, bizScope);
                    if (ret) {
                        sb.append(ResManager.loadKDString((String)"\u6761\u4ef6\u6b63\u786e\uff0c", (String)"AddressProcessUtils_22", (String)"bos-wf-engine", (Object[])new Object[0]));
                        if (meetStartConditionProcdefs.isEmpty()) {
                            meetStartConditionProcdefs.add(info);
                            sb.append(String.format(ResManager.loadKDString((String)"\u6ee1\u8db3\u6761\u4ef6\u7684\u6d41\u7a0b\u6210\u73b0\u5728\u4e3a\u7a7a\uff0c\u6d41\u7a0b[%s]\u6dfb\u52a0\u8fdb\u6765\uff1b", (String)"AddressProcessUtils_23", (String)"bos-wf-engine", (Object[])new Object[0]), info.getNumber()));
                            if (WfConfigurationUtil.isFindTheOnlyProcess()) continue;
                            sb.append(ResManager.loadKDString((String)"\u4e0d\u662f\u201c\u552f\u4e00\u6d41\u7a0b\u201d\uff0c\u76f4\u63a5\u8df3\u51fa\u5faa\u73af\uff01", (String)"AddressProcessUtils_24", (String)"bos-wf-engine", (Object[])new Object[0]));
                            break block3;
                        }
                        meetStartConditionProcdefs.add(info);
                        sb.append(String.format(ResManager.loadKDString((String)"\u6ee1\u8db3\u6761\u4ef6\u7684\u6d41\u7a0b\u6210\u73b0\u5728\u4e0d\u4e3a\u7a7a\uff0c\u6d41\u7a0b[%s]\u6dfb\u52a0\u8fdb\u6765\uff1b\u76f4\u63a5\u8df3\u51fa\u5faa\u73af\uff01", (String)"AddressProcessUtils_25", (String)"bos-wf-engine", (Object[])new Object[0]), info.getNumber()));
                        break block3;
                    }
                    sb.append(ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3\u6761\u4ef6\uff01", (String)"AddressProcessUtils_9", (String)"bos-wf-engine", (Object[])new Object[0]));
                }
            }
            boolean only = WfConfigurationUtil.isFindTheOnlyProcess();
            addressLogger.logFindTheOnlyProcessStatus(only);
            if (only) {
                sb.append(String.format(ResManager.loadKDString((String)"\u73b0\u5728\u5bfb\u5740\u6a21\u5f0f\u4e3a\u201c\u552f\u4e00\u6d41\u7a0b\u201d\uff0c\u6ee1\u8db3\u6761\u4ef6\u7684\u6d41\u7a0b\u6709[%1$s]\u4e2a\uff0c\u6ca1\u6709\u6761\u4ef6\u7684\u6d41\u7a0b[%2$s]\u4e2a\uff1b", (String)"AddressProcessUtils_11", (String)"bos-wf-engine", (Object[])new Object[0]), meetStartConditionProcdefs.size(), noStartConditionProcdefs.size()));
                if (meetStartConditionProcdefs.size() == 1) {
                    processDefinition = (ProcessDefinitionStartInfo)meetStartConditionProcdefs.get(0);
                } else if (meetStartConditionProcdefs.isEmpty() && noStartConditionProcdefs.size() == 1) {
                    processDefinition = (ProcessDefinitionStartInfo)noStartConditionProcdefs.get(0);
                }
            } else {
                sb.append(String.format(ResManager.loadKDString((String)"\u73b0\u5728\u5bfb\u5740\u6a21\u5f0f\u4e0d\u662f\u201c\u552f\u4e00\u6d41\u7a0b\u201d\uff0c\u6ee1\u8db3\u6761\u4ef6\u7684\u6d41\u7a0b\u6709[%1$s]\u4e2a\uff0c\u6ca1\u6709\u6761\u4ef6\u7684\u6d41\u7a0b[%2$s]\u4e2a\uff1b", (String)"AddressProcessUtils_12", (String)"bos-wf-engine", (Object[])new Object[0]), meetStartConditionProcdefs.size(), noStartConditionProcdefs.size()));
                if (!meetStartConditionProcdefs.isEmpty()) {
                    processDefinition = (ProcessDefinitionStartInfo)meetStartConditionProcdefs.get(0);
                } else if (!noStartConditionProcdefs.isEmpty()) {
                    processDefinition = (ProcessDefinitionStartInfo)noStartConditionProcdefs.get(0);
                }
            }
        } else {
            sb.append(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5b9e\u4f53[%s]\u4e2d\u6ca1\u6709\u4e3b\u7ec4\u7ec7\u5b57\u6bb5\uff0c\u6309\u7167\u4ee5\u524d\u65b9\u6cd5\u5bfb\u5740\uff01", (String)"AddressProcessUtils_28", (String)"bos-wf-engine", (Object[])new Object[0]), dt.getName()));
            return AddressProcessUtils.findAppropriateProcessDefinitionInfo(commandContext, businessModel, operation, parentProcDefId, sb, processDefinitionId);
        }
        sb.append(String.format(ResManager.loadKDString((String)"\u6700\u7ec8\u5f97\u5230\u6d41\u7a0b[%s]!", (String)"AddressProcessUtils_26", (String)"bos-wf-engine", (Object[])new Object[0]), processDefinition == null ? ResManager.loadKDString((String)"\u7a7a", (String)"AddressProcessUtils_27", (String)"bos-wf-engine", (Object[])new Object[0]) : processDefinition.getNumber()));
        return processDefinition;
    }

    public static Boolean mountBizFlow(CommandContext commandContext, String entityNumber, String businessKey, String operation, Map<String, Object> variables) {
        try {
            if (!WfUtils.exist(entityNumber, (Object)businessKey)) {
                return false;
            }
            List<Long> procdefIds = commandContext.getProcessDefinitionEntityManager().getMountOperationProcdefIds(entityNumber, operation);
            QFilter[] filters = new QFilter[]{new QFilter("businessKey", "=", (Object)businessKey), new QFilter("scope", "=", (Object)Boolean.FALSE), new QFilter("processtype", "=", (Object)ModelType.BizFlow.name())};
            List execs = commandContext.getExecutionEntityManager().findByQueryFilters(filters, null, "createDate desc");
            if (execs != null && !execs.isEmpty()) {
                Set<Long> processDefinitionIds = commandContext.getProcessDefinitionInfoEntityManager().findProcDefIdsByEntityAndOperation(entityNumber, operation);
                processDefinitionIds.addAll(procdefIds);
                if (processDefinitionIds.isEmpty()) {
                    return false;
                }
                DelegateExecution last = null;
                ArrayList<ExecutionEntity> childExecs = new ArrayList<ExecutionEntity>(4);
                boolean existActive = false;
                for (ExecutionEntity exec : execs) {
                    if (!processDefinitionIds.contains(exec.getProcessDefinitionId())) continue;
                    if (exec.isActive() && !existActive) {
                        existActive = true;
                    }
                    if (exec.isActive()) {
                        childExecs.add(exec);
                    }
                    if (last != null || !exec.isBillExecution()) continue;
                    last = exec;
                }
                if (last != null) {
                    if (!procdefIds.contains(last.getProcessDefinitionId())) {
                        logger.info(String.format("procdefIds[%s] don't contain founded definitionid[%s].", WfUtils.listToString(procdefIds, ","), last.getProcessDefinitionId()));
                        return Boolean.FALSE;
                    }
                    if (existActive) {
                        AddressProcessUtils.resetOperation(operation, (ExecutionEntity)last);
                        AddressProcessUtils.triggerWaitActionsOperation(commandContext, (ExecutionEntity)last, childExecs, entityNumber, businessKey, operation, variables);
                        return Boolean.FALSE;
                    }
                    AddressProcessUtils.resetOperation(operation, (ExecutionEntity)last);
                    return AddressProcessUtils.mountBizFlowBySelf(entityNumber, businessKey, operation, variables, (ExecutionEntity)last);
                }
                logger.info(String.format("last is null: entityNumber:_%s_ businessKey:_%s_ .", entityNumber, businessKey));
            }
            if (procdefIds.isEmpty()) {
                return false;
            }
            ArrayList<String> pks = new ArrayList<String>(1);
            pks.add(businessKey);
            Map<String, Set<String>> srcBillIds = BillRelationHelper.get().getDirectSourceBill(entityNumber, pks);
            if (srcBillIds != null && !srcBillIds.isEmpty()) {
                logger.info(String.format("mountBizFlow: entityNumber:_%s_ businessKey:_%s_ mountBySrcBill:_%s_procdefids:_%s", entityNumber, businessKey, srcBillIds, WfUtils.listToString(procdefIds, ",")));
                return AddressProcessUtils.mountBizFlowBySrcBill(commandContext, entityNumber, businessKey, operation, variables, srcBillIds, procdefIds);
            }
            logger.info(String.format("mountBizFlow: entityNumber:_%s_ businessKey:_%s_ mountByBatchNumber operation:_%s_", entityNumber, businessKey, operation));
            return AddressProcessUtils.mountBizFlowByBatchNumber(commandContext, entityNumber, businessKey, operation);
        }
        catch (Exception e) {
            throw new WFMountException(WFErrorCode.getMountException(), new String[]{entityNumber, businessKey, operation, WfUtils.getExceptionStacktrace(e)});
        }
    }

    private static void resetOperation(String operation, ExecutionEntity last) {
        if (WfUtils.isNotEmpty(operation) && last != null) {
            String op = (String)last.getVariableLocal("_operation_");
            String ops = (String)last.getVariableLocal("_operations_");
            if (WfUtils.isEmpty(ops)) {
                ops = op;
            }
            if (WfUtils.isNotEmpty(ops)) {
                String separator = ",";
                StringBuilder operations = new StringBuilder();
                String[] os = ops.split(separator);
                int length = os.length;
                boolean exist = false;
                for (int i = 0; i < length; ++i) {
                    String o = os[i];
                    if (o.equals(operation)) {
                        exist = true;
                    }
                    operations.append(o);
                    if (i >= length - 1) continue;
                    operations.append(separator);
                }
                if (!exist) {
                    operations.append(separator).append(operation);
                    ops = operations.toString();
                }
                last.setVariableLocal("_operations_", ops);
            } else {
                last.setVariableLocal("_operations_", operation);
            }
        }
    }

    private static Boolean mountBizFlowBySelf(String entityNumber, String businessKey, String operation, Map<String, Object> variables, ExecutionEntity lastBillExec) {
        if (lastBillExec != null) {
            AddressProcessUtils.planExecutionConvertOperationBySelfExec(entityNumber, businessKey, operation, variables, lastBillExec);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Boolean mountBizFlowBySrcBill(CommandContext commandContext, String entityNumber, String businessKey, String operation, Map<String, Object> variables, Map<String, Set<String>> srcBillIds, List<Long> procdefIds) {
        HashSet params;
        QFilter[] filters;
        if (srcBillIds.isEmpty()) {
            logger.info(String.format("no source bill exist %s %s", entityNumber, businessKey));
            return false;
        }
        HashSet<String> sourcePks = new HashSet<String>();
        for (Set<String> srcPks : srcBillIds.values()) {
            sourcePks.addAll(srcPks);
        }
        ExecutionEntityManager execMgr = commandContext.getExecutionEntityManager();
        List execs = execMgr.findByQueryFilters(filters = new QFilter[]{new QFilter("businessKey", "in", params = new HashSet(sourcePks)), new QFilter("scope", "=", (Object)Boolean.FALSE), new QFilter("billexecution", "=", (Object)Boolean.FALSE), new QFilter("multiInstanceRoot", "=", (Object)Boolean.FALSE), new QFilter("processtype", "=", (Object)ModelType.BizFlow.name())});
        if (execs.isEmpty()) {
            logger.info(String.format("no current execution is related to srcBill[%s] for current and dest bill[ %s %s]!", WfUtils.listToString(sourcePks, ","), entityNumber, businessKey));
            return false;
        }
        variables.put("_operation_", operation);
        TaskEntityManager taskEntityManager = commandContext.getTaskEntityManager();
        StringBuilder sourceEntitys = new StringBuilder();
        HashMap<Long, MountResult> mountExecutionIds = new HashMap<Long, MountResult>(8);
        for (ExecutionEntity entity : execs) {
            boolean continueFlow;
            sourceEntitys.append(entity.getEntityNumber()).append(",");
            TaskEntity task = (TaskEntity)taskEntityManager.findById(entity.getCurrentTaskId());
            if (task == null || task.isDeleted() || !"manualpush".equals(task.getExecutionType())) {
                AddressProcessUtils.collectToMountResult(mountExecutionIds, entity, null, entityNumber, businessKey, sourcePks, operation);
                continue;
            }
            BpmnModel bpmn = ProcessDefinitionUtil.getBpmnModel(((ExecutionEntity)execs.get(0)).getProcessDefinitionId(), ((ExecutionEntity)execs.get(0)).getProcessInstanceId());
            BillTask elem = (BillTask)bpmn.getFlowElement(task.getTaskDefinitionKey());
            boolean sameEntity = elem != null && entityNumber.equalsIgnoreCase(elem.getEntityNumber());
            boolean bl = continueFlow = sameEntity && elem.getOperationStr() != null && Arrays.asList(elem.getOperationStr().split(",")).contains(operation);
            if (elem != null && !continueFlow) {
                AddressProcessUtils.collectToMountResult(mountExecutionIds, entity, null, entityNumber, businessKey, sourcePks, operation);
                continue;
            }
            if (continueFlow) {
                AddressProcessUtils.collectToMountResult(mountExecutionIds, entity, task.getId(), entityNumber, businessKey, sourcePks, operation);
                continue;
            }
            logger.info(String.format("it cannot reach here:%s %s", entity.getEntityNumber(), entity.getBusinessKey()));
        }
        Boolean ret = Boolean.FALSE;
        Set set = mountExecutionIds.entrySet();
        HashSet<Long> existDefs = new HashSet<Long>();
        for (Map.Entry entry : set) {
            MountResult result = (MountResult)entry.getValue();
            existDefs.addAll(result.getProcDefs());
            if (WfUtils.isEmptyForCollection(result.getCurTaskExecutions()) && WfUtils.isEmptyForCollection(result.getCurExecutions())) {
                logger.info(String.format("wait for target bill node: entityNumber:_%s_ businessKey:_%s_ operation:_%s_ ", entityNumber, businessKey, operation));
                if (ret == null || ret.booleanValue()) continue;
                ret = null;
                continue;
            }
            if (WfUtils.isNotEmptyForCollection(result.getCurTaskExecutions())) {
                Set taskExecutions = result.getCurTaskExecutions().stream().filter(execution -> WfUtils.exist(execution.getEntityNumber(), (Object)execution.getBusinessKey()) && procdefIds.contains(execution.getProcessDefinitionId()) && AddressProcessUtils.getTargetBillFilterResult(commandContext, execution, entityNumber, businessKey)).collect(Collectors.toSet());
                if (WfUtils.isNotEmptyForCollection(taskExecutions)) {
                    ret = Boolean.TRUE;
                    for (ExecutionEntity execution2 : taskExecutions) {
                        execution2.setTransientVariableLocal("mountBySrcExc_filteredFlag", Boolean.TRUE);
                        AddressProcessUtils.planExecutionConvertOperationBySourceExec(entityNumber, businessKey, operation, variables, execution2);
                    }
                } else {
                    logger.info(String.format("cannot get suitable execution by task execution: entityNumber:_%s_ businessKey:_%s_ operation:_%s_ ", entityNumber, businessKey, operation));
                }
            }
            if (!WfUtils.isNotEmptyForCollection(result.getCurExecutions())) continue;
            Set executions = result.getCurExecutions().stream().filter(execution -> WfUtils.exist(execution.getEntityNumber(), (Object)execution.getBusinessKey()) && procdefIds.contains(execution.getProcessDefinitionId()) && AddressProcessUtils.getTargetBillFilterResult(commandContext, execution, entityNumber, businessKey)).collect(Collectors.toSet());
            if (WfUtils.isNotEmptyForCollection(executions)) {
                ret = Boolean.TRUE;
                for (ExecutionEntity execution2 : executions) {
                    execution2.setTransientVariableLocal("mountBySrcExc_filteredFlag", Boolean.TRUE);
                    AddressProcessUtils.planExecutionConvertOperationBySourceExec(entityNumber, businessKey, operation, variables, execution2);
                }
                continue;
            }
            logger.info(String.format("cannot get suitable execution by current execution: entityNumber:_%s_ businessKey:_%s_ operation:_%s_ ", entityNumber, businessKey, operation));
        }
        if (ret != null) {
            if (ret != false) return ret;
        }
        if (WfUtils.isNotEmptyForCollection(existDefs)) {
            if (existDefs.stream().anyMatch(procdefIds::contains)) {
                return null;
            }
        }
        Boolean bl = Boolean.FALSE;
        return bl;
    }

    private static boolean getTargetBillFilterResult(CommandContext commandContext, ExecutionEntity execution, String entityNumber, String businessKey) {
        SequenceFlow incomingFlow;
        BillCalculatorExecutor billConversionCalculator = commandContext.getBillConversionCalculator();
        if (billConversionCalculator.isSupportTargetBillsFilter(commandContext, execution, incomingFlow = billConversionCalculator.tryGetIncomingFlowByExec(commandContext, execution))) {
            return billConversionCalculator.doFilter(incomingFlow, entityNumber, businessKey);
        }
        return true;
    }

    private static boolean getTargetBillFilterResult(CommandContext commandContext, SequenceFlow incomingFlow, String entityNumber, String businessKey) {
        BillCalculatorExecutor billConversionCalculator = commandContext.getBillConversionCalculator();
        if (billConversionCalculator.isSupportTargetBillsFilter(commandContext, null, incomingFlow)) {
            return billConversionCalculator.doFilter(incomingFlow, entityNumber, businessKey);
        }
        return true;
    }

    private static void planExecutionConvertOperationBySelfExec(String entityNumber, String businessKey, String operation, Map<String, Object> variables, ExecutionEntity execution) {
        if (execution != null) {
            execution.setTransientVariable("selfExecutions", String.valueOf(execution.getId()));
            HashSet<String> businessKeys = new HashSet<String>(1);
            businessKeys.add(businessKey);
            variables.put("_operation_", operation);
            Context.getAgenda().planExecutionConvertOperation(execution, entityNumber, businessKeys, variables);
        }
    }

    private static void planExecutionConvertOperationBySourceExec(String entityNumber, String businessKey, String operation, Map<String, Object> variables, ExecutionEntity execution) {
        if (execution != null) {
            execution.setTransientVariable("upExecutions", String.valueOf(execution.getId()));
            HashSet<String> businessKeys = new HashSet<String>(1);
            businessKeys.add(businessKey);
            Context.getAgenda().planExecutionConvertOperation(execution, entityNumber, businessKeys, variables);
            QFilter procFilter = new QFilter("executionId", "=", (Object)execution.getId());
            QFilter pkFilter = new QFilter("businessKey", "=", (Object)execution.getBusinessKey());
            QFilter typeFilter = new QFilter("jobHandlerType", "in", (Object)new String[]{"async-continuation", "async-executionConversion"});
            QFilter eleFilter = new QFilter("elementId", "=", (Object)execution.getActivityId());
            CommandContext commandContext = Context.getCommandContext();
            List dJobs = commandContext.getDeadLetterJobEntityManager().findByQueryFilters(new QFilter[]{procFilter, pkFilter, typeFilter, eleFilter});
            if (!dJobs.isEmpty()) {
                commandContext.getDeadLetterJobEntityManager().delete((Entity)dJobs.get(0));
            }
        }
    }

    private static void collectToMountResult(Map<Long, MountResult> mountExecutionIds, ExecutionEntity entity, Long taskId, String tagEntityNumber, String tagBusinessKey, Set<String> sourcePks, String operation) {
        if (entity == null) {
            return;
        }
        MountResult ret = mountExecutionIds.get(entity.getProcessInstanceId());
        if (ret == null) {
            ret = new MountResult();
        }
        if (WfUtils.isNotEmpty(taskId)) {
            ret.addTaskExecution(entity);
            logger.info(String.format("mount by task[%s],procdefid[%s]", taskId, entity.getProcessDefinitionId()));
        } else if (AddressProcessUtils.existPatch(entity, tagEntityNumber, tagBusinessKey, operation)) {
            logger.info(String.format("mount by execution[%s],procdefid[%s]", entity.getId(), entity.getProcessDefinitionId()));
            ret.addExecution(entity);
        } else {
            logger.info(String.format("srcBill[%s] is in bizflow,wait a moment for targetBill[%s][%s] or execution[%s] activity entitynumber is not target.", WfUtils.listToString(sourcePks, ","), tagEntityNumber, tagBusinessKey, entity.getId()));
            ret.addExistProcDefId(entity.getProcessDefinitionId());
        }
        mountExecutionIds.put(entity.getProcessInstanceId(), ret);
    }

    private static void triggerWaitActionsOperation(CommandContext commandContext, ExecutionEntity last, List<ExecutionEntity> childExecs, String entityNumber, String businessKey, String operation, Map<String, Object> variables) {
        if (last == null) {
            logger.info(String.format("triggerWaitActionsOperation: entityNumber: %s, businessKey: %s, operation: %s,last:%s", entityNumber, businessKey, operation, last == null ? null : last.getId()));
            return;
        }
        if (childExecs == null || childExecs.isEmpty()) {
            return;
        }
        if (entityNumber != null && !entityNumber.equalsIgnoreCase(last.getEntityNumber())) {
            logger.info(String.format("entity must be equals: entityNumber: %s, businessKey: %s ,last-entitynumber:%s", entityNumber, businessKey, last == null ? null : last.getEntityNumber()));
            return;
        }
        QFilter[] filters = new QFilter[]{new QFilter("processDefinitionId", "=", (Object)last.getProcessDefinitionId()), new QFilter("operation", "=", (Object)operation)};
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(last.getProcessDefinitionId(), last.getSchemeId(), last.getProcessInstanceId());
        List procDefInfos = commandContext.getProcessDefinitionInfoEntityManager().findByQueryFilters(filters);
        if (procDefInfos == null || procDefInfos.isEmpty()) {
            return;
        }
        String willActionactId = null;
        boolean find = false;
        boolean leaveNode = false;
        Map<String, Set<String>> nodeOpersMap = AddressProcessUtils.getBillTaskWaitActionsOperation(bpmnModel);
        for (ProcessDefinitionInfoEntity procDefInfo : procDefInfos) {
            Set<String> operations;
            BillTask billTask;
            willActionactId = procDefInfo.getActId();
            FlowElement element = bpmnModel.getFlowElement(willActionactId);
            if (!(element instanceof BillTask) || (billTask = (BillTask)element).getBillCloseConfig() == null || billTask.getBillCloseConfig().getBillCloseCondition() == null || !entityNumber.equalsIgnoreCase(procDefInfo.getEntityNumber()) || (operations = nodeOpersMap.get(willActionactId)) == null || !operations.contains(procDefInfo.getOperation())) continue;
            if (!last.getActivityId().equalsIgnoreCase(willActionactId) && !bpmnModel.getPreviousNodeIds(willActionactId).contains(last.getActivityId())) {
                logger.info(String.format("billexecution actid is not equals def.info wait operation, billActid:%s waitActId: %s Operation: %s", last.getActivityId(), willActionactId, procDefInfo.getOperation()));
                continue;
            }
            find = true;
            leaveNode = true;
            break;
        }
        if (!find) {
            for (ExecutionEntity exec : childExecs) {
                boolean enableCallActivity;
                BillTask ut;
                boolean continueFlow;
                String executionActId;
                FlowElement element;
                Boolean ret = (Boolean)exec.getVariableLocal("MountOperationNotMatch");
                if (ret != null && ret.booleanValue() && !leaveNode) {
                    leaveNode = true;
                }
                if (!((element = bpmnModel.getFlowElement(executionActId = exec.getActivityId())) instanceof BillTask) || !(continueFlow = (ut = (BillTask)element).getOperationStr() != null && Arrays.asList(ut.getOperationStr().split(",")).contains(operation))) continue;
                CallActivity callActivity = ut.getCallActivity();
                boolean bl = enableCallActivity = callActivity != null && ("processAddress".equals(callActivity.getCalledWay()) || "bindByProdefId".equals(callActivity.getCalledWay()) && WfUtils.isNotEmpty(callActivity.getCallProcessNumber()));
                if (!enableCallActivity) {
                    find = true;
                    break;
                }
                QFilter[] qs = new QFilter[]{new QFilter("businessKey", "=", (Object)exec.getBusinessKey()), new QFilter("processInstanceId", "!=", (Object)exec.getProcessInstanceId())};
                if (commandContext.getExecutionEntityManager().exist(qs)) continue;
                find = true;
                break;
            }
        }
        if (!find) {
            return;
        }
        String billExecutionActId = last.getActivityId();
        HashMap<String, Boolean> tmp = new HashMap<String, Boolean>();
        for (ExecutionEntity exec : childExecs) {
            String executionActId = exec.getActivityId();
            FlowElement element = bpmnModel.getFlowElement(executionActId);
            if (!(element instanceof FlowNode)) continue;
            if (exec.getParentId().equals(last.getId())) {
                exec.setParent(last);
            }
            if (leaveNode) {
                Object obj = exec.getVariable("leaveFromBillExecElem");
                if (obj != null && "true".equalsIgnoreCase(obj.toString())) {
                    if (tmp.containsKey(billExecutionActId)) continue;
                    AddressProcessUtils.leaveBizExectionNode(entityNumber, businessKey, operation, willActionactId, billExecutionActId, bpmnModel, exec, element);
                    tmp.put(billExecutionActId, Boolean.TRUE);
                    continue;
                }
                AddressProcessUtils.leaveCurrentNode(entityNumber, businessKey, operation, willActionactId, billExecutionActId, bpmnModel, exec, element);
                continue;
            }
            List<DeadLetterJobEntity> dJobs = AddressProcessUtils.getCurrentNodeByCompensationError(commandContext, exec, element);
            if (!dJobs.isEmpty()) {
                new RecoverProcessInstanceCmd(dJobs.get(0).getId(), null).execute(commandContext);
                continue;
            }
            if (exec.isBillExecution()) continue;
            AddressProcessUtils.mountBizFlowBySelf(entityNumber, businessKey, operation, variables, last);
        }
    }

    @Deprecated
    public static void triggerWaitActionsOperation(CommandContext commandContext, ExecutionEntity last, List<ExecutionEntity> childExecs, String entityNumber, String businessKey, String operation) {
    }

    private static List<DeadLetterJobEntity> getCurrentNodeByCompensationError(CommandContext commandContext, ExecutionEntity exec, FlowElement element) {
        QFilter procFilter = new QFilter("executionId", "=", (Object)exec.getId());
        QFilter pkFilter = new QFilter("businessKey", "=", (Object)exec.getBusinessKey());
        QFilter typeFilter = new QFilter("jobHandlerType", "in", (Object)new String[]{"async-continuation", "async-executionConversion"});
        QFilter eleFilter = new QFilter("elementId", "=", (Object)element.getId());
        return commandContext.getDeadLetterJobEntityManager().findByQueryFilters(new QFilter[]{procFilter, pkFilter, typeFilter, eleFilter});
    }

    private static void leaveBizExectionNode(String entityNumber, String businessKey, String operation, String actId, String billExecutionActId, BpmnModel bpmnModel, ExecutionEntity exec, FlowElement element) {
        String executionActId = exec.getActivityId();
        FlowElement billExecutionElement = bpmnModel.getFlowElement(billExecutionActId);
        if (executionActId.equals(billExecutionActId)) {
            logger.info(String.format("Activity consistency, trigger.  executionId: %s, businessKey: %s, operation: %s", exec.getId(), businessKey, operation));
            Context.getAgenda().planTriggerExecutionOperation(exec);
        } else {
            exec.setCurrentFlowElement(billExecutionElement);
            logger.info(String.format("Force leave from bill execution Activity, trigger.  executionId: %s, businessKey: %s, operation: %s", exec.getId(), businessKey, operation));
            Context.getAgenda().planTriggerExecutionOperation(exec);
        }
    }

    private static void leaveCurrentNode(String entityNumber, String businessKey, String operation, String actId, String billExecutionActId, BpmnModel bpmnModel, ExecutionEntity exec, FlowElement element) {
        String executionActId = exec.getActivityId();
        FlowElement billExecutionElement = bpmnModel.getFlowElement(billExecutionActId);
        Set<String> billExecutionEntities = BpmnModelUtil.getTargetEntityNumber(billExecutionElement);
        if (executionActId.equals(billExecutionActId)) {
            logger.info(String.format("Activity consistency, trigger.  executionId: %s, businessKey: %s, operation: %s", exec.getId(), businessKey, operation));
            Context.getAgenda().planTriggerExecutionOperation(exec);
        } else {
            Set<String> executionEntities = BpmnModelUtil.getTargetEntityNumber(element);
            if (Sets.difference(executionEntities, billExecutionEntities).isEmpty()) {
                if (executionActId.equals(actId)) {
                    logger.info(String.format("trigger. procDefActId: %s, execActId: %s, billExecActId: %s, executionId: %s, businessKey: %s, operation: %s", actId, executionActId, billExecutionActId, exec.getId(), businessKey, operation));
                    Context.getAgenda().planTriggerExecutionOperation(exec);
                } else {
                    logger.info(String.format("Entity consistency, discard.  executionId: %s, businessKey: %s, operation: %s", exec.getId(), businessKey, operation));
                }
            } else {
                logger.info(String.format("Entity not consistency, convert.  executionId: %s, businessKey: %s, operation: %s", exec.getId(), businessKey, operation));
                FlowNode node = (FlowNode)element;
                for (SequenceFlow sf : node.getIncomingFlows()) {
                    boolean isBotpAutoConvert;
                    BillRelationshipModel bm;
                    String entity;
                    if (!(sf.getSourceFlowElement() instanceof IEntitySupport) || !entityNumber.equalsIgnoreCase(entity = ((IEntitySupport)((Object)sf.getSourceFlowElement())).getEntityNumber()) || (bm = sf.getBillRelationshipModel()) == null) continue;
                    boolean bl = isBotpAutoConvert = "botpTargetBills".equalsIgnoreCase(bm.getRelationType()) && "auto".equalsIgnoreCase(bm.getConversionMode());
                    if (isBotpAutoConvert || "sameWithPreNode".equals(bm.getRelationType())) {
                        Context.getAgenda().planExecutionConvertOperation(exec, sf.getId());
                        continue;
                    }
                    logger.info(String.format("Non automatic or entityNumber inconformity. executionId: %s, businessKey: %s, relationType: %s, conversionMode: %s", exec.getId(), businessKey, bm.getRelationType(), bm.getConversionMode()));
                }
            }
        }
    }

    private static Map<String, Set<String>> getBillTaskWaitActionsOperation(BpmnModel bpmnModel) {
        List<BillTask> billTasks = bpmnModel.getMainProcess().findFlowElementsOfType(BillTask.class);
        if (billTasks == null || billTasks.isEmpty()) {
            return new HashMap<String, Set<String>>();
        }
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(billTasks.size());
        BillCloseConfig config = null;
        HashSet<String> operations = null;
        for (BillTask billTask : billTasks) {
            config = billTask.getBillCloseConfig();
            if (config == null || config.getWaitActions() == null || config.getWaitActions().getOperations() == null) continue;
            operations = (HashSet<String>)map.get(billTask.getId());
            if (operations == null) {
                operations = new HashSet<String>(config.getWaitActions().getOperations().size());
                map.put(billTask.getId(), operations);
            }
            for (WaitCloseOperation operation : config.getWaitActions().getOperations()) {
                operations.add(operation.getNumber());
            }
        }
        return map;
    }

    private static boolean existPatch(ExecutionEntity entity, String entityNumber, String tagBusinessKey, String operation) {
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(null, entity.getProcessInstanceId());
        if (bpmnModel != null) {
            FlowElement elem = bpmnModel.getFlowElement(entity.getActivityId());
            Set<String> fmEntitys = BpmnModelUtil.getTargetEntityNumber(elem);
            if (fmEntitys != null && !fmEntitys.contains(entityNumber)) {
                return false;
            }
            if (fmEntitys != null && !fmEntitys.contains(entity.getEntityNumber())) {
                return true;
            }
        }
        QFilter[] filters = new QFilter[]{new QFilter("processInstanceId", "=", (Object)entity.getProcessInstanceId()), new QFilter("businessKey", "=", (Object)tagBusinessKey)};
        logger.info(String.format("why it can reach here[%s][%s][%s]", entityNumber, tagBusinessKey, entity.getId()));
        return Context.getCommandContext().getHistoricActivityInstanceEntityManager().exist(filters);
    }

    private static boolean mountBizFlowByBatchNumber(CommandContext commandContext, String entityNumber, String businessKey, String operation) {
        if (entityNumber == null || operation == null) {
            return false;
        }
        List<ProcessDefinitionStartInfo> infos = AddressProcessUtils.findAppropriateBizFlowProcDefInfos(commandContext, entityNumber, businessKey, operation);
        if (infos.isEmpty()) {
            return false;
        }
        ExecutionEntity processInstance = null;
        DynamicObject dynamicObject = WfUtils.findBusinessObject(businessKey, entityNumber);
        BusinessModelVariableScope bizScope = new BusinessModelVariableScope(dynamicObject);
        for (ProcessDefinitionStartInfo info : infos) {
            String batchNumber = BizFlowUtil.parseBatchNumberValue(bizScope, info.getBatchNumber());
            if (!WfUtils.isNotEmpty(batchNumber)) continue;
            logger.info(String.format("mountBizFlow: findSameBatchNumberProcessInstance: entityNumber:_%s_ businessKey:_%s_ operation:_%s_, batchNumber:_%s_", entityNumber, businessKey, operation, batchNumber));
            processInstance = AddressProcessUtils.getSameBatchNumberProcessInstance(commandContext, batchNumber, entityNumber, info.getId());
            if (processInstance == null) continue;
            break;
        }
        if (processInstance != null) {
            FlowNode target = AddressProcessUtils.findMountNode(entityNumber, businessKey, processInstance);
            if (target == null) {
                logger.info(String.format("%s & %s can not found!", entityNumber, operation));
                return false;
            }
            ExecutionEntity brachExec = BizFlowUtil.createBillExecutionAndContinue(commandContext, processInstance, target, entityNumber, businessKey);
            if (brachExec != null && brachExec.getParent() != null && brachExec.getParent().isBillExecution()) {
                brachExec.getParent().setVariableLocal("_operation_", operation);
            }
            return true;
        }
        return false;
    }

    private static FlowNode findMountNode(String entityNumber, String businessKey, ExecutionEntity processInstance) {
        CommandContext commandContext = Context.getCommandContext();
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(processInstance.getProcessDefinitionId(), processInstance.getSchemeId(), processInstance.getProcessInstanceId());
        LinkedList<FlowNode> queue = new LinkedList<FlowNode>();
        StartEvent startEvent = bpmnModel.getMainProcess().findFlowElementsOfType(StartEvent.class).get(0);
        queue.offer(startEvent);
        while (!queue.isEmpty()) {
            FlowNode flowNode = (FlowNode)queue.poll();
            List<SequenceFlow> outgoingFlows = flowNode.getOutgoingFlows();
            for (SequenceFlow flow : outgoingFlows) {
                FlowElement targetElement = flow.getTargetFlowElement();
                if (!(targetElement instanceof FlowNode)) continue;
                FlowNode node = (FlowNode)targetElement;
                String nodeEntityNumber = AddressProcessUtils.getEntityNumber(node);
                if (entityNumber.equals(nodeEntityNumber) && AddressProcessUtils.getTargetBillFilterResult(commandContext, flow, entityNumber, businessKey)) {
                    return node;
                }
                queue.add(node);
            }
        }
        return null;
    }

    private static String getEntityNumber(FlowElement element) {
        if (element instanceof UserTask) {
            return ((UserTask)element).getEntityNumber();
        }
        if (element instanceof CallActivity) {
            return ((CallActivity)element).getEntityNumber();
        }
        if (element instanceof AutoTask) {
            AutoTask autoTask = (AutoTask)element;
            MainEntityType entity = EntityMetadataCache.getDataEntityTypeById((String)autoTask.getEntityId());
            return entity != null ? entity.getName() : null;
        }
        return null;
    }

    private static ExecutionEntity getSameBatchNumberProcessInstance(CommandContext commandContext, String batchNumber, String entityNumber, Long procDefId) {
        ExecutionEntityManager entityManager = commandContext.getExecutionEntityManager();
        EntityQueryBuilder queryBuilder = entityManager.createQueryBuilder();
        queryBuilder.addFilter("processDefinitionId", procDefId);
        queryBuilder.addFilter("entityNumber", entityNumber);
        queryBuilder.addFilter("batchnumber", batchNumber);
        queryBuilder.addFilter("scope", true);
        queryBuilder.orderBy(String.format("%s desc", "createDate"));
        List result = entityManager.findByQueryBuilder(queryBuilder);
        if (result.isEmpty()) {
            return null;
        }
        return (ExecutionEntity)result.get(0);
    }

    private static List<ProcessDefinitionStartInfo> findAppropriateBizFlowProcDefInfos(CommandContext commandContext, String entityNumber, String businessKey, String operation) {
        ArrayList<ProcessDefinitionStartInfo> conditionStartInfos = new ArrayList<ProcessDefinitionStartInfo>();
        List<ProcessDefinitionStartInfo> infos = commandContext.getProcessDefinitionEntityManager().findEnabledHadBatchNumberBizFlowProcDefinitions(entityNumber, operation);
        if (infos.isEmpty()) {
            return conditionStartInfos;
        }
        ArrayList<ProcessDefinitionStartInfo> startInfos = new ArrayList<ProcessDefinitionStartInfo>();
        BusinessModelVariableScope bizScope = new BusinessModelVariableScope(businessKey, entityNumber);
        for (ProcessDefinitionStartInfo info : infos) {
            if (WfUtils.isEmpty(info.getStartCondition())) {
                startInfos.add(info);
                continue;
            }
            String key = String.format("BizFlow: %s: entityNumber: %s, businessKey: %s, operation: %s", "addressProcess", entityNumber, businessKey, operation);
            boolean ret = ConditionUtil.hasTrueCondition(info.getStartCondition(), (VariableScope)bizScope, key);
            if (!ret) continue;
            conditionStartInfos.add(info);
        }
        conditionStartInfos.addAll(startInfos);
        return conditionStartInfos;
    }

    private static class MountResult {
        private Set<ExecutionEntity> curExecutions = new HashSet<ExecutionEntity>(16);
        private Set<ExecutionEntity> curTaskExecutions = new HashSet<ExecutionEntity>(16);
        private Set<Long> procDefs = new HashSet<Long>(16);

        private MountResult() {
        }

        public void addExecution(ExecutionEntity entity) {
            this.curExecutions.add(entity);
        }

        public void addTaskExecution(ExecutionEntity entity) {
            this.curTaskExecutions.add(entity);
        }

        public Set<ExecutionEntity> getCurExecutions() {
            return this.curExecutions;
        }

        public Set<ExecutionEntity> getCurTaskExecutions() {
            return this.curTaskExecutions;
        }

        public void addExistProcDefId(Long procDefId) {
            if (WfUtils.isNotEmpty(procDefId)) {
                this.procDefs.add(procDefId);
            }
        }

        public Set<Long> getProcDefs() {
            return this.procDefs;
        }
    }
}

