/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordGroup;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordItem;
import kd.bos.workflow.engine.impl.cmd.model.ApprovalHistoryRecord;
import org.jsoup.Jsoup;

public class ApprovalRecordHtmlAdapter {
    public static List<IApprovalRecordGroup> approvalRecordHtmlAdapter(List<IApprovalRecordGroup> approvalRecordGroups) {
        for (IApprovalRecordGroup approvalRecordGroup : approvalRecordGroups) {
            List childrens = approvalRecordGroup.getChildren();
            for (IApprovalRecordItem children : childrens) {
                if (!StringUtils.isNotEmpty((CharSequence)children.getMessage())) continue;
                children.setMessage(ApprovalRecordHtmlAdapter.adaptHtml(children.getMessage()));
            }
        }
        return approvalRecordGroups;
    }

    public static List<ApprovalHistoryRecord> approvalHistoryRecordsHtmlAdapter(List<ApprovalHistoryRecord> recordList) {
        for (ApprovalHistoryRecord approvalHistoryRecord : recordList) {
            if (!StringUtils.isNotEmpty((CharSequence)approvalHistoryRecord.getMessage())) continue;
            approvalHistoryRecord.setMessage(ApprovalRecordHtmlAdapter.adaptHtml(approvalHistoryRecord.getMessage()));
        }
        return recordList;
    }

    public static String adaptHtml(String str) {
        try {
            Pattern pairTag = Pattern.compile("<([^>]+?)\\s*([^>]*)>([\\s\\S]*?)</\\1>", 2);
            Pattern singleTag = Pattern.compile("<([a-zA-Z0-9]*)\\s*([^>]*)/>", 2);
            Pattern singleTag1 = Pattern.compile("<(br|hr|img\\s+([^>]*))>", 2);
            Matcher pairMatcher = pairTag.matcher(str);
            Matcher singleMatcher = singleTag.matcher(str);
            Matcher singleMatcher1 = singleTag1.matcher(str);
            ArrayList<List<Integer>> tagStartAndEndPos = new ArrayList<List<Integer>>();
            ApprovalRecordHtmlAdapter.findHtmlTagsPosByRegex(pairMatcher, tagStartAndEndPos);
            ApprovalRecordHtmlAdapter.findHtmlTagsPosByRegex(singleMatcher, tagStartAndEndPos);
            ApprovalRecordHtmlAdapter.findHtmlTagsPosByRegex(singleMatcher1, tagStartAndEndPos);
            tagStartAndEndPos.sort((o1, o2) -> (Integer)o1.get(0) - (Integer)o2.get(0));
            StringBuilder adaptedStr = new StringBuilder();
            char[] chars = str.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                if (!(chars[i] != '<' && chars[i] != '>' || ApprovalRecordHtmlAdapter.posNotInTagPos(i, tagStartAndEndPos))) {
                    adaptedStr.append(chars[i] == '<' ? "&lt;" : "&gt;");
                    continue;
                }
                adaptedStr.append(chars[i]);
            }
            return adaptedStr.toString();
        }
        catch (Exception e) {
            return str;
        }
    }

    public static String filterHtml(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return str;
        }
        if (str.contains("<") && str.contains(">")) {
            return Jsoup.parse((String)str).text();
        }
        return str;
    }

    public static void findHtmlTagsPosByRegex(Matcher matcher, List<List<Integer>> tagStartAndEndPos) {
        while (matcher.find()) {
            ArrayList<Integer> posList = new ArrayList<Integer>(2);
            posList.add(matcher.start());
            posList.add(matcher.end() - 1);
            tagStartAndEndPos.add(posList);
        }
    }

    private static boolean posNotInTagPos(int curPos, List<List<Integer>> tagStartAndEndPos) {
        for (List<Integer> posInterval : tagStartAndEndPos) {
            int start = posInterval.get(0);
            int end = posInterval.get(1);
            if (curPos < start || curPos > end) continue;
            return true;
        }
        return false;
    }
}

