/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.util;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.AutoTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.extitf.ExtItfCallerType;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import kd.bos.workflow.engine.impl.model.ServiceInfo;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;

public class AutoTaskUtil {
    private static Log log = LogFactory.getLog(AutoTaskUtil.class);

    public static ServiceInfo getServiceInfoFromString(String infoStr) {
        ServiceInfo info = (ServiceInfo)JSON.parseObject((String)infoStr, ServiceInfo.class);
        return info;
    }

    public static Object executeExternalInterface(AutoTask autoTask, DelegateExecution execution, boolean withdraw) {
        List<String> extItfs = autoTask.getExtItf();
        if (extItfs != null && !extItfs.isEmpty()) {
            block8: for (String extItf : extItfs) {
                String entityId = autoTask.getEntityId();
                ServiceInfo info = AutoTaskUtil.getServiceInfoFromString(extItf);
                extItf = info.getExtItf();
                if (WfUtils.isNotEmpty(info.getEntityNumber()) && !info.getEntityNumber().equals(execution.getEntityNumber())) {
                    log.debug(String.format("entity is inconsistent: executionId: %s, %s - %s", execution.getId(), info.getEntityNumber(), execution.getEntityNumber()));
                    continue;
                }
                if (WfUtils.isNotEmpty(info.getEntityId())) {
                    entityId = info.getEntityId();
                }
                String type = ExternalInterfaceUtil.getExtItfType(extItf);
                ExtItfCallerType callerType = null;
                switch (type) {
                    case "operation": {
                        callerType = withdraw ? ExtItfCallerType.OPERATION_WITHDRAW : ExtItfCallerType.OPERATION;
                        AutoTaskUtil.handleOperation(extItf, entityId, execution, callerType);
                        continue block8;
                    }
                    case "function": {
                        callerType = withdraw ? ExtItfCallerType.FUNCTION_WITHDRAW : ExtItfCallerType.FUNCTION;
                        AutoTaskUtil.handleFunction(extItf, execution, callerType);
                        continue block8;
                    }
                }
                callerType = withdraw ? ExtItfCallerType.LISTENER_WITHDRAW : ExtItfCallerType.LISTENER;
                ExternalInterfaceUtil.executeExtItf(callerType, extItf, execution);
            }
        }
        return null;
    }

    public static void executeItemExternalInterface(String extItf, String entityId, DelegateExecution execution, boolean withdraw) {
        ServiceInfo info = AutoTaskUtil.getServiceInfoFromString(extItf);
        extItf = info.getExtItf();
        if (WfUtils.isNotEmpty(info.getEntityNumber()) && !info.getEntityNumber().equals(execution.getEntityNumber())) {
            log.debug(String.format("entity is inconsistent: executionId: %s, %s - %s", execution.getId(), info.getEntityNumber(), execution.getEntityNumber()));
            return;
        }
        if (WfUtils.isNotEmpty(info.getEntityId())) {
            entityId = info.getEntityId();
        }
        String type = ExternalInterfaceUtil.getExtItfType(extItf);
        ExtItfCallerType callerType = null;
        switch (type) {
            case "operation": {
                callerType = withdraw ? ExtItfCallerType.OPERATION_WITHDRAW : ExtItfCallerType.OPERATION;
                AutoTaskUtil.handleOperationWithBusinessKeys(extItf, entityId, execution, callerType);
                break;
            }
            case "function": {
                callerType = withdraw ? ExtItfCallerType.FUNCTION_WITHDRAW : ExtItfCallerType.FUNCTION;
                AutoTaskUtil.handleFunction(extItf, execution, callerType);
                break;
            }
            default: {
                callerType = withdraw ? ExtItfCallerType.LISTENER_WITHDRAW : ExtItfCallerType.LISTENER;
                ExternalInterfaceUtil.executeExtItf(callerType, extItf, execution);
            }
        }
    }

    private static Object handleOperationWithBusinessKeys(String extItf, String entityId, DelegateExecution execution, ExtItfCallerType callerType) {
        try {
            MainEntityType entity = EntityMetadataCache.getDataEntityTypeById((String)entityId);
            String entityNumber = null;
            entityNumber = entity != null && WfUtils.isNotEmpty(entity.getName()) ? entity.getName() : ((ExecutionEntity)execution).getEntityNumber();
            ArrayList<Object> params = new ArrayList<Object>(16);
            params.add(entityNumber);
            String businessKey = ((ExecutionEntity)execution).getBusinessKey();
            String businessKeysStr = (String)execution.getVariableLocal("batchCompensateBusinesskey");
            if (WfUtils.isNotEmpty(businessKeysStr)) {
                params.addAll(Arrays.asList(businessKeysStr.split("\\,")));
            }
            if (!params.contains(businessKey)) {
                params.add(businessKey);
            }
            params.add(execution);
            params.add(execution);
            return ExternalInterfaceUtil.executeExtItf(callerType, extItf, params.toArray());
        }
        catch (Exception e) {
            log.info(WfUtils.getExceptionStacktrace(e));
            throw e;
        }
    }

    private static Object handleOperation(String extItf, String entityId, DelegateExecution execution, ExtItfCallerType callerType) {
        MainEntityType entity = EntityMetadataCache.getDataEntityTypeById((String)entityId);
        String entityNumber = null;
        entityNumber = entity != null && WfUtils.isNotEmpty(entity.getName()) ? entity.getName() : ((ExecutionEntity)execution).getEntityNumber();
        String businessKey = ((ExecutionEntity)execution).getBusinessKey();
        return ExternalInterfaceUtil.executeExtItf(callerType, extItf, entityNumber, businessKey, execution, execution);
    }

    private static Object handleFunction(String extItf, DelegateExecution execution, ExtItfCallerType callerType) {
        return null;
    }
}

