/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.util;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.dao.MetadataWriter;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.BillNoField;
import kd.bos.metadata.entity.businessfield.MaterielField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.MuliLangTextField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.ButtonAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.impl.util.CollectionUtil;

public final class BillSummaryRebuildUtil {
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String FNAME = "fname";
    private static final String FILEDNAME = "fieldname";
    private static final String ENTRYLOCATIONNAME = "entrylocationname";
    private static final String ENTRYENTITY = "entryentity";
    private static final String FIELDID = "fieldid";
    private static final String FIELDKEY = "fieldkey";
    private static final String ISHEADFIELD = "isheadfield";
    private static final String ENTRYLOCATION = "entrylocation";
    private static final String FIELDPERCENT = "fieldpercent";
    private static final String FONTCOLOR = "fontcolor";
    private static final String FONTSIZE = "fontsize";
    private static final String EDITABLE = "editable";
    private static final String STRETCH = "stretch";
    private static final String COLORVALUE = "#F8F9FB";
    private static final String SELECT = "SELECT ";
    private static final String FROM = "FROM ";

    private BillSummaryRebuildUtil() {
    }

    public static void rebuildAllMetadataOfBillSummaryCfg(String summaryTplId, String billSummaryCfgNumber) {
        Object[] params;
        String nameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_mbillsummary_cfg", "a", "b", FNAME, FNAME, NAME);
        String sql = "SELECT a.fid,a.fnumber," + nameSQL + ",a.fstatus,a.fenable,a.fbilltype,a.fsummarytpl,a.fdefaultrows,a.fdefaultdatarows " + FROM + "t_wf_mbillsummarycfg a LEFT JOIN t_wf_mbillsummarycfg_l b on a.FID=b.FID and b.FLOCALEID=? ";
        String lang = RequestContext.get().getLang().name();
        if (StringUtils.isNotBlank((CharSequence)summaryTplId)) {
            sql = sql + "WHERE a.fsummarytpl= ?";
            String summaryTplnum = MetadataDao.getNumberById((String)summaryTplId);
            params = new Object[]{lang, summaryTplnum};
        } else if (StringUtils.isNotBlank((CharSequence)billSummaryCfgNumber)) {
            sql = sql + "WHERE a.fnumber= ?";
            params = new Object[]{lang, billSummaryCfgNumber};
        } else {
            return;
        }
        ArrayList<DynamicObject> billSummaryConfigObjects = new ArrayList<DynamicObject>();
        try (DataSet ds = DB.queryDataSet((String)"rebuildAllMetadataOfBillSummaryCfg", (DBRoute)DBRoute.workflow, (String)sql, (Object[])params);){
            Iterator iter = ds.iterator();
            while (iter.hasNext()) {
                DynamicObject newDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"wf_mbillsummary_cfg");
                Row row = (Row)iter.next();
                newDynamicObject.set(NUMBER, row.get("fnumber"));
                newDynamicObject.set(NAME, BillSummaryRebuildUtil.getNameValue(row.get("fid")));
                newDynamicObject.set("status", row.get("fstatus"));
                newDynamicObject.set("enable", row.get("fenable"));
                newDynamicObject.set("billtype_Id", row.get("fbilltype"));
                newDynamicObject.set("summarytplnum", row.get("fsummarytpl"));
                newDynamicObject.set("defaultrows", row.get("fdefaultrows"));
                newDynamicObject.set("defaultdatarows", row.get("fdefaultdatarows"));
                String fid = row.getString("fid");
                BillSummaryRebuildUtil.getEntryEntityDatas(newDynamicObject, fid);
                billSummaryConfigObjects.add(newDynamicObject);
            }
        }
        if (CollectionUtil.isNotEmpty(billSummaryConfigObjects)) {
            for (DynamicObject billSummmaryConfigObject : billSummaryConfigObjects) {
                BillSummaryRebuildUtil.rebuildBillSummaryConfigRuntimeMeta(billSummmaryConfigObject);
            }
        }
    }

    private static Object getNameValue(Object id) {
        String sql = "SELECT a.fid,b.flocaleid,b.fname FROM t_wf_mbillsummarycfg a LEFT JOIN t_wf_mbillsummarycfg_l b on a.FID=b.FID where a.fid=? ";
        Object[] params = new Object[]{id};
        HashMap<String, String> map = new HashMap<String, String>();
        try (DataSet ds = DB.queryDataSet((String)"getNameValue", (DBRoute)DBRoute.workflow, (String)sql, (Object[])params);){
            for (Row row : ds) {
                String namestr = row.getString(FNAME);
                String locale = row.getString("flocaleid");
                map.put(locale, namestr);
            }
        }
        return LocaleString.fromMap(map);
    }

    private static void getEntryEntityDatas(DynamicObject newDynamicObject, String fid) {
        String masterTableAlias = "a";
        String multiLangTableAlias = "b";
        String entityNumber = "wf_mbillsummary_cfg";
        String fieldNameSQL = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, "ffieldname", FILEDNAME, FILEDNAME);
        String entryLocationNameSQL = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, "fentrylocationname", ENTRYLOCATIONNAME, ENTRYLOCATIONNAME);
        String sql = "SELECT a.fentryid entryid,a.ffieldid fieldid,a.ffieldkey fieldkey," + fieldNameSQL + ",a.ffieldtype fieldtype,a.fisheadfield isheadfield,a.fisdefaultshow isdefaultshow,a.fentrylocation entrylocation,a.fentrylocationid entrylocationid," + entryLocationNameSQL + ",a.feditable editable,a.ffieldpercen fieldpercent,a.ffontcolor fontcolor,a.ffontsize fontsize " + FROM + "t_wf_mbillsumarycfgentry a LEFT JOIN t_wf_mbillsumarycfgentry_l b on a.FENTRYID=b.FENTRYID and b.FLOCALEID=? WHERE a.fid = ?";
        String lang = RequestContext.get().getLang().name();
        Object[] params = new Object[]{lang, Long.parseLong(fid)};
        DynamicObjectCollection newRets = newDynamicObject.getDynamicObjectCollection(ENTRYENTITY);
        DynamicObjectType dynamicObjectType = newRets.getDynamicObjectType();
        try (DataSet ds = DB.queryDataSet((String)"getEntryEntityDatas", (DBRoute)DBRoute.workflow, (String)sql, (Object[])params);){
            DynamicObjectCollection rets = ORM.create().toPlainDynamicObjectCollection(ds);
            for (DynamicObject dynamicObject : rets) {
                DynamicObject tempDynamicObject = (DynamicObject)dynamicObjectType.createInstance();
                tempDynamicObject.set(FIELDID, dynamicObject.get(FIELDID));
                tempDynamicObject.set(FIELDKEY, dynamicObject.get(FIELDKEY));
                tempDynamicObject.set("fieldtype", dynamicObject.get("fieldtype"));
                tempDynamicObject.set(ISHEADFIELD, dynamicObject.get(ISHEADFIELD));
                tempDynamicObject.set(EDITABLE, dynamicObject.get(EDITABLE));
                tempDynamicObject.set("isdefaultshow", dynamicObject.get("isdefaultshow"));
                tempDynamicObject.set("entrylocationid", dynamicObject.get("entrylocationid"));
                tempDynamicObject.set(ENTRYLOCATION, dynamicObject.get(ENTRYLOCATION));
                tempDynamicObject.set(FIELDPERCENT, dynamicObject.get(FIELDPERCENT));
                tempDynamicObject.set(FONTCOLOR, dynamicObject.get(FONTCOLOR));
                tempDynamicObject.set(FONTSIZE, dynamicObject.get(FONTSIZE));
                List<Object> list = BillSummaryRebuildUtil.getFieldNameValue(dynamicObject.get("entryid"));
                tempDynamicObject.set(FILEDNAME, list.get(0));
                tempDynamicObject.set(ENTRYLOCATIONNAME, list.get(1));
                newRets.add((Object)tempDynamicObject);
            }
            newDynamicObject.set(ENTRYENTITY, (Object)newRets);
        }
    }

    private static List<Object> getFieldNameValue(Object id) {
        ArrayList<Object> list = new ArrayList<Object>();
        String sql = "SELECT b.ffieldname fieldname,b.fentrylocationname entrylocationname,b.flocaleid localeid FROM t_wf_mbillsumarycfgentry_l b WHERE b.FENTRYID = ?";
        HashMap<String, String> fieldNameMap = new HashMap<String, String>();
        HashMap<String, String> entryLocationNameMap = new HashMap<String, String>();
        Object[] params = new Object[]{id};
        try (DataSet ds = DB.queryDataSet((String)"getFieldNameValue", (DBRoute)DBRoute.workflow, (String)sql, (Object[])params);){
            DynamicObjectCollection rets = ORM.create().toPlainDynamicObjectCollection(ds);
            for (DynamicObject dynamicObject : rets) {
                String locale = dynamicObject.getString("localeid");
                String fieldNameStr = dynamicObject.getString(FILEDNAME);
                String entryLocationNameStr = dynamicObject.getString(ENTRYLOCATIONNAME);
                fieldNameMap.put(locale, fieldNameStr);
                entryLocationNameMap.put(locale, entryLocationNameStr);
            }
        }
        list.add(LocaleString.fromMap(fieldNameMap));
        list.add(LocaleString.fromMap(entryLocationNameMap));
        return list;
    }

    public static AbstractMetadata buildMetadata(DynamicObject mobileConfig) {
        FlexPanelAp uiContainerMeta;
        String summaryTpl = mobileConfig.getString("summarytplnum");
        String partentId = MetadataDao.getIdByNumber((String)summaryTpl, (MetaCategory)MetaCategory.Form);
        String summaryNumber = mobileConfig.getString(NUMBER).toLowerCase();
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)partentId, (MetaCategory)MetaCategory.Form);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)partentId, (MetaCategory)MetaCategory.Entity);
        formMetadata.bindEntityMetadata(entityMetadata);
        String metaId = BillSummaryRebuildUtil.getRuntimeMetadataIdByNumber(summaryNumber);
        if (metaId == null) {
            metaId = DBServiceHelper.genStringId();
        }
        formMetadata.setId(metaId);
        entityMetadata.setId(metaId);
        formMetadata.setEntityId(metaId);
        LocaleString name = LocaleString.fromMap((Map)mobileConfig.getLocaleString(NAME));
        formMetadata.setName(name);
        entityMetadata.setName(name);
        formMetadata.setKey(summaryNumber);
        entityMetadata.setKey(summaryNumber);
        formMetadata.setParentId(partentId);
        entityMetadata.setParentId(partentId);
        formMetadata.setInheritPath(formMetadata.getInheritPath() + "," + partentId + ",/Y1PEU0BGY8S");
        entityMetadata.setInheritPath(entityMetadata.getInheritPath() + "," + partentId + ",/Y1PEU0BGY8S");
        FlexPanelAp uiHeadMeta = (FlexPanelAp)formMetadata.getItem("Y6qV0PTOrG");
        if (uiHeadMeta == null) {
            uiHeadMeta = BillSummaryRebuildUtil.createFlexContainter(formMetadata.getId(), "bill_head", ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"WorkflowServiceImpl_15", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        if ((uiContainerMeta = (FlexPanelAp)formMetadata.getItem("rj752Awy6l")) == null) {
            uiContainerMeta = BillSummaryRebuildUtil.createFlexContainter(formMetadata.getId(), "bill_entity", ResManager.loadKDString((String)"\u5355\u636e\u4f53", (String)"WorkflowServiceImpl_16", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        Map<String, Map<String, Object>> map = BillSummaryRebuildUtil.initDefaultFields(formMetadata, entityMetadata);
        HashMap entityItems = new HashMap();
        BillSummaryRebuildUtil.createMeta(mobileConfig, uiHeadMeta, uiContainerMeta, entityItems, map);
        formMetadata.getItems().addAll(uiHeadMeta.getItems());
        formMetadata.getItems().addAll(uiContainerMeta.getItems());
        formMetadata.createIndex(true);
        entityMetadata.getItems().addAll(entityItems.values());
        entityMetadata.createIndex(true);
        return formMetadata;
    }

    private static FlexPanelAp createFlexContainter(String id, String flexId, String flexName) {
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setId(DBServiceHelper.genStringId());
        flexPanelAp.setKey("flex_" + flexId);
        flexPanelAp.setName(new LocaleString(String.format(ResManager.loadKDString((String)"Flex\u9762\u677f_%s", (String)"WorkflowServiceImpl_17", (String)"bos-wf-engine", (Object[])new Object[0]), flexName)));
        flexPanelAp.setGrow(1);
        flexPanelAp.setDirection("column");
        flexPanelAp.setAlignItems(STRETCH);
        flexPanelAp.setParentId(id);
        return flexPanelAp;
    }

    private static String getRuntimeMetadataIdByNumber(String number) {
        String sql = String.format("select FID from %s where FNUMBER = ? ", "T_META_FORM");
        Object[] params = new SqlParameter[]{new SqlParameter(":FNUMBER", 12, (Object)number)};
        ResultSetHandler<String> action = new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getString("FID");
                }
                return null;
            }
        };
        return (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    private static Map<String, Map<String, Object>> initDefaultFields(FormMetadata formMetadata, EntityMetadata entityMetadata) {
        HashMap<String, Map<String, Object>> initDefaultFields = new HashMap<String, Map<String, Object>>();
        List entityItems = entityMetadata.getItems();
        for (int i = 0; i < entityItems.size(); ++i) {
            EntityItem controlAp = (EntityItem)entityItems.get(i);
            if (!controlAp.getKey().startsWith("tpl")) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("formmeta", formMetadata.getItem(controlAp.getId()));
            map.put("entitymeta", controlAp);
            String controlType = controlAp.getClass().getSimpleName();
            initDefaultFields.put(controlType, map);
        }
        return initDefaultFields;
    }

    private static void createMeta(DynamicObject mobileConfig, FlexPanelAp uiHeadMeta, FlexPanelAp uiContainerMeta, Map<String, EntityItem<?>> entityItems, Map<String, Map<String, Object>> map) {
        String entityNum = mobileConfig.getString("billtype_Id");
        MetadataReader reader = new MetadataReader();
        String entityId = reader.loadIdByNumber(entityNum, MetaCategory.Entity);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Form);
        Map<String, EntityItem<?>> mapItems = BillSummaryRebuildUtil.getItems(entityMetadata);
        ArrayList<String> flexAps = new ArrayList<String>();
        DynamicObjectCollection cfgEntries = mobileConfig.getDynamicObjectCollection(ENTRYENTITY);
        Field fieldCopy = null;
        for (int i = 0; i < cfgEntries.size(); ++i) {
            ControlAp formItem;
            DynamicObject object = (DynamicObject)cfgEntries.get(i);
            String fieldkey = object.getString(FIELDKEY);
            String fieldId = object.getString(FIELDID);
            OrmLocaleValue fieldNames = (OrmLocaleValue)object.getLocaleString(FILEDNAME);
            LocaleString fieldName = LocaleString.fromMap((Map)fieldNames);
            EntityItem<?> entity = mapItems.get(fieldkey);
            if (!(entity instanceof Field)) continue;
            Field field = (Field)entity;
            FieldAp fieldAp = new FieldAp();
            if (!object.getBoolean(EDITABLE)) {
                field.setMustInput(false);
            }
            if ((entity instanceof BillNoField || entity instanceof MaterielField) && map.get("TextField") != null) {
                field.setMustInput(false);
                BillSummaryRebuildUtil.copyProperties(fieldAp, map.get("TextField"));
            } else {
                String controlType = entity.getClass().getSimpleName();
                if (map.get(controlType) != null) {
                    BillSummaryRebuildUtil.copyProperties(fieldAp, map.get(controlType));
                } else if (!"AttachmentField".equals(controlType)) {
                    fieldAp.setLabelWidth(new LocaleString("30%"));
                    fieldAp.setTextAlign("right");
                    fieldAp.setFieldTextAlign("left");
                }
            }
            if (formMetadata != null && ((formItem = formMetadata.getItem(fieldId)) instanceof FieldAp || formItem instanceof EntryFieldAp)) {
                fieldAp.setNoDisplayScaleZero(((FieldAp)formItem).isNoDisplayScaleZero());
                fieldAp.setDisplayFormatString(((FieldAp)formItem).getDisplayFormatString());
            }
            field.setId(entity.getId());
            field.setKey(entity.getKey());
            field.setName(fieldName);
            field.setFieldName("");
            fieldCopy = fieldAp.getField();
            if (fieldCopy instanceof MuliLangTextField) {
                ((MuliLangTextField)field).setMutiLine(((MuliLangTextField)fieldCopy).isMutiLine());
            }
            fieldAp.setId(fieldId);
            fieldAp.setKey(fieldkey);
            fieldAp.setName(fieldName);
            fieldAp.setField(field);
            fieldAp.setFieldId(fieldId);
            fieldAp.setVisible(null);
            if (StringUtils.isNotBlank((CharSequence)object.getString(FIELDPERCENT))) {
                fieldAp.setLabelWidth(new LocaleString(object.getString(FIELDPERCENT)));
            }
            if (StringUtils.isNotBlank((CharSequence)object.getString(FONTCOLOR))) {
                fieldAp.setForeColor(object.getString(FONTCOLOR));
            }
            if (object.getInt(FONTSIZE) != 0) {
                fieldAp.setFontSize(object.getInt(FONTSIZE));
            }
            if (object.getBoolean(EDITABLE)) {
                fieldAp.setLock("view");
                fieldAp.setForeColor("#4598f0");
            } else {
                fieldAp.setLock("edit,new,view");
            }
            fieldAp.setParentId(uiHeadMeta.getId());
            uiHeadMeta.getItems().add(fieldAp);
            if (!object.getBoolean(ISHEADFIELD)) {
                String entryKey = object.getString(ENTRYLOCATION);
                OrmLocaleValue entryLocationName = (OrmLocaleValue)object.getLocaleString(ENTRYLOCATIONNAME);
                LocaleString entryName = LocaleString.fromMap((Map)entryLocationName);
                if (!flexAps.contains(entryKey)) {
                    flexAps.add(entryKey);
                    FlexPanelAp flexPanelAp = new FlexPanelAp();
                    flexPanelAp.setId(DBServiceHelper.genStringId());
                    flexPanelAp.setKey("flex_" + entryKey);
                    flexPanelAp.setGrow(1);
                    flexPanelAp.setDirection("row");
                    flexPanelAp.setAlignItems(STRETCH);
                    Style style = new Style();
                    Margin margin = new Margin();
                    margin.setLeft("18px");
                    margin.setTop("12px");
                    margin.setRight("13px");
                    margin.setBottom("0px");
                    style.setMargin(margin);
                    flexPanelAp.setStyle(style);
                    flexPanelAp.setAlignContent("center");
                    flexPanelAp.setHeight(new LocaleString("40px"));
                    flexPanelAp.setRadius("15px");
                    flexPanelAp.setBackColor(COLORVALUE);
                    flexPanelAp.setParentId(uiContainerMeta.getId());
                    flexPanelAp.setClickable(true);
                    FlexPanelAp flexflexAp = new FlexPanelAp();
                    flexflexAp.setId(DBServiceHelper.genStringId());
                    flexflexAp.setKey("flex_flex_" + entryKey);
                    flexflexAp.setGrow(1);
                    flexflexAp.setDirection("column");
                    flexflexAp.setAlignItems(STRETCH);
                    flexflexAp.setJustifyContent("center");
                    flexflexAp.setBackColor(COLORVALUE);
                    flexflexAp.setParentId(flexPanelAp.getId());
                    LabelAp labelAp = new LabelAp();
                    labelAp.setId(DBServiceHelper.genStringId());
                    labelAp.setKey("flex_flex_label_" + entryKey);
                    labelAp.setName(entryName);
                    labelAp.setFontSize(14);
                    Style labelStyle = new Style();
                    Margin labelMargin = new Margin();
                    labelMargin.setLeft("12px");
                    labelStyle.setMargin(labelMargin);
                    labelAp.setStyle(labelStyle);
                    labelAp.setForeColor("#1D1D1D");
                    labelAp.setBackColor(COLORVALUE);
                    labelAp.setParentId(flexflexAp.getId());
                    ButtonAp buttonAp = new ButtonAp();
                    buttonAp.setId(DBServiceHelper.genStringId());
                    buttonAp.setKey("button_" + entryKey);
                    buttonAp.setBackColor(COLORVALUE);
                    buttonAp.setButtonStyle(3);
                    buttonAp.setImgHeight("16px");
                    buttonAp.setImageKey("icons/mobile/navigation_bar/icon_details.png");
                    buttonAp.setParentId(flexPanelAp.getId());
                    uiContainerMeta.getItems().add(flexPanelAp);
                    uiContainerMeta.getItems().add(flexflexAp);
                    uiContainerMeta.getItems().add(labelAp);
                    uiContainerMeta.getItems().add(buttonAp);
                }
            }
            entityItems.put(fieldId, (EntityItem<?>)field);
        }
    }

    private static Map<String, EntityItem<?>> getItems(EntityMetadata entityMetadata) {
        HashMap mapItems = new HashMap(2);
        List items = entityMetadata.getItems();
        for (EntityItem item : items) {
            mapItems.put(item.getKey(), item);
        }
        return mapItems;
    }

    private static void copyProperties(FieldAp fieldAp, Map<String, Object> map) {
        FieldAp tplFieldAp = (FieldAp)map.get("formmeta");
        fieldAp.setAlignSelf(tplFieldAp.getAlignSelf());
        fieldAp.setBackColor(tplFieldAp.getBackColor());
        fieldAp.setComboShowStyle(tplFieldAp.getComboShowStyle());
        fieldAp.setComboShowType(tplFieldAp.getComboShowType());
        fieldAp.setCustomeStyles(tplFieldAp.getCustomeStyles());
        fieldAp.setDateSelectType(tplFieldAp.getDateSelectType());
        fieldAp.setDefaultShowPicture(tplFieldAp.getDefaultShowPicture());
        fieldAp.setDisplayFormatString(tplFieldAp.getDisplayFormatString());
        fieldAp.setFieldBackColor(tplFieldAp.getFieldBackColor());
        fieldAp.setFieldFontSize(tplFieldAp.getFieldFontSize());
        fieldAp.setFieldForeColor(tplFieldAp.getFieldForeColor());
        fieldAp.setFieldStyle(tplFieldAp.getFieldStyle());
        fieldAp.setFieldTextAlign(tplFieldAp.getFieldTextAlign());
        fieldAp.setFontSize(tplFieldAp.getFontSize());
        fieldAp.setForeColor(tplFieldAp.getForeColor());
        fieldAp.setGrow(tplFieldAp.getGrow());
        fieldAp.setHeight(tplFieldAp.getHeight());
        fieldAp.setLabelDirection(tplFieldAp.getLabelDirection());
        fieldAp.setLabelWidth(tplFieldAp.getLabelWidth());
        fieldAp.setLock(tplFieldAp.getLock());
        fieldAp.setRadius(tplFieldAp.getRadius());
        fieldAp.setShrink(tplFieldAp.getShrink());
        fieldAp.setStyle(tplFieldAp.getStyle());
        fieldAp.setTextAlign(tplFieldAp.getTextAlign());
        fieldAp.setVisible(tplFieldAp.getVisible());
        fieldAp.setWidth(tplFieldAp.getWidth());
        fieldAp.setAutoWrap(tplFieldAp.isAutoWrap());
        fieldAp.setAutoTextWrap(tplFieldAp.isAutoTextWrap());
        fieldAp.setField(tplFieldAp.getField());
    }

    public static boolean checkBillSummaryCfgNumber(String number) {
        String sql = String.format("select 1 from %s where FNUMBER = ? ", "t_wf_mbillsummarycfg");
        Object[] params = new SqlParameter[]{new SqlParameter(":FNUMBER", 12, (Object)number)};
        ResultSetHandler<Boolean> action = new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getInt(1) > 0;
                }
                return Boolean.FALSE;
            }
        };
        return (Boolean)DB.query((DBRoute)DBRoute.workflow, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    public static void rebuildBillSummaryConfigRuntimeMeta(DynamicObject billSummmaryConfigObject) {
        MetadataWriter writer = new MetadataWriter("MobileFormModel");
        AbstractMetadata metadata = BillSummaryRebuildUtil.buildMetadata(billSummmaryConfigObject);
        EntityMetadata entityMetadata = ((FormMetadata)metadata).getEntityMetadata();
        writer.rebuildRuntimeMeta(new AbstractMetadata[]{metadata, entityMetadata});
    }
}

