/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.operate.MutexHelper;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.domainmodel.Property;
import kd.bos.mutex.DataMutex;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.bpmn.converter.util.ModelConfigUtil;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.AutoTask;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.BoundaryEvent;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.ExtendAttributeGroup;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.Gateway;
import kd.bos.workflow.bpmn.model.IEntitySupport;
import kd.bos.workflow.bpmn.model.JudgeTask;
import kd.bos.workflow.bpmn.model.Macro;
import kd.bos.workflow.bpmn.model.MessageSendModel;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.RPATask;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.StartEvent;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.WaitTask;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.bpmn.model.basedata.BaseDataHelper;
import kd.bos.workflow.domain.model.NodeForkJoinModel;
import kd.bos.workflow.engine.EntityNumberConstant;
import kd.bos.workflow.engine.WfConstanst;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.dynprocess.freeflow.WFExtendAttributeGroup;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cmd.management.scheme.ProcessMultiLangDataHelper;
import kd.bos.workflow.engine.impl.cmd.model.DynamicPartialHelper;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.log.builder.AddressLogger;
import kd.bos.workflow.engine.impl.model.ServiceInfo;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.impl.util.AutoTaskUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.condition.ConditionType;
import kd.bos.workflow.engine.impl.util.condition.ConditionUtil;
import kd.bos.workflow.engine.management.batchsetting.MutexResult;
import kd.bos.workflow.engine.pojo.SchemePathItem;

public class BpmnModelUtil {
    private static Log log = LogFactory.getLog(BpmnModelUtil.class);
    private static final String OPKEY_PUBLISH = "publish";

    private BpmnModelUtil() {
    }

    public static boolean instanceofSequenceFlow(String stencilType) {
        return BpmnModelUtil.isInstanceof(stencilType, "SequenceFlow");
    }

    public static boolean instanceofStartEvent(String stencilType) {
        return BpmnModelUtil.isInstanceof(stencilType, "StartSignalEvent");
    }

    public static boolean instanceofEndEvent(String stencilType) {
        return "EndNoneEvent".equals(stencilType) || "EndTerminateEvent".equals(stencilType);
    }

    public static boolean instanceofAutoTask(String stencilType) {
        return BpmnModelUtil.isInstanceof(stencilType, "AutoTask");
    }

    public static boolean instanceofNotifyTask(String stencilType) {
        return BpmnModelUtil.isInstanceof(stencilType, "NotifyTask");
    }

    public static boolean instanceofUserTask(String stencilType) {
        return BpmnModelUtil.isInstanceof(stencilType, "UserTask");
    }

    public static boolean instanceofUserTaskExcludeSSCApprove(String stencilType) {
        return BpmnModelUtil.isInstanceof(stencilType, "UserTask") && !"SSCApprove".equals(stencilType);
    }

    public static boolean instanceofAuditTask(String stencilType) {
        return BpmnModelUtil.isInstanceof(stencilType, "AuditTask");
    }

    public static boolean instanceofBillTask(String stencilType) {
        return BpmnModelUtil.isInstanceof(stencilType, "BillTask");
    }

    public static boolean instanceofYunzhijiaTask(String stencilType) {
        return BpmnModelUtil.isInstanceof(stencilType, "YunzhijiaTask");
    }

    public static boolean instanceofSSCApprover(String stencilType) {
        return BpmnModelUtil.isInstanceof(stencilType, "SSCApprove");
    }

    public static boolean instanceofCallActivity(String stencilType) {
        return BpmnModelUtil.isInstanceof(stencilType, "CallActivity");
    }

    public static boolean instanceofSSCImageUpload(String stencilType) {
        return BpmnModelUtil.isInstanceof(stencilType, "SSCImageUpload") || BpmnModelUtil.isInstanceof(stencilType, "SSCImageUploadNew");
    }

    public static boolean instanceofMultiInstanceType(String stencilType) {
        return BpmnModelUtil.isInstanceof(stencilType, "YunzhijiaTask") || BpmnModelUtil.isInstanceof(stencilType, "CallActivity");
    }

    public static boolean isInstanceof(String instance, String clazz) {
        if (clazz.equals(instance)) {
            return true;
        }
        String parent = ModelConfigUtil.getInheritStencilType(instance);
        while (parent != null) {
            if (parent.equals(clazz)) {
                return true;
            }
            parent = ModelConfigUtil.getInheritStencilType(parent);
        }
        return false;
    }

    public static String getYunzhijiaVoteRule(YunzhijiaTask task) {
        StringBuilder ret = new StringBuilder(ResManager.loadKDString((String)"\u901a\u8fc7\u89c4\u5219\uff1a", (String)"BpmnModelUtil_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        switch (task.getBusinessModel()) {
            case "oneVoteVeto": {
                ret.append(ResManager.loadKDString((String)"\u5168\u90e8\u901a\u8fc7", (String)"BpmnModelUtil_2", (String)"bos-wf-engine", (Object[])new Object[0]));
                break;
            }
            case "allVote": {
                ret.append(ResManager.loadKDString((String)"\u5168\u5458\u6295\u7968\u4e14", (String)"BpmnModelUtil_3", (String)"bos-wf-engine", (Object[])new Object[0])).append(BpmnModelUtil.getPassRuleTip(task)).append(ResManager.loadKDString((String)"\u6210\u5458\u540c\u610f", (String)"BpmnModelUtil_4", (String)"bos-wf-engine", (Object[])new Object[0]));
                break;
            }
            case "voteOnProportion": {
                ret.append(ResManager.loadKDString((String)"\u90e8\u5206\u6295\u7968\u4e14", (String)"BpmnModelUtil_5", (String)"bos-wf-engine", (Object[])new Object[0])).append(BpmnModelUtil.getPassRuleTip(task)).append(ResManager.loadKDString((String)"\u6210\u5458\u540c\u610f", (String)"BpmnModelUtil_4", (String)"bos-wf-engine", (Object[])new Object[0]));
                break;
            }
            case "voteByPassProportion": {
                ret.append(ResManager.loadKDString((String)"\u540c\u610f\u6bd4\u4f8b\u8fbe\u5230", (String)"BpmnModelUtil_6", (String)"bos-wf-engine", (Object[])new Object[0])).append(BpmnModelUtil.getPassRuleTip(task));
                break;
            }
            case "custom": {
                ret.append(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u4e1a\u52a1\u6a21\u5f0f", (String)"BusinessModelSemanticizer_5", (String)"bos-wf-engine", (Object[])new Object[0]));
                break;
            }
            default: {
                ret.append(ResManager.loadKDString((String)"\u4e00\u7968\u901a\u8fc7", (String)"BpmnModelUtil_7", (String)"bos-wf-engine", (Object[])new Object[0]));
            }
        }
        return ret.toString();
    }

    public static String getYunzhijiaThroughRules(YunzhijiaTask yunzhijiaTask, Long processinstanceId) {
        String throughRules = "";
        boolean isShowThroughRules = yunzhijiaTask.isShowThroughRules();
        log.debug("isShowThroughRules\u4e3a\uff1a" + isShowThroughRules);
        if (isShowThroughRules) {
            String throughRulesType = yunzhijiaTask.getThroughRulesType();
            log.debug("throughRulesType\u4e3a\uff1a" + throughRulesType);
            if (WfUtils.isEmpty(throughRulesType) || "initialization".equals(throughRulesType)) {
                throughRules = BpmnModelUtil.getYunzhijiaVoteRule(yunzhijiaTask);
            } else if ("custom".equals(throughRulesType)) {
                String multiKey;
                throughRules = yunzhijiaTask.getRulesContent();
                JSONObject multiLangDatas = BpmnModelUtil.getMultiLangDatas(processinstanceId);
                ILocaleString throughRulesMulti = BpmnModelUtil.getMultiLangFieldValue(multiLangDatas, multiKey = String.format("%s.rulesContent", yunzhijiaTask.getId()), throughRules);
                if (throughRulesMulti != null && WfUtils.isNotEmpty(throughRulesMulti)) {
                    throughRules = (String)throughRulesMulti.get((Object)RequestContext.get().getLang().toString());
                }
            }
        }
        log.debug("throughRules\u4e3a\uff1a" + throughRules);
        return throughRules;
    }

    private static String getPassRuleTip(YunzhijiaTask task) {
        if ("passByFraction".equals(task.getPasstype())) {
            return task.getPassfraction();
        }
        if ("passByAnyOne".equals(task.getPasstype())) {
            return ResManager.loadKDString((String)"\u4efb\u4e00", (String)"BpmnModelUtil_15", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        return String.format("%s%s", task.getPassPercentage(), "%");
    }

    public static boolean hasProperty(Map<String, Object> node, String prop) {
        if (WfUtils.isEmpty(prop)) {
            return false;
        }
        if (prop.indexOf(46) < 0) {
            return node.containsKey(prop);
        }
        String name = null;
        String[] names = prop.split("\\.");
        name = names[0];
        Object value = node.get(name);
        if (value instanceof Map) {
            return BpmnModelUtil.hasProperty((Map)value, prop.replaceFirst(name + "\\.", ""));
        }
        return false;
    }

    public static Object getProperty(Map<String, Object> node, String prop) {
        if (node == null) {
            return null;
        }
        if (WfUtils.isEmpty(prop)) {
            return null;
        }
        if (prop.indexOf(46) < 0) {
            return BpmnModelUtil.getSimplePropertyValue(node, prop);
        }
        String name = null;
        String[] names = prop.split("\\.");
        name = names[0];
        Object value = node.get(name);
        if (value instanceof Map) {
            return BpmnModelUtil.getProperty((Map)value, prop.replaceFirst(name + "\\.", ""));
        }
        return value;
    }

    public static Object getProcessNodeProperty(String modelJson, String nodeId, String property) {
        JSONObject model = JSON.parseObject((String)modelJson);
        JSONObject node = BpmnModelUtil.getNodeJSON(model, nodeId);
        if (node != null) {
            return BpmnModelUtil.getProperty((Map<String, Object>)node, property);
        }
        return null;
    }

    public static Object getProcessNodeProperty(JSONObject model, String nodeId, String property) {
        JSONObject node = BpmnModelUtil.getNodeJSON(model, nodeId);
        if (node != null) {
            return BpmnModelUtil.getProperty((Map<String, Object>)node, property);
        }
        return null;
    }

    public static Object getProcessProperty(String modelJson, String property) {
        JSONObject model = JSON.parseObject((String)modelJson);
        return BpmnModelUtil.getProperty((Map<String, Object>)model, property);
    }

    public static JSONObject getNodeJSON(JSONObject model, String nodeId) {
        JSONArray children = model.getJSONArray("childShapes");
        int size = children.size();
        JSONObject child = null;
        for (int i = 0; i < size; ++i) {
            child = children.getJSONObject(i);
            if (!nodeId.equals(child.getString("resourceId"))) continue;
            return child;
        }
        return null;
    }

    public static JSONObject getNodeJSON(String modelStr, String nodeId) {
        JSONObject model = JSONObject.parseObject((String)modelStr);
        return BpmnModelUtil.getNodeJSON(model, nodeId);
    }

    public static Object getSimplePropertyValue(Map<String, Object> node, String prop) {
        if (node == null || WfUtils.isEmpty(prop)) {
            return null;
        }
        for (Map.Entry<String, Object> entry : node.entrySet()) {
            String key = entry.getKey();
            if (!prop.equalsIgnoreCase(key)) continue;
            return node.get(key);
        }
        return null;
    }

    public static void setProperty(Map<String, Object> node, String prop, Object value) {
        HashMap obj;
        if (WfUtils.isEmpty(prop)) {
            return;
        }
        if (prop.indexOf(46) < 0) {
            node.put(prop, value);
            return;
        }
        String name = null;
        String[] names = prop.split("\\.");
        name = names[0];
        HashMap hashMap = obj = node == null ? null : node.get(name);
        if (obj == null) {
            obj = new HashMap();
            ((Map)obj).put(names[1], value);
            BpmnModelUtil.setProperty(node, name, obj);
        } else if (obj instanceof Map) {
            BpmnModelUtil.setProperty(obj, prop.replaceFirst(name + "\\.", ""), value);
        }
    }

    public static void deleteProperty(Map<String, Object> node, String prop) {
        if (WfUtils.isEmpty(prop)) {
            return;
        }
        if (prop.indexOf(46) < 0) {
            node.remove(prop);
            return;
        }
        String[] names = prop.split("\\.");
        Object obj = node.get(names[0]);
        if (obj instanceof Map) {
            ((Map)obj).remove(names[1]);
        }
    }

    public static void disposeDynamicPartial(String modelJson, Long modelId) {
        if (WfUtils.isEmpty(modelId) || WfUtils.isEmpty(modelJson)) {
            return;
        }
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(modelJson);
        DynamicPartialHelper.disposeDynamicPartial(bpmnModel.getMainProcess(), modelId, null, null);
    }

    public static void disposeDynamicPartial(String modelJson, DynamicConfigSchemeEntity scheme) {
        if (WfUtils.isEmpty(modelJson) || scheme == null) {
            return;
        }
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(modelJson);
        BpmnModelUtil.disposeDynamicPartial(bpmnModel, scheme);
    }

    public static void disposeDynamicPartial(BpmnModel bpmnModel, DynamicConfigSchemeEntity scheme) {
        DynamicPartialHelper.disposeDynamicPartial(bpmnModel.getMainProcess(), null, scheme.getProcDefId(), scheme.getId());
    }

    public static List<Macro> loadDefaultNodeMacro(BaseElement elem, String processType, String stencilType) {
        ArrayList<Macro> macros = new ArrayList<Macro>();
        String modelType = GraphCodecUtils.getModelTypeByProcessType(processType);
        try {
            List<Property> properties = GraphCodecUtils.getNodeProperties(modelType, stencilType);
            if (properties == null) {
                return macros;
            }
            for (Property property : properties) {
                if (!"macros".equals(property.getPropertyName())) continue;
                Map editor = property.getEditor();
                if (editor == null) {
                    return macros;
                }
                Object defaultVal = editor.get("default");
                if (defaultVal == null) {
                    return macros;
                }
                if (defaultVal instanceof ArrayList) {
                    for (Object value : (ArrayList)defaultVal) {
                        if (!(value instanceof Map)) continue;
                        Map val = (Map)value;
                        Macro macro = new Macro();
                        macro.setName(BpmnModelUtil.getFormattedValue(elem, (String)val.get("name")));
                        macro.setDescription(BpmnModelUtil.getFormattedValue(elem, (String)val.get("description")));
                        macro.setType((String)val.get("type"));
                        macro.setParseClass((String)val.get("parseClass"));
                        macro.setDataType((String)val.get("dataType"));
                        macros.add(macro);
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            log.error(String.format("\u83b7\u53d6 %s \u7684\u5b8f\u51fa\u9519\uff01%s", elem.getId(), WfUtils.getExceptionStacktrace(e)));
        }
        return macros;
    }

    private static String getFormattedValue(BaseElement elem, String value) {
        String regex = "\\$\\{node.(\\w+)\\}";
        String PROP_ITEMID = "itemId";
        String PROP_NAME = "name";
        String PROP_TYPE = "type";
        if (WfUtils.isEmpty(value)) {
            return value;
        }
        Pattern pattern = Pattern.compile("\\$\\{node.(\\w+)\\}");
        Matcher matcher = pattern.matcher(value);
        String val = null;
        while (matcher.find()) {
            String prop;
            String all = matcher.group();
            switch (prop = matcher.group(1)) {
                case "itemId": {
                    val = elem.getId();
                    break;
                }
                case "name": {
                    val = elem.getName();
                    break;
                }
                case "type": {
                    val = elem.getType();
                    break;
                }
                default: {
                    val = null;
                }
            }
            if (val == null) continue;
            value = value.replace(all, val);
        }
        return value;
    }

    public static UserTask getFirstUserTask(Process process) {
        List<UserTask> elements = process.findFlowElementsOfType(UserTask.class);
        for (UserTask userTask : elements) {
            for (SequenceFlow flow : userTask.getIncomingFlows()) {
                if (!(process.getFlowElement(flow.getSourceRef()) instanceof StartEvent)) continue;
                return userTask;
            }
        }
        return null;
    }

    public static List<UserTask> getFirstUserTasks(Process process) {
        List<UserTask> elements = process.findFlowElementsOfType(UserTask.class);
        ArrayList<UserTask> userTasks = new ArrayList<UserTask>(elements.size());
        block0: for (UserTask userTask : elements) {
            for (SequenceFlow flow : userTask.getIncomingFlows()) {
                if (!(process.getFlowElement(flow.getSourceRef()) instanceof StartEvent)) continue;
                userTasks.add(userTask);
                continue block0;
            }
        }
        return userTasks;
    }

    public static boolean instanceofUserTaskOnly(String stencilType) {
        return BpmnModelUtil.instanceofUserTask(stencilType) && !BpmnModelUtil.instanceofAuditTask(stencilType);
    }

    public static List<FlowElement> getPreviousNodes(String modelJson, String nodeId) throws IOException {
        BpmnModel model = ProcessDefinitionUtil.getBpmnModel(modelJson);
        return BpmnModelUtil.getPreviousNodes(model, nodeId);
    }

    public static List<FlowElement> getPreviousNodes(BpmnModel model, String nodeId) {
        return model.getPreviousNodes(nodeId);
    }

    public static List<FlowElement> getFollowNodes(BpmnModel model, String nodeId) {
        return model.getFollowNodes(nodeId);
    }

    public static boolean isEmptyResource(String json) {
        String temp = null;
        return json == null || "".equals(temp = json.trim()) || "{}".equals(temp);
    }

    public static String getProcessPropertyMultiKey(String property) {
        return String.format("node_1.%s", property);
    }

    public static String getActivityNameMultiKey(String activityId) {
        return String.format("%s.name", activityId);
    }

    public static String getEntityNameMultiKey(String activityId) {
        return String.format("%s.entityName", activityId);
    }

    public static String getDecisionNameMultiKey(String activityId, String decisionItemId) {
        return String.format("%s.decisionOptions.[%s].name", activityId, decisionItemId);
    }

    public static String getMessageContextMultiKey(String activityId, String msgItemId, boolean out) {
        String type = out ? "outMsg" : "inMsg";
        return String.format("%s.%s.[%s].content", activityId, type, msgItemId);
    }

    public static String getMessageTitleMultiKey(String activityId, String msgItemId, boolean out) {
        String type = out ? "outMsg" : "inMsg";
        return String.format("%s.%s.[%s].notifysubject", activityId, type, msgItemId);
    }

    public static JSONObject getMultiLangDatas(Long processInstanceId) {
        ProcessMultiLangDataHelper helper = new ProcessMultiLangDataHelper();
        JSONObject data = helper.getConfigSchemeMultiLangData(processInstanceId);
        if (data == null || data.size() == 0) {
            return data;
        }
        Lang[] langs = WfUtils.getSupportLangs();
        String currentLanuage = null;
        for (Lang lang : langs) {
            String key = lang.name();
            JSONObject datas = data.getJSONObject(key);
            if (!WfUtils.isEmptyForMap((Map)datas)) continue;
            if (currentLanuage == null) {
                currentLanuage = BpmnModelUtil.getCurrentLanguage(processInstanceId);
            }
            data.put(key, (Object)data.getJSONObject(currentLanuage));
        }
        return data;
    }

    private static String getCurrentLanguage(Long processInstanceId) {
        Long schemeId = WfCacheHelper.getCachedSchemeId(processInstanceId);
        try {
            DynamicObject object;
            if (WfUtils.isEmpty(schemeId) && (object = QueryServiceHelper.queryOne((String)EntityNumberConstant.getHiProcInstEntityNumber(), (String)"schemeid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)processInstanceId)})) != null) {
                schemeId = object.getLong("schemeid");
            }
            if (WfUtils.isEmpty(schemeId)) {
                return " ";
            }
            DynamicObject dynamicConfigSchemeObj = QueryServiceHelper.queryOne((String)"wf_processdynamicconfig", (String)"id,jsonresourceid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)schemeId)});
            if (dynamicConfigSchemeObj != null) {
                QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)dynamicConfigSchemeObj.getLong("jsonresourceid"))};
                DynamicObject resources = QueryServiceHelper.queryOne((String)"wf_resource", (String)"currentlanguage", (QFilter[])filters);
                return resources.getString("currentlanguage");
            }
        }
        catch (Exception e) {
            log.warn(WfUtils.getExceptionStacktrace(e));
        }
        return " ";
    }

    public static JSONObject getMultiLangDatasFromResource(ResourceEntity resource) {
        ProcessMultiLangDataHelper helper = new ProcessMultiLangDataHelper();
        JSONObject data = helper.getResourceMultiLangData(resource);
        return data;
    }

    public static ILocaleString getMultiLangFieldValue(JSONObject multiLangDatas, String multiKey, String defaultValue) {
        LocaleString value;
        LocaleString localeString = value = defaultValue != null ? new LocaleString(defaultValue) : new LocaleString();
        if (multiLangDatas != null && multiKey != null) {
            JSONObject datas = null;
            String val = null;
            String zhCNVal = null;
            JSONObject zhCNDatas = multiLangDatas.getJSONObject(WfConstanst.LOCALE_ZH_CN);
            if (zhCNDatas != null && (val = zhCNDatas.getString(multiKey)) != null) {
                zhCNVal = val;
                value.put((Object)WfConstanst.LOCALE_ZH_CN, (Object)zhCNVal);
            }
            for (String key : multiLangDatas.keySet()) {
                if (WfConstanst.LOCALE_ZH_CN.equals(key)) continue;
                datas = multiLangDatas.getJSONObject(key);
                if (datas != null && (val = datas.getString(multiKey)) != null) {
                    value.put((Object)key, (Object)val);
                    continue;
                }
                if (zhCNVal == null) continue;
                value.put((Object)key, (Object)zhCNVal);
            }
        }
        return value.keySet().isEmpty() ? null : value;
    }

    public static ILocaleString getMultiLangFieldValueFromResource(ResourceEntity resource, String multiKey, String defaultValue) {
        JSONObject multiLangDatas = BpmnModelUtil.getMultiLangDatasFromResource(resource);
        return BpmnModelUtil.getMultiLangFieldValue(multiLangDatas, multiKey, defaultValue);
    }

    public static ILocaleString getMultiLangFieldValue(Long processInstanceId, String multiKey, String defaultValue) {
        JSONObject multiLangDatas = BpmnModelUtil.getMultiLangDatas(processInstanceId);
        return BpmnModelUtil.getMultiLangFieldValue(multiLangDatas, multiKey, defaultValue);
    }

    public static List<MessageSendModel> getClonedMessageModel(List<MessageSendModel> models) {
        ArrayList<MessageSendModel> clone = new ArrayList<MessageSendModel>(models.size());
        for (MessageSendModel model : models) {
            clone.add(model.clone());
        }
        return clone;
    }

    public static List<FlowElement> getJumpNodes(BpmnModel model, String nodeId) {
        ArrayList<FlowElement> result = new ArrayList<FlowElement>();
        Process process = model.getMainProcess();
        Map<String, List<FlowNode>> boundaryNodes = process.getBoundaryNodes();
        String boundaryNodeId = process.getBoundaryEventId(nodeId);
        if (WfUtils.isNotEmpty(boundaryNodeId)) {
            result.addAll((Collection)boundaryNodes.get(boundaryNodeId));
        } else {
            try {
                result.addAll(BpmnModelUtil.getRejectNodes(model, nodeId));
                Map<String, NodeForkJoinModel> models = process.getForkJoinModels();
                NodeForkJoinModel fjModel = models.get(nodeId);
                if (fjModel != null) {
                    String structre = fjModel.getForkStructure();
                    for (FlowElement ele : process.getFlowElements()) {
                        NodeForkJoinModel tmp;
                        if (!(ele instanceof FlowNode) || result.contains(ele) || (tmp = models.get(ele.getId())) == null || structre == null || !structre.equals(tmp.getForkStructure()) || tmp.isJoinNode()) continue;
                        result.add(ele);
                    }
                }
            }
            catch (Exception e) {
                log.error(WfUtils.getExceptionStacktrace(e));
            }
        }
        ArrayList<FlowElement> tmp = new ArrayList<FlowElement>();
        for (FlowElement f : result) {
            if (f instanceof Gateway || f instanceof RPATask || f instanceof JudgeTask) continue;
            tmp.add(f);
        }
        return tmp;
    }

    public static List<FlowElement> getRejectNodes(BpmnModel model, String nodeId) throws JsonProcessingException, IOException {
        ArrayList<FlowElement> result = new ArrayList<FlowElement>();
        Process process = model.getMainProcess();
        String boundaryNodeId = process.getBoundaryEventId(nodeId);
        if (WfUtils.isNotEmpty(boundaryNodeId)) {
            FlowNode fn = (FlowNode)process.getFlowElement(nodeId);
            Set<String> nonBoundaryNodes = process.getNonBoundaryNodes();
            while (!(fn == null || fn instanceof BoundaryEvent || nonBoundaryNodes.contains(fn.getId()) || result.contains(fn))) {
                if (!nodeId.equals(fn.getId())) {
                    result.add(fn);
                }
                List<SequenceFlow> inFlows = fn.getIncomingFlows();
                for (SequenceFlow s : inFlows) {
                    if (s.isDynamic()) continue;
                    fn = (FlowNode)s.getSourceFlowElement();
                }
            }
        } else {
            List<FlowElement> preNodes = BpmnModelUtil.getPreviousNodes(model, nodeId);
            ArrayList<FlowElement> filterPreNodes = new ArrayList<FlowElement>();
            boolean flag = false;
            try {
                Map<String, NodeForkJoinModel> models = model.getMainProcess().getForkJoinModels();
                if (models != null && models.get(nodeId) != null) {
                    NodeForkJoinModel m = models.get(nodeId);
                    String structure = m.getForkStructure();
                    HashSet<String> ss = new HashSet<String>();
                    ss.add(structure);
                    if (structure.contains("$")) {
                        ss.add(structure.substring(0, structure.lastIndexOf(36)));
                    }
                    for (FlowElement f : preNodes) {
                        NodeForkJoinModel fjm = models.get(f.getId());
                        if (fjm == null || !ss.contains(fjm.getForkStructure()) || filterPreNodes.contains(f) || fjm.isJoinNode()) continue;
                        filterPreNodes.add(f);
                    }
                    flag = true;
                }
            }
            catch (Exception e) {
                log.error(WfUtils.getExceptionStacktrace(e));
            }
            if (flag) {
                result.addAll(filterPreNodes);
            } else {
                result.addAll(preNodes);
            }
        }
        ArrayList<FlowElement> tmp = new ArrayList<FlowElement>(result.size());
        ArrayList<BoundaryEvent> boundaryEvents = new ArrayList<BoundaryEvent>();
        for (FlowElement f : result) {
            if (f instanceof BoundaryEvent) {
                boundaryEvents.add((BoundaryEvent)f);
                continue;
            }
            if (f instanceof Gateway || f instanceof WaitTask || f instanceof RPATask || f instanceof JudgeTask) continue;
            tmp.add(f);
        }
        if (!boundaryEvents.isEmpty()) {
            for (BoundaryEvent event : boundaryEvents) {
                FlowElement refElement = process.getFlowElement(event.getAttachedToRefId());
                if (refElement == null || tmp.contains(refElement)) continue;
                tmp.add(refElement);
            }
        }
        return tmp;
    }

    public static String getCopyValueForReplace(String originalValue, String oldValue, String newValue) {
        String copyValueForReplace = null;
        if (WfUtils.isNotEmpty(newValue)) {
            copyValueForReplace = WfUtils.isNotEmpty(originalValue) ? originalValue.replace(oldValue, newValue) : originalValue;
        }
        return copyValueForReplace;
    }

    public static boolean isBizFlow(String type) {
        return ModelType.BizFlow.toString().equals(type);
    }

    public static <T> Map<String, T> copyForMap(String oldValue, String newValue, Map<String, T> map) {
        HashMap<String, T> newMap = null;
        if (null != map && 0 != map.size()) {
            newMap = new HashMap<String, T>(map.size());
            Set<Map.Entry<String, T>> keys = map.entrySet();
            Iterator<Map.Entry<String, T>> ite = keys.iterator();
            Map.Entry<String, T> entry = null;
            String key = null;
            while (ite.hasNext()) {
                entry = ite.next();
                key = BpmnModelUtil.getCopyValueForReplace(entry.getKey(), oldValue, newValue);
                if (!WfUtils.isNotEmpty(key)) continue;
                newMap.put(key, entry.getValue());
            }
        }
        return newMap;
    }

    public static boolean isFirstNodeByModel(FlowNode flowNode) {
        boolean first = false;
        if (flowNode.getIncomingFlows() != null) {
            List<SequenceFlow> tmp = flowNode.getIncomingFlows();
            for (SequenceFlow seq : tmp) {
                if (seq == null || seq.getSourceFlowElement() == null || !(seq.getSourceFlowElement() instanceof StartEvent)) continue;
                first = true;
                break;
            }
        }
        return first;
    }

    public static boolean isSkipFirstUserTaskByPath(DelegateExecution execution) {
        boolean first = false;
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        HistoricActivityInstanceEntityManager hisActivityManager = processEngineConfiguration.getHistoricActivityInstanceEntityManager();
        List<HistoricActivityInstanceEntity> seqNodes = hisActivityManager.findByTargetId(execution.getProcessInstanceId(), execution.getCurrentActInstId());
        block0: for (HistoricActivityInstanceEntity seqInst : seqNodes) {
            List<HistoricActivityInstanceEntity> preNodes = hisActivityManager.findByTargetId(execution.getProcessInstanceId(), seqInst.getId());
            for (HistoricActivityInstanceEntity nodeInst : preNodes) {
                if (!nodeInst.getActivityType().equals("StartSignalEvent")) continue;
                first = true;
                continue block0;
            }
        }
        return first;
    }

    public static List<SequenceFlow> sortOutgoingFlowsByJudgeTaskSeq(List<SequenceFlow> outgoingFlows) {
        TreeMap<Integer, ArrayList<SequenceFlow>> map = new TreeMap<Integer, ArrayList<SequenceFlow>>();
        ArrayList<SequenceFlow> ret = new ArrayList<SequenceFlow>(outgoingFlows.size());
        for (SequenceFlow flow : outgoingFlows) {
            FlowElement target = flow.getTargetFlowElement();
            if (target instanceof JudgeTask) {
                int seq = ((JudgeTask)target).getSeq();
                ArrayList<SequenceFlow> flows = (ArrayList<SequenceFlow>)map.get(seq);
                if (flows == null) {
                    flows = new ArrayList<SequenceFlow>();
                    map.put(seq, flows);
                }
                flows.add(flow);
                continue;
            }
            ret.add(flow);
        }
        for (List flows : map.values()) {
            ret.addAll(flows);
        }
        return ret;
    }

    public static DecisionOption getDecisionOption(AuditTask auditTask, String auditNumber) {
        if (auditTask == null) {
            return null;
        }
        List<DecisionOption> dos = auditTask.getDecisionOptions();
        for (DecisionOption d : dos) {
            if (!d.getNumber().equals(auditNumber)) continue;
            return d;
        }
        return null;
    }

    public static DecisionOption getDefaultOption(FlowElement elem) {
        AuditTask audit;
        DecisionOption defVal = null;
        if (elem instanceof AuditTask && (audit = (AuditTask)elem).getDecisionOptions() != null) {
            for (DecisionOption op : audit.getDecisionOptions()) {
                if (op.isDefaultDecision()) {
                    defVal = op;
                    break;
                }
                if (defVal != null || !"approve".equalsIgnoreCase(op.getAuditType())) continue;
                defVal = op;
            }
        }
        return defVal;
    }

    public static String getDefaultOptionNumber(FlowElement elem) {
        DecisionOption defVal = BpmnModelUtil.getDefaultOption(elem);
        return defVal == null ? null : defVal.getNumber();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MutexResult requirePublishOrImportProcessMutexLock(String type, String processNumber) {
        MutexResult result = new MutexResult();
        result.setSuccess(true);
        String entityId = "wf_processdefinitioninfo";
        String mutexGroupId = MutexHelper.getMutexGroupId((String)entityId, (String)OPKEY_PUBLISH);
        if (WfUtils.isEmpty(mutexGroupId)) return result;
        if (WfUtils.isEmpty(processNumber)) {
            return result;
        }
        log.debug(String.format("require %s %s mutex.", type, processNumber));
        String userId = RequestContext.get().getUserId();
        try (DataMutex dataMutex = DataMutex.create();){
            Map lockInfo;
            String dataObjectId = null;
            if ("import".equals(type)) {
                dataObjectId = BpmnModelUtil.getMutexDataObjectId(OPKEY_PUBLISH, processNumber);
                Map publishLockInfo = dataMutex.getLockInfo(dataObjectId, mutexGroupId, entityId);
                if (publishLockInfo != null) {
                    log.debug(String.format("\u5f53\u524d\u5df2\u6709 %s\u53d1\u5e03%s\u6d41\u7a0b\u7684\u9501\u3002 ", userId, processNumber));
                    BpmnModelUtil.setFailedMutexResult(result, publishLockInfo);
                    MutexResult mutexResult = result;
                    return mutexResult;
                }
            } else {
                dataObjectId = BpmnModelUtil.getMutexDataObjectId("import", processNumber);
                Map importLockInfo = dataMutex.getLockInfo(dataObjectId, mutexGroupId, entityId);
                if (importLockInfo != null) {
                    log.debug(String.format("\u5f53\u524d\u5df2\u6709 %s\u5bfc\u5165%s\u6d41\u7a0b\u7684\u9501\u3002 ", userId, processNumber));
                    BpmnModelUtil.setFailedMutexResult(result, importLockInfo);
                    MutexResult mutexResult = result;
                    return mutexResult;
                }
            }
            if ((lockInfo = dataMutex.getLockInfo(dataObjectId = BpmnModelUtil.getMutexDataObjectId(type, processNumber), mutexGroupId, entityId)) != null) {
                log.debug(String.format("\u5f53\u524d\u5df2\u6709 %s %s %s\u6d41\u7a0b\u7684\u9501\u3002 ", userId, type, processNumber));
                BpmnModelUtil.setFailedMutexResult(result, lockInfo);
                MutexResult mutexResult = result;
                return mutexResult;
            }
            boolean isSuccess = dataMutex.require(dataObjectId, mutexGroupId, entityId, OPKEY_PUBLISH, true);
            result.setSuccess(isSuccess);
            if (isSuccess) return result;
            BpmnModelUtil.setFailedMutexResult(result, dataMutex.getLockInfo());
            return result;
        }
        catch (IOException e) {
            log.error(WfUtils.getExceptionStacktrace(e));
        }
        return result;
    }

    private static String getMutexDataObjectId(String type, String processNumber) {
        return String.format("%s_process_%s", type, processNumber);
    }

    public static void releasePublishOrImportProcessMutexLock(String type, String processNumber) {
        MutexHelper.release((String)"wf_processdefinitioninfo", (String)OPKEY_PUBLISH, (String)BpmnModelUtil.getMutexDataObjectId(type, processNumber));
    }

    private static void setFailedMutexResult(MutexResult result, Map<String, String> lockInfo) {
        result.setSuccess(false);
        if (lockInfo == null) {
            return;
        }
        String userIdStr = lockInfo.get("userid");
        if (WfUtils.isNotEmpty(userIdStr)) {
            result.setUserId(Long.parseLong(userIdStr));
        }
    }

    public static String getFirstApproveOptNum(FlowElement elem) {
        AuditTask audit;
        String defVal = null;
        if (elem instanceof AuditTask && (audit = (AuditTask)elem).getDecisionOptions() != null) {
            for (DecisionOption op : audit.getDecisionOptions()) {
                if (!"approve".equalsIgnoreCase(op.getAuditType())) continue;
                defVal = op.getNumber();
                break;
            }
        }
        return defVal;
    }

    public static String getApproveTypeByNum(FlowElement elem, String optNum) {
        AuditTask audit;
        String ret = null;
        if (elem instanceof AuditTask && (audit = (AuditTask)elem).getDecisionOptions() != null) {
            for (DecisionOption op : audit.getDecisionOptions()) {
                if (null == op || null == op.getNumber() || !op.getNumber().equals(optNum)) continue;
                ret = op.getAuditType();
            }
        }
        return ret;
    }

    public static Long filterSchemeByCondition(CommandContext commandContext, Map<String, Object> target, VariableScope bizScope) {
        return BpmnModelUtil.filterSchemeByProcdefId(commandContext, (Long)target.get("id"), bizScope);
    }

    public static Long filterSchemeByProcdefId(CommandContext commandContext, Long procDefId, VariableScope bizScope) {
        AddressLogger addressLogger = AddressLogger.get(commandContext);
        List<DynamicConfigSchemeEntity> schemes = commandContext.getDynamicConfigSchemeEntityManager().getActiveSchemesByProcDefId(procDefId);
        Long defaultSchemeId = null;
        LinkedHashMap<Long, SchemePathItem> schemePathItems = new LinkedHashMap<Long, SchemePathItem>();
        if (schemes != null && !schemes.isEmpty()) {
            Iterator<DynamicConfigSchemeEntity> iter = schemes.iterator();
            while (iter.hasNext()) {
                DynamicConfigSchemeEntity tmp = iter.next();
                SchemePathItem schemePathItem = new SchemePathItem(tmp);
                ConditionType.logOpDesc(schemePathItem.getShowText());
                schemePathItems.put(tmp.getSchemeId(), schemePathItem);
                if (tmp.isAcquiescence()) {
                    defaultSchemeId = tmp.getId();
                    iter.remove();
                    continue;
                }
                String condition = tmp.getConditionExpression();
                if (!WfUtils.isNotEmpty(condition)) continue;
                bizScope.setVariable("processDefinitionId", procDefId);
                String schemeName = "";
                if (tmp.getName() != null) {
                    schemeName = tmp.getName().getLocaleValue();
                }
                bizScope.setVariable("schemeName", schemeName);
                boolean match = ConditionUtil.hasTrueCondition(condition, bizScope, "addressScheme_[" + tmp.getSchemeId() + "]");
                schemePathItem.setParsedCondition(bizScope);
                schemePathItem.setConditionStatus(match);
                if (match) continue;
                iter.remove();
            }
        }
        Long result = null;
        if (schemes != null && !schemes.isEmpty()) {
            result = schemes.get(0).getId();
        } else if (defaultSchemeId != null) {
            result = defaultSchemeId;
        }
        addressLogger.logEnteredProcessSchemeList(new ArrayList<SchemePathItem>(schemePathItems.values())).logEnteredProcessTargetScheme((SchemePathItem)schemePathItems.get(result));
        return result;
    }

    public static String getDecisionType(AuditTask auditTask, String decisionNum) {
        if (decisionNum != null && auditTask != null && auditTask.getDecisionOptions() != null) {
            for (DecisionOption dop : auditTask.getDecisionOptions()) {
                if (!dop.getNumber().equalsIgnoreCase(decisionNum)) continue;
                return dop.getAuditType();
            }
        }
        return null;
    }

    public static boolean isManualHandled(String executionType) {
        return WfUtils.isEmpty(executionType) || executionType.equals("byExpireAuto") || executionType.equals("jump");
    }

    public static void recordBaseDataRef(String modelJson, Long procDefId, Long schemeId) {
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(modelJson);
        BpmnModelUtil.recordBaseDataRef(bpmnModel, procDefId, schemeId);
    }

    public static void recordBaseDataRef(BpmnModel bpmnModel, Long procDefId, Long schemeId) {
        Process process = bpmnModel.getMainProcess();
        BaseDataHelper.recordBaseDataRef(process, procDefId, schemeId);
    }

    public static Set<String> getTargetEntityNumber(FlowElement elem) {
        HashSet<String> target = new HashSet<String>(4);
        if (elem instanceof IEntitySupport) {
            target.add(((IEntitySupport)((Object)elem)).getEntityNumber());
        } else if (elem instanceof AutoTask) {
            String em;
            AutoTask autoTask = (AutoTask)elem;
            List<String> extItfs = autoTask.getExtItf();
            if (extItfs != null && !extItfs.isEmpty()) {
                for (String extItf : extItfs) {
                    ServiceInfo info = AutoTaskUtil.getServiceInfoFromString(extItf);
                    target.add(info.getEntityNumber());
                }
            }
            if (WfUtils.isNotEmpty(autoTask.getEntityId()) && WfUtils.isNotEmpty(em = MetadataDao.getNumberById((String)autoTask.getEntityId()))) {
                target.add(em);
            }
        }
        return target;
    }

    public static Map<String, WFExtendAttributeGroup> extendAttributeGroupConverterToWF(FlowElement flowElement) {
        HashMap<String, WFExtendAttributeGroup> extAttrGroup = new HashMap<String, WFExtendAttributeGroup>();
        Map<String, ExtendAttributeGroup> extendAttributeGroup = ((UserTask)flowElement).getExtAttrGroup();
        if (extendAttributeGroup != null && !extendAttributeGroup.isEmpty()) {
            Set<Map.Entry<String, ExtendAttributeGroup>> extendAttributeGroupEntrySet = extendAttributeGroup.entrySet();
            for (Map.Entry<String, ExtendAttributeGroup> extendAttributeGroupEntry : extendAttributeGroupEntrySet) {
                WFExtendAttributeGroup wfExtendAttributeGroup = new WFExtendAttributeGroup();
                String key = extendAttributeGroupEntry.getKey();
                ExtendAttributeGroup value = extendAttributeGroupEntry.getValue();
                wfExtendAttributeGroup.setGroupEnable(value.isGroupEnable());
                wfExtendAttributeGroup.setExtAttrValue(value.getExtAttrValue());
                extAttrGroup.put(key, wfExtendAttributeGroup);
            }
        }
        return extAttrGroup;
    }
}

