/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.util;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.session.SessionManager;
import kd.bos.url.UrlService;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.ParticipatantModel;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.component.approvalrecord.ApprovalAttachmentInfo;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordItem;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.TaskService;
import kd.bos.workflow.engine.WfConstanst;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.component.ApprovalRecordItem;
import kd.bos.workflow.engine.impl.util.ApprovalRecordHtmlAdapter;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.SecureGuestUrlUtil;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class CoordinateRecordUtil {
    private static final String[] PREVIEW_EXT = new String[]{"jpg", "jpeg", "gif", "bmp", "png", "dib", "rle", "emf", "jpe", "pcx", "dcx", "pic", "tga", "tif", "wmf", "jfif", "pdf", "pptx", "ppt", "doc", "docx", "xls", "xlsx", "txt"};
    private static final String[] imgtype = new String[]{"jpg", "jpeg", "gif", "bmp", "png", "dib", "rle", "emf", "jpe", "jfif", "pcx", "dcx", "pic", "tga", "tif", "wmf"};
    private static Log log = LogFactory.getLog(CoordinateRecordUtil.class);
    private static final String WF_TASK = "wf_task";
    private static final String WF_HICOMMENT = "wf_hicomment";
    private static final String WF_PARTICIPANT = "wf_participant";
    private static final String WF_HIPARTICIPANT = "wf_hiparticipant";
    private static final String WF_TASKHANDLELOG = "wf_taskhandlelog";
    private static final String COMMENT = "comment";
    private static final String TASKID = "taskid";
    private static final String COORDINATE = "coordinate";
    private static final String USERID = "userid";
    private static final String OWNERID = "ownerid";
    private static final String PARENTTASKID = "parenttaskid";
    private static final String USERIDTYPE = "userid,type";
    private static final String TRANSFER = "transfer";
    private static final String TYPE = "type";

    public static List<ApprovalAttachmentInfo> getApprovalAttachments(String attachmentIdStr) {
        if (StringUtils.isBlank((CharSequence)attachmentIdStr)) {
            return new ArrayList<ApprovalAttachmentInfo>();
        }
        String[] attachmentIds = attachmentIdStr.split(",");
        ArrayList<Long> ids = new ArrayList<Long>(attachmentIds.length);
        for (String attachmentId : attachmentIds) {
            ids.add(Long.valueOf(attachmentId));
        }
        return CoordinateRecordUtil.getApprovalAttachments(ids);
    }

    public static List<ApprovalAttachmentInfo> getApprovalAttachments(List<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return new ArrayList<ApprovalAttachmentInfo>();
        }
        QFilter qFilter = new QFilter("id", "in", ids);
        DynamicObject[] attachmentObjects = BusinessDataServiceHelper.load((String)"bd_attachment", (String)"name,size,url,type", (QFilter[])new QFilter[]{qFilter});
        if (attachmentObjects.length == 0) {
            return new ArrayList<ApprovalAttachmentInfo>();
        }
        String kd_cs_ticket = SessionManager.getCSRFTokenValue((String)RequestContext.get().getGlobalSessionId());
        ArrayList<ApprovalAttachmentInfo> attachements = new ArrayList<ApprovalAttachmentInfo>(attachmentObjects.length);
        for (DynamicObject attachmentObject : attachmentObjects) {
            ApprovalAttachmentInfo approvalAttachmentInfo = new ApprovalAttachmentInfo();
            ILocaleString name = attachmentObject.getLocaleString("name");
            String localeName = name.getLocaleValue();
            if (WfUtils.isEmpty(localeName)) {
                for (Map.Entry entry : name.entrySet()) {
                    if (!WfUtils.isNotEmpty((String)entry.getValue())) continue;
                    localeName = (String)entry.getValue();
                    break;
                }
            }
            approvalAttachmentInfo.setFileName(localeName);
            approvalAttachmentInfo.setFileSize(attachmentObject.getInt("size"));
            String url = attachmentObject.getString("url");
            try {
                url = URLEncoder.encode(CoordinateRecordUtil.removeUrlVersion(url), StandardCharsets.UTF_8.name());
            }
            catch (Exception e) {
                log.error(String.format("\u9644\u4ef6\u5730\u5740\u89e3\u6790\u51fa\u9519\uff1a%s", url));
            }
            String downloadUrl = "";
            String client = RequestContext.get().getClient();
            downloadUrl = "web".equalsIgnoreCase(client) ? SecureGuestUrlUtil.encryptURL(UrlService.getAttachmentFullUrl((String)url)) : SecureGuestUrlUtil.getSecureUrl(UrlService.getAttachmentFullUrl((String)url), "");
            if (WfUtils.isNotEmpty(downloadUrl) && WfUtils.isNotEmpty(kd_cs_ticket)) {
                downloadUrl = downloadUrl + "&kd_cs_ticket=" + kd_cs_ticket;
            }
            approvalAttachmentInfo.setDownloadUrl(downloadUrl);
            Object previewUrl = CoordinateRecordUtil.getPreviewUrl(downloadUrl, attachmentObject.getString(TYPE));
            approvalAttachmentInfo.setPreviewUrl((String)previewUrl);
            approvalAttachmentInfo.setId(attachmentObject.getString("id"));
            attachements.add(approvalAttachmentInfo);
        }
        return attachements;
    }

    public static String removeUrlVersion(String versionUrl) {
        return versionUrl.replace("?v=1", "");
    }

    public static Boolean isCurrentNode(Long taskId) {
        boolean exists = QueryServiceHelper.exists((String)WF_TASK, (Object)taskId);
        if (exists) {
            return Boolean.TRUE;
        }
        QFilter q1 = new QFilter(TYPE, "=", (Object)COMMENT);
        QFilter q2 = new QFilter(TASKID, "=", (Object)taskId);
        DynamicObject[] hicomments = BusinessDataServiceHelper.load((String)WF_HICOMMENT, (String)"id,groupid", (QFilter[])new QFilter[]{q2, q1});
        long groupId = hicomments[0].getLong("groupid");
        if (groupId == 0L) {
            return Boolean.FALSE;
        }
        exists = QueryServiceHelper.exists((String)WF_TASK, (Object)groupId);
        return exists;
    }

    public static boolean getIsContainCoordinateRecored(List<Long> taskIds) {
        QFilter q1 = new QFilter(TYPE, "=", (Object)COORDINATE);
        QFilter q2 = new QFilter(TASKID, "in", taskIds);
        QFilter q3 = new QFilter(USERID, "=", (Object)Long.valueOf(RequestContext.get().getUserId()));
        return QueryServiceHelper.exists((String)WF_PARTICIPANT, (QFilter[])new QFilter[]{q1, q2, q3});
    }

    public static Boolean isCoordinateRecored(Long taskId) {
        QFilter q1 = new QFilter(TYPE, "=", (Object)COORDINATE);
        QFilter q2 = new QFilter(TASKID, "=", (Object)taskId);
        QFilter q5 = new QFilter(OWNERID, "!=", (Object)1);
        Boolean isCoordinate = QueryServiceHelper.exists((String)WF_PARTICIPANT, (QFilter[])new QFilter[]{q2, q5, q1});
        if (isCoordinate.booleanValue()) {
            return isCoordinate;
        }
        QFilter q3 = new QFilter(TYPE, "=", (Object)COORDINATE);
        QFilter q4 = new QFilter(TASKID, "=", (Object)taskId);
        QFilter q6 = new QFilter(OWNERID, "!=", (Object)1);
        isCoordinate = QueryServiceHelper.exists((String)WF_HICOMMENT, (QFilter[])new QFilter[]{q4, q3, q6});
        return isCoordinate;
    }

    public static boolean isCoordinateRecord(Long taskId, Long userId) {
        QFilter filter1 = new QFilter(TASKID, "=", (Object)taskId);
        QFilter filter2 = new QFilter(TYPE, "=", (Object)COORDINATE);
        QFilter filter3 = new QFilter(USERID, "=", (Object)userId);
        QFilter filter4 = new QFilter(OWNERID, "!=", (Object)1L);
        boolean exists = QueryServiceHelper.exists((String)WF_PARTICIPANT, (QFilter[])new QFilter[]{filter1, filter2, filter3, filter4});
        if (exists) {
            return true;
        }
        return QueryServiceHelper.exists((String)WF_HICOMMENT, (QFilter[])new QFilter[]{filter1, filter2, filter3, filter4});
    }

    public static boolean isAutoCoordinateRecord(Long taskId, Long userId) {
        QFilter filter1 = new QFilter(TASKID, "=", (Object)taskId);
        QFilter filter2 = new QFilter(TYPE, "=", (Object)COORDINATE);
        QFilter filter3 = new QFilter(USERID, "=", (Object)userId);
        QFilter filter4 = new QFilter(OWNERID, "=", (Object)1L);
        boolean exists = QueryServiceHelper.exists((String)WF_PARTICIPANT, (QFilter[])new QFilter[]{filter1, filter2, filter3, filter4});
        if (exists) {
            return true;
        }
        return QueryServiceHelper.exists((String)WF_HICOMMENT, (QFilter[])new QFilter[]{filter1, filter2, filter3, filter4});
    }

    public static Object getPreviewUrl(String downloadUrl, String type) {
        String previewUrl = null;
        String isPreVuewProp = System.getProperty("fileserver.attachment.preview");
        log.info("fileserver.attachment.preview:" + isPreVuewProp);
        Boolean isPreVuew = Boolean.FALSE;
        if ("true".equals(isPreVuewProp)) {
            isPreVuew = Boolean.TRUE;
        }
        if (CoordinateRecordUtil.ablePreView(type).booleanValue() && isPreVuew.booleanValue()) {
            previewUrl = downloadUrl.replace("download.do", "preview.do");
        }
        return previewUrl;
    }

    public static Boolean ablePreView(String type) {
        for (int i = 0; i < PREVIEW_EXT.length; ++i) {
            if (!PREVIEW_EXT[i].equalsIgnoreCase(type)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean isImage(String type) {
        for (int i = 0; i < imgtype.length; ++i) {
            if (!imgtype[i].equalsIgnoreCase(type)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static boolean isContainCoordinateRecord(List<Long> taskIds) {
        QFilter q1 = new QFilter(TYPE, "=", (Object)COORDINATE);
        QFilter q2 = new QFilter(TASKID, "in", taskIds);
        QFilter q3 = new QFilter(USERID, "=", (Object)Long.valueOf(RequestContext.get().getUserId()));
        QFilter q4 = new QFilter(OWNERID, "!=", (Object)WfConstanst.ADMIN);
        return QueryServiceHelper.exists((String)WF_HIPARTICIPANT, (QFilter[])new QFilter[]{q1, q2, q3, q4});
    }

    public static boolean getIsExistUndoCoordinateRecord(String taskId) {
        QFilter q1 = new QFilter(TYPE, "=", (Object)COORDINATE);
        QFilter q2 = new QFilter(TASKID, "=", (Object)Long.valueOf(taskId));
        QFilter q3 = new QFilter(OWNERID, "!=", (Object)WfConstanst.ADMIN);
        return QueryServiceHelper.exists((String)WF_PARTICIPANT, (QFilter[])new QFilter[]{q1, q2, q3});
    }

    public static boolean getIsExistUndoCoordinateRecord(List<Long> taskIds) {
        QFilter q1 = new QFilter(TYPE, "=", (Object)COORDINATE);
        QFilter q2 = new QFilter(TASKID, "in", taskIds);
        QFilter q3 = new QFilter(OWNERID, "!=", (Object)WfConstanst.ADMIN);
        return QueryServiceHelper.exists((String)WF_PARTICIPANT, (QFilter[])new QFilter[]{q1, q2, q3});
    }

    public static boolean coordinateRecoredIsExist(Long taskId) {
        QFilter q1 = new QFilter(TYPE, "=", (Object)COORDINATE);
        QFilter q2 = new QFilter(TASKID, "=", (Object)taskId);
        QFilter q3 = new QFilter(USERID, "=", (Object)Long.valueOf(RequestContext.get().getUserId()));
        return QueryServiceHelper.exists((String)WF_PARTICIPANT, (QFilter[])new QFilter[]{q1, q2, q3});
    }

    public static Map<Long, String> getParticipantsByTaskId(Long taskId) {
        QFilter q;
        HashMap<Long, String> userInfos = new HashMap<Long, String>();
        ArrayList<Long> taskIds = null;
        DynamicObject taskObject = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)WF_TASK, (String)"parenttaskid, category");
        Long parentTaskId = taskObject.getLong(PARENTTASKID);
        String category = taskObject.getString("category");
        if (BpmnModelUtil.instanceofYunzhijiaTask(category)) {
            if (parentTaskId == 0L) {
                parentTaskId = taskId;
            }
            q = new QFilter(PARENTTASKID, "=", (Object)parentTaskId);
            DynamicObject[] tasks = BusinessDataServiceHelper.load((String)WF_TASK, (String)"id", (QFilter[])new QFilter[]{q});
            taskIds = new ArrayList(tasks.length + 1);
            for (DynamicObject task : tasks) {
                taskIds.add(task.getLong("id"));
            }
            taskIds.add(parentTaskId);
        } else {
            taskIds = new ArrayList<Long>(1);
            taskIds.add(taskId);
        }
        q = new QFilter(TASKID, "in", taskIds);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)WF_PARTICIPANT, (String)USERIDTYPE, (QFilter[])new QFilter[]{q});
        if (dynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                userInfos.put(dynamicObject.getLong(USERID), dynamicObject.getString(TYPE));
            }
        }
        QFilter qFilter = new QFilter(TYPE, "=", (Object)COMMENT);
        dynamicObjects = BusinessDataServiceHelper.load((String)WF_HICOMMENT, (String)USERIDTYPE, (QFilter[])new QFilter[]{q, qFilter});
        if (dynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                userInfos.put(dynamicObject.getLong(USERID), "participant");
            }
        }
        return userInfos;
    }

    public static List<Long> getParticipantsByParentTaskId(Long taskId) {
        ArrayList<Long> userIds = new ArrayList<Long>();
        QFilter q = new QFilter(PARENTTASKID, "=", (Object)taskId);
        QFilter q1 = new QFilter("id", "=", (Object)taskId);
        DynamicObject[] tasks = BusinessDataServiceHelper.load((String)WF_TASK, (String)"id", (QFilter[])new QFilter[]{q.or(q1)});
        ArrayList<Long> taskIds = new ArrayList<Long>(tasks.length);
        for (DynamicObject dynamicObject : tasks) {
            taskIds.add(dynamicObject.getLong("id"));
        }
        QFilter q2 = new QFilter(TASKID, "in", taskIds);
        QFilter q3 = new QFilter(TYPE, "=", (Object)"participant");
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)WF_PARTICIPANT, (String)USERIDTYPE, (QFilter[])new QFilter[]{q2, q3});
        if (dynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                long userId = dynamicObject.getLong(USERID);
                if (userIds.contains(userId)) continue;
                userIds.add(userId);
            }
        }
        QFilter qFilter = new QFilter(TYPE, "=", (Object)COMMENT);
        dynamicObjects = BusinessDataServiceHelper.load((String)WF_HICOMMENT, (String)USERIDTYPE, (QFilter[])new QFilter[]{q2, qFilter});
        if (dynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                long userId = dynamicObject.getLong(USERID);
                if (userIds.contains(userId)) continue;
                userIds.add(userId);
            }
        }
        return userIds;
    }

    public static String getCoordinateMsg(String taskId, String userId, String type) {
        QFilter q2;
        QFilter q3;
        QFilter q1 = new QFilter(TASKID, "=", (Object)Long.valueOf(taskId));
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)WF_HICOMMENT, (String)"message", (QFilter[])new QFilter[]{q1, q3 = new QFilter(TYPE, "=", (Object)type), q2 = new QFilter(USERID, "=", (Object)Long.valueOf(userId))});
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            return dynamicObjects[0].getLocaleString("message").getLocaleValue();
        }
        return null;
    }

    public static Object[] getCoordinateAttachments(String taskId, String userId) {
        QFilter q2;
        QFilter q1 = new QFilter(TASKID, "=", (Object)Long.valueOf(taskId));
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"wf_hiattachment", (String)"urlid", (QFilter[])new QFilter[]{q1, q2 = new QFilter(USERID, "=", (Object)Long.valueOf(userId))});
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            Object[] attIds = new Object[dynamicObjects.length];
            for (int j = 0; j < dynamicObjects.length; ++j) {
                attIds[j] = dynamicObjects[j].get("urlid");
            }
            return attIds;
        }
        return new Object[0];
    }

    public static DynamicObject[] getCoordinateAttachmentDynamicObjects(String taskId, String userId) {
        QFilter q1 = new QFilter(TASKID, "=", (Object)Long.valueOf(taskId));
        QFilter q2 = new QFilter(USERID, "=", (Object)Long.valueOf(userId));
        return BusinessDataServiceHelper.load((String)"wf_hiattachment", (String)"urlid,name", (QFilter[])new QFilter[]{q1, q2});
    }

    public static Boolean isCoordinateRecord(Long taskId, String userId) {
        Boolean isCoordinate = Boolean.FALSE;
        QFilter q1 = new QFilter(TASKID, "=", (Object)taskId);
        QFilter q2 = new QFilter(USERID, "=", (Object)Long.valueOf(userId));
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)WF_HICOMMENT, (String)TYPE, (QFilter[])new QFilter[]{q1, q2});
        if (dynamicObjects != null && dynamicObjects.length > 0 && COORDINATE.equals(dynamicObjects[0].getString(TYPE))) {
            isCoordinate = Boolean.TRUE;
        }
        return isCoordinate;
    }

    public static boolean isShowCoordinate(Long taskId, Long userId) {
        boolean coordinateRecored = CoordinateRecordUtil.isCoordinateRecored(taskId);
        if (!coordinateRecored) {
            return false;
        }
        if (CoordinateRecordUtil.isWfAdmin(userId)) {
            return true;
        }
        boolean isParticipantOrCoordinateOrTranfer = CoordinateRecordUtil.isParticipantOrCoordinateOrTranfer(taskId, userId);
        if (isParticipantOrCoordinateOrTranfer) {
            return true;
        }
        return CoordinateRecordUtil.isExistPublicCoordianteRecord(taskId);
    }

    private static boolean isParticipantOrCoordinateOrTranfer(Long taskId, Long userId) {
        boolean exists = false;
        QFilter q1 = new QFilter(TASKID, "=", (Object)taskId);
        QFilter q4 = new QFilter(TYPE, "=", (Object)COORDINATE);
        QFilter q5 = new QFilter(OWNERID, "!=", (Object)1);
        DynamicObjectCollection coordinateParticipants = QueryServiceHelper.query((String)WF_PARTICIPANT, (String)"userid,ownerid", (QFilter[])new QFilter[]{q1, q5, q4});
        for (DynamicObject coordinateParticipant : coordinateParticipants) {
            if (!userId.equals(coordinateParticipant.getLong(USERID)) && !userId.equals(coordinateParticipant.getLong(OWNERID))) continue;
            exists = true;
            break;
        }
        if (exists) {
            return true;
        }
        QFilter q2 = new QFilter(TYPE, "=", (Object)COMMENT);
        QFilter q6 = new QFilter(USERID, "=", (Object)userId).or(new QFilter(OWNERID, "=", (Object)userId));
        exists = QueryServiceHelper.exists((String)WF_HICOMMENT, (QFilter[])new QFilter[]{q1, q2.or(q4), q5, q6});
        if (exists) {
            return true;
        }
        q2 = new QFilter(TYPE, "=", (Object)TRANSFER);
        QFilter q8 = new QFilter(OWNERID, "=", (Object)userId);
        return QueryServiceHelper.exists((String)WF_TASKHANDLELOG, (QFilter[])new QFilter[]{q1, q8, q2});
    }

    private static boolean isWfAdmin(Long userId) {
        QFilter q2 = new QFilter("status", "=", (Object)Character.valueOf('1'));
        Map admins = BusinessDataServiceHelper.loadFromCache((String)"wf_administrator", (String)USERID, (QFilter[])new QFilter[]{q2});
        if (admins != null && !admins.isEmpty()) {
            for (DynamicObject admin : admins.values()) {
                if (!userId.equals(admin.getLong("userid_id"))) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isExistPublicCoordianteRecord(Long taskId) {
        QFilter q1 = new QFilter(TASKID, "=", (Object)taskId);
        QFilter q2 = new QFilter("ispublic", "=", (Object)Boolean.FALSE);
        QFilter q3 = new QFilter(TYPE, "=", (Object)COORDINATE);
        boolean isExist = QueryServiceHelper.exists((String)WF_HICOMMENT, (QFilter[])new QFilter[]{q1, q3, q2});
        if (isExist) {
            return isExist;
        }
        QFilter q4 = new QFilter(OWNERID, "!=", (Object)1);
        return QueryServiceHelper.exists((String)WF_PARTICIPANT, (QFilter[])new QFilter[]{q1, q4, q3, q2});
    }

    public static boolean isParticipant(Long taskId, String userId, String type) {
        QFilter q1 = new QFilter(TYPE, "=", (Object)type);
        QFilter q2 = new QFilter(TASKID, "=", (Object)taskId);
        QFilter q3 = new QFilter(USERID, "=", (Object)Long.valueOf(userId));
        return QueryServiceHelper.exists((String)WF_PARTICIPANT, (QFilter[])new QFilter[]{q2, q3, q1});
    }

    public static boolean isHiparticipant(Long taskId, String userId, String type) {
        QFilter q1 = new QFilter(TYPE, "=", (Object)type);
        QFilter q2 = new QFilter(TASKID, "=", (Object)taskId);
        QFilter q3 = new QFilter(USERID, "=", (Object)Long.valueOf(userId));
        return QueryServiceHelper.exists((String)WF_HIPARTICIPANT, (QFilter[])new QFilter[]{q2, q3, q1});
    }

    public static boolean isCanShowCoordinateRecored(Long taskId, Long userId, Boolean ispublic) {
        return CoordinateRecordUtil.isCanShowCoordinateRecored(taskId, userId, ispublic, 0L);
    }

    public static boolean isCanShowCoordinateRecored(Long taskId, Long userId, Boolean ispublic, Long delegateId) {
        Long currentUserId = Long.valueOf(RequestContext.get().getUserId());
        if (!ispublic.booleanValue() || CoordinateRecordUtil.isWfAdmin(currentUserId) || userId.longValue() == currentUserId.longValue()) {
            return true;
        }
        return CoordinateRecordUtil.isParticipantOrTranfer(taskId, currentUserId, delegateId);
    }

    private static boolean isParticipantOrTranfer(Long taskId, Long userId, Long delegateId) {
        QFilter q1 = new QFilter(TASKID, "=", (Object)taskId);
        QFilter q2 = new QFilter(TYPE, "=", (Object)"participant");
        QFilter q5 = new QFilter(OWNERID, "!=", (Object)1);
        QFilter q6 = new QFilter(USERID, "=", (Object)userId);
        QFilter q7 = new QFilter("delegateid", "=", (Object)delegateId);
        boolean exists = QueryServiceHelper.exists((String)WF_PARTICIPANT, (QFilter[])new QFilter[]{q1, q5, q6, q2, q7});
        if (exists) {
            return true;
        }
        q2 = new QFilter(TYPE, "=", (Object)COMMENT);
        exists = QueryServiceHelper.exists((String)WF_HICOMMENT, (QFilter[])new QFilter[]{q1, q2, q5, q6});
        if (exists) {
            return true;
        }
        q2 = new QFilter(TYPE, "=", (Object)TRANSFER);
        QFilter q8 = new QFilter(OWNERID, "=", (Object)userId);
        return QueryServiceHelper.exists((String)WF_TASKHANDLELOG, (QFilter[])new QFilter[]{q1, q8, q2});
    }

    public static boolean isCanShowAutoCoordinateRecored(String groupId) {
        QFilter q1 = new QFilter(TYPE, "=", (Object)COORDINATE);
        QFilter q2 = new QFilter(OWNERID, "=", (Object)WfConstanst.ADMIN);
        QFilter q3 = new QFilter(TASKID, "=", (Object)Long.valueOf(groupId));
        boolean isCanShowAutoCoordinate = QueryServiceHelper.exists((String)WF_PARTICIPANT, (QFilter[])new QFilter[]{q3, q2, q1});
        if (!isCanShowAutoCoordinate) {
            QFilter q4 = new QFilter(PARENTTASKID, "=", (Object)Long.valueOf(groupId));
            isCanShowAutoCoordinate = QueryServiceHelper.exists((String)WF_PARTICIPANT, (QFilter[])new QFilter[]{q4, q2, q1});
        }
        if (!isCanShowAutoCoordinate) {
            QFilter q5 = new QFilter("groupid", "=", (Object)groupId);
            isCanShowAutoCoordinate = QueryServiceHelper.exists((String)WF_HICOMMENT, (QFilter[])new QFilter[]{q2, q1, q5});
        }
        return isCanShowAutoCoordinate;
    }

    public static Boolean isTransfered(Long historicTaskId, String userId) {
        QFilter q1 = new QFilter(OWNERID, "=", (Object)Long.valueOf(userId));
        QFilter q2 = new QFilter(TASKID, "=", (Object)historicTaskId);
        QFilter q3 = new QFilter(TYPE, "=", (Object)TRANSFER);
        return QueryServiceHelper.exists((String)WF_TASKHANDLELOG, (QFilter[])new QFilter[]{q2, q1, q3});
    }

    public static Boolean hasComment(Long taskId, String userId, String type) {
        QFilter q1 = new QFilter(USERID, "=", (Object)Long.valueOf(userId));
        QFilter q2 = new QFilter(TASKID, "=", (Object)taskId);
        QFilter q3 = new QFilter(TYPE, "=", (Object)type);
        return QueryServiceHelper.exists((String)WF_HICOMMENT, (QFilter[])new QFilter[]{q2, q3, q1});
    }

    public static Boolean isParticipant(Long taskId, String userId, String[] types, String entityName) {
        Boolean isParticipant = Boolean.FALSE;
        if (WfUtils.isNotEmpty(taskId)) {
            QFilter q1 = new QFilter(TYPE, "in", (Object)types);
            QFilter q2 = new QFilter(TASKID, "=", (Object)taskId);
            QFilter q3 = new QFilter(USERID, "=", (Object)Long.valueOf(userId));
            isParticipant = QueryServiceHelper.exists((String)entityName, (QFilter[])new QFilter[]{q2, q3, q1});
        }
        return isParticipant;
    }

    public static Boolean isDisplaySetting(Long taskId) {
        Boolean isDisplaySetting = Boolean.FALSE;
        WorkflowService service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        String fields = "processDefinitionId,taskDefinitionKey,processInstanceId";
        HistoricTaskInstanceEntity hitaskEntity = (HistoricTaskInstanceEntity)service.getRepositoryService().findEntityById(taskId, "wf_hitaskinst", fields);
        if (hitaskEntity != null) {
            try {
                Long processInstanceId = hitaskEntity.getProcessInstanceId();
                String taskDefinitionKey = hitaskEntity.getTaskDefinitionKey();
                Long processDefinitionId = hitaskEntity.getProcessDefinitionId();
                RepositoryService repositoryService = service.getRepositoryService();
                BpmnModel bpmnModel = repositoryService.getBpmnModel(processDefinitionId, processInstanceId);
                Process process = bpmnModel.getMainProcess();
                UserTask userTask = (UserTask)process.getFlowElement(taskDefinitionKey);
                ParticipatantModel participantModel = userTask.getParticipant();
                isDisplaySetting = participantModel.isDisplaySetting();
            }
            catch (Exception e) {
                return isDisplaySetting;
            }
        }
        return isDisplaySetting;
    }

    public static List<IApprovalRecordItem> getCoordinateRecords(String taskId, boolean containAutoCoordinate) {
        List<IApprovalRecordItem> records = null;
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        TaskService taskService = wfService.getTaskService();
        String[] taskIdsStr = taskId.split(",");
        if (taskIdsStr.length >= 2) {
            ArrayList<Long> taskIds = new ArrayList<Long>(taskIdsStr.length);
            for (String taskIdStr : taskIdsStr) {
                taskIds.add(Long.valueOf(taskIdStr));
            }
            records = taskService.getCoordinatorRecordByTaskIdsCmd(taskIds);
        } else {
            records = taskService.getCoordinatorRecordCmd(Long.valueOf(taskId));
        }
        if (containAutoCoordinate) {
            List<IApprovalRecordItem> autoCoordinateRecoreds;
            String firstTaskId = taskIdsStr[0];
            DynamicObject taskInfo = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(firstTaskId), (String)"wf_hitaskinst");
            Long groupId = taskInfo.getLong(PARENTTASKID);
            if (WfUtils.isEmpty(groupId)) {
                groupId = Long.valueOf(firstTaskId);
            }
            if ((autoCoordinateRecoreds = taskService.getAutoCoordinateRecordCmd(groupId)) != null && !autoCoordinateRecoreds.isEmpty()) {
                records.addAll(autoCoordinateRecoreds);
            }
        }
        return records;
    }

    public static List<IApprovalRecordItem> getCoordinateRecordsWithoutTag(String taskId, boolean containAutoCoordinate) {
        List<IApprovalRecordItem> records = CoordinateRecordUtil.getCoordinateRecords(taskId, containAutoCoordinate);
        for (IApprovalRecordItem record : records) {
            if (!(record instanceof ApprovalRecordItem)) continue;
            ApprovalRecordItem recordItem = (ApprovalRecordItem)record;
            if (StringUtils.isNotBlank((CharSequence)recordItem.getMessage())) {
                recordItem.setMessage(ApprovalRecordHtmlAdapter.filterHtml(recordItem.getMessage()));
            }
            if (!StringUtils.isNotBlank((CharSequence)recordItem.getCoordInviteOpinion())) continue;
            recordItem.setCoordInviteOpinion(ApprovalRecordHtmlAdapter.filterHtml(recordItem.getCoordInviteOpinion()));
        }
        return records;
    }

    public static List<IApprovalRecordItem> getCoordinateRecordsTagTransfer(String taskId, boolean containAutoCoordinate) {
        List<IApprovalRecordItem> records = CoordinateRecordUtil.getCoordinateRecords(taskId, containAutoCoordinate);
        for (IApprovalRecordItem record : records) {
            if (!(record instanceof ApprovalRecordItem)) continue;
            ApprovalRecordItem recordItem = (ApprovalRecordItem)record;
            if (StringUtils.isNotBlank((CharSequence)recordItem.getMessage())) {
                recordItem.setMessage(ApprovalRecordHtmlAdapter.adaptHtml(recordItem.getMessage()));
            }
            if (!StringUtils.isNotBlank((CharSequence)recordItem.getCoordInviteOpinion())) continue;
            recordItem.setCoordInviteOpinion(ApprovalRecordHtmlAdapter.adaptHtml(recordItem.getCoordInviteOpinion()));
        }
        return records;
    }
}

