/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.util;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.util.TimeZoneUtil;
import kd.bos.workflow.engine.runtime.Clock;

public class DefaultClockImpl
implements Clock {
    private volatile Calendar CURRENT_TIME;

    @Override
    public void setCurrentTime(Date currentTime) {
        GregorianCalendar time = null;
        if (currentTime != null) {
            time = new GregorianCalendar();
            time.setTime(currentTime);
        }
        this.setCurrentCalendar(time);
    }

    @Override
    public void setCurrentCalendar(Calendar currentTime) {
        this.CURRENT_TIME = currentTime;
    }

    @Override
    public void reset() {
        this.CURRENT_TIME = null;
    }

    @Override
    public Date getCurrentTime() {
        return WfUtils.now();
    }

    @Override
    public Calendar getCurrentCalendar() {
        return this.CURRENT_TIME == null ? new GregorianCalendar() : (Calendar)this.CURRENT_TIME.clone();
    }

    @Override
    public Calendar getCurrentCalendar(TimeZone timeZone) {
        return TimeZoneUtil.convertToTimeZone(this.getCurrentCalendar(), timeZone);
    }

    @Override
    public TimeZone getCurrentTimeZone() {
        return this.getCurrentCalendar().getTimeZone();
    }
}

