/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.util;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.bizflow.util.BizFlowUtil;
import kd.bos.workflow.bpmn.model.AllowNextPersonSetting;
import kd.bos.workflow.bpmn.model.AllowNextPersonSettingModel;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.ISupportSkipCondition;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SelectNodesModel;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.StartEvent;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.domain.model.NodeForkJoinModel;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.bpmn.behavior.SkipInfo;
import kd.bos.workflow.engine.impl.cmd.management.scheme.GetConfigSchemeBpmnModelCmd;
import kd.bos.workflow.engine.impl.cmd.precomputation.NodeTempVariable;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.DynamicResourceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.HiUserActInstEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.PathJson;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.PreComputatorExecutionEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.condition.ConditionUtil;
import org.apache.commons.lang.StringUtils;

public class DynamicFlowUtil {
    private static final Log log = LogFactory.getLog(DynamicFlowUtil.class);
    private static final String CURNODE = "curNode";
    private static final String NEXTNODE = "nextNode";
    private static final String TEXTVALUE = "textvalue";
    private static final String NAMEVARIABLE = "name";
    private static final String VARIABLEINSTANCE = "wf_variableinstance";
    public static final String FORCEABORT = "forceAbort";
    public static final String FORCEABORTCURNODE = "forceAbortcurNode";
    public static final String PARENTPROCESSABORT = "abortByParentProcessAbort";
    public static final String PARENTPROCESSABORTCURNODE = "abortByParentProcessAbortcurNode";
    public static final String PARENTPROCESSJUMP = "abortByParentProcessJump";
    public static final String PARENTPROCESSJUMPCURNODE = "abortByParentProcessJumpcurNode";
    public static final String PARENTPROCESSWITHDRAW = "abortByParentProcessWithdraw";
    public static final String PARENTPROCESSWITHDRAWCURNODE = "abortByParentProcessWithdrawcurNode";
    public static final String TERMINATEPROCWHENEXCEPTIONOCCURS = "terminateProcWhenExceptionOccurs";
    public static final String TERMINATEPROCWHENEXCEPTIONOCCURSCURNODE = "terminateProcWhenExceptionOccurscurNode";
    public static final String BILLABORT = "billAbort";
    public static final String BILLABORTCURNODE = "billAbortcurNode";
    public static final String BILLWITHDRAWJUMP = "billWithdrawJump";
    public static final String BILLWITHDRAWJUMPCURNODE = "billWithdrawJumpcurNode";
    public static final String MEETBILLCLOSEABORT = "meetBillClose";
    public static final String MEETBILLCLOSEABORTCURNODE = "meetBillClosecurNode";
    public static final String BILLEXCEPABORT = "billExcepAbort";
    public static final String BILLEXCEPABORTCURNODE = "billExcepAbortcurNode";
    public static final String AUDITABORT = "auditAbort";
    public static final String AUDITABORTCURNODE = "auditAbortcurNode";
    public static final String REJECTTOPARENTPROCESS = "abortByRejectToParentProcess";
    public static final String REJECTTOPARENTPROCESSCURNODE = "abortByRejectToParentProcesscurNode";
    public static final String FORCEJUMP = "dynJump";
    public static final String FORCEJUMPCURNODE = "dynJumpcurNode";
    public static final String EXPIRESKIP = "expireSkip";
    public static final String EXPIRESKIPCURNODE = "expireSkipcurNode";
    public static final String DYNAMICREJECT = "dynReject";
    public static final String DYNAMICREJECTCURNODE = "dynRejectcurNode";
    public static final String BACKTOREJECTNODE = "dynBackToRejectNode";
    public static final String BACKTOREJECTNODECURNODE = "dynBackToRejectNodecurNode";
    public static final String ADDSIGN = "addsignbefore";
    public static final String ADDSIGNCURNODE = "addsignbeforecurNode";
    private static final String TEMP_DYNTONODE = "TEMP_DYNTONODE";

    private static Map<String, Map<String, String>> createVariableCollection() {
        HashMap<String, Map<String, String>> variable = new HashMap<String, Map<String, String>>();
        HashMap<String, String> forceAbort = new HashMap<String, String>();
        forceAbort.put("executionType", "skip");
        forceAbort.put("skipReason", "ForceAbort");
        forceAbort.put("dynName", ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u7ec8\u6b62", (String)"DynamicFlowUtil_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        variable.put(FORCEABORTCURNODE, forceAbort);
        HashMap<String, String> parentProcessJump = new HashMap<String, String>();
        parentProcessJump.put("executionType", "skip");
        parentProcessJump.put("skipReason", "ParentProcessJump");
        parentProcessJump.put("dynName", WFMultiLangConstants.getParentProcessJumpText().getLocaleValue());
        variable.put(PARENTPROCESSJUMPCURNODE, parentProcessJump);
        HashMap<String, String> parentProcessAbort = new HashMap<String, String>();
        parentProcessAbort.put("executionType", "skip");
        parentProcessAbort.put("skipReason", "ParentProcessAbort");
        parentProcessAbort.put("dynName", WFMultiLangConstants.getParentProcessAbortText().getLocaleValue());
        variable.put(PARENTPROCESSABORTCURNODE, parentProcessAbort);
        HashMap<String, String> parentProcessWithdraw = new HashMap<String, String>();
        parentProcessWithdraw.put("executionType", "skip");
        parentProcessWithdraw.put("skipReason", "parentProcessWithdraw");
        parentProcessWithdraw.put("dynName", WFMultiLangConstants.getParentProcessWithdrawText().getLocaleValue());
        variable.put(PARENTPROCESSWITHDRAWCURNODE, parentProcessWithdraw);
        HashMap<String, String> directTerminate = new HashMap<String, String>();
        directTerminate.put("executionType", "skip");
        directTerminate.put("skipReason", "TerminateProcWhenExceptionOccurs");
        directTerminate.put("dynName", WFMultiLangConstants.getAbendText().getLocaleValue());
        variable.put(TERMINATEPROCWHENEXCEPTIONOCCURSCURNODE, directTerminate);
        HashMap<String, String> billAbort = new HashMap<String, String>();
        billAbort.put("executionType", "skip");
        billAbort.put("skipReason", "BillAbort");
        billAbort.put("dynName", ResManager.loadKDString((String)"\u6574\u5355\u5f3a\u5236\u64a4\u56de", (String)"DynamicFlowUtil_5", (String)"bos-wf-engine", (Object[])new Object[0]));
        variable.put(BILLABORTCURNODE, billAbort);
        HashMap<String, String> billWithdrawJump = new HashMap<String, String>();
        billWithdrawJump.put("executionType", "jump");
        billWithdrawJump.put("skipReason", "BillWithdrawJump");
        billWithdrawJump.put("nextNodeId", "");
        billWithdrawJump.put("dynName", ResManager.loadKDString((String)"\u6574\u5355\u64a4\u56de\u5f3a\u5236\u8df3\u8f6c\u81f3\u4eba\u5de5", (String)"DynamicFlowUtil_8", (String)"bos-wf-engine", (Object[])new Object[0]));
        variable.put(BILLWITHDRAWJUMPCURNODE, billWithdrawJump);
        HashMap<String, String> billExcepAbort = new HashMap<String, String>();
        billExcepAbort.put("executionType", "skip");
        billExcepAbort.put("skipReason", "BillExcepAbort");
        billExcepAbort.put("dynName", ResManager.loadKDString((String)"\u5355\u636e\u4f8b\u5916", (String)"DynamicFlowUtil_6", (String)"bos-wf-engine", (Object[])new Object[0]));
        variable.put(BILLEXCEPABORTCURNODE, billExcepAbort);
        HashMap<String, String> auditAbort = new HashMap<String, String>();
        auditAbort.put("dynName", ResManager.loadKDString((String)"\u5ba1\u6279\u7ec8\u6b62", (String)"DynamicFlowUtil_2", (String)"bos-wf-engine", (Object[])new Object[0]));
        variable.put(AUDITABORTCURNODE, auditAbort);
        HashMap<String, String> rejectToParentProcess = new HashMap<String, String>();
        rejectToParentProcess.put("nextNodeId", "");
        rejectToParentProcess.put("dynName", ResManager.loadKDString((String)"\u9a73\u56de\u81f3\u7236\u6d41\u7a0b", (String)"DynamicFlowUtil_9", (String)"bos-wf-engine", (Object[])new Object[0]));
        variable.put(REJECTTOPARENTPROCESSCURNODE, rejectToParentProcess);
        HashMap<String, String> forceJump = new HashMap<String, String>();
        forceJump.put("executionType", "jump");
        forceJump.put("skipReason", "PersonJump");
        forceJump.put("nextNodeId", "");
        forceJump.put("dynName", ResManager.loadKDString((String)"\u8df3\u8f6c", (String)"DynamicFlowUtil_3", (String)"bos-wf-engine", (Object[])new Object[0]));
        variable.put(FORCEJUMPCURNODE, forceJump);
        HashMap<String, String> expireSkip = new HashMap<String, String>();
        expireSkip.put("executionType", "skip");
        expireSkip.put("skipReason", "ExpireSkip");
        variable.put(EXPIRESKIPCURNODE, expireSkip);
        HashMap<String, String> dynamicReject = new HashMap<String, String>();
        dynamicReject.put("nextNodeId", "");
        dynamicReject.put("dynName", ResManager.loadKDString((String)"\u9a73\u56de", (String)"DynamicFlowUtil_4", (String)"bos-wf-engine", (Object[])new Object[0]));
        variable.put(DYNAMICREJECTCURNODE, dynamicReject);
        HashMap<String, String> backToRejectNode = new HashMap<String, String>();
        backToRejectNode.put("nextNodeId", "");
        backToRejectNode.put("dynName", "");
        backToRejectNode.put("auditNumber", "");
        backToRejectNode.put("auditName", "");
        variable.put(BACKTOREJECTNODECURNODE, backToRejectNode);
        HashMap<String, String> addSign = new HashMap<String, String>();
        addSign.put("executionType", "addSignBefore");
        addSign.put("skipReason", "AddSignBeforeJump");
        addSign.put("dynName", ResManager.loadKDString((String)"\u52a0\u7b7e", (String)"DynamicFlowUtil_7", (String)"bos-wf-engine", (Object[])new Object[0]));
        variable.put(ADDSIGNCURNODE, addSign);
        return variable;
    }

    public static Map<String, String> getVariableCollectionByScense(String sence) {
        return DynamicFlowUtil.createVariableCollection().get(sence);
    }

    public static boolean isAbortCurNode(DelegateExecution execution, String type) {
        return type != null && (AUDITABORT.equalsIgnoreCase(type) || FORCEABORT.equalsIgnoreCase(type) || BILLABORT.equalsIgnoreCase(type) || MEETBILLCLOSEABORT.equalsIgnoreCase(type) || BILLEXCEPABORT.equalsIgnoreCase(type) || PARENTPROCESSJUMP.equalsIgnoreCase(type) || PARENTPROCESSABORT.equalsIgnoreCase(type) || PARENTPROCESSWITHDRAW.equals(type) || TERMINATEPROCWHENEXCEPTIONOCCURS.equalsIgnoreCase(type) || REJECTTOPARENTPROCESS.equalsIgnoreCase(type));
    }

    public static boolean isRejectToInnerSkip(ExecutionEntity execution) {
        String nodeRejectToInner = (String)execution.getProcessInstance().getVariable("rejectToForkInnerAndSkip");
        BpmnModel model = ProcessDefinitionUtil.getBpmnModelByProcInstId(execution.getProcessInstanceId());
        if (WfUtils.isNotEmpty(nodeRejectToInner)) {
            for (String rejectNode : nodeRejectToInner.split("\\,")) {
                FlowElement f;
                if (!WfUtils.isNotEmpty(rejectNode)) continue;
                List<FlowElement> preNodes = BpmnModelUtil.getPreviousNodes(model, rejectNode);
                boolean isPreNode = false;
                Iterator<FlowElement> iterator = preNodes.iterator();
                while (iterator.hasNext() && !(isPreNode = rejectNode.equals((f = iterator.next()).getId()))) {
                }
                if (!isPreNode) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isSkipCurNode(DelegateExecution execution) {
        String type = DynamicFlowUtil.getDynamicVariableValue((ExecutionEntity)execution, "executionType");
        return type != null && ("skip".equalsIgnoreCase(type) || "jump".equalsIgnoreCase(type));
    }

    public static boolean isSkipCurNodeForListener(DelegateExecution execution) {
        String type = DynamicFlowUtil.getDynamicType((ExecutionEntity)execution);
        return type != null && (FORCEJUMP.equalsIgnoreCase(type) || BILLWITHDRAWJUMP.equalsIgnoreCase(type) || TERMINATEPROCWHENEXCEPTIONOCCURS.equalsIgnoreCase(type) || FORCEABORT.equalsIgnoreCase(type) || PARENTPROCESSJUMP.equalsIgnoreCase(type) || PARENTPROCESSABORT.equals(type) || BILLEXCEPABORT.equalsIgnoreCase(type) || BILLABORT.equalsIgnoreCase(type)) || ADDSIGN.equals(type) || PARENTPROCESSWITHDRAW.equals(type) || "compensationAbort".equals(type) || MEETBILLCLOSEABORT.equals(type);
    }

    public static void removeVariablesWhenLeaving(DelegateExecution execution, FlowNode flowNode) {
        ArrayList<String> variables = new ArrayList<String>(2);
        String dynType = (String)execution.getVariableLocal("dynType");
        if (WfUtils.isNotEmpty(dynType)) {
            Map<String, String> val = DynamicFlowUtil.createVariableCollection().get(dynType + CURNODE);
            if (val != null) {
                for (String key : val.keySet()) {
                    variables.add(key);
                }
            }
            variables.add("dynType");
            execution.removeVariablesLocal(variables);
        }
    }

    private static boolean directSkipFromNode(ExecutionEntity execution, FlowNode flowNode) {
        String dynToNode = (String)execution.getTransientVariable(TEMP_DYNTONODE);
        if (dynToNode != null && WfUtils.isNotEmpty(dynToNode) && dynToNode.equalsIgnoreCase(flowNode.getId())) {
            execution.removeTransientVariable(TEMP_DYNTONODE);
            return true;
        }
        return false;
    }

    public static void removeVariableWhenIncoming(ExecutionEntity execution, String curNodeId) {
        Map map;
        String dynNode = (String)execution.getVariableLocal("dynToNode");
        if (dynNode != null && WfUtils.isNotEmpty(dynNode) && (map = (Map)SerializationUtils.fromJsonString((String)dynNode, Map.class)) != null && map.get("dynToNode") != null && curNodeId.equals(map.get("dynToNode"))) {
            execution.removeVariableLocal("dynToNode");
            String type = (String)map.get("dynType");
            if (type != null && DYNAMICREJECT.equalsIgnoreCase(type)) {
                execution.setTransientVariable(TEMP_DYNTONODE, curNodeId);
            }
        }
        DynamicFlowUtil.removeDynNodeInfoVariable(execution, curNodeId);
        try {
            DynamicFlowUtil.saveAssignParticipant(execution, curNodeId);
        }
        catch (Exception exception) {
            log.error(WfUtils.getExceptionStacktrace(exception));
        }
    }

    public static void saveAssignParticipant(ExecutionEntity execution, String curNodeId) {
        if (execution.getCurrentTask() != null && "dismissed".equals(execution.getCurrentTask().getHandleState()) || curNodeId != null && curNodeId.equals(execution.getVariable("dynparticipantdynjump"))) {
            DynamicFlowUtil.updateDynParticipant(execution, curNodeId);
            if (curNodeId != null && curNodeId.equals(execution.getVariable("dynparticipantdynjump"))) {
                execution.removeVariable("dynparticipantdynjump");
            }
            return;
        }
    }

    private static void updateDynParticipant(ExecutionEntity execution, String curNodeId) {
        Map nodesAssignParticipant;
        String assignParticipant;
        String currentParticipant = (String)execution.getVariable(curNodeId + "currentParticipant");
        LinkedHashMap dynamicParticipantMap = new LinkedHashMap();
        if (WfUtils.isNotEmpty(currentParticipant)) {
            List instanceParticipantList;
            Map instanceParticipant = (Map)SerializationUtils.fromJsonString((String)currentParticipant, Map.class);
            String dynamicParticipant = (String)instanceParticipant.get(curNodeId);
            if (dynamicParticipant != null && (instanceParticipantList = SerializationUtils.fromJsonStringToList((String)dynamicParticipant, Map.class)) != null) {
                for (Map tempInstanceParticipant : instanceParticipantList) {
                    dynamicParticipantMap.put((String)tempInstanceParticipant.get("nodeId"), tempInstanceParticipant.get("userIds"));
                }
            }
        } else {
            List instanceParticipantList;
            String executionVariable = (String)execution.getVariable("dynParticipant");
            if (WfUtils.isNotEmpty(executionVariable) && (instanceParticipantList = SerializationUtils.fromJsonStringToList((String)executionVariable, Map.class)) != null) {
                for (Map map : instanceParticipantList) {
                    dynamicParticipantMap.put((String)map.get("nodeId"), map.get("userIds"));
                }
            }
        }
        if ((assignParticipant = (String)execution.getVariable(curNodeId.toLowerCase() + "assignparticipant")) != null && (nodesAssignParticipant = (Map)SerializationUtils.fromJsonString((String)assignParticipant, Map.class)) != null && nodesAssignParticipant.size() > 0) {
            for (Map.Entry entry : nodesAssignParticipant.entrySet()) {
                Map assignNodeInfo = (Map)entry.getValue();
                for (Map.Entry assignParticipantEntry : assignNodeInfo.entrySet()) {
                    StringBuilder userIdBuilder = new StringBuilder();
                    List participantUserIds = (List)assignParticipantEntry.getValue();
                    for (String participantUserId : participantUserIds) {
                        userIdBuilder.append(participantUserId);
                        userIdBuilder.append(',');
                    }
                    if (userIdBuilder.length() > 0) {
                        userIdBuilder.deleteCharAt(userIdBuilder.length() - 1);
                    }
                    dynamicParticipantMap.put((String)assignParticipantEntry.getKey(), userIdBuilder);
                }
            }
        }
        if (dynamicParticipantMap.size() > 0) {
            ArrayList instanceVariable = new ArrayList(dynamicParticipantMap.size());
            for (Map.Entry entry : dynamicParticipantMap.entrySet()) {
                LinkedHashMap<String, Object> instanceParticipantTemp = new LinkedHashMap<String, Object>();
                instanceParticipantTemp.put("nodeId", entry.getKey());
                instanceParticipantTemp.put("userIds", entry.getValue());
                instanceVariable.add(instanceParticipantTemp);
            }
            execution.setVariable("dynParticipant", SerializationUtils.toJsonString(instanceVariable));
        } else {
            execution.removeVariable("dynParticipant");
        }
    }

    public static void removeTransferedVariablesFromPrevNodeWhenGoingoutCurNode(DelegateExecution execution) {
        execution.removeVariableLocal("dynToNode");
        DynamicFlowUtil.removeDynNodeInfoVariable((ExecutionEntity)execution, null);
    }

    public static Map<String, Object> getCompatibleParticipantInstance(ExecutionEntity execution, FlowNode flowNode) {
        List taskParticipantList;
        LinkedHashMap<String, Object> instanceParticipantMap = new LinkedHashMap<String, Object>();
        String executionVariable = (String)execution.getVariable("dynParticipant");
        String nodeType = flowNode.getType();
        if (WfUtils.isNotEmpty(executionVariable)) {
            List instanceParticipantList = SerializationUtils.fromJsonStringToList((String)executionVariable, Map.class);
            if (instanceParticipantList != null) {
                for (Map instanceParticipant : instanceParticipantList) {
                    instanceParticipantMap.put((String)instanceParticipant.get("nodeId"), instanceParticipant.get("userIds"));
                }
            }
            boolean needSaveByFirstUserTask = DynamicFlowUtil.getNeedSaveByFirstUserTask(execution, flowNode);
            if (nodeType != null && WfUtils.isAuditTypeNode(nodeType) && instanceParticipantList != null && instanceParticipantList.size() > 0 && needSaveByFirstUserTask) {
                HashMap<String, String> currentNodeDynInst = new HashMap<String, String>();
                String nodeId = flowNode.getId();
                currentNodeDynInst.put(nodeId, executionVariable);
                execution.setVariable(nodeId + "currentParticipant", SerializationUtils.toJsonString(currentNodeDynInst));
            }
        } else if (nodeType != null && WfUtils.isAuditTypeNode(nodeType)) {
            String nodeId = flowNode.getId();
            execution.setVariable(nodeId + "currentParticipant", SerializationUtils.toJsonString(new HashMap()));
        }
        String customNextParitcipant = DynamicFlowUtil.getCustomNextNodeParticipant(execution);
        if (customNextParitcipant != null && (taskParticipantList = SerializationUtils.fromJsonStringToList((String)customNextParitcipant, Map.class)) != null) {
            for (Map taskParticipant : taskParticipantList) {
                instanceParticipantMap.put((String)taskParticipant.get("nodeId"), taskParticipant.get("userIds"));
            }
        }
        return instanceParticipantMap;
    }

    private static boolean getNeedSaveByFirstUserTask(ExecutionEntity execution, FlowNode flowNode) {
        boolean needSaveByFirstUserTask = true;
        if (flowNode instanceof UserTask) {
            UserTask userTask = (UserTask)flowNode;
            AllowNextPersonSettingModel allowNextPersonSettingModel = userTask.getAllowNextPersonSettingModel();
            Process process = ProcessDefinitionUtil.getProcess(execution.getProcessDefinitionId(), execution.getProcessInstanceId());
            UserTask firstUserTask = BpmnModelUtil.getFirstUserTask(process);
            if (firstUserTask != null && firstUserTask.getId() != null && firstUserTask.getId().equals(userTask.getId()) && allowNextPersonSettingModel != null && (!allowNextPersonSettingModel.isAllowNextPersonWhenMatch() || allowNextPersonSettingModel.isAllowNextPersonWhenMatch() && allowNextPersonSettingModel.getAllowNextPersonSetting() != null && allowNextPersonSettingModel.getAllowNextPersonSetting().getReAssignPerson() == null || !allowNextPersonSettingModel.getAllowNextPersonSetting().getReAssignPerson().booleanValue())) {
                needSaveByFirstUserTask = false;
            }
        }
        return needSaveByFirstUserTask;
    }

    private static Map<String, String> getFilterParticipant(ExecutionEntity execution, String nodeId) {
        Long processInstanceId = execution.getProcessInstanceId();
        QFilter textvalueFilter = new QFilter(TEXTVALUE, "like", (Object)("%" + nodeId + "%"));
        QFilter procInstanceFilter = new QFilter("processinstanceid", "=", (Object)processInstanceId);
        QFilter nameFilter = new QFilter(NAMEVARIABLE, "like", (Object)"%assignparticipant");
        QFilter[] filters = new QFilter[]{procInstanceFilter, textvalueFilter, nameFilter};
        DynamicObject[] dynamicObjectArray = BusinessDataServiceHelper.load((String)VARIABLEINSTANCE, (String)"name,textvalue", (QFilter[])filters);
        HashMap<String, String> assignParticipantInfo = new HashMap<String, String>();
        if (dynamicObjectArray.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjectArray) {
                String variableName = (String)dynamicObject.get(NAMEVARIABLE);
                String variableTextValue = (String)dynamicObject.get(TEXTVALUE);
                assignParticipantInfo.put(variableName, variableTextValue);
            }
        }
        return assignParticipantInfo;
    }

    public static void getBeforeAssignParticipant(ExecutionEntity execution, Map<String, Object> dynamicParticipantMap, String nodeId) {
        BpmnModel bpmnModel;
        List<FlowElement> previousNodes;
        Long processInstanceId = execution.getProcessInstanceId();
        Map<String, String> filterParticipant = DynamicFlowUtil.getFilterParticipant(execution, nodeId);
        if (filterParticipant.size() > 0 && (previousNodes = BpmnModelUtil.getPreviousNodes(bpmnModel = ProcessDefinitionUtil.getBpmnModelByProcInstId(processInstanceId), nodeId)) != null && previousNodes.size() > 0) {
            for (FlowElement flowElement : previousNodes) {
                Map nodeInfo;
                String elementId;
                String variableName;
                String assignParticipant;
                String elementType = flowElement.getType();
                if (elementType == null || !WfUtils.isAuditTypeNode(elementType) || (assignParticipant = filterParticipant.get(variableName = (elementId = flowElement.getId()).toLowerCase() + "assignparticipant")) == null) continue;
                Map nodeAssignInfo = (Map)SerializationUtils.fromJsonString((String)assignParticipant, Map.class);
                if (nodeAssignInfo == null || (nodeInfo = (Map)nodeAssignInfo.get(elementId)) == null) break;
                List participantUserIds = (List)nodeInfo.get(nodeId);
                StringBuilder userIdBuilder = new StringBuilder();
                for (String participantUserId : participantUserIds) {
                    userIdBuilder.append(participantUserId);
                    userIdBuilder.append(',');
                }
                if (userIdBuilder.length() > 0) {
                    userIdBuilder.deleteCharAt(userIdBuilder.length() - 1);
                }
                dynamicParticipantMap.put(nodeId, userIdBuilder);
                break;
            }
        }
    }

    public static void mergeAssignToDynamicParticipant(ExecutionEntity execution, FlowNode flowNode, Map<String, Object> dynamicParticipantMap, String nextNodeId) {
        TaskEntity taskEntity;
        String assignParticipant = null;
        Boolean currentTaskExist = Boolean.FALSE;
        String flowNodeId = flowNode.getId();
        String auditType = null;
        if (execution.getCurrentTask() != null && (taskEntity = execution.getCurrentTask()) != null) {
            assignParticipant = (String)taskEntity.getVariableLocal(flowNodeId.toLowerCase() + "assignparticipant");
            currentTaskExist = Boolean.TRUE;
            auditType = (String)taskEntity.getVariable("auditType");
        }
        if (nextNodeId != null && "reject".equals(auditType)) {
            DynamicFlowUtil.getBeforeAssignParticipant(execution, dynamicParticipantMap, flowNodeId);
        }
        if (assignParticipant == null) {
            assignParticipant = (String)execution.getVariable(flowNode.getId().toLowerCase() + "assignparticipant");
        }
        if (assignParticipant != null) {
            Map nodeAssignParticipant = (Map)SerializationUtils.fromJsonString(assignParticipant, Map.class);
            if (nodeAssignParticipant != null && nodeAssignParticipant.get(flowNodeId) != null) {
                Map assignNodeInfo = (Map)nodeAssignParticipant.get(flowNodeId);
                for (Map.Entry assignParticipantEntry : assignNodeInfo.entrySet()) {
                    StringBuilder userIdBuilder = new StringBuilder();
                    List participantUserIds = (List)assignParticipantEntry.getValue();
                    for (String participantUserId : participantUserIds) {
                        userIdBuilder.append(participantUserId);
                        userIdBuilder.append(',');
                    }
                    if (userIdBuilder.length() > 0) {
                        userIdBuilder.deleteCharAt(userIdBuilder.length() - 1);
                    }
                    dynamicParticipantMap.put((String)assignParticipantEntry.getKey(), userIdBuilder);
                }
            }
            if (flowNode instanceof UserTask) {
                AllowNextPersonSetting allowNextPersonSetting;
                AllowNextPersonSettingModel allowNextPersonSettingModel = ((UserTask)flowNode).getAllowNextPersonSettingModel();
                Boolean isInsidetaskAgain = Boolean.FALSE;
                if (allowNextPersonSettingModel != null && (allowNextPersonSetting = allowNextPersonSettingModel.getAllowNextPersonSetting()) != null && allowNextPersonSettingModel.isAllowNextPersonWhenMatch()) {
                    isInsidetaskAgain = allowNextPersonSettingModel.getAllowNextPersonSetting().getReAssignPerson();
                }
                if ((isInsidetaskAgain == null || !isInsidetaskAgain.booleanValue()) && nodeAssignParticipant != null && nodeAssignParticipant.containsKey(flowNodeId)) {
                    execution.getProcessInstance().removeVariableLocalIgnoreCase(flowNode.getId().toLowerCase() + "assignparticipant");
                } else if (isInsidetaskAgain != null && isInsidetaskAgain.booleanValue() && currentTaskExist.booleanValue()) {
                    execution.getProcessInstance().setVariable(flowNode.getId().toLowerCase() + "assignparticipant", SerializationUtils.toJsonString((Object)nodeAssignParticipant));
                }
            }
        }
    }

    public static void transferDynInfo(ExecutionEntity execution, FlowNode flowNode, String nextNodeId) {
        if (execution.getCurrentTask() != null) {
            Object tmp = execution.getCurrentTask().getVariableLocal("CompositeDynParticipant");
            String nodeType = flowNode.getType();
            if (tmp != null && nodeType != null) {
                if ("YunzhijiaTask".equals(nodeType)) {
                    execution.getCurrentTask().removeVariableLocal("dynParticipant");
                    execution.getCurrentTask().removeVariableLocal("CompositeDynParticipant");
                } else if ("AuditTask".equals(nodeType) || "UserTask".equals(nodeType)) {
                    execution.getCurrentTask().removeTransientVariable("dynParticipant");
                    execution.getCurrentTask().removeTransientVariable("CompositeDynParticipant");
                }
            }
        }
        String dynType = DynamicFlowUtil.getDynamicType(execution);
        try {
            Map<String, Object> dynamicParticipantMap = DynamicFlowUtil.getCompatibleParticipantInstance(execution, flowNode);
            DynamicFlowUtil.mergeAssignToDynamicParticipant(execution, flowNode, dynamicParticipantMap, nextNodeId);
            if (WfUtils.isNotEmpty(nextNodeId) && DYNAMICREJECT.equalsIgnoreCase(dynType)) {
                String rejectParticipantStr = nextNodeId.toLowerCase() + "rejectParticipant";
                String rejectParticipantVal = "";
                if (execution.getCurrentTask() != null && execution.getCurrentTask().getVariable(rejectParticipantStr) != null) {
                    rejectParticipantVal = execution.getCurrentTask().getVariable(rejectParticipantStr).toString();
                } else if (flowNode instanceof CallActivity && execution.getVariable(rejectParticipantStr) != null) {
                    rejectParticipantVal = execution.getVariable(rejectParticipantStr).toString();
                    execution.removeVariableLocal(rejectParticipantStr);
                }
                List rejectParticipantList = SerializationUtils.fromJsonStringToList((String)rejectParticipantVal, Map.class);
                if (CollectionUtil.isNotEmpty(rejectParticipantList)) {
                    for (Map rejectParticipant : rejectParticipantList) {
                        dynamicParticipantMap.put((String)rejectParticipant.get("nodeId"), rejectParticipant.get("userIds"));
                    }
                }
            }
            ArrayList instanceVariable = new ArrayList(dynamicParticipantMap.size());
            for (Map.Entry<String, Object> instanceParticipant : dynamicParticipantMap.entrySet()) {
                LinkedHashMap<String, Object> instanceParticipantTemp = new LinkedHashMap<String, Object>();
                instanceParticipantTemp.put("nodeId", instanceParticipant.getKey());
                instanceParticipantTemp.put("userIds", instanceParticipant.getValue());
                instanceVariable.add(instanceParticipantTemp);
            }
            if (instanceVariable.size() > 0) {
                execution.setVariable("dynParticipant", SerializationUtils.toJsonString(instanceVariable));
            }
        }
        catch (Exception exception) {
            log.error(WfUtils.getExceptionStacktrace(exception));
        }
        if (nextNodeId != null) {
            DynamicFlowUtil.transferVariablesToTargetNode(execution, flowNode.getId(), nextNodeId);
        }
        if (WfUtils.isNotEmpty(dynType)) {
            if (DynamicFlowUtil.isAbortCurNode(execution, dynType)) {
                execution.getProcessInstance().setVariable("endType", DynamicFlowUtil.getEndTypeByDynType(dynType));
                execution.getProcessInstance().setVariable("exceptionEvent", DynamicFlowUtil.getDynamicVariableValue(execution, "exceptionEvent"));
            } else if (DYNAMICREJECT.equalsIgnoreCase(dynType) && !(flowNode instanceof CallActivity)) {
                execution.getProcessInstance().setVariable("allowRejectAndGoBack", DynamicFlowUtil.getDynamicVariableValue(execution, "allowRejectAndGoBack"));
                execution.getProcessInstance().setVariable("rejectBackToNode", DynamicFlowUtil.getDynamicVariableValue(execution, "rejectBackToNode"));
            }
        }
        DynamicFlowUtil.transferRejectToParentProessVarsToProcessVars(execution, dynType, nextNodeId);
        DynamicFlowUtil.removeVariablesWhenLeaving(execution, flowNode);
        DynamicFlowUtil.transferVariablesToProcessVariables(execution, "dynNodeInfo");
        DynamicFlowUtil.transferVariablesToProcessVariables(execution, "priority");
    }

    private static void transferRejectToParentProessVarsToProcessVars(ExecutionEntity execution, String dynType, String nextNodeId) {
        ExecutionEntity processInstance;
        if (REJECTTOPARENTPROCESS.equals(dynType) && execution != null && (processInstance = execution.getProcessInstance()) != null && processInstance.getVariable("rejectToParentProcess_variablesMap") == null) {
            String nextNodeDealPerson;
            HashMap<String, String> varMap = new HashMap<String, String>(3);
            if (WfUtils.isNotEmpty(nextNodeId)) {
                varMap.put("rejectToParentProcess_nextNodeId", nextNodeId);
                String rejectParticipant = DynamicFlowUtil.getDynamicVariableValue(execution, nextNodeId.toLowerCase() + "rejectParticipant");
                if (WfUtils.isNotEmpty(rejectParticipant)) {
                    varMap.put("rejectToParentProcess_rejectParticipant", rejectParticipant);
                }
            }
            if (WfUtils.isNotEmpty(nextNodeDealPerson = DynamicFlowUtil.getDynamicVariableValue(execution, "nextnodedealperson"))) {
                varMap.put("rejectToParentProcess_nextNodeDealPerson", nextNodeDealPerson);
            }
            processInstance.setVariable("rejectToParentProcess_variablesMap", SerializationUtils.toJsonString(varMap));
        }
    }

    public static String getEndTypeByDynType(String type) {
        String endType = "10";
        switch (type) {
            case "auditAbort": {
                endType = "30";
                break;
            }
            case "forceAbort": {
                endType = "40";
                break;
            }
            case "billAbort": {
                endType = "60";
                break;
            }
            case "billExcepAbort": {
                endType = "50";
                break;
            }
            case "process instance withdraw": {
                endType = "20";
                break;
            }
            case "abortByParentProcessJump": {
                endType = "70";
                break;
            }
            case "abortByParentProcessAbort": {
                endType = "80";
                break;
            }
            case "abortByParentProcessWithdraw": {
                endType = "90";
                break;
            }
            case "meetBillClose": {
                endType = "100";
                break;
            }
            case "terminateProcWhenExceptionOccurs": {
                endType = "110";
                break;
            }
            case "abortByRejectToParentProcess": {
                endType = "120";
                break;
            }
        }
        return endType;
    }

    public static void transferVariablesToTargetNode(ExecutionEntity execution, String curNode, String nextNodeId) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("srcNode", curNode);
        param.put("dynToNode", nextNodeId);
        String dynType = DynamicFlowUtil.getDynamicType(execution);
        param.put("dynType", dynType);
        DynamicFlowUtil.extraNextNodeVariablesByDynType(execution, param);
        execution.setVariableLocal("dynToNode", SerializationUtils.toJsonString(param));
    }

    public static boolean isRejectInCurrentNode(DelegateExecution execution, String curNodeId) {
        Map tmp;
        String rejectNode = (String)execution.getVariableLocal("dynToNode");
        if (rejectNode != null && WfUtils.isNotEmpty(rejectNode) && (tmp = (Map)SerializationUtils.fromJsonString((String)rejectNode, Map.class)) != null && tmp.get("dynToNode") != null) {
            String s;
            String dynToNodes = (String)tmp.get("dynToNode");
            boolean flag = false;
            String[] stringArray = dynToNodes.split("\\,");
            int n = stringArray.length;
            for (int i = 0; i < n && !(flag = curNodeId.equals(s = stringArray[i])); ++i) {
            }
            String dynType = (String)tmp.get("dynType");
            return flag && (DYNAMICREJECT.equals(dynType) || "rejectToForkInner".equals(dynType));
        }
        return false;
    }

    public static boolean isJumpInCurrentNode(DelegateExecution execution, String curNodeId) {
        Map tmp;
        String dynNode = (String)execution.getVariableLocal("dynToNode");
        return dynNode != null && WfUtils.isNotEmpty(dynNode) && (tmp = (Map)SerializationUtils.fromJsonString((String)dynNode, Map.class)) != null && tmp.get("dynToNode") != null && curNodeId.equals(tmp.get("dynToNode")) && FORCEJUMP.equals(tmp.get("dynType"));
    }

    public static boolean isBillWithdrawJumpInCurrentNode(DelegateExecution execution, String curNodeId) {
        Map tmp;
        String dynNode = (String)execution.getVariableLocal("dynToNode");
        return WfUtils.isNotEmpty(dynNode) && (tmp = (Map)SerializationUtils.fromJsonString((String)dynNode, Map.class)) != null && tmp.get("dynToNode") != null && ((String)tmp.get("dynToNode")).equals(curNodeId) && BILLWITHDRAWJUMP.equals(tmp.get("dynType"));
    }

    public static boolean isRejectFromCurNode(ExecutionEntity execution) {
        if (execution.getCurrentTask() != null && WfUtils.isNotEmpty(execution.getCurrentTask().getId())) {
            String type = (String)execution.getCurrentTask().getVariableLocal("dynType");
            return type != null && DYNAMICREJECT.equalsIgnoreCase(type);
        }
        return false;
    }

    public static boolean isRejectFromCallActivity(ExecutionEntity execution) {
        if (execution != null && execution.getCurrentFlowElement() instanceof CallActivity) {
            String dynType = (String)execution.getVariable("dynType");
            return DYNAMICREJECT.equalsIgnoreCase(dynType);
        }
        return false;
    }

    public static List<SelectNodesModel> getUpperLevel(TaskEntity task) {
        HiUserActInstEntity curUserActivity;
        CommandContext commandContext = Context.getCommandContext();
        List<HiUserActInstEntity> userActInstEntities = commandContext.getHiUserActInstEntityManager().findeByProInstIdAndBusinessKey(task.getProcessInstanceId());
        HashMap<String, ArrayList<HiUserActInstEntity>> joinFlagMap = new HashMap<String, ArrayList<HiUserActInstEntity>>();
        HashMap<Long, HiUserActInstEntity> hiUserActivityIdMap = new HashMap<Long, HiUserActInstEntity>(userActInstEntities.size());
        HashMap<Long, String> preActEndTypes = new HashMap<Long, String>(userActInstEntities.size());
        for (HiUserActInstEntity act : userActInstEntities) {
            hiUserActivityIdMap.put(act.getCurrentActinstId(), act);
            preActEndTypes.put(act.getLastNodeActinstId(), act.getEndType());
            if (act.getJoinFlag() == null || act.getJoinFlag().equalsIgnoreCase("") || act.getJoinFlag().equalsIgnoreCase("forkJumpOrReject")) continue;
            ArrayList<HiUserActInstEntity> tmp = (ArrayList<HiUserActInstEntity>)joinFlagMap.get(act.getJoinFlag());
            if (tmp == null) {
                tmp = new ArrayList<HiUserActInstEntity>();
            }
            tmp.add(act);
            joinFlagMap.put(act.getJoinFlag(), tmp);
        }
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModelByProcInstId(task.getProcessInstanceId());
        List<FlowElement> previousNodes = BpmnModelUtil.getPreviousNodes(bpmnModel, task.getTaskDefinitionKey());
        Process process = ProcessDefinitionUtil.getProcess(task.getProcessDefinitionId(), task.getProcessInstanceId());
        Map<String, NodeForkJoinModel> nodeForkJoinModelMap = process.getForkJoinModels();
        String structure = nodeForkJoinModelMap.get(task.getTaskDefinitionKey()).getForkStructure();
        HashSet<String> structures = new HashSet<String>();
        structures.add(structure);
        if (structure.contains("$")) {
            structures.add(structure.substring(0, structure.lastIndexOf(36)));
        }
        if ((curUserActivity = (HiUserActInstEntity)hiUserActivityIdMap.get(task.getExecution().getCurrentActInstId())) == null && "YunzhijiaTask".equals(task.getCategory())) {
            EntityQueryBuilder entityEntityQueryBuilder = commandContext.getHistoricActivityInstanceEntityManager().createQueryBuilder().addFilter("processInstanceId", "=", task.getProcessInstanceId()).addFilter("parentTaskId", "=", task.getParentTaskId());
            List acts = commandContext.getHistoricActivityInstanceEntityManager().findByQueryBuilder(entityEntityQueryBuilder);
            for (HistoricActivityInstanceEntity act : acts) {
                if (!task.getParentTaskId().equals(act.getParentTaskId()) || hiUserActivityIdMap.get(act.getId()) == null) continue;
                curUserActivity = (HiUserActInstEntity)hiUserActivityIdMap.get(act.getId());
                break;
            }
        }
        Map<Long, HistoricActivityInstanceEntity> hiActivityIdMap = DynamicFlowUtil.initActInsts(commandContext, task.getProcessInstanceId());
        HiUserActInstEntity re = null;
        while (curUserActivity != null) {
            HiUserActInstEntity callActiHiUserActInstEntity;
            if (curUserActivity.getPathJson() != null && curUserActivity.getPathJson().contains("CallActivity") && (callActiHiUserActInstEntity = DynamicFlowUtil.getCallActivityHiUserActInstEntityFromPathJson(commandContext, hiActivityIdMap, curUserActivity.getPathJson(), structures, bpmnModel, previousNodes)) != null) {
                re = callActiHiUserActInstEntity;
                break;
            }
            NodeForkJoinModel curNodeForkJoin = nodeForkJoinModelMap.get(curUserActivity.getCurrentActId());
            structure = curNodeForkJoin.getForkStructure();
            String endType = (String)preActEndTypes.get(curUserActivity.getCurrentActinstId());
            if (!curNodeForkJoin.isJoinNode() && structures.contains(structure) && previousNodes.contains(bpmnModel.getFlowElement(curUserActivity.getCurrentActId())) && !"jump".equals(endType)) {
                re = curUserActivity;
                break;
            }
            NodeForkJoinModel curNodeForkJoinModel = nodeForkJoinModelMap.get(task.getTaskDefinitionKey());
            List curJoinflags = (List)joinFlagMap.get(curUserActivity.getJoinFlag());
            HiUserActInstEntity tmpUserActivity = null;
            if (curNodeForkJoinModel.isJoinNode() || curJoinflags != null && curJoinflags.size() > 0) {
                if (curJoinflags != null && curJoinflags.size() == 1) {
                    structures.add(hiActivityIdMap.get(curUserActivity.getLastNodeActinstId()).getForkPath());
                    tmpUserActivity = (HiUserActInstEntity)hiUserActivityIdMap.get(curUserActivity.getLastNodeActinstId());
                } else {
                    tmpUserActivity = (HiUserActInstEntity)hiUserActivityIdMap.get(curUserActivity.getLastNodeActinstId());
                }
            } else {
                tmpUserActivity = (HiUserActInstEntity)hiUserActivityIdMap.get(curUserActivity.getLastNodeActinstId());
            }
            if (tmpUserActivity != null) {
                curUserActivity = tmpUserActivity;
                continue;
            }
            FlowElement flowNode = bpmnModel.getFlowElement(curUserActivity.getLastUserNodeActId());
            if (flowNode instanceof StartEvent) {
                HistoricActivityInstanceEntity startEvent = hiActivityIdMap.get(curUserActivity.getLastNodeActinstId());
                HistoricActivityInstanceEntity squeue = hiActivityIdMap.get(startEvent.getTargetElementId());
                HistoricActivityInstanceEntity userNode = hiActivityIdMap.get(squeue.getTargetElementId());
                if (userNode != null && curUserActivity.getPathJson() != null) {
                    HiUserActInstEntity userAct = (HiUserActInstEntity)commandContext.getHiUserActInstEntityManager().create();
                    userAct.setCurrentActId(userNode.getActivityId());
                    userAct.setCurrentActinstId(userNode.getId());
                    userAct.setCurrentNodeName(userNode.getActivityName().toString());
                    curUserActivity = userAct;
                    continue;
                }
                curUserActivity = null;
                continue;
            }
            curUserActivity = null;
        }
        ArrayList<SelectNodesModel> selectNodesModels = new ArrayList<SelectNodesModel>();
        if (re != null) {
            SelectNodesModel selectNodesModel = new SelectNodesModel();
            selectNodesModel.setItemId(re.getCurrentActId());
            selectNodesModel.setName(re.getCurrentNodeName().toString());
            selectNodesModels.add(selectNodesModel);
        }
        return selectNodesModels;
    }

    private static HiUserActInstEntity getCallActivityHiUserActInstEntityFromPathJson(CommandContext commandContext, Map<Long, HistoricActivityInstanceEntity> hiActivityIdMap, String pathJsonStr, Set<String> structures, BpmnModel bpmnModel, List<FlowElement> previousNodes) {
        List paths = SerializationUtils.fromJsonStringToList((String)pathJsonStr, PathJson.class);
        Collections.reverse(paths);
        for (PathJson pathJson : paths) {
            if (pathJson.getNodeId() == null || !pathJson.getNodeId().contains("CallActivity")) continue;
            Long actInstId = pathJson.getActInstId();
            HistoricActivityInstanceEntity callActivityHiActivityInstEntity = hiActivityIdMap.get(actInstId);
            String executionType = callActivityHiActivityInstEntity.getExecutionType();
            String activityId = callActivityHiActivityInstEntity.getActivityId();
            String structure = bpmnModel.getMainProcess().getForkJoinModels().get(activityId).getForkStructure();
            if ("skip".equals(executionType) || !structures.contains(structure) || !previousNodes.contains(bpmnModel.getFlowElement(activityId))) continue;
            HiUserActInstEntity userAct = (HiUserActInstEntity)commandContext.getHiUserActInstEntityManager().create();
            userAct.setCurrentActId(activityId);
            userAct.setCurrentActinstId(actInstId);
            userAct.setCurrentNodeName(callActivityHiActivityInstEntity.getActivityName().toString());
            return userAct;
        }
        return null;
    }

    private static Map<Long, HistoricActivityInstanceEntity> initActInsts(CommandContext commandContext, Long processInstanceId) {
        List<HistoricActivityInstanceEntity> actInstEntities = commandContext.getHistoricActivityInstanceEntityManager().findByProcessInstanceId(processInstanceId);
        HashMap<Long, HistoricActivityInstanceEntity> hiActivityIdMap = new HashMap<Long, HistoricActivityInstanceEntity>(actInstEntities.size());
        for (HistoricActivityInstanceEntity act : actInstEntities) {
            hiActivityIdMap.put(act.getId(), act);
        }
        return hiActivityIdMap;
    }

    public static boolean isRejectToForkInner(ExecutionEntity execution) {
        return "rejectToForkInner".equals(DynamicFlowUtil.getDynamicVariableValue(execution, "dynType"));
    }

    public static boolean skipRejectInnerAfterNode(ExecutionEntity execution, FlowNode node, boolean cleanVar) {
        boolean skip = false;
        String currentNodeId = node.getId();
        String key = String.format("%s_%s", currentNodeId, "rejectToForkInnerAndSkip");
        String rejectInnerInfo = (String)execution.getProcessInstance().getVariable(key);
        if (WfUtils.isNotEmpty(rejectInnerInfo)) {
            String skipNodesKey = String.format("%s$%s", "skipNode", rejectInnerInfo);
            String[] nodes = rejectInnerInfo.split("\\-");
            if (currentNodeId.equals(nodes[1])) {
                if (cleanVar) {
                    execution.getProcessInstance().removeVariable(key);
                    execution.getProcessInstance().removeVariable(skipNodesKey);
                }
            } else {
                boolean bl = skip = !currentNodeId.equals(nodes[0]);
                if (skip) {
                    skip = false;
                    String skipNodes = (String)execution.getProcessInstance().getVariable(skipNodesKey);
                    if (WfUtils.isEmpty(skipNodes)) {
                        BpmnModel model = Context.getProcessEngineConfiguration().getCommandExecutor().execute(new GetConfigSchemeBpmnModelCmd(execution.getSchemeId()));
                        List<FlowElement> eles = BpmnModelUtil.getFollowNodes(model, nodes[0]);
                        List<FlowElement> stopNodeFollowEles = BpmnModelUtil.getFollowNodes(model, nodes[1]);
                        ArrayList<String> stopNodeFollowEleIds = new ArrayList<String>(16);
                        for (FlowElement flowElement : stopNodeFollowEles) {
                            stopNodeFollowEleIds.add(flowElement.getId());
                        }
                        stopNodeFollowEleIds.add(nodes[1]);
                        StringBuilder sb = new StringBuilder();
                        for (FlowElement ele : eles) {
                            String eleId = ele.getId();
                            if (stopNodeFollowEleIds.contains(eleId)) continue;
                            sb.append(ele.getId()).append(',');
                        }
                        if (sb.length() > 0) {
                            skipNodes = sb.substring(0, sb.length() - 1);
                            execution.getProcessInstance().setVariable(skipNodesKey, skipNodes);
                        }
                    }
                    if (WfUtils.isNotEmpty(skipNodes)) {
                        String[] skipNodesArr;
                        boolean acrossRejectInnerNode = true;
                        for (String string : skipNodesArr = skipNodes.split("\\,")) {
                            if (!string.equals(currentNodeId)) continue;
                            skip = true;
                            acrossRejectInnerNode = false;
                            break;
                        }
                        if (acrossRejectInnerNode && cleanVar) {
                            execution.getProcessInstance().removeVariable(key);
                            execution.getProcessInstance().removeVariable(skipNodesKey);
                        }
                    }
                }
            }
        }
        return skip;
    }

    public static boolean isNextNodeTerminate(ExecutionEntity execution) {
        String dynType;
        String auditType = null;
        if (execution.getCurrentTask() != null && WfUtils.isNotEmpty(execution.getCurrentTask().getId())) {
            auditType = (String)execution.getCurrentTask().getVariable("auditType");
        }
        return FORCEABORT.equalsIgnoreCase(dynType = DynamicFlowUtil.getDynamicVariableValue(execution, "dynType")) || "compensationAbort".equalsIgnoreCase(dynType) || BILLEXCEPABORT.equalsIgnoreCase(dynType) || BILLABORT.equalsIgnoreCase(dynType) || "processrestart".equalsIgnoreCase(dynType) || PARENTPROCESSJUMP.equals(dynType) || PARENTPROCESSABORT.equals(dynType) || MEETBILLCLOSEABORT.equals(dynType) || PARENTPROCESSWITHDRAW.equals(dynType) || TERMINATEPROCWHENEXCEPTIONOCCURS.equals(dynType) || REJECTTOPARENTPROCESS.equals(dynType) || "terminate".equals(auditType) && AUDITABORT.equalsIgnoreCase(dynType);
    }

    public static boolean isNextNodeTerminateExceptAuditAbort(ExecutionEntity execution) {
        String dynType = DynamicFlowUtil.getDynamicVariableValue(execution, "dynType");
        return FORCEABORT.equalsIgnoreCase(dynType) || BILLEXCEPABORT.equalsIgnoreCase(dynType) || BILLABORT.equalsIgnoreCase(dynType) || MEETBILLCLOSEABORT.equalsIgnoreCase(dynType) || PARENTPROCESSJUMP.equals(dynType) || PARENTPROCESSABORT.equals(dynType) || PARENTPROCESSWITHDRAW.equals(dynType);
    }

    public static boolean isTerminalSkipReason(String skipReason) {
        return "ForceAbort".equalsIgnoreCase(skipReason) || "BillAbort".equalsIgnoreCase(skipReason) || "BillExcepAbort".equalsIgnoreCase(skipReason) || "ParentProcessAbort".equals(skipReason) || "ParentProcessJump".equals(skipReason) || "parentProcessWithdraw".equals(skipReason) || "TerminateProcWhenExceptionOccurs".equals(skipReason);
    }

    public static boolean isAddSignBefore(ExecutionEntity execution) {
        String dynType = null;
        dynType = execution.getCurrentTask() != null && WfUtils.isNotEmpty(execution.getCurrentTask().getId()) ? (String)execution.getCurrentTask().getVariable("dynType") : (String)execution.getVariable("dynType");
        return ADDSIGN.equals(dynType);
    }

    public static boolean isFreeFlow(ExecutionEntity execution) {
        String freeflowStr = (String)execution.getVariable(DynamicFlowUtil.getFreeFlowNode(execution.getActivityId()));
        if (WfUtils.isNotEmpty(freeflowStr)) {
            BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModelByProcInstId(execution.getProcessInstanceId());
            FlowElement flowElement = bpmnModel.getFlowElement(execution.getActivityId());
            if (flowElement instanceof FlowNode) {
                int count = 0;
                List<SequenceFlow> outgoingFlows = ((FlowNode)flowElement).getOutgoingFlows();
                for (SequenceFlow sequenceFlow : outgoingFlows) {
                    if (sequenceFlow.isDynamic()) continue;
                    ++count;
                }
                if (count != 1) {
                    return false;
                }
                count = 0;
                FlowElement targetFlowElement = outgoingFlows.get(0).getTargetFlowElement();
                List<SequenceFlow> incomingFlows = ((FlowNode)targetFlowElement).getIncomingFlows();
                for (SequenceFlow sequenceFlow : incomingFlows) {
                    if (sequenceFlow.isDynamic()) continue;
                    ++count;
                }
                if (count >= 2) {
                    return false;
                }
            }
            CommandContext commandContext = Context.getCommandContext();
            DynamicResourceEntityManager dynamicResourceEntityManager = commandContext.getDynamicResourceEntityManager();
            return dynamicResourceEntityManager.hasAddFreeFlow(execution.getProcessInstanceId(), execution.getActivityId(), "freeflowafternode");
        }
        return false;
    }

    public static String getFreeFlowNode(String key) {
        return String.format("%s%s", key, "_freeflow");
    }

    public static boolean isNextNodeDynamicJump(ExecutionEntity execution) {
        String dynType = DynamicFlowUtil.getDynamicType(execution);
        return dynType != null && (FORCEJUMP.equalsIgnoreCase(dynType) || BILLWITHDRAWJUMP.equalsIgnoreCase(dynType));
    }

    public static String getDynamicVariableValue(ExecutionEntity execution, String variableName) {
        String val = null;
        if (execution.getCurrentTask() == null) {
            val = (String)execution.getVariable(variableName);
        } else {
            val = (String)execution.getVariableLocal(variableName);
            if (execution.getCurrentTask() != null && WfUtils.isNotEmpty(execution.getCurrentTask().getId()) && WfUtils.isNotEmpty(val) && execution.getCurrentTask().isFromHistory()) {
                return val;
            }
            val = (String)execution.getCurrentTask().getVariable(variableName);
        }
        return val;
    }

    public static String getDynamicType(ExecutionEntity execution) {
        return DynamicFlowUtil.getDynamicVariableValue(execution, "dynType");
    }

    public static void removeDynParticipantVariable(ExecutionEntity execution, String flowNodeId) {
        String dynParticipant = (String)execution.getVariableLocal("dynParticipant");
        if (dynParticipant != null && WfUtils.isNotEmpty(dynParticipant)) {
            List parts = (List)SerializationUtils.fromJsonString((String)dynParticipant, List.class);
            if (parts != null && parts.size() > 0) {
                Iterator iter = parts.iterator();
                while (iter.hasNext()) {
                    Map map = (Map)iter.next();
                    if (map == null || map.get("nodeId") == null || !flowNodeId.equals(map.get("nodeId"))) continue;
                    iter.remove();
                }
            }
            if (parts != null && parts.size() > 0) {
                if (execution.hasVariableLocal("dynParticipant")) {
                    execution.setVariableLocal("dynParticipant", SerializationUtils.toJsonString((Object)parts));
                } else if (execution.hasVariableLocal("dynparticipant")) {
                    execution.setVariableLocal("dynParticipant", SerializationUtils.toJsonString((Object)parts));
                }
            } else {
                execution.removeVariableLocalIgnoreCase("dynParticipant");
            }
        }
    }

    public static Map<String, Object> extraCurNodeVariablesByDynType(ExecutionEntity execution, Map<String, Object> variables) {
        return DynamicFlowUtil.extraVariablesByDynType(variables, CURNODE);
    }

    private static Map<String, Object> extraNextNodeVariablesByDynType(ExecutionEntity execution, Map<String, Object> variables) {
        return DynamicFlowUtil.extraVariablesByDynType(variables, NEXTNODE);
    }

    private static Map<String, Object> extraVariablesByDynType(Map<String, Object> variables, String type) {
        Map<String, String> val;
        String dynType = (String)variables.get("dynType");
        if (WfUtils.isNotEmpty(dynType) && (val = DynamicFlowUtil.createVariableCollection().get(dynType + type)) != null && !val.isEmpty()) {
            for (Map.Entry<String, String> entry : val.entrySet()) {
                String key = entry.getKey();
                if (variables.get(key) != null) continue;
                variables.put(key, val.get(key));
            }
        }
        return variables;
    }

    public static SkipInfo isSkipNode(ExecutionEntity execution) {
        SkipInfo info = new SkipInfo(false);
        boolean skipUserTask = DynamicFlowUtil.isSkipCurNode(execution);
        if (skipUserTask) {
            info.setSkip(true);
            info.setSkipReason((String)execution.getVariableLocal("skipReason"));
            info.setExecutionType((String)execution.getVariableLocal("executionType"));
            return info;
        }
        return info;
    }

    public static String getDynNode(ExecutionEntity executionEntity) {
        String dynNode = null;
        if (executionEntity instanceof PreComputatorExecutionEntityImpl) {
            NodeTempVariable var = ((PreComputatorExecutionEntityImpl)executionEntity).getTempVariableMap().get("dynToNode");
            if (var != null) {
                dynNode = var.getNodeId();
            }
        } else {
            dynNode = (String)executionEntity.getVariable("dynToNode");
        }
        return dynNode;
    }

    public static boolean rejectBackNotSkip(ExecutionEntity executionEntity, String taskActivityId) {
        if (WfConfigurationUtil.rejectToBackAndAutomaticProcessingFailure()) {
            return DynamicFlowUtil.isRejectToBack(executionEntity, taskActivityId);
        }
        return false;
    }

    public static boolean rejectBackNeedAgainCalculatorPartcipant(ExecutionEntity executionEntity, String taskActivityId) {
        if (WfConfigurationUtil.rejectToBackAndRecalculationParticipant()) {
            return DynamicFlowUtil.isRejectToBack(executionEntity, taskActivityId);
        }
        return false;
    }

    public static boolean isRejectToBack(ExecutionEntity executionEntity, String taskActivityId) {
        String dynNode;
        if (executionEntity.getCurrentFlowElement() instanceof AuditTask && StringUtils.isNotEmpty((String)(dynNode = DynamicFlowUtil.getDynNode(executionEntity)))) {
            Map map = (Map)JSON.parse((String)dynNode);
            String backToRejectNode = (String)map.get("dynType");
            String dynToNode = (String)map.get("dynToNode");
            return (BACKTOREJECTNODE.equalsIgnoreCase(backToRejectNode) || "rejectBackToNode".equalsIgnoreCase(backToRejectNode)) && taskActivityId.equalsIgnoreCase(dynToNode);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static SkipInfo isSkipTask(FlowNode userTask, TaskEntity task, ExecutionEntity execution) {
        boolean skipUserTask;
        SkipInfo info;
        boolean isBizFlow;
        block19: {
            block17: {
                block18: {
                    boolean isInSubProcess;
                    SkipInfo skipInfo;
                    isBizFlow = BizFlowUtil.isBizFlowExecution(execution);
                    if (isBizFlow && (skipInfo = BizFlowUtil.getSkipInfoWhenBoot(execution, userTask)).isSkip()) {
                        return skipInfo;
                    }
                    if (DynamicFlowUtil.skipRejectInnerAfterNode(execution, userTask, true)) {
                        return new SkipInfo(true, "rejectToForkInnerAndSkip");
                    }
                    info = new SkipInfo(false);
                    skipUserTask = false;
                    if (!userTask.getClass().getName().equalsIgnoreCase(UserTask.class.getName())) break block17;
                    if (BizFlowUtil.isBizFlowExecution(execution)) {
                        skipUserTask = BpmnModelUtil.isFirstNodeByModel(userTask);
                        if (!skipUserTask) {
                            String bootNodeId = (String)execution.getVariable("bootNodeId");
                            skipUserTask = bootNodeId != null && userTask.getId().equalsIgnoreCase(bootNodeId);
                        }
                    } else {
                        skipUserTask = BpmnModelUtil.isSkipFirstUserTaskByPath(execution);
                    }
                    if (!skipUserTask) break block18;
                    info.setFirstNode(true);
                    String evtStart = (String)execution.getVariable("_eventNumber_");
                    boolean operationStart = WfUtils.isEmpty(evtStart);
                    boolean bl = isInSubProcess = execution.getSuperExecution() != null;
                    if (operationStart && !isInSubProcess) {
                        String op = (String)execution.getVariable("_operation_");
                        if (op != null && userTask instanceof UserTask) {
                            info.setSkip(DynamicFlowUtil.inDecisionOptions((UserTask)userTask, op));
                        } else {
                            info.setSkip(!isBizFlow);
                            log.warn("it cannot go here, what happen?");
                        }
                        info.setSkipReason("FirstUserTask");
                        return info;
                    }
                    if (isInSubProcess) {
                        boolean parentBizFlow = BizFlowUtil.isBizFlowExecution(execution.getSuperExecution());
                        if (!parentBizFlow) {
                            info.setSkip(true);
                            info.setSkipReason("FirstUserTask");
                            return info;
                        }
                        String op = (String)execution.getVariable("_operation_");
                        String ops = (String)execution.getVariable("_operations_");
                        if ((op != null || ops != null) && userTask instanceof UserTask) {
                            List<String> opList = null;
                            opList = ops != null ? Arrays.asList(ops.split(",")) : Collections.singletonList(op);
                            info.setSkip(DynamicFlowUtil.inDecisionOptions((UserTask)userTask, opList, execution));
                        }
                        break block19;
                    } else if (operationStart) {
                        // empty if block
                    }
                    break block19;
                }
                info.setFirstNode(false);
                break block19;
            }
            info.setFirstNode(false);
        }
        boolean rejectBackNotSkip = DynamicFlowUtil.rejectBackNotSkip(execution, userTask.getId());
        if (!isBizFlow && rejectBackNotSkip) {
            SkipInfo skipInfo = new SkipInfo(false);
            skipInfo.setSkipReason("RejectToBackNotSkip");
            return skipInfo;
        }
        skipUserTask = DynamicFlowUtil.isSkipCurNode(execution);
        if (skipUserTask) {
            info.setSkip(true);
            info.setSkipReason((String)execution.getVariableLocal("skipReason"));
            info.setExecutionType((String)execution.getVariableLocal("executionType"));
            return info;
        }
        if (!info.isSkip() && userTask instanceof ISupportSkipCondition && ConditionUtil.isConditionAvailable(((ISupportSkipCondition)((Object)userTask)).getSkipCondition())) {
            String key = ConditionUtil.getConInstKey(userTask.getNumber(), "skip");
            skipUserTask = ConditionUtil.hasTrueCondition(((ISupportSkipCondition)((Object)userTask)).getSkipCondition(), task == null ? execution : task, key);
            if (skipUserTask) {
                info.setSkip(true);
                info.setSkipReason("MeetSkipCondition");
                return info;
            }
        }
        return info;
    }

    private static boolean inDecisionOptions(UserTask userTask, List<String> opList, ExecutionEntity execution) {
        if (userTask != null && userTask.getDecisionOptions() != null && !userTask.getDecisionOptions().isEmpty()) {
            for (DecisionOption dc : userTask.getDecisionOptions()) {
                if (!opList.contains(dc.getNumber())) continue;
                if (opList.size() > 1) {
                    execution.setVariable("_operation_", dc.getNumber());
                }
                return true;
            }
        }
        return false;
    }

    private static boolean inDecisionOptions(UserTask userTask, String op) {
        if (userTask != null && userTask.getDecisionOptions() != null && !userTask.getDecisionOptions().isEmpty()) {
            for (DecisionOption dc : userTask.getDecisionOptions()) {
                if (!dc.getNumber().equalsIgnoreCase(op)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getCustomNextNodeId(ExecutionEntity execution) {
        return DynamicFlowUtil.getDynamicVariableValue(execution, "nextNodeId");
    }

    public static String getCustomNextNodeParticipant(ExecutionEntity execution) {
        if (execution.getCurrentTask() != null) {
            return (String)execution.getCurrentTask().getVariableLocal("dynParticipant");
        }
        return null;
    }

    public static boolean isSkipForMultiInstance(ExecutionEntity execution, ExecutionEntity miRootExecution) {
        boolean ret;
        boolean bl = ret = DynamicFlowUtil.isNextNodeTerminateExceptAuditAbort(execution) || DynamicFlowUtil.isNextNodeDynamicJump(execution) || DynamicFlowUtil.isExpireSkipForCurNode(execution) || DynamicFlowUtil.isAddSignBefore(execution);
        if (!ret) {
            ret = DynamicFlowUtil.isNextNodeTerminateExceptAuditAbort(miRootExecution) || DynamicFlowUtil.isNextNodeDynamicJump(miRootExecution) || DynamicFlowUtil.isExpireSkipForCurNode(miRootExecution) || DynamicFlowUtil.isAddSignBefore(miRootExecution);
        }
        return ret;
    }

    private static boolean isExpireSkipForCurNode(ExecutionEntity execution) {
        String dynType = DynamicFlowUtil.getDynamicType(execution);
        return dynType != null && EXPIRESKIP.equalsIgnoreCase(dynType);
    }

    public static String getComingInWay(DelegateExecution execution, String curNodeId) {
        Object dynNode;
        String comingInWay = "normal";
        if (null != execution && WfUtils.isNotEmptyString(dynNode = execution.getVariableLocal("dynToNode"))) {
            try {
                Map tmp = (Map)SerializationUtils.fromJsonString((String)((String)dynNode), Map.class);
                if (tmp != null && tmp.get("dynToNode") != null && curNodeId.equals(tmp.get("dynToNode"))) {
                    comingInWay = (String)tmp.get("dynType");
                }
            }
            catch (Exception e) {
                log.error(WfUtils.getExceptionStacktrace(e));
            }
        }
        return comingInWay;
    }

    public static Object getDynNodeInfoByAttr(ExecutionEntity execution, String curNodeId, String attrName) {
        if (null != execution && WfUtils.isNotEmpty(curNodeId) && WfUtils.isNotEmpty(attrName)) {
            Object dynNodeInfoObj;
            Object attrValue = execution.getVariable(attrName);
            if (WfUtils.isNotEmptyString(attrValue)) {
                return attrValue;
            }
            Map dynNodeInfo = DynamicFlowUtil.getDynNodeInfo(execution.getProcessInstance(), "dynNodeInfo");
            if (dynNodeInfo != null && WfUtils.isNotEmptyForMap(dynNodeInfo) && (dynNodeInfoObj = dynNodeInfo.get(curNodeId)) instanceof Map) {
                Map dynNodeInfoDetail = (Map)dynNodeInfoObj;
                return dynNodeInfoDetail.get(attrName);
            }
        }
        return null;
    }

    private static void removeDynNodeInfoVariable(ExecutionEntity execution, String curNodeId) {
        ExecutionEntity processInstance;
        if (null != execution && null != (processInstance = execution.getProcessInstance())) {
            String variableName = "dynNodeInfo";
            if (WfUtils.isEmpty(curNodeId)) {
                processInstance.removeVariable(variableName);
            } else {
                Map dynNodeInfo = DynamicFlowUtil.getDynNodeInfo(processInstance, variableName);
                if (null != dynNodeInfo) {
                    dynNodeInfo.remove(curNodeId);
                    if (WfUtils.isNotEmptyForMap(dynNodeInfo)) {
                        processInstance.setVariable(variableName, SerializationUtils.toJsonString((Object)dynNodeInfo));
                    } else {
                        processInstance.removeVariable(variableName);
                    }
                }
            }
            FlowElement currentFlowElement = execution.getCurrentFlowElement();
            if (null == currentFlowElement || !"StartSignalEvent".equals(currentFlowElement.getType())) {
                processInstance.removeVariable("priority");
            }
        }
    }

    private static void transferVariablesToProcessVariables(ExecutionEntity execution, String variableName) {
        String variableValue;
        ExecutionEntity processInstance;
        if (null != execution && WfUtils.isNotEmpty(variableName) && null != (processInstance = execution.getProcessInstance()) && WfUtils.isEmptyString(processInstance.getVariable(variableName)) && WfUtils.isNotEmpty(variableValue = DynamicFlowUtil.getDynamicVariableValue(execution, variableName))) {
            processInstance.setVariable(variableName, variableValue);
        }
    }

    public static String getCurrentNodeIdByExecution(DelegateExecution execution) {
        FlowElement element;
        if (null != execution && null != (element = execution.getCurrentFlowElement())) {
            return element.getId();
        }
        return null;
    }

    public static Map getDynNodeInfo(ExecutionEntity processInstance, String variableName) {
        Object variable;
        Map dynNodeInfo = null;
        if (null != processInstance && null != (variable = processInstance.getVariable(variableName))) {
            try {
                dynNodeInfo = (Map)SerializationUtils.fromJsonString((String)variable.toString(), Map.class);
            }
            catch (Exception e) {
                log.error(WfUtils.getExceptionStacktrace(e));
            }
        }
        return dynNodeInfo;
    }

    public static boolean matchCloseCondition(CommandContext commandContext, Long processInstanceId) {
        ExecutionEntity proInstance;
        Process process = ProcessDefinitionUtil.getProcessByProcInstId(processInstanceId);
        if (process != null && process.getCloseCondition() != null && (proInstance = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(processInstanceId)) != null && ModelType.BizFlow.name().equalsIgnoreCase(proInstance.getProcessType())) {
            String key = String.format("closeProcess-%s", processInstanceId);
            boolean ret = ConditionUtil.hasTrueCondition(process.getCloseCondition(), (VariableScope)proInstance, key);
            log.debug(String.format("proinstance[%s] match close condition!", processInstanceId));
            return ret;
        }
        return false;
    }
}

