/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.converter.BpmnJsonConverter;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandConfig;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.CommandExecutor;
import kd.bos.workflow.engine.impl.interceptor.DefaultCommandContextCloseListener;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.DynamicResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.DynamicResourceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.condition.ConditionUtil;

public class DynamicProcessDefinitionHelper {
    private static Log logger = LogFactory.getLog(DynamicProcessDefinitionHelper.class);

    public static BpmnModel getBpmnModel(String modelJson) {
        BpmnModel bpmnModel = null;
        try {
            JsonNode jsonNode = new ObjectMapper().readTree(modelJson);
            bpmnModel = new BpmnJsonConverter().convertToBpmnModel(jsonNode);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return bpmnModel;
    }

    public void deleteSequenceFlow(Long processDefinitionId, final Long processInstanceId, DynamicResourceEntity dynamicResource, String deleteReason) {
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(processDefinitionId, processInstanceId);
        BpmnModel newBpmnModel = bpmnModel.clone();
        SequenceFlow flow = newBpmnModel.getMainProcess().findFlowElementsOfTypeAndId(SequenceFlow.class, dynamicResource.getActivityId(), false);
        if (flow == null) {
            return;
        }
        FlowNode source = (FlowNode)flow.getSourceFlowElement();
        for (SequenceFlow sequenceFlow : source.getOutgoingFlows()) {
            if (!sequenceFlow.getId().equals(flow.getId())) continue;
            source.getOutgoingFlows().remove(sequenceFlow);
            break;
        }
        FlowNode target = (FlowNode)flow.getTargetFlowElement();
        for (SequenceFlow in : target.getIncomingFlows()) {
            if (!in.getId().equals(flow.getId())) continue;
            target.getIncomingFlows().remove(in);
            break;
        }
        Process process = newBpmnModel.getMainProcess();
        process.getFlowElementList().remove(flow);
        process.getFlowElementMap().remove(flow.getId());
        process.addFlowElementToMap(source);
        process.addFlowElementToMap(target);
        newBpmnModel.removeFlowGraphicInfoList(dynamicResource.getActivityId());
        DynamicResourceEntityManager dynamicResourceEntityManager = Context.getCommandContext().getProcessEngineConfiguration().getDynamicResourceEntityManager();
        dynamicResourceEntityManager.delete(dynamicResource, deleteReason, false);
        CommandContext commandContext = Context.getCommandContext();
        ExecutionEntity entity = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(processInstanceId);
        entity.setModifyDate(Context.getCommandContext().getProcessEngineConfiguration().getClock().getCurrentTime());
        commandContext.getExecutionEntityManager().update(entity);
        this.clearCacheAndReload(processInstanceId, commandContext);
        commandContext.addCloseListener(new DefaultCommandContextCloseListener(""){

            @Override
            public void closed(CommandContext commandContext) {
                CommandExecutor commandExecutor = commandContext.getProcessEngineConfiguration().getCommandExecutor();
                CommandConfig commandConfig = commandExecutor.getDefaultConfig().transactionRequiresNew();
                commandExecutor.execute(commandConfig, new Command<Void>(){

                    @Override
                    public Void execute(CommandContext commandContext) {
                        DynamicProcessDefinitionHelper.this.clearCacheAndReload(processInstanceId, commandContext);
                        return null;
                    }
                });
            }
        });
    }

    private void clearCacheAndReload(Long processInstanceId, CommandContext commandContext) {
        WfCacheHelper.removeCachedDynamicProcessInstance(processInstanceId);
        commandContext.getDeploymentManager().getProcessDefinitionCache().remove(processInstanceId);
        ProcessDefinitionUtil.getBpmnModel(null, processInstanceId);
    }

    public static List<Map<String, Object>> filterProcessByCondition(List<Map<String, Object>> processDefList, VariableScope scope, String operation, String entityNumber) {
        ArrayList<Map<String, Object>> matchConditionProcesses = new ArrayList<Map<String, Object>>();
        if (processDefList != null && processDefList.size() > 0) {
            Iterator<Map<String, Object>> iter = processDefList.iterator();
            String key = "";
            while (iter.hasNext()) {
                Map<String, Object> obj = iter.next();
                String condition = (String)obj.get("startcondition");
                if (!WfUtils.isNotEmpty(condition)) continue;
                key = ConditionUtil.getStartConInstKey(entityNumber, operation, (String)obj.get("number"));
                boolean match = ConditionUtil.hasTrueCondition(condition, scope, key);
                if (!match) {
                    iter.remove();
                    continue;
                }
                matchConditionProcesses.add(obj);
                break;
            }
        }
        if (matchConditionProcesses.isEmpty()) {
            return processDefList;
        }
        return matchConditionProcesses;
    }
}

