/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.bpmn.deployer.BpmnDeploymentHelper;
import kd.bos.workflow.engine.impl.bpmn.deployer.ProcessOperation;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.deploy.DeploymentCache;
import kd.bos.workflow.engine.impl.persistence.deploy.ProcessDefinitionCacheEntry;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionInfoEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionInfoEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionInfoEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.scheme.model.NodeInfo;
import kd.bos.workflow.engine.impl.scheme.model.ProcessDiffResult;

public class DynamicSchemeUtil {
    public static final String UPDATED_BY_PARENT = "updated_by_parent";
    private static Log log = LogFactory.getLog(DynamicSchemeUtil.class);

    private DynamicSchemeUtil() {
    }

    public static String getDefaultSchemeNumber(String key, String version) {
        return String.format("%s_%s_scheme", key, version);
    }

    public static String getSynchronizeSchemeNumber(CommandContext commandContext, String oriNumber) {
        String number = null;
        number = !oriNumber.matches("((^[\\w]+)_sync)\\d*$") ? String.format("%s%s", oriNumber, "_sync") : oriNumber.replaceFirst("((^[\\w]+)_sync)\\d*$", "$1");
        return DynamicSchemeUtil.getUniqueNumber(commandContext, number);
    }

    public static String getImportedSchemeNumber(CommandContext commandContext, String oriNumber) {
        return DynamicSchemeUtil.getUniqueNumber(commandContext, oriNumber);
    }

    private static String getUniqueNumber(CommandContext commandContext, String number) {
        String newNumber = null;
        DynamicConfigSchemeEntityManager schemeManager = commandContext.getDynamicConfigSchemeEntityManager();
        QFilter[] filters = new QFilter[]{new QFilter("number", "like", (Object)(number + "%"))};
        long count = schemeManager.countByFilter("id", filters, true);
        if (count > 0L) {
            newNumber = String.format("%s%s", number, count);
        } else {
            return number;
        }
        while (DynamicSchemeUtil.isSchemeNumberExist(schemeManager, newNumber)) {
            newNumber = String.format("%s%s", number, ++count);
        }
        return newNumber;
    }

    private static boolean isSchemeNumberExist(DynamicConfigSchemeEntityManager schemeManager, String number) {
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)number)};
        return schemeManager.countByFilter("id", filters, true) > 0L;
    }

    public static List<ComboItem> getPreviousProcessItemsWithCustomScheme(String key) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT P.FID ID, P.FVERSION VERSION FROM T_WF_PROCDEF P ");
        sql.append("INNER JOIN T_WF_DYNCONFSCHEME S ON P.FID = S.FPROCDEFID ");
        sql.append("WHERE P.FKEY = ? AND S.FDEFAULT = '0' ");
        sql.append("GROUP BY S.FPROCDEFID, P.FID, P.FVERSION ");
        sql.append("ORDER BY FVERSION DESC");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        try (DataSet ds = DB.queryDataSet((String)"wf.engine.getPreviousProcessItemsWithCustomScheme", (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])new Object[]{key});){
            for (Row row : ds) {
                items.add(new ComboItem(new LocaleString(String.format(ResManager.loadKDString((String)"%s \u7248\u672c", (String)"DynamicSchemeUtil_1", (String)"bos-wf-engine", (Object[])new Object[0]), row.getString("VERSION"))), row.getString("ID")));
            }
        }
        log.debug("getPreviousProcessItemsWithCustomScheme: " + items.size());
        return items;
    }

    public static ProcessDiffResult diffProcessNodes(String json, String otherJson) {
        if (WfUtils.isEmpty(json) || WfUtils.isEmpty(otherJson)) {
            log.debug(String.format("\u6d41\u7a0bJson\u4e3a\u7a7a\uff0c\u4e0d\u505a\u6bd4\u8f83\uff01Json: %s  OtherJson: %s", json, otherJson));
            return null;
        }
        JSONObject process = JSON.parseObject((String)json);
        JSONObject otherProcess = JSON.parseObject((String)otherJson);
        return DynamicSchemeUtil.diffChildshapes(process, otherProcess);
    }

    private static ProcessDiffResult diffChildshapes(JSONObject cell, JSONObject otherCell) {
        Map<String, NodeInfo> nodeMap = DynamicSchemeUtil.getNodeMap(cell.getJSONArray("childShapes"));
        Map<String, NodeInfo> otherNodeMap = DynamicSchemeUtil.getNodeMap(otherCell.getJSONArray("childShapes"));
        Set<String> nodeIds = nodeMap.keySet();
        Set<String> otherNodeIds = otherNodeMap.keySet();
        ProcessDiffResult ret = new ProcessDiffResult();
        ArrayList<NodeInfo> addedNodes = new ArrayList<NodeInfo>();
        ArrayList<NodeInfo> removedNodes = new ArrayList<NodeInfo>();
        for (String id : Sets.difference(otherNodeIds, nodeIds)) {
            addedNodes.add(otherNodeMap.get(id));
        }
        for (String id : Sets.difference(nodeIds, otherNodeIds)) {
            removedNodes.add(nodeMap.get(id));
        }
        ret.setAddedNodes(addedNodes);
        ret.setRemovedNodes(removedNodes);
        return ret;
    }

    private static Map<String, NodeInfo> getNodeMap(JSONArray childShapes) {
        int size = childShapes.size();
        JSONObject shape = null;
        JSONObject properties = null;
        NodeInfo nodeInfo = null;
        JSONObject stencil = null;
        HashMap<String, NodeInfo> nodeMap = new HashMap<String, NodeInfo>(size);
        for (int i = 0; i < size; ++i) {
            shape = childShapes.getJSONObject(i);
            properties = shape.getJSONObject("properties");
            nodeInfo = new NodeInfo(properties.getString("number"), properties.getString("name"));
            stencil = shape.getJSONObject("stencil");
            if ("SequenceFlow".equals(stencil.getString("id"))) {
                nodeInfo.setEdge(true);
            }
            nodeMap.put(properties.getString("itemId"), nodeInfo);
        }
        return nodeMap;
    }

    public static void disposeOperationCache(CommandContext commandContext, DynamicConfigSchemeEntity scheme, BpmnModel model) {
        DynamicSchemeUtil.disposeOperationCache(commandContext, scheme.getProcDefId(), model, scheme.isAcquiescence());
    }

    public static void disposeOperationCache(CommandContext commandContext, Long procDefId, BpmnModel model, boolean clear) {
        if (model != null) {
            List<ProcessOperation> operations;
            log.debug(String.format("\u5904\u7406\u6d41\u7a0b\u5b9a\u4e49%s\u64cd\u4f5c\u7f13\u5b58\uff01", procDefId));
            QFilter[] filters = null;
            List entities = null;
            ArrayList<ProcessOperation> deletedOperations = new ArrayList<ProcessOperation>(16);
            ProcessDefinitionInfoEntityManager processDefinitionInfoManager = commandContext.getProcessDefinitionInfoEntityManager();
            if (clear && !(entities = processDefinitionInfoManager.findByQueryFilters(filters = new QFilter[]{new QFilter("processDefinitionId", "=", (Object)procDefId)})).isEmpty()) {
                for (ProcessDefinitionInfoEntity entity : entities) {
                    deletedOperations.add(new ProcessOperation(null, entity.getOperation(), entity.getEntityNumber()));
                    processDefinitionInfoManager.delete(entity);
                }
            }
            if (!(operations = new BpmnDeploymentHelper().getAllProcessOperations(model)).isEmpty()) {
                List<String> exisOps = processDefinitionInfoManager.findProcessDefinitionInfos(procDefId);
                for (ProcessOperation operation : operations) {
                    String op = String.format("%s-%s", operation.getEntityNumber(), operation.getOp());
                    if (exisOps.contains(op)) continue;
                    processDefinitionInfoManager.insert(DynamicSchemeUtil.getProcessDefinitionInfoEntity(operation.getElement(), procDefId, operation.getOp(), operation.getEntityNumber()));
                }
            }
            operations.addAll(deletedOperations);
            if (!operations.isEmpty()) {
                ProcessDefinitionEntity def = (ProcessDefinitionEntity)commandContext.getProcessDefinitionEntityManager().findById(procDefId, "entrabill");
                WfCacheHelper.updateProcessDefWhenStateChange(commandContext, def.getEntraBill(), operations);
            }
        } else {
            log.warn(String.format("model[%s]\u672a\u627e\u5230\u6a21\u578b\u4fe1\u606f", procDefId));
        }
    }

    private static ProcessDefinitionInfoEntity getProcessDefinitionInfoEntity(BaseElement element, Long procDefId, String operation, String entityNumber) {
        ProcessDefinitionInfoEntityImpl infoEntityImpl = new ProcessDefinitionInfoEntityImpl();
        infoEntityImpl.setActId(element == null ? null : element.getId());
        infoEntityImpl.setEntityNumber(entityNumber);
        infoEntityImpl.setOperation(operation);
        infoEntityImpl.setProcessDefinitionId(procDefId);
        return infoEntityImpl;
    }

    public static void disposeCache(CommandContext commandContext, DynamicConfigSchemeEntity scheme) {
        String sql = "SELECT E.FID FROM T_WF_DYNRESOURCE D INNER JOIN T_WF_EXECUTION E ON E.FID = D.FPROCINSTID WHERE E.FSCHEMEID = ?;";
        HashSet<Long> ids = new HashSet<Long>();
        try (DataSet ds = DB.queryDataSet((String)"wf.engine.queryDynamicProcessBySchemeId", (DBRoute)DBRoute.workflow, (String)sql, (Object[])new Object[]{scheme.getId()});){
            for (Row row : ds) {
                ids.add(row.getLong("FID"));
            }
        }
        DeploymentCache<ProcessDefinitionCacheEntry> processDefinitionCache = commandContext.getProcessEngineConfiguration().getDeploymentManager().getProcessDefinitionCache();
        processDefinitionCache.remove(scheme.getId());
        HashSet<Long> processInstanceIds = new HashSet<Long>(10);
        if (!ids.isEmpty()) {
            log.debug(String.format("\u6e05\u9664\u5f15\u7528\u65b9\u6848%s[%s]\u7684\u6d41\u7a0b\u5b9e\u4f8b\u7f13\u5b58\uff01", scheme.getNumber(), scheme.getId()));
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", ids)};
            List executions = commandContext.getExecutionEntityManager().findByQueryFilters(filters, true);
            if (executions != null && !executions.isEmpty()) {
                for (ExecutionEntity execution : executions) {
                    commandContext.getExecutionEntityManager().update(execution, false);
                    processInstanceIds.add(execution.getProcessInstanceId());
                }
            }
        }
        log.debug(String.format("--\u79fb\u9664\u6d41\u7a0b\u5b9e\u4f8b %s \u7684\u7f13\u5b58\uff1a", processInstanceIds));
        processDefinitionCache.remove(processInstanceIds);
        if (scheme.isAcquiescence()) {
            log.debug(String.format("--\u79fb\u9664\u6d41\u7a0b\u5b9a\u4e49 %s \u7684\u7f13\u5b58\uff1a", scheme.getProcDefId()));
            processDefinitionCache.remove(scheme.getProcDefId());
            ProcessDefinitionEntity entity = (ProcessDefinitionEntity)commandContext.getProcessDefinitionEntityManager().findById(scheme.getProcDefId());
            commandContext.getProcessDefinitionEntityManager().update(entity);
        }
        WfCacheHelper.removeSchemeMultiLangDatas(scheme.getId());
    }
}

