/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.converter.util.ModelConfigUtil;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.bpmn.helper.nodetemplate.NodeTemplateExtAttrEntity;
import kd.bos.workflow.engine.impl.bpmn.helper.nodetemplate.NodeTemplateUtil;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ProcessCategoryEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceRelationEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateCategoryEntityConstants;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.repository.Model;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import org.apache.commons.lang.math.NumberUtils;

public class ExtractMultiLanguageWordsUtil {
    private static Log logger = LogFactory.getLog(ExtractMultiLanguageWordsUtil.class);
    private static final List<String> BlackMultiLanguageProp = new ArrayList<String>();
    private static final Map<String, List<String>> multiLanguageProp = new HashMap<String, List<String>>();
    private static final List<String> DiagramProperties = new ArrayList<String>();
    private static final List<String> SequenceFlowProperties = new ArrayList<String>();
    private static final List<String> StartSignalEventProperties = new ArrayList<String>();
    private static final List<String> UserTaskProperties = new ArrayList<String>();
    private static final List<String> EndTerminateEventProperties = new ArrayList<String>();
    private static final List<String> EndNoneEventProperties = new ArrayList<String>();
    private static final List<String> AuditTaskProperties = new ArrayList<String>();
    private static final List<String> NotifyTaskProperties = new ArrayList<String>();
    private static final List<String> YunzhijiaTaskProperties = new ArrayList<String>();
    private static final List<String> AutoTaskProperties = new ArrayList<String>();
    private static final List<String> RPATaskProperties = new ArrayList<String>();
    private static final List<String> WaitTaskProperties = new ArrayList<String>();
    private static final List<String> CallActivityProperties = new ArrayList<String>();
    private static final List<String> CompensateTaskProperties = new ArrayList<String>();
    private static final List<String> CompensateEventProperties = new ArrayList<String>();
    private static final List<String> BillTaskProperties = new ArrayList<String>();
    private static final String FILE_SUFFIX = ".sql";
    private static final String EXTATTRGROUP = "extAttrGroup";
    private static final String EXT_GROUPNAME = "groupName";
    private static final String EXT_ATTRIBUTETYPE = "attributeType";
    private static final String EXT_EXTATTRVALUE = "extAttrValue";
    private static final String EXT_ATTRIBUTENUMBER = "attributeNumber";
    private static final String PROCESSID = "processId";
    private static final String VERSION = "version";
    private static final String RESOURCEID = "resourceId";
    private static final String MULLANGINFO = "mulLangInfo";
    private static final String CHILDSHAPES = "childShapes";
    private static final String LANG = "lang";
    private static final String NAME = "name";
    private static final String CATEGORY_ID = "categoryId";
    private static final String CATEGORY_NAME = "categoryName";
    private static final String CATEGORY_PARENT_ID = "categoryParentId";
    private static final String CHILDREN_ARRAY = "childrenArray";
    private static final String PARENT_ID = "parent.id";
    private static final String NUMBER = "number";
    private static final String SQL_S = "sqls";
    private static final String FILE_NAME = "fileName";
    private static final String TWO_FIELD_TPL = "{0},{1}";
    private static final char NEWLINE_CHAR = '\n';

    private static synchronized void initMultiLanguageProp() {
        DiagramProperties.add(NAME);
        DiagramProperties.add("documentation");
        DiagramProperties.add("entrabillname");
        DiagramProperties.add("flowelementlist\\.\\[.+?\\]\\.name");
        DiagramProperties.add("flowelementlist\\.\\[.+?\\]\\.documentation");
        DiagramProperties.add("flowelementmap\\.name");
        DiagramProperties.add("flowelementmap\\.documentation");
        DiagramProperties.add("variablegroup\\.variables\\.\\[.+?\\]\\.description");
        DiagramProperties.add("variablegroup\\.variables\\.\\[.+?\\]\\.name");
        DiagramProperties.add("variablegroup\\.variables\\.\\[.+?\\]\\.grouprealvalue\\.showinfo");
        DiagramProperties.add("variablegroup\\.variables\\.\\[.+?\\]\\.grouprealvalue\\.settinginfo");
        DiagramProperties.add("macros\\.\\[.+?\\]\\.description");
        DiagramProperties.add("startupcondrule\\.showtext");
        DiagramProperties.add("startupcondrule\\.description");
        DiagramProperties.add("billexceptionop\\.\\[.+?\\]\\.opername");
        multiLanguageProp.put("BPMNDiagram", DiagramProperties);
        UserTaskProperties.add(NAME);
        UserTaskProperties.add("entityname");
        UserTaskProperties.add("documentation");
        UserTaskProperties.add("entityname\\.opername");
        UserTaskProperties.add("subject\\.customsubject");
        UserTaskProperties.add("subject\\.\\[.+?\\]\\.customsubject");
        UserTaskProperties.add("decisionoptions\\.\\[.+?\\]\\.name");
        UserTaskProperties.add("decisionoptions\\.\\[.+?\\]\\.rejectoptions\\.\\[.+?\\]\\.name");
        UserTaskProperties.add("decisionoptions\\.\\[.+?\\]\\.rejectoptions\\.\\[.+?\\]\\.documentation");
        UserTaskProperties.add("expiremodel\\.timecontrols\\.\\[.+?\\]\\.operation\\.name");
        UserTaskProperties.add("expiremodel\\.timecontrols\\.\\[.+?\\]\\.operation\\.config\\.processhandler");
        UserTaskProperties.add("expiremodel\\.timecontrols\\.\\[.+?\\]\\.operation\\.config\\.autoopinionwhenmatch");
        UserTaskProperties.add("expiremodel\\.timecontrols\\.\\[.+?\\]\\.operation\\.config\\.valueshowtext");
        UserTaskProperties.add("expiremodel\\.timecontrols\\.\\[.+?\\]\\.operation\\.config\\.value");
        UserTaskProperties.add("expiremodel\\.timecontrols\\.\\[.+?\\]\\.operation\\.config\\.opinion");
        UserTaskProperties.add("skipcondition\\.showtext");
        UserTaskProperties.add("skipcondition\\.description");
        UserTaskProperties.add("inmsg\\.\\[.+?\\]\\.receiver\\.\\[.+?\\]\\.valueshowtext");
        UserTaskProperties.add("inmsg\\.\\[.+?\\]\\.receiver\\.\\[.+?\\]\\.value");
        UserTaskProperties.add("outmsg\\.\\[.+?\\]\\.receiver\\.\\[.+?\\]\\.valueshowtext");
        UserTaskProperties.add("outmsg\\.\\[.+?\\]\\.receiver\\.\\[.+?\\]\\.value");
        UserTaskProperties.add("circulatemodel\\.circulate\\.suggestion");
        UserTaskProperties.add("circulatemodel\\.circulate\\.participant\\.\\[.+?\\]\\.participant_showvaluepre");
        UserTaskProperties.add("circulatemodel\\.circulate\\.participant\\.\\[.+?\\]\\.valueshowtext");
        UserTaskProperties.add("circulatemodel\\.circulate\\.participant\\.\\[.+?\\]\\.condruleshowtext");
        UserTaskProperties.add("circulatemodel\\.circulate\\.participant\\.\\[.+?\\]\\.value");
        UserTaskProperties.add("autocoordinatemodel\\.autocoordinate\\.suggestion");
        UserTaskProperties.add("autocoordinatemodel\\.autocoordinate\\.participant\\.\\[.+?\\]\\.participant_showvaluepre");
        UserTaskProperties.add("autocoordinatemodel\\.autocoordinate\\.participant\\.\\[.+?\\]\\.valueshowtext");
        UserTaskProperties.add("autocoordinatemodel\\.autocoordinate\\.participant\\.\\[.+?\\]\\.condruleshowtext");
        UserTaskProperties.add("autocoordinatemodel\\.autocoordinate\\.participant\\.\\[.+?\\]\\.value");
        UserTaskProperties.add("participant\\.participant\\.\\[.+?\\]\\.value");
        UserTaskProperties.add("participant\\.participant\\.\\[.+?\\]\\.valueshowtext");
        UserTaskProperties.add("participant\\.displayinfo");
        UserTaskProperties.add("participant\\.participant\\.\\[.+?\\]\\.referencePersonShowValue");
        UserTaskProperties.add("participant\\.participant\\.\\[.+?\\]\\.referencePersonShowValue");
        UserTaskProperties.add("billsetting\\.pageparameter\\.\\[.+?\\]\\.parametername");
        multiLanguageProp.put("UserTask", UserTaskProperties);
        AuditTaskProperties.add(NAME);
        AuditTaskProperties.add("entityname");
        AuditTaskProperties.add("documentation");
        AuditTaskProperties.add("entityname\\.opername");
        AuditTaskProperties.add("subject\\.customsubject");
        AuditTaskProperties.add("subject\\.\\[.+?\\]\\.customsubject");
        AuditTaskProperties.add("decisionoptions\\.\\[.+?\\]\\.name");
        AuditTaskProperties.add("decisionoptions\\.\\[.+?\\]\\.rejectoptions\\.\\[.+?\\]\\.name");
        AuditTaskProperties.add("decisionoptions\\.\\[.+?\\]\\.rejectoptions\\.\\[.+?\\]\\.documentation");
        AuditTaskProperties.add("expiremodel\\.timecontrols\\.\\[.+?\\]\\.operation\\.name");
        AuditTaskProperties.add("expiremodel\\.timecontrols\\.\\[.+?\\]\\.operation\\.config\\.processhandler");
        AuditTaskProperties.add("expiremodel\\.timecontrols\\.\\[.+?\\]\\.operation\\.config\\.autoopinionwhenmatch");
        AuditTaskProperties.add("expiremodel\\.timecontrols\\.\\[.+?\\]\\.operation\\.config\\.valueshowtext");
        AuditTaskProperties.add("expiremodel\\.timecontrols\\.\\[.+?\\]\\.operation\\.config\\.value");
        AuditTaskProperties.add("expiremodel\\.timecontrols\\.\\[.+?\\]\\.operation\\.config\\.opinion");
        AuditTaskProperties.add("skipcondition\\.showtext");
        AuditTaskProperties.add("skipcondition\\.description");
        AuditTaskProperties.add("inmsg\\.\\[.+?\\]\\.receiver\\.\\[.+?\\]\\.valueshowtext");
        AuditTaskProperties.add("inmsg\\.\\[.+?\\]\\.receiver\\.\\[.+?\\]\\.value");
        AuditTaskProperties.add("outmsg\\.\\[.+?\\]\\.receiver\\.\\[.+?\\]\\.valueshowtext");
        AuditTaskProperties.add("outmsg\\.\\[.+?\\]\\.receiver\\.\\[.+?\\]\\.value");
        AuditTaskProperties.add("circulatemodel\\.circulate\\.suggestion");
        AuditTaskProperties.add("circulatemodel\\.circulate\\.participant\\.\\[.+?\\]\\.participant_showvaluepre");
        AuditTaskProperties.add("circulatemodel\\.circulate\\.participant\\.\\[.+?\\]\\.valueshowtext");
        AuditTaskProperties.add("circulatemodel\\.circulate\\.participant\\.\\[.+?\\]\\.condruleshowtext");
        AuditTaskProperties.add("circulatemodel\\.circulate\\.participant\\.\\[.+?\\]\\.value");
        AuditTaskProperties.add("autocoordinatemodel\\.autocoordinate\\.suggestion");
        AuditTaskProperties.add("autocoordinatemodel\\.autocoordinate\\.participant\\.\\[.+?\\]\\.participant_showvaluepre");
        AuditTaskProperties.add("autocoordinatemodel\\.autocoordinate\\.participant\\.\\[.+?\\]\\.valueshowtext");
        AuditTaskProperties.add("autocoordinatemodel\\.autocoordinate\\.participant\\.\\[.+?\\]\\.condruleshowtext");
        AuditTaskProperties.add("autocoordinatemodel\\.autocoordinate\\.participant\\.\\[.+?\\]\\.value");
        AuditTaskProperties.add("participant\\.participant\\.\\[.+?\\]\\.value");
        AuditTaskProperties.add("participant\\.participant\\.\\[.+?\\]\\.valueshowtext");
        AuditTaskProperties.add("autoaudit\\.autoopinionwhenmatch");
        AuditTaskProperties.add("autoaudit\\.processhandler");
        AuditTaskProperties.add("auditpointmodel\\.auditpointtitle");
        AuditTaskProperties.add("auditpointmodel\\.auditpoints\\.\\[.+?\\]\\.displayname");
        AuditTaskProperties.add("auditpointmodel\\.auditpoints\\.\\[.+?\\]\\.errormessage");
        AuditTaskProperties.add("auditpointmodel\\.auditpoints\\.\\[.+?\\]\\.instruction");
        AuditTaskProperties.add("auditpointmodel\\.auditpoints\\.\\[.+?\\]\\.bizrule\\.expression");
        AuditTaskProperties.add("auditpointmodel\\.auditpoints\\.\\[.+?\\]\\.bizrule\\.expression\\.entryentity\\.\\[.+?\\]\\.value");
        AuditTaskProperties.add("auditcommentmodel\\.auditcomments\\.\\[.+?\\]\\.content");
        AuditTaskProperties.add("btnmodel\\.extendbtns\\.\\[.+?\\]\\.btnname");
        AuditTaskProperties.add("btnmodel\\.extendbtns\\.\\[.+?\\]\\.extbtn_operation");
        AuditTaskProperties.add("btnmodel\\.extendbtns\\.\\[.+?\\]\\.operationname");
        AuditTaskProperties.add("variablegroup\\.variables\\.\\[.+?\\]\\.description");
        AuditTaskProperties.add("participant\\.displayinfo");
        AuditTaskProperties.add("participant\\.participant\\.\\[.+?\\]\\.referencePersonShowValue");
        AuditTaskProperties.add("participant\\.participant\\.\\[.+?\\]\\.referencePersonShowValue");
        AuditTaskProperties.add("billsetting\\.pageparameter\\.\\[.+?\\]\\.parametername");
        AuditTaskProperties.add("customauditmsg");
        multiLanguageProp.put("AuditTask", AuditTaskProperties);
        AuditTaskProperties.add("advappschememodel\\.advappschemes\\.\\[.+?\\]\\.showtext");
        BillTaskProperties.add(NAME);
        BillTaskProperties.add("subject\\.\\[.+?\\]\\.customsubject");
        BillTaskProperties.add("outmsg\\.\\[.+?\\]\\.receiver\\.\\[.+?\\]\\.valueshowtext");
        BillTaskProperties.add("outmsg\\.\\[.+?\\]\\.receiver\\.\\[.+?\\]\\.value");
        BillTaskProperties.add("inmsg\\.\\[.+?\\]\\.receiver\\.\\[.+?\\]\\.valueshowtext");
        BillTaskProperties.add("inmsg\\.\\[.+?\\]\\.receiver\\.\\[.+?\\]\\.value");
        BillTaskProperties.add("decisionoptions\\.\\[.+?\\]\\.name");
        BillTaskProperties.add("decisionoptions\\.\\[.+?\\]\\.rejectoptions\\.\\[.+?\\]\\.name");
        BillTaskProperties.add("decisionoptions\\.\\[.+?\\]\\.rejectoptions\\.\\[.+?\\]\\.documentation");
        BillTaskProperties.add("expiremodel\\.timecontrols\\.\\[.+?\\]\\.operation\\.name");
        BillTaskProperties.add("expiremodel\\.timecontrols\\.\\[.+?\\]\\.operation\\.config\\.processhandler");
        BillTaskProperties.add("expiremodel\\.timecontrols\\.\\[.+?\\]\\.operation\\.config\\.autoopinionwhenmatch");
        BillTaskProperties.add("expiremodel\\.timecontrols\\.\\[.+?\\]\\.operation\\.config\\.valueshowtext");
        BillTaskProperties.add("expiremodel\\.timecontrols\\.\\[.+?\\]\\.operation\\.config\\.value");
        BillTaskProperties.add("expiremodel\\.timecontrols\\.\\[.+?\\]\\.operation\\.config\\.opinion");
        BillTaskProperties.add("billcloseconfig\\.waitactions\\.operations\\.\\[.+?\\]\\.name");
        BillTaskProperties.add("billcloseconfig\\.waitactions\\.closeevent\\.eventname");
        BillTaskProperties.add("billcloseconfig\\.waitactions\\.closeevent\\.eventparams\\.\\[.+?\\]\\.name");
        multiLanguageProp.put("BillTask", BillTaskProperties);
        YunzhijiaTaskProperties.add("rulescontent");
        YunzhijiaTaskProperties.add("customauditmsg");
        YunzhijiaTaskProperties.add(NAME);
        YunzhijiaTaskProperties.add("entityname");
        YunzhijiaTaskProperties.add("documentation");
        YunzhijiaTaskProperties.add("subject\\.customsubject");
        YunzhijiaTaskProperties.add("subject\\.\\[.+?\\]\\.customsubject");
        YunzhijiaTaskProperties.add("outmsg\\.\\[.+?\\]\\.receiver\\.\\[.+?\\]\\.description");
        YunzhijiaTaskProperties.add("outmsg\\.\\[.+?\\]\\.receiver\\.\\[.+?\\]\\.value");
        YunzhijiaTaskProperties.add("inmsg\\.\\[.+?\\]\\.receiver\\.\\[.+?\\]\\.valueshowtext");
        YunzhijiaTaskProperties.add("inmsg\\.\\[.+?\\]\\.receiver\\.\\[.+?\\]\\.value");
        YunzhijiaTaskProperties.add("decisionoptions\\.\\[.+?\\]\\.name");
        YunzhijiaTaskProperties.add("decisionoptions\\.\\[.+?\\]\\.rejectoptions\\.\\[.+?\\]\\.name");
        YunzhijiaTaskProperties.add("decisionoptions\\.\\[.+?\\]\\.rejectoptions\\.\\[.+?\\]\\.documentation");
        YunzhijiaTaskProperties.add("expiremodel\\.timecontrols\\.\\[.+?\\]\\.operation\\.name");
        YunzhijiaTaskProperties.add("expiremodel\\.timecontrols\\.\\[.+?\\]\\.operation\\.config\\.processhandler");
        YunzhijiaTaskProperties.add("expiremodel\\.timecontrols\\.\\[.+?\\]\\.operation\\.config\\.autoopinionwhenmatch");
        YunzhijiaTaskProperties.add("expiremodel\\.timecontrols\\.\\[.+?\\]\\.operation\\.config\\.valueshowtext");
        YunzhijiaTaskProperties.add("expiremodel\\.timecontrols\\.\\[.+?\\]\\.operation\\.config\\.value");
        YunzhijiaTaskProperties.add("expiremodel\\.timecontrols\\.\\[.+?\\]\\.operation\\.config\\.opinion");
        YunzhijiaTaskProperties.add("skipcondition\\.showtext");
        YunzhijiaTaskProperties.add("skipcondition\\.description");
        YunzhijiaTaskProperties.add("circulatemodel\\.circulate\\.suggestion");
        YunzhijiaTaskProperties.add("circulatemodel\\.circulate\\.participant\\.\\[.+?\\]\\.participant_showvaluepre");
        YunzhijiaTaskProperties.add("circulatemodel\\.circulate\\.participant\\.\\[.+?\\]\\.valueshowtext");
        YunzhijiaTaskProperties.add("circulatemodel\\.circulate\\.participant\\.\\[.+?\\]\\.condruleshowtext");
        YunzhijiaTaskProperties.add("circulatemodel\\.circulate\\.participant\\.\\[.+?\\]\\.value");
        YunzhijiaTaskProperties.add("autocoordinatemodel\\.autocoordinate\\.suggestion");
        YunzhijiaTaskProperties.add("autocoordinatemodel\\.autocoordinate\\.participant\\.\\[.+?\\]\\.participant_showvaluepre");
        YunzhijiaTaskProperties.add("autocoordinatemodel\\.autocoordinate\\.participant\\.\\[.+?\\]\\.valueshowtext");
        YunzhijiaTaskProperties.add("autocoordinatemodel\\.autocoordinate\\.participant\\.\\[.+?\\]\\.condruleshowtext");
        YunzhijiaTaskProperties.add("autocoordinatemodel\\.autocoordinate\\.participant\\.\\[.+?\\]\\.value");
        YunzhijiaTaskProperties.add("participant\\.participant\\.\\[.+?\\]\\.value");
        YunzhijiaTaskProperties.add("participant\\.participant\\.\\[.+?\\]\\.valueshowtext");
        YunzhijiaTaskProperties.add("auditpointmodel\\.auditpointtitle");
        YunzhijiaTaskProperties.add("auditpointmodel\\.auditpoints\\.\\[.+?\\]\\.displayname");
        YunzhijiaTaskProperties.add("auditpointmodel\\.auditpoints\\.\\[.+?\\]\\.errormessage");
        YunzhijiaTaskProperties.add("auditpointmodel\\.auditpoints\\.\\[.+?\\]\\.instruction");
        YunzhijiaTaskProperties.add("auditpointmodel\\.auditpoints\\.\\[.+?\\]\\.bizrule\\.expression");
        YunzhijiaTaskProperties.add("auditpointmodel\\.auditpoints\\.\\[.+?\\]\\.bizrule\\.expression\\.entryentity\\.\\[.+?\\]\\.value");
        YunzhijiaTaskProperties.add("auditcommentmodel\\.auditcomments\\.\\[.+?\\]\\.content");
        YunzhijiaTaskProperties.add("btnmodel\\.extendbtns\\.\\[.+?\\]\\.btnname");
        YunzhijiaTaskProperties.add("btnmodel\\.extendbtns\\.\\[.+?\\]\\.extbtn_operation");
        YunzhijiaTaskProperties.add("btnmodel\\.extendbtns\\.\\[.+?\\]\\.operationname");
        YunzhijiaTaskProperties.add("variablegroup\\.variables\\.\\[.+?\\]\\.description");
        YunzhijiaTaskProperties.add("participant\\.displayinfo");
        YunzhijiaTaskProperties.add("billsetting\\.pageparameter\\.\\[.+?\\]\\.parametername");
        YunzhijiaTaskProperties.add("participant\\.participant\\.\\[.+?\\]\\.referencePersonShowValue");
        YunzhijiaTaskProperties.add("participant\\.participant\\.\\[.+?\\]\\.referencePersonShowValue");
        multiLanguageProp.put("YunzhijiaTask", YunzhijiaTaskProperties);
        AutoTaskProperties.add(NAME);
        AutoTaskProperties.add("service\\.entityname");
        AutoTaskProperties.add("documentation");
        AutoTaskProperties.add("outmsg\\.\\[.+?\\]\\.receiver\\.\\[.+?\\]\\.valueshowtext");
        AutoTaskProperties.add("outmsg\\.\\[.+?\\]\\.receiver\\.\\[.+?\\]\\.value");
        AutoTaskProperties.add("inmsg\\.\\[.+?\\]\\.receiver\\.\\[.+?\\]\\.valueshowtext");
        AutoTaskProperties.add("inmsg\\.\\[.+?\\]\\.receiver\\.\\[.+?\\]\\.value");
        multiLanguageProp.put("AutoTask", AutoTaskProperties);
        NotifyTaskProperties.add(NAME);
        NotifyTaskProperties.add("documentation");
        NotifyTaskProperties.add("outmsg\\.\\[.+?\\]\\.receiver\\.\\[.+?\\]\\.valueshowtext");
        NotifyTaskProperties.add("outmsg\\.\\[.+?\\]\\.receiver\\.\\[.+?\\]\\.value");
        NotifyTaskProperties.add("inmsg\\.\\[.+?\\]\\.receiver\\.\\[.+?\\]\\.valueshowtext");
        NotifyTaskProperties.add("inmsg\\.\\[.+?\\]\\.receiver\\.\\[.+?\\]\\.value");
        multiLanguageProp.put("NotifyTask", NotifyTaskProperties);
        WaitTaskProperties.add(NAME);
        WaitTaskProperties.add("documentation");
        WaitTaskProperties.add("outmsg\\.\\[.+?\\]\\.receiver\\.\\[.+?\\]\\.valueshowtext");
        WaitTaskProperties.add("outmsg\\.\\[.+?\\]\\.receiver\\.\\[.+?\\]\\.value");
        WaitTaskProperties.add("inmsg\\.\\[.+?\\]\\.receiver\\.\\[.+?\\]\\.valueshowtext");
        WaitTaskProperties.add("inmsg\\.\\[.+?\\]\\.receiver\\.\\[.+?\\]\\.value");
        WaitTaskProperties.add("condition\\.showtext");
        WaitTaskProperties.add("condition\\.description");
        multiLanguageProp.put("WaitTask", WaitTaskProperties);
        RPATaskProperties.add(NAME);
        RPATaskProperties.add("documentation");
        RPATaskProperties.add("entityname");
        RPATaskProperties.add("rpaprocname");
        RPATaskProperties.add("rparobotalias");
        RPATaskProperties.add("rpaprocparams\\.\\[.+?\\]\\.name");
        RPATaskProperties.add("rpaprocparams\\.\\[.+?\\]\\.exprtext");
        multiLanguageProp.put("RPATask", RPATaskProperties);
        StartSignalEventProperties.add(NAME);
        StartSignalEventProperties.add("documentation");
        multiLanguageProp.put("StartSignalEvent", StartSignalEventProperties);
        CallActivityProperties.add(NAME);
        CallActivityProperties.add("callprocessname");
        CallActivityProperties.add("addresskeyname");
        CallActivityProperties.add("inparameters\\.\\[.+?\\]\\.paramname");
        CallActivityProperties.add("inparameters\\.\\[.+?\\]\\.desc");
        CallActivityProperties.add("outparameters\\.\\[.+?\\]\\.paramname");
        CallActivityProperties.add("outparameters\\.\\[.+?\\]\\.desc");
        multiLanguageProp.put("CallActivity", CallActivityProperties);
        CompensateTaskProperties.add(NAME);
        CompensateTaskProperties.add("documentation");
        CompensateTaskProperties.add("service\\.entityname");
        multiLanguageProp.put("CompensateTask", CompensateTaskProperties);
        CompensateEventProperties.add(NAME);
        CompensateEventProperties.add("documentation");
        CompensateEventProperties.add("backset\\.\\[.+?\\]\\.backnodename");
        multiLanguageProp.put("BoundaryCompensateEvent", CompensateEventProperties);
        EndNoneEventProperties.add(NAME);
        EndNoneEventProperties.add("documentation");
        multiLanguageProp.put("EndNoneEvent", EndNoneEventProperties);
        EndTerminateEventProperties.add(NAME);
        EndTerminateEventProperties.add("documentation");
        multiLanguageProp.put("EndNoneEvent", EndTerminateEventProperties);
        SequenceFlowProperties.add(NAME);
        multiLanguageProp.put("SequenceFlow", SequenceFlowProperties);
        ExtractMultiLanguageWordsUtil.putExtendedModelMultiLangProps();
    }

    private static synchronized void initBlackMultiLanguageProp() {
        BlackMultiLanguageProp.add("participant\\.participant\\.\\[\\d+\\]\\.condrule\\.entryentity\\.\\[\\d+\\]\\.value");
        BlackMultiLanguageProp.add("circulatemodel\\.circulate\\.participant\\.\\[\\d+\\]\\.condrule\\.entryentity\\.\\[\\d+\\]\\.value");
        BlackMultiLanguageProp.add("autocoordinatemodel\\.autocoordinate\\.participant\\.\\[\\d+\\]\\.condrule\\.entryentity\\.\\[\\d+\\]\\.value");
    }

    public static List<Long> getWorkflowMultiLanguageIds(String applicationId) {
        QFilter qFilterDeployId;
        QFilter qFilterAppId;
        if (WfUtils.isEmpty(applicationId)) {
            ExtractMultiLanguageWordsUtil.printAppIdEmptyLog();
            return Collections.emptyList();
        }
        HashSet<Long> resourceIds = new HashSet<Long>();
        ArrayList<Long> newResourceIds = new ArrayList<Long>();
        RepositoryService repositoryService = ExtractMultiLanguageWordsUtil.getRepositoryService();
        List<ModelEntity> models = repositoryService.findModelsByFilters(new QFilter[]{qFilterAppId = new QFilter("applicationid", "=", (Object)applicationId), qFilterDeployId = new QFilter("deploymentid", "!=", (Object)0)});
        if (models == null || models.isEmpty()) {
            ExtractMultiLanguageWordsUtil.printEntityQueryByAppIdEmptyLog("ModelEntityFilterByDeployIdNot0");
            return Collections.emptyList();
        }
        for (ModelEntity model : models) {
            QFilter qFilterEnable;
            QFilter qFilterModelId = new QFilter("modelid", "=", (Object)model.getId());
            List processDefinitions = repositoryService.findEntitiesByFilters("wf_processdefinition", new QFilter[]{qFilterModelId, qFilterEnable = new QFilter("enable", "=", (Object)"enable")});
            if (processDefinitions == null || processDefinitions.isEmpty()) continue;
            for (ProcessDefinitionEntity processDefinitionEntity : processDefinitions) {
                List<DynamicConfigSchemeEntity> schemes = repositoryService.getDynamicConfigSchemeEntitysByProcessdefineId(processDefinitionEntity.getId());
                for (DynamicConfigSchemeEntity scheme : schemes) {
                    resourceIds.add(scheme.getJsonResourceId());
                }
                resourceIds.add(processDefinitionEntity.getResourceId());
            }
            resourceIds.add(model.getBPMNXMLID());
        }
        newResourceIds.addAll(resourceIds);
        return newResourceIds;
    }

    public static List<Long> getWorkflowModelMultiLanguageIds(String applicationId) {
        if (WfUtils.isEmpty(applicationId)) {
            ExtractMultiLanguageWordsUtil.printAppIdEmptyLog();
            return Collections.emptyList();
        }
        RepositoryService repositoryService = ExtractMultiLanguageWordsUtil.getRepositoryService();
        QFilter qFilterAppId = new QFilter("applicationid", "=", (Object)applicationId);
        QFilter qFilterEnable = new QFilter("discard", "=", (Object)Boolean.FALSE);
        List<ModelEntity> models = repositoryService.findModelsByFilters(new QFilter[]{qFilterAppId, qFilterEnable});
        if (WfUtils.isEmptyForCollection(models)) {
            ExtractMultiLanguageWordsUtil.printEntityQueryByAppIdEmptyLog("ModelEntity");
            return Collections.emptyList();
        }
        return models.stream().map(ModelEntity::getBPMNXMLID).distinct().collect(Collectors.toList());
    }

    public static List<Map<String, Object>> getWorkflowTemplateMultiLanguageIds(Long categoryId) {
        if (WfUtils.isEmpty(categoryId)) {
            ExtractMultiLanguageWordsUtil.printAppIdEmptyLog();
            return Collections.emptyList();
        }
        RepositoryService repositoryService = ExtractMultiLanguageWordsUtil.getRepositoryService();
        QFilter qFilter = new QFilter("category", "=", (Object)categoryId);
        String fields = MessageFormat.format(TWO_FIELD_TPL, "resourceid", NUMBER);
        List<Entity> entitiesByFilters = repositoryService.findEntitiesByFilters("wf_proctemplate", new QFilter[]{qFilter}, fields, null);
        if (WfUtils.isEmptyForCollection(entitiesByFilters)) {
            ExtractMultiLanguageWordsUtil.printEntityQueryByAppIdEmptyLog("ProcTemplateEntity");
            return Collections.emptyList();
        }
        ArrayList res = Lists.newArrayListWithExpectedSize((int)entitiesByFilters.size());
        entitiesByFilters.forEach(t -> {
            DynamicObject dynamicObject = t.getDynamicObject();
            if (WfUtils.isNotNullObject(dynamicObject)) {
                HashMap node = Maps.newHashMapWithExpectedSize((int)org.apache.commons.lang3.math.NumberUtils.INTEGER_TWO);
                node.put("id", dynamicObject.getLong("resourceid"));
                node.put(NUMBER, dynamicObject.getString(NUMBER));
                res.add(node);
            }
        });
        return res;
    }

    public static List<Map<String, Object>> getWorkflowResourceIdsByCategoryId(Long categoryId) {
        if (WfUtils.isEmpty(categoryId)) {
            ExtractMultiLanguageWordsUtil.printCategoryIdNullLog();
            return Collections.emptyList();
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(16);
        List processDefinitions = null;
        RepositoryService repositoryService = ExtractMultiLanguageWordsUtil.getRepositoryService();
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"enable");
        QFilter filter = new QFilter("template", "!=", (Object)"freeflowdefaulttpl").and(new QFilter(VERSION, "!=", (Object)"testing"));
        if (ExtractMultiLanguageWordsUtil.getRootId().equals(categoryId)) {
            processDefinitions = repositoryService.findEntitiesByFilters("wf_processdefinition", new QFilter[]{qFilterEnable, filter});
        } else {
            QFilter qFilterCategoryId = null;
            List<ProcessCategoryEntity> processCategoryEntities = repositoryService.getProcateByParentId(categoryId);
            if (processCategoryEntities != null && !processCategoryEntities.isEmpty()) {
                HashSet<Long> ids = new HashSet<Long>(processCategoryEntities.size() + 1);
                for (ProcessCategoryEntity processCategoryEntity : processCategoryEntities) {
                    ids.add(processCategoryEntity.getId());
                }
                ids.add(categoryId);
                qFilterCategoryId = new QFilter("categoryid", "in", ids);
            } else {
                qFilterCategoryId = new QFilter("categoryid", "=", (Object)categoryId);
            }
            processDefinitions = repositoryService.findEntitiesByFilters("wf_processdefinition", new QFilter[]{qFilterEnable, filter, qFilterCategoryId});
        }
        if (processDefinitions == null || processDefinitions.isEmpty()) {
            ExtractMultiLanguageWordsUtil.printCategoryIdQueryEmptyLog();
            return Collections.emptyList();
        }
        HashMap<Long, ProcessDefinitionEntity> mapData = new HashMap<Long, ProcessDefinitionEntity>(processDefinitions.size());
        for (ProcessDefinitionEntity processDefinitionEntity : processDefinitions) {
            mapData.put(processDefinitionEntity.getId(), processDefinitionEntity);
        }
        if (!mapData.isEmpty()) {
            QFilter qFilter = new QFilter("processdefinitionid", "in", mapData.keySet());
            List schemes = repositoryService.findEntitiesByFilters("wf_processdynamicconfig", new QFilter[]{qFilter});
            for (DynamicConfigSchemeEntity scheme : schemes) {
                Long schemeResourceId = scheme.getJsonResourceId();
                ProcessDefinitionEntity processDefinitionEntity = (ProcessDefinitionEntity)mapData.get(scheme.getProcDefId());
                ILocaleString name = processDefinitionEntity.getName();
                String number = processDefinitionEntity.getKey();
                if (!scheme.isAcquiescence()) {
                    name = scheme.getName();
                    number = scheme.getNumber();
                }
                HashMap<String, Object> mapVal = new HashMap<String, Object>();
                mapVal.put(RESOURCEID, schemeResourceId);
                mapVal.put(NAME, name);
                mapVal.put(NUMBER, number);
                mapVal.put(VERSION, processDefinitionEntity.getVersion());
                result.add(mapVal);
            }
        }
        return result;
    }

    public static List<Map<String, Object>> getWorkflowModelResourceIdsByCategoryId(Long categoryId) {
        List<ModelEntity> modelsByFilters;
        if (WfUtils.isEmpty(categoryId)) {
            ExtractMultiLanguageWordsUtil.printCategoryIdNullLog();
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        RepositoryService repositoryService = ExtractMultiLanguageWordsUtil.getRepositoryService();
        QFilter qFilterEnable = new QFilter("discard", "=", (Object)Boolean.FALSE);
        if (Objects.equals(ExtractMultiLanguageWordsUtil.getRootId(), categoryId)) {
            modelsByFilters = repositoryService.findModelsByFilters(new QFilter[]{qFilterEnable});
        } else {
            QFilter qFilterCategoryId;
            List<ProcessCategoryEntity> processCategoryEntities = repositoryService.getProcateByParentId(categoryId);
            if (WfUtils.isEmptyForCollection(processCategoryEntities)) {
                qFilterCategoryId = new QFilter("categoryid", "=", (Object)categoryId);
            } else {
                Set ids = processCategoryEntities.stream().map(Entity::getId).collect(Collectors.toSet());
                ids.add(categoryId);
                qFilterCategoryId = new QFilter("categoryid", "in", ids);
            }
            modelsByFilters = repositoryService.findModelsByFilters(new QFilter[]{qFilterEnable, qFilterCategoryId});
        }
        if (WfUtils.isEmptyForCollection(modelsByFilters)) {
            ExtractMultiLanguageWordsUtil.printCategoryIdQueryEmptyLog();
            return Collections.emptyList();
        }
        modelsByFilters.forEach(t -> {
            HashMap mapVal = Maps.newHashMapWithExpectedSize((int)4);
            mapVal.put(RESOURCEID, t.getBPMNXMLID());
            mapVal.put(NAME, t.getName());
            mapVal.put(NUMBER, t.getNumber());
            mapVal.put(VERSION, t.getVersion());
            result.add(mapVal);
        });
        return result;
    }

    private static void printCategoryIdNullLog() {
        logger.debug("\u7ffb\u8bd1\u5e73\u53f0\u4f20\u9012\u8fc7\u6765\u7684\u6d41\u7a0b\u7c7b\u522bID\u4e3a\u7a7a\uff01");
    }

    private static void printCategoryIdQueryEmptyLog() {
        logger.debug("\u6839\u636ecategoryId\u672a\u67e5\u8be2\u5230\u6570\u636e\uff01");
    }

    private static void printProcIdAndResIdQueryEmptyLog(Long resourceId) {
        logger.warn(MessageFormat.format("\u6d41\u7a0b\u6a21\u578bId\u4e3a\u7a7a\u4e14\u4e0d\u5b58\u5728\uff0c\u4e14\u8d44\u6e90Id\u4e3a[{0}]\u7684\u6d41\u7a0b\u6a21\u677f\u4e0d\u5b58\u5728", resourceId));
    }

    private static void printProcessIdQueryEmptyLog(Long processId) {
        logger.warn(String.format("\u6d41\u7a0b\u6a21\u578bId\u4e3a[%s]\u7684\u6d41\u7a0b\u6a21\u578b\u4e0d\u5b58\u5728", processId));
    }

    private static void printResIdQueryEmptyLog(Long resourceId) {
        logger.warn(String.format("\u8d44\u6e90Id\u4e3a[%s]\u7684\u8d44\u6e90\u4e0d\u5b58\u5728", resourceId));
    }

    private static void printDataParamEmptyLog() {
        logger.warn("\u60a8\u6240\u4f20\u9012\u7684\u53c2\u6570\u7ed3\u6784\u4e0d\u6b63\u786e\uff0c\u8d44\u6e90\u4fe1\u606f\uff1adata\u4e3a\u7a7a\uff01");
    }

    private static void printAppIdEmptyLog() {
        logger.debug("\u7ffb\u8bd1\u5e73\u53f0\u4f20\u9012\u8fc7\u6765\u7684\u5e94\u7528Id\u4e3a\u7a7a\uff01");
    }

    private static void printEntityQueryByAppIdEmptyLog(String entityName) {
        logger.debug(MessageFormat.format("\u8be5\u5e94\u7528\u4e0b\u7684\u6ca1\u6709\u627e\u5230{0}\uff01", entityName));
    }

    private static Long getRootId() {
        Long rootId = 0L;
        ProcessCategoryEntity processCategoryEntity = ExtractMultiLanguageWordsUtil.getRepositoryService().getRootProcessCategory();
        if (processCategoryEntity != null) {
            rootId = processCategoryEntity.getId();
        }
        return rootId;
    }

    public static Object getProcessCategoryData() {
        JSONObject result = new JSONObject();
        RepositoryService repositoryService = ExtractMultiLanguageWordsUtil.getRepositoryService();
        ProcessCategoryEntity processCategoryEntity = repositoryService.getRootProcessCategory();
        Long rootId = processCategoryEntity.getId();
        String name = processCategoryEntity.getName();
        if (WfUtils.isEmpty(name)) {
            name = ResManager.loadKDString((String)"\u4e1a\u52a1\u4e91", (String)"ProcessCategoryTreeListView_1", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        result.put(CATEGORY_ID, (Object)rootId);
        result.put(CATEGORY_NAME, (Object)name);
        result.put(CATEGORY_PARENT_ID, (Object)0);
        result.put("isLeaf", (Object)processCategoryEntity.isLeaf());
        result.put("applicationid", (Object)processCategoryEntity.getApplicationId());
        if (!processCategoryEntity.isLeaf().booleanValue()) {
            result = ExtractMultiLanguageWordsUtil.getProcessTreeNextData(rootId, result);
        }
        return result;
    }

    public static Object getProcessTemplateCategoryData() {
        JSONObject result = new JSONObject();
        String name = ResManager.loadKDString((String)"\u5168\u90e8", (String)"GetProcTemplateCategoryTreeCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]);
        result.put(CATEGORY_ID, (Object)"0");
        result.put(CATEGORY_NAME, (Object)name);
        result.put(CATEGORY_PARENT_ID, (Object)NumberUtils.INTEGER_ZERO);
        QFilter qFilter = new QFilter("id", "!=", (Object)ProcTemplateCategoryEntityConstants.CATEGORY_NOCODE);
        QFilter qFilter1 = new QFilter(PARENT_ID, "!=", (Object)ProcTemplateCategoryEntityConstants.CATEGORY_NOCODE);
        QFilter[] qFilters = new QFilter[]{qFilter, qFilter1};
        String field = MessageFormat.format("{0},{1},{2},{3}", "id", PARENT_ID, "applicationid", NAME);
        List entitiesByFilters = ExtractMultiLanguageWordsUtil.getRepositoryService().findEntitiesByFilters("wf_proctemplatecategory", qFilters, field, "id ASC");
        if (entitiesByFilters.isEmpty()) {
            return result;
        }
        ArrayList parents = Lists.newArrayList();
        LinkedHashMap entityMap = Maps.newLinkedHashMapWithExpectedSize((int)entitiesByFilters.size());
        LinkedHashMap relation = Maps.newLinkedHashMap();
        for (Entity entity : entitiesByFilters) {
            List children;
            Long id = entity.getId();
            entityMap.put(id, entity);
            DynamicObject dynamicObject = entity.getDynamicObject();
            Long parentId = dynamicObject.getLong(PARENT_ID);
            if (WfUtils.isEmpty(parentId)) {
                parents.add(id);
                children = (List)relation.get(id);
                if (!WfUtils.isNullObject(children)) continue;
                children = Lists.newArrayList();
                relation.put(id, children);
                continue;
            }
            children = (List)relation.get(parentId);
            if (WfUtils.isNullObject(children)) {
                ExtractMultiLanguageWordsUtil.printWarnLog(MessageFormat.format("build relationship failed! id: {0}, parentId: {1}", id, parentId));
                continue;
            }
            children.add(id);
        }
        JSONArray childArray = new JSONArray();
        result.put(CHILDREN_ARRAY, (Object)childArray);
        for (Long parentId : parents) {
            Entity parent = (Entity)entityMap.get(parentId);
            JSONObject obj = new JSONObject();
            DynamicObject dynamicObject = parent.getDynamicObject();
            obj.put(CATEGORY_ID, (Object)dynamicObject.getLong("id"));
            obj.put(CATEGORY_NAME, (Object)dynamicObject.getString(NAME));
            obj.put(CATEGORY_PARENT_ID, (Object)dynamicObject.getLong(PARENT_ID));
            obj.put("applicationid", (Object)dynamicObject.getString("applicationid"));
            childArray.add((Object)obj);
            List childIds = (List)relation.get(parentId);
            if (WfUtils.isEmptyForCollection(childIds)) continue;
            JSONArray curChildArray = new JSONArray();
            obj.put(CHILDREN_ARRAY, (Object)curChildArray);
            for (Long childId : childIds) {
                Entity child = (Entity)entityMap.get(childId);
                JSONObject childObj = new JSONObject();
                DynamicObject childDynamicObject = child.getDynamicObject();
                childObj.put(CATEGORY_ID, (Object)childDynamicObject.getLong("id"));
                childObj.put(CATEGORY_NAME, (Object)childDynamicObject.getString(NAME));
                childObj.put(CATEGORY_PARENT_ID, (Object)childDynamicObject.getLong(PARENT_ID));
                childObj.put("applicationid", (Object)childDynamicObject.getString("applicationid"));
                curChildArray.add((Object)childObj);
            }
        }
        return result;
    }

    private static JSONObject getProcessTreeNextData(Long parentNodeId, JSONObject object) {
        JSONArray array = new JSONArray();
        List<ProcessCategoryEntity> processCategoryEntities = ExtractMultiLanguageWordsUtil.getRepositoryService().getProcateByParentId(parentNodeId, "wf_model");
        if (processCategoryEntities == null || processCategoryEntities.isEmpty()) {
            object.put(CHILDREN_ARRAY, (Object)array);
            return object;
        }
        for (ProcessCategoryEntity entity : processCategoryEntities) {
            JSONObject obj = new JSONObject();
            obj.put(CATEGORY_ID, (Object)entity.getId());
            obj.put(CATEGORY_NAME, (Object)entity.getName());
            obj.put(CATEGORY_PARENT_ID, (Object)parentNodeId);
            obj.put("isLeaf", (Object)entity.isLeaf());
            obj.put("applicationid", (Object)entity.getApplicationId());
            if (entity.isLeaf().booleanValue()) {
                array.add((Object)obj);
                continue;
            }
            obj = ExtractMultiLanguageWordsUtil.getProcessTreeNextData(entity.getId(), obj);
            array.add((Object)obj);
        }
        object.put(CHILDREN_ARRAY, (Object)array);
        return object;
    }

    private static RepositoryService getRepositoryService() {
        WorkflowService wfService = WfUtils.getWfService();
        return wfService.getRepositoryService();
    }

    private static void putExtendedModelMultiLangProps() {
        Set<String> types = ModelConfigUtil.getAllExtendedStencilTypes();
        if (types == null || types.isEmpty()) {
            return;
        }
        Map<String, List<String>> multiLangProps = ExtractMultiLanguageWordsUtil.getMultiLanguageProp();
        for (String stencilType : types) {
            String parentType = ModelConfigUtil.getExtendNodeInheritStencilType(stencilType);
            if (parentType != null) {
                multiLangProps.put(stencilType, multiLangProps.get(parentType));
                continue;
            }
            logger.debug(String.format("\u627e\u4e0d\u5230 %s \u8282\u70b9\u7ee7\u627f\u7684\u8282\u70b9\u7c7b\u578b\uff01", stencilType));
        }
    }

    public static Map<String, Object> getMultiLanguageWords(Long resourceId) {
        HashMap<String, Object> multiLanguageWords = new HashMap<String, Object>();
        ResourceEntity resource = ExtractMultiLanguageWordsUtil.getRepositoryService().getResourceById(resourceId);
        if (WfUtils.isNullObject(resource)) {
            return Collections.emptyMap();
        }
        ILocaleString content = resource.getContent();
        HashMap<String, HashMap<String, String>> properties = new HashMap<String, HashMap<String, String>>();
        for (String contentKey : content.keySet()) {
            String multiLangContent = (String)content.get((Object)contentKey);
            if (WfUtils.isEmpty(multiLangContent)) {
                ExtractMultiLanguageWordsUtil.printWarnLog("multiLangContent of" + contentKey + "is empty");
                continue;
            }
            JSONObject multiLangContentObject = JSON.parseObject((String)multiLangContent);
            JSONObject multiLangProperties = multiLangContentObject.getJSONObject("data");
            if (WfUtils.isEmptyString(multiLangProperties)) continue;
            String lang = multiLangContentObject.getString(LANG);
            String name = multiLangContentObject.getString(NAME);
            Long processId = multiLangContentObject.getLong(PROCESSID);
            String version = multiLangContentObject.getString(VERSION);
            for (String propertiesKey : multiLangProperties.keySet()) {
                String propertiesValue = (String)multiLangProperties.get((Object)propertiesKey);
                if (WfUtils.isEmptyString(propertiesValue)) continue;
                HashMap<String, String> word = (HashMap<String, String>)properties.get(propertiesKey);
                if (word == null) {
                    word = new HashMap<String, String>();
                    properties.put(propertiesKey, word);
                }
                word.put(lang, propertiesValue);
            }
            multiLanguageWords.put(RESOURCEID, resourceId);
            multiLanguageWords.put(NAME, name);
            multiLanguageWords.put(PROCESSID, processId);
            multiLanguageWords.put(VERSION, version);
            multiLanguageWords.put("data", properties);
        }
        return multiLanguageWords;
    }

    public static void applyMultiLanguageWords(Map<String, Object> mutiLangDatas) {
        if (ExtractMultiLanguageWordsUtil.validateMutiLangDatas(mutiLangDatas)) {
            return;
        }
        Long processId = WfUtils.getLongValueFromObj(mutiLangDatas.get(PROCESSID));
        String lang = (String)mutiLangDatas.get(LANG);
        RepositoryService repositoryService = ExtractMultiLanguageWordsUtil.getRepositoryService();
        List mulLangInfo = (List)mutiLangDatas.get(MULLANGINFO);
        for (Map datas : mulLangInfo) {
            datas.put(PROCESSID, processId);
            ModelEntity model = (ModelEntity)repositoryService.getModel(processId);
            if (model == null) {
                ExtractMultiLanguageWordsUtil.printProcessIdQueryEmptyLog(processId);
                continue;
            }
            ILocaleString modelName = model.getName();
            datas.put(NAME, modelName == null || WfUtils.isEmpty((String)modelName.get((Object)lang)) ? "" : modelName.get((Object)lang));
            datas.put(LANG, lang);
            datas.put(VERSION, model.getVersion());
            Long resourceId = (Long)datas.get(RESOURCEID);
            if (WfUtils.isEmpty(resourceId)) {
                ExtractMultiLanguageWordsUtil.printResIdQueryEmptyLog(resourceId);
                continue;
            }
            ResourceEntity resourceEntity = repositoryService.getResourceById(resourceId);
            if (resourceEntity == null) {
                ExtractMultiLanguageWordsUtil.printResIdQueryEmptyLog(resourceId);
                continue;
            }
            ILocaleString content = resourceEntity.getContent();
            content.setItem(lang, (Object)SerializationUtils.toJsonString((Object)datas));
            resourceEntity.setContent(content);
            repositoryService.saveOrUpdateEntity(resourceEntity);
        }
    }

    public static void applyMultiLanguageWords4ModelAndTpl(Map<String, Object> mutiLangDatas) {
        if (ExtractMultiLanguageWordsUtil.validateMutiLangDatas4ModelAndTpl(mutiLangDatas)) {
            return;
        }
        Long processId = WfUtils.getLongValueFromObj(mutiLangDatas.get(PROCESSID));
        String lang = (String)mutiLangDatas.get(LANG);
        RepositoryService repositoryService = ExtractMultiLanguageWordsUtil.getRepositoryService();
        List mulLangInfo = (List)mutiLangDatas.get(MULLANGINFO);
        for (Map datas : mulLangInfo) {
            String version;
            ILocaleString modelName;
            Long resourceId = (Long)datas.get(RESOURCEID);
            if (WfUtils.isEmpty(resourceId)) {
                ExtractMultiLanguageWordsUtil.printResIdQueryEmptyLog(resourceId);
                continue;
            }
            QFilter qFilter = new QFilter(RESOURCEID, "=", (Object)resourceId);
            List entitiesByFilters = repositoryService.findEntitiesByFilters("wf_proctemplate", new QFilter[]{qFilter}, NAME, null);
            if (WfUtils.isEmptyForCollection(entitiesByFilters)) {
                ModelEntity model = (ModelEntity)ExtractMultiLanguageWordsUtil.getModelByProcessId(processId, repositoryService);
                if (Objects.isNull(model)) {
                    ExtractMultiLanguageWordsUtil.printProcIdAndResIdQueryEmptyLog(resourceId);
                    continue;
                }
                modelName = model.getName();
                version = model.getVersion();
            } else {
                modelName = ((Entity)entitiesByFilters.get(NumberUtils.INTEGER_ZERO)).getDynamicObject().getLocaleString(NAME);
                version = "";
            }
            datas.put(NAME, WfUtils.isNullObject(modelName) || WfUtils.isEmpty((String)modelName.get((Object)lang)) ? "" : modelName.get((Object)lang));
            datas.put(LANG, lang);
            datas.put(VERSION, version);
            datas.put(PROCESSID, processId);
            ResourceEntity resourceEntity = repositoryService.getResourceById(resourceId);
            if (WfUtils.isNullObject(resourceEntity)) {
                ExtractMultiLanguageWordsUtil.printResIdQueryEmptyLog(resourceId);
                continue;
            }
            ILocaleString content = resourceEntity.getContent();
            content.setItem(lang, (Object)SerializationUtils.toJsonString((Object)datas));
            resourceEntity.setContent(content);
            repositoryService.saveOrUpdateEntity(resourceEntity);
        }
    }

    private static Model getModelByProcessId(Long processId, RepositoryService repositoryService) {
        if (WfUtils.isEmpty(processId)) {
            ExtractMultiLanguageWordsUtil.printProcessIdQueryEmptyLog(processId);
            return null;
        }
        return repositoryService.getModel(processId);
    }

    public static Map<String, Object> makeMultiLanguagePackage(Map<String, Object> mutiLangDatas) {
        if (ExtractMultiLanguageWordsUtil.validateMutiLangDatas(mutiLangDatas)) {
            return null;
        }
        Long newModelId = (Long)mutiLangDatas.get(PROCESSID);
        RepositoryService repositoryService = ExtractMultiLanguageWordsUtil.getRepositoryService();
        ModelEntity model = (ModelEntity)repositoryService.getModel(newModelId);
        if (model == null) {
            logger.warn("\u6d41\u7a0b\u6a21\u578bId\u4e3a[%s]\u7684\u6d41\u7a0b\u6a21\u578b\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6240\u4f20\u9012\u7684\u53c2\u6570\uff1aprocessId\u662f\u5426\u6b63\u786e\uff01");
            return null;
        }
        String modelKey = model.getKey();
        String newVersion = model.getVersion();
        String lang = (String)mutiLangDatas.get(LANG);
        StringBuilder multiLangPackSQL = new StringBuilder();
        List mulLangInfo = (List)mutiLangDatas.get(MULLANGINFO);
        String[] fpkids = ORM.create().genStringIds("wf_resource", mulLangInfo.size());
        int i = 0;
        for (Map datas : mulLangInfo) {
            if (datas.isEmpty()) {
                ExtractMultiLanguageWordsUtil.printDataParamEmptyLog();
                continue;
            }
            Long newResourceId = (Long)datas.get(RESOURCEID);
            if (WfUtils.isEmpty(newResourceId)) {
                ExtractMultiLanguageWordsUtil.printResIdQueryEmptyLog(newResourceId);
                continue;
            }
            QFilter qFProcNumber = new QFilter("procnumber", "=", (Object)modelKey);
            QFilter qFNewVersion = new QFilter("newversion", "=", (Object)newVersion);
            QFilter qFNewResourceId = new QFilter("newresourceid", "=", (Object)newResourceId);
            List resourceRelationEntities = repositoryService.findEntitiesByFilters("wf_resourcerelation", new QFilter[]{qFProcNumber, qFNewVersion, qFNewResourceId});
            if (resourceRelationEntities == null || resourceRelationEntities.isEmpty()) {
                logger.warn(String.format("\u6839\u636e\u6d41\u7a0b\u7f16\u7801[%s]\u548c\u7248\u672c\u53f7[%s]\u67e5\u8be2\u4e0d\u5230\u6d41\u7a0b\u8d44\u6e90\u5173\u7cfb\u76f8\u5173\u8bb0\u5f55\uff01", modelKey, newVersion));
                continue;
            }
            ResourceRelationEntity resourceRelation = (ResourceRelationEntity)resourceRelationEntities.get(0);
            Long originalResourceId = resourceRelation.getOriginalResourceId();
            if (WfUtils.isEmpty(originalResourceId)) {
                logger.warn("\u6d41\u7a0b\u7f16\u7801\u4e3a[%s]\u7248\u672c\u53f7\u4e3a[%s]\u7684\u6d41\u7a0b\u672a\u5728\u8d44\u6e90\u5173\u7cfb\u8868\u91cc\u627e\u5230\u539f\u8d44\u6e90Id\uff01");
                continue;
            }
            datas.put(RESOURCEID, originalResourceId);
            datas.put(PROCESSID, resourceRelation.getOriginalModelId());
            datas.put(NAME, model.getName().getLocaleValue_zh_CN());
            datas.put(LANG, lang);
            datas.put(VERSION, resourceRelation.getOriginalVersion());
            String content = SerializationUtils.toJsonString((Object)datas);
            String deleteSQL = "delete from t_wf_gebytearray_l where fid = " + originalResourceId + " and flocaleid='" + lang + "';";
            String insertSQL = "insert into t_wf_gebytearray_l(fpkid,fid,flocaleid,fcontent) values ('" + fpkids[i] + "'," + originalResourceId + ",'" + lang + "','" + content + "');";
            multiLangPackSQL.append(deleteSQL).append('\n').append(insertSQL).append('\n');
            if (mulLangInfo.size() > 1) {
                multiLangPackSQL.append('\n');
            }
            ++i;
        }
        String fileName = String.format("%s.%s%s", modelKey, lang, FILE_SUFFIX);
        HashMap<String, Object> sqls = new HashMap<String, Object>();
        sqls.put(SQL_S, multiLangPackSQL.toString());
        sqls.put(FILE_NAME, fileName);
        return sqls;
    }

    public static Map<String, Object> makeMultiLanguagePackage4ModelAndTpl(Map<String, Object> mutiLangDatas) {
        if (ExtractMultiLanguageWordsUtil.validateMutiLangDatas4ModelAndTpl(mutiLangDatas)) {
            return null;
        }
        String modelKey = " ";
        String newVersion = " ";
        Long newModelId = WfUtils.getLongValueFromObj(mutiLangDatas.get(PROCESSID));
        RepositoryService repositoryService = ExtractMultiLanguageWordsUtil.getRepositoryService();
        String lang = (String)mutiLangDatas.get(LANG);
        StringBuilder multiLangPackSQL = new StringBuilder();
        List mulLangInfo = (List)mutiLangDatas.get(MULLANGINFO);
        String[] fpkids = ORM.create().genStringIds("wf_resource", mulLangInfo.size());
        int i = NumberUtils.INTEGER_ZERO;
        for (Map datas : mulLangInfo) {
            List resourceRelationEntities;
            String curModelKey;
            ILocaleString modelName;
            if (WfUtils.isEmptyForMap(datas)) {
                ExtractMultiLanguageWordsUtil.printDataParamEmptyLog();
                continue;
            }
            Long newResourceId = WfUtils.getLongValueFromObj(datas.get(RESOURCEID));
            if (WfUtils.isEmpty(newResourceId)) {
                ExtractMultiLanguageWordsUtil.printResIdQueryEmptyLog(newResourceId);
                continue;
            }
            QFilter qFilter = new QFilter(RESOURCEID, "=", (Object)newResourceId);
            String field = MessageFormat.format(TWO_FIELD_TPL, NAME, NUMBER);
            List entitiesByFilters = repositoryService.findEntitiesByFilters("wf_proctemplate", new QFilter[]{qFilter}, field, null);
            if (WfUtils.isEmptyForCollection(entitiesByFilters)) {
                ModelEntity model = (ModelEntity)ExtractMultiLanguageWordsUtil.getModelByProcessId(newModelId, repositoryService);
                if (Objects.isNull(model)) {
                    ExtractMultiLanguageWordsUtil.printResIdQueryEmptyLog(newResourceId);
                    continue;
                }
                modelName = model.getName();
                curModelKey = model.getKey();
                if (Objects.equals(" ", modelKey)) {
                    modelKey = curModelKey;
                }
                if (Objects.equals(" ", newVersion)) {
                    newVersion = model.getVersion();
                }
            } else {
                DynamicObject tpl = ((Entity)entitiesByFilters.get(NumberUtils.INTEGER_ZERO)).getDynamicObject();
                modelName = tpl.getLocaleString(NAME);
                curModelKey = tpl.getString(NUMBER);
                if (Objects.equals(" ", modelKey)) {
                    modelKey = curModelKey;
                }
            }
            ArrayList qfs = Lists.newArrayListWithExpectedSize((int)3);
            qfs.add(new QFilter("newresourceid", "=", (Object)newResourceId));
            if (WfUtils.isNotEmpty(curModelKey)) {
                qfs.add(new QFilter("procnumber", "=", (Object)curModelKey));
            }
            if (WfUtils.isNotEmpty(newVersion)) {
                qfs.add(new QFilter("newversion", "=", (Object)newVersion));
            }
            if (WfUtils.isEmptyForCollection(resourceRelationEntities = repositoryService.findEntitiesByFilters("wf_resourcerelation", qfs.toArray(new QFilter[0])))) {
                ExtractMultiLanguageWordsUtil.printResIdQueryEmptyLog(newResourceId);
                continue;
            }
            ResourceRelationEntity resourceRelation = (ResourceRelationEntity)resourceRelationEntities.get(NumberUtils.INTEGER_ZERO);
            Long originalResourceId = resourceRelation.getOriginalResourceId();
            if (WfUtils.isEmpty(originalResourceId)) {
                ExtractMultiLanguageWordsUtil.printResIdQueryEmptyLog(newResourceId);
                continue;
            }
            datas.put(RESOURCEID, originalResourceId);
            datas.put(PROCESSID, resourceRelation.getOriginalModelId());
            datas.put(NAME, modelName);
            datas.put(LANG, lang);
            datas.put(VERSION, resourceRelation.getOriginalVersion());
            String content = SerializationUtils.toJsonString((Object)datas).replaceAll("'", "''");
            String deleteSQL = "delete from t_wf_gebytearray_l where fid = " + originalResourceId + " and flocaleid='" + lang + "';";
            String insertSQL = "insert into t_wf_gebytearray_l(fpkid,fid,flocaleid,fcontent) values ('" + fpkids[i] + "'," + originalResourceId + ",'" + lang + "','" + content + "');";
            multiLangPackSQL.append(deleteSQL).append('\n').append(insertSQL).append('\n');
            if (mulLangInfo.size() > 1) {
                multiLangPackSQL.append('\n');
            }
            ++i;
        }
        String fileName = MessageFormat.format("{0}.{1}", modelKey, lang + FILE_SUFFIX);
        HashMap sqls = Maps.newHashMapWithExpectedSize((int)2);
        sqls.put(SQL_S, multiLangPackSQL.toString());
        sqls.put(FILE_NAME, fileName);
        return sqls;
    }

    private static boolean validateMutiLangDatas(Map<String, Object> mutiLangDatas) {
        String errMsg = ExtractMultiLanguageWordsUtil.getMutiLangDatasErrMsg(mutiLangDatas);
        return ExtractMultiLanguageWordsUtil.validateMutiLangDatasStr(errMsg);
    }

    private static String getMutiLangDatasErrMsg(Map<String, Object> mutiLangDatas) {
        if (WfUtils.isEmptyForMap(mutiLangDatas)) {
            return "The parameter you passed is incorrect, the parameter is empty, please recheck!";
        }
        Long processId = (Long)mutiLangDatas.get(PROCESSID);
        if (WfUtils.isEmpty(processId)) {
            return "The structure of the parameter you passed is incorrect and the process model Id:processId is empty!";
        }
        String lang = (String)mutiLangDatas.get(LANG);
        if (WfUtils.isEmpty(lang)) {
            return "The structure of the parameter you passed is incorrect, and the language code: lang is empty!";
        }
        List mulLangInfo = (List)mutiLangDatas.get(MULLANGINFO);
        if (mulLangInfo == null || mulLangInfo.isEmpty()) {
            return "The structure of the parameter you passed is incorrect. multilingualResourceInfo: mulLangInfo is empty!";
        }
        return null;
    }

    private static boolean validateMutiLangDatas4ModelAndTpl(Map<String, Object> mutiLangDatas) {
        String errMsg = ExtractMultiLanguageWordsUtil.getMutiLangDatas4ModelAndTplErrMsg(mutiLangDatas);
        return ExtractMultiLanguageWordsUtil.validateMutiLangDatasStr(errMsg);
    }

    private static String getMutiLangDatas4ModelAndTplErrMsg(Map<String, Object> mutiLangDatas) {
        if (WfUtils.isEmptyForMap(mutiLangDatas)) {
            return "The parameter you passed is incorrect, the parameter is empty, please recheck!";
        }
        String lang = (String)mutiLangDatas.get(LANG);
        if (WfUtils.isEmpty(lang)) {
            return "The structure of the parameter you passed is incorrect, and the language code: lang is empty!";
        }
        List mulLangInfo = (List)mutiLangDatas.get(MULLANGINFO);
        if (WfUtils.isEmptyForCollection(mulLangInfo)) {
            return "The structure of the parameter you passed is incorrect. multilingualResourceInfo: mulLangInfo is empty!";
        }
        return null;
    }

    private static boolean validateMutiLangDatasStr(String errMsg) {
        if (StringUtils.isNotEmpty((CharSequence)errMsg)) {
            ExtractMultiLanguageWordsUtil.printWarnLog(errMsg);
            return true;
        }
        return false;
    }

    private static void printWarnLog(String errMsg) {
        logger.warn(errMsg);
    }

    public static Map<String, Object> getMultiLangResourceTemplate(Long resourceId, String name, Long processId, String version, String lang) {
        HashMap<String, Object> template = new HashMap<String, Object>();
        template.put(RESOURCEID, resourceId);
        template.put(LANG, lang);
        template.put(NAME, name);
        template.put(PROCESSID, processId);
        template.put(VERSION, version);
        template.put("data", new HashMap());
        return template;
    }

    public static Map<String, Object> getMultiLangResourceTemplate(Long resourceId, String name, Long processId, String version, String lang, Map<String, Object> data) {
        Map<String, Object> template = ExtractMultiLanguageWordsUtil.getMultiLangResourceTemplate(resourceId, name, processId, version, lang);
        template.put("data", data);
        return template;
    }

    public static void extractWordsAndSaveOrUpdate(Long resourceId, String name, Long processId, String version, String key) {
        String lang = RequestContext.get().getLang().toString();
        Map<String, Object> multiLanguageWords = ExtractMultiLanguageWordsUtil.getMultiLangResourceTemplate(resourceId, name, processId, version, lang);
        WorkflowService service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        ResourceEntity resource = service.getRepositoryService().getResourceById(resourceId);
        String modelJson = resource.getData();
        if (!WfUtils.isEmpty(modelJson.replace("{}", ""))) {
            JSONObject root = JSON.parseObject((String)modelJson);
            Map<String, Object> datas = ExtractMultiLanguageWordsUtil.getExtractedMultiLangTerms(root, key);
            multiLanguageWords.put("data", datas);
            if (datas.size() > 0) {
                ILocaleString content = resource.getContent();
                content.setItem(lang, (Object)SerializationUtils.toJsonString(multiLanguageWords));
                resource.setContent(content);
                resource.setCurrentLanguage(lang);
                service.getRepositoryService().saveOrUpdateEntity(resource);
            }
        }
    }

    public static Map<String, Object> getExtractedMultiLangTerms(JSONObject root, String procNumber) {
        HashMap<String, Object> datas = new HashMap<String, Object>();
        ExtractMultiLanguageWordsUtil.extractMultiLanguageProperties(root, datas, procNumber);
        return datas;
    }

    private static void extractMultiLanguageProperties(JSONObject node, Map<String, Object> datas, String key) {
        JSONArray childShapes;
        String stencilId;
        String resourceId = node.getString(RESOURCEID);
        String string = stencilId = node.getJSONObject("stencil") == null ? null : node.getJSONObject("stencil").getString("id");
        if (stencilId == null && resourceId != null) {
            stencilId = resourceId.replaceFirst(key + "_([a-zA-Z]+)\\d+", "$1");
        }
        if (stencilId == null && resourceId == null) {
            stencilId = "BPMNDiagram";
            resourceId = "node_1";
        }
        if (WfUtils.isNotEmpty(stencilId)) {
            ExtractMultiLanguageWordsUtil.extractMultiLanguageForProperties(node, datas, resourceId, stencilId);
        }
        if ((childShapes = node.getJSONArray(CHILDSHAPES)) != null && childShapes.size() > 0) {
            for (Object child : childShapes) {
                ExtractMultiLanguageWordsUtil.extractMultiLanguageProperties((JSONObject)child, datas, key);
            }
        }
    }

    private static void extractMultiLanguageForProperties(JSONObject node, Map<String, Object> datas, String resourceId, String stencilId) {
        List<String> multiLangProps = ExtractMultiLanguageWordsUtil.getMultiLanguageProp().get(stencilId);
        if (multiLangProps != null && !multiLangProps.isEmpty()) {
            JSONObject properties = node.getJSONObject("properties");
            Map<String, String> expendAttributePathMap = null;
            if (properties != null && !properties.isEmpty()) {
                for (String propertyKey : properties.keySet()) {
                    Object value = properties.get((Object)propertyKey);
                    if (EXTATTRGROUP.equals(propertyKey) && value != null) {
                        if (expendAttributePathMap == null) {
                            expendAttributePathMap = ExtractMultiLanguageWordsUtil.getExtAttributePathMap(stencilId);
                        }
                        ExtractMultiLanguageWordsUtil.extractMultiLanguageExtAttrProperties(datas, resourceId, expendAttributePathMap, value);
                        continue;
                    }
                    String path = String.format("%s.%s", resourceId, propertyKey);
                    ExtractMultiLanguageWordsUtil.extractMultiLanguagePropertiesFromObject(value, datas, path, multiLangProps);
                }
            }
        }
    }

    private static Map<String, String> getExtAttributePathMap(String stencilId) {
        HashMap<String, String> expendAttributePathMap = new HashMap<String, String>();
        NodeTemplateExtAttrEntity nodeTemplateExtAttrEntity = NodeTemplateUtil.getExtAttrDatas(stencilId, null);
        Map<String, JSONArray> extAttrMap = nodeTemplateExtAttrEntity.getExtAttrMap();
        if (extAttrMap == null || extAttrMap.isEmpty()) {
            logger.debug("ExtractMultiLanguageWordsUtil.getExpendAttributePathMap is error:extAttrMap is null");
            return expendAttributePathMap;
        }
        for (Map.Entry<String, JSONArray> extAttr : extAttrMap.entrySet()) {
            JSONArray attributesArray;
            String groupNumber = extAttr.getKey();
            if (WfUtils.isEmpty((String)expendAttributePathMap.get(groupNumber))) {
                String groupNamePath = "extAttrGroup." + groupNumber + "." + EXT_GROUPNAME;
                expendAttributePathMap.put(groupNumber, groupNamePath);
            }
            if ((attributesArray = extAttr.getValue()) == null) continue;
            for (Object object : attributesArray) {
                JSONObject expendAttribute = (JSONObject)object;
                String attributeType = expendAttribute.getString(EXT_ATTRIBUTETYPE);
                if (!"text".equals(attributeType)) continue;
                String attributesPatch = "extAttrGroup." + groupNumber + "." + EXT_EXTATTRVALUE + "." + expendAttribute.getString(EXT_ATTRIBUTENUMBER);
                expendAttributePathMap.put(expendAttribute.getString(EXT_ATTRIBUTENUMBER), attributesPatch);
            }
        }
        return expendAttributePathMap;
    }

    private static void extractMultiLanguageExtAttrProperties(Map<String, Object> datas, String resourceId, Map<String, String> extAttrValuePathMap, Object value) {
        JSONObject extAttrGroupValue = (JSONObject)value;
        Set entrySet = extAttrGroupValue.entrySet();
        for (Map.Entry entry : entrySet) {
            String key = (String)entry.getKey();
            JSONObject entryValue = (JSONObject)entry.getValue();
            String groupNameValue = entryValue.getString(EXT_GROUPNAME);
            datas.put(String.format("%s.%s", resourceId, extAttrValuePathMap.get(key)), groupNameValue);
            JSONObject extAttrValue = entryValue.getJSONObject(EXT_EXTATTRVALUE);
            if (extAttrValue == null) continue;
            Set extAttrValueEntrySet = extAttrValue.entrySet();
            for (Map.Entry extAttrValueEntry : extAttrValueEntrySet) {
                String extendedAttributeKey = (String)extAttrValueEntry.getKey();
                if (!WfUtils.isNotEmpty(extAttrValuePathMap.get(extendedAttributeKey))) continue;
                datas.put(String.format("%s.%s", resourceId, extAttrValuePathMap.get(extendedAttributeKey)), extAttrValueEntry.getValue());
            }
        }
    }

    private static void extractMultiLanguagePropertiesFromObject(Object value, Map<String, Object> datas, String path, List<String> multiLangProps) {
        if (value instanceof Map) {
            Map node = (Map)value;
            for (Map.Entry entry : node.entrySet()) {
                String key = (String)entry.getKey();
                Object val = entry.getValue();
                String patch = String.format("%s.%s", path, key);
                ExtractMultiLanguageWordsUtil.extractMultiLanguagePropertiesFromObject(val, datas, patch, multiLangProps);
            }
        } else if (value instanceof List) {
            List items = (List)value;
            for (Object item : items) {
                Map obj;
                String id = null;
                id = item instanceof Map ? (WfUtils.isNotEmpty(id = ExtractMultiLanguageWordsUtil.getString((obj = (Map)item).get("id"))) ? id : ExtractMultiLanguageWordsUtil.getString(obj.get("itemId"))) : String.valueOf(item.hashCode());
                String patch = String.format("%s.[%s]", path, id);
                ExtractMultiLanguageWordsUtil.extractMultiLanguagePropertiesFromObject(item, datas, patch, multiLangProps);
            }
        } else if (value instanceof String && WfUtils.isJSONFormat(value)) {
            Map node = null;
            try {
                node = (Map)SerializationUtils.fromJsonString((String)((String)value), Map.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (node != null) {
                for (Map.Entry entry : node.entrySet()) {
                    String key = (String)entry.getKey();
                    Object val = entry.getValue();
                    String patch = String.format("%s.%s", path, key);
                    ExtractMultiLanguageWordsUtil.extractMultiLanguagePropertiesFromObject(val, datas, patch, multiLangProps);
                }
            } else {
                ExtractMultiLanguageWordsUtil.extractFromBasicProperty(value, datas, path, multiLangProps);
            }
        } else {
            ExtractMultiLanguageWordsUtil.extractFromBasicProperty(value, datas, path, multiLangProps);
        }
    }

    private static String getString(Object value) {
        return value == null ? null : value.toString();
    }

    private static void extractFromBasicProperty(Object value, Map<String, Object> datas, String path, List<String> multiLangProps) {
        if (ExtractMultiLanguageWordsUtil.isMultiProperty(path, multiLangProps) && value != null) {
            datas.put(path, value);
        }
    }

    private static boolean isMultiProperty(String path, List<String> multiLangProps) {
        String propPath = path.substring(path.indexOf(46) + 1).toLowerCase();
        List<String> blackProps = ExtractMultiLanguageWordsUtil.getBlackMultiLanguageProp();
        for (String regex : blackProps) {
            if (!propPath.toLowerCase().matches(regex)) continue;
            return false;
        }
        for (String regex : multiLangProps) {
            if (!propPath.toLowerCase().matches(regex)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static void mergeMultiLanguageWords(Long resourceId) {
        WorkflowService service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        ResourceEntity resource = service.getRepositoryService().getResourceById(resourceId);
        String modelJson = resource.getData();
        ILocaleString content = resource.getContent();
        if (modelJson != null && !WfUtils.isEmpty(modelJson.replace("{}", ""))) {
            JSONObject contentObject;
            JSONObject multiLanguageWords;
            String lang;
            String contentLocaleString;
            Map root = (Map)JSON.parseObject((String)modelJson, Map.class);
            HashMap<String, Map<String, Object>> relation = new HashMap<String, Map<String, Object>>();
            relation.put((String)root.get(RESOURCEID), root);
            List childShapes = (List)root.get(CHILDSHAPES);
            if (childShapes != null) {
                for (Map child : childShapes) {
                    relation.put((String)child.get(RESOURCEID), child);
                }
            }
            if (!WfUtils.isEmpty(contentLocaleString = (String)content.getItem(lang = RequestContext.get().getLang().toString())) && !WfUtils.isEmptyString(multiLanguageWords = (contentObject = JSON.parseObject((String)contentLocaleString)).getJSONObject("data"))) {
                for (String multiLanguageWordsKey : multiLanguageWords.keySet()) {
                    Object wordValue = multiLanguageWords.get((Object)multiLanguageWordsKey);
                    ExtractMultiLanguageWordsUtil.replaceMultiLanguageProperties(relation, multiLanguageWordsKey, wordValue);
                }
                String data = SerializationUtils.toJsonString((Object)root);
                resource.setData(data);
                resource.setCurrentLanguage(lang);
                service.getRepositoryService().saveOrUpdateEntity(resource);
            }
        }
    }

    private static String getMultiLanguageResourceData(ResourceEntity resource, String lang, boolean isPatch) {
        String currentLanguage = resource.getCurrentLanguage();
        String data = resource.getData();
        if (BpmnModelUtil.isEmptyResource(data)) {
            logger.debug(String.format("%s \u8d44\u6e90\u6570\u636e\u4e3a\u7a7a\uff01", resource.getId()));
            return data;
        }
        if (WfUtils.isEmpty(currentLanguage) || currentLanguage.equals(lang)) {
            return data;
        }
        String multiContent = null;
        if (resource.getContent() == null || BpmnModelUtil.isEmptyResource(multiContent = (String)resource.getContent().get((Object)lang))) {
            logger.debug(String.format("%s \u8d44\u6e90 %s \u8bed\u79cd\u6570\u636e\u4e3a\u7a7a\uff01", resource.getId(), lang));
            return data;
        }
        JSONObject multiData = JSON.parseObject((String)multiContent).getJSONObject("data");
        if (multiData == null) {
            return data;
        }
        Map root = (Map)JSON.parseObject((String)data, Map.class);
        HashMap<String, Map<String, Object>> relation = new HashMap<String, Map<String, Object>>();
        relation.put((String)root.get(RESOURCEID), root);
        List childShapes = (List)root.get(CHILDSHAPES);
        if (childShapes != null) {
            for (Map child : childShapes) {
                relation.put((String)child.get(RESOURCEID), child);
            }
        }
        for (String itemKey : multiData.keySet()) {
            Object multiValue = multiData.get((Object)itemKey);
            ExtractMultiLanguageWordsUtil.replaceMultiLanguageProperties(relation, itemKey, multiValue);
        }
        return SerializationUtils.toJsonString((Object)root);
    }

    public static String getMultiLanguageResourceData(ResourceEntity resource, String lang) {
        return ExtractMultiLanguageWordsUtil.getMultiLanguageResourceData(resource, lang, false);
    }

    public static String getMultiLanguagePatchResourceData(ResourceEntity resource, String lang) {
        return ExtractMultiLanguageWordsUtil.getMultiLanguageResourceData(resource, lang, true);
    }

    private static void replaceMultiLanguageProperties(Map<String, Map<String, Object>> relation, String multiLanguageWordsKey, Object wordValue) {
        String[] strKey = multiLanguageWordsKey.split("\\.");
        String resId = strKey[0];
        Map<String, Object> node = relation.get(resId);
        if (node != null && node.size() > 0) {
            Map properties = (Map)node.get("properties");
            if (strKey.length > 2) {
                int i = 0;
                ExtractMultiLanguageWordsUtil.replaceMultiLanguagePropertiesForObject(i, properties, strKey, wordValue);
            } else if (strKey.length == 2) {
                ExtractMultiLanguageWordsUtil.replaceMultiLanguagePropertiesForBasic(properties, strKey, wordValue);
            }
        }
    }

    private static void replaceMultiLanguagePropertiesForObject(int i, Map<String, Object> properties, String[] strKey, Object wordValue) {
        String key;
        Object subValue;
        if (i > strKey.length - 1) {
            return;
        }
        if ((subValue = properties.get(key = strKey[++i])) == null && i < strKey.length - 1) {
            return;
        }
        if (subValue instanceof JSONArray) {
            List subProperties = (List)properties.get(key);
            String idKey = BpmnDiffUtil.getListElementUniqueKey(key);
            String id = strKey[++i].replaceAll("\\[|\\]", "");
            for (Map subProperty : subProperties) {
                if (!id.equals(subProperty.get(idKey))) continue;
                ExtractMultiLanguageWordsUtil.replaceMultiLanguagePropertiesForObject(i, subProperty, strKey, wordValue);
                break;
            }
        } else if (subValue instanceof JSONObject) {
            Map subProperties = (Map)properties.get(key);
            String[] stringKey = Arrays.copyOfRange(strKey, i, strKey.length);
            ExtractMultiLanguageWordsUtil.replaceMultiLanguagePropertiesForObject(0, subProperties, stringKey, wordValue);
        } else if (subValue instanceof String && WfUtils.isJSONFormat(subValue)) {
            JSONObject subValueMap = null;
            try {
                subValueMap = JSON.parseObject((String)((String)subValue));
            }
            catch (Exception stringKey) {
                // empty catch block
            }
            if (subValueMap != null) {
                String[] stringKey = Arrays.copyOfRange(strKey, i, strKey.length);
                if (stringKey.length == 1) {
                    properties.put(key, wordValue);
                } else {
                    ExtractMultiLanguageWordsUtil.replaceMultiLanguagePropertiesForObject(0, (Map<String, Object>)subValueMap, stringKey, wordValue);
                    properties.put(key, subValueMap.toJSONString());
                }
            } else {
                properties.put(key, wordValue);
            }
        } else {
            properties.put(key, wordValue);
        }
    }

    private static void replaceMultiLanguagePropertiesForBasic(Map<String, Object> properties, String[] strKey, Object wordValue) {
        properties.put(strKey[strKey.length - 1], wordValue);
    }

    public static void synchronizeResourceWords(Long srcResourceId, Long targetResourceId) {
        RepositoryService repositoryService = ExtractMultiLanguageWordsUtil.getRepositoryService();
        ResourceEntity srcResource = (ResourceEntity)repositoryService.findEntityById(srcResourceId, "wf_resource");
        if (srcResource == null) {
            logger.debug(String.format("\u6e90\u8d44\u6e90Id\u4e3a\uff1a[%s]\u7684\u6d41\u7a0b\u8d44\u6e90\u5b9e\u4f53\u4e0d\u5b58\u5728\uff01", srcResourceId));
            return;
        }
        ResourceEntity targetResource = (ResourceEntity)repositoryService.findEntityById(targetResourceId, "wf_resource");
        if (targetResource == null) {
            logger.debug(String.format("\u76ee\u6807\u8d44\u6e90Id\u4e3a\uff1a[%s]\u7684\u6d41\u7a0b\u8d44\u6e90\u5b9e\u4f53\u4e0d\u5b58\u5728\uff01", targetResourceId));
            return;
        }
        ExtractMultiLanguageWordsUtil.synchronizeWords(srcResource, targetResource);
    }

    private static void synchronizeWords(ResourceEntity srcResource, ResourceEntity targetResource) {
        ILocaleString targetContent = targetResource.getContent();
        if (targetContent != null && !targetContent.isEmpty() && targetContent.getLocaleValue() != null) {
            Map targetContentMap = (Map)SerializationUtils.fromJsonString((String)targetContent.getLocaleValue(), Map.class);
            ILocaleString srcContent = srcResource.getContent();
            for (Map.Entry srcEntry : srcContent.entrySet()) {
                if (WfUtils.isEmpty((String)srcEntry.getValue())) continue;
                String newTargetResWords = ExtractMultiLanguageWordsUtil.getNewTargetResWords(targetResource, targetContent, targetContentMap, srcEntry);
                targetContent.setItem((String)srcEntry.getKey(), (Object)newTargetResWords);
            }
            targetResource.setContent(targetContent);
            ExtractMultiLanguageWordsUtil.getRepositoryService().saveOrUpdateEntity(targetResource);
        }
    }

    private static String getNewTargetResWords(ResourceEntity targetResource, ILocaleString targetContent, Map<String, Object> targetContentMap, Map.Entry<String, String> srcEntry) {
        String srcKey = srcEntry.getKey();
        String srcValue = srcEntry.getValue();
        String newTargetResContent = null;
        Map srcContentMap = (Map)SerializationUtils.fromJsonString((String)srcValue, Map.class);
        String lang = RequestContext.get().getLang().toString();
        if (!lang.equals(srcKey)) {
            Map<String, Object> newTargetContentMap = targetContentMap;
            Map newTargetContentData = (Map)newTargetContentMap.get("data");
            newTargetContentMap.put(LANG, srcKey);
            newTargetContentMap.put(RESOURCEID, targetResource.getId());
            Map srcContentData = (Map)srcContentMap.get("data");
            Map targetContentData = (Map)targetContentMap.get("data");
            if (srcContentData != null && targetContentData != null) {
                for (Map.Entry dataEntry : targetContentData.entrySet()) {
                    String dataKey = (String)dataEntry.getKey();
                    String srcDataValue = (String)srcContentData.get(dataKey);
                    if (WfUtils.isEmpty(srcDataValue)) continue;
                    newTargetContentData.put(dataKey, srcDataValue);
                }
            }
            newTargetContentMap.put("data", newTargetContentData);
            newTargetResContent = SerializationUtils.toJsonString(newTargetContentMap);
        } else {
            newTargetResContent = targetContent.getLocaleValue();
        }
        return newTargetResContent;
    }

    public static void repairMultiLangResWords(Long resourceId, String name, Long processId, String version) {
        ResourceEntity resourceEntity = (ResourceEntity)ExtractMultiLanguageWordsUtil.getRepositoryService().findEntityById(resourceId, "wf_resource");
        if (resourceEntity == null) {
            logger.debug(String.format("\u4fee\u590d\u591a\u8bed\u8a00\u8bcd\u6761\u8d44\u6e90\u65f6\uff0c\u6839\u636e\u8d44\u6e90Id\uff1a[%s]\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6d41\u7a0b\u8d44\u6e90\u5b9e\u4f53\uff01", resourceId));
            return;
        }
        ILocaleString content = resourceEntity.getContent();
        LocaleString newContent = new LocaleString();
        for (Map.Entry entry : content.entrySet()) {
            String lang = (String)entry.getKey();
            String resourceWords = (String)entry.getValue();
            Map resourceWordsMap = (Map)SerializationUtils.fromJsonString((String)resourceWords, Map.class);
            Map data = (Map)resourceWordsMap.get("data");
            Map<String, Object> newContentMap = ExtractMultiLanguageWordsUtil.getMultiLangResourceTemplate(resourceId, name, processId, version, lang, data);
            newContent.setItem(lang, (Object)SerializationUtils.toJsonString(newContentMap));
        }
        resourceEntity.setContent((ILocaleString)newContent);
        ExtractMultiLanguageWordsUtil.getRepositoryService().saveOrUpdateEntity(resourceEntity);
    }

    private static Map<String, List<String>> getMultiLanguageProp() {
        if (multiLanguageProp.isEmpty()) {
            ExtractMultiLanguageWordsUtil.initMultiLanguageProp();
        }
        return multiLanguageProp;
    }

    private static List<String> getBlackMultiLanguageProp() {
        if (BlackMultiLanguageProp.isEmpty()) {
            ExtractMultiLanguageWordsUtil.initBlackMultiLanguageProp();
        }
        return BlackMultiLanguageProp;
    }
}

