/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.util;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.util.StringUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.calculator.ExpressionCalculatorUtil;
import kd.bos.workflow.engine.impl.cmd.task.CRRDimenTypeConstant;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;

public class FilterDimemsionsUtils {
    private FilterDimemsionsUtils() {
    }

    public static List<Long> parseOptionData(Map<String, Object> params) {
        String entityNumber = (String)params.get("entityNumber");
        String businessKey = (String)params.get("businessKey");
        String selectType = (String)params.get("selectType");
        String parseInfo = (String)params.get("parseInfo");
        VariableScope scope = (VariableScope)params.get("scope");
        return FilterDimemsionsUtils.parseOptionData(selectType, parseInfo, businessKey, entityNumber, scope);
    }

    public static List<Long> parseOptionData(String paramsJson, String businessKey, String entityNumber, VariableScope execution) {
        JSONObject parseObject = JSONObject.parseObject((String)paramsJson);
        String selectType = (String)parseObject.get((Object)"selectType");
        String parseInfo = (String)parseObject.get((Object)"parseInfo");
        return FilterDimemsionsUtils.parseOptionData(selectType, parseInfo, businessKey, entityNumber, execution);
    }

    public static List<Long> parseOptionData(String option, String parseInfo, String businessKey, String entityNumber, VariableScope execution) {
        List<Long> dimensionIds = new ArrayList<Long>();
        if (CRRDimenTypeConstant.CONSTANT.getValue().equals(option)) {
            dimensionIds.add(Long.valueOf(parseInfo));
        } else if (CRRDimenTypeConstant.BUSINESSFIELD.getValue().equals(option)) {
            dimensionIds = FilterDimemsionsUtils.extractBusinessField(parseInfo, businessKey, entityNumber);
        } else if (CRRDimenTypeConstant.EXPRESSION.getValue().equals(option)) {
            dimensionIds = FilterDimemsionsUtils.extractExpressField(parseInfo, businessKey, entityNumber, execution);
        }
        return new ArrayList<Long>(new LinkedHashSet(dimensionIds));
    }

    public static List<Long> extractExpressField(String expressInfo, String businessKey, String entityNumber, VariableScope execution) {
        ArrayList<Long> dimensionIds = new ArrayList<Long>();
        DynamicObject dynObj = null;
        CommandContext commandContext = Context.getCommandContext();
        boolean hasFomrContext = ExpressionCalculatorUtil.fromContext(entityNumber, businessKey, commandContext);
        dynObj = hasFomrContext ? commandContext.getParsedBusinessObject() : WfUtils.findBusinessObject(businessKey, entityNumber);
        if (dynObj != null) {
            String expression = "${" + expressInfo + "}";
            Object subjectObj = ExpressionCalculatorUtil.parseValue(dynObj, execution, expression, null);
            if (subjectObj instanceof Long) {
                dimensionIds.add((Long)subjectObj);
                return dimensionIds;
            }
            if (subjectObj instanceof DynamicObject) {
                dimensionIds.add((Long)((DynamicObject)subjectObj).getPkValue());
                return dimensionIds;
            }
            if (subjectObj instanceof String) {
                String[] subjectArr;
                String subjectStr = subjectObj.toString();
                if (WfUtils.isNotEmpty(subjectStr) && (subjectArr = subjectStr.split(",")) != null && subjectArr.length != 0) {
                    for (String subject : subjectArr) {
                        if (!StringUtils.isNumeric((String)subject)) continue;
                        dimensionIds.add(Long.valueOf(subject));
                    }
                }
                return dimensionIds;
            }
            if (subjectObj instanceof MulBasedataDynamicObjectCollection) {
                for (DynamicObject v : (MulBasedataDynamicObjectCollection)subjectObj) {
                    DynamicObject basedata = v.getDynamicObject("fbasedataid");
                    if (basedata == null) continue;
                    dimensionIds.add((Long)basedata.getPkValue());
                }
            } else if (subjectObj instanceof Collection) {
                for (Object v : (Collection)subjectObj) {
                    if (v instanceof DynamicObject) {
                        dimensionIds.add((Long)((DynamicObject)v).getPkValue());
                        continue;
                    }
                    if (v instanceof String) {
                        String[] subjectArr;
                        String subjectStr = v.toString();
                        if (!WfUtils.isNotEmpty(subjectStr) || (subjectArr = subjectStr.split(",")) == null || subjectArr.length == 0) continue;
                        for (String subject : subjectArr) {
                            if (!StringUtils.isNumeric((String)subject)) continue;
                            dimensionIds.add(Long.valueOf(subject));
                        }
                        continue;
                    }
                    if (v instanceof Long) {
                        dimensionIds.add((Long)v);
                        continue;
                    }
                    if (!(v instanceof MulBasedataDynamicObjectCollection)) continue;
                    for (DynamicObject tmp : (MulBasedataDynamicObjectCollection)v) {
                        DynamicObject basedata = tmp.getDynamicObject("fbasedataid");
                        if (basedata == null) continue;
                        dimensionIds.add((Long)basedata.getPkValue());
                    }
                }
                return dimensionIds;
            }
        }
        return dimensionIds;
    }

    private static List<Long> extractBusinessField(String businessField, String businessKey, String entityNumber) {
        ArrayList<Long> businessFields;
        block5: {
            String newBusinessField;
            DynamicObjectCollection collection;
            block4: {
                Object fieldValue;
                block6: {
                    if (StringUtils.isBlank((String)businessField)) {
                        return Collections.emptyList();
                    }
                    businessFields = new ArrayList<Long>(3);
                    if (!businessField.contains("ENTI_")) break block4;
                    fieldValue = ExpressionCalculatorUtil.getFieldValue(entityNumber, businessKey, businessField);
                    if (fieldValue == null) break block5;
                    if (!(fieldValue instanceof Long)) break block6;
                    Long value = (Long)fieldValue;
                    if (WfUtils.isNotEmpty(value)) {
                        businessFields.add(value);
                    }
                    break block5;
                }
                if (!(fieldValue instanceof List)) break block5;
                businessFields.addAll((List)fieldValue);
                break block5;
            }
            if (businessField.contains("ENTRY_") && (collection = ExpressionCalculatorUtil.getEntryFieldValue(entityNumber, (newBusinessField = ExpressionCalculatorUtil.removeFieldPrefix(businessField)) + " id ", businessKey)) != null && collection.size() > 0) {
                for (DynamicObject fieldValue : collection) {
                    Long value = (Long)fieldValue.get("id");
                    businessFields.add(value);
                }
            }
        }
        return businessFields;
    }

    public static List<Object> parseOptionObjectData(String paramsJson, String businessKey, String entityNumber, VariableScope execution) {
        JSONObject parseObject = JSONObject.parseObject((String)paramsJson);
        String selectType = (String)parseObject.get((Object)"selectType");
        String parseInfo = (String)parseObject.get((Object)"parseInfo");
        return FilterDimemsionsUtils.parseOptionObjectData(selectType, parseInfo, businessKey, entityNumber, execution);
    }

    private static List<Object> parseOptionObjectData(String option, String parseInfo, String businessKey, String entityNumber, VariableScope execution) {
        List<Object> dimensionIds = new ArrayList<Object>(1);
        if (CRRDimenTypeConstant.CONSTANT.getValue().equals(option)) {
            dimensionIds.add(parseInfo);
        } else if (CRRDimenTypeConstant.BUSINESSFIELD.getValue().equals(option)) {
            dimensionIds = FilterDimemsionsUtils.extractObjectBusinessField(parseInfo, businessKey, entityNumber);
        } else if (CRRDimenTypeConstant.EXPRESSION.getValue().equals(option)) {
            dimensionIds = FilterDimemsionsUtils.extractObjectExpressField(parseInfo, businessKey, entityNumber, execution);
        }
        return dimensionIds;
    }

    private static List<Object> extractObjectExpressField(String expressInfo, String businessKey, String entityNumber, VariableScope execution) {
        ArrayList<Object> dimensionIds = new ArrayList<Object>();
        DynamicObject dynObj = null;
        CommandContext commandContext = Context.getCommandContext();
        boolean hasFomrContext = ExpressionCalculatorUtil.fromContext(entityNumber, businessKey, commandContext);
        dynObj = hasFomrContext ? commandContext.getParsedBusinessObject() : WfUtils.findBusinessObject(businessKey, entityNumber);
        if (dynObj != null) {
            String expression = "${" + expressInfo + "}";
            Object subjectObj = ExpressionCalculatorUtil.parseValue(dynObj, execution, expression, null);
            if (subjectObj instanceof DynamicObject) {
                dimensionIds.add(((DynamicObject)subjectObj).getPkValue());
                return dimensionIds;
            }
            if (subjectObj instanceof String) {
                String[] subjectArr;
                String subjectStr = subjectObj.toString();
                if (WfUtils.isNotEmpty(subjectStr) && (subjectArr = subjectStr.split(",")) != null && subjectArr.length != 0) {
                    for (String subject : subjectArr) {
                        if (!StringUtils.isNumeric((String)subject)) continue;
                        dimensionIds.add(subject);
                    }
                }
                return dimensionIds;
            }
            if (subjectObj instanceof MulBasedataDynamicObjectCollection) {
                for (DynamicObject v : (MulBasedataDynamicObjectCollection)subjectObj) {
                    DynamicObject basedata = v.getDynamicObject("fbasedataid");
                    if (basedata == null) continue;
                    dimensionIds.add(basedata.getPkValue());
                }
            } else if (subjectObj instanceof Collection) {
                for (Object v : (Collection)subjectObj) {
                    if (v instanceof DynamicObject) {
                        dimensionIds.add(((DynamicObject)v).getPkValue());
                        continue;
                    }
                    if (v instanceof String) {
                        String[] subjectArr;
                        String subjectStr = v.toString();
                        if (!WfUtils.isNotEmpty(subjectStr) || (subjectArr = subjectStr.split(",")) == null || subjectArr.length == 0) continue;
                        for (String subject : subjectArr) {
                            if (!StringUtils.isNumeric((String)subject)) continue;
                            dimensionIds.add(subject);
                        }
                        continue;
                    }
                    if (!(v instanceof MulBasedataDynamicObjectCollection)) continue;
                    for (DynamicObject dObject : (MulBasedataDynamicObjectCollection)v) {
                        DynamicObject basedata = dObject.getDynamicObject("fbasedataid");
                        if (basedata == null) continue;
                        dimensionIds.add(basedata.getPkValue());
                    }
                }
                return dimensionIds;
            }
        }
        return dimensionIds;
    }

    private static List<Object> extractObjectBusinessField(String businessField, String businessKey, String entityNumber) {
        String newBusinessField;
        DynamicObjectCollection collection;
        if (StringUtils.isBlank((String)businessField)) {
            return Collections.emptyList();
        }
        ArrayList<Object> businessFields = new ArrayList<Object>(3);
        if (businessField.contains("ENTI_")) {
            Object fieldValue = ExpressionCalculatorUtil.getFieldValue(entityNumber, businessKey, businessField);
            if (fieldValue != null) {
                if (fieldValue instanceof List) {
                    businessFields.addAll((List)fieldValue);
                } else {
                    businessFields.add(fieldValue);
                }
            }
        } else if (businessField.contains("ENTRY_") && (collection = ExpressionCalculatorUtil.getEntryFieldValue(entityNumber, (newBusinessField = ExpressionCalculatorUtil.removeFieldPrefix(businessField)) + " id ", businessKey)) != null && collection.size() > 0) {
            for (DynamicObject fieldValue : collection) {
                businessFields.add(fieldValue.get("id"));
            }
        }
        return businessFields;
    }
}

