/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.converter.util.ModelConfigUtil;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordItem;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.extitf.ExtItfCallerType;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.util.CoordinateRecordUtil;

public class FlowRecordUtil {
    private static Log log = LogFactory.getLog(FlowRecordUtil.class);

    public static List<IApprovalRecordItem> executeFormatPlugin(Process process, List<IApprovalRecordItem> items) {
        LinkedHashMap<String, ArrayList<IApprovalRecordItem>> groups = new LinkedHashMap<String, ArrayList<IApprovalRecordItem>>(items == null ? 16 : items.size());
        HashMap<String, String> typeMap = new HashMap<String, String>();
        ArrayList<IApprovalRecordItem> fmtItems = new ArrayList<IApprovalRecordItem>();
        if (items != null && !items.isEmpty()) {
            for (IApprovalRecordItem item : items) {
                String groupId;
                String string = groupId = WfUtils.isNotEmpty(item.getGroupId()) ? item.getGroupId() : item.getTaskId();
                if (WfUtils.isEmpty(groupId)) {
                    fmtItems.add(item);
                    continue;
                }
                ArrayList<IApprovalRecordItem> group = (ArrayList<IApprovalRecordItem>)groups.get(groupId);
                if (group == null) {
                    group = new ArrayList<IApprovalRecordItem>();
                }
                group.add(item);
                groups.put(groupId, group);
                if (typeMap.get(groupId) != null) continue;
                typeMap.put(groupId, process.getFlowElement(item.getActivityId()).getType());
            }
        }
        CommandContext commandContext = Context.getCommandContext();
        Map<String, Map<String, UserTask>> configCache = commandContext.getProcessEngineConfiguration().getDynModelConfigCache();
        for (Map.Entry entry : groups.entrySet()) {
            String type = (String)typeMap.get(entry.getKey());
            String formatter = ModelConfigUtil.getFormatRecordsPlugin(type, configCache);
            if (WfUtils.isNotEmpty(formatter)) {
                List ret = (List)ExternalInterfaceUtil.executeExtItf(ExtItfCallerType.FORMATFLOWRECORDS, formatter, entry.getValue());
                fmtItems.addAll(ret);
                continue;
            }
            fmtItems.addAll((Collection)entry.getValue());
        }
        for (IApprovalRecordItem item : fmtItems) {
            FlowRecordUtil.executeFormatPlugin(process, item);
        }
        return fmtItems;
    }

    public static IApprovalRecordItem executeFormatPlugin(Process process, IApprovalRecordItem item) {
        FlowElement element = process.getFlowElement(item.getActivityId());
        if (element instanceof UserTask) {
            FlowRecordUtil.setCommentId(item);
            FlowRecordUtil.executeFormatPlugin(process.getFlowRecordFormatter(), ((UserTask)element).getFlowRecordFormatter(), item);
        } else if (element instanceof CallActivity) {
            FlowRecordUtil.executeFormatPlugin(process.getFlowRecordFormatter(), element.getAttributeValue("flowRecordFormatter"), item);
        }
        return item;
    }

    public static IApprovalRecordItem executeFormatPlugin(String processFmt, String nodeFmt, IApprovalRecordItem item) {
        String extItf = WfUtils.isEmpty(nodeFmt) ? processFmt : nodeFmt;
        log.debug("--begin execute formatPlugin: " + extItf);
        if (WfUtils.isEmpty(extItf)) {
            log.debug("--Formater is null, return the item!");
            return item;
        }
        FlowRecordUtil.setCommentId(item);
        return (IApprovalRecordItem)ExternalInterfaceUtil.executeExtItf(ExtItfCallerType.FORMATFLOWRECORD, extItf, item);
    }

    private static void setCommentId(IApprovalRecordItem item) {
        if (WfUtils.isEmpty(item.getCommentId())) {
            item.setCommentId(String.format("%s%s", item.getTaskId() != null ? item.getTaskId() : "", item.getUserStr() != null ? item.getUserStr() : ""));
        }
    }

    public static Map<String, Object> getProcessAttachmentInfo(Long procInstId, Long taskId, String commentId) {
        HashMap<String, Object> attachmentInfo = new HashMap<String, Object>();
        StringBuilder attachmentIds = new StringBuilder();
        StringBuilder sql = new StringBuilder();
        sql.append("select furlid attachmentId from t_wf_hiattachment ");
        sql.append("where fprocinstid = ? and ftaskid = ? and fcontentid=? and fuserid != 1 ");
        sql.append("order by fcreatedate desc");
        Object[] params = new Object[]{procInstId, taskId, WfUtils.isEmpty(commentId) ? 0L : Long.parseLong(commentId)};
        try (DataSet ds = DB.queryDataSet((String)"getProcessAttachment", (DBRoute)WfUtils.WFS, (String)sql.toString(), (Object[])params);){
            for (Row r : ds) {
                attachmentIds.append(r.getLong("attachmentId")).append(",");
            }
        }
        attachmentInfo.put("attachmentIds", attachmentIds.toString());
        attachmentInfo.put("attachments", CoordinateRecordUtil.getApprovalAttachments(attachmentIds.toString()));
        return attachmentInfo;
    }
}

