/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.utils.StringUtils;

public class FormatParsedConditionUtil {
    private static final String REGEX = "(?<=\\$\\{)(.*?)(?=\\})";
    private static final String SPLITTER = "(?=(&&|\\|\\|))";
    private static final int SIZE = 0;

    public static List<String> format(String parsedCondition) {
        if (StringUtils.isEmpty((CharSequence)parsedCondition)) {
            return new ArrayList<String>(0);
        }
        Pattern compile = Pattern.compile(REGEX);
        Matcher matcher = compile.matcher(parsedCondition);
        if (!matcher.find()) {
            return new ArrayList<String>();
        }
        String group = matcher.group();
        String[] split = group.split(SPLITTER);
        ArrayList<ParserData> parserDataLists = new ArrayList<ParserData>(split.length);
        int min = 0;
        int formatSize = 0;
        for (String s : split) {
            String trim = s.trim();
            ParserData parserData = new ParserData(trim);
            int index = FormatParsedConditionUtil.findFirstLetterIndex(trim);
            parserData.setFirstLetterIndex(index);
            int paddingSize = 0 - index;
            if (paddingSize < min) {
                min = paddingSize;
            }
            parserData.setPaddingSize(paddingSize);
            parserDataLists.add(parserData);
        }
        if (min < 0) {
            formatSize = -min;
        }
        ArrayList<String> result = new ArrayList<String>(split.length);
        for (ParserData item : parserDataLists) {
            char[] padding = new char[item.getPaddingSize() + formatSize];
            Arrays.fill(padding, ' ');
            StringBuilder sb = new StringBuilder(item.getData());
            sb.insert(item.getFirstLetterIndex(), padding);
            result.add(sb.toString());
        }
        return result;
    }

    private static int findFirstLetterIndex(String s) {
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '$') && c != '_') continue;
            return i;
        }
        return 0;
    }

    private static class ParserData {
        private String data;
        private int firstLetterIndex;
        private int paddingSize;

        public ParserData(String data) {
            this.data = data;
        }

        public String getData() {
            return this.data;
        }

        public void setData(String data) {
            this.data = data;
        }

        public int getFirstLetterIndex() {
            return this.firstLetterIndex;
        }

        public void setFirstLetterIndex(int firstLetterIndex) {
            this.firstLetterIndex = firstLetterIndex;
        }

        public int getPaddingSize() {
            return this.paddingSize;
        }

        public void setPaddingSize(int paddingSize) {
            this.paddingSize = paddingSize;
        }
    }
}

