/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.api.IWorkflowService;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.bpmn.converter.BpmnJsonConverter;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.bpmn.model.AuditComment;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.AutoTask;
import kd.bos.workflow.bpmn.model.BillSetting;
import kd.bos.workflow.bpmn.model.BillTask;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.BroadcastTask;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.WaitTask;
import kd.bos.workflow.engine.WfRoleDimensionUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.bpmn.deployer.VersionUtils;
import kd.bos.workflow.engine.impl.calculator.RoleDimension;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.design.ProcessCategoryEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ProcessCategoryEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceRelationEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceRelationEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.KeyAuditorEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.RoleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.proctpl.ProcTemplateEntity;
import kd.bos.workflow.engine.impl.util.BillSummaryType;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.math.NumberUtils;

public class ImportExportProcessUtil {
    private static Log logger = LogFactory.getLog(ImportExportProcessUtil.class);
    private static final String MULTILANGUAGETEXT = "multilanguagetext";
    private static final String IDNUMBER = "id,number";
    private static final String NUMBER = "number";
    private static final String NUMBERDIMENSION = "numberdimension";
    private static final String DIMENSION = "dimension";
    private static final String MULILANGDIMENSION = "mulilangdimension";

    public static ProcessCategoryEntity insertProcessCategoryIfNeed(CommandContext commandContext, List<DynamicObject> categories) {
        DynamicObject appDynamicObject;
        DynamicObject cloudDynamicObject;
        Long rootCategoryId = 10000L;
        ProcessCategoryEntity rootCategory = (ProcessCategoryEntity)commandContext.getProcessCategoryEntityManager().findById(rootCategoryId);
        if (categories == null || categories.isEmpty()) {
            logger.warn("\u7c7b\u522b\u4fe1\u606f\u4e3a\u7a7a\u6216\u6761\u76ee\u4e0d\u7b26\uff0c\u9ed8\u8ba4\u8fd4\u56de\u6839\u7c7b\u522b\uff01");
            return rootCategory;
        }
        String cloudFormId = "bos_devportal_bizcloud";
        String appFormId = "bos_devportal_bizapp";
        if (categories.size() == 1) {
            String applicationId = categories.get(0).getString("applicationid");
            if (WfUtils.isEmpty(applicationId) || "0".equals(applicationId)) {
                logger.debug("\u7c7b\u522b\u7684\u5e94\u7528ID\u4e3a\u7a7a\uff0c\u9ed8\u8ba4\u5bfc\u5165\u5230\u6839\u7c7b\u522b\u8282\u70b9\u4e0b\uff01");
                return rootCategory;
            }
            if (!QueryServiceHelper.exists((String)"bos_devportal_bizcloud", (Object)applicationId)) {
                logger.debug(String.format("\u4e0d\u5b58\u5728ID\u4e3a %s \u7684\u4e91\uff0c\u9ed8\u8ba4\u5bfc\u5165\u5230\u6839\u7c7b\u522b\u8282\u70b9\u4e0b\uff01", applicationId));
                return rootCategory;
            }
            ProcessCategoryEntity category = ImportExportProcessUtil.getProcateByApplicationId(commandContext, applicationId);
            if (category == null) {
                return ImportExportProcessUtil.insertProcessCategory(commandContext, categories.get(0));
            }
            return category;
        }
        if (categories.get(0).getBoolean("isleaf")) {
            cloudDynamicObject = categories.get(1);
            appDynamicObject = categories.get(0);
        } else {
            cloudDynamicObject = categories.get(0);
            appDynamicObject = categories.get(1);
        }
        String cloudId = cloudDynamicObject.getString("applicationid");
        String applicationId = appDynamicObject.getString("applicationid");
        if (!QueryServiceHelper.exists((String)"bos_devportal_bizcloud", (Object)cloudId)) {
            return rootCategory;
        }
        ProcessCategoryEntity cloudCategory = ImportExportProcessUtil.getProcateByApplicationId(commandContext, cloudId);
        if (cloudCategory == null) {
            cloudCategory = ImportExportProcessUtil.insertProcessCategory(commandContext, cloudDynamicObject);
        }
        if (!QueryServiceHelper.exists((String)"bos_devportal_bizapp", (Object)applicationId)) {
            return cloudCategory;
        }
        ProcessCategoryEntity appCategory = ImportExportProcessUtil.getProcateByApplicationId(commandContext, applicationId);
        if (appCategory == null) {
            appDynamicObject.set("parentid", (Object)cloudCategory.getId());
            appDynamicObject.set("id", null);
            DynamicObjectCollection multilangCols = appDynamicObject.getDynamicObjectCollection(MULTILANGUAGETEXT);
            if (multilangCols != null) {
                for (DynamicObject multilang : multilangCols) {
                    multilang.set("pkid", null);
                    multilang.getDataEntityState().setDirty(true);
                }
            }
            appCategory = ImportExportProcessUtil.insertProcessCategory(commandContext, appDynamicObject);
        }
        return appCategory;
    }

    private static ProcessCategoryEntity getProcateByApplicationId(CommandContext commandContext, String applicationId) {
        return commandContext.getProcessCategoryEntityManager().getProcessCategoryByApplicationId(applicationId);
    }

    private static ProcessCategoryEntity insertProcessCategory(CommandContext commandContext, DynamicObject category) {
        ProcessCategoryEntityImpl entity = new ProcessCategoryEntityImpl();
        entity.setILocaleStringName(category.getLocaleString("name"));
        entity.setNumber(category.getString(NUMBER));
        entity.setDescription(category.getString("description"));
        entity.setLeaf(category.getBoolean("isleaf"));
        entity.setApplicationId(category.getString("applicationid"));
        entity.setParentId(category.getLong("parentid"));
        entity.setProcessType(category.getString("processtype"));
        commandContext.getProcessCategoryEntityManager().insert(entity);
        return entity;
    }

    public static void insertKeyAuditors(CommandContext commandContext, List<DynamicObject> keyAuditors) {
        if (keyAuditors == null || keyAuditors.isEmpty()) {
            return;
        }
        for (DynamicObject keyAuditor : keyAuditors) {
            boolean exist = QueryServiceHelper.exists((String)"wf_keyauditor", (QFilter[])new QFilter[]{new QFilter("id", "=", keyAuditor.get("id"))});
            if (exist) continue;
            KeyAuditorEntity keyAuditorEntity = (KeyAuditorEntity)commandContext.getKeyAuditorEntityManager().create();
            keyAuditorEntity.setId(keyAuditor.getLong("id"));
            keyAuditorEntity.setNumber(keyAuditor.getString(NUMBER));
            keyAuditorEntity.setName(keyAuditor.getLocaleString("name"));
            keyAuditorEntity.setOrgUnit(RequestContext.get().getOrgId());
            keyAuditorEntity.setCreateDate(Context.getProcessEngineConfiguration().getClock().getCurrentTime());
            keyAuditorEntity.setModifyDate(Context.getProcessEngineConfiguration().getClock().getCurrentTime());
            keyAuditorEntity.setDescription(keyAuditor.getLocaleString("description"));
            commandContext.getKeyAuditorEntityManager().insert(keyAuditorEntity);
            DynamicObjectCollection roleentryCols = keyAuditor.getDynamicObjectCollection("keyauditor");
            if (roleentryCols != null) {
                for (DynamicObject roleentry : roleentryCols) {
                    roleentry.getDataEntityState().setDirty(true);
                }
            }
            keyAuditorEntity.setKeyAudit(keyAuditor.getDynamicObjectCollection("keyauditor"));
        }
    }

    public static void insertRoles(CommandContext commandContext, List<DynamicObject> roles) {
        if (roles == null || roles.isEmpty()) {
            return;
        }
        for (DynamicObject role : roles) {
            boolean exist = QueryServiceHelper.exists((String)"wf_role", (QFilter[])new QFilter[]{new QFilter("id", "=", role.get("id"))});
            if (exist) continue;
            RoleEntity roleEntity = (RoleEntity)commandContext.getRoleEntityManager().create();
            String roleDimension = role.getString("roledimension");
            roleEntity.setId(role.getLong("id"));
            roleEntity.setNumber(role.getString(NUMBER));
            roleEntity.setName(role.getString("name"));
            roleEntity.setRoleDimension(role.getString("roledimension"));
            roleEntity.setOrgUnit(RequestContext.get().getOrgId());
            roleEntity.setManager(RequestContext.get().getCurrUserId());
            roleEntity.setCreateDate(Context.getProcessEngineConfiguration().getClock().getCurrentTime());
            roleEntity.setModifyDate(Context.getProcessEngineConfiguration().getClock().getCurrentTime());
            roleEntity.setUseCount(0);
            roleEntity.setDescription(role.getString("description"));
            roleEntity.setRoleType(Optional.ofNullable(role.getString("roleType")).orElseGet(() -> "user"));
            DynamicObjectCollection roleentryCols = role.getDynamicObjectCollection("roleentry");
            if (WfUtils.isNotEmpty(roleDimension) && roleentryCols != null) {
                Map<String, Object> dimensionInfos = WfRoleDimensionUtil.getDimensionInfos(roleDimension);
                List rdList = (List)dimensionInfos.get("dimensions");
                for (RoleDimension rd : rdList) {
                    ImportExportProcessUtil.refreshSingleDimension(rd, roleentryCols);
                }
            }
            if (roleentryCols != null) {
                for (DynamicObject roleentry : roleentryCols) {
                    DynamicObjectCollection multilangCols;
                    roleentry.set("id", null);
                    if (WfUtils.isEmpty(roleentry.getString("functiontype"))) {
                        roleentry.set("functiontype", (Object)"1");
                    }
                    if ((multilangCols = roleentry.getDynamicObjectCollection(MULTILANGUAGETEXT)) != null) {
                        for (DynamicObject multilang : multilangCols) {
                            multilang.getDataEntityState().setDirty(true);
                        }
                    }
                    roleentry.getDataEntityState().setDirty(true);
                }
                roleEntity.setRoleEntry(roleentryCols);
            }
            commandContext.getRoleEntityManager().insert(roleEntity);
        }
    }

    private static void refreshSingleDimension(RoleDimension rd, DynamicObjectCollection roleentry) {
        int count = roleentry.size();
        String index = rd.getIndex();
        char dimensionIndex = index.charAt(index.length() - 1);
        HashMap<String, List<Integer>> numberMap = new HashMap<String, List<Integer>>();
        for (int i = 0; i < count; ++i) {
            DynamicObject role = (DynamicObject)roleentry.get(i);
            String numberDimension = role.getString(NUMBERDIMENSION + dimensionIndex);
            if (WfUtils.isNotEmpty(numberDimension)) {
                List<Integer> indexList = numberMap.containsKey(numberDimension) ? (List)numberMap.get(numberDimension) : new ArrayList(1);
                indexList.add(i);
                numberMap.put(numberDimension, indexList);
                continue;
            }
            role.set(DIMENSION + dimensionIndex, null);
            role.set(MULILANGDIMENSION + dimensionIndex, null);
        }
        ImportExportProcessUtil.refreshSingleDimensionValue(rd, numberMap, roleentry);
    }

    private static void refreshSingleDimensionValue(RoleDimension rd, Map<String, List<Integer>> numberMap, DynamicObjectCollection roleentry) {
        if (numberMap.isEmpty()) {
            return;
        }
        String entityNumber = rd.getEntityNumber();
        String index = rd.getIndex();
        char dimensionIndex = index.charAt(index.length() - 1);
        DynamicObject dynObject = WfRoleDimensionUtil.getObjectType(entityNumber);
        if (WfUtils.isNullObject(dynObject)) {
            for (List<Integer> value : numberMap.values()) {
                for (int i : value) {
                    DynamicObject role = (DynamicObject)roleentry.get(i);
                    role.set(DIMENSION + dimensionIndex, null);
                    role.set(NUMBERDIMENSION + dimensionIndex, null);
                    role.set(MULILANGDIMENSION + dimensionIndex, null);
                }
            }
        } else {
            BasedataEntityType basedataEntityTaype = (BasedataEntityType)dynObject.getDataEntityType();
            String numberProperty = basedataEntityTaype.getNumberProperty();
            String nameProperty = basedataEntityTaype.getNameProperty();
            QFilter qFilter = new QFilter(numberProperty, "in", numberMap.keySet());
            DynamicObject[] dimensionDymObject = BusinessDataServiceHelper.load((String)entityNumber, (String)String.format("%s,%s", numberProperty, nameProperty), (QFilter[])new QFilter[]{qFilter});
            for (DynamicObject obj : dimensionDymObject) {
                Object pkValue = obj.getPkValue();
                Object number = obj.get(numberProperty);
                ILocaleString name = obj.getLocaleString(nameProperty);
                if (!numberMap.containsKey(number)) continue;
                List<Integer> list = numberMap.get(number);
                for (int i : list) {
                    DynamicObject role = (DynamicObject)roleentry.get(i);
                    role.set(DIMENSION + dimensionIndex, pkValue);
                    role.set(NUMBERDIMENSION + dimensionIndex, number);
                    role.set(MULILANGDIMENSION + dimensionIndex, (Object)name);
                }
                numberMap.remove(number);
            }
            for (List list : numberMap.values()) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    DynamicObject role = (DynamicObject)roleentry.get(i);
                    role.set(DIMENSION + dimensionIndex, null);
                    role.set(NUMBERDIMENSION + dimensionIndex, null);
                    role.set(MULILANGDIMENSION + dimensionIndex, null);
                }
            }
        }
    }

    public static void insertMobileBillSummaryCfg(Boolean isCoverSummaryCfg, List<DynamicObject> mobileBillSummaryCfgs) {
        List<Object> mobileBillSummaryCfgPks;
        if (mobileBillSummaryCfgs == null || mobileBillSummaryCfgs.isEmpty()) {
            return;
        }
        if (isCoverSummaryCfg != null && !isCoverSummaryCfg.booleanValue()) {
            return;
        }
        if (isCoverSummaryCfg != null && isCoverSummaryCfg.booleanValue() && !(mobileBillSummaryCfgPks = ImportExportProcessUtil.getMobileBillSummaryCfgPks(mobileBillSummaryCfgs)).isEmpty()) {
            DeleteServiceHelper.delete((IDataEntityType)mobileBillSummaryCfgs.get(0).getDataEntityType(), (Object[])mobileBillSummaryCfgPks.toArray());
        }
        ImportExportProcessUtil.insertCommonBaseData(mobileBillSummaryCfgs, "wf_mbillsummary_cfg", true, true, true, "entryentity");
        ImportExportProcessUtil.rebuildBillSummaryConfigRuntimeMeta(mobileBillSummaryCfgs);
    }

    private static List<Object> getMobileBillSummaryCfgPks(List<DynamicObject> mobileBillSummaryCfgs) {
        ArrayList<Object> mobileBillSummaryCfgPks = new ArrayList<Object>(mobileBillSummaryCfgs.size());
        for (DynamicObject mobileBillSummaryCfg : mobileBillSummaryCfgs) {
            String summaryNumber = mobileBillSummaryCfg.getString(NUMBER);
            QFilter[] filters = new QFilter[]{new QFilter(NUMBER, "=", (Object)summaryNumber)};
            List primaryKeys = QueryServiceHelper.queryPrimaryKeys((String)"wf_mbillsummary_cfg", (QFilter[])filters, null, (int)20);
            mobileBillSummaryCfgPks.addAll(primaryKeys);
        }
        return mobileBillSummaryCfgPks;
    }

    private static void rebuildBillSummaryConfigRuntimeMeta(List<DynamicObject> mobileBillSummaryCfgs) {
        IWorkflowService wfService = (IWorkflowService)ServiceFactory.getService(IWorkflowService.class);
        for (DynamicObject mobileBillSummaryCfg : mobileBillSummaryCfgs) {
            if (!BillSummaryType.mobileSummary.name().equals(mobileBillSummaryCfg.get("scene"))) continue;
            wfService.rebuildBillSummaryConfigRuntimeMeta(mobileBillSummaryCfg);
        }
    }

    public static void insertCommonAuditComment(List<DynamicObject> commonAudits, String entityNumber, boolean hasMultiLangText, boolean hasEntryEntity, boolean hasEntryEntityMultiLangText, String entryEntityName) {
        if (commonAudits != null && !commonAudits.isEmpty()) {
            for (DynamicObject dynamicObject : commonAudits) {
                String decisionType = dynamicObject.getString("decisiontype");
                String status = dynamicObject.getString("status");
                if (WfUtils.isEmpty(decisionType)) {
                    dynamicObject.set("decisiontype", (Object)"approve");
                }
                if ("C".equals(status)) continue;
                dynamicObject.set("status", (Object)"C");
            }
        }
        ImportExportProcessUtil.insertCommonBaseData(commonAudits, entityNumber, hasMultiLangText, hasEntryEntity, hasEntryEntityMultiLangText, entryEntityName);
    }

    public static void insertCommonBaseData(List<DynamicObject> dynamicObjects, String entityNumber, boolean hasMultiLangText, boolean hasEntryEntity, boolean hasEntryEntityMultiLangText, String entryEntityName) {
        if (dynamicObjects == null || dynamicObjects.isEmpty()) {
            return;
        }
        ImportExportProcessUtil.removeExist(dynamicObjects, entityNumber);
        if (dynamicObjects.isEmpty()) {
            return;
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObjectCollection entryentityCols;
            DynamicObjectCollection multilangCols;
            dynamicObject.getDataEntityState().setDirty(true);
            if (hasMultiLangText && (multilangCols = dynamicObject.getDynamicObjectCollection(MULTILANGUAGETEXT)) != null) {
                for (DynamicObject multilang : multilangCols) {
                    multilang.getDataEntityState().setDirty(true);
                }
            }
            if (!hasEntryEntity || (entryentityCols = dynamicObject.getDynamicObjectCollection(entryEntityName)) == null) continue;
            for (DynamicObject entryentity : entryentityCols) {
                DynamicObjectCollection entryentityMultilangCols;
                entryentity.getDataEntityState().setDirty(true);
                if (!hasEntryEntityMultiLangText || (entryentityMultilangCols = entryentity.getDynamicObjectCollection(MULTILANGUAGETEXT)) == null) continue;
                for (DynamicObject entryentityMultilang : entryentityMultilangCols) {
                    entryentityMultilang.getDataEntityState().setDirty(true);
                }
            }
        }
        SaveServiceHelper.save((IDataEntityType)dynamicObjects.get(0).getDataEntityType(), (Object[])dynamicObjects.toArray());
    }

    private static void removeExist(List<DynamicObject> dynamicObjects, String entityNumber) {
        Iterator<DynamicObject> iterator = dynamicObjects.iterator();
        while (iterator.hasNext()) {
            DynamicObject dynamicObject = iterator.next();
            Long id = dynamicObject.getLong("id");
            boolean exist = QueryServiceHelper.exists((String)entityNumber, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
            if (!exist) continue;
            iterator.remove();
        }
    }

    public static void insertOrUpdateResRelation(DynamicObject dynamicObject, Long originalResourceId, ModelEntity newModel, Long newProcdefId, Long newResourceId, boolean isCover) {
        QFilter versionQFilter;
        List resRelations;
        String newVersion = "";
        Long newModelId = 0L;
        if (newModel != null) {
            newVersion = newModel.getVersion();
            newModelId = newModel.getId();
        }
        ResourceRelationEntityManager relationEntityManager = Context.getCommandContext().getResourceRelationEntityManager();
        QFilter oriResIdQFilter = new QFilter("originalresourceid", "=", (Object)originalResourceId);
        String procNumber = dynamicObject.getString("key");
        QFilter numberQFilter = new QFilter("procnumber", "=", (Object)procNumber);
        String originalVersion = dynamicObject.getString("version");
        Long originalModelId = dynamicObject.getLong("id");
        Long originalProcdefId = 0L;
        if ("wf_processdefinition".equals(dynamicObject.getDataEntityType().getName())) {
            originalVersion = VersionUtils.getNextVersion(originalVersion);
            originalModelId = dynamicObject.getLong("modelid");
            originalProcdefId = dynamicObject.getLong("id");
        }
        if ((resRelations = relationEntityManager.findByQueryFilters(new QFilter[]{oriResIdQFilter, numberQFilter, versionQFilter = new QFilter("originalversion", "=", (Object)originalVersion)})) != null && !resRelations.isEmpty() && isCover) {
            ResourceRelationEntity resRelation = (ResourceRelationEntity)resRelations.get(0);
            resRelation.setNewVersion(newVersion);
            resRelation.setNewModelId(newModelId);
            resRelation.setNewProcdefId(newProcdefId);
            resRelation.setNewResourceId(newResourceId);
            relationEntityManager.update(resRelation);
        } else {
            ResourceRelationEntity relationEntity = (ResourceRelationEntity)relationEntityManager.create();
            relationEntity.setId(null);
            relationEntity.setProcNumber(procNumber);
            relationEntity.setOriginalVersion(originalVersion);
            relationEntity.setOriginalModelId(originalModelId);
            relationEntity.setOriginalProcdefId(originalProcdefId);
            relationEntity.setOriginalResourceId(originalResourceId);
            relationEntity.setNewVersion(newVersion);
            relationEntity.setNewModelId(newModelId);
            relationEntity.setNewProcdefId(newProcdefId);
            relationEntity.setNewResourceId(newResourceId);
            relationEntityManager.insert(relationEntity);
        }
    }

    public static void insertOrUpdateResRelation(DynamicObject dynamicObject, Long originalResourceId, ProcTemplateEntity newTemplate, Long newResourceId, boolean isCover) {
        Long newModelId = WfUtils.isNullObject(newTemplate) ? NumberUtils.LONG_ZERO : newTemplate.getId();
        CommandContext commandContext = Context.getCommandContext();
        if (WfUtils.isNullObject(commandContext)) {
            return;
        }
        ResourceRelationEntityManager relationEntityManager = commandContext.getResourceRelationEntityManager();
        QFilter oriResIdQFilter = new QFilter("originalresourceid", "=", (Object)originalResourceId);
        String procNumber = dynamicObject.getString(NUMBER);
        QFilter numberQFilter = new QFilter("procnumber", "=", (Object)procNumber);
        long originalModelId = dynamicObject.getLong("id");
        List resRelations = relationEntityManager.findByQueryFilters(new QFilter[]{oriResIdQFilter, numberQFilter});
        if (WfUtils.isEmptyForCollection(resRelations) || BooleanUtils.isFalse((Boolean)isCover)) {
            ResourceRelationEntity relationEntity = (ResourceRelationEntity)relationEntityManager.create();
            relationEntity.setId(null);
            relationEntity.setProcNumber(procNumber);
            relationEntity.setOriginalModelId(originalModelId);
            relationEntity.setOriginalResourceId(originalResourceId);
            relationEntity.setNewModelId(newModelId);
            relationEntity.setNewResourceId(newResourceId);
            relationEntityManager.insert(relationEntity);
        } else {
            ResourceRelationEntity resRelation = (ResourceRelationEntity)resRelations.get(NumberUtils.INTEGER_ZERO);
            resRelation.setNewModelId(newModelId);
            resRelation.setNewResourceId(newResourceId);
            relationEntityManager.update(resRelation);
        }
    }

    public static void loadBaseDataForModel(String entityNumber, String data, boolean hasIdOnBpmbJson, String numberPrefix, List<DynamicObject> lists) {
        Set<Long> ids = ImportExportProcessUtil.matchesBasedataPkIds(entityNumber, data, hasIdOnBpmbJson, numberPrefix);
        ImportExportProcessUtil.addDynamicObjects(entityNumber, lists, ids);
    }

    public static void loadBaseDataForScheme(String entityNumber, DynamicObject[] resources, DynamicObject[] conditionalRules, boolean hasIdOnBpmnJson, String numberPrefix, List<DynamicObject> lists) {
        HashSet<Long> ids = new HashSet<Long>();
        for (DynamicObject resource : resources) {
            String data = resource.getString("data");
            if (WfUtils.isEmpty(data)) continue;
            ids.addAll(ImportExportProcessUtil.matchesBasedataPkIds(entityNumber, data, hasIdOnBpmnJson, numberPrefix));
        }
        for (DynamicObject conditionalRule : conditionalRules) {
            String expression = conditionalRule.getString("expression");
            ids.addAll(ImportExportProcessUtil.matchesBasedataPkIds(entityNumber, expression, hasIdOnBpmnJson, numberPrefix));
        }
        if (ids.isEmpty()) {
            return;
        }
        ImportExportProcessUtil.addDynamicObjects(entityNumber, lists, ids);
    }

    private static Set<Long> matchesBasedataPkIds(String entityNumber, String data, boolean hasIdOnBpmnJson, String numberPrefix) {
        HashSet<Long> ids = new HashSet<Long>();
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)entityNumber, (String)IDNUMBER, null);
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                Long pkId = (Long)dynamicObject.getPkValue();
                if (hasIdOnBpmnJson) {
                    if (data.indexOf(String.valueOf(pkId)) <= -1) continue;
                    ids.add(pkId);
                    continue;
                }
                String number = dynamicObject.getString(NUMBER);
                if (!number.startsWith(numberPrefix) || data.indexOf(number) <= -1) continue;
                ids.add(pkId);
            }
        }
        return ids;
    }

    public static void loadMobileBillSummaryForModel(String entityNumber, String data, List<DynamicObject> lists) {
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(data);
        Set<Long> ids = ImportExportProcessUtil.findIdsWhenMatchForBillSummary(entityNumber, bpmnModel);
        ImportExportProcessUtil.addDynamicObjects(entityNumber, lists, ids);
    }

    public static Set<Long> loadCommonAuditCommentForModel(String entityNumber, String data, List<DynamicObject> lists) {
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(data);
        Set<Long> ids = ImportExportProcessUtil.findIdsWhenMatchForAuditComment(entityNumber, bpmnModel);
        ImportExportProcessUtil.addDynamicObjects(entityNumber, lists, ids);
        return ids;
    }

    public static void loadMobileBillSummaryForScheme(String entityNumber, DynamicObject[] resources, List<DynamicObject> lists) {
        HashSet<Long> ids = new HashSet<Long>();
        String defaultResource = ImportExportProcessUtil.getDefaultSchemeResource(resources);
        BpmnModel bpmnModel = null;
        for (DynamicObject resource : resources) {
            String data = resource.getString("data");
            String name = resource.getString("name");
            if (name.endsWith("patch_json")) {
                if (WfUtils.isEmpty(data)) continue;
                bpmnModel = new BpmnJsonConverter().convertToBpmnModel(BpmnDiffUtil.applyPatch(defaultResource, data));
            } else {
                bpmnModel = ProcessDefinitionUtil.getBpmnModel(defaultResource);
            }
            ids.addAll(ImportExportProcessUtil.findIdsWhenMatchForBillSummary(entityNumber, bpmnModel));
        }
        ImportExportProcessUtil.addDynamicObjects(entityNumber, lists, ids);
    }

    public static Set<Long> loadCommonAuditCommentForScheme(String entityNumber, DynamicObject[] resources, List<DynamicObject> lists) {
        HashSet<Long> ids = new HashSet<Long>();
        String defaultResource = ImportExportProcessUtil.getDefaultSchemeResource(resources);
        BpmnModel bpmnModel = null;
        for (DynamicObject resource : resources) {
            String data = resource.getString("data");
            String name = resource.getString("name");
            if (name.endsWith("patch_json")) {
                if (WfUtils.isEmpty(data)) continue;
                bpmnModel = new BpmnJsonConverter().convertToBpmnModel(BpmnDiffUtil.applyPatch(defaultResource, data));
            } else {
                bpmnModel = ProcessDefinitionUtil.getBpmnModel(defaultResource);
            }
            ids.addAll(ImportExportProcessUtil.findIdsWhenMatchForAuditComment(entityNumber, bpmnModel));
        }
        ImportExportProcessUtil.addDynamicObjects(entityNumber, lists, ids);
        return ids;
    }

    public static void loadAuditCommentGroupForSchemeOrModel(String entityNumber, Set<Long> commonAuditCommentIds, List<DynamicObject> lists) {
        QFilter[] groupFiltersForId;
        DynamicObjectCollection auditCommentGroupsForIds;
        QFilter[] groupFilters;
        DynamicObjectCollection auditCommentGroups;
        HashSet<Long> groupIds = new HashSet<Long>();
        HashSet<String> longNumbers = new HashSet<String>();
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", commonAuditCommentIds)};
        DynamicObjectCollection auditComments = QueryServiceHelper.query((String)"wf_commonauditcommenttree", (String)"id,group", (QFilter[])filters);
        if (auditComments != null && !auditComments.isEmpty()) {
            for (DynamicObject auditComment : auditComments) {
                Long groupId = auditComment.getLong("group");
                if (WfUtils.isEmpty(groupId)) continue;
                groupIds.add(groupId);
            }
        }
        if ((auditCommentGroups = QueryServiceHelper.query((String)"wf_auditcommentgroup", (String)"longnumber", (QFilter[])(groupFilters = new QFilter[]{new QFilter("id", "in", groupIds)}))) != null && !auditCommentGroups.isEmpty()) {
            for (DynamicObject auditCommentGroup : auditCommentGroups) {
                String longNumber = auditCommentGroup.getString("longnumber");
                String[] num = longNumber.split("\\.");
                if (num == null || num.length <= 0) continue;
                for (String numString : num) {
                    longNumbers.add(numString);
                }
            }
        }
        if ((auditCommentGroupsForIds = QueryServiceHelper.query((String)"wf_auditcommentgroup", (String)"id", (QFilter[])(groupFiltersForId = new QFilter[]{new QFilter(NUMBER, "in", longNumbers)}))) != null && !auditCommentGroupsForIds.isEmpty()) {
            for (DynamicObject auditCommentGroupsForId : auditCommentGroupsForIds) {
                long groupId = auditCommentGroupsForId.getLong("id");
                groupIds.add(groupId);
            }
        }
        ImportExportProcessUtil.addDynamicObjects(entityNumber, lists, groupIds);
    }

    private static String getDefaultSchemeResource(DynamicObject[] resources) {
        String defaultResource = "";
        for (DynamicObject resource : resources) {
            String data = resource.getString("data");
            String name = resource.getString("name");
            if (WfUtils.isEmpty(data) || !name.endsWith("bpmn20.json")) continue;
            defaultResource = data;
            break;
        }
        return defaultResource;
    }

    private static Set<Long> findIdsWhenMatchForBillSummary(String entityNumber, BpmnModel bpmnModel) {
        DynamicObject[] dynamicObjects;
        HashSet<Long> ids = new HashSet<Long>();
        Process process = bpmnModel.getMainProcess();
        if (WfUtils.isNullObject(process)) {
            return ids;
        }
        List<FlowElement> flowElementList = process.getFlowElementList();
        if (CollectionUtil.isEmpty(flowElementList)) {
            return ids;
        }
        HashSet<String> billSummaryNumbers = new HashSet<String>();
        String processType = process.getProcessType();
        if (ProcessType.AuditFlow.name().equals(processType)) {
            List<AuditTask> auditTasks = process.findFlowElementsOfType(AuditTask.class);
            DynamicObject[] dynamicObjectArray = auditTasks.iterator();
            while (dynamicObjectArray.hasNext()) {
                String billSummeryNumber;
                AuditTask auditTask = dynamicObjectArray.next();
                BillSetting billSetting = auditTask.getBillSetting();
                String mobilFormKey = billSetting.getMobilFormKey();
                if (WfUtils.isEmpty(mobilFormKey) || !WfUtils.isNotEmpty(billSummeryNumber = ImportExportProcessUtil.getBillSummeryNumber(mobilFormKey))) continue;
                billSummaryNumbers.add(billSummeryNumber);
            }
        } else if (ProcessType.BizFlow.name().equals(processType)) {
            for (FlowElement flowElement : flowElementList) {
                String floatLayerBillSummary;
                String bizFlowBillSummary;
                if (flowElement instanceof UserTask) {
                    UserTask userTask = (UserTask)flowElement;
                    bizFlowBillSummary = userTask.getBizFlowBillSummary();
                    if (WfUtils.isNotEmpty(bizFlowBillSummary)) {
                        billSummaryNumbers.add(bizFlowBillSummary);
                    }
                    if (!WfUtils.isNotEmpty(floatLayerBillSummary = userTask.getFloatLayerBillSummary())) continue;
                    billSummaryNumbers.add(floatLayerBillSummary);
                    continue;
                }
                if (!(flowElement instanceof CallActivity)) continue;
                CallActivity callActivity = (CallActivity)flowElement;
                bizFlowBillSummary = callActivity.getBizFlowbillSummary();
                if (WfUtils.isNotEmpty(bizFlowBillSummary)) {
                    billSummaryNumbers.add(bizFlowBillSummary);
                }
                if (!WfUtils.isNotEmpty(floatLayerBillSummary = callActivity.getFloatLayerBillSummary())) continue;
                billSummaryNumbers.add(floatLayerBillSummary);
            }
            Set<String> billNumbers = ImportExportProcessUtil.getBillNumbersInProcess(flowElementList);
            QFilter billNumberFilter = new QFilter("billtype", "in", billNumbers);
            HashSet<String> scenes = new HashSet<String>();
            scenes.add(BillSummaryType.billRelationCardSummary.name());
            scenes.add(BillSummaryType.billRelationStackedCardSummary.name());
            QFilter sceneFilter = new QFilter("scene", "in", scenes);
            DynamicObject[] billSummarys = BusinessDataServiceHelper.load((String)"wf_mbillsummary_cfg", (String)"scene,number,billtype", (QFilter[])new QFilter[]{billNumberFilter, sceneFilter}, (String)"modifytime desc");
            if (billSummarys != null && billSummarys.length > 0) {
                HashSet<String> bills = new HashSet<String>(billSummarys.length);
                for (DynamicObject billSummary : billSummarys) {
                    String billType = billSummary.getString("billtype_id");
                    String scene = billSummary.getString("scene");
                    String key = String.format("%s_%s", scene, billType);
                    if (!bills.add(key)) continue;
                    billSummaryNumbers.add(billSummary.getString(NUMBER));
                }
            }
        }
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)entityNumber, (String)IDNUMBER, null)) {
            String number = dynamicObject.getString(NUMBER);
            if (!billSummaryNumbers.contains(number)) continue;
            ids.add((Long)dynamicObject.getPkValue());
        }
        return ids;
    }

    private static Set<String> getBillNumbersInProcess(List<FlowElement> flowElementList) {
        HashSet<String> billNumbers = new HashSet<String>();
        if (CollectionUtil.isNotEmpty(flowElementList)) {
            for (FlowElement flowElement : flowElementList) {
                String entityNumber;
                String entityId;
                if (flowElement instanceof BillTask) {
                    BillTask billTask = (BillTask)flowElement;
                    billNumbers.add(billTask.getEntityNumber());
                    billNumbers.add(billTask.getSourceEntityNumber());
                }
                if (flowElement instanceof UserTask) {
                    billNumbers.add(((UserTask)flowElement).getEntityNumber());
                    continue;
                }
                if (flowElement instanceof CallActivity) {
                    billNumbers.add(((CallActivity)flowElement).getEntityNumber());
                    continue;
                }
                if (flowElement instanceof AutoTask) {
                    AutoTask autoTask = (AutoTask)flowElement;
                    entityId = autoTask.getEntityId();
                    entityNumber = MetadataDao.getNumberById((String)entityId);
                    billNumbers.add(entityNumber);
                    continue;
                }
                if (flowElement instanceof WaitTask) {
                    billNumbers.add(((WaitTask)flowElement).getEntityNumber());
                    continue;
                }
                if (!(flowElement instanceof BroadcastTask)) continue;
                BroadcastTask broadcastTask = (BroadcastTask)flowElement;
                entityId = broadcastTask.getEntityId();
                entityNumber = MetadataDao.getNumberById((String)entityId);
                billNumbers.add(entityNumber);
            }
        }
        return billNumbers;
    }

    private static String getBillSummeryNumber(String mobilFormKey) {
        if (WfUtils.isNotEmpty(mobilFormKey) && mobilFormKey.endsWith("$")) {
            return mobilFormKey.substring(0, mobilFormKey.length() - 1);
        }
        return "";
    }

    private static Set<Long> findIdsWhenMatchForAuditComment(String entityNumber, BpmnModel bpmnModel) {
        HashSet<Long> ids = new HashSet<Long>();
        Process process = bpmnModel.getMainProcess();
        if (!WfUtils.isNullObject(process)) {
            DynamicObject[] dynamicObjects;
            List<AuditTask> auditTasks = process.findFlowElementsOfType(AuditTask.class);
            for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)entityNumber, (String)IDNUMBER, null)) {
                Long pkId = (Long)dynamicObject.getPkValue();
                String number = dynamicObject.getString(NUMBER);
                for (AuditTask auditTask : auditTasks) {
                    if (auditTask.getAuditCommentModel() == null) continue;
                    List<AuditComment> auditComments = auditTask.getAuditCommentModel().getAuditComments();
                    for (AuditComment auditComment : auditComments) {
                        if (!number.equals(auditComment.getNumber())) continue;
                        ids.add(pkId);
                    }
                }
            }
        }
        return ids;
    }

    private static void addDynamicObjects(String entityNumber, List<DynamicObject> lists, Set<Long> ids) {
        DynamicObject[] objects = BusinessDataReader.load((Object[])ids.toArray(new Long[ids.size()]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityNumber), (Boolean)Boolean.FALSE);
        if (objects != null && objects.length > 0) {
            for (DynamicObject object : objects) {
                lists.add(object);
            }
        }
    }

    public static void checkProcessTypeConsistent(String processNumber, String processType, boolean manageCenter) {
        String entity;
        QFilter[] filters = new QFilter[]{new QFilter("key", "=", (Object)processNumber), new QFilter("type", "!=", (Object)processType)};
        String string = entity = manageCenter ? "wf_processdefinition" : "wf_model";
        if (QueryServiceHelper.exists((String)entity, (QFilter[])filters)) {
            String text = ModelType.AuditFlow.name().equals(processType) ? ResManager.loadKDString((String)"\u4e1a\u52a1\u6d41", (String)"ImportExportProcessUtil_1", (String)"bos-wf-engine", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5ba1\u6279\u6d41", (String)"ImportExportProcessUtil_2", (String)"bos-wf-engine", (Object[])new Object[0]);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u6d41\u7a0b\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u201c%2$s\u201d\uff0c\u6d41\u7a0b\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"ImportExportProcessUtil_3", (String)"bos-wf-engine", (Object[])new Object[0]), processNumber, text));
        }
    }
}

