/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.domainmodel.ElementType;
import kd.bos.metadata.domainmodel.Property;
import kd.bos.workflow.bpmn.converter.util.ModelConfigUtil;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.property.semantic.Semanticizer;
import kd.bos.workflow.bpmn.model.property.semantic.SemanticizerFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.IModelModifyLog;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.ModelModifyLogEntityManager;

public class ModelModifyLogUtils {
    private static Log log = LogFactory.getLog(ModelModifyLogUtils.class);
    public static final String RESOURCE_ID = "resourceId";
    public static final String PATH = "path";
    public static final String PROPERTIES = "properties";
    public static final String CHILD_SHAPES = "childShapes";
    public static final String DIAGRAM = "Diagram";
    public static final String ACTION = "_action_";
    public static final String REMOVE = "remove";
    public static final String ADD = "add";
    public static final String REPLACE = "replace";
    public static final String DELETE = "delete";
    public static final String FLOW_ELEMENT_ID = "flowElementId";
    public static final String FLOW_ELEMENT_NAME = "flowElementName";
    public static final String ELEMENT_TYPE = "elementType";
    public static final String ELEMENT_TYPE_NAME = "elementTypeName";
    public static final String PROPERTY = "property";
    public static final String PROPERTY_NAME = "propertyName";
    public static final String GROUP = "group";
    public static final String GROUP_NAME = "groupName";
    public static final String OLD_VALUE = "oldValue";
    public static final String NEW_VALUE = "newValue";
    public static final String REVISION = "revision";
    public static final String OPERATION = "operation";
    public static final String BIZGROUP = "bizGroup";
    public static final String BIZGROUP_NAME = "bizGroupName";
    public static final String DYNAMIC_CONFIG_SCHEME = "dynconfscheme";
    public static final String PROCESS_BATCH_SETTING = "batchSetting";
    public static final String EXPRESSION = "expression";
    public static final String NODE_1 = "node_1";

    private ModelModifyLogUtils() {
    }

    public static Map<String, Object> getParamsByPatch(String flowElementId, String oldVal, String newVal, String path, IModelModifyLog entity, BpmnModel bpmnModel, ModelModifyLogEntityManager manager) {
        HashMap<String, Object> params = new HashMap<String, Object>(15);
        Process process = bpmnModel.getMainProcess();
        String flowElementName = null;
        String elementType = null;
        if (NODE_1.equals(flowElementId)) {
            flowElementName = ResManager.loadKDString((String)"\u6d41\u7a0b", (String)"ModelModifyLogUtils_0", (String)"bos-wf-engine", (Object[])new Object[0]);
            elementType = DIAGRAM;
        } else {
            FlowElement element = process.getFlowElement(flowElementId);
            elementType = element.getType();
            flowElementName = element.getName();
        }
        params.put(FLOW_ELEMENT_ID, flowElementId);
        params.put(FLOW_ELEMENT_NAME, flowElementName);
        String[] props = path.split("\\.");
        String prop = null;
        if (props.length > 2) {
            prop = props[2];
        } else if (props.length > 1) {
            prop = props[1];
        }
        ModelModifyLogUtils.getPropsInfo(prop, params, elementType, process);
        params.put(PATH, path);
        String operation = null;
        operation = ModelModifyLogUtils.isEmptyForBatch(oldVal) && !ModelModifyLogUtils.isEmptyForBatch(newVal) ? ADD : (ModelModifyLogUtils.isEmptyForBatch(newVal) && !ModelModifyLogUtils.isEmptyForBatch(oldVal) ? DELETE : REPLACE);
        params.put(OPERATION, operation);
        params.put(OLD_VALUE, oldVal);
        params.put(NEW_VALUE, newVal);
        return params;
    }

    private static boolean isEmptyForBatch(String value) {
        return WfUtils.isEmpty(value) || "[]".equals(value);
    }

    private static void getPropsInfo(String prop, Map<String, Object> result, String type, Process process) {
        String modelType = GraphCodecUtils.getModelTypeByProcessType(process.getProcessType());
        DomainModelType domainModelType = GraphCodecUtils.getDomainType(modelType);
        ElementType elementType = ModelModifyLogUtils.getElementType(modelType, domainModelType, type);
        List properties = null;
        if (elementType == null) {
            log.debug(String.format("ElementType is null! %s ", type));
            return;
        }
        properties = elementType.getProperties();
        result.put(PROPERTY, prop);
        for (Property property : properties) {
            if (prop == null || !prop.equals(property.getPropertyName())) continue;
            ModelModifyLogUtils.putPropInfo(result, property);
            break;
        }
        result.put(ELEMENT_TYPE, type);
        result.put(ELEMENT_TYPE_NAME, elementType.getName());
    }

    private static void putPropInfo(Map<String, Object> result, Property property) {
        LocaleString propName = property.getName();
        result.put(PROPERTY_NAME, propName);
        String bizGourp = null;
        String bizGourpName = null;
        Map editor = property.getEditor();
        if (editor != null) {
            bizGourp = editor.get(BIZGROUP) == null ? null : (String)editor.get(BIZGROUP);
            result.put(BIZGROUP, bizGourp);
            bizGourpName = editor.get(BIZGROUP_NAME) == null ? null : (String)editor.get(BIZGROUP_NAME);
            result.put(BIZGROUP_NAME, new LocaleString(bizGourpName));
        }
        String groupId = property.getGroupId();
        LocaleString groupName = property.getGroup();
        if (WfUtils.isNotEmpty(groupId)) {
            result.put(GROUP, groupId);
        } else {
            result.put(GROUP, WfUtils.isNotEmpty(bizGourp) ? bizGourp : property.getPropertyName());
        }
        if (WfUtils.isNotEmpty((ILocaleString)groupName)) {
            result.put(GROUP_NAME, groupName);
        } else {
            result.put(GROUP_NAME, WfUtils.isNotEmpty(bizGourpName) ? bizGourpName : propName);
        }
    }

    private static ElementType getElementType(String modelType, DomainModelType domainModelType, String type) {
        String extModel;
        if (WfUtils.isEmpty(modelType) || WfUtils.isEmpty(type)) {
            return null;
        }
        if (domainModelType == null) {
            log.debug(String.format("DomainType %s not exists ", modelType));
            return null;
        }
        ElementType elementType = domainModelType.getElementType(type);
        if (elementType != null) {
            return elementType;
        }
        if (ModelConfigUtil.getAllExtendedStencilTypes().contains(type) && (extModel = GraphCodecUtils.getExtendedModel("WorkflowModel")) != null) {
            String[] modelIds;
            for (String modelId : modelIds = extModel.split(";")) {
                DomainModelType domainModel = GraphCodecUtils.getDomainType(modelId);
                elementType = domainModel.getElementType(type);
                if (elementType == null) continue;
                return elementType;
            }
        }
        String parentType = ModelConfigUtil.getExtendNodeInheritStencilType(type);
        return ModelModifyLogUtils.getElementType(modelType, domainModelType, parentType);
    }

    public static String handleSpecial(String path, String elementType, String value) {
        if (value == null || "".equals(value) || "null".equals(value) || "[]".equals(value)) {
            return null;
        }
        if ("true".equals(value)) {
            return ResManager.loadKDString((String)"\u5f00", (String)"ModelModifyLogUtils_1", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        if ("false".equals(value)) {
            return ResManager.loadKDString((String)"\u5173", (String)"ModelModifyLogUtils_2", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        Semanticizer semanticizer = SemanticizerFactory.createSemanticizer(path);
        if (semanticizer != null) {
            return semanticizer.convert(value, elementType);
        }
        return value;
    }

    public static List<Map<String, String>> getElementPathsByBpmnPatch(JsonNode bpmnPatch, BpmnModel bpmnModel) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        JsonNode childShapes = bpmnPatch.get(CHILD_SHAPES);
        if (childShapes == null || !childShapes.isArray()) {
            return result;
        }
        for (JsonNode childShapeNode : childShapes) {
            String resourceId = childShapeNode.get(RESOURCE_ID).asText();
            JsonNode actionNode = childShapeNode.get(ACTION);
            if (actionNode != null) {
                HashMap<String, String> resultMap = new HashMap<String, String>();
                resultMap.put(RESOURCE_ID, resourceId);
                resultMap.put(ACTION, REMOVE);
                result.add(resultMap);
                continue;
            }
            JsonNode propertiesNode = childShapeNode.get(PROPERTIES);
            if (propertiesNode == null) continue;
            Iterator propertiesIt = propertiesNode.fields();
            while (propertiesIt.hasNext()) {
                Map.Entry propertyEntry0 = (Map.Entry)propertiesIt.next();
                String path0 = (String)propertyEntry0.getKey();
                JsonNode propertyNode0 = (JsonNode)propertyEntry0.getValue();
                List<String> groups = ModelModifyLogUtils.getAllGroups(bpmnModel, resourceId);
                if (propertyNode0.isObject() && groups.contains(path0)) {
                    Iterator it = propertyNode0.fieldNames();
                    while (it.hasNext()) {
                        String path1 = (String)it.next();
                        StringBuilder path = new StringBuilder();
                        path.append(PROPERTIES).append(".").append(path0).append(".").append(path1);
                        HashMap<String, String> resultMap = new HashMap<String, String>();
                        resultMap.put(RESOURCE_ID, resourceId);
                        resultMap.put(PATH, path.toString());
                        result.add(resultMap);
                    }
                    continue;
                }
                StringBuilder path = new StringBuilder();
                path.append(PROPERTIES).append(".").append(path0);
                HashMap<String, String> resultMap = new HashMap<String, String>();
                resultMap.put(RESOURCE_ID, resourceId);
                resultMap.put(PATH, path.toString());
                result.add(resultMap);
            }
        }
        return result;
    }

    public static List<String> getProcessPathsByBpmnPatch(JsonNode bpmnPatch, BpmnModel bpmnModel) {
        ArrayList<String> result = new ArrayList<String>();
        JsonNode propertiesNode = bpmnPatch.get(PROPERTIES);
        if (propertiesNode == null) {
            return Collections.emptyList();
        }
        Iterator propertiesIt = propertiesNode.fields();
        while (propertiesIt.hasNext()) {
            Map.Entry propertyEntry0 = (Map.Entry)propertiesIt.next();
            String path0 = (String)propertyEntry0.getKey();
            JsonNode propertyNode0 = (JsonNode)propertyEntry0.getValue();
            List<String> groups = ModelModifyLogUtils.getAllGroups(bpmnModel, NODE_1);
            if (propertyNode0.isObject() && groups.contains(path0)) {
                Iterator it = propertyNode0.fieldNames();
                while (it.hasNext()) {
                    String path1 = (String)it.next();
                    StringBuilder path = new StringBuilder();
                    path.append(PROPERTIES).append(".").append(path0).append(".").append(path1);
                    result.add(path.toString());
                }
                continue;
            }
            StringBuilder path = new StringBuilder();
            path.append(PROPERTIES).append(".").append(path0);
            result.add(path.toString());
        }
        return result;
    }

    private static List<String> getAllGroups(BpmnModel bpmnModel, String resourceId) {
        ArrayList<String> groups = new ArrayList<String>();
        Process process = bpmnModel.getMainProcess();
        FlowElement element = process.getFlowElement(resourceId);
        String type = null;
        if (element != null) {
            type = element.getType();
        } else if (resourceId.equals(NODE_1)) {
            type = DIAGRAM;
        }
        String modelType = GraphCodecUtils.getModelTypeByProcessType(process.getProcessType());
        DomainModelType domainModelType = GraphCodecUtils.getDomainType(modelType);
        ElementType elementType = ModelModifyLogUtils.getElementType(modelType, domainModelType, type);
        List properties = null;
        if (elementType != null) {
            properties = elementType.getProperties();
        }
        if (WfUtils.isEmptyForCollection(properties)) {
            return Collections.emptyList();
        }
        for (Property property : properties) {
            String groupId = property.getGroupId();
            if (!WfUtils.isNotEmpty(groupId)) continue;
            groups.add(groupId);
        }
        return groups;
    }

    public static String getRuleExpression(JsonNode ruleNode) {
        String ruleExpression = null;
        if (ruleNode != null && ruleNode.get(EXPRESSION) != null) {
            ruleExpression = ruleNode.get(EXPRESSION).asText();
        }
        return ruleExpression;
    }

    public static boolean isJsonStr(String str) {
        Object obj = null;
        try {
            obj = JSON.parse((String)str);
        }
        catch (Exception e) {
            return false;
        }
        return obj instanceof JSONObject || obj instanceof JSONArray;
    }

    public static List<Map<String, Object>> mergeBizGroupParams(Map<String, Set<Map<String, Object>>> bizGroups) {
        if (WfUtils.isEmptyForMap(bizGroups)) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(16);
        for (Map.Entry<String, Set<Map<String, Object>>> entry : bizGroups.entrySet()) {
            Set<Map<String, Object>> groupSet = entry.getValue();
            String bizGroup = null;
            ILocaleString bizGroupName = null;
            StringBuilder oldValueBuilder = new StringBuilder();
            StringBuilder newValueBuilder = new StringBuilder();
            Map<String, Object> mergedMap = null;
            int index = 0;
            for (Map<String, Object> param : groupSet) {
                Object propertyNameObj = param.get(PROPERTY_NAME);
                ILocaleString propertyName = propertyNameObj != null ? (ILocaleString)propertyNameObj : null;
                Object oldValueObj = param.get(OLD_VALUE);
                String oldValue = oldValueObj != null ? (String)oldValueObj : null;
                Object newValueObj = param.get(NEW_VALUE);
                String newValue = newValueObj != null ? (String)newValueObj : null;
                Object pathObj = param.get(PATH);
                String path = pathObj != null ? (String)pathObj : null;
                Object elementTypeObj = param.get(ELEMENT_TYPE);
                String elementType = elementTypeObj != null ? (String)elementTypeObj : null;
                oldValue = ModelModifyLogUtils.handleSpecial(path, elementType, oldValue);
                newValue = ModelModifyLogUtils.handleSpecial(path, elementType, newValue);
                oldValueBuilder.append(propertyName).append("\uff1a").append(oldValue).append("\n");
                newValueBuilder.append(propertyName).append("\uff1a").append(newValue).append("\n");
                if (index == 0) {
                    mergedMap = param;
                    bizGroup = (String)param.get(BIZGROUP);
                    bizGroupName = (ILocaleString)param.get(BIZGROUP_NAME);
                }
                ++index;
            }
            if (mergedMap != null) {
                mergedMap.put(OLD_VALUE, oldValueBuilder.toString());
                mergedMap.put(NEW_VALUE, newValueBuilder.toString());
                mergedMap.put(OPERATION, REPLACE);
            }
            result.add(mergedMap);
        }
        return result;
    }
}

