/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.ParticipatantModel;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.RuntimeService;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import kd.bos.workflow.engine.impl.calculator.ExpressionCalculatorUtil;
import kd.bos.workflow.engine.impl.calculator.ParticipantExpressionParsing;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.VariableInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.CoordinateRecordUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.relservice.WorkflowUserRelQueryHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;

public class ParticipantHelper {
    private static final String VALUE_SHOWTEXT = "valueshowtext";
    public static final String TYPE_ITEM_PERSON = "person";
    public static final String TYPE_ITEM_PLUGIN = "plugin";
    private static final String TYPE_ITEM_POSITION = "position";
    public static final String BOS_USER = "bos_user";
    private static final String BOS_POSITION = "bos_position";
    public static final String selectFileds = "id,name,entryentity.position,entryentity.dpt,simplepinyin,fullpinyin,number,usertype,phone,email";
    protected static final Log logger = LogFactory.getLog((String)"ParticipantHelper");

    public static List<Long> getUserIdsForParticipantFromHiActivity(CommandContext commandContext, Long processInstanceId, String flowNodeId) {
        ArrayList<Long> userIds = new ArrayList<Long>();
        List<HistoricActivityInstanceEntity> historicActs = ParticipantHelper.getHisActForParticipantFromHiActivity(commandContext, processInstanceId, flowNodeId);
        if (CollectionUtils.isEmpty(historicActs)) {
            return userIds;
        }
        for (HistoricActivityInstanceEntity node : historicActs) {
            Long assigneeId = node.getAssigneeId();
            if (assigneeId == null) continue;
            if (node.getActivityType().equals("YunzhijiaTask")) {
                userIds.add(assigneeId);
                continue;
            }
            userIds.add(assigneeId);
            break;
        }
        return userIds;
    }

    public static List<HistoricActivityInstanceEntity> getHisActForParticipantFromHiActivity(CommandContext commandContext, Long processInstanceId, String flowNodeId) {
        QFilter[] filters = new QFilter[]{new QFilter("processInstanceId", "=", (Object)processInstanceId), new QFilter("activityId", "=", (Object)flowNodeId)};
        HistoricActivityInstanceEntityManager hisActivityManager = commandContext.getProcessEngineConfiguration().getHistoricActivityInstanceEntityManager();
        List nodes = hisActivityManager.findByQueryFilters(filters, null, "endtime desc");
        ArrayList<HistoricActivityInstanceEntity> historicActivityInstanceEntities = new ArrayList<HistoricActivityInstanceEntity>();
        if (CollectionUtils.isEmpty(nodes)) {
            return historicActivityInstanceEntities;
        }
        for (HistoricActivityInstanceEntity node : nodes) {
            if (node.getActivityType().equals("YunzhijiaTask")) {
                historicActivityInstanceEntities.add(node);
                continue;
            }
            if (node.getActivityType().equals("AuditTask") && WfUtils.isNotEmpty(node.getExecutionType()) && node.getExecutionType().equals("skip") || node.getAssigneeId() == null) continue;
            historicActivityInstanceEntities.add(node);
            break;
        }
        return historicActivityInstanceEntities;
    }

    public static HistoricActivityInstanceEntity getUserIdsAndTaskIdsForParticipantFromHiActivity(List<HistoricActivityInstanceEntity> entities) {
        if (CollectionUtils.isEmpty(entities)) {
            return null;
        }
        HistoricActivityInstanceEntity HistoricActivityInstanceEntity2 = null;
        for (HistoricActivityInstanceEntity node : entities) {
            if (node.getActivityType().equals("YunzhijiaTask")) continue;
            HistoricActivityInstanceEntity2 = node;
            break;
        }
        return HistoricActivityInstanceEntity2;
    }

    public static String getTextFromParams(Map<String, Object> map) {
        if (WfUtils.isEmptyForMap(map)) {
            return "";
        }
        String showText = null;
        String valueshowtext = null;
        if (map.get(VALUE_SHOWTEXT) != null) {
            valueshowtext = (String)map.get(VALUE_SHOWTEXT);
        }
        Object value = map.get("value");
        String type = map.get("type").toString();
        if (value != null && TYPE_ITEM_PERSON.equals(type)) {
            String[] ids = value.toString().split(",");
            showText = WfUtils.isEmptyString(valueshowtext) ? ParticipantHelper.getNamesByIds(ids, TYPE_ITEM_PERSON) : valueshowtext;
        } else if (value != null && TYPE_ITEM_PLUGIN.equals(type)) {
            showText = WfUtils.isNotEmpty(valueshowtext) ? valueshowtext : (WfUtils.isNotEmpty((String)map.get("description")) ? (String)map.get("description") : ExternalInterfaceUtil.getFormattedShowValue((String)value));
        } else if (value != null && TYPE_ITEM_POSITION.equals(type)) {
            String[] ids = value.toString().split(",");
            showText = Optional.ofNullable(valueshowtext).orElseGet(() -> ParticipantHelper.getNamesByIds(ids, TYPE_ITEM_POSITION));
        } else {
            showText = WfUtils.isNotEmpty(valueshowtext) ? valueshowtext : (String)value;
        }
        return showText;
    }

    private static String getNamesByIds(String[] ids, String type) {
        String formId;
        String name = "";
        ArrayList<Long> idsLong = new ArrayList<Long>();
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i] == null || "".equals(ids[i].trim())) continue;
            idsLong.add(Long.valueOf(ids[i]));
        }
        if (idsLong.isEmpty()) {
            return null;
        }
        ORM orm = ORM.create();
        DynamicObjectCollection dos = orm.query(formId = TYPE_ITEM_POSITION.equals(type) ? BOS_POSITION : BOS_USER, "id,name", new QFilter[]{new QFilter("id", "in", (Object)idsLong.toArray())});
        if (!dos.isEmpty()) {
            StringBuilder names = new StringBuilder();
            HashMap<Long, String> userNameMap = new HashMap<Long, String>(dos.size());
            for (DynamicObject obj : dos) {
                userNameMap.put(obj.getLong("id"), ((ILocaleString)obj.get("name")).getLocaleValue());
            }
            for (Long userId : idsLong) {
                names.append((String)userNameMap.get(userId)).append('\uff0c');
            }
            name = names.substring(0, names.length() - 1);
        }
        return name;
    }

    public static String receiverPrefix(String type) {
        String receiverPrefix = "";
        if (type == null || "".equals(type)) {
            return receiverPrefix;
        }
        if (type.equals("relation")) {
            receiverPrefix = ResManager.loadKDString((String)"\u5173\u7cfb \uff1a ", (String)"ParticipantHelper_0", (String)"bos-wf-engine", (Object[])new Object[0]);
        } else if (type.equals("role")) {
            receiverPrefix = ResManager.loadKDString((String)"\u89d2\u8272 \uff1a ", (String)"ParticipantHelper_1", (String)"bos-wf-engine", (Object[])new Object[0]);
        } else if (type.equals(TYPE_ITEM_PERSON)) {
            receiverPrefix = ResManager.loadKDString((String)"\u4eba\u5458 \uff1a ", (String)"ParticipantHelper_2", (String)"bos-wf-engine", (Object[])new Object[0]);
        } else if (type.equals(TYPE_ITEM_PLUGIN)) {
            receiverPrefix = ResManager.loadKDString((String)"\u63d2\u4ef6 \uff1a ", (String)"ParticipantHelper_3", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        return receiverPrefix;
    }

    public static List<ILocaleString> getNameFormatMapByUserId(List<Long> userIdArray, ExecutionEntity execution, String displayInfo) {
        LinkedList<ILocaleString> nameFormatList = new LinkedList<ILocaleString>();
        DynamicObjectCollection userObjectCollection = QueryServiceHelper.query((String)BOS_USER, (String)selectFileds, (QFilter[])new QFilter[]{new QFilter("id", "in", userIdArray)});
        boolean isDisplaySetting = WfConfigurationUtil.isDisplaySetting();
        String entityNumber = execution.getEntityNumber();
        for (DynamicObject user : userObjectCollection) {
            LocaleString userNameFormatOne = new LocaleString();
            for (Lang lang : WfUtils.getSupportLangs()) {
                String userNameFormatOneStr = (String)ExpressionCalculatorUtil.getParticipantDisplayValue(user, execution, lang.toString(), displayInfo, entityNumber, execution.getBusinessKey(), isDisplaySetting);
                userNameFormatOne.put((Object)lang.toString(), (Object)userNameFormatOneStr);
            }
            nameFormatList.add((ILocaleString)userNameFormatOne);
        }
        return nameFormatList;
    }

    public static List<ILocaleString> getNameFormatMapByUserId(List<Long> userIdArray, ExecutionEntity execution, ILocaleString displayInfo) {
        LinkedList<ILocaleString> nameFormatList = new LinkedList<ILocaleString>();
        DynamicObjectCollection userObjectCollection = QueryServiceHelper.query((String)BOS_USER, (String)selectFileds, (QFilter[])new QFilter[]{new QFilter("id", "in", userIdArray)});
        String entityNumber = execution.getEntityNumber();
        Map<Long, ILocaleString> usersNameFormat = ParticipantExpressionParsing.getParticipantExpressionParsing().getParticipantDisplayValue(userObjectCollection, execution, displayInfo, entityNumber, execution.getBusinessKey());
        Set<Map.Entry<Long, ILocaleString>> usersNameFormatEntrySet = usersNameFormat.entrySet();
        for (Map.Entry<Long, ILocaleString> userNameFormat : usersNameFormatEntrySet) {
            nameFormatList.add(userNameFormat.getValue());
        }
        return nameFormatList;
    }

    public static ILocaleString getUserNameFormatValue(String[] userIdArray, ExecutionEntity execution, String displayInfo, Boolean isDisplaySetting) {
        LinkedList<Long> userIdList = new LinkedList<Long>();
        for (String userId : userIdArray) {
            if (!WfUtils.isNotEmpty(userId)) continue;
            userIdList.add(Long.valueOf(userId));
        }
        return WfMultiLangUtils.getFormatMergeValue(ParticipantHelper.getNameFormatMapByUserId(userIdList, execution, displayInfo));
    }

    public static ILocaleString getUserNameFormatValue(String[] userIdArray, ExecutionEntity execution, ILocaleString displayInfo) {
        LinkedList<Long> userIdList = new LinkedList<Long>();
        for (String userId : userIdArray) {
            if (!WfUtils.isNotEmpty(userId)) continue;
            userIdList.add(Long.valueOf(userId));
        }
        return WfMultiLangUtils.getFormatMergeValue(ParticipantHelper.getNameFormatMapByUserId(userIdList, execution, displayInfo));
    }

    public static ILocaleString getUserNameFormatValue(Long userId, ExecutionEntity execution, String displayInfo) {
        LocaleString result = new LocaleString();
        DynamicObject user = QueryServiceHelper.queryOne((String)BOS_USER, (String)selectFileds, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)userId)});
        boolean isDisplaySetting = WfConfigurationUtil.isDisplaySetting();
        String entityNumber = execution.getEntityNumber();
        for (Lang lang : WfUtils.getSupportLangs()) {
            Object resultLang = ExpressionCalculatorUtil.getParticipantDisplayValue(user, execution, lang.toString(), displayInfo, entityNumber, execution.getBusinessKey(), isDisplaySetting);
            if (resultLang == null) continue;
            result.put((Object)lang.toString(), (Object)resultLang.toString());
        }
        return result;
    }

    public static ILocaleString getUserNameFormatValue(Long userId, ExecutionEntity execution, ILocaleString displayInfo) {
        DynamicObject[] usersArray = BusinessDataServiceHelper.load((String)BOS_USER, (String)selectFileds, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)userId)});
        DynamicObjectCollection users = new DynamicObjectCollection();
        for (int i = 0; i < usersArray.length; ++i) {
            users.add((Object)usersArray[i]);
        }
        String entityNumber = execution.getEntityNumber();
        Map<Long, ILocaleString> userNameFormatMap = ParticipantExpressionParsing.getParticipantExpressionParsing().getParticipantDisplayValue(users, execution, displayInfo, entityNumber, execution.getBusinessKey());
        return userNameFormatMap.get(userId);
    }

    public static ILocaleString getUserNameFormatValue(TaskEntity task, Collection<Long> userIds) {
        LinkedList<ILocaleString> participantNameFormatList = new LinkedList<ILocaleString>();
        Map<Long, ILocaleString> participantNameFormaterMap = ParticipantHelper.getParticipantDisplayInfo(task, Lists.newArrayList(userIds));
        for (Long userId : userIds) {
            participantNameFormatList.add(participantNameFormaterMap.get(userId));
        }
        return WfMultiLangUtils.getFormatMergeValue(participantNameFormatList);
    }

    public static ILocaleString getUserName(ILocaleString userName, ILocaleString userNameFormat) {
        return WfUtils.isEmpty(userNameFormat) ? userName : userNameFormat;
    }

    public static ILocaleString getUserName(Long id, ILocaleString userNameFormat) {
        LocaleString userName = new LocaleString();
        userName = WfUtils.isNotEmpty(userNameFormat) ? userNameFormat : WfUtils.findUserName(id);
        return userName;
    }

    public static String getUserName(String userName, String userNameFormat) {
        return WfUtils.isEmpty(userNameFormat) ? userName : userNameFormat;
    }

    public static String getUserName(String userName, ILocaleString userNameFormat) {
        return WfUtils.isNotEmpty(userNameFormat) && WfUtils.isNotEmpty(userNameFormat.getLocaleValue()) ? userNameFormat.getLocaleValue() : userName;
    }

    public static String getUserName(FlowElement element, Long taskId) {
        String newString;
        QFilter[] filters;
        QFilter filter2;
        QFilter filter1;
        String userName = "";
        List<Long> userIds = CoordinateRecordUtil.getParticipantsByParentTaskId(taskId);
        DynamicObjectCollection identityLinks = null;
        if ("YunzhijiaTask".equals(element.getType())) {
            filter1 = new QFilter("parenttaskid", "=", (Object)taskId);
            filter2 = new QFilter("type", "in", (Object)"participant");
            filters = new QFilter[]{filter1, filter2};
            identityLinks = QueryServiceHelper.query((String)"wf_participant", (String)"usernameformatter", (QFilter[])filters);
        } else {
            filter1 = new QFilter("taskid", "=", (Object)taskId);
            filter2 = new QFilter("userid", "in", userIds);
            filters = new QFilter[]{filter1, filter2};
            identityLinks = QueryServiceHelper.query((String)"wf_participant", (String)"usernameformatter", (QFilter[])filters);
        }
        StringBuilder userNameFormatterSB = new StringBuilder();
        if (identityLinks != null && !identityLinks.isEmpty()) {
            for (int j = 0; j < identityLinks.size(); ++j) {
                String userNameFormatter = (String)((DynamicObject)identityLinks.get(j)).get("usernameformatter");
                if (!WfUtils.isNotEmpty(userNameFormatter)) continue;
                userNameFormatterSB.append(userNameFormatter).append(',');
            }
        }
        userName = WfUtils.isNotEmpty(newString = userNameFormatterSB.toString().replaceAll(",", " ")) ? userNameFormatterSB.toString().substring(0, userNameFormatterSB.length() - 1) : WfUtils.getUsersName(userIds);
        return userName;
    }

    public static Map<String, VariableInstanceEntity> getVariableInstancesForFormat(Long parentTaskId, RuntimeService runtimeService, Map<String, Object> parameter) {
        QFilter[] filters = new QFilter[2];
        filters[0] = new QFilter("taskId", "=", (Object)parentTaskId);
        String[] selectArray = new String[]{"teamMemberNamesFormat", "teamMemberNames"};
        filters[1] = new QFilter("name", "in", (Object)selectArray);
        List<VariableInstanceEntity> variableInstancesFormat = runtimeService.findVariableInstancesByFilters(filters, parameter, false);
        HashMap<String, VariableInstanceEntity> resultvariableInstances = new HashMap<String, VariableInstanceEntity>(2);
        for (VariableInstanceEntity variableInstanceEntity : variableInstancesFormat) {
            resultvariableInstances.put(variableInstanceEntity.getName(), variableInstanceEntity);
        }
        return resultvariableInstances;
    }

    public static ILocaleString getUserNameFormatByHiIdent(CommandContext commandContext, Long ownerId, Long taskId) {
        QFilter hiParticipantFilter1 = new QFilter("taskid", "=", (Object)taskId);
        QFilter hiParticipantFilter2 = new QFilter("userId", "=", (Object)ownerId);
        QFilter[] hiParticipantFilters = new QFilter[]{hiParticipantFilter1, hiParticipantFilter2};
        LocaleString userNameFormatter = new LocaleString();
        List hiParticipant = commandContext.getHistoricIdentityLinkEntityManager().findByQueryFilters(hiParticipantFilters);
        if (hiParticipant != null && !hiParticipant.isEmpty()) {
            userNameFormatter = ((HistoricIdentityLinkEntity)hiParticipant.get(0)).getUserNameFormatter();
        }
        return userNameFormatter;
    }

    public static DynamicObject getUserNameFormatByDynamicObject(Long ownerId, Long taskId, String entityNumber, String selectFiled, QFilter[] secondFilters) {
        Object[] filters;
        QFilter filter2 = new QFilter("taskid", "=", (Object)taskId);
        QFilter filter1 = new QFilter("userid", "=", (Object)ownerId);
        Object[] realFilters = filters = new QFilter[]{filter2, filter1};
        if (secondFilters != null && secondFilters.length > 1) {
            realFilters = (QFilter[])ArrayUtils.addAll((Object[])filters, (Object[])secondFilters);
        }
        DynamicObject hiparticipant = BusinessDataServiceHelper.loadSingle((String)entityNumber, (String)selectFiled, (QFilter[])realFilters);
        return hiparticipant;
    }

    public static ILocaleString getParticipantDisplayInfo(TaskEntity taskEntity, Long userId) {
        LocaleString participantDisplayInfo = new LocaleString();
        String taskSource = taskEntity.getSource();
        if (taskSource.equalsIgnoreCase("wf")) {
            BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModelByProcInstId(taskEntity.getProcessInstanceId());
            Process process = bpmnModel.getMainProcess();
            UserTask userTask = (UserTask)process.getFlowElement(taskEntity.getTaskDefinitionKey());
            String entityNumber = taskEntity.getEntityNumber();
            String multiKey = String.format("%s.participant.displayInfo", taskEntity.getTaskDefinitionKey());
            ParticipatantModel participantModel = userTask.getParticipant();
            if (userTask != null && participantModel != null) {
                String displayInfoStr = participantModel.getDisplayInfo();
                LocaleString displayInfo = new LocaleString();
                if (WfUtils.isNotEmpty(displayInfoStr)) {
                    displayInfo = BpmnModelUtil.getMultiLangFieldValue(taskEntity.getProcessInstanceId(), multiKey, displayInfoStr);
                }
                DynamicObject user = QueryServiceHelper.queryOne((String)BOS_USER, (String)selectFileds, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)userId)});
                if (WfUtils.isEmpty((ILocaleString)displayInfo)) {
                    displayInfo = WfUtils.getMultiLangValue(" ");
                }
                if (user == null) {
                    return displayInfo;
                }
                boolean isDisplaySetting = WfConfigurationUtil.isDisplaySetting();
                for (Lang lang : WfUtils.getSupportLangs()) {
                    Object expression = ExpressionCalculatorUtil.getParticipantDisplayValue(user, taskEntity.getExecution(), lang.toString(), (String)displayInfo.get((Object)lang.toString()), entityNumber, taskEntity.getBusinessKey(), isDisplaySetting);
                    participantDisplayInfo.setItem(lang.toString(), (Object)((String)expression));
                }
            }
        }
        return participantDisplayInfo;
    }

    public static Map<Long, ILocaleString> getParticipantDisplayInfo(TaskEntity taskEntity, List<Long> userIds) {
        Map<Long, ILocaleString> participantDisplayInfo = new HashMap<Long, ILocaleString>();
        if (!taskEntity.isBizTask()) {
            DynamicObject[] usersArray;
            String displayInfoStr;
            BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModelByProcInstId(taskEntity.getProcessInstanceId());
            Process process = bpmnModel.getMainProcess();
            UserTask userTask = (UserTask)process.getFlowElement(taskEntity.getTaskDefinitionKey());
            String string = taskEntity.getEntityNumber();
            String multiKey = String.format("%s.participant.displayInfo", taskEntity.getTaskDefinitionKey());
            ParticipatantModel participantModel = userTask.getParticipant();
            LocaleString displayInfo = new LocaleString();
            if (participantModel != null && WfUtils.isNotEmpty(displayInfoStr = participantModel.getDisplayInfo())) {
                displayInfo = BpmnModelUtil.getMultiLangFieldValue(taskEntity.getProcessInstanceId(), multiKey, displayInfoStr);
            }
            if ((usersArray = BusinessDataServiceHelper.load((String)BOS_USER, (String)selectFileds, (QFilter[])new QFilter[]{new QFilter("id", "in", userIds)})) == null) {
                return new HashMap<Long, ILocaleString>();
            }
            DynamicObjectCollection users = new DynamicObjectCollection();
            for (int i = 0; i < usersArray.length; ++i) {
                users.add((Object)usersArray[i]);
            }
            ParticipantExpressionParsing participantExpressionParsing = ParticipantExpressionParsing.getParticipantExpressionParsing();
            participantDisplayInfo = participantExpressionParsing.getParticipantDisplayValue(users, taskEntity.getExecution(), (ILocaleString)displayInfo, string, taskEntity.getBusinessKey());
        } else {
            Map<Long, ILocaleString> userNameMapping = WorkflowUserRelQueryHelper.getUsernames(userIds);
            Set<Map.Entry<Long, ILocaleString>> entries = userNameMapping.entrySet();
            for (Map.Entry entry : entries) {
                participantDisplayInfo.put((Long)entry.getKey(), (ILocaleString)entry.getValue());
            }
        }
        Set parEntrySet = participantDisplayInfo.entrySet();
        for (Map.Entry par : parEntrySet) {
            logger.debug(String.format("English display getParticipantDisplayInfo userId is %s, en value is %s", par.getKey(), ((ILocaleString)par.getValue()).getLocaleValue_en()));
        }
        return participantDisplayInfo;
    }
}

