/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.workflow.bpmn.converter.BpmnJsonConverter;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.IDynamicResourceItem;
import kd.bos.workflow.engine.impl.persistence.deploy.DeploymentCache;
import kd.bos.workflow.engine.impl.persistence.deploy.DeploymentManager;
import kd.bos.workflow.engine.impl.persistence.deploy.ProcessDefinitionCacheEntry;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricDynamicResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricDynamicResourceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.DynamicResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.DynamicResourceEntityManager;
import kd.bos.workflow.engine.repository.ProcessDefinition;
import kd.bos.workflow.exception.WFEngineException;

public class ProcessDefinitionUtil {
    private static Log logger = LogFactory.getLog(ProcessDefinitionUtil.class);

    public static ProcessDefinition getProcessDefinition(Long processDefinitionId) {
        return ProcessDefinitionUtil.getProcessDefinition(processDefinitionId, false);
    }

    public static ProcessDefinition getProcessDefinition(Long processDefinitionId, boolean checkCacheOnly) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        if (checkCacheOnly) {
            ProcessDefinitionCacheEntry cacheEntry = processEngineConfiguration.getProcessDefinitionCache().get(processDefinitionId);
            if (cacheEntry != null) {
                return cacheEntry.getProcessDefinition();
            }
            return null;
        }
        return processEngineConfiguration.getDeploymentManager().findDeployedProcessDefinitionById(processDefinitionId);
    }

    public static Process getProcess(Long processDefinitionId, Long processInstanceId) {
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(processDefinitionId, processInstanceId);
        if (bpmnModel != null) {
            return bpmnModel.getMainProcess();
        }
        logger.debug("can not get BpmnModel by processInstanceId is null");
        return null;
    }

    public static Process getProcessByProcInstId(Long processInstanceId) {
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModelByProcInstId(processInstanceId);
        if (bpmnModel != null) {
            return bpmnModel.getMainProcess();
        }
        logger.debug("can not get BpmnModel by processInstanceId: " + processInstanceId);
        return null;
    }

    public static Process getProcessBySchemeId(Long schemeId) {
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModelBySchemeId(schemeId);
        if (bpmnModel != null) {
            return bpmnModel.getMainProcess();
        }
        logger.error("can not get BpmnModel by schemeId: " + schemeId);
        return null;
    }

    public static Process getProcessByProcDefId(Long processDefinitionId) {
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModelByProcDefId(processDefinitionId);
        if (bpmnModel != null) {
            return bpmnModel.getMainProcess();
        }
        logger.debug("can not get BpmnModel by processDefinitionId: " + processDefinitionId);
        return null;
    }

    public static BpmnModel getBpmnModelByProcInstId(Long processInstanceId) {
        return ProcessDefinitionUtil.getBpmnModel(null, null, processInstanceId);
    }

    public static BpmnModel getBpmnModelBySchemeId(Long schemeId) {
        return ProcessDefinitionUtil.getBpmnModel(null, schemeId, null);
    }

    public static BpmnModel getBpmnModelByProcDefId(Long processDefinitionId) {
        return ProcessDefinitionUtil.getBpmnModel(processDefinitionId, null, null);
    }

    public static FlowElement getFlowElement(Long processDefinitionId, Long processInstanceId, String actId) {
        BpmnModel model = ProcessDefinitionUtil.getBpmnModel(processDefinitionId, processInstanceId);
        if (model != null) {
            return model.getFlowElement(actId);
        }
        return null;
    }

    public static FlowElement getFlowElement(Long processDefinitionId, Long processInstanceId, Long schemeId, String actId) {
        BpmnModel model = ProcessDefinitionUtil.getBpmnModel(processDefinitionId, schemeId, processInstanceId);
        if (model != null) {
            return model.getFlowElement(actId);
        }
        return null;
    }

    public static BpmnModel getBpmnModel(Long processDefinitionId, Long processInstanceId) {
        if (processDefinitionId == null && processInstanceId == null) {
            return null;
        }
        return ProcessDefinitionUtil.getBpmnModel(processDefinitionId, null, processInstanceId);
    }

    public static BpmnModel getBpmnModel(Long processDefinitionId, Long schemeId, Long processInstanceId) {
        CommandContext commandContext = Context.getCommandContext();
        BpmnModel model = commandContext.getBpmnModel(processDefinitionId, schemeId, processInstanceId);
        if (model == null) {
            ProcessEngineConfigurationImpl configuration = Context.getProcessEngineConfiguration();
            if (WfUtils.isEmpty(processDefinitionId)) {
                if (WfUtils.isNotEmpty(processInstanceId)) {
                    HistoricProcessInstanceEntityManager hisProcessInstanceMgr = configuration.getHistoricProcessInstanceEntityManager();
                    HistoricProcessInstanceEntity proinstance = (HistoricProcessInstanceEntity)hisProcessInstanceMgr.findById(processInstanceId, "processDefinitionId");
                    if (proinstance != null) {
                        processDefinitionId = proinstance.getProcessDefinitionId();
                    } else {
                        logger.debug("can not find processInstance by Id: " + processInstanceId);
                    }
                } else if (WfUtils.isNotEmpty(schemeId)) {
                    DynamicConfigSchemeEntity scheme = (DynamicConfigSchemeEntity)configuration.getDynamicConfigSchemeEntityManager().findById(schemeId, "processdefinitionid");
                    if (scheme != null) {
                        processDefinitionId = scheme.getProcDefId();
                    } else {
                        logger.debug("can not find scheme by Id: " + schemeId);
                    }
                }
            }
            DeploymentManager deploymentManager = Context.getProcessEngineConfiguration().getDeploymentManager();
            model = deploymentManager.resolveProcessDefinition(processDefinitionId, schemeId, processInstanceId).getBpmnModel();
            Context.getCommandContext().putBpmnModel(processDefinitionId, processInstanceId, schemeId, model);
        }
        return model;
    }

    public static BpmnModel getBpmnModelFromCache(Long processDefinitionId, Long schemeId, Long processInstanceId) {
        DeploymentCache<ProcessDefinitionCacheEntry> cache = Context.getProcessEngineConfiguration().getProcessDefinitionCache();
        ProcessDefinitionCacheEntry cacheEntry = cache.get(processInstanceId);
        if (cacheEntry == null) {
            cacheEntry = cache.get(schemeId);
        }
        if (cacheEntry == null) {
            cacheEntry = cache.get(processDefinitionId);
        }
        if (cacheEntry != null) {
            return cacheEntry.getBpmnModel();
        }
        return null;
    }

    public static boolean isProcessDefinitionSuspended(Long processDefinitionId) {
        ProcessDefinitionEntity processDefinition = ProcessDefinitionUtil.getProcessDefinitionFromDatabase(processDefinitionId);
        return processDefinition.isSuspended();
    }

    public static ProcessDefinitionEntity getProcessDefinitionFromDatabase(Long processDefinitionId) {
        ProcessDefinitionEntityManager processDefinitionEntityManager = Context.getProcessEngineConfiguration().getProcessDefinitionEntityManager();
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)processDefinitionEntityManager.findById(processDefinitionId);
        if (processDefinition == null) {
            throw new WFEngineException("No process definition found with id " + processDefinitionId);
        }
        return processDefinition;
    }

    public static BpmnModel getBpmnModel(String modelJson) {
        BpmnModel bpmnModel = null;
        try {
            JsonNode jsonNode = new ObjectMapper().readTree(modelJson);
            bpmnModel = new BpmnJsonConverter().convertToBpmnModel(jsonNode);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return bpmnModel;
    }

    public static List<IDynamicResourceItem> findDynamicResourceContentByProcessInstance(BpmnModel defBpmnModel, Long processInstanceId, boolean processIsTerminated) {
        ArrayList<IDynamicResourceItem> dynamicResourceItems = new ArrayList<IDynamicResourceItem>();
        try (TraceSpan ts = Tracer.create((String)"ProcessDefinitionUtil", (String)"findDynamicResourceByProcessInstance");){
            logger.debug(String.format("---findDynamicResourceByProcessInstance\uff1a%s---", processInstanceId));
            ts.addTag("processIsTerminated", String.valueOf(processIsTerminated));
            ts.addTag("processInstanceId", String.valueOf(processInstanceId));
            if (!processIsTerminated) {
                List<DynamicResourceEntity> dynamicResources = ProcessDefinitionUtil.getFromCacheOrLoad(processInstanceId);
                if (dynamicResources != null && !dynamicResources.isEmpty()) {
                    for (DynamicResourceEntity dynamicResource : dynamicResources) {
                        if (dynamicResource == null || dynamicResource.getContent() == null) continue;
                        dynamicResourceItems.add(dynamicResource);
                    }
                }
            } else {
                HistoricDynamicResourceEntityManager hisDynResEntityManager = Context.getCommandContext().getProcessEngineConfiguration().getHistoricDynamicResourceEntityManager();
                List<HistoricDynamicResourceEntity> hisDynResources = hisDynResEntityManager.findByProcessInstanceId(processInstanceId);
                if (hisDynResources != null && !hisDynResources.isEmpty()) {
                    for (HistoricDynamicResourceEntity hisDynResource : hisDynResources) {
                        if (hisDynResource == null || hisDynResource.getContent() == null || !WfUtils.isEmpty(hisDynResource.getDeleteReason())) continue;
                        dynamicResourceItems.add(hisDynResource);
                    }
                }
            }
        }
        return dynamicResourceItems;
    }

    private static List<DynamicResourceEntity> getFromCacheOrLoad(Long processInstanceId) {
        DynamicResourceEntityManager dynamicResourceEntityManager = Context.getCommandContext().getProcessEngineConfiguration().getDynamicResourceEntityManager();
        if (Context.getCommandContext() != null && Context.getCommandContext().getAttribute("DYNRESOURCE") != null) {
            return (List)Context.getCommandContext().getAttribute("DYNRESOURCE");
        }
        return dynamicResourceEntityManager.findByProcessInstanceId(processInstanceId);
    }

    public static void removeBPMNModel(Long key) {
        DeploymentCache<ProcessDefinitionCacheEntry> cache = Context.getProcessEngineConfiguration().getProcessDefinitionCache();
        cache.remove(key);
    }

    public static boolean existProcessDefinitionByEntityNumber(String entityNumber) {
        Boolean ret = WfCacheHelper.existEnableProcDefByEntityNumber(entityNumber);
        if (ret != null) {
            return ret;
        }
        int count = 0;
        String sql = "select top 1 fid id from t_wf_procdef where fentrabill = ? ";
        try (DataSet ds = DB.queryDataSet((String)"wf.existProcessDefinitionByEntityNumber", (DBRoute)DBRoute.workflow, (String)sql, (Object[])new Object[]{entityNumber});){
            Iterator iter = ds.iterator();
            if (iter.hasNext() && ((Row)iter.next()).getLong("id") != null) {
                count = 1;
            }
        }
        WfCacheHelper.putEnableProcDefByEntityNumber(entityNumber, count);
        return count > 0;
    }
}

