/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.util;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.workflow.bizflow.util.BizFlowUtil;
import kd.bos.workflow.bpmn.converter.util.CollectionUtils;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.EventDefinition;
import kd.bos.workflow.bpmn.model.EventSubProcess;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.MessageEventDefinition;
import kd.bos.workflow.bpmn.model.ParticipatantModel;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.StartEvent;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.ValuedDataObject;
import kd.bos.workflow.bpmn.model.Variable;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.calculator.ExpressionCalculatorUtil;
import kd.bos.workflow.engine.impl.calculator.ParticipantExpressionParsing;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.dynprocess.DynProcessProcessorHelper;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTrdDataSourceRecordEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityManager;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.repository.ProcessDefinition;
import kd.bos.workflow.engine.runtime.ProcessInstance;
import kd.bos.workflow.exception.WFEngineException;

public class ProcessInstanceHelper {
    protected Log logger = LogFactory.getLog(this.getClass());
    private static final String IDFORMAT = " (id = ";

    public ProcessInstance createProcessInstance(ProcessDefinitionEntity processDefinition, String businessKey, String processInstanceName, Map<String, Object> variables, Map<String, Object> transientVariables) {
        return this.createAndStartProcessInstance(processDefinition, businessKey, processInstanceName, variables, transientVariables, false);
    }

    public ProcessInstance createAndStartProcessInstance(ProcessDefinition processDefinition, String businessKey, String processInstanceName, Map<String, Object> variables, Map<String, Object> transientVariables) {
        return this.createAndStartProcessInstance(processDefinition, businessKey, processInstanceName, variables, transientVariables, true);
    }

    protected ProcessInstance createAndStartProcessInstance(ProcessDefinition processDefinition, String businessKey, String processInstanceName, Map<String, Object> variables, Map<String, Object> transientVariables, boolean startProcessInstance) {
        CommandContext commandContext = Context.getCommandContext();
        if (ProcessDefinitionUtil.isProcessDefinitionSuspended(processDefinition.getId())) {
            throw new WFEngineException("Cannot start process instance. Process definition " + processDefinition.getName() + IDFORMAT + processDefinition.getId() + ") is suspended");
        }
        Process process = ProcessDefinitionUtil.getProcess(processDefinition.getId(), null);
        if (process == null) {
            throw new WFEngineException("Cannot start process instance. Process model " + processDefinition.getName() + IDFORMAT + processDefinition.getId() + ") could not be found");
        }
        FlowElement initialFlowElement = process.getInitialFlowElement();
        if (initialFlowElement == null) {
            throw new WFEngineException("No start element found for process definition " + processDefinition.getId());
        }
        return this.createAndStartProcessInstanceWithInitialFlowElement(processDefinition, businessKey, processInstanceName, initialFlowElement, process, variables, transientVariables, startProcessInstance);
    }

    @Deprecated
    public ProcessInstance createAndStartProcessInstanceByMessage(ProcessDefinition processDefinition, String messageName, Map<String, Object> variables, Map<String, Object> transientVariables) {
        return null;
    }

    public ProcessInstance createAndStartProcessInstanceWithInitialFlowElement(ProcessDefinition processDefinition, String businessKey, String processInstanceName, FlowElement initialFlowElement, Process process, Map<String, Object> variables, Map<String, Object> transientVariables, boolean startProcessInstance) {
        ExecutionEntity superExecution;
        CommandContext commandContext = Context.getCommandContext();
        String initiator = null;
        Long schemeId = null;
        Long testingPlanId = null;
        String entityNumber = null;
        Long rootProInstId = null;
        Long superExecutionId = null;
        String bizTraceNo = null;
        String operation = null;
        if (variables != null) {
            initiator = (String)variables.get("_initiator_");
            schemeId = (Long)variables.get("SCHEMEID");
            testingPlanId = (Long)variables.get("testingPlanId");
            rootProInstId = (Long)variables.get("rootProcessInstanceId");
            entityNumber = (String)variables.get("entityNumber");
            superExecutionId = (Long)variables.get("superExecutionId");
            bizTraceNo = (String)variables.get("biztraceno");
            operation = (String)variables.get("_operation_");
        }
        if (entityNumber == null) {
            entityNumber = (String)variables.get("_entityNumber_");
        }
        if (WfUtils.isEmpty(entityNumber)) {
            entityNumber = ((ProcessDefinitionEntity)processDefinition).getEntraBill();
        }
        ExecutionEntity processInstance = commandContext.getExecutionEntityManager().createProcessInstanceExecution(processDefinition, businessKey, entityNumber, initiator, schemeId, testingPlanId, rootProInstId, superExecutionId);
        ProcessDefinitionEntity processDefinitionEntity = (ProcessDefinitionEntity)commandContext.getProcessDefinitionEntityManager().findById(processDefinition.getId());
        if (processDefinitionEntity != null && "sub".equals(processDefinitionEntity.getPrimarySubprocess())) {
            processInstance.setSubProcess(true);
        }
        this.recordTrdBusinessObjectDataSource(commandContext, entityNumber, businessKey, processInstance.getId(), variables);
        processInstance.setBizTraceNo(bizTraceNo);
        processInstance.setVariablesLocal(this.processVariables(process.getVariables(), processInstance));
        processInstance.setStarUserNameFormat(this.getStarUserNameFormat(processInstance));
        String businessId = process.getBusinessId();
        String number = process.getNumber();
        if (StringUtils.isBlank((CharSequence)businessId)) {
            QFilter[] filters = new QFilter[]{new QFilter("key", "=", (Object)number)};
            List procDefs = commandContext.getProcessDefinitionEntityManager().findByQueryFilters(filters);
            if (CollectionUtils.isNotEmpty(procDefs) && procDefs.get(0) != null) {
                businessId = ((ProcessDefinitionEntity)procDefs.get(0)).getBusinessId();
            }
        }
        processInstance.setBusinessId(businessId);
        commandContext.getHistoryManager().recordProcessInstanceStart(processInstance, initialFlowElement);
        if (variables != null) {
            String checkRightAppId;
            String appIdOfEntity;
            Iterator<Map.Entry<String, Object>> appNumber = variables.get("appnumber");
            if ((WfUtils.isEmptyString(appNumber) || "wftask".equals(appNumber)) && WfUtils.isNotEmpty(appIdOfEntity = EntityMetadataCache.getDataEntityType((String)entityNumber).getBizAppNumber())) {
                variables.put("appnumber", appIdOfEntity);
            }
            if ("wftask".equals(appNumber) && WfUtils.isNotEmpty(checkRightAppId = WfConfigurationUtil.getAppIdForEntityNumber(entityNumber))) {
                variables.put("appnumber", checkRightAppId);
            }
            if (WfUtils.isEmptyString(variables.get("appnumber"))) {
                variables.remove("appnumber");
            }
        }
        if (variables != null) {
            ProcessInstanceHelper.filterInValidVariables(variables);
            for (Map.Entry<String, Object> entry : variables.entrySet()) {
                processInstance.setVariable(entry.getKey(), entry.getValue());
            }
        }
        if (transientVariables != null) {
            for (Map.Entry<String, Object> entry : transientVariables.entrySet()) {
                processInstance.setTransientVariable(entry.getKey(), entry.getValue());
            }
        }
        if (processInstanceName != null) {
            LocaleString name = new LocaleString(processInstanceName);
            processInstance.setName((ILocaleString)name);
            commandContext.getHistoryManager().recordProcessInstanceNameChange(processInstance.getId(), (ILocaleString)name);
        }
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityWithVariablesEvent(ActivitiEventType.ENTITY_INITIALIZED, processInstance, variables, false));
        }
        ExecutionEntity execution = null;
        ProcessDefinitionEntity procdef = (ProcessDefinitionEntity)commandContext.getProcessDefinitionEntityManager().findById(processInstance.getProcessDefinitionId());
        if ("BizFlow".equals(procdef.getType())) {
            BizFlowUtil.setExecutionBatchNumber(processInstance);
            ExecutionEntityManager executionMgr = commandContext.getExecutionEntityManager();
            ExecutionEntity billExecution = executionMgr.createChildExecution(processInstance);
            billExecution.setBillExecution(true);
            billExecution.setActive(false);
            if (WfUtils.isNotEmpty(operation)) {
                billExecution.setVariableLocal("_operation_", operation);
            }
            executionMgr.update(billExecution);
            execution = executionMgr.createChildExecution(billExecution);
            if (superExecutionId == null) {
                commandContext.getCirculateRelationEntityManager().recordCirculateRelationShip(execution, initialFlowElement);
            }
        } else {
            execution = commandContext.getExecutionEntityManager().createChildExecution(processInstance);
        }
        execution.setVariableLocal("lastUserDealNode", "startProcessInstance");
        execution.setCurrentFlowElement(initialFlowElement);
        if (WfUtils.isNotEmpty(superExecutionId) && (superExecution = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(superExecutionId)) != null) {
            superExecution.setVariable(String.format("%s.%s", superExecution.getActivityId(), "subProcessInstanceId"), processInstance.getId());
            commandContext.getHistoryManager().recordSubProcessInstanceStart(superExecution, processInstance, initialFlowElement);
        }
        if (variables != null && "freeflow".equals((String)variables.get("dynType"))) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("freeflowmodelstr", variables.get("freeflowmodelstr"));
            execution.setVariable("freeflowsource", "freeflowsourceaddress");
            DynProcessProcessorHelper.createDynProcess(execution, (FlowNode)initialFlowElement, "freeflow", params);
        }
        for (FlowElement flowElement : process.getFlowElements()) {
            if (!(flowElement instanceof EventSubProcess)) continue;
            EventSubProcess eventSubProcess = (EventSubProcess)flowElement;
            for (FlowElement subElement : eventSubProcess.getFlowElements()) {
                EventDefinition eventDefinition;
                StartEvent startEvent;
                if (!(subElement instanceof StartEvent) || !CollectionUtil.isNotEmpty((startEvent = (StartEvent)subElement).getEventDefinitions()) || !((eventDefinition = startEvent.getEventDefinitions().get(0)) instanceof MessageEventDefinition)) continue;
                MessageEventDefinition messageEventDefinition = (MessageEventDefinition)eventDefinition;
                BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(processInstance.getProcessDefinitionId(), null);
                if (bpmnModel.containsMessageId(messageEventDefinition.getMessageRef())) {
                    messageEventDefinition.setMessageRef(bpmnModel.getMessage(messageEventDefinition.getMessageRef()).getName());
                }
                ExecutionEntity messageExecution = commandContext.getExecutionEntityManager().createChildExecution(processInstance);
                messageExecution.setCurrentFlowElement(startEvent);
                messageExecution.setEventScope(true);
                messageExecution.setActive(false);
                if (eventSubProcess.getSubProcessId() != null) {
                    messageExecution.setProcessDefinitionId(Long.valueOf(eventSubProcess.getSubProcessId()));
                }
                commandContext.getEventSubscriptionEntityManager().insertMessageEvent(messageEventDefinition.getMessageRef(), messageExecution);
            }
        }
        this.logger.debug(String.format("start processInstance[%s]", processInstance.getId()));
        if (startProcessInstance) {
            this.startProcessInstance(processInstance, commandContext, variables, execution);
        }
        return processInstance;
    }

    private void recordTrdBusinessObjectDataSource(CommandContext commandContext, String entityNumber, String businessKey, Long procInstId, Map<String, Object> variables) {
        if (WfUtils.isEmptyForMap(variables) || StringUtils.isBlank((CharSequence)entityNumber) || StringUtils.isBlank((CharSequence)businessKey)) {
            return;
        }
        boolean isCrossTenant = Boolean.parseBoolean(String.valueOf(variables.get("isCrossTenant")));
        if (!isCrossTenant) {
            return;
        }
        String dataSourceType = "";
        JSONObject dataSourceDetailsJson = new JSONObject();
        if (isCrossTenant) {
            dataSourceType = "CT";
            Object currentTenantId = variables.get("currentTenantId");
            Object targetTenantId = variables.get("targetTenantId");
            Object crossTenantInfo = variables.get("crossTenantInfo");
            dataSourceDetailsJson.put("dataSourceType", (Object)dataSourceType);
            dataSourceDetailsJson.put("currentTenantId", currentTenantId);
            dataSourceDetailsJson.put("targetTenantId", targetTenantId);
            dataSourceDetailsJson.put("crossTenantInfo", crossTenantInfo);
        }
        String sourceDetails = SerializationUtils.toJsonString((Object)dataSourceDetailsJson);
        HistoricTrdDataSourceRecordEntity recordEntity = commandContext.getHistoricTrdDataSourceRecordEntityManager().create(entityNumber, businessKey, procInstId, dataSourceType, sourceDetails);
        commandContext.getHistoricTrdDataSourceRecordEntityManager().insert(recordEntity, false);
        WfCacheHelper.putTrdBusinessObjectDataSource(entityNumber, businessKey, sourceDetails);
        WfConfigurationUtil.updateCrossTenantEntityNumberWhiteList(entityNumber);
    }

    private ILocaleString getStarUserNameFormat(ExecutionEntity processInstance) {
        Long starUserId = processInstance.getStartUserId();
        DynamicObject[] usersArray = BusinessDataServiceHelper.load((String)"bos_user", (String)"id,name,entryentity.position,entryentity.dpt,simplepinyin,fullpinyin,number,usertype,phone,email", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)starUserId)});
        DynamicObjectCollection users = new DynamicObjectCollection();
        for (int i = 0; i < usersArray.length; ++i) {
            users.add((Object)usersArray[i]);
        }
        Long processInstanceId = processInstance.getProcessInstanceId();
        Long processDefinitionId = processInstance.getProcessDefinitionId();
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(processDefinitionId, processInstanceId);
        Process process = bpmnModel.getMainProcess();
        UserTask userTask = BpmnModelUtil.getFirstUserTask(process);
        LocaleString disPlayInfo = new LocaleString();
        if (userTask != null) {
            ParticipatantModel participantModel = userTask.getParticipant();
            disPlayInfo = participantModel == null ? null : BpmnModelUtil.getMultiLangFieldValue(processInstanceId, String.format("%s.participant.displayInfo", processInstance.getActivityId()), participantModel.getDisplayInfo());
        }
        Map<Long, ILocaleString> userNameFormat = ParticipantExpressionParsing.getParticipantExpressionParsing().getParticipantDisplayValue(users, processInstance, (ILocaleString)disPlayInfo, processInstance.getEntityNumber(), processInstance.getBusinessKey());
        return userNameFormat.get(starUserId);
    }

    public void startProcessInstance(ExecutionEntity processInstance, CommandContext commandContext, Map<String, Object> variables, ExecutionEntity execution) {
        if (execution == null) {
            execution = processInstance.getExecutions().get(0);
        }
        this.logger.debug(String.format("planContinueProcessOperation execution[%s],size is [%s]", execution.getId(), processInstance.getExecutions().size()));
        Context.getAgenda().planContinueProcessOperation(execution);
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createProcessStartedEvent(processInstance, variables, false));
        }
    }

    protected Map<String, Object> processDataObjects(Collection<ValuedDataObject> dataObjects) {
        HashMap<String, Object> variablesMap = new HashMap<String, Object>();
        if (dataObjects != null) {
            for (ValuedDataObject dataObject : dataObjects) {
                variablesMap.put(dataObject.getName(), dataObject.getValue());
            }
        }
        return variablesMap;
    }

    public Map<String, Object> processVariables(List<Variable> variables, ExecutionEntity processInstance) {
        HashMap<String, Object> variablesMap = new HashMap<String, Object>();
        Long startUserId = processInstance.getStartUserId();
        if (variables != null && variables.size() > 0) {
            boolean isContainsBizapplier = false;
            for (Variable variable : variables) {
                if (WfUtils.isEmpty((String)variable.getDefaultValue())) continue;
                if ("taskGroupBy".equals(variable.getName())) {
                    variablesMap.put("groupby_id", variable.getId());
                    String realValue = variable.getRealValue();
                    if (!WfUtils.isNotEmpty(realValue)) continue;
                    this.setGroupInfo(realValue, variablesMap);
                    continue;
                }
                Object defaultValue = ExpressionCalculatorUtil.parseValue(null, processInstance, (String)variable.getDefaultValue(), null);
                if ("bizApplier".equals(variable.getName())) {
                    isContainsBizapplier = true;
                    try {
                        Long bizApplier = (Long)defaultValue;
                        this.setBizApplier(bizApplier, variablesMap);
                        processInstance.setStartUserId(bizApplier);
                    }
                    catch (Exception e) {
                        this.setBizApplier(startUserId, variablesMap);
                    }
                    continue;
                }
                variablesMap.put(variable.getName(), defaultValue);
            }
            if (!isContainsBizapplier) {
                this.setBizApplier(startUserId, variablesMap);
            }
        } else {
            this.setBizApplier(startUserId, variablesMap);
        }
        return variablesMap;
    }

    private void setGroupInfo(String defaultValue, Map<String, Object> variablesMap) {
        Map groupInfo = (Map)SerializationUtils.fromJsonString((String)defaultValue, Map.class);
        for (Map.Entry entry : groupInfo.entrySet()) {
            String key = (String)entry.getKey();
            if ("groupbynode".equals(key)) {
                variablesMap.put("groupby_node", entry.getValue());
                continue;
            }
            if ("settinginfo".equals(key)) {
                variablesMap.put("groupby_rule", entry.getValue());
                continue;
            }
            if (!"showinfo".equals(key)) continue;
            variablesMap.put("groupby_name", entry.getValue());
        }
    }

    private void setBizApplier(Long bizApplier, Map<String, Object> variablesMap) {
        variablesMap.put("bizApplier", bizApplier);
        Map userInfo = UserServiceHelper.getUserInfoByID((long)bizApplier);
        String bizApplierName = (String)userInfo.get("name");
        variablesMap.put("bizApplierName", bizApplierName);
    }

    public static void filterInValidVariables(Map<String, Object> variables) {
        List<String> inVars;
        String inValidVars = WfConfigurationUtil.getVarsBlackList();
        if (WfUtils.isNotEmpty(inValidVars) && WfUtils.isNotEmptyForMap(variables) && WfUtils.isNotEmptyForCollection(inVars = Arrays.asList(inValidVars.split(",")))) {
            Set<Map.Entry<String, Object>> sets = variables.entrySet();
            Iterator<Map.Entry<String, Object>> iter = sets.iterator();
            while (iter.hasNext()) {
                Map.Entry<String, Object> entry = iter.next();
                if (!inVars.contains(entry.getKey())) continue;
                iter.remove();
            }
        }
    }
}

