/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.util;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.workflow.component.approvalrecord.CustomizeLink;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.OperationLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.OperationLogEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;

public class RPAUtil {
    private static Log log = LogFactory.getLog(RPAUtil.class);
    private static final String ICON_RPA = "/icons/pc/application/RPA2_48_48.png";

    private RPAUtil() {
    }

    public static ILocaleString getRobotName() {
        return WfUtils.getPromptWordLocaleString("\u65e0\u4eba\u503c\u5b88\u673a\u5668\u4eba", "RPAUtil_1", "bos-wf-engine");
    }

    public static ILocaleString getSendStartRPAProcMsgText() {
        return WfUtils.getPromptWordLocaleString("\u6210\u529f\u53d1\u9001\u542f\u52a8RPA\u6d41\u7a0b\u7684\u6d88\u606f\u3002", "RPAUtil_2", "bos-wf-engine");
    }

    public static ILocaleString getStartRPAProcText() {
        return WfUtils.getPromptWordLocaleString("\u6210\u529f\u542f\u52a8RPA\u6d41\u7a0b\u3002", "RPAUtil_3", "bos-wf-engine");
    }

    public static List<CustomizeLink> createViewLogLink(String taskId) {
        ArrayList<CustomizeLink> links = new ArrayList<CustomizeLink>();
        if (WfUtils.isEmpty(taskId) || "0".equals(taskId)) {
            return links;
        }
        try {
            String url = (String)DispatchServiceHelper.invokeBizService((String)"rpac", (String)"rpacp", (String)"RpaService", (String)"getTaskLogUrl", (Object[])new Object[]{taskId});
            CustomizeLink link = new CustomizeLink();
            link.setUrl(url);
            link.setText(ResManager.loadKDString((String)"\u67e5\u770b\u8fd0\u884c\u65e5\u5fd7", (String)"RPAUtil_4", (String)"bos-wf-engine", (Object[])new Object[0]));
            links.add(link);
        }
        catch (Exception e) {
            log.error(WfUtils.getExceptionStacktrace(e));
        }
        return links;
    }

    public static void recordOperationLog(CommandContext commandContext, CommentEntity commentEntity) {
        HistoricProcessInstanceEntity procInstEntity = (HistoricProcessInstanceEntity)commandContext.getHistoricProcessInstanceEntityManager().findById(commentEntity.getProcessInstanceId(), "processDefinitionId");
        RPAUtil.recordOperationLog(commandContext, commentEntity, procInstEntity.getProcessDefinitionId());
    }

    public static void recordOperationLog(CommandContext commandContext, CommentEntity commentEntity, Long procDefId) {
        Long procInstId = commentEntity.getProcessInstanceId();
        OperationLogEntityManager operationLogManager = commandContext.getOperationLogEntityManager();
        OperationLogEntity operationLog = (OperationLogEntity)operationLogManager.create();
        operationLog.setProcInstId(procInstId);
        operationLog.setProcDefId(procDefId);
        operationLog.setCommentId(commentEntity.getId());
        operationLog.setBusinessKey(commentEntity.getBusinessKey());
        operationLog.setBillNo(commentEntity.getBillNo());
        operationLog.setActivityId(commentEntity.getActivityId());
        operationLog.setActivityName(commentEntity.getNodeName());
        operationLog.setOwner(commentEntity.getTaskAssignee());
        operationLog.setAssignee(commentEntity.getTaskAssignee());
        operationLog.setNOpinion(commentEntity.getCommentMessage());
        operationLog.setCreateDate(commentEntity.getTime());
        operationLog.setModifyDate(commentEntity.getTime());
        operationLog.setTerminalWay(commentEntity.getTerminalWay());
        operationLog.setType("auto");
        operationLog.setStep(operationLogManager.calculateLogStep(procInstId));
        operationLogManager.insert(operationLog);
    }

    public static String getRPAApprovalRecordAvatar() {
        return ICON_RPA;
    }
}

