/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.Locale;
import java.util.regex.Pattern;
import kd.bos.dataentity.TypesContainer;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.exception.BECEngineException;
import kd.bos.workflow.exception.WFEngineException;

public abstract class ReflectUtil {
    protected static Log log = LogFactory.getLog(ReflectUtil.class);
    private static final Pattern GETTER_PATTERN = Pattern.compile("(get|is)[A-Z].*");
    private static final Pattern SETTER_PATTERN = Pattern.compile("set[A-Z].*");

    public static ClassLoader getClassLoader() {
        ClassLoader loader = ReflectUtil.getCustomClassLoader();
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        return loader;
    }

    public static Class<?> loadClass(String className) {
        Exception throwable = null;
        Class<?> clazz = null;
        try {
            clazz = ReflectUtil.getClazz(className);
        }
        catch (Exception t) {
            throwable = t;
        }
        if (clazz == null) {
            throw new WFEngineException(className, throwable);
        }
        return clazz;
    }

    public static Class<?> loadClassForEvent(String className) {
        Exception throwable = null;
        Class<?> clazz = null;
        try {
            clazz = ReflectUtil.getClazz(className);
        }
        catch (Exception t) {
            throwable = t;
        }
        if (clazz == null) {
            throw new BECEngineException(className, throwable);
        }
        return clazz;
    }

    public static Class<?> getClazz(String className) throws Exception {
        Class clazz;
        Exception exception;
        block10: {
            ClassLoader classLoader = ReflectUtil.getCustomClassLoader();
            exception = null;
            clazz = null;
            if (classLoader != null) {
                try {
                    log.debug("Trying to load class with custom classloader: " + className);
                    clazz = ReflectUtil.loadClass(classLoader, className);
                }
                catch (Exception t) {
                    exception = t;
                }
            }
            if (clazz == null) {
                try {
                    log.debug("Trying to load class with current thread context classloader: " + className);
                    clazz = ReflectUtil.loadClass(Thread.currentThread().getContextClassLoader(), className);
                }
                catch (Exception t) {
                    exception = t;
                }
                if (clazz == null) {
                    try {
                        log.debug("Trying to load class with local classloader: " + className);
                        clazz = ReflectUtil.loadClass(ReflectUtil.class.getClassLoader(), className);
                    }
                    catch (Exception t) {
                        if (exception != null) break block10;
                        exception = t;
                    }
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
        return clazz;
    }

    public static URL getResource(String name) {
        URL url = null;
        ClassLoader classLoader = ReflectUtil.getCustomClassLoader();
        if (classLoader != null) {
            url = classLoader.getResource(name);
        }
        if (url == null && (url = (classLoader = Thread.currentThread().getContextClassLoader()).getResource(name)) == null) {
            classLoader = ReflectUtil.class.getClassLoader();
            url = classLoader.getResource(name);
        }
        return url;
    }

    public static Object instantiate(String className) {
        try {
            Class<?> clazz = ReflectUtil.loadClass(className);
            return clazz.newInstance();
        }
        catch (Exception e) {
            log.info(WfUtils.getExceptionStacktrace(e));
            throw new WFEngineException("couldn't instantiate class " + className, e);
        }
    }

    public static Object invoke(Object target, String methodName, Object[] args) {
        try {
            Class<?> clazz = target.getClass();
            Method method = ReflectUtil.findMethod(clazz, methodName, args);
            if (method != null) {
                AccessibleObject.setAccessible(new AccessibleObject[]{method}, true);
                return method.invoke(target, args);
            }
            return null;
        }
        catch (Exception e) {
            throw new WFEngineException("couldn't invoke " + methodName + " on " + target, e);
        }
    }

    public static Field getField(String fieldName, Object object) {
        return ReflectUtil.getField(fieldName, object.getClass());
    }

    public static Field getField(String fieldName, Class<?> clazz) {
        Field field;
        block3: {
            field = null;
            try {
                field = ReflectUtil.getDeclaredFieldIgnoreCase(fieldName, clazz);
            }
            catch (SecurityException e) {
                throw new WFEngineException("not allowed to access field " + field + " on class " + clazz.getCanonicalName());
            }
            catch (NoSuchFieldException e) {
                Class<?> superClass = clazz.getSuperclass();
                if (superClass == null) break block3;
                return ReflectUtil.getField(fieldName, superClass);
            }
        }
        return field;
    }

    private static Field getDeclaredFieldIgnoreCase(String fieldName, Class<?> clazz) throws NoSuchFieldException {
        Field[] fields = clazz.getDeclaredFields();
        if (fields.length > 0) {
            for (Field field : fields) {
                if (!field.getName().equalsIgnoreCase(fieldName)) continue;
                return field;
            }
        }
        throw new NoSuchFieldException();
    }

    public static void setField(Field field, Object object, Object value) {
        try {
            AccessibleObject.setAccessible(new AccessibleObject[]{field}, true);
            field.set(object, value);
        }
        catch (IllegalArgumentException e) {
            throw new WFEngineException("Could not set field " + field.toString(), e);
        }
        catch (IllegalAccessException e) {
            throw new WFEngineException("Could not set field " + field.toString(), e);
        }
    }

    public static Method getSetter(String fieldName, Class<?> clazz, Class<?> fieldType) {
        String setterName = "set" + Character.toTitleCase(fieldName.charAt(0)) + fieldName.substring(1, fieldName.length());
        try {
            Method[] methods;
            for (Method method : methods = clazz.getMethods()) {
                Class<?>[] paramTypes;
                if (!method.getName().equals(setterName) || (paramTypes = method.getParameterTypes()) == null || paramTypes.length != 1 || !paramTypes[0].isAssignableFrom(fieldType)) continue;
                return method;
            }
            return null;
        }
        catch (SecurityException e) {
            throw new WFEngineException("Not allowed to access method " + setterName + " on class " + clazz.getCanonicalName());
        }
    }

    private static Method findMethod(Class<? extends Object> clazz, String methodName, Object[] args) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.getName().equals(methodName) || !ReflectUtil.matches(method.getParameterTypes(), args)) continue;
            return method;
        }
        Class<? extends Object> superClass = clazz.getSuperclass();
        if (superClass != null) {
            return ReflectUtil.findMethod(superClass, methodName, args);
        }
        return null;
    }

    public static Object instantiate(String className, Object[] args) {
        Class<?> clazz = ReflectUtil.loadClass(className);
        Constructor<?> constructor = ReflectUtil.findMatchingConstructor(clazz, args);
        if (constructor == null) {
            throw new WFEngineException("couldn't find constructor for " + className + " with args " + Arrays.asList(args));
        }
        try {
            return constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new WFEngineException("couldn't find constructor for " + className + " with args " + Arrays.asList(args), e);
        }
    }

    private static <T> Constructor<T> findMatchingConstructor(Class<T> clazz, Object[] args) {
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            if (!ReflectUtil.matches(constructor.getParameterTypes(), args)) continue;
            return constructor;
        }
        return null;
    }

    private static boolean matches(Class<?>[] parameterTypes, Object[] args) {
        if (parameterTypes == null || parameterTypes.length == 0) {
            return args == null || args.length == 0;
        }
        if (args == null || parameterTypes.length != args.length) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (args[i] == null || parameterTypes[i].isAssignableFrom(args[i].getClass())) continue;
            return false;
        }
        return true;
    }

    private static ClassLoader getCustomClassLoader() {
        ClassLoader classLoader;
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        if (processEngineConfiguration != null && (classLoader = processEngineConfiguration.getClassLoader()) != null) {
            return classLoader;
        }
        return null;
    }

    private static Class loadClass(ClassLoader classLoader, String className) throws ClassNotFoundException {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        boolean useClassForName = processEngineConfiguration == null || processEngineConfiguration.isUseClassForNameClassLoading();
        return useClassForName ? TypesContainer.getOrRegister((String)className) : classLoader.loadClass(className);
    }

    public static boolean isGetter(Method method) {
        String name = method.getName();
        Class<?> type = method.getReturnType();
        Class<?>[] params = method.getParameterTypes();
        if (!GETTER_PATTERN.matcher(name).matches()) {
            return false;
        }
        if (name.startsWith("is")) {
            return params.length == 0 && type.getSimpleName().equalsIgnoreCase("boolean");
        }
        return params.length == 0 && !type.equals(Void.TYPE);
    }

    public static boolean isSetter(Method method, boolean allowBuilderPattern) {
        String name = method.getName();
        Class<?> type = method.getReturnType();
        Class<?>[] params = method.getParameterTypes();
        if (!SETTER_PATTERN.matcher(name).matches()) {
            return false;
        }
        return params.length == 1 && (type.equals(Void.TYPE) || allowBuilderPattern && method.getDeclaringClass().isAssignableFrom(type));
    }

    public static boolean isSetter(Method method) {
        return ReflectUtil.isSetter(method, false);
    }

    public static String getGetterShorthandName(Method method) {
        if (!ReflectUtil.isGetter(method)) {
            return method.getName();
        }
        String name = method.getName();
        if (name.startsWith("get")) {
            name = name.substring(3);
            name = name.substring(0, 1).toLowerCase(Locale.ENGLISH) + name.substring(1);
        } else if (name.startsWith("is")) {
            name = name.substring(2);
            name = name.substring(0, 1).toLowerCase(Locale.ENGLISH) + name.substring(1);
        }
        return name;
    }

    public static String getSetterShorthandName(Method method) {
        if (!ReflectUtil.isSetter(method)) {
            return method.getName();
        }
        String name = method.getName();
        if (name.startsWith("set")) {
            name = name.substring(3);
            name = name.substring(0, 1).toLowerCase(Locale.ENGLISH) + name.substring(1);
        }
        return name;
    }
}

