/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.jobexecutor.JobUtil;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.TimerJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.msg.info.ToDoInfo;

public class RuntimeUtil {
    public static boolean isBizRunning(CommandContext commandContext, String businessKey) {
        return RuntimeUtil.isStarting(commandContext, businessKey) || RuntimeUtil.isRunning(commandContext, businessKey) || RuntimeUtil.isRetring(commandContext, businessKey);
    }

    public static boolean isStarting(CommandContext commandContext, String businessKey) {
        return WfCacheHelper.isCurrentExecuting(businessKey);
    }

    public static boolean isRunningByProcInst(CommandContext commandContext, Long procInstId) {
        List<JobEntity> jobs = commandContext.getJobEntityManager().findJobsByProcInstId(procInstId, String.format("%s,%s,%s", "id", "rootJobId", "jobHandlerType"));
        return RuntimeUtil.hasRunningJob(jobs);
    }

    public static boolean isRunning(CommandContext commandContext, String businessKey) {
        List<JobEntity> jobs = commandContext.getJobEntityManager().findJobsByBusinessKey(businessKey, String.format("%s,%s,%s", "id", "rootJobId", "jobHandlerType"));
        return RuntimeUtil.hasRunningJob(jobs);
    }

    private static boolean hasRunningJob(List<JobEntity> jobs) {
        boolean running = false;
        if (jobs != null && jobs.size() > 0) {
            for (JobEntity job : jobs) {
                if (JobUtil.isInJobThread() && JobUtil.isCurrentThreadJob(job.getId())) continue;
                if (!running && RuntimeUtil.isRunningJob(job.getJobHandlerType())) {
                    running = true;
                }
                if (!running) continue;
                break;
            }
        }
        return running;
    }

    public static Set<String> isRunning(CommandContext commandContext, List<String> businessKeys) {
        HashSet<String> isRunningBusinesskeys = new HashSet<String>();
        List<JobEntity> jobs = commandContext.getJobEntityManager().findJobsByBusinessKeys(businessKeys, String.format("%s,%s,%s,%s", "id", "rootJobId", "jobHandlerType", "businessKey"));
        if (jobs != null && !jobs.isEmpty()) {
            for (JobEntity job : jobs) {
                if (!RuntimeUtil.isRunningJob(job.getJobHandlerType())) continue;
                isRunningBusinesskeys.add(job.getBusinessKey());
            }
        }
        return isRunningBusinesskeys;
    }

    public static boolean isRetring(CommandContext commandContext, String businessKey) {
        List<TimerJobEntity> timerJobs = commandContext.getTimerJobEntityManager().findJobsByBusinessKey(businessKey, String.format("%s,%s", "id", "jobHandlerType"));
        if (timerJobs != null && !timerJobs.isEmpty()) {
            for (TimerJobEntity timer : timerJobs) {
                if (!RuntimeUtil.isRunningJob(timer.getJobHandlerType())) continue;
                return true;
            }
        }
        return false;
    }

    public static Set<String> isRetring(CommandContext commandContext, List<String> businessKey) {
        List<TimerJobEntity> timerJobs = commandContext.getTimerJobEntityManager().findJobsByBusinessKeys(businessKey, String.format("%s,%s,%s", "id", "jobHandlerType", "businessKey"));
        HashSet<String> isRetringBusinesskeys = new HashSet<String>();
        if (timerJobs != null && !timerJobs.isEmpty()) {
            for (TimerJobEntity timer : timerJobs) {
                if (!RuntimeUtil.isRunningJob(timer.getJobHandlerType())) continue;
                isRetringBusinesskeys.add(timer.getBusinessKey());
            }
        }
        return isRetringBusinesskeys;
    }

    public static boolean isRunningJob(String type) {
        return "address-process-event".equalsIgnoreCase(type) || "async-continuation".equalsIgnoreCase(type) || "async-trigger".equalsIgnoreCase(type) || "start-process-event".equalsIgnoreCase(type) || "execute-behavior".equalsIgnoreCase(type) || "async-executionConversion".equalsIgnoreCase(type) || "start-callactivity-event".equalsIgnoreCase(type) || "async-compensationTaskJob".equalsIgnoreCase(type) || "event-address-process".equalsIgnoreCase(type) || "multi-async-continuation".equalsIgnoreCase(type);
    }

    public static String[] getRunningJobStr() {
        return new String[]{"address-process-event", "async-continuation", "async-trigger", "start-process-event", "execute-behavior", "async-executionConversion", "start-callactivity-event", "async-compensationTaskJob", "event-address-process", "donothing-event", "multi-async-continuation"};
    }

    public static String[] getDeadLetterJobStr() {
        return new String[]{"address-process-event", "async-continuation", "async-trigger", "start-process-event", "execute-behavior", "async-executionConversion", "expireModelJobHandler", "start-callactivity-event", "async-compensationTaskJob", "event-address-process", "donothing-event", "async-timing", "wait-event", "multi-async-continuation"};
    }

    public static boolean isExist(CommandContext commandContext, Long processInstanceId) {
        ExecutionEntity entity = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(processInstanceId);
        return entity != null;
    }

    public static boolean isRunning(CommandContext commandContext, Long processInstanceId) {
        List<JobEntity> jobs = commandContext.getJobEntityManager().findJobsByProcessInstanceId(processInstanceId);
        if (jobs != null && !jobs.isEmpty()) {
            for (JobEntity job : jobs) {
                if (!RuntimeUtil.isRunningJob(job.getJobHandlerType())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isRetring(CommandContext commandContext, Long processInstanceId) {
        List<TimerJobEntity> timerJobs = commandContext.getTimerJobEntityManager().findJobsByProcessInstanceId(processInstanceId);
        if (timerJobs != null && !timerJobs.isEmpty()) {
            for (TimerJobEntity timer : timerJobs) {
                if (!RuntimeUtil.isRunningJob(timer.getJobHandlerType())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isNeedToRemoveFailedJob(String handlerType, String handleCfg) {
        if ("async-todo".equals(handlerType)) {
            JSONObject configuration = JSON.parseObject((String)handleCfg);
            if (configuration == null) {
                return false;
            }
            String modelStr = configuration.getString("model");
            if (WfUtils.isEmpty(modelStr)) {
                return false;
            }
            JSONObject model = JSON.parseObject((String)modelStr);
            String state = model.getString("state");
            return ToDoInfo.State.DEAL.toString().equals(state) || ToDoInfo.State.DELETE.toString().equals(state) || ToDoInfo.State.ONLYCHECK.toString().equals(state);
        }
        return false;
    }

    public static boolean isTaskExist(CommandContext commandContext, String taskId) {
        TaskEntity entity = (TaskEntity)commandContext.getTaskEntityManager().findById(Long.valueOf(taskId));
        return entity != null;
    }

    public static boolean needHandleException(String jobHandlerType) {
        return RuntimeUtil.isRunningJob(jobHandlerType) || "expireModelJobHandler".equalsIgnoreCase(jobHandlerType) || "async-timing".equalsIgnoreCase(jobHandlerType) || "wait-event".equals(jobHandlerType);
    }
}

