/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.util;

import kd.bos.context.RequestContext;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.service.dto.BuildSecureUrlParam;
import kd.bos.servicehelper.login.LoginServiceHelper;
import kd.bos.session.EncreptSessionUtils;
import kd.bos.util.RevProxyUtil;
import kd.bos.util.StringUtils;
import kd.bos.workflow.engine.WfUtils;

public class SecureGuestUrlUtil {
    private static Log logger = LogFactory.getLog(SecureGuestUrlUtil.class);
    private static final Integer EXPIRETIME = 1800;
    private static final Integer ALLOWUSETIMES = 50;

    public static String getSecureUrl(String path, String formId) {
        BuildSecureUrlParam buildSecureUrlParam = SecureGuestUrlUtil.getSecureUrlParam(path, formId);
        if (buildSecureUrlParam == null) {
            logger.warn(String.format("the path is %s, buildSecureUrlParam is null", path));
            return EncreptSessionUtils.encryptSession((String)path);
        }
        return LoginServiceHelper.buildSecureGuestUrl((BuildSecureUrlParam)buildSecureUrlParam);
    }

    private static BuildSecureUrlParam getSecureUrlParam(String url, String formId) {
        String paramValue;
        BuildSecureUrlParam buildSecureUrlParam = new BuildSecureUrlParam();
        if (WfUtils.isNotEmpty(url) && url.contains("path=")) {
            buildSecureUrlParam.setParamName("path");
            paramValue = SecureGuestUrlUtil.getParamValue(url);
            if (!WfUtils.isNotEmpty(paramValue)) {
                return null;
            }
        } else {
            return null;
        }
        buildSecureUrlParam.setParamValue(paramValue);
        buildSecureUrlParam.setUrl(url);
        buildSecureUrlParam.setFormId(formId);
        buildSecureUrlParam.setExpireTime(EXPIRETIME);
        buildSecureUrlParam.setAllowUseTimes(ALLOWUSETIMES);
        return buildSecureUrlParam;
    }

    private static String getParamValue(String url) {
        try {
            String[] pairs;
            String[] pairStr = url.split("\\?");
            if (pairStr != null && pairStr.length > 1 && (pairs = pairStr[1].split("&")) != null && pairs.length > 0) {
                for (int i = 0; i < pairs.length; ++i) {
                    String[] urlParam = pairs[i].split("=");
                    if (urlParam == null || urlParam.length <= 1 || !"path".equalsIgnoreCase(urlParam[0])) continue;
                    return urlParam[1];
                }
            }
        }
        catch (Exception e) {
            logger.warn(" get url param value occurred exception : {}", (Object)e.getMessage());
        }
        return "";
    }

    public static String getScene(IFormView formView) {
        if (formView != null) {
            String modelType = formView.getFormShowParameter().getFormConfig().getModelType();
            String scene = null;
            scene = !"mobilebase".equalsIgnoreCase(modelType) && !"mobilebill".equalsIgnoreCase(modelType) && !"mobileform".equalsIgnoreCase(modelType) && !"mobilelist".equalsIgnoreCase(modelType) ? "pc" : "mob";
            return scene;
        }
        return null;
    }

    public static String encryptURL(String url) {
        StringBuilder conSb = new StringBuilder();
        conSb.append(url).append(RevProxyUtil.getHttpParamCollectFlag((String)url));
        if (StringUtils.isNotEmpty((String)url) && !url.trim().contains("accountId=") && RequestContext.get() != null) {
            if ("&".equalsIgnoreCase(RevProxyUtil.getHttpParamCollectFlag((String)url))) {
                conSb.append("accountId=").append(RequestContext.get().getAccountId());
            } else {
                conSb.append("&").append("accountId=").append(RequestContext.get().getAccountId());
            }
        }
        return conSb.toString();
    }
}

