/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.util;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.entity.format.FormatTypes;
import kd.bos.workflow.engine.impl.calculator.ExpressionCalculatorUtil;

public class SensitiveFieldUtil {
    public static final String SENSITIVENAMES = "sensitiveNames";
    public static final String NEWVALUE = "newValue";
    public static final String OLDVALUE = "oldValue";
    public static final String NAME = "name";

    private SensitiveFieldUtil() {
    }

    public static String buildSensitiveFieldKey(String businesskey, String activityId) {
        return businesskey + activityId.toLowerCase() + "sensitivefieldinfochange";
    }

    public static Object formatValue(Object value) {
        if (value != null) {
            if (value instanceof Date) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
                return format.format(value);
            }
            if (value instanceof BigDecimal) {
                return ExpressionCalculatorUtil.numberOrCurrencyFormat(value, FormatTypes.Currency, null, 2);
            }
            if (value instanceof DynamicObject) {
                return ((DynamicObject)value).getPkValue();
            }
            if (value instanceof MulBasedataDynamicObjectCollection) {
                ArrayList<Long> idList = new ArrayList<Long>();
                MulBasedataDynamicObjectCollection ids = (MulBasedataDynamicObjectCollection)value;
                for (DynamicObject dynObj : ids) {
                    idList.add(dynObj.getLong("fbasedataid_id"));
                }
                return idList;
            }
        }
        return value;
    }
}

