/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.field.SignatureEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.portal.HandWrittenSignServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.Pair;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.SignatureModel;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordGroup;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordItem;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.model.ApprovalHistoryRecord;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.bos.workflow.util.WfCommonUtil;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.ObjectUtils;

public class SignatureUtils {
    private static final Log logger = LogFactory.getLog(SignatureUtils.class);
    public static final String SIGNATURE_FIELD = "signaturefield";
    public static final String SIGNATURE_FIELD_CRD = "signaturefield_crd";
    public static final String ALLOW_SIGNATURE_CACHE = "allow_signature_cache";
    public static final String FORCE_SIGNATURE_CACHE = "force_signature_cache";
    public static final String FLEX_PANEL_AP_SIGNATURE = "flexpanelap_signature";
    public static final String FLEX_PANEL_AP_SIGNATURE_CRD = "flexpanelap_signature_crd";
    public static final String SIGNATURE = "signature";
    public static final String FSIGNATURE = "fsignature";
    public static final String APPROVAL_SIGN = "signature";

    public static void initSignatureFP(IFormView view, boolean isPCShow) {
        SignatureUtils.initSignatureFP(view, isPCShow, FLEX_PANEL_AP_SIGNATURE, SIGNATURE_FIELD);
    }

    public static void initSignatureFP(IFormView view, boolean isPCShow, String flexPanelApSignature, String signatureField) {
        IPageCache pageCache;
        if (WfUtils.isNullObject(view)) {
            return;
        }
        if (isPCShow) {
            pageCache = view.getPageCache();
        } else {
            IFormView parentView = view.getParentView();
            if (WfUtils.isNullObject(parentView)) {
                return;
            }
            pageCache = parentView.getPageCache();
        }
        String control = pageCache.get("taskcontrol");
        if (WfUtils.isEmptyString(control)) {
            return;
        }
        SignatureEdit signatureEdit = (SignatureEdit)view.getControl(signatureField);
        if (WfUtils.isNullObject(signatureEdit)) {
            return;
        }
        Map controlMap = WfCommonUtil.getValueFromMapJson((String)control);
        Boolean isAllowSignature = WfCommonUtil.getBooleanValueFromJson((Map)controlMap, (String)"aS");
        Boolean isForceSignature = WfCommonUtil.getBooleanValueFromJson((Map)controlMap, (String)"fS");
        if (BooleanUtils.toBoolean((Boolean)isAllowSignature)) {
            view.getPageCache().put(ALLOW_SIGNATURE_CACHE, Boolean.TRUE.toString());
            view.setVisible(Boolean.TRUE, new String[]{flexPanelApSignature});
        }
        if (BooleanUtils.toBoolean((Boolean)isForceSignature)) {
            view.getPageCache().put(FORCE_SIGNATURE_CACHE, Boolean.TRUE.toString());
            return;
        }
        signatureEdit.setMustInput(Boolean.FALSE.booleanValue());
        ImmutableMap item = ImmutableMap.of((Object)"mhs", (Object)Boolean.FALSE);
        ImmutableMap prop = ImmutableMap.of((Object)"item", (Object)item);
        view.updateControlMetadata(signatureField, (Map)prop);
        String defaultSignature = SignatureUtils.getDefaultSignature();
        if (WfUtils.isEmpty(defaultSignature)) {
            return;
        }
        view.getModel().setValue(signatureField, (Object)defaultSignature);
    }

    public static String getSignatureFromModel(IFormView view) {
        return SignatureUtils.getSignatureFromModel(view, SIGNATURE_FIELD);
    }

    public static String getSignatureFromModel(IFormView view, String signatureField) {
        if (WfUtils.isNullObject(view.getControl(signatureField))) {
            return "";
        }
        String allowSignatureStr = view.getPageCache().get(ALLOW_SIGNATURE_CACHE);
        if (!BooleanUtils.toBoolean((String)allowSignatureStr)) {
            return "";
        }
        return ObjectUtils.toString((Object)view.getModel().getValue(signatureField));
    }

    public static String checkForceSignature(IPageCache pageCache, String auditSignature) {
        String isForceSignatureStr = pageCache.get(FORCE_SIGNATURE_CACHE);
        boolean isForceSignature = BooleanUtils.toBoolean((String)isForceSignatureStr);
        boolean isSign = isForceSignature && WfUtils.isEmptyString(auditSignature);
        return isSign ? ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u5b8c\u6210\u624b\u5199\u7b7e\u540d\u3002", (String)"SignatureUtils_2", (String)"bos-wf-engine", (Object[])new Object[0]) : "";
    }

    public static String getSignatureByCache(IPageCache pageCache, String auditSignature) {
        boolean isAllowSignature = BooleanUtils.toBoolean((String)pageCache.get(ALLOW_SIGNATURE_CACHE));
        return isAllowSignature ? auditSignature : "";
    }

    private static String getDefaultSignature() {
        long currUserId = RequestContext.get().getCurrUserId();
        return SignatureUtils.getDefaultSignature(currUserId);
    }

    public static String getDefaultSignatureIfAllow(TaskInfo taskInfo, Long currUserId) {
        if (SignatureUtils.isNotAllowSignature(taskInfo)) {
            return "";
        }
        return SignatureUtils.getDefaultSignature(currUserId);
    }

    private static String getDefaultSignature(long currUserId) {
        try {
            return HandWrittenSignServiceHelper.getHandWrittenSign((Long)currUserId);
        }
        catch (Exception e) {
            logger.warn("the getHandWrittenSign api is err msg:{0}, stackTrace:{1}", (Object)e.getMessage(), (Object)WfUtils.getExceptionStacktrace(e));
            return "";
        }
    }

    public static List<AuditTask> filterOutCompositeSignatureNode(FlowNode node) {
        if (!node.getFork().booleanValue()) {
            return null;
        }
        List<SequenceFlow> outgoingFlows = node.getOutgoingFlows();
        Boolean isSignature = null;
        if (WfUtils.isEmptyForCollection(outgoingFlows)) {
            return null;
        }
        ArrayList res = Lists.newArrayListWithExpectedSize((int)outgoingFlows.size());
        for (SequenceFlow seq : outgoingFlows) {
            AuditTask auditTask;
            FlowElement targetFlowElement = seq.getTargetFlowElement();
            if (WfUtils.isNullObject(targetFlowElement) || !Objects.equals(targetFlowElement.getClass(), AuditTask.class) && !Objects.equals(targetFlowElement.getClass(), YunzhijiaTask.class) || !(auditTask = (AuditTask)targetFlowElement).isCompositeTasks()) continue;
            boolean curIsSignature = SignatureUtils.isAllowSignature(auditTask);
            if (WfUtils.isNullObject(isSignature)) {
                isSignature = curIsSignature;
                continue;
            }
            if (Objects.equals(curIsSignature, isSignature)) continue;
            res.add(auditTask);
        }
        return res;
    }

    private static boolean notInstanceofAuditTask(Object flowElement) {
        return !(flowElement instanceof AuditTask);
    }

    private static boolean isAllowSignature(FlowElement flowElement) {
        if (SignatureUtils.notInstanceofAuditTask(flowElement)) {
            return Boolean.FALSE;
        }
        AuditTask auditTask = (AuditTask)flowElement;
        SignatureModel signatureModel = auditTask.getSignatureModel();
        return SignatureUtils.isAllowSignature(signatureModel);
    }

    private static boolean isNotAllowSignature(TaskInfo taskInfo) {
        if (WfUtils.isNullObject(taskInfo)) {
            return Boolean.TRUE;
        }
        Map controlMap = WfCommonUtil.getValueFromMapJson((String)taskInfo.getControl());
        return !WfCommonUtil.getBooleanValueFromJson((Map)controlMap, (String)"aS");
    }

    private static boolean isAllowSignature(SignatureModel signatureModel) {
        return WfUtils.isNotNullObject(signatureModel) && signatureModel.isAllowSignature();
    }

    public static Pair<Boolean, Boolean> getSignatureValue(AuditTask auditTask) {
        SignatureModel signatureModel = auditTask.getSignatureModel();
        boolean allowSignature = SignatureUtils.isAllowSignature(signatureModel);
        boolean forceSignature = allowSignature && signatureModel.isForceSignature();
        return new Pair((Object)allowSignature, (Object)forceSignature);
    }

    public static void handleApprovalRecordGrpApiSignature(List<IApprovalRecordGroup> approvalRecordGroups) {
        if (WfUtils.isEmptyForCollection(approvalRecordGroups)) {
            return;
        }
        approvalRecordGroups.forEach(t -> SignatureUtils.handleApprovalRecordApiSignature(t.getChildren()));
    }

    public static void handleApprovalRecordApiSignature(List<IApprovalRecordItem> approvalRecordItems) {
        if (WfUtils.isEmptyForCollection(approvalRecordItems)) {
            return;
        }
        approvalRecordItems.forEach(t -> {
            if (WfUtils.isNotEmpty(t.getSignature())) {
                t.setSignature(null);
            }
        });
    }

    public static void handleApprovalRecordSignatureUrl(Map<String, Object> coordinateRecordMap, String signature) {
        if (WfUtils.isNotEmpty(signature)) {
            coordinateRecordMap.put("signature", AttachmentServiceHelper.getEncreptURL((String)UrlService.getImageFullUrl((String)signature)));
        }
    }

    public static void handleApprovalRecordSignatureUrl(IApprovalRecordItem child, String signature) {
        if (WfUtils.isNotEmpty(signature)) {
            child.setSignature(AttachmentServiceHelper.getEncreptURL((String)UrlService.getImageFullUrl((String)signature)));
        }
    }

    public static void handleApprovalRecordSignatureUrl(IApprovalRecordItem child) {
        String signature = child.getSignature();
        SignatureUtils.handleApprovalRecordSignatureUrl(child, signature);
    }

    public static void handleApprovalRecordSignatureUrl(List<IApprovalRecordItem> records) {
        if (WfUtils.isEmptyForCollection(records)) {
            return;
        }
        for (IApprovalRecordItem child : records) {
            SignatureUtils.handleApprovalRecordSignatureUrl(child);
        }
    }

    public static void handleApprovalHisRecordSignatureUrl(List<ApprovalHistoryRecord> records) {
        if (WfUtils.isEmptyForCollection(records)) {
            return;
        }
        for (IApprovalRecordItem iApprovalRecordItem : records) {
            SignatureUtils.handleApprovalRecordSignatureUrl(iApprovalRecordItem);
        }
    }

    public static void handleApprovalGroupSignatureUrl(List<IApprovalRecordGroup> approvalRecordItems) {
        for (IApprovalRecordGroup approvalRecordItem : approvalRecordItems) {
            List children = approvalRecordItem.getChildren();
            SignatureUtils.handleApprovalRecordSignatureUrl(children);
        }
    }
}

