/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.util;

import com.alibaba.fastjson.JSONObject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.dlock.DLock;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.workflow.api.constants.WFAuditResultTypeEnum;
import kd.bos.workflow.bpmn.converter.util.CollectionUtils;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.AutoAudit;
import kd.bos.workflow.bpmn.model.BillSetting;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.Circulate;
import kd.bos.workflow.bpmn.model.CirculateModel;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.PageParameter;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SelectNodesModel;
import kd.bos.workflow.bpmn.model.SensitiveField;
import kd.bos.workflow.bpmn.model.SensitiveFieldInfo;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.domain.model.NodeForkJoinModel;
import kd.bos.workflow.engine.EntityNumberConstant;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.TaskService;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfAfterAuditUtil;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.delegate.event.ActivitiEventDispatcher;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import kd.bos.workflow.engine.identity.User;
import kd.bos.workflow.engine.impl.WfTracerHelper;
import kd.bos.workflow.engine.impl.agenda.AbstractOperation;
import kd.bos.workflow.engine.impl.agenda.ContinueProcessOperation;
import kd.bos.workflow.engine.impl.agenda.ForkJoinUtils;
import kd.bos.workflow.engine.impl.agenda.callback.PlanAutoAuditOperationCallback;
import kd.bos.workflow.engine.impl.asyncexecutor.JobManager;
import kd.bos.workflow.engine.impl.bpmn.behavior.TaskBehaviorUtil;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.calculator.ExpressionCalculatorUtil;
import kd.bos.workflow.engine.impl.calculator.ParticipantCalculator;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cmd.management.AbandonProcessCmd;
import kd.bos.workflow.engine.impl.cmd.management.delegatesetting.ResumeDelegateTasksCmd;
import kd.bos.workflow.engine.impl.cmd.precomputation.PreComputorHelper;
import kd.bos.workflow.engine.impl.cmd.task.AddTaskGroupCmd;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandConfig;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.DefaultCommandContextCloseListener;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricAttachmentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricAttachmentEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricVariableInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricVariableInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.ManagementConstants;
import kd.bos.workflow.engine.impl.persistence.entity.management.ParticipantModelEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.delegatesetting.DelegateSettingEntity;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.OperationLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.OperationLogEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.OperationLogEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.RuleTaskRelationEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.RuleTaskRelationEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskMarkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskToDoGroupEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskToDoGroupEntityManager;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.DynamicFlowUtil;
import kd.bos.workflow.engine.impl.util.ParticipantHelper;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.SensitiveFieldUtil;
import kd.bos.workflow.engine.impl.util.SignatureUtils;
import kd.bos.workflow.engine.impl.util.WfOperationLogUtil;
import kd.bos.workflow.engine.impl.util.condition.ConditionType;
import kd.bos.workflow.engine.impl.util.condition.ConditionUtil;
import kd.bos.workflow.engine.impl.variable.ValueFields;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.engine.msg.MessageTypeEnum;
import kd.bos.workflow.engine.msg.ctx.MessageContext;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.engine.msg.quantitysum.MessageQuantitySummaryServcie;
import kd.bos.workflow.engine.msg.quantitysum.QuantitySummary;
import kd.bos.workflow.engine.precomputor.IPreComputorRecord;
import kd.bos.workflow.engine.precomputor.IPreComputorRecordItem;
import kd.bos.workflow.engine.runtime.Execution;
import kd.bos.workflow.engine.task.Comment;
import kd.bos.workflow.engine.task.DelegationState;
import kd.bos.workflow.engine.task.Task;
import kd.bos.workflow.engine.task.TaskUtils;
import kd.bos.workflow.exception.WFCirculateParserException;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFObjectNotFoundException;
import kd.bos.workflow.exception.WFProInstanceException;
import kd.bos.workflow.feature.taskfield.util.TaskExtendFieldUtil;
import kd.bos.workflow.relservice.BusinessLogicServiceHelper;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import org.apache.commons.lang.StringUtils;

public class TaskHelper {
    private Log log = LogFactory.getLog(this.getClass());
    private static final String SPERATER = "%s(%s)";
    private static final String SENSITIVECHANGLOG = "sensitiveChangeLog";
    private static final String SENSITIVECHANGMSG = "sensitiveChangeMsg";
    public static final String LANG = "Lang";

    public Comment addComment(Long taskId, Long processInstanceId, Long userId, String type, Map<String, Object> variables) {
        Map<String, Object> sensitiveInfo;
        ExecutionEntity executionEntity;
        FlowElement flowElement;
        CommandContext commandContext = Context.getCommandContext();
        TaskEntity task = null;
        if (taskId != null) {
            task = (TaskEntity)commandContext.getTaskEntityManager().findById(taskId);
            if (task == null) {
                throw new WFObjectNotFoundException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u4efb\u52a1\u201c%s\u201d\uff0c\u53ef\u80fd\u5df2\u5220\u9664\u3002", (String)"TaskHelper_1", (String)"bos-wf-engine", (Object[])new Object[0]), taskId), Task.class);
            }
            if (task.isSuspended()) {
                throw new WFEngineException(ResManager.loadKDString((String)"\u4e0d\u80fd\u7ed9\u6302\u8d77\u7684\u4efb\u52a1\u6dfb\u52a0\u5b8c\u6210\u4fe1\u606f\u3002", (String)"TaskHelper_2", (String)"bos-wf-engine", (Object[])new Object[0]));
            }
        }
        ExecutionEntity execution = null;
        if (processInstanceId != null) {
            execution = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(processInstanceId);
            if (execution == null) {
                throw new WFObjectNotFoundException("execution " + processInstanceId + " doesn't exist", Execution.class);
            }
            if (execution.isSuspended()) {
                throw new WFProInstanceException(WFErrorCode.createEngineSuspendError(), new Object[0]);
            }
        }
        Long processDefinitionId = null;
        if (execution != null) {
            processDefinitionId = execution.getProcessDefinitionId();
        } else if (task != null) {
            processDefinitionId = task.getProcessDefinitionId();
        }
        if (userId == null || userId == 0L) {
            String currentUserId = RequestContext.get().getUserId();
            userId = currentUserId == null ? 0L : Long.parseLong(currentUserId);
        }
        Long ownerId = this.findOwnerId(userId, task);
        CommentEntity comment = (CommentEntity)commandContext.getCommentEntityManager().create();
        comment.setUserId(userId);
        comment.setType(type == null ? "comment" : type);
        comment.setTime(commandContext.getProcessEngineConfiguration().getClock().getCurrentTime());
        comment.setTaskId(taskId);
        comment.setOwnerId(ownerId);
        comment.setProcessInstanceId(processInstanceId);
        if (task != null) {
            comment.setActivityId(task.getTaskDefinitionKey());
            comment.setProcessType(task.getProcessType());
            comment.setCreateDate(task.getCreateDate() == null ? WfUtils.now() : task.getCreateDate());
        }
        if (task != null && task.getSource().equalsIgnoreCase("wf")) {
            comment.setStep(commandContext.getCommentEntityManager().calculateStep(processInstanceId));
        } else {
            comment.setStep(0);
        }
        if (task != null && !WfUtils.isEmpty(task.getParentTaskId())) {
            comment.setGroupId(String.valueOf(task.getParentTaskId()));
        }
        if (task != null && WfUtils.isNotEmpty(task.getProcessDefinitionId()) && WfUtils.isNotEmpty(task.getTaskDefinitionKey()) && (flowElement = ProcessDefinitionUtil.getBpmnModel(task.getProcessDefinitionId(), task.getProcessInstanceId()).getFlowElement(task.getTaskDefinitionKey())) instanceof YunzhijiaTask) {
            YunzhijiaTask yunzhijiaTask = (YunzhijiaTask)flowElement;
            comment.setBackToBack(yunzhijiaTask.getBackToBackVote());
        }
        if (variables != null) {
            List<IdentityLinkEntity> identityLinks;
            ILocaleString userName;
            Object auditTime = variables.get("auditTime");
            if (null != auditTime) {
                comment.setTime(new Date((Long)auditTime));
                variables.remove("auditTime");
            }
            comment.setResultNumber((String)variables.get("auditNumber"));
            ILocaleString result = WfUtils.getLocaleStringVariable(variables, "auditName");
            comment.setResultName(result);
            Object auditMessage = variables.get("auditMessage");
            Object message = null;
            message = auditMessage instanceof Map ? LocaleString.fromMap((Map)((Map)auditMessage)) : WfUtils.getMultiLangValue(auditMessage != null ? auditMessage.toString() : "");
            comment.setMessage((ILocaleString)message);
            Object auditSignature = variables.get("signature");
            if (auditSignature instanceof String) {
                comment.setSignature((String)auditSignature);
            }
            String richTextMessage = (String)variables.get("richTextMessage");
            comment.setRichTextMessage(richTextMessage);
            if (WfUtils.isNotEmptyString(variables.get("assignee"))) {
                Object obj = variables.get("assignee");
                if (obj instanceof ILocaleString && !WfUtils.isEmpty(((ILocaleString)obj).toString())) {
                    comment.setAssignee((ILocaleString)obj);
                } else if (obj instanceof String) {
                    LocaleString localStr = new LocaleString();
                    localStr.setLocaleValue((String)obj);
                    if (!WfUtils.isEmpty(localStr.toString())) {
                        comment.setAssignee((ILocaleString)localStr);
                    }
                }
            } else if (userId != null && userId > 0L && (userName = WfUtils.findUserName(userId)) != null && !WfUtils.isEmpty(userName.toString())) {
                comment.setAssignee(userName);
            }
            ILocaleString assigneeFormat = (ILocaleString)variables.get("assigneeFormat");
            comment.setUserNameFormatter(assigneeFormat);
            if (task != null && (identityLinks = task.getIdentityLinks()) != null && !identityLinks.isEmpty()) {
                QFilter filter1 = new QFilter("userid", "=", (Object)userId);
                QFilter filter2 = new QFilter("taskid", "=", (Object)taskId);
                QFilter[] filters = new QFilter[]{filter1, filter2};
                HashMap<String, Long> paramMap = new HashMap<String, Long>(2);
                paramMap.put("taskId", taskId);
                paramMap.put("userId", userId);
                List<IdentityLinkEntity> identityLinkEntity = commandContext.getIdentityLinkEntityManager().findIdentityLinksByFilters(filters, paramMap, true);
                ILocaleString userNameFormatter = null;
                if (identityLinkEntity != null && !identityLinkEntity.isEmpty()) {
                    userNameFormatter = identityLinkEntity.get(0).getUserNameFormatter();
                    if (WfUtils.isNotEmpty(identityLinkEntity.get(0).getCurrentSubject())) {
                        comment.setCurrentSubject(identityLinkEntity.get(0).getCurrentSubject());
                    }
                }
                if (WfUtils.isEmpty(assigneeFormat)) {
                    if (WfUtils.isEmpty(userNameFormatter)) {
                        Map<Long, ILocaleString> userNameFormatterMap = ParticipantHelper.getParticipantDisplayInfo(task, Collections.singletonList(userId));
                        userNameFormatter = userNameFormatterMap.get(userId);
                    }
                    comment.setUserNameFormatter(userNameFormatter);
                }
                this.setCommentAssignorName(userId, ownerId, comment, identityLinks, variables);
            }
            comment.setDecisionType((String)variables.get("auditType"));
            String terminal = (String)variables.get("terminal");
            comment.setTerminalWay(WfUtils.isEmpty(terminal) ? RequestContext.get().getClient() : terminal);
        }
        LocaleString note = null;
        if (task != null && (executionEntity = task.getExecution()) != null && (sensitiveInfo = this.initSensitiveFielsChangeInfo(variables, executionEntity.getBusinessKey(), executionEntity.getActivityId())).get(SENSITIVECHANGMSG) != null) {
            comment.setSensitivefieldchange((ILocaleString)((LocaleString)sensitiveInfo.get(SENSITIVECHANGMSG)));
            note = (LocaleString)sensitiveInfo.get(SENSITIVECHANGLOG);
        }
        TaskHelper.updateHiCommentRedundancyFieldFromOtherTable(commandContext, task, comment);
        if (task != null) {
            String processType = task.getProcessType();
            if (ModelType.NoCodeFlow.name().equalsIgnoreCase(processType) && variables.get("nextNodeId") != null && "reject".equalsIgnoreCase(comment.getDecisionType())) {
                FlowElement flowElement2 = ProcessDefinitionUtil.getBpmnModel(task.getProcessDefinitionId(), task.getProcessInstanceId()).getFlowElement(variables.get("nextNodeId").toString());
                task.setTransientVariable("rejectActivityId", variables.get("nextNodeId").toString());
                task.setTransientVariable("rejectActivityName", flowElement2.getName());
            }
        }
        commandContext.getCommentEntityManager().insert(comment);
        if (null == variables || null == variables.get("savedLogMark")) {
            WfOperationLogUtil.recordOperationLogFromComment(commandContext, comment, note, null);
        } else {
            variables.remove("savedLogMark");
            QFilter q1 = new QFilter("taskId", "=", (Object)taskId);
            QFilter q2 = new QFilter("type", "=", (Object)"comment");
            OperationLogEntityManager operationLogEntityManager = commandContext.getOperationLogEntityManager();
            List operationLogEntities = operationLogEntityManager.findByQueryFilters(new QFilter[]{q1, q2});
            if (CollectionUtils.isNotEmpty(operationLogEntities)) {
                for (OperationLogEntity operationLogEntity : operationLogEntities) {
                    operationLogEntity.setCommentId(comment.getId());
                }
            }
        }
        return comment;
    }

    public static void updateHiCommentRedundancyFieldFromOtherTable(CommandContext commandContext, TaskEntity task, CommentEntity comment) {
        if (task != null) {
            comment.setBillNo(task.getBillNo());
            comment.setEntityName(task.getEntityName());
            comment.setSenderNameFormat(WfMultiLangUtils.subString(task.getSenderNameFormat(), 0, 255));
            comment.setStarterId(task.getStarterId());
            comment.setProcessingPage(task.getProcessingPage());
            comment.setProcessingMobilePage(task.getProcessingMobilePage());
            comment.setHandleState(task.getHandleState());
            comment.setCategory(StringUtils.substring((String)task.getCategory(), (int)0, (int)50));
            comment.setSenderName(WfMultiLangUtils.subString(task.getSenderName(), 0, 400));
            comment.setCreateDate(task.getCreateDate());
            comment.setExecutionType(task.getExecutionType());
            HistoricTaskInstanceEntity hiTask = (HistoricTaskInstanceEntity)commandContext.getHistoricTaskInstanceEntityManager().findById(task.getId());
            comment.setDisplay(hiTask != null ? hiTask.isDisplay() : task.isDisplay());
            comment.setEndType(task.getEndType());
            comment.setBillType(task.getBillType());
            comment.setSource(task.getSource());
            comment.setSourceName(task.getSourceName());
            comment.setStartName(WfMultiLangUtils.subString(task.getStartName(), 0, 255));
            comment.setStartNameFormat(WfMultiLangUtils.subString(task.getStartNameFormat(), 0, 255));
            comment.setBusinessDate(task.getBusinessDate());
            comment.setBusinessFormat(task.getBusinessFormat());
            comment.setBusinessNumber(task.getBusinessNumber());
            comment.setBusinessStr1(StringUtils.substring((String)task.getBusinessStr1(), (int)0, (int)255));
            comment.setBusinessStr2(StringUtils.substring((String)task.getBusinessStr2(), (int)0, (int)255));
            comment.setBusinessDate2(task.getBusinessDate2());
            comment.setBusinessNumber2(task.getBusinessNumber2());
            comment.setBusinessMulStr1(WfUtils.subILocaleString(task.getBusinessMulStr1(), 255));
            comment.setBusinessMulStr2(WfUtils.subILocaleString(task.getBusinessMulStr2(), 255));
            TaskExtendFieldUtil.setExtendTaskBusinessField(comment.getDynamicObject(), task.getDynamicObject());
        }
    }

    private Map<String, Object> initSensitiveFielsChangeInfo(Map<String, Object> variables, String businessKey, String activityId) {
        Object object;
        Map sensitiveFieldInfoMap;
        String sensitiveInfoChangeKeyChange;
        HashMap<String, Object> sensitiveInfo = new HashMap<String, Object>(2);
        String sensitiveInfoChangeKey = SensitiveFieldUtil.buildSensitiveFieldKey(businessKey, activityId);
        String string = sensitiveInfoChangeKeyChange = variables != null ? (String)variables.get(sensitiveInfoChangeKey) : "";
        if (StringUtils.isNotBlank((String)sensitiveInfoChangeKeyChange) && (sensitiveFieldInfoMap = (Map)SerializationUtils.fromJsonString((String)sensitiveInfoChangeKeyChange, Map.class)) != null && !sensitiveFieldInfoMap.isEmpty() && !WfUtils.isNullObject(object = sensitiveFieldInfoMap.get(SENSITIVECHANGMSG))) {
            LocaleString sensitiveChangeMsg = new LocaleString();
            String sensitiveChangeMsgStr = SerializationUtils.toJsonString(object);
            for (Lang lang : WfUtils.getSupportLangs()) {
                sensitiveChangeMsg.put((Object)lang.name(), (Object)sensitiveChangeMsgStr);
            }
            sensitiveInfo.put(SENSITIVECHANGMSG, sensitiveChangeMsg);
            sensitiveInfo.put(SENSITIVECHANGLOG, LocaleString.fromMap((Map)((Map)sensitiveFieldInfoMap.get(SENSITIVECHANGLOG))));
        }
        return sensitiveInfo;
    }

    public static ILocaleString mulitLangAppend(ILocaleString lString1, ILocaleString lString2) {
        return WfMultiLangUtils.jointILocaleString(lString1, lString2, "");
    }

    public static ILocaleString mulitLangAppendString(ILocaleString lString, String string) {
        for (Lang lang : WfUtils.getSupportLangs()) {
            String l = lang.toString();
            String itemStr = WfUtils.isEmpty((String)lString.getItem(l)) ? "" : (String)lString.getItem(l);
            lString.setItem(l, (Object)(itemStr + string));
        }
        return lString;
    }

    private void setCommentAssignorName(Long userId, Long ownerId, CommentEntity comment, List<IdentityLinkEntity> identityLinks, Map<String, Object> variables) {
        for (IdentityLinkEntity identityLink : identityLinks) {
            ILocaleString assignorName;
            if (WfUtils.isEmpty(identityLink.getDelegateId()) || ownerId == null || ownerId.equals(userId) || WfUtils.isEmpty(assignorName = WfUtils.findUserName(ownerId))) continue;
            comment.setAssignorName(assignorName);
            comment.setDelegateId(identityLink.getDelegateId());
        }
    }

    public void addHiAttachment(Comment comment, Map<String, Object> varaibles) {
        Object procAttachObject = varaibles.get("procAttachInfos");
        if (WfUtils.isNullObject(procAttachObject)) {
            return;
        }
        List procAttachInfos = null;
        if (procAttachObject instanceof String) {
            procAttachInfos = (List)SerializationUtils.fromJsonString((String)procAttachObject.toString(), List.class);
        } else if (procAttachObject instanceof List) {
            procAttachInfos = (List)procAttachObject;
        }
        if (null != comment && null != procAttachInfos && !procAttachInfos.isEmpty()) {
            CommandContext commandContext = Context.getCommandContext();
            HistoricAttachmentEntityManager entityManager = commandContext.getHistoricAttachmentEntityManager();
            for (Map procAttachInfo : procAttachInfos) {
                HistoricAttachmentEntity entity = (HistoricAttachmentEntity)entityManager.create();
                entity.setUserId(comment.getUserId());
                Map dynamicObject = (Map)procAttachInfo.get("dynamicObject");
                if (dynamicObject != null && !dynamicObject.isEmpty()) {
                    Map nameMap;
                    LocaleString name = new LocaleString();
                    Object nameObject = dynamicObject.get("name");
                    if (nameObject != null && (nameMap = (Map)nameObject) != null && !nameMap.isEmpty()) {
                        for (Map.Entry entry : nameMap.entrySet()) {
                            name.setItem((String)entry.getKey(), (Object)((String)entry.getValue()));
                        }
                    }
                    entity.setName((ILocaleString)name);
                    entity.setUrlId((Long)dynamicObject.get("urlid"));
                } else {
                    Object aid = procAttachInfo.get("attachmentId");
                    Object name = procAttachInfo.get("attachmentName");
                    if (aid != null) {
                        Long attachmentId = null;
                        if (aid instanceof Long) {
                            attachmentId = (Long)aid;
                        } else if (aid instanceof String) {
                            try {
                                attachmentId = Long.parseLong(aid.toString());
                            }
                            catch (Exception e) {
                                this.log.debug("\u3010sonar\u5ba1\u8ba1\u3011\u4e0d\u80fd\u4e3a\u7a7acatch");
                            }
                        }
                        entity.setUrlId(attachmentId);
                    }
                    if (name != null) {
                        ILocaleString attachmentName = null;
                        if (name instanceof ILocaleString) {
                            attachmentName = (ILocaleString)name;
                        } else if (name instanceof String) {
                            attachmentName = new LocaleString(name.toString());
                        } else if (name instanceof Map) {
                            attachmentName = new LocaleString();
                            Set keys = ((Map)name).entrySet();
                            for (Map.Entry entry : keys) {
                                attachmentName.setItem((String)entry.getKey(), entry.getValue());
                            }
                        }
                        entity.setName(attachmentName);
                    }
                }
                entity.setType(comment.getType());
                entity.setTaskId(comment.getTaskId());
                entity.setProcessInstanceId(comment.getProcessInstanceId());
                entity.setContentId(comment.getId());
                entityManager.insert(entity);
            }
        }
    }

    private Long findOwnerId(Long userId, TaskEntity task) {
        if (userId != null && userId > 0L && task.getIdentityLinks() != null && task.getIdentityLinks().size() > 0) {
            List<IdentityLinkEntity> users = task.getIdentityLinks();
            for (IdentityLinkEntity user : users) {
                if (user == null || !userId.equals(user.getUserId()) || !WfUtils.isNotEmpty(user.getOwnerId()) || !"participant".equals(user.getType())) continue;
                return user.getOwnerId();
            }
        }
        return null;
    }

    public void setLastUsedDealNode(DelegateExecution execution, CommandContext commandContext, FlowNode userTask) {
        block8: {
            Object lastNodeVar = execution.getVariableLocal("lastUserDealNode");
            this.log.debug("\u83b7\u53d6\u53d8\u91cf\u53c2\u6570lastuserdealNode:" + lastNodeVar);
            if (lastNodeVar != null) {
                if ("startProcessInstance".equals(lastNodeVar) || "startStrongControl".equals(lastNodeVar)) {
                    execution.setVariableLocal("lastUserDealNode", "start");
                } else if (WfConfigurationUtil.isAllowBillUnsubmitAfterUserNode()) {
                    try {
                        FlowElement ele = ProcessDefinitionUtil.getFlowElement(execution.getProcessDefinitionId(), execution.getProcessInstanceId(), (String)lastNodeVar);
                        if (!"UserTask".equals(ele.getType())) break block8;
                        boolean isSubExeReThrough = false;
                        if (((ExecutionEntity)execution).getSuperExecution() != null) {
                            List<HistoricActivityInstanceEntity> actInsts = commandContext.getHistoricActivityInstanceEntityManager().findByActivityId(execution.getProcessInstanceId(), (String)lastNodeVar);
                            boolean bl = isSubExeReThrough = actInsts.size() > 1;
                        }
                        if (isSubExeReThrough) break block8;
                        List<DecisionOption> options = ((UserTask)ele).getDecisionOptions();
                        for (DecisionOption option : options) {
                            if (!"submit".equals(option.getNumber())) continue;
                            execution.setVariableLocal("lastUserDealNode", "start");
                            this.log.debug(String.format("\u7ecf\u8fc7\u8282\u70b9%s\u8bbe\u7f6e\u4e0a\u4e00\u6b65\u53d8\u91cflastUserdealNode%s", userTask.getId(), "start"));
                            break;
                        }
                    }
                    catch (Exception e) {
                        this.log.warn(String.format("\u8bbe\u7f6e\u53d8\u91cf\u9519\u8bef\uff1a%s", WfUtils.getExceptionStacktrace(e)));
                    }
                }
            }
        }
    }

    public void CompleteTask(TaskEntity task, Long userId, Map<String, Object> variables, boolean localScope) {
        this.completeTaskWithOutContinue(task, userId, variables, localScope);
        CommandContext commandContext = Context.getCommandContext();
        if (variables != null && "terminate".equals(variables.get("auditType")) && !ModelType.NoCodeFlow.name().equals(task.getProcessType())) {
            this.log.debug("terminate by complete task, try to terminate other process");
            this.terminateAllProcessInstance(commandContext, task, variables);
            return;
        }
        this.planExecutionOperationAsync(commandContext, task);
    }

    private void terminateAllProcessInstance(CommandContext commandContext, TaskEntity task, Map<String, Object> variables) {
        ExecutionEntity execution;
        UserTask userTask;
        List<DecisionOption> decisionOptions;
        String taskDefinitionKey;
        if (task == null || variables == null) {
            return;
        }
        String auditNumber = (String)variables.get("auditNumber");
        String auditType = (String)variables.get("auditType");
        boolean isTerminateMainProcessScene = false;
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(task.getProcessDefinitionId(), task.getProcessInstanceId());
        FlowElement flowElement = bpmnModel.getFlowElement(taskDefinitionKey = task.getTaskDefinitionKey());
        if (BpmnModelUtil.instanceofUserTask(flowElement.getType()) && kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)auditNumber) && kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)auditType) && WfUtils.isNotEmptyForCollection(decisionOptions = (userTask = (UserTask)flowElement).getDecisionOptions())) {
            DecisionOption decisionOption = decisionOptions.stream().filter(option -> auditNumber.equals(option.getNumber()) && auditType.equals(option.getAuditType())).findFirst().orElse(null);
            boolean bl = isTerminateMainProcessScene = decisionOption != null && decisionOption.isTerminateMainProcessScene();
        }
        if ((execution = task.getExecution()) != null) {
            String dynType = isTerminateMainProcessScene && execution.getSuperExecutionId() != null ? "forceAbortAll" : "forceAbort";
            Long processInstanceId = execution.getProcessInstanceId();
            Long triggerExecutionId = execution.getId();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("auditAbort_sourceProcessInstanceId", processInstanceId);
            String triggerKey = String.format("%s_%s", processInstanceId, "triggerExecutionId");
            params.put(triggerKey, triggerExecutionId);
            new AbandonProcessCmd(processInstanceId, null, dynType, params).execute(commandContext);
        }
    }

    public void completeCustomTask(TaskEntity task, Long userId, Map<String, Object> variables) {
        if (task == null) {
            return;
        }
        StringBuilder logInfo = new StringBuilder();
        CommandContext commandContext = Context.getCommandContext();
        logInfo.append(task.getBillNo()).append(' ');
        logInfo.append(task.getName().getLocaleValue());
        Object compensation = WfUtils.pop(variables, "taskCompensation");
        if (variables != null) {
            Object auditName;
            Object auditMessage = variables.get("auditMessage");
            if (auditMessage instanceof Map) {
                variables.put("auditMessage", SerializationUtils.toJsonString((Object)auditMessage));
            }
            if ((auditName = variables.get("auditName")) instanceof Map) {
                variables.put("auditName", SerializationUtils.toJsonString((Object)auditName));
            }
            logInfo.append(String.format("[%s-%s-%s]", variables.get("auditNumber"), variables.get("auditName"), variables.get("auditType")));
        }
        ILocaleString userName = null;
        if (userId == null || userId == 0L) {
            String currentUserId = RequestContext.get().getUserId();
            userId = currentUserId == null ? 0L : Long.parseLong(currentUserId);
            userName = WfUtils.findUserName(userId);
        } else if (userId.equals(-1L)) {
            ILocaleString assignee = null;
            if (variables != null) {
                assignee = WfUtils.getLocaleStringVariable(variables, "assignee");
            }
            ILocaleString iLocaleString = userName = assignee != null ? assignee : WfUtils.getAutoApproverName();
        }
        if (userName == null) {
            userName = WfUtils.findUserName(userId);
        }
        logInfo.append(userName);
        commandContext.getTaskEntityManager().changeTaskAssignee(task, userId, userName);
        this.executeTaskComplete(commandContext, task, userId, variables, Boolean.TRUE);
        if ("enterBoundary".equals(task.getExecutionType())) {
            return;
        }
        this.executeSubscribeEvent(variables, task.getId(), commandContext);
        this.sendYunzhijiaMsgBySubscribe(Boolean.FALSE, commandContext, task, variables);
        this.sendDealResultMsgToAssignor(Boolean.FALSE, commandContext, task, userId, variables);
        boolean isSSCApprove = "SSCApprove".equals(task.getCategory());
        if (!Boolean.FALSE.booleanValue() && task != null && compensation == null && !isSSCApprove) {
            commandContext.getMessageService().dealToDo(task, Long.parseLong(RequestContext.get().getUserId()), false);
        }
        WfUtils.addOpLog("wf_task", "completeTask", new MultiLangEnumBridge("\u5b8c\u6210\u4efb\u52a1", "TaskHelper_7", "bos-wf-engine"), null, String.format("[%s]%s", task.getId(), logInfo.toString()));
    }

    public void completeTaskWithOutContinue(TaskEntity task, Long userId, Map<String, Object> variables, boolean localScope) {
        boolean isSSCImageUpload;
        if (task == null) {
            return;
        }
        StringBuilder logInfo = new StringBuilder();
        if (WfUtils.isNotEmpty(task.getId())) {
            TaskHelper.setDeletedCache(task.getProcessInstanceId(), new String[]{String.valueOf(task.getId())});
        }
        CommandContext commandContext = Context.getCommandContext();
        boolean autoAudit = variables != null && variables.get("autoAudit") != null ? (Boolean)variables.get("autoAudit") : false;
        logInfo.append(task.getBillNo()).append(' ');
        logInfo.append(task.getName().toString());
        if (autoAudit) {
            variables.remove("autoAudit");
            logInfo.append(ResManager.loadKDString((String)" \u81ea\u52a8\u5ba1\u6838  ", (String)"TaskHelper_4", (String)"bos-wf-engine", (Object[])new Object[0]));
        } else if (BpmnModelUtil.instanceofAuditTask(task.getCategory())) {
            logInfo.append(ResManager.loadKDString((String)" \u4eba\u5de5\u5ba1\u6838  ", (String)"TaskHelper_5", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        Object compensation = WfUtils.pop(variables, "taskCompensation");
        if (variables != null) {
            Object auditType;
            Object auditName;
            Object auditMessage;
            task.removeTransientVariable("auditNumber");
            if (variables.get("auditType") != null && "approve".equals(variables.get("auditType")) && "dismissed".equals(task.getHandleState())) {
                String currentNodeId = task.getTaskDefinitionKey();
                Long processInstanceId = task.getProcessInstanceId();
                Long currentActInstId = task.getExecution().getCurrentActInstId();
                Process process = ProcessDefinitionUtil.getProcess(task.getProcessDefinitionId(), processInstanceId);
                String rejectNodeId = this.getRejectNodeId(processInstanceId, currentActInstId);
                UserTask ut = (UserTask)process.getFlowElement(currentNodeId);
                if (ut.isBackRejectedActivity() && WfUtils.isNotEmpty(rejectNodeId)) {
                    variables.put("nextNodeId", rejectNodeId);
                    variables.put("dynName", ResManager.loadKDString((String)"\u9a73\u56de\u540e\u518d\u5904\u7406", (String)"TaskHelper_6", (String)"bos-wf-engine", (Object[])new Object[0]));
                    variables.put("dynType", "dynBackToRejectNode");
                }
                String buildSensitiveFieldKey = SensitiveFieldUtil.buildSensitiveFieldKey(task.getBusinessKey(), task.getTaskDefinitionKey());
                if (variables != null && variables.get(buildSensitiveFieldKey) == null) {
                    this.getSensitiveFieldInfos(task, variables);
                }
                this.wrapBackToRejectVariables(commandContext, task, variables);
                if (variables != null && variables.get(buildSensitiveFieldKey) != null) {
                    this.updateOperationLogForNote(commandContext, variables, task);
                }
            }
            variables = DynamicFlowUtil.extraCurNodeVariablesByDynType(task.getExecution(), variables);
            if (task.hasVariableLocal("dynParticipant")) {
                variables.remove("dynParticipant");
            }
            if (task.hasVariable("priority")) {
                task.removeVariable("priority");
            }
            if ((auditMessage = variables.get("auditMessage")) instanceof Map) {
                variables.put("auditMessage", SerializationUtils.toJsonString((Object)auditMessage));
            }
            if ((auditName = variables.get("auditName")) instanceof Map) {
                variables.put("auditName", SerializationUtils.toJsonString((Object)auditName));
            }
            if ((auditType = variables.get("auditType")) != null && "terminate".equals(auditType.toString())) {
                commandContext.getHistoryManager().recordOtherBranchActivityExecutionType(task.getExecution(), "skip");
            }
            if (WfUtils.isEmpty((String)variables.get("nextNodeId")) && "reject".equals((String)variables.get("auditType"))) {
                variables.remove("nextNodeId");
            }
            if (localScope) {
                task.setVariablesLocal(variables);
            } else if (task.getExecutionId() != null) {
                task.setExecutionVariables(variables);
            } else {
                task.setVariables(variables);
            }
            if (BpmnModelUtil.instanceofAuditTask(task.getCategory())) {
                logInfo.append(String.format("[%s-%s-%s-%s]", variables.get("auditNumber"), TaskHelper.handelData(variables.get("auditName")), variables.get("auditType"), TaskHelper.handelData(variables.get("auditMessage"))));
            } else {
                logInfo.append(String.format("[%s-%s-%s]", variables.get("auditNumber"), TaskHelper.handelData(variables.get("auditName")), variables.get("auditType")));
            }
        }
        ILocaleString userName = null;
        if (userId == null || userId == 0L) {
            String currentUserId = RequestContext.get().getUserId();
            userId = currentUserId == null ? 0L : Long.parseLong(currentUserId);
            userName = WfUtils.findUserName(userId);
        } else if (userId.equals(-1L)) {
            ILocaleString assignee = null;
            if (variables != null) {
                assignee = WfUtils.getLocaleStringVariable(variables, "assignee");
            }
            ILocaleString iLocaleString = userName = assignee != null ? assignee : WfUtils.getAutoApproverName();
        }
        if (userName == null) {
            userName = WfUtils.findUserName(userId);
        }
        logInfo.append(userName);
        commandContext.getTaskEntityManager().changeTaskAssignee(task, userId, userName);
        this.executeTaskComplete(commandContext, task, userId, variables, localScope);
        if ("enterBoundary".equals(task.getExecutionType())) {
            return;
        }
        this.executeSubscribeEvent(variables, task.getId(), commandContext);
        this.sendYunzhijiaMsgBySubscribe(autoAudit, commandContext, task, variables);
        this.sendDealResultMsgToAssignor(autoAudit, commandContext, task, userId, variables);
        boolean isSSCApprove = "SSCApprove".equals(task.getCategory());
        boolean bl = isSSCImageUpload = "SSCImageUploadNew".equals(task.getCategory()) || "SSCImageUpload".equals(task.getCategory());
        if (!autoAudit && task != null && compensation == null && !isSSCApprove & !isSSCImageUpload) {
            commandContext.getMessageService().dealToDo(task, Long.parseLong(RequestContext.get().getUserId()), false);
        }
        WfUtils.addOpLog("wf_task", "completeTask", new MultiLangEnumBridge("\u5b8c\u6210\u4efb\u52a1", "TaskHelper_7", "bos-wf-engine"), null, String.format("[%s]%s", task.getId(), logInfo.toString()));
    }

    private static String handelData(Object obj) {
        JSONObject jsonObject;
        if (WfUtils.isEmptyString(obj)) {
            return "";
        }
        String lang = Lang.get().toString();
        String data = obj.toString();
        if (WfUtils.isJSONObject(obj) && WfUtils.isEmpty(data = (jsonObject = JSONObject.parseObject((String)data)).getString(lang))) {
            data = jsonObject.getString("GLang");
        }
        return data;
    }

    public void getSensitiveFieldInfos(TaskEntity task, Map<String, Object> variables) {
        if (!WfConfigurationUtil.sensitiveChangeSwitch()) {
            return;
        }
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        TaskService taskService = wfService.getTaskService();
        if (this.getSetSensitiveField(task)) {
            String entityNumber;
            String businessKey = task.getBusinessKey();
            DynamicObject dataEntity = WfUtils.findBusinessObject(businessKey, entityNumber = task.getEntityNumber());
            if (dataEntity == null) {
                return;
            }
            SensitiveFieldInfo sensitiveFieldInfo = taskService.getSensitiveFieldInfo(entityNumber, dataEntity, "approve", task.getCategory(), task.getId());
            if (sensitiveFieldInfo != null && sensitiveFieldInfo.getIsSensitiveChange().booleanValue()) {
                String buildSensitiveFieldKey = SensitiveFieldUtil.buildSensitiveFieldKey(businessKey, task.getTaskDefinitionKey());
                variables.put(buildSensitiveFieldKey, SerializationUtils.toJsonString((Object)sensitiveFieldInfo));
            }
        }
    }

    public boolean getSetSensitiveField(TaskEntity taskEntity) {
        String taskDefinitionKey;
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        RepositoryService repositoryService = wfService.getRepositoryService();
        BpmnModel bpmnModel = repositoryService.getBpmnModel(taskEntity.getProcessDefinitionId(), taskEntity.getProcessInstanceId());
        FlowElement flowElement = bpmnModel.getFlowElement(taskDefinitionKey = taskEntity.getTaskDefinitionKey());
        if (!BpmnModelUtil.instanceofUserTask(flowElement.getType())) {
            return false;
        }
        UserTask userTask = (UserTask)flowElement;
        SensitiveField sensitiveField = userTask.getSensitiveField();
        return sensitiveField != null && WfUtils.isNotEmpty(sensitiveField.getSensitiveFieldData());
    }

    private void executeSubscribeEvent(Map<String, Object> variables, Long taskId, CommandContext commandContext) {
        boolean subscribeSign;
        if (variables != null && variables.get("subscribeSign") != null && (subscribeSign = ((Boolean)variables.get("subscribeSign")).booleanValue())) {
            String userId = RequestContext.get().getUserId();
            List<HistoricIdentityLinkEntity> hiidentityLinks = commandContext.getHistoricIdentityLinkEntityManager().findHistoricIdentityLinksByTaskUserGroupAndType(taskId, Long.parseLong(userId), null);
            if (hiidentityLinks != null && !hiidentityLinks.isEmpty()) {
                HistoricIdentityLinkEntity entity = hiidentityLinks.get(0);
                entity.setSubscribesign(subscribeSign);
                commandContext.getHistoricIdentityLinkEntityManager().update(entity);
            }
        }
    }

    private void sendYunzhijiaMsgBySubscribe(boolean autoAudit, CommandContext commandContext, TaskEntity task, Map<String, Object> variables) {
        if (autoAudit) {
            return;
        }
        List<Long> subscribeUserIds = this.getSubscribeUserIds(commandContext, task);
        if (!subscribeUserIds.isEmpty()) {
            ILocaleString messageContent = WfUtils.getPromptWordLocaleString("%1$s\u7684\u4efb\u52a1\u201c%2$s\u201d\u5df2\u88ab\u201c%3$s\u201d\u5904\u7406\uff0c\u6700\u7ec8\u7ed3\u679c\u4e3a\u201c%4$s\u201d\u3002", "TaskHelper_15", "bos-wf-engine");
            ILocaleString transferName = WfConfigurationUtil.getLocaleStringTransferName();
            this.buildAndSendMessage(commandContext, task, variables, subscribeUserIds, messageContent, transferName, "transferCompleteNotation");
        }
    }

    private List<Long> getSubscribeUserIds(CommandContext commandContext, TaskEntity task) {
        QFilter filterTaskId = new QFilter("taskId", "=", (Object)task.getId());
        QFilter filterSubscribe = new QFilter("subscribe", "=", (Object)"1");
        QFilter[] filters = new QFilter[]{filterTaskId, filterSubscribe};
        ArrayList<Long> subscribeUserIds = new ArrayList<Long>();
        List taskHandleLogs = commandContext.getTaskHandleLogEntityManager().findByQueryFilters(filters);
        if (taskHandleLogs == null || taskHandleLogs.isEmpty()) {
            return subscribeUserIds;
        }
        for (TaskHandleLogEntity taskHandleLog : taskHandleLogs) {
            Long userId = taskHandleLog.getOwnerId();
            if (subscribeUserIds.contains(userId)) continue;
            subscribeUserIds.add(userId);
        }
        return subscribeUserIds;
    }

    private void sendDealResultMsgToAssignor(boolean autoAudit, CommandContext commandContext, TaskEntity task, Long userId, Map<String, Object> variables) {
        if (autoAudit) {
            return;
        }
        List<Long> sendMsgAssignorIds = this.getSendMsgAssignorIds(commandContext, task, userId);
        if (!sendMsgAssignorIds.isEmpty()) {
            ILocaleString messageContent = WfUtils.getPromptWordLocaleString("\u59d4\u6258\u4efb\u52a1\u201c%1$s\u201d\u5df2\u88ab\u201c%2$s\u201d\u5904\u7406\uff0c\u6700\u7ec8\u7ed3\u679c\u4e3a\u201c%3$s\u201d\u3002", "TaskHelper_34", "bos-wf-engine");
            this.buildAndSendMessage(commandContext, task, variables, sendMsgAssignorIds, messageContent, null, MessageTypeEnum.COMPLETEDELEGATE.getNumber());
        }
    }

    private List<Long> getSendMsgAssignorIds(CommandContext commandContext, TaskEntity task, Long userId) {
        ArrayList<Long> sendMsgAssignorIds = new ArrayList<Long>();
        QFilter filter1 = new QFilter("taskId", "=", (Object)task.getId());
        QFilter filter2 = new QFilter("type", "=", (Object)"participant");
        QFilter filter3 = new QFilter("userId", "=", (Object)userId);
        QFilter filter4 = new QFilter("delegateid", "!=", (Object)0L);
        QFilter[] qFilters = new QFilter[]{filter1, filter2, filter3, filter4};
        List hiIdentityLinks = commandContext.getHistoricIdentityLinkEntityManager().findByQueryFilters(qFilters);
        if (hiIdentityLinks == null || hiIdentityLinks.isEmpty()) {
            return sendMsgAssignorIds;
        }
        for (HistoricIdentityLinkEntity hiIdentityLink : hiIdentityLinks) {
            Boolean isSendMsg;
            DelegateSettingEntity delegate = (DelegateSettingEntity)commandContext.getDelegateSettingEntityManager().findById(hiIdentityLink.getDelegateId());
            if (delegate == null || (isSendMsg = delegate.isSendMsgToAssignor()) == null || !isSendMsg.booleanValue()) continue;
            sendMsgAssignorIds.add(delegate.getAssignorId());
        }
        return sendMsgAssignorIds;
    }

    private void buildAndSendMessage(CommandContext commandContext, TaskEntity task, Map<String, Object> variables, List<Long> userIds, ILocaleString messageContent, ILocaleString transferName, String tplScene) {
        Object auditName = variables.get("auditName");
        LocaleString auditNameLocale = new LocaleString();
        if (auditName != null) {
            if (auditName.toString().startsWith("{") && auditName.toString().endsWith("}")) {
                Map map = (Map)SerializationUtils.fromJsonString((String)auditName.toString(), Map.class);
                if (WfUtils.isNotEmptyForMap(map)) {
                    auditNameLocale = LocaleString.fromMap((Map)map);
                }
            } else {
                auditNameLocale = WfMultiLangUtils.getMultiLangValue(auditName.toString());
            }
        }
        MessageContext messageContext = MessageServiceUtil.buildMessageContext(task.getId());
        MessageInfo messageInfo = MessageServiceUtil.buildMessageInfo(task.getProcessInstanceId(), task.getTaskDefinitionKey());
        LocaleString messageContentStr = new LocaleString();
        messageContentStr = WfUtils.isNotEmpty(transferName) ? WfMultiLangUtils.getMultiLangValue(new ILocaleString[]{messageContent, transferName, task.getSubject(), task.getTaskAssignee(), auditNameLocale}) : WfMultiLangUtils.getMultiLangValue(new ILocaleString[]{messageContent, task.getSubject(), task.getTaskAssignee(), auditNameLocale});
        messageInfo.setMessageContent((ILocaleString)messageContentStr);
        if (!WfUtils.isEmpty(tplScene)) {
            messageInfo.setTplScene(tplScene);
            messageInfo.setType("message");
            messageInfo.setEntityNumber(EntityNumberConstant.getHiTaskInstEntityNumber());
            messageContext.setEntityNumber(EntityNumberConstant.getHiTaskInstEntityNumber());
        }
        messageInfo.setUserIds(userIds);
        commandContext.getMessageService().sendMessage(messageContext, messageInfo);
    }

    protected void executeTaskComplete(CommandContext commandContext, TaskEntity taskEntity, Long userId, Map<String, Object> variables, boolean localScope) {
        Object updateQSDone;
        if (taskEntity.getDelegationState() != null && taskEntity.getDelegationState().equals(DelegationState.PENDING.toString())) {
            throw new WFEngineException("A delegated task cannot be completed, but should be resolved instead.");
        }
        if (taskEntity.isBizTask() || !(taskEntity.getExecution().getCurrentFlowElement() instanceof YunzhijiaTask)) {
            commandContext.getProcessEngineConfiguration().getListenerNotificationHelper().executeTaskListeners(taskEntity, "complete");
        }
        if ("enterBoundary".equals(taskEntity.getExecutionType())) {
            return;
        }
        if (variables != null && variables.get("from") != null && "autoAudit".equals(variables.get("from"))) {
            variables.remove("from");
        } else if (taskEntity.getSource().equalsIgnoreCase("wf")) {
            Object lastuserdealNode = taskEntity.getExecution().getVariableLocal("lastUserDealNode");
            if (WfConfigurationUtil.isSupportStrongControl() && "startStrongControl".equals(lastuserdealNode)) {
                taskEntity.setExecutionType(null);
                HistoricActivityInstanceEntity hiActInst = commandContext.getHistoricActivityInstanceEntityManager().findActivityByTaskId(taskEntity.getId());
                hiActInst.setExecutionType(null);
                commandContext.getHistoricActivityInstanceEntityManager().update(hiActInst);
            } else {
                ExecutionEntity execution = taskEntity.getExecution();
                if ("YunzhijiaTask".equals(taskEntity.getCategory())) {
                    execution = execution.getParent();
                }
                execution.setVariableLocal("lastUserDealNode", taskEntity.getTaskDefinitionKey());
            }
        }
        if (userId == null || userId == 0L) {
            String currentUserId = RequestContext.get().getUserId();
            userId = currentUserId == null ? 0L : Long.parseLong(currentUserId);
        }
        if (userId != null && taskEntity.getProcessInstanceId() != null) {
            ExecutionEntity processInstanceEntity = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(taskEntity.getProcessInstanceId());
            commandContext.getIdentityLinkEntityManager().involveUser(processInstanceEntity, userId, "dynparticipant");
        }
        if (variables != null && (updateQSDone = variables.get("updateQuantitySummaryDone")) != null && ((Boolean)updateQSDone).booleanValue()) {
            taskEntity.setTransientVariable("updateQuantitySummaryDone", updateQSDone);
        }
        new ResumeDelegateTasksCmd(taskEntity.getId(), "task complete", userId).execute(commandContext);
        commandContext.getTaskHelper().deleteTaskEntity(taskEntity, "task complete", false, false);
        taskEntity.removeTransientVariable("updateQuantitySummaryDone");
        this.updateHistoricIdentityLinkEntities(commandContext, taskEntity.getId(), userId);
    }

    public void updateHistoricIdentityLinkEntities(CommandContext commandContext, Long taskId, Long userId) {
        List<HistoricIdentityLinkEntity> historicIdentityLinkEntities;
        HistoricIdentityLinkEntityManager manager = commandContext.getHistoricIdentityLinkEntityManager();
        if (WfUtils.isEmpty(userId)) {
            userId = Long.parseLong(RequestContext.get().getUserId());
        }
        if (null != (historicIdentityLinkEntities = manager.findHistoricIdentityLinksByTaskIdUserId(taskId, userId)) && 0 != historicIdentityLinkEntities.size()) {
            Date currentDate = commandContext.getProcessEngineConfiguration().getClock().getCurrentTime();
            for (HistoricIdentityLinkEntity entity : historicIdentityLinkEntities) {
                entity.setEndTime(currentDate);
                entity.setDurationInMillis(currentDate.getTime() - entity.getCreateDate().getTime());
                manager.update(entity);
            }
        }
    }

    public void planExecutionOperationAsync(CommandContext commandContext, TaskEntity taskEntity) {
        ExecutionEntity executionEntity = taskEntity.getExecution();
        if (executionEntity == null && taskEntity.getExecutionId() != null) {
            executionEntity = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(taskEntity.getExecutionId());
        }
        if (executionEntity != null) {
            executionEntity.setCurrentTask(taskEntity);
            if (WfUtils.isNotEmpty(taskEntity.getParentTaskId()) && WfUtils.isNotEmpty(executionEntity.getParentId())) {
                executionEntity.getParent().setCurrentTask(taskEntity.getParentTaskInstance());
                executionEntity.getParent().setCurrentTaskId(taskEntity.getParentTaskId());
            }
        }
        if (executionEntity != null) {
            JobEntity job = commandContext.getJobManager().createAsyncTriggerJob(executionEntity, false);
            commandContext.getJobManager().scheduleAsyncJob(job);
        }
    }

    public void planExecutionOperationAsync(CommandContext commandContext, ExecutionEntity executionEntity) {
        JobEntity job = commandContext.getJobManager().createAsyncTriggerJob(executionEntity, false);
        commandContext.getJobManager().scheduleAsyncJob(job);
    }

    public boolean isRejectTask(Long processInstanceId, Long currentActInstId, String curNodeId) {
        if (WfUtils.isEmpty(currentActInstId)) {
            return false;
        }
        HistoricVariableInstanceEntityManager historicVariableInstanceEntityManager = Context.getCommandContext().getHistoricVariableInstanceEntityManager();
        CommentEntityManager commentEntityManager = Context.getCommandContext().getCommentEntityManager();
        List<HistoricActivityInstanceEntity> lastNodes = this.findLastNodes(processInstanceId, currentActInstId, false);
        for (HistoricActivityInstanceEntity lastNode : lastNodes) {
            HistoricVariableInstanceEntity task;
            List<CommentEntity> list;
            if (BpmnModelUtil.instanceofCallActivity(lastNode.getActivityType())) {
                String subRetKey = String.format("%s_%s", lastNode.getActivityId(), "subProcessResult");
                List<ValueFields> valueFields = historicVariableInstanceEntityManager.findHistoricVariableInstancesByProcessInstanceId(processInstanceId, new String[]{subRetKey});
                if (!WfUtils.isNotEmptyForCollection(valueFields) || !"120".equals(valueFields.get(0).getValue())) continue;
                return true;
            }
            Long taskId = null;
            if (BpmnModelUtil.instanceofYunzhijiaTask(lastNode.getActivityType())) {
                taskId = lastNode.getParentTaskId();
            } else if (BpmnModelUtil.instanceofAuditTask(lastNode.getActivityType())) {
                taskId = lastNode.getTaskId();
            }
            if (!WfUtils.isNotEmpty(taskId) || (list = commentEntityManager.findCommentsByTaskId(taskId)) == null || list.size() <= 0 || !"reject".equals(list.get(0).getDecisionType()) && !"forceReject".equals(list.get(0).getDecisionType()) || (task = historicVariableInstanceEntityManager.findHistoricVariableInstancesByTaskIdAndVarName(taskId, "nextNodeId")) == null || task.getValue() == null) continue;
            String value = (String)task.getValue();
            for (String nid : value.split("\\,")) {
                if (!curNodeId.equalsIgnoreCase(nid)) continue;
                return true;
            }
        }
        return false;
    }

    public List<HistoricActivityInstanceEntity> findLastNodes(Long processInstanceId, Long currentActInstId, boolean onlyUserAuditNode) {
        ArrayList<HistoricActivityInstanceEntity> lastNodes = new ArrayList<HistoricActivityInstanceEntity>();
        this.preLoop(lastNodes, processInstanceId, currentActInstId, onlyUserAuditNode);
        return lastNodes;
    }

    private void preLoop(List<HistoricActivityInstanceEntity> lastNodes, Long processInstanceId, Long currentActInstId, boolean onlyUserAuditNode) {
        HistoricActivityInstanceEntity entity;
        HistoricActivityInstanceEntityManager hisActivityManager = Context.getCommandContext().getHistoricActivityInstanceEntityManager();
        List<HistoricActivityInstanceEntity> lastSeqFlows = hisActivityManager.findByTargetId(processInstanceId, currentActInstId);
        if (WfUtils.isEmptyForCollection(lastSeqFlows) && (entity = (HistoricActivityInstanceEntity)hisActivityManager.findById(currentActInstId)) != null && BpmnModelUtil.instanceofYunzhijiaTask(entity.getActivityType())) {
            lastSeqFlows.add((HistoricActivityInstanceEntity)hisActivityManager.findById(entity.getSourceElementId()));
        }
        for (HistoricActivityInstanceEntity seqFlow : lastSeqFlows) {
            if (!"SequenceFlow".equalsIgnoreCase(seqFlow.getActivityType()) || "StartSignalEvent".equalsIgnoreCase(seqFlow.getActivityType())) break;
            HistoricActivityInstanceEntity activity = (HistoricActivityInstanceEntity)hisActivityManager.findById(seqFlow.getSourceElementId());
            boolean loop = false;
            boolean autoReject = false;
            if (activity != null) {
                if ("byAuto".equals(activity.getExecutionType()) && BpmnModelUtil.instanceofAuditTask(activity.getActivityType())) {
                    BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(null, processInstanceId);
                    AuditTask autoAuditTask = (AuditTask)bpmnModel.getFlowElement(activity.getActivityId());
                    loop = autoAuditTask.getAutoAudit() == null || !"reject".equalsIgnoreCase(BpmnModelUtil.getDecisionType(autoAuditTask, autoAuditTask.getAutoAudit().getAutoDecisionWhenMatch()));
                    autoReject = true;
                } else {
                    boolean bl = loop = "skip".equals(activity.getExecutionType()) || BpmnModelUtil.instanceofAutoTask(activity.getActivityType()) || BpmnModelUtil.instanceofNotifyTask(activity.getActivityType()) || "jump".equals(activity.getExecutionType());
                }
            }
            if (!loop && onlyUserAuditNode && activity != null) {
                boolean bl = loop = !autoReject && "byAuto".equals(activity.getExecutionType()) || !BpmnModelUtil.instanceofAuditTask(activity.getActivityType());
            }
            if (loop) {
                this.preLoop(lastNodes, processInstanceId, activity.getId(), onlyUserAuditNode);
                continue;
            }
            lastNodes.add(activity);
        }
    }

    public String getRejectNodeId(Long processInstanceId, Long currentActInstId) {
        HistoricActivityInstanceEntity lastNode = this.getRejectHiActInstEntity(processInstanceId, currentActInstId);
        if (lastNode != null) {
            return lastNode.getActivityId();
        }
        return null;
    }

    public HistoricActivityInstanceEntity getRejectHiActInstEntity(Long processInstanceId, Long currentActInstId) {
        List<HistoricActivityInstanceEntity> lastNodes = this.findLastNodes(processInstanceId, currentActInstId, true);
        for (HistoricActivityInstanceEntity lastNode : lastNodes) {
            CommentEntityManager commentEntityManager;
            List<CommentEntity> list;
            Long taskId = null;
            if (BpmnModelUtil.instanceofYunzhijiaTask(lastNode.getActivityType())) {
                taskId = lastNode.getParentTaskId();
            } else if (BpmnModelUtil.instanceofAuditTask(lastNode.getActivityType())) {
                taskId = lastNode.getTaskId();
            }
            if (!WfUtils.isNotEmpty(taskId) || !CollectionUtil.isNotEmpty(list = (commentEntityManager = Context.getCommandContext().getCommentEntityManager()).findCommentsByTaskId(taskId)) || list.get(0) == null || !"reject".equals(list.get(0).getDecisionType()) && !"forceReject".equals(list.get(0).getDecisionType())) continue;
            return lastNode;
        }
        return null;
    }

    public void deleteTask(Long taskId, String deleteReason, boolean cascade) {
        TaskEntity taskEntity = (TaskEntity)Context.getCommandContext().getTaskEntityManager().findById(taskId);
        if (taskEntity != null) {
            this.dispatchEventListener(taskEntity, deleteReason);
        }
        Context.getCommandContext().getTaskEntityManager().deleteTask(taskId, deleteReason, cascade);
    }

    public void deleteTaskEntity(TaskEntity taskEntity, String deleteReason, boolean cascade, boolean cancel) {
        this.dispatchEventListener(taskEntity, deleteReason);
        Context.getCommandContext().getTaskEntityManager().deleteTask(taskEntity, deleteReason, cascade, cancel);
    }

    public void deleteTask(Long taskId, String deleteReason, boolean cascade, boolean sub) {
        TaskEntity taskEntity = (TaskEntity)Context.getCommandContext().getTaskEntityManager().findById(taskId);
        this.dispatchEventListener(taskEntity, deleteReason);
        Context.getCommandContext().getTaskEntityManager().deleteTask(taskId, deleteReason, cascade, sub);
    }

    private void dispatchEventListener(TaskEntity taskEntity, String deleteReason) {
        if (!"task complete".equals(deleteReason) && !taskEntity.isDisplay()) {
            this.log.debug(String.format("qs_dispatchEventListener_taskEntity[%s], deleteReason[%s]", taskEntity.getId(), deleteReason));
            return;
        }
        ActivitiEventDispatcher eventDispatcher = Context.getProcessEngineConfiguration().getEventDispatcher();
        if (eventDispatcher.isEnabled()) {
            this.log.debug("qs_dispatchEventListener_enabled");
            if (WfUtils.isNotEmpty(deleteReason)) {
                if ("task complete".equals(deleteReason) || "yunzhijiaTask completed".equals(deleteReason)) {
                    eventDispatcher.dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.TASK_COMPLETED, taskEntity));
                    this.log.debug("qs_dispatchEventListener_enabled_finish");
                } else if ("task skip".equals(deleteReason) || "first_usertask_skip".equals(deleteReason)) {
                    taskEntity.setTransientVariable("deleteReason", deleteReason);
                    eventDispatcher.dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.TASK_SKIP, taskEntity));
                    taskEntity.removeTransientVariable("deleteReason");
                } else {
                    taskEntity.setTransientVariable("deleteReason", deleteReason);
                    eventDispatcher.dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.TASK_DELETED, taskEntity));
                    taskEntity.removeTransientVariable("deleteReason");
                }
            } else {
                eventDispatcher.dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.TASK_DELETED, taskEntity));
            }
        }
    }

    @Deprecated
    public void updateTaskCompleteQuantitySummary(List<TaskEntity> taskEntities, Long assigneeId) {
    }

    public void skipTask(TaskEntity task, Long userId, Map<String, Object> variables) {
        CommandContext commandContext = Context.getCommandContext();
        TaskEntity parentTask = task;
        ArrayList<Long> taskIdsForComposite = new ArrayList<Long>();
        if (task.getParentTaskId() != null) {
            parentTask = (TaskEntity)commandContext.getTaskEntityManager().findById(task.getParentTaskId());
            List<TaskEntity> subTasks = commandContext.getTaskEntityManager().findTasksByParentTaskId(task.getParentTaskId());
            if (subTasks != null) {
                for (Task task2 : subTasks) {
                    taskIdsForComposite.add(task2.getId());
                }
            }
        } else {
            taskIdsForComposite.add(task.getId());
        }
        if (variables != null) {
            task.setVariablesLocal(variables);
            if (!task.equals(parentTask)) {
                parentTask.setVariablesLocal(variables);
            }
        }
        if (task.hasVariable("priority")) {
            task.removeVariable("priority");
        }
        if (userId == null || userId == 0L) {
            String currentUserId = RequestContext.get().getUserId();
            userId = currentUserId == null ? 0L : Long.parseLong(currentUserId);
        }
        this.executeSkipTask(commandContext, parentTask, userId, variables);
        this.planExecutionOperationAsync(commandContext, task);
        this.executeCompositeTask(taskIdsForComposite);
    }

    private void executeCompositeTask(List<Long> taskIdsForComposite) {
        if (taskIdsForComposite != null && !taskIdsForComposite.isEmpty()) {
            for (Long taskId : taskIdsForComposite) {
                TaskHelper.dealWithCompositeTask(taskId);
            }
        }
    }

    private void executeSkipTask(CommandContext commandContext, TaskEntity taskEntity, Long userId, Map<String, Object> variables) {
        if (taskEntity.getDelegationState() != null && taskEntity.getDelegationState().equals(DelegationState.PENDING.toString())) {
            throw new WFEngineException("A delegated task cannot be completed, but should be resolved instead.");
        }
        if (userId == null || userId == 0L) {
            String currentUserId = RequestContext.get().getUserId();
            userId = currentUserId == null ? 0L : Long.parseLong(currentUserId);
        }
        if (userId != null && taskEntity.getProcessInstanceId() != null) {
            ExecutionEntity processInstanceEntity = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(taskEntity.getProcessInstanceId());
            commandContext.getIdentityLinkEntityManager().involveUser(processInstanceEntity, userId, "skiper");
        }
        String skipReason = (String)taskEntity.getVariable("skipReason");
        String executionType = (String)taskEntity.getVariable("executionType");
        String taskDefKey = taskEntity.getTaskDefinitionKey();
        if (WfUtils.isNotEmpty(taskDefKey) && taskDefKey.contains("YunzhijiaTask")) {
            List<TaskEntity> tasks = commandContext.getTaskEntityManager().findTasksByParentTaskId(taskEntity.getId());
            for (TaskEntity task : tasks) {
                commandContext.getHistoryManager().recordActivityExecutionType(task.getExecution(), executionType, skipReason);
            }
        } else {
            commandContext.getHistoryManager().recordActivityExecutionType(taskEntity.getExecution(), executionType, skipReason);
        }
        commandContext.getTaskEntityManager().changeTaskExecutionType(taskEntity, executionType);
        commandContext.getProcessEngineConfiguration().getListenerNotificationHelper().executeTaskListeners(taskEntity, "complete");
        commandContext.getTaskHelper().deleteTaskEntity(taskEntity, "task skip", false, false);
    }

    public void autoAudit(DelegateExecution execution, TaskEntity task, Map<String, Object> variables, Long assigneeId) {
        String lastUserNode = (String)execution.getVariableLocal("lastUserDealNode");
        if (WfUtils.isNotEmpty(lastUserNode) && ("start".equals(lastUserNode) || "startStrongControl".equals(lastUserNode))) {
            execution.setVariableLocal("lastUserDealNode", "startProcessInstance");
        }
        String executeType = "byAuto";
        String expireAutoAudit = (String)variables.get("expireAutoAudit");
        if (WfUtils.isNotEmpty(expireAutoAudit)) {
            executeType = "byExpireAuto";
        }
        Context.getProcessEngineConfiguration().getTaskEntityManager().changeTaskExecutionType(task, executeType);
        Context.getProcessEngineConfiguration().getHistoryManager().recordActivityExecutionType((ExecutionEntity)execution, executeType, "AUTOAUDIT");
        Long taskId = task.getId();
        this.addComment(taskId, execution.getProcessInstanceId(), assigneeId, null, variables);
        if (WfUtils.isEmpty(expireAutoAudit)) {
            variables.put("from", "autoAudit");
        }
        this.CompleteTask(task, assigneeId, variables, true);
        ActivitiEventDispatcher eventDispatcher = Context.getProcessEngineConfiguration().getEventDispatcher();
        if (eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.TASK_AUTOAUDIT, task));
        }
    }

    private Map<String, Object> getAutoAuditVariables(ExecutionEntity exec, DecisionOption autoDecision) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("autoAudit", Boolean.TRUE);
        variables.put("auditNumber", autoDecision.getNumber());
        variables.put("decisionscene", autoDecision.getDecisionScene());
        String multiKey = BpmnModelUtil.getDecisionNameMultiKey(exec.getCurrentActivityId(), autoDecision.getId());
        variables.put("auditName", BpmnModelUtil.getMultiLangFieldValue(exec.getProcessInstanceId(), multiKey, autoDecision.getName()));
        variables.put("auditType", autoDecision.getAuditType());
        if ("terminate".equalsIgnoreCase(autoDecision.getAuditType())) {
            variables.put("dynType", "auditAbort");
        }
        return variables;
    }

    private static void handleSignature(Map<String, Object> variables, TaskEntity taskEntity, long currUserId) {
        Object signatureObj = variables.get("signature");
        if (WfUtils.isNotEmptyString(signatureObj)) {
            return;
        }
        String signature = SignatureUtils.getDefaultSignatureIfAllow(taskEntity, currUserId);
        if (WfUtils.isNotEmptyString(signature)) {
            variables.put("signature", signature);
        }
    }

    private void putRejectVariables(ExecutionEntity exec, DecisionOption autoDecision, Map<String, Object> variables) {
        if (autoDecision.getAuditType().equals("reject")) {
            variables.put("rejectBackToNode", "false");
            Process process = ProcessDefinitionUtil.getProcess(exec.getProcessDefinitionId(), exec.getProcessInstanceId());
            List<SelectNodesModel> rejectOptions = autoDecision.getRejectOptions();
            if (WfConfigurationUtil.isIgnoreNoThroughNode()) {
                rejectOptions = TaskHelper.filterUnFlowThrough(rejectOptions, exec.getProcessInstanceId());
            }
            for (SelectNodesModel rejectOption : rejectOptions) {
                UserTask reUserTask = process.findFlowElementsOfTypeAndId(UserTask.class, rejectOption.getItemId(), false);
                if (reUserTask instanceof AuditTask) {
                    boolean skip = DynamicFlowUtil.isSkipTask(reUserTask, exec.getCurrentTask(), exec).isSkip();
                    if (skip) continue;
                    AutoAudit reAutoAudit = ((AuditTask)reUserTask).getAutoAudit();
                    if (reAutoAudit != null && reAutoAudit.isAutoAuditWhenMatch()) {
                        ConditionType.logOpDesc(reAutoAudit.getAutoAuditCondition());
                        String key = ConditionUtil.getConInstKey(reUserTask.getNumber(), "autoAudit");
                        boolean reAuto = ConditionUtil.hasTrueCondition(reAutoAudit.getAutoAuditCondition(), (VariableScope)exec, key);
                        if (reAuto) continue;
                        variables.put("dynType", "dynReject");
                        variables.put("nextNodeId", rejectOption.getItemId());
                        break;
                    }
                    variables.put("dynType", "dynReject");
                    variables.put("nextNodeId", rejectOption.getItemId());
                    break;
                }
                variables.put("dynType", "dynReject");
                variables.put("nextNodeId", rejectOption.getItemId());
                break;
            }
            if (WfUtils.isEmptyForCollection(rejectOptions) && autoDecision.isRejectToParentProcessScene()) {
                variables.put("dynType", "abortByRejectToParentProcess");
            }
        }
    }

    public static List<SelectNodesModel> filterUnFlowThrough(List<SelectNodesModel> list, Long procId) {
        ArrayList<SelectNodesModel> nodeList = new ArrayList<SelectNodesModel>();
        List<HistoricActivityInstanceEntity> entities = Context.getCommandContext().getHistoricActivityInstanceEntityManager().findByProcessInstanceId(procId);
        int len = list.size();
        block0: for (int i = 0; i < len; ++i) {
            SelectNodesModel node = list.get(i);
            String nextNodeId = node.getItemId();
            int length = entities.size();
            for (int j = 0; j < length; ++j) {
                if (!nextNodeId.equals(entities.get(j).getActivityId())) continue;
                nodeList.add(node);
                continue block0;
            }
        }
        return nodeList;
    }

    public void doAutoAudit(ExecutionEntity exec, DecisionOption autoDecision, Long assigneeId, ILocaleString auditMessage) {
        if (autoDecision == null) {
            this.log.warn(exec.getCurrentTaskId() + " \u81ea\u52a8\u5ba1\u6279\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u51b3\u7b56\u9879\u4e3a\u7a7a\u6216\u6ca1\u6709\u9ed8\u8ba4\u51b3\u7b56\u9879\uff01");
            return;
        }
        Map<String, Object> variables = this.getAutoAuditVariables(exec, autoDecision);
        ILocaleString defaultMessage = WFMultiLangConstants.getAutoAuditDefaultMessageLocaleString();
        ILocaleString message = null;
        message = WfUtils.isEmpty(auditMessage) ? defaultMessage : (auditMessage.getLocaleValue().contains(defaultMessage.getLocaleValue()) ? auditMessage : WfMultiLangUtils.getMultiLangValue(new ILocaleString[]{new LocaleString(SPERATER), auditMessage, defaultMessage}));
        variables.put("auditMessage", message);
        if (assigneeId == null) {
            assigneeId = -1L;
            variables.put("assignee", WFMultiLangConstants.getAutoAuditDefaultMessage());
        } else {
            User user = WfUtils.findUserById(assigneeId);
            variables.put("assignee", user != null ? user.getName() : null);
        }
        this.log.debug(String.format(WFMultiLangConstants.getAutoTaskInfo(), exec.getCurrentTaskId(), assigneeId));
        TaskHelper.handleSignature(variables, exec.getCurrentTask(), assigneeId);
        AbstractOperation agendaOperation = Context.getCommandContext().getAgendaOperation();
        if (agendaOperation instanceof ContinueProcessOperation) {
            ((ContinueProcessOperation)agendaOperation).getCallbacks().add(new PlanAutoAuditOperationCallback(exec, exec.getCurrentTask(), variables, assigneeId));
        } else {
            TaskHelper taskHelper = Context.getProcessEngineConfiguration().getTaskHelper();
            taskHelper.autoAudit(exec, exec.getCurrentTask(), variables, assigneeId);
        }
    }

    public void doAutoAudit(ExecutionEntity exec, AutoAudit autoAudit, DecisionOption autoDecision, ILocaleString opinion) {
        ILocaleString multiValue;
        String activityId = exec.getCurrentActivityId();
        Map<String, Object> variables = this.getAutoAuditVariables(exec, autoDecision);
        JSONObject multiLangDatas = BpmnModelUtil.getMultiLangDatas(exec.getProcessInstanceId());
        if (WfUtils.isNotEmpty(opinion)) {
            variables.put("auditMessage", opinion);
        } else {
            multiValue = BpmnModelUtil.getMultiLangFieldValue(multiLangDatas, String.format("%s.autoAudit.autoOpinionWhenMatch", activityId), autoAudit.getAutoOpinionWhenMatch());
            variables.put("auditMessage", multiValue != null ? multiValue : WfUtils.getMultiLangValue(autoAudit.getAutoOpinionWhenMatch()));
        }
        multiValue = BpmnModelUtil.getMultiLangFieldValue(multiLangDatas, String.format("%s.autoAudit.processHandler", activityId), autoAudit.getProcessHandler());
        variables.put("assignee", multiValue != null ? multiValue : WfUtils.getMultiLangValue(autoAudit.getProcessHandler()));
        this.putRejectVariables(exec, autoDecision, variables);
        this.putTerminateVariable(exec, autoDecision, variables);
        Long assigneeId = -1L;
        if (Boolean.TRUE.equals(autoAudit.getParticipantAsAutoAuditor())) {
            List<IdentityLinkEntity> userIds = Context.getProcessEngineConfiguration().getIdentityLinkEntityManager().findIdentityLinksByTaskId(exec.getCurrentTaskId());
            if ((userIds = userIds.stream().filter(user -> WfUtils.isEmpty(user.getDelegateId())).collect(Collectors.toList())).size() == 1) {
                assigneeId = userIds.get(0).getUserId();
                ILocaleString userName = WfUtils.findUserName(assigneeId);
                variables.put("assignee", userName);
                TaskHelper.handleSignature(variables, exec.getCurrentTask(), assigneeId);
            }
        }
        this.log.debug(String.format(WFMultiLangConstants.getAutoTaskInfo(), exec.getCurrentTaskId(), assigneeId));
        AbstractOperation agendaOperation = Context.getCommandContext().getAgendaOperation();
        if (agendaOperation instanceof ContinueProcessOperation) {
            ((ContinueProcessOperation)agendaOperation).getCallbacks().add(new PlanAutoAuditOperationCallback(exec, exec.getCurrentTask(), variables, assigneeId));
        } else {
            TaskHelper taskHelper = Context.getProcessEngineConfiguration().getTaskHelper();
            taskHelper.autoAudit(exec, exec.getCurrentTask(), variables, assigneeId);
        }
    }

    private void putTerminateVariable(ExecutionEntity exec, DecisionOption autoDecision, Map<String, Object> variables) {
        if (autoDecision.getAuditType().equals("terminate")) {
            exec.setVariable("dynType", "auditAbort");
        }
    }

    private void participantNotAsAutoAuditor(ExecutionEntity exec, Map<String, Object> variables) {
        if (exec.getCurrentFlowElement() instanceof YunzhijiaTask) {
            List<Long> userIds = new ArrayList();
            if ("serialAudit".equals(((YunzhijiaTask)exec.getCurrentFlowElement()).getSignType())) {
                Long taskId = exec.getTasks() == null || exec.getTasks().isEmpty() ? null : exec.getTasks().get(0).getId();
                QFilter qFilter1 = new QFilter("taskId", "=", taskId);
                QFilter qFilter2 = new QFilter("type", "=", (Object)"participant");
                QFilter[] filters = new QFilter[]{qFilter1, qFilter2};
                List userDys = Context.getProcessEngineConfiguration().getHistoricIdentityLinkEntityManager().findByQueryFilters(filters);
                for (HistoricIdentityLinkEntity user : userDys) {
                    userIds.add(user.getUserId());
                }
            } else {
                userIds = (List)WfUtils.stringToCollection((String)exec.getCurrentTask().getVariable("teamMembers"), ",");
            }
            ArrayList<Long> alreadyDealtuserIds = new ArrayList<Long>();
            String groupId = WfUtils.isEmpty(exec.getParent().getCurrentTaskId()) ? null : String.valueOf(exec.getParent().getCurrentTaskId());
            QFilter filter1 = new QFilter("groupid", "=", (Object)groupId);
            QFilter[] qFilters = new QFilter[]{filter1};
            List alreadyDealtuserCommentEntity = Context.getProcessEngineConfiguration().getCommentEntityManager().findByQueryFilters(qFilters);
            if (null != alreadyDealtuserCommentEntity && !alreadyDealtuserCommentEntity.isEmpty()) {
                for (int i = 0; i < alreadyDealtuserCommentEntity.size(); ++i) {
                    alreadyDealtuserIds.add(((CommentEntity)alreadyDealtuserCommentEntity.get(i)).getUserId());
                }
            }
            if (null != userIds && !userIds.isEmpty()) {
                userIds.removeAll(alreadyDealtuserIds);
                LocaleString username = new LocaleString();
                ILocaleString suffix = WfUtils.getPromptWordLocaleString("\u5904\u7406\u8d85\u671f\uff0c\u81ea\u52a8\u5ba1\u6279", "TaskHelper_31", "bos-wf-engine");
                for (Long id : userIds) {
                    StringBuilder userNames = null;
                    ILocaleString name = WfUtils.findUserName(id);
                    for (String key : suffix.keySet()) {
                        String val = (String)username.get((Object)key);
                        userNames = val == null ? new StringBuilder() : new StringBuilder(val);
                        userNames.append((String)name.get((Object)key)).append("\uff0c");
                        username.put((Object)key, (Object)userNames.toString());
                    }
                }
                LocaleString tip = new LocaleString();
                for (Map.Entry entry : suffix.entrySet()) {
                    tip.put(entry.getKey(), (Object)String.format("%s %s", username.get(entry.getKey()), entry.getValue()));
                }
                variables.put("auditMessage", tip);
            }
        }
    }

    private Long participantAsAutoAuditor(ExecutionEntity exec, Long assigneeId, Map<String, Object> variables) {
        List participants;
        List<IdentityLinkEntity> userIdList = Context.getProcessEngineConfiguration().getIdentityLinkEntityManager().findIdentityLinksByTaskId(exec.getCurrentTaskId());
        if (exec.getCurrentFlowElement() instanceof YunzhijiaTask) {
            if (null != userIdList && !userIdList.isEmpty()) {
                for (IdentityLinkEntity entity : userIdList) {
                    assigneeId = entity.getUserId();
                    ILocaleString username = WfUtils.findUserName(assigneeId);
                    variables.put("assignee", username);
                    TaskHelper.handleSignature(variables, exec.getCurrentTask(), assigneeId);
                }
            }
        } else if (userIdList != null && (participants = userIdList.stream().filter(item -> "participant".equals(item.getType())).collect(Collectors.toList())) != null && participants.size() == 1) {
            assigneeId = ((IdentityLinkEntity)participants.get(0)).getUserId();
            ILocaleString userName = WfUtils.findUserName(assigneeId);
            variables.put("assignee", userName);
            TaskHelper.handleSignature(variables, exec.getCurrentTask(), assigneeId);
            return assigneeId;
        }
        return assigneeId;
    }

    public void doAutoAudit(ExecutionEntity exec, AutoAudit autoAudit, DecisionOption autoDecision, ILocaleString opinion, ILocaleString assigneeName, boolean isAuto) {
        ILocaleString multiValue;
        String activityId = exec.getCurrentActivityId();
        Map<String, Object> variables = this.getAutoAuditVariables(exec, autoDecision);
        JSONObject multiLangDatas = BpmnModelUtil.getMultiLangDatas(exec.getProcessInstanceId());
        if (WfUtils.isNotEmpty(opinion)) {
            variables.put("auditMessage", opinion);
        } else {
            multiValue = BpmnModelUtil.getMultiLangFieldValue(multiLangDatas, String.format("%s.autoAudit.autoOpinionWhenMatch", activityId), autoAudit.getAutoOpinionWhenMatch());
            variables.put("auditMessage", multiValue != null ? multiValue : WfUtils.getMultiLangValue(autoAudit.getAutoOpinionWhenMatch()));
        }
        multiValue = BpmnModelUtil.getMultiLangFieldValue(multiLangDatas, String.format("%s.autoAudit.processHandler", activityId), autoAudit.getProcessHandler());
        variables.put("assignee", multiValue != null ? multiValue : WfUtils.getMultiLangValue(autoAudit.getProcessHandler()));
        this.putRejectVariables(exec, autoDecision, variables);
        this.putTerminateVariable(exec, autoDecision, variables);
        Long assigneeId = -1L;
        if (WfUtils.isNotEmpty(assigneeName)) {
            variables.put("assignee", assigneeName);
        }
        if (Boolean.TRUE.equals(autoAudit.getParticipantAsAutoAuditor())) {
            assigneeId = this.participantAsAutoAuditor(exec, assigneeId, variables);
        } else {
            this.participantNotAsAutoAuditor(exec, variables);
        }
        if (!isAuto) {
            variables.remove("autoAudit");
        } else {
            variables.put("expireAutoAudit", activityId);
        }
        this.log.debug(String.format(WFMultiLangConstants.getAutoTaskInfo(), exec.getCurrentTaskId(), assigneeId));
        AbstractOperation agendaOperation = Context.getCommandContext().getAgendaOperation();
        if (agendaOperation instanceof ContinueProcessOperation) {
            ((ContinueProcessOperation)agendaOperation).getCallbacks().add(new PlanAutoAuditOperationCallback(exec, exec.getCurrentTask(), variables, assigneeId));
        } else {
            TaskHelper taskHelper = Context.getProcessEngineConfiguration().getTaskHelper();
            taskHelper.autoAudit(exec, exec.getCurrentTask(), variables, assigneeId);
        }
    }

    public boolean isStarterSameAsAuditor(TaskEntity task) {
        CommandContext commandContext = Context.getCommandContext();
        Process process = ProcessDefinitionUtil.getProcess(task.getProcessDefinitionId(), task.getProcessInstanceId());
        if (Boolean.TRUE.equals(process.getAutoAuditWhenSamePerson())) {
            ExecutionEntity execution = task.getExecution();
            TaskHelper taskHelper = commandContext.getProcessEngineConfiguration().getTaskHelper();
            boolean isReject = taskHelper.isRejectTask(execution.getProcessInstanceId(), execution.getCurrentActInstId(), task.getTaskDefinitionKey());
            if (isReject) {
                return false;
            }
            List<HistoricIdentityLinkEntity> entities = commandContext.getHistoricIdentityLinkEntityManager().findHistoricIdentityLinksByTaskId(task.getId());
            ArrayList<HistoricIdentityLinkEntity> approverEntities = new ArrayList<HistoricIdentityLinkEntity>(entities.size());
            ArrayList<HistoricIdentityLinkEntity> trusteeEntities = new ArrayList<HistoricIdentityLinkEntity>(entities.size());
            HashSet<Long> trusteeIds = new HashSet<Long>();
            List<IdentityLinkEntity> identityLinks = task.getIdentityLinks();
            for (IdentityLinkEntity identityLink : identityLinks) {
                if (!WfUtils.isNotEmpty(identityLink.getDelegateId())) continue;
                trusteeIds.add(identityLink.getUserId());
            }
            for (HistoricIdentityLinkEntity entity : entities) {
                if (trusteeIds != null && !trusteeIds.isEmpty() && trusteeIds.contains(entity.getUserId())) {
                    trusteeEntities.add(entity);
                    continue;
                }
                approverEntities.add(entity);
            }
            if (entities == null || entities.isEmpty()) {
                return false;
            }
            for (HistoricIdentityLinkEntity entity : approverEntities) {
                if (!"participant".equals(entity.getType()) || !task.getStarterId().equals(entity.getUserId())) continue;
                return true;
            }
            if (!WfConfigurationUtil.isTrustHandle()) {
                for (HistoricIdentityLinkEntity entity : trusteeEntities) {
                    if (!"participant".equals(entity.getType()) || !task.getStarterId().equals(entity.getUserId())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void quickCompleteTask(TaskEntity task, boolean batch) {
        CommandContext commandContext = Context.getCommandContext();
        if (task != null) {
            commandContext.getMessageService().dealToDo(task, Long.parseLong(RequestContext.get().getUserId()), batch);
        }
    }

    public void quickBatchCompleteTask(List<TaskEntity> tasks, Long userId, boolean async) {
        if (tasks == null || tasks.isEmpty()) {
            return;
        }
        Context.getCommandContext().getMessageService().batchDealToDo(tasks, userId, async);
    }

    public void planCompensationTaskJob(TaskEntity task, Map<String, Object> variables) {
        CommandContext commandContext = Context.getCommandContext();
        JobEntity job = commandContext.getJobManager().createCompensationTaskJob(task, variables);
        commandContext.getJobManager().scheduleAsyncJob(job);
    }

    public void planBatchCompensationTaskJob(List<TaskEntity> tasks, Map<String, Object> variables) {
        if (tasks == null || tasks.isEmpty()) {
            return;
        }
        CommandContext commandContext = Context.getCommandContext();
        JobManager jobManager = commandContext.getJobManager();
        JobEntityManager jobEntityManager = commandContext.getJobEntityManager();
        try (TraceSpan tracer = Tracer.create((String)"WF_JOB", (String)WfTracerHelper.wrapTagValue("planBatchCompensationTaskJob", new String[0]));){
            JobEntity job = null;
            ArrayList<JobEntity> jobs = new ArrayList<JobEntity>(0);
            for (TaskEntity task : tasks) {
                if (variables.get("taskSource") == null) {
                    variables.put("taskSource", task.getSource());
                }
                job = jobManager.createCompensationTaskJob(task, variables);
                jobEntityManager.insert(job);
                jobs.add(job);
            }
            commandContext.getJobManager().batchScheduleAsyncJob(jobs);
        }
    }

    public static Object getHandledStatusDesc(String code) {
        if (WFAuditResultTypeEnum.approve.getValue().equalsIgnoreCase(code)) {
            return ResManager.loadKDString((String)"\u5df2\u540c\u610f", (String)"TaskHelper_11", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        if (WFAuditResultTypeEnum.reject.getValue().equalsIgnoreCase(code)) {
            return ResManager.loadKDString((String)"\u5df2\u9a73\u56de", (String)"TaskHelper_12", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        if (WFAuditResultTypeEnum.terminate.getValue().equalsIgnoreCase(code)) {
            return ResManager.loadKDString((String)"\u5df2\u7ec8\u6b62", (String)"TaskHelper_13", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u5df2\u5904\u7406", (String)"TaskHelper_14", (String)"bos-wf-engine", (Object[])new Object[0]);
    }

    public boolean isValidate(TaskEntity task, Map<String, Object> variable) {
        String auditType = (String)variable.get("auditType");
        TaskHelper.validateTaskStatus(task.getBillNo(), task.getSuspensionState(), String.valueOf(task.isActive()));
        String validateOp = TaskBehaviorUtil.getValidateOpByAuditTypeForTask(task.getValidateOperation(), auditType, task.getCategory());
        if (WfUtils.isNotEmpty(validateOp)) {
            if (ExternalInterfaceUtil.isValidValue(validateOp)) {
                DynamicObject billInfo = BusinessDataServiceHelper.loadSingle((Object)task.getBusinessKey(), (String)task.getEntityNumber());
                return ExternalInterfaceUtil.invokeValidateExtItf(billInfo, validateOp);
            }
            HashMap<String, String> tmp = new HashMap<String, String>();
            for (Map.Entry<String, Object> entry : variable.entrySet()) {
                String key = entry.getKey();
                Object obj = entry.getValue();
                if (obj == null) continue;
                tmp.put(key, obj.toString());
            }
            tmp.put("entitynumber", task.getEntityNumber());
            tmp.put("businesskey", task.getBusinessKey());
            tmp.put("taskid", task.getId().toString());
            tmp.put("ignoreIdempotent", String.valueOf(true));
            OperationResult ret = BusinessLogicServiceHelper.invokeOperationService(validateOp, task.getEntityNumber(), new Object[]{task.getBusinessKey()}, tmp, task, task.getExecution());
            return ret.isSuccess();
        }
        return true;
    }

    public static void validateTaskStatus(String billNo, String suspensionstate, String active) {
        if (!ManagementConstants.ACTIVE.getStateCode().equalsIgnoreCase(suspensionstate)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u201c%s\u201d\u4e3a\u6302\u8d77\u72b6\u6001\uff0c\u4e0d\u80fd\u63d0\u4ea4\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TaskHelper_17", (String)"bos-wf-engine", (Object[])new Object[0]), billNo));
        }
        if ("false".equalsIgnoreCase(active)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u201c%s\u201d\u4e3a\u51bb\u7ed3\u72b6\u6001\uff0c\u4e0d\u80fd\u63d0\u4ea4\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TaskHelper_18", (String)"bos-wf-engine", (Object[])new Object[0]), billNo));
        }
    }

    public void calcCompositeTask(DelegateExecution execution, UserTask userTask, List<Long> userIds, Map<String, IdentityLinkEntity> identityLinkMap) {
        CommandContext commandContext = Context.getCommandContext();
        Long proInstId = execution.getProcessInstanceId();
        Map<String, NodeForkJoinModel> models = ProcessDefinitionUtil.getProcess(execution.getProcessDefinitionId(), proInstId).getForkJoinModels();
        NodeForkJoinModel model = models.get(userTask.getId());
        if (model != null && WfUtils.isNotEmpty(model.getLatestForkNode())) {
            String forkNodeId = model.getLatestForkNode();
            Map<String, Map<String, Object>> userSameInfo = commandContext.getTaskEntityManager().findTasksByProInstIdAndUserId(proInstId, "(" + WfUtils.listToString(userIds, ",") + ")");
            if (!userSameInfo.isEmpty()) {
                IdentityLinkEntityManager ilkManager = commandContext.getIdentityLinkEntityManager();
                HistoricIdentityLinkEntityManager hilkManager = commandContext.getHistoricIdentityLinkEntityManager();
                for (Map.Entry<String, Map<String, Object>> entry : userSameInfo.entrySet()) {
                    IdentityLinkEntity ile;
                    String userString = entry.getKey();
                    Map<String, Object> tmp = entry.getValue();
                    String actId = (String)tmp.get("actId");
                    if (!WfUtils.isNotEmpty(actId)) continue;
                    NodeForkJoinModel tmpModel = models.get(actId);
                    boolean flag = true;
                    for (int i = 0; tmpModel != null && WfUtils.isNotEmpty(tmpModel.getLatestForkNode()) && flag && i < 50; ++i) {
                        if (forkNodeId.equals(tmpModel.getLatestForkNode())) {
                            flag = false;
                            continue;
                        }
                        tmpModel = models.get(tmpModel.getNodeId());
                    }
                    if (flag || (ile = identityLinkMap.get(userString)) == null) continue;
                    Boolean isDisplay = ile.isDisplay();
                    Long compositeTaskId = (Long)tmp.get("taskId");
                    if (!WfUtils.isEmpty(compositeTaskId)) {
                        ile.setCompositeTaskId(compositeTaskId);
                        isDisplay = Boolean.FALSE;
                    }
                    ile.setDisplay(isDisplay);
                    ilkManager.update(ile);
                    HistoricIdentityLinkEntity hile = (HistoricIdentityLinkEntity)hilkManager.findById(ile.getId());
                    if (hile == null) continue;
                    hile.setCompositeTaskId(ile.getCompositeTaskId());
                    hile.setDisplay(isDisplay);
                    hilkManager.update(hile);
                }
            }
        }
    }

    public void voteNewCompiTask(DelegateExecution execution, boolean jump) {
        Long parentTaskId = null;
        CommandContext commandContext = Context.getCommandContext();
        HistoricIdentityLinkEntityManager hilkManager = commandContext.getHistoricIdentityLinkEntityManager();
        HistoricTaskInstanceEntityManager hiTaskMgr = commandContext.getHistoricTaskInstanceEntityManager();
        parentTaskId = jump ? execution.getCurrentTask().getId() : ((TaskEntity)execution.getCurrentTask()).getParentTaskId();
        if (WfUtils.isNotEmpty(parentTaskId)) {
            QFilter parentTaskIdFilter = new QFilter("parentTaskId", "=", (Object)parentTaskId);
            QFilter endtimeFilter = new QFilter("endTime", "is null", null);
            List hiChildTasks = hiTaskMgr.findByQueryFilters(new QFilter[]{parentTaskIdFilter, endtimeFilter});
            ArrayList<Long> passiveDeleteTaskIds = new ArrayList<Long>(hiChildTasks.size());
            HashSet<String> pdts = new HashSet<String>(hiChildTasks.size());
            for (HistoricTaskInstanceEntity ht : hiChildTasks) {
                pdts.add(String.valueOf(ht.getId()));
                passiveDeleteTaskIds.add(ht.getId());
            }
            if (!passiveDeleteTaskIds.isEmpty()) {
                String proInstIdStr = String.valueOf(execution.getProcessInstanceId());
                String[] cachedDeletedTaskIds = pdts.toArray(new String[0]);
                TaskHelper.setDeletedCache(execution.getProcessInstanceId(), cachedDeletedTaskIds);
                passiveDeleteTaskIds.remove(execution.getCurrentTask().getId());
                QFilter filter = new QFilter("compositetaskid", "in", passiveDeleteTaskIds);
                List identLinks = commandContext.getIdentityLinkEntityManager().findByQueryFilters(new QFilter[]{filter});
                List<Object> surviveLinks = new ArrayList();
                if (WfCacheHelper.getDeletedTaskIds(proInstIdStr) != null) {
                    List<String> deleteTasks = Arrays.asList(WfCacheHelper.getDeletedTaskIds(proInstIdStr));
                    for (IdentityLinkEntity identityLinkEntity : identLinks) {
                        if (deleteTasks.contains(String.valueOf(identityLinkEntity.getTaskId()))) continue;
                        surviveLinks.add(identityLinkEntity);
                    }
                } else {
                    surviveLinks = identLinks;
                }
                HashMap<String, Long> newCompiTaskIds = new HashMap<String, Long>();
                for (IdentityLinkEntity identityLinkEntity : surviveLinks) {
                    if (!WfUtils.isNotEmpty(identityLinkEntity.getParenttaskid())) continue;
                    newCompiTaskIds.put(String.valueOf(identityLinkEntity.getCompositeTaskId()), identityLinkEntity.getTaskId());
                }
                for (IdentityLinkEntity identityLinkEntity : surviveLinks) {
                    String oldCompiTaskId = String.valueOf(identityLinkEntity.getCompositeTaskId());
                    Long newCompiTaskId = (Long)newCompiTaskIds.get(oldCompiTaskId);
                    if (WfUtils.isEmpty(newCompiTaskId)) {
                        newCompiTaskId = identityLinkEntity.getTaskId();
                        newCompiTaskIds.put(oldCompiTaskId, newCompiTaskId);
                    }
                    Boolean isDisplay = identityLinkEntity.isDisplay();
                    if (identityLinkEntity.getTaskId().equals(newCompiTaskId)) {
                        identityLinkEntity.setCompositeTaskId(0L);
                        isDisplay = Boolean.TRUE;
                    } else {
                        identityLinkEntity.setCompositeTaskId(newCompiTaskId);
                        isDisplay = Boolean.FALSE;
                    }
                    identityLinkEntity.setDisplay(isDisplay);
                    commandContext.getIdentityLinkEntityManager().update(identityLinkEntity);
                    HistoricIdentityLinkEntity hile = (HistoricIdentityLinkEntity)hilkManager.findById(identityLinkEntity.getId());
                    if (hile == null) continue;
                    hile.setCompositeTaskId(identityLinkEntity.getCompositeTaskId());
                    hile.setDisplay(isDisplay);
                    hilkManager.update(hile);
                }
            }
        }
    }

    public static void setDeletedCache(Long procinstanceId, final String[] taskIds) {
        final String proInstIdStr = String.valueOf(procinstanceId);
        WfCacheHelper.addDeletedTaskIds(proInstIdStr, taskIds);
        Context.getCommandContext().addCloseListener(new DefaultCommandContextCloseListener("updateDeleteTaskId"){

            @Override
            public void closed(CommandContext commandContext) {
                WfCacheHelper.removeDeletedTaskIds(proInstIdStr, taskIds);
            }

            @Override
            public void closeFailure(CommandContext commandContext) {
                WfCacheHelper.removeDeletedTaskIds(proInstIdStr, taskIds);
            }
        });
    }

    public static boolean isComposeTask(Long taskId) {
        boolean isComposeTask = false;
        StringBuilder sb = new StringBuilder();
        sb.append("select a.fcreatedate createdate,a.fprocinstid procinstid from t_wf_execution a ");
        sb.append("inner join t_wf_task b on a.FID = b.Fprocinstid ");
        sb.append("where a.fisscope='1' and b.fid= ?");
        Map dt = (Map)DB.query((DBRoute)DBRoute.workflow, (String)sb.toString(), (Object[])new Object[]{taskId}, (ResultSetHandler)new ResultSetHandler<Map<String, Object>>(){

            public Map<String, Object> handle(ResultSet rs) throws SQLException {
                HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
                if (rs.next()) {
                    resultMap.put("createdate", rs.getDate("createdate"));
                    resultMap.put("procinstid", rs.getLong("procinstid"));
                    return resultMap;
                }
                resultMap.put("createdate", TimeServiceHelper.now());
                resultMap.put("procinstid", null);
                return resultMap;
            }
        });
        QFilter filter = new QFilter("compositetaskid", "=", (Object)taskId);
        QFilter filter2 = null;
        if (dt.get("procinstid") != null) {
            filter2 = new QFilter("processInstanceId", "=", dt.get("procinstid"));
        }
        QFilter df = new QFilter("createDate", ">=", dt.get("createdate"));
        boolean exists = QueryServiceHelper.exists((String)EntityNumberConstant.getHiIdentityLinkEntityNumber(), (QFilter[])new QFilter[]{filter2, filter, df});
        if (exists) {
            isComposeTask = true;
        }
        return isComposeTask;
    }

    public static boolean isComposedTask(Long taskId) {
        boolean isComposedTask = false;
        if (WfUtils.isEmpty(taskId)) {
            return isComposedTask;
        }
        QFilter taskIdFilter = new QFilter("taskId", "=", (Object)taskId);
        QFilter compositeTaskIdFilter = new QFilter("compositetaskid", "!=", (Object)0);
        boolean exists = QueryServiceHelper.exists((String)EntityNumberConstant.getHiIdentityLinkEntityNumber(), (QFilter[])new QFilter[]{taskIdFilter, compositeTaskIdFilter});
        if (exists) {
            isComposedTask = true;
        }
        return isComposedTask;
    }

    public static void dealWithCompositeTask(Long taskId) {
        if (TaskHelper.isComposeTask(taskId)) {
            ArrayList<Long> compositeTaskIds = new ArrayList<Long>();
            compositeTaskIds.add(taskId);
            Context.getCommandContext().getProcessEngineConfiguration().getTaskService().revoteCompositeTaskId(compositeTaskIds);
        } else if (TaskHelper.isComposedTask(taskId)) {
            TaskHelper.clearIdentityCompositeTaskId(taskId);
        }
    }

    public static void clearIdentityCompositeTaskId(Long taskId) {
        IdentityLinkEntityManager identityLinkEntityManager = Context.getCommandContext().getIdentityLinkEntityManager();
        List<IdentityLinkEntity> identityLinks = identityLinkEntityManager.findIdentityLinksByTaskId(taskId);
        for (IdentityLinkEntity identityLinkEntity : identityLinks) {
            identityLinkEntity.setCompositeTaskId(0L);
            identityLinkEntity.setDisplay(Boolean.TRUE);
            identityLinkEntityManager.update(identityLinkEntity);
        }
        HistoricIdentityLinkEntityManager historicIdentityLinkEntityManager = Context.getCommandContext().getHistoricIdentityLinkEntityManager();
        List<HistoricIdentityLinkEntity> hiIdentityLinks = historicIdentityLinkEntityManager.findHistoricIdentityLinksByTaskId(taskId);
        for (HistoricIdentityLinkEntity historicIdentityLinkEntity : hiIdentityLinks) {
            historicIdentityLinkEntity.setCompositeTaskId(0L);
            historicIdentityLinkEntity.setDisplay(Boolean.TRUE);
            historicIdentityLinkEntityManager.update(historicIdentityLinkEntity);
        }
    }

    public void taskAutoCirculate(CommandContext commandContext, UserTask userTask, DelegateExecution execution, Long taskId, List<Long> userIds, ILocaleString suggestion) {
        Circulate circulate;
        CirculateModel circulateModel = userTask.getCirculateModel();
        if (execution != null && circulateModel != null && circulateModel.isCirculateWhenMatch() && (circulate = circulateModel.getCirculate()) != null) {
            try {
                ProcessEngineConfigurationImpl processEngineConfigurationImpl = commandContext.getProcessEngineConfiguration();
                String businessKey = execution.getBusinessKey();
                if (CollectionUtil.isEmpty(userIds)) {
                    List<ParticipantModelEntityImpl> participants = circulate.getParticipant();
                    ParticipantCalculator participantCalculator = processEngineConfigurationImpl.getParticipantCalculator();
                    ConditionType.logConditionKey("participantAutoCirculate");
                    userIds = participantCalculator.getUserIds(businessKey, execution, participants);
                    ConditionType.removeConditionKey();
                }
                if (suggestion == null) {
                    suggestion = new LocaleString();
                    String suggestionMultiKey = String.format("%s.circulateModel.circulate.suggestion", userTask.getId());
                    ILocaleString suggestionExpression = BpmnModelUtil.getMultiLangFieldValue(execution.getProcessInstanceId(), suggestionMultiKey, circulate.getSuggestion());
                    if (WfUtils.isEmpty(suggestionExpression)) {
                        suggestionExpression = new LocaleString(circulate.getSuggestion());
                    }
                    DynamicObject dynamicObject = WfUtils.findBusinessObject(businessKey, execution.getEntityNumber());
                    for (Map.Entry entry : suggestionExpression.entrySet()) {
                        String key = (String)entry.getKey();
                        execution.setVariable(LANG, key);
                        String suggestionParser = ExpressionCalculatorUtil.contentParser((String)suggestionExpression.get((Object)key), dynamicObject, execution, true);
                        suggestion.setItem(key, (Object)suggestionParser);
                    }
                }
                Long senderId = 0L;
                this.log.debug(String.format("\u81ea\u52a8\u4f20\u9605\u81ea\u52a8\u5904\u7406\u5df2\u7ec4\u88c5\u5b8c\u53c2\u6570\uff0c\u51c6\u5907\u53d1\u9001\u4f20\u9605\u6d88\u606f\uff1ataskId\uff1a%s\uff0cuserIds\uff1a%s\uff0csuggestion\uff1a%s", taskId, userIds, suggestion));
                processEngineConfigurationImpl.getTaskService().taskCirculation(taskId, userIds, suggestion, senderId);
            }
            catch (Exception e) {
                String content = String.format(ResManager.loadKDString((String)"\u60a8\u63d0\u4ea4\u7684\u5355\u636e\u201c%1$s\u201d\u5728\u201c%2$s\u201d\u8282\u70b9\u81ea\u52a8%3$s\u65f6\uff0c\u53c2\u4e0e\u4eba\u6216\u8005\u201c%s\u610f\u89c1\u201d\u89e3\u6790\u51fa\u9519\uff0c\u201c%4$s\u201d\uff1a\u201c%5$s\u201d\u3002", (String)"TaskHelper_19", (String)"bos-wf-engine", (Object[])new Object[0]), ((ExecutionEntity)execution).getEntraBillName(), userTask.getName(), WfConfigurationUtil.getCirculationName(), WfConfigurationUtil.getCirculationName(), e.getClass().getName(), e.getMessage());
                throw new WFCirculateParserException(null, WFErrorCode.circulateParserError(), new Object[]{WfConfigurationUtil.getCirculationName(), content});
            }
            finally {
                execution.removeVariable(LANG);
            }
        }
    }

    public ILocaleString getParticipantName(List<Long> destUserIds) {
        User user = null;
        LocaleString retName = new LocaleString();
        int size = destUserIds.size();
        for (int i = 0; i < size; ++i) {
            Long destUserId = destUserIds.get(i);
            user = WfUtils.findUserById(destUserId);
            ILocaleString name = null;
            if (user != null && (name = user.getName()) != null) {
                for (Map.Entry entry : name.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)retName.get((Object)key);
                    StringBuilder sb = null;
                    sb = value == null ? new StringBuilder() : new StringBuilder(value);
                    sb.append((String)name.get((Object)key));
                    if (i < size - 1) {
                        sb.append(",");
                    }
                    retName.put((Object)key, (Object)sb.toString());
                }
                continue;
            }
            this.log.debug(String.format("\u627e\u4e0d\u5230\u7528\u6237\uff1a%s \u6216\u8be5\u7528\u6237\u7684Name\u4e3a\u7a7a\uff01", destUserId));
        }
        return retName;
    }

    public void wrapBackToRejectVariables(CommandContext commandContext, TaskEntity task, Map<String, Object> variables) {
        this.wrapBackToRejectVariables(commandContext, task, variables, null, null);
    }

    @Deprecated
    public boolean wrapBackToRejectVariablesRe(CommandContext commandContext, TaskEntity task, Map<String, Object> variables, BpmnModel bpmnModel, UserTask userTask) {
        return false;
    }

    public void wrapBackToRejectVariables(CommandContext commandContext, TaskEntity task, Map<String, Object> variables, BpmnModel bpmnModel, UserTask userTask) {
        Object name = variables.get("auditName");
        String category = task.getCategory();
        if ("SSCImageUploadNew".equalsIgnoreCase(category)) {
            name = WfUtils.getPromptWordLocaleString("\u4e0a\u4f20\u5f71\u50cf", "TaskHelper_32", "bos-wf-engine");
            variables.put("auditName", name);
        } else if (BpmnModelUtil.instanceofAuditTask(category)) {
            name = WfUtils.getPromptWordLocaleString("\u91cd\u65b0\u5ba1\u6279", "TaskHelper_33", "bos-wf-engine");
        }
        if (task.getHandleState().equals("dismissed")) {
            HistoricActivityInstanceEntityManager historicActivityInstanceEntityManager;
            HistoricActivityInstanceEntity actInst;
            boolean goRejectActivity = false;
            boolean isBackRejectedActivity = this.isBackRejectedActivity(variables, bpmnModel, task, userTask);
            if (isBackRejectedActivity) {
                goRejectActivity = true;
            }
            boolean isRejectBackToNode = false;
            String allowRejectAndGoBack = DynamicFlowUtil.getDynamicVariableValue(task.getExecution(), "allowRejectAndGoBack");
            if ("true".equalsIgnoreCase(allowRejectAndGoBack)) {
                String rejectBackToNode = DynamicFlowUtil.getDynamicVariableValue(task.getExecution(), "rejectBackToNode");
                if ("true".equalsIgnoreCase(rejectBackToNode)) {
                    goRejectActivity = true;
                    isRejectBackToNode = true;
                } else if ("false".equals(rejectBackToNode)) {
                    goRejectActivity = false;
                } else {
                    isRejectBackToNode = goRejectActivity = this.isRejectBackToNode(commandContext, task);
                }
            }
            if (goRejectActivity && (actInst = (historicActivityInstanceEntityManager = commandContext.getHistoricActivityInstanceEntityManager()).findActivityByTaskId(task.getId())) != null) {
                String rejectNodeId = this.getRejectNodeId(task.getProcessInstanceId(), actInst.getId());
                if (bpmnModel == null) {
                    bpmnModel = ProcessDefinitionUtil.getBpmnModel(task.getProcessDefinitionId(), task.getProcessInstanceId());
                    userTask = (UserTask)bpmnModel.getFlowElement(task.getTaskDefinitionKey());
                }
                boolean canBackRejectedNode = true;
                if (isBackRejectedActivity) {
                    Map<String, NodeForkJoinModel> models = bpmnModel.getMainProcess().getForkJoinModels();
                    if (WfUtils.isNotEmpty(rejectNodeId) && !models.isEmpty() && models.get(rejectNodeId) != null) {
                        String srcNodeId = task.getTaskDefinitionKey();
                        NodeForkJoinModel targetModel = models.get(rejectNodeId);
                        NodeForkJoinModel srcModel = models.get(srcNodeId);
                        if (targetModel != null && targetModel.isJoinNode()) {
                            canBackRejectedNode = false;
                        } else if (targetModel != null && srcModel != null) {
                            canBackRejectedNode = targetModel.getForkStructure().equals(srcModel.getForkStructure());
                        }
                    }
                    this.log.debug(String.format("rejectNodeId[%s],canSubmitToReject[%s]", rejectNodeId, canBackRejectedNode));
                }
                boolean canRejectBackToNode = true;
                FlowElement rejectFlowElement = bpmnModel.getFlowElement(rejectNodeId);
                if (!(rejectFlowElement == null || BpmnModelUtil.instanceofAuditTask(rejectFlowElement.getType()) || BpmnModelUtil.instanceofYunzhijiaTask(rejectFlowElement.getType()) || isBackRejectedActivity)) {
                    isRejectBackToNode = false;
                    canRejectBackToNode = false;
                }
                if (isRejectBackToNode) {
                    if (userTask != null && ForkJoinUtils.isForkNode(userTask) && "all".equals(userTask.getPassTypeAfterInnerReject())) {
                        canRejectBackToNode = false;
                    }
                    if (WfUtils.isEmpty(rejectNodeId)) {
                        rejectNodeId = this.getRejectIdForRejectBackToNode(commandContext, task);
                    }
                }
                String buildSensitiveFieldKey = SensitiveFieldUtil.buildSensitiveFieldKey(task.getBusinessKey(), task.getTaskDefinitionKey());
                Object sensitivefieldinfo = variables.get(buildSensitiveFieldKey);
                if (canBackRejectedNode && canRejectBackToNode && WfUtils.isNotEmpty(rejectNodeId) && sensitivefieldinfo == null) {
                    variables.put("nextNodeId", rejectNodeId);
                    variables.put("dynName", name);
                    variables.put("dynType", "dynBackToRejectNode");
                }
            }
        }
    }

    private boolean isBackRejectedActivity(Map<String, Object> variables, BpmnModel bpmnModel, TaskEntity task, UserTask userTask) {
        boolean isBackRejectedActivity = false;
        String backRejectedNode = (String)variables.get("backrejectednode");
        if ("true".equalsIgnoreCase(backRejectedNode)) {
            isBackRejectedActivity = true;
        } else {
            BpmnModel bpmnModel2 = bpmnModel = bpmnModel == null ? ProcessDefinitionUtil.getBpmnModel(task.getProcessDefinitionId(), task.getProcessInstanceId()) : bpmnModel;
            if (bpmnModel != null) {
                userTask = userTask == null ? (UserTask)bpmnModel.getFlowElement(task.getTaskDefinitionKey()) : userTask;
                isBackRejectedActivity = userTask != null && userTask.isBackRejectedActivity();
            }
        }
        return isBackRejectedActivity;
    }

    public boolean isRejectBackToNode(CommandContext commandContext, TaskEntity taskEntity) {
        String textValue;
        QFilter qfilter3;
        QFilter qfilter2;
        QFilter qfilter1;
        QFilter[] qFilters;
        HistoricVariableInstanceEntityManager hiVariableManager;
        List hiVariables;
        boolean isRejectBackToNode = false;
        Long currentActInstId = 0L;
        if (WfUtils.isEmpty(taskEntity.getParentTaskId()) && BpmnModelUtil.instanceofYunzhijiaTask(taskEntity.getCategory())) {
            currentActInstId = taskEntity.getExecution().getCurrentActInstId();
        } else {
            HistoricActivityInstanceEntityManager hiActivityInstManager = commandContext.getHistoricActivityInstanceEntityManager();
            HistoricActivityInstanceEntity hiActInst = hiActivityInstManager.findActivityByTaskId(taskEntity.getId());
            if (hiActInst != null) {
                currentActInstId = hiActInst.getId();
            }
        }
        Long taskId = 0L;
        Long processInstanceId = taskEntity.getProcessInstanceId();
        HistoricActivityInstanceEntity rejectHiActInstEntity = this.getRejectHiActInstEntity(processInstanceId, currentActInstId);
        if (rejectHiActInstEntity != null) {
            taskId = rejectHiActInstEntity.getTaskId();
            if ("YunzhijiaTask".equals(rejectHiActInstEntity.getActivityType())) {
                taskId = rejectHiActInstEntity.getParentTaskId();
            }
        } else {
            QFilter filter1 = new QFilter("processInstanceId", "=", (Object)processInstanceId);
            QFilter filter2 = new QFilter("handleState", "=", (Object)"reject");
            QFilter[] filters = new QFilter[]{filter1, filter2};
            List hiTasks = commandContext.getHistoricTaskInstanceEntityManager().findByQueryFilters(filters, "id,taskDefinitionKey,category,parentTaskId", "createdate desc");
            if (hiTasks != null && !hiTasks.isEmpty()) {
                HistoricTaskInstanceEntity hiTask = (HistoricTaskInstanceEntity)hiTasks.get(0);
                taskId = hiTask.getId();
                if ("YunzhijiaTask".equals(hiTask.getCategory())) {
                    taskId = hiTask.getParentTaskId();
                }
            }
        }
        if ((hiVariables = (hiVariableManager = commandContext.getHistoricVariableInstanceEntityManager()).findByQueryFilters(qFilters = new QFilter[]{qfilter1 = new QFilter("processInstanceId", "=", (Object)processInstanceId), qfilter2 = new QFilter("taskId", "=", (Object)taskId), qfilter3 = new QFilter("name", "=", (Object)"rejectBackToNode")}, String.format("%s,%s", "textValue", "typeName"), null)) != null && !hiVariables.isEmpty() && "true".equalsIgnoreCase(textValue = ((HistoricVariableInstanceEntity)hiVariables.get(0)).getTextValue())) {
            isRejectBackToNode = true;
        }
        return isRejectBackToNode;
    }

    public String getRejectIdForRejectBackToNode(CommandContext commandContext, TaskEntity taskEntity) {
        String rejectNodeId = "";
        HistoricActivityInstanceEntityManager hiActivityInstManager = commandContext.getHistoricActivityInstanceEntityManager();
        HistoricActivityInstanceEntity hiActInst = null;
        if ("YunzhijiaTask".equals(taskEntity.getCategory())) {
            Long parentTaskId = WfUtils.isNotEmpty(taskEntity.getParentTaskId()) ? taskEntity.getParentTaskId() : taskEntity.getId();
            hiActInst = hiActivityInstManager.findActivityByYzjAuditParentTaskId(taskEntity.getProcessInstanceId(), parentTaskId);
        } else {
            hiActInst = hiActivityInstManager.findActivityByTaskId(taskEntity.getId());
        }
        if (hiActInst != null) {
            HistoricActivityInstanceEntity rejectHiActInstEntity = this.getRejectHiActInstEntity(taskEntity.getProcessInstanceId(), hiActInst.getId());
            if (rejectHiActInstEntity != null) {
                rejectNodeId = rejectHiActInstEntity.getActivityId();
            } else {
                QFilter filter1 = new QFilter("processInstanceId", "=", (Object)taskEntity.getProcessInstanceId());
                ArrayList<String> handleStates = new ArrayList<String>(2);
                handleStates.add("reject");
                handleStates.add("forceReject");
                QFilter filter2 = new QFilter("handleState", "in", handleStates);
                QFilter[] filters = new QFilter[]{filter1, filter2};
                List hiTasks = commandContext.getHistoricTaskInstanceEntityManager().findByQueryFilters(filters, "id,taskDefinitionKey", "createdate desc");
                if (hiTasks != null && !hiTasks.isEmpty()) {
                    rejectNodeId = ((HistoricTaskInstanceEntity)hiTasks.get(0)).getTaskDefinitionKey();
                }
            }
        }
        return rejectNodeId;
    }

    public static Long addGroupInfo(TaskEntity taskEntity, ExecutionEntity execution) {
        Map<String, Object> variables = execution.getProcessInstance().getVariables();
        String groupById = (String)variables.get("groupby_id");
        TaskToDoGroupEntityManager groupManager = Context.getCommandContext().getTaskToDoGroupEntityManager();
        Long groupId = 0L;
        if (WfUtils.isEmpty(groupById)) {
            String bizTraceNo = taskEntity.getBizTraceNo();
            if (WfUtils.isNotEmpty(bizTraceNo)) {
                groupId = TaskHelper.getTaskToDoGroupEntityId(groupManager, (ILocaleString)new LocaleString(bizTraceNo), bizTraceNo);
            }
            return groupId;
        }
        String multiKey = String.format("node_1.variableGroup.variables.[%s].grouprealvalue.showinfo", groupById);
        ILocaleString showInfo = BpmnModelUtil.getMultiLangFieldValue(execution.getProcessInstanceId(), multiKey, null);
        if (WfUtils.isEmpty(showInfo)) {
            return groupId;
        }
        LocaleString groupName = new LocaleString();
        DynamicObject obj = WfUtils.findBusinessObject(execution.getBusinessKey(), execution.getEntityNumber());
        Set showInfos = showInfo.entrySet();
        for (Map.Entry si : showInfos) {
            String lang = (String)si.getKey();
            execution.setTransientVariable("lang", lang);
            String name = ExpressionCalculatorUtil.contentParser((String)si.getValue(), obj, execution, true);
            name = name.length() <= 500 ? name : name.substring(0, 500);
            groupName.setItem(lang, (Object)name);
        }
        execution.removeTransientVariable("lang");
        String groupRule = (String)variables.get("groupby_rule");
        groupRule = ExpressionCalculatorUtil.contentParser(groupRule, obj, execution, true);
        groupRule = groupRule.length() <= 500 ? groupRule : groupRule.substring(0, 500);
        Boolean isGroupbynode = (Boolean)variables.get("groupby_node");
        if (isGroupbynode.booleanValue()) {
            FlowElement currentFlowElement = taskEntity.getExecution().getCurrentFlowElement();
            StringBuilder sb = new StringBuilder();
            groupRule = currentFlowElement instanceof UserTask && WfUtils.isNotEmpty(((UserTask)currentFlowElement).getBizIdentifyKey()) ? sb.append(groupRule).append("_").append(((UserTask)currentFlowElement).getBizIdentifyKey()).toString() : sb.append(groupRule).append("_").append(taskEntity.getTaskDefinitionKey()).toString();
        }
        groupId = TaskHelper.getTaskToDoGroupEntityId(groupManager, (ILocaleString)groupName, groupRule);
        return groupId;
    }

    private static Long getTaskToDoGroupEntityId(TaskToDoGroupEntityManager groupManager, ILocaleString groupName, String groupRule) {
        Long groupId = 0L;
        List<TaskToDoGroupEntity> groups = groupManager.getTaskToDoGroupEntityByRule(groupRule);
        for (int i = 0; i < groups.size(); ++i) {
            TaskToDoGroupEntity group = groups.get(i);
            if (!WfUtils.isNotEmpty(group.getName()) || !WfUtils.isNotEmpty(groupName) || !WfUtils.isNotEmpty(groupName.toString()) || !groupName.toString().equalsIgnoreCase(group.getName().toString())) continue;
            groupId = group.getGroupNumber();
            return groupId;
        }
        try (DLock lock = DLock.create((String)String.format("wf/updateToHandleGroup/%s", groupRule)).fastMode();){
            boolean canLock = lock.tryLock(60000L);
            if (canLock) {
                QFilter f1 = new QFilter("rule", "=", (Object)groupRule);
                DynamicObject[] dyobjs = BusinessDataServiceHelper.load((String)"wf_tohandlegroup", (String)"id", (QFilter[])new QFilter[]{f1});
                if (dyobjs != null && dyobjs.length > 0) {
                    Long l = dyobjs[0].getLong("id");
                    return l;
                }
                ProcessEngineConfigurationImpl processEngineConfiguration = Context.getCommandContext().getProcessEngineConfiguration();
                CommandConfig commandConfig = processEngineConfiguration.getCommandExecutor().getDefaultConfig().transactionRequiresNew();
                Long l = groupId = processEngineConfiguration.getCommandExecutor().execute(commandConfig, new AddTaskGroupCmd(groupRule, groupName));
                return l;
            }
        }
        return groupId;
    }

    public void autoTransferRepeaterApproval(CommandContext commandContext, Long taskId, Long transfererId) {
        TaskEntity task = (TaskEntity)commandContext.getTaskEntityManager().findById(taskId);
        if (task != null && task.getIdentityLinks().size() == 1) {
            Long processInstanceId = task.getProcessInstanceId();
            Long prodefid = task.getProcessDefinitionId();
            Process process = ProcessDefinitionUtil.getProcess(prodefid, processInstanceId);
            FlowElement ele = process.getFlowElement(task.getTaskDefinitionKey());
            ExecutionEntity execution = task.getExecution();
            if (WfAfterAuditUtil.canDoAfterAudit(task).booleanValue()) {
                IPreComputorRecord record = PreComputorHelper.doAfterAuditPreComputor(execution.getProcessInstanceId());
                IPreComputorRecordItem item = PreComputorHelper.getNextAfterAuditNode(record, execution.getCurrentActivityId(), transfererId);
                task.setExecution(execution);
                if (item != null) {
                    TaskHelper taskHelper = Context.getProcessEngineConfiguration().getTaskHelper();
                    HashMap<String, Object> variables = new HashMap<String, Object>();
                    variables.put("auditNumber", "Consent");
                    taskHelper.skipTask(task, transfererId, variables);
                    this.saveOperationLog(task.getId(), item.getNodeName());
                    Context.getCommandContext().getHistoryManager().recordActivityExecutionType(execution, "skip", "SameParticipant");
                    return;
                }
            }
            if (ele instanceof AuditTask || ele instanceof YunzhijiaTask) {
                AuditTask auditTask = (AuditTask)ele;
                if (!auditTask.isRepeaterbtn()) {
                    return;
                }
                String repeaterModel = auditTask.getRepeaterModel();
                Boolean adjacentnodeonly = auditTask.isAdjacentnodeonly();
                HashMap<String, DecisionOption> approvalNumbers = new HashMap<String, DecisionOption>();
                for (DecisionOption op : auditTask.getDecisionOptions()) {
                    if (!"approve".equals(op.getAuditType())) continue;
                    approvalNumbers.put(op.getNumber(), op);
                }
                HashMap<String, String> remainSourceIdKeyMap = new HashMap<String, String>();
                ArrayList<Long> transfererIds = new ArrayList<Long>();
                transfererIds.add(transfererId);
                List<Object> repeaterApprovalInfo = new ArrayList();
                repeaterApprovalInfo = adjacentnodeonly != false ? TaskUtils.getRepeaterAdjacentNodes(transfererIds, execution.getProcessInstanceId(), auditTask.getId()) : TaskUtils.getRepeaterApprovalAllNumber(transfererIds, processInstanceId, prodefid, execution, remainSourceIdKeyMap);
                String hiAuditNumber = "";
                LocaleString auditMessage = new LocaleString();
                Long hicommentId = 0L;
                for (Map map : repeaterApprovalInfo) {
                    if (!approvalNumbers.containsKey(map.get("resultNumber"))) continue;
                    hicommentId = Long.valueOf((String)map.get("commentId"));
                    hiAuditNumber = (String)map.get("resultNumber");
                    if (!WfUtils.isNotEmpty(hicommentId)) continue;
                    CommentEntity comment = (CommentEntity)Context.getCommandContext().getCommentEntityManager().findById(hicommentId);
                    auditMessage = comment.getCommentMessage();
                    break;
                }
                if ("auto".equals(repeaterModel)) {
                    if (WfUtils.isNotEmpty(hicommentId) && WfUtils.isNotEmpty(hiAuditNumber)) {
                        HashMap<String, Object> variables = new HashMap<String, Object>();
                        DecisionOption decisionOption = (DecisionOption)approvalNumbers.get(hiAuditNumber);
                        variables.put("autoAudit", Boolean.TRUE);
                        variables.put("auditNumber", decisionOption.getNumber());
                        String multiKey = BpmnModelUtil.getDecisionNameMultiKey(execution.getActivityId(), decisionOption.getId());
                        ILocaleString autoDecisionName = BpmnModelUtil.getMultiLangFieldValue(execution.getProcessInstanceId(), multiKey, decisionOption.getName());
                        ILocaleString auto = WfUtils.getPromptWordLocaleString("[\u81ea\u52a8]", "AuditTaskActivityBehavior_1", "bos-wf-engine");
                        ILocaleString auditName = WfMultiLangUtils.getMultiLangValue(new ILocaleString[]{new LocaleString("%s%s"), autoDecisionName, auto});
                        variables.put("auditName", auditName);
                        variables.put("auditType", decisionOption.getAuditType());
                        variables.put("auditMessage", auditName);
                        variables.put("decisionscene", decisionOption.getDecisionScene());
                        if (WfUtils.isNotEmpty((ILocaleString)auditMessage)) {
                            variables.put("auditMessage", auditMessage);
                        }
                        TaskHelper taskHelper = Context.getProcessEngineConfiguration().getTaskHelper();
                        taskHelper.autoAudit(execution, task, variables, transfererId);
                    }
                } else if ("skip".equals(repeaterModel) && WfUtils.isNotEmpty(hicommentId) && WfUtils.isNotEmpty(hiAuditNumber)) {
                    TaskHelper taskHelper = Context.getProcessEngineConfiguration().getTaskHelper();
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("auditNumber", hiAuditNumber);
                    taskHelper.skipTask(task, transfererId, hashMap);
                    Context.getCommandContext().getHistoryManager().recordActivityExecutionType(execution, "skip", "SameParticipant");
                }
            }
        }
    }

    private void saveOperationLog(Long taskId, ILocaleString nodeName) {
        CommandContext commandContext = Context.getCommandContext();
        OperationLogEntityImpl operationLog = new OperationLogEntityImpl();
        Date date = commandContext.getProcessEngineConfiguration().getClock().getCurrentTime();
        operationLog.setTaskId(taskId);
        operationLog.setCreateDate(date);
        operationLog.setType("comment");
        operationLog.setNote(WfMultiLangUtils.replaceILocaleString((ILocaleString)ResManager.getLocaleString((String)"\u5ba1\u6279\u4eba\u540e\u5ba1\u63a7\u5236\uff0c\u4e0e\u540e\u5e8f\u8282\u70b9\uff08%s\uff09\u5904\u7406\u4eba\u76f8\u540c", (String)"AuditTaskActivityBehavior_3", (String)"bos-wf-engine"), nodeName));
        operationLog.setTerminalWay("background");
        WfOperationLogUtil.recordOperationLog(commandContext, operationLog);
    }

    public static void setTaskPriority(String taskLevel, List<IdentityLinkEntity> identityLinkEntities, TaskEntity task) {
        if (WfUtils.isNotEmptyForCollection(identityLinkEntities)) {
            Long taskId = task.getId();
            TaskMarkEntity entity = Context.getCommandContext().getTaskMarkEntityManager().getTaskMarkEntityByNumber(taskLevel);
            if (null != entity) {
                String value = entity.getValue();
                Integer priority = null;
                if (WfUtils.isNotEmpty(value)) {
                    priority = Integer.valueOf(value);
                    task.setPriority(priority);
                }
                IdentityLinkEntityManager identityLinkEntityManager = Context.getCommandContext().getIdentityLinkEntityManager();
                HistoricIdentityLinkEntityManager hIdentityLinkEntityManager = Context.getCommandContext().getHistoricIdentityLinkEntityManager();
                HistoricIdentityLinkEntity hIdentityLinkEntity = null;
                for (IdentityLinkEntity identityLinkEntity : identityLinkEntities) {
                    identityLinkEntity.setPriority(priority);
                    identityLinkEntityManager.update(identityLinkEntity);
                    hIdentityLinkEntity = (HistoricIdentityLinkEntity)hIdentityLinkEntityManager.findById(identityLinkEntity.getId());
                    hIdentityLinkEntity.setPriority(priority);
                    hIdentityLinkEntityManager.update(hIdentityLinkEntity);
                }
                RuleTaskRelationEntityManager manager = Context.getCommandContext().getRuleTaskRelationEntityManager();
                RuleTaskRelationEntityImpl relationEntity = new RuleTaskRelationEntityImpl();
                relationEntity.setTaskid(taskId);
                relationEntity.setMarkid(entity.getId());
                relationEntity.setRuletype(entity.getNumber());
                relationEntity.setUserid(Long.valueOf(RequestContext.get().getUserId()));
                relationEntity.setPriority(priority);
                manager.insert(relationEntity);
            }
        }
    }

    public static void planSavePageParameter(UserTask userTask, TaskEntity task) {
        List<PageParameter> pageParameter;
        BillSetting billSetting;
        HashMap<String, String> pageParameterMap = new HashMap<String, String>();
        if (null != userTask && null != (billSetting = userTask.getBillSetting()) && WfUtils.isNotEmptyForCollection(pageParameter = billSetting.getPageParameter())) {
            String parameterValue = null;
            Object expressionValue = null;
            for (PageParameter p : pageParameter) {
                parameterValue = p.getParameterValue();
                if (!WfUtils.isNotEmpty(parameterValue)) continue;
                expressionValue = parameterValue.startsWith("${") && parameterValue.matches("\\$\\{.+\\}") ? ExpressionCalculatorUtil.parseValue(null, task, parameterValue, null) : parameterValue;
                pageParameterMap.put(p.getParameterNumber(), (String)expressionValue);
            }
        }
        if (WfUtils.isNotEmptyForMap(pageParameterMap)) {
            task.setVariableLocal("pageParameter", SerializationUtils.toJsonString(pageParameterMap));
        }
    }

    public static Integer getPriorityValueByTaskLevel(Object taskLevel, Long taskId) {
        Integer priority = 0;
        String priorityValue = TaskHelper.getMarkValueByTaskLevel(taskLevel, taskId);
        if (WfUtils.isNotEmpty(priorityValue)) {
            priority = Integer.valueOf(priorityValue);
        }
        return priority;
    }

    public static String getMarkValueByTaskLevel(Object taskLevel, Long taskId) {
        String priority = "";
        if (WfUtils.isNotEmptyString(taskLevel)) {
            Object level = null;
            TaskMarkEntity entity = Context.getCommandContext().getTaskMarkEntityManager().getTaskMarkEntityByNumber(taskLevel.toString());
            if (null != entity) {
                priority = entity.getValue();
                ILocaleString levelILocal = entity.getName();
                if (null != levelILocal) {
                    String string = levelILocal.getLocaleValue();
                }
            }
        }
        return priority;
    }

    public void addOperationLogForTasks(CommandContext commandContext, List<TaskEntity> ts, Map<String, Object> variables, Long userId) {
        if (WfUtils.isEmptyForCollection(ts) || null == variables) {
            return;
        }
        if (variables.get("batchOpType") == null && variables.get("auditNumber") == null) {
            variables.remove("savedLogMark");
            return;
        }
        for (TaskEntity t : ts) {
            OperationLogEntityImpl operationLog = new OperationLogEntityImpl();
            operationLog.setTaskId(t.getId());
            this.buildLogInfoLikeComment(operationLog, variables, userId, t);
            WfOperationLogUtil.recordOperationLogByIdAndType(commandContext, operationLog, t.getProcessInstanceId(), "comment");
        }
    }

    public void updateTaskHandleLogForTasks(CommandContext commandContext, Long taskId, Object terminalWay, Long userId) {
        if (terminalWay != null) {
            QFilter filterTaskId = new QFilter("taskId", "=", (Object)taskId);
            QFilter filterUserId = new QFilter("assigneeid", "=", (Object)userId);
            QFilter[] filters = new QFilter[]{filterTaskId, filterUserId};
            List taskHandleLogs = commandContext.getTaskHandleLogEntityManager().findByQueryFilters(filters);
            for (TaskHandleLogEntity taskHandleLog : taskHandleLogs) {
                taskHandleLog.setTerminalWay(String.valueOf(terminalWay));
                commandContext.getTaskHandleLogEntityManager().update(taskHandleLog);
            }
        }
    }

    public void updateOperationLogForNote(CommandContext commandContext, Map<String, Object> variables, TaskEntity taskEntity) {
        try {
            Map<String, Object> sensitiveInfo = this.initSensitiveFielsChangeInfo(variables, taskEntity.getBusinessKey(), taskEntity.getTaskDefinitionKey());
            if (sensitiveInfo.get(SENSITIVECHANGLOG) != null) {
                OperationLogEntityManager manager = commandContext.getOperationLogEntityManager();
                QFilter qFilter1 = new QFilter("taskid", "=", (Object)taskEntity.getId());
                QFilter qFilter2 = new QFilter("procinstid", "=", (Object)taskEntity.getProcessInstanceId());
                QFilter qFilter3 = new QFilter("type", "=", (Object)"comment");
                QFilter[] filters = new QFilter[]{qFilter1, qFilter2, qFilter3};
                List entities = manager.findByQueryFilters(filters, manager.getSelectFields(), null);
                for (OperationLogEntity entity : entities) {
                    entity.setNote((ILocaleString)((LocaleString)sensitiveInfo.get(SENSITIVECHANGLOG)));
                    manager.update(entity);
                }
            }
            if (sensitiveInfo.get(SENSITIVECHANGMSG) != null) {
                CommentEntityManager commentEntityManager = commandContext.getCommentEntityManager();
                List<CommentEntity> commentEntitys = commentEntityManager.findCommentsByTaskId(taskEntity.getId());
                for (CommentEntity commentEntity : commentEntitys) {
                    commentEntity.setSensitivefieldchange((ILocaleString)((LocaleString)sensitiveInfo.get(SENSITIVECHANGMSG)));
                    commentEntityManager.update(commentEntity);
                }
            }
        }
        catch (Exception e) {
            this.log.debug("updateOperationLogForNote \u5f02\u5e38\uff1a" + WfUtils.getExceptionStacktrace(e));
        }
    }

    private void buildLogInfoLikeComment(OperationLogEntity operationLog, Map<String, Object> variables, Long userId, TaskEntity taskEntity) {
        ILocaleString userName;
        Object auditMessage = variables.get("auditMessage");
        Object message = null;
        message = auditMessage instanceof Map ? LocaleString.fromMap((Map)((Map)auditMessage)) : WfUtils.getMultiLangValue(auditMessage != null ? auditMessage.toString() : "");
        operationLog.setNOpinion((ILocaleString)message);
        operationLog.setResultNumber((String)variables.get("auditNumber"));
        Object tempResult = variables.get("auditName");
        Object result = null;
        result = tempResult instanceof Map && !(tempResult instanceof LocaleString) ? LocaleString.fromMap((Map)((Map)tempResult)) : WfUtils.getLocaleStringVariable(variables, "auditName");
        operationLog.setResultName((ILocaleString)result);
        operationLog.setDecisionType((String)variables.get("auditType"));
        operationLog.setTerminalWay((String)variables.get("terminal"));
        Map<String, Object> sensitiveInfo = this.initSensitiveFielsChangeInfo(variables, taskEntity.getBusinessKey(), taskEntity.getTaskDefinitionKey());
        if (sensitiveInfo.get(SENSITIVECHANGLOG) != null) {
            operationLog.setNote((ILocaleString)((LocaleString)sensitiveInfo.get(SENSITIVECHANGLOG)));
        }
        if ("reject".equals(operationLog.getDecisionType()) && "true".equals(variables.get("rejectBackToNode"))) {
            operationLog.setNote(WfMultiLangUtils.getMultiLangValue(WfUtils.getPromptWordLocaleString("\u9a73\u56de\u540e\u518d\u6b21\u63d0\u4ea4\u65f6\u76f4\u63a5\u56de\u5230\u672c\u8282\u70b9", "TaskHelper_35", "bos-wf-engine")));
        }
        if (WfUtils.isNotEmptyString(variables.get("assignee"))) {
            Object obj = variables.get("assignee");
            if (obj instanceof ILocaleString && !WfUtils.isEmpty(((ILocaleString)obj).toString())) {
                operationLog.setAssignee((ILocaleString)obj);
            } else if (obj instanceof String) {
                LocaleString localStr = new LocaleString();
                localStr.setLocaleValue((String)obj);
                if (!WfUtils.isEmpty(localStr.toString())) {
                    operationLog.setAssignee((ILocaleString)localStr);
                }
            }
        } else if (userId != null && userId > 0L && (userName = WfUtils.findUserName(userId)) != null && !WfUtils.isEmpty(userName.toString())) {
            operationLog.setAssignee(userName);
        }
    }

    public List<HistoricActivityInstanceEntity> loopAdjacentNode(List<HistoricActivityInstanceEntity> lastNodes, Long processInstanceId, Long currentActInstId) {
        HistoricActivityInstanceEntity entity;
        HistoricActivityInstanceEntityManager hisActivityManager = Context.getCommandContext().getHistoricActivityInstanceEntityManager();
        List<HistoricActivityInstanceEntity> lastSeqFlows = hisActivityManager.findByTargetId(processInstanceId, currentActInstId);
        if (WfUtils.isEmptyForCollection(lastSeqFlows) && (entity = (HistoricActivityInstanceEntity)hisActivityManager.findById(currentActInstId)) != null && BpmnModelUtil.instanceofYunzhijiaTask(entity.getActivityType())) {
            lastSeqFlows.add((HistoricActivityInstanceEntity)hisActivityManager.findById(entity.getSourceElementId()));
        }
        for (HistoricActivityInstanceEntity seqFlow : lastSeqFlows) {
            if (!"SequenceFlow".equalsIgnoreCase(seqFlow.getActivityType()) || "StartSignalEvent".equalsIgnoreCase(seqFlow.getActivityType())) break;
            HistoricActivityInstanceEntity activity = (HistoricActivityInstanceEntity)hisActivityManager.findById(seqFlow.getSourceElementId());
            if (activity == null) continue;
            boolean loop = false;
            if ("byAuto".equals(activity.getExecutionType()) && BpmnModelUtil.instanceofAuditTask(activity.getActivityType())) {
                if (WfUtils.isEmpty(activity.getAssigneeId())) {
                    BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(null, processInstanceId);
                    AuditTask autoAuditTask = (AuditTask)bpmnModel.getFlowElement(activity.getActivityId());
                    loop = autoAuditTask.getAutoAudit() != null && "reject".equalsIgnoreCase(BpmnModelUtil.getDecisionType(autoAuditTask, autoAuditTask.getAutoAudit().getAutoDecisionWhenMatch())) && autoAuditTask.getAutoAudit().getParticipantAsAutoAuditor() != false ? loop : Boolean.TRUE;
                }
            } else {
                boolean bl = loop = "skip".equals(activity.getExecutionType()) || BpmnModelUtil.instanceofAutoTask(activity.getActivityType()) || BpmnModelUtil.instanceofNotifyTask(activity.getActivityType()) || BpmnModelUtil.isInstanceof(activity.getActivityType(), "WaitTask") || "InclusiveGateway".equals(activity.getActivityType()) || BpmnModelUtil.isInstanceof(activity.getActivityType(), "SubProcess") || BpmnModelUtil.instanceofSSCApprover(activity.getActivityType()) || BpmnModelUtil.instanceofSSCImageUpload(activity.getActivityType()) || "jump".equals(activity.getExecutionType());
            }
            if (loop) {
                this.loopAdjacentNode(lastNodes, processInstanceId, activity.getId());
                continue;
            }
            if (this.isRejectActivity(activity)) {
                Date createDate;
                String activityId = activity.getActivityId();
                List<HistoricActivityInstanceEntity> rejectNodes = this.getBackRejectNode(processInstanceId, activityId, createDate = activity.getCreateDate());
                if (rejectNodes.isEmpty()) continue;
                Long id = rejectNodes.get(0).getId();
                this.loopAdjacentNode(lastNodes, processInstanceId, id);
                continue;
            }
            lastNodes.add(activity);
        }
        return lastNodes;
    }

    private boolean isRejectActivity(HistoricActivityInstanceEntity lastNode) {
        if (lastNode != null) {
            HistoricVariableInstanceEntity task;
            CommentEntityManager commentEntityManager;
            List<CommentEntity> list;
            Long taskId = null;
            String curNodeId = lastNode.getActivityId();
            if (BpmnModelUtil.instanceofYunzhijiaTask(lastNode.getActivityType())) {
                taskId = lastNode.getParentTaskId();
            } else if (BpmnModelUtil.instanceofAuditTask(lastNode.getActivityType())) {
                taskId = lastNode.getTaskId();
            }
            if (WfUtils.isNotEmpty(taskId) && (list = (commentEntityManager = Context.getCommandContext().getCommentEntityManager()).findCommentsByTaskId(taskId)) != null && !list.isEmpty() && "reject".equals(list.get(0).getDecisionType()) && (task = Context.getCommandContext().getHistoricVariableInstanceEntityManager().findHistoricVariableInstancesByTaskIdAndVarName(taskId, "nextNodeId")) != null && task.getValue() != null) {
                String value = (String)task.getValue();
                for (String nid : value.split("\\,")) {
                    if (!curNodeId.equalsIgnoreCase(nid)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public List<HistoricActivityInstanceEntity> getBackRejectNode(Long processInstanceId, String activityId, Date createDate) {
        HistoricActivityInstanceEntityManager hisActivityManager = Context.getCommandContext().getHistoricActivityInstanceEntityManager();
        QFilter proFilter = new QFilter("processinstanceid", "=", (Object)processInstanceId);
        QFilter dateFilter = new QFilter("createdate", "<", (Object)createDate);
        QFilter actFilter = new QFilter("activityid", "=", (Object)activityId);
        return hisActivityManager.findByQueryFilters(new QFilter[]{proFilter, dateFilter, actFilter}, "", "createdate desc");
    }

    public void deleteUndealCoordinateTask(CommandContext commandContext, List<TaskEntity> tasks) {
        if (CollectionUtils.isEmpty(tasks)) {
            return;
        }
        for (TaskEntity task : tasks) {
            if (!"YunzhijiaTask".equals(task.getCategory()) || CollectionUtils.isEmpty(task.getIdentityLinks())) continue;
            List<IdentityLinkEntity> identityLinks = task.getIdentityLinks();
            ArrayList<Long> userIds = new ArrayList<Long>(identityLinks.size());
            for (IdentityLinkEntity identityLink : identityLinks) {
                if (!"coordinate".equals(identityLink.getType())) continue;
                userIds.add(identityLink.getUserId());
            }
            if (userIds.isEmpty()) continue;
            Long taskId = task.getId();
            QFilter taskFilter = new QFilter("taskid", "=", (Object)taskId);
            QFilter typeFilter = new QFilter("type", "=", (Object)"coordinate");
            commandContext.getMessageService().deleteToDo(taskId, userIds);
            QFilter userFilter = new QFilter("userid", "in", userIds);
            commandContext.getIdentityLinkEntityManager().deleteByFilters(new QFilter[]{taskFilter, typeFilter, userFilter});
            commandContext.getHistoricIdentityLinkEntityManager().deleteByFilters(new QFilter[]{taskFilter, typeFilter, userFilter});
            userFilter = new QFilter("userid", "in", userIds);
            QFilter ruleTypeFilter = new QFilter("ruletype", "=", (Object)"coordinate");
            commandContext.getRuleTaskRelationEntityManager().deleteByFilters(new QFilter[]{taskFilter, ruleTypeFilter, userFilter});
        }
    }

    public void gatherAsyncCompensationData(TaskEntity task, QuantitySummary quantitySummary) {
        if (task == null) {
            return;
        }
        ArrayList<TaskEntity> taskEntities = new ArrayList<TaskEntity>();
        taskEntities.add(task);
        MessageQuantitySummaryServcie service = MessageServiceUtil.getMessageQuantitySummaryService();
        service.gatherDiffData(RequestContext.get().getUserId(), taskEntities, quantitySummary);
    }

    public void gatherAsyncCompensationData(TaskEntity task) {
        if (task == null) {
            return;
        }
        ArrayList<TaskEntity> taskEntities = new ArrayList<TaskEntity>();
        taskEntities.add(task);
        this.gatherAsyncCompensationData(taskEntities);
    }

    public void gatherAsyncCompensationData(List<TaskEntity> taskEntities) {
        MessageQuantitySummaryServcie service = MessageServiceUtil.getMessageQuantitySummaryService();
        service.gatherDiffData(RequestContext.get().getUserId(), taskEntities, QuantitySummary.MINUS);
    }
}

