/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.IntermediateCatchEvent;
import kd.bos.workflow.bpmn.model.TimerEventDefinition;
import kd.bos.workflow.engine.delegate.Expression;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.calendar.BusinessCalendar;
import kd.bos.workflow.engine.impl.calendar.CycleBusinessCalendar;
import kd.bos.workflow.engine.impl.calendar.DurationBusinessCalendar;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.el.ExpressionManager;
import kd.bos.workflow.engine.impl.el.NoExecutionVariableScope;
import kd.bos.workflow.engine.impl.persistence.entity.job.TimerJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.exception.WFEngineException;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;

public class TimerUtil {
    public static void initTimerEntityForTimerEventDefinition(TimerJobEntity timerJob, TimerEventDefinition timerEventDefinition, boolean isInterruptingTimer, ExecutionEntity executionEntity) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        String businessCalendarRef = null;
        Expression expression = null;
        ExpressionManager expressionManager = processEngineConfiguration.getExpressionManager();
        VariableScope scopeForExpression = executionEntity;
        if (scopeForExpression == null) {
            scopeForExpression = NoExecutionVariableScope.getSharedInstance();
        }
        if (StringUtils.isNotEmpty((String)timerEventDefinition.getTimeDate())) {
            businessCalendarRef = "dueDate";
            expression = expressionManager.createExpression(timerEventDefinition.getTimeDate());
        } else if (StringUtils.isNotEmpty((String)timerEventDefinition.getTimeCycle())) {
            businessCalendarRef = CycleBusinessCalendar.NAME;
            expression = expressionManager.createExpression(timerEventDefinition.getTimeCycle());
        } else if (StringUtils.isNotEmpty((String)timerEventDefinition.getTimeDuration())) {
            businessCalendarRef = DurationBusinessCalendar.NAME;
            expression = expressionManager.createExpression(timerEventDefinition.getTimeDuration());
        }
        if (StringUtils.isNotEmpty((String)timerEventDefinition.getCalendarName())) {
            businessCalendarRef = timerEventDefinition.getCalendarName();
            Expression businessCalendarExpression = expressionManager.createExpression(businessCalendarRef);
            businessCalendarRef = businessCalendarExpression.getValue(scopeForExpression).toString();
        }
        if (expression == null) {
            throw new WFEngineException("Timer needs configuration (either timeDate, timeCycle or timeDuration is needed) (" + timerEventDefinition.getId() + ")");
        }
        BusinessCalendar businessCalendar = processEngineConfiguration.getBusinessCalendarManager().getBusinessCalendar(businessCalendarRef);
        String dueDateString = null;
        Date duedate = null;
        Object dueDateValue = expression.getValue(scopeForExpression);
        if (dueDateValue instanceof String) {
            dueDateString = (String)dueDateValue;
        } else if (dueDateValue instanceof Date) {
            duedate = (Date)dueDateValue;
        } else if (dueDateValue instanceof DateTime) {
            duedate = ((DateTime)dueDateValue).toDate();
        } else if (dueDateValue != null) {
            String activityId = executionEntity != null ? executionEntity.getActivityId() : " ";
            throw new WFEngineException("Timer '" + activityId + "' was not configured with a valid duration/time, either hand in a java.util.Date or a String in format 'yyyy-MM-dd'T'hh:mm:ss'");
        }
        if (duedate == null && dueDateString != null) {
            String startDate = timerEventDefinition.getStartDate();
            duedate = businessCalendar.resolveDuedate(dueDateString, startDate);
        }
        if (duedate != null) {
            timerJob.setDuedate(duedate);
        }
        if (StringUtils.isNotEmpty((String)timerEventDefinition.getTimeCycle())) {
            FlowElement currentElement;
            boolean repeat;
            boolean bl = repeat = !isInterruptingTimer;
            if (executionEntity != null && (currentElement = executionEntity.getCurrentFlowElement()) instanceof IntermediateCatchEvent) {
                repeat = false;
            }
            if (repeat) {
                String prepared = TimerUtil.prepareRepeat(dueDateString);
                timerJob.setRepeat(prepared);
            }
        }
    }

    public static String prepareRepeat(String dueDate) {
        if (dueDate != null && dueDate.startsWith("R") && dueDate.split("/").length == 2) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            return dueDate.replace("/", "/" + sdf.format(Context.getProcessEngineConfiguration().getClock().getCurrentTime()) + "/");
        }
        return dueDate;
    }
}

