/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.jobexecutor.JobHandler;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.job.DeadLetterJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.FailedJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.service.IWorkflowCoreService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.task.service.MessageLogService;

public class ToDoJobUtil {
    public static final String IMMEDIATELY_RETRY = "immediately";
    public static final String SCHDULEEVN = "scheduleEnv";

    private ToDoJobUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reExecuteJob(CommandContext commandContext, JobEntity jobEntity) {
        Map<String, JobHandler> jobHandlers = commandContext.getProcessEngineConfiguration().getJobHandlers();
        JobHandler jobHandler = jobHandlers.get(jobEntity.getJobHandlerType());
        try {
            commandContext.addAttribute(IMMEDIATELY_RETRY, Boolean.FALSE);
            commandContext.addAttribute(SCHDULEEVN, Boolean.TRUE);
            jobHandler.execute(jobEntity, jobEntity.getJobHandlerConfiguration(), null, commandContext);
        }
        finally {
            commandContext.removeAttribute(SCHDULEEVN);
            ((MessageLogService)((IWorkflowCoreService)ServiceFactory.getService(IWorkflowCoreService.class)).getService(MessageLogService.class)).updateTaskJobByRootJobId(jobEntity.getId(), (Entity)jobEntity);
        }
    }

    public static void reExecuteFailedJob(CommandContext commandContext, FailedJobEntity failedJobEntity) {
        try {
            JobEntity jobEntity = commandContext.getFailedJobEntityManager().getJobEntityFromFailedJob(failedJobEntity);
            ToDoJobUtil.reExecuteJob(commandContext, jobEntity);
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                failedJobEntity.setRetries(failedJobEntity.getRetries() + 1);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{failedJobEntity.getDynamicObject()});
                throw throwable;
            }
        }
        failedJobEntity.setRetries(failedJobEntity.getRetries() + 1);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{failedJobEntity.getDynamicObject()});
    }

    public static void reExecuteDeadLetterJob(CommandContext commandContext, DeadLetterJobEntity deadJob) {
        try {
            JobEntity jobEntity = (JobEntity)commandContext.getJobEntityManager().create();
            jobEntity.setJobType(deadJob.getJobType());
            jobEntity.setRetries(deadJob.getRetries());
            jobEntity.setExecutionId(deadJob.getExecutionId());
            jobEntity.setProcessInstanceId(deadJob.getProcessInstanceId());
            jobEntity.setProcessDefinitionId(deadJob.getProcessDefinitionId());
            jobEntity.setBusinessKey(deadJob.getBusinessKey());
            jobEntity.setEntityNumber(deadJob.getEntityNumber());
            jobEntity.setJobHandlerType(deadJob.getJobHandlerType());
            jobEntity.setElementId(deadJob.getElementId());
            jobEntity.setOperation(deadJob.getOperation());
            jobEntity.setExceptionMessage(deadJob.getExceptionStackMessage());
            jobEntity.setJobHandlerConfiguration(deadJob.getJobHandlerConfiguration());
            jobEntity.setId(deadJob.getId());
            ToDoJobUtil.reExecuteJob(commandContext, jobEntity);
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                deadJob.setRetries(deadJob.getRetries() + 1);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{deadJob.getDynamicObject()});
                throw throwable;
            }
        }
        deadJob.setRetries(deadJob.getRetries() + 1);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{deadJob.getDynamicObject()});
    }

    @Deprecated
    private static String getConfiguration(String handleCfg) {
        JSONObject configuration = JSON.parseObject((String)handleCfg);
        String modelStr = configuration.getString("model");
        JSONObject model = JSON.parseObject((String)modelStr);
        model.put("check", (Object)Boolean.FALSE);
        configuration.put("model", (Object)model.toJSONString());
        return configuration.toJSONString();
    }
}

