/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.bpmn.converter.util.CollectionUtils;
import kd.bos.workflow.bpmn.model.BillTask;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.ViewFlowchartUtil;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class ViewBizFlowChartUtil {
    private static Log log = LogFactory.getLog(ViewBizFlowChartUtil.class);

    public static void initFloatLayerCellIds(Map<String, Object> data, Long procInstId) {
        if (WfUtils.isNotEmpty(procInstId) && ProcessType.BizFlow.name().equals(ViewFlowchartUtil.getWorkFlowType(procInstId))) {
            WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
            List<HistoricActivityInstanceEntity> historicActivities = wfService.getHistoryService().getHistoricActivityByProcessInstanceId(procInstId);
            BpmnModel bpmnModel = wfService.getRepositoryService().getBpmnModel(null, procInstId);
            List<FlowElement> flowElementList = bpmnModel.getMainProcess().getFlowElementList();
            if (CollectionUtils.isNotEmpty(flowElementList)) {
                ArrayList<String> floatLayerCellIds = new ArrayList<String>(flowElementList.size());
                for (FlowElement flowElement : flowElementList) {
                    boolean showFloatLayer = ViewBizFlowChartUtil.isShowFloatLayer(flowElement, historicActivities);
                    if (!showFloatLayer) continue;
                    floatLayerCellIds.add(flowElement.getId());
                }
                data.put("floatLayerCellIds", floatLayerCellIds);
            }
        }
    }

    private static boolean isShowFloatLayer(FlowElement flowElement, List<HistoricActivityInstanceEntity> historicActivities) {
        String type = flowElement.getType();
        if ("BillTask".equals(type)) {
            BillTask billTask = (BillTask)flowElement;
            if (WfUtils.isEmpty(billTask.getFloatLayerBillSummary())) {
                return false;
            }
            return ViewBizFlowChartUtil.hasNodeActivity(billTask.getEntityNumber(), historicActivities);
        }
        if ("UserTask".equals(type)) {
            UserTask userTask = (UserTask)flowElement;
            if (WfUtils.isEmpty(userTask.getFloatLayerBillSummary())) {
                return false;
            }
            return ViewBizFlowChartUtil.hasNodeActivity(userTask.getEntityNumber(), historicActivities);
        }
        if ("CallActivity".equals(type)) {
            CallActivity callActivity = (CallActivity)flowElement;
            if (WfUtils.isEmpty(callActivity.getFloatLayerBillSummary())) {
                return false;
            }
            return ViewBizFlowChartUtil.hasNodeActivity(callActivity.getEntityNumber(), historicActivities);
        }
        return false;
    }

    private static boolean hasNodeActivity(String entityNumber, List<HistoricActivityInstanceEntity> historicActivities) {
        if (WfUtils.isNotEmpty(entityNumber) && CollectionUtils.isNotEmpty(historicActivities)) {
            for (HistoricActivityInstanceEntity historicActivitie : historicActivities) {
                if (!entityNumber.equals(historicActivitie.getEntityNumber())) continue;
                return true;
            }
        }
        return false;
    }

    public static Long getCallProcInstIdByHiActInstId(String historicActivityInstanceId) {
        DynamicObject dynamicobject = BusinessDataServiceHelper.loadSingle((Object)historicActivityInstanceId, (String)"wf_hiactinst");
        Long callProcInstanceId = 0L;
        if (dynamicobject != null) {
            callProcInstanceId = dynamicobject.getLong("processInstanceId");
            if (WfUtils.isNotEmpty(dynamicobject.getLong("calledProcessInstanceId"))) {
                callProcInstanceId = dynamicobject.getLong("calledProcessInstanceId");
            } else {
                String entityNumber = dynamicobject.getString("entitynumber");
                String businessKey = dynamicobject.getString("businessKey");
                if (WfUtils.isEmpty(entityNumber) || WfUtils.isEmpty(businessKey)) {
                    log.debug(String.format("entityNumber or businessKey is empty! hisActInstId: %s, entityNumber: %s, businessKey: %s", historicActivityInstanceId, entityNumber, businessKey));
                    return callProcInstanceId;
                }
                WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
                List<HistoricActivityInstanceEntity> historicActivityInstanceEntities = wfService.getHistoryService().getHistoricActivityByBusinessKeyAndEntityNubmer(businessKey, entityNumber);
                if (CollectionUtil.isNotEmpty(historicActivityInstanceEntities)) {
                    for (HistoricActivityInstanceEntity historicActivityInstanceEntity : historicActivityInstanceEntities) {
                        if (!WfUtils.isNotEmpty(historicActivityInstanceEntity.getCalledProcessInstanceId())) continue;
                        callProcInstanceId = historicActivityInstanceEntity.getCalledProcessInstanceId();
                        break;
                    }
                }
            }
        }
        return callProcInstanceId;
    }

    public static Long getCallProcInstIdByHiActInstId(String procInstId, String historicActivityInstanceId) {
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        Long callProcInstanceId = 0L;
        if (WfUtils.isEmpty(procInstId) || WfUtils.isEmpty(historicActivityInstanceId)) {
            return callProcInstanceId;
        }
        HistoricActivityInstanceEntity hiActInst = wfService.getHistoryService().getHistoricActivityByProcessInstanceIdAndActivityInstId(Long.valueOf(procInstId), Long.valueOf(historicActivityInstanceId));
        if (hiActInst != null) {
            callProcInstanceId = Long.valueOf(procInstId);
            if (WfUtils.isNotEmpty(hiActInst.getCalledProcessInstanceId())) {
                callProcInstanceId = hiActInst.getCalledProcessInstanceId();
            } else {
                String entityNumber = hiActInst.getEntityNumber();
                String businessKey = hiActInst.getBusinessKey();
                if (WfUtils.isEmpty(entityNumber) || WfUtils.isEmpty(businessKey)) {
                    log.debug(String.format("entityNumber or businessKey is empty! hisActInstId: %s, entityNumber: %s, businessKey: %s", historicActivityInstanceId, entityNumber, businessKey));
                    return callProcInstanceId;
                }
                List<HistoricActivityInstanceEntity> historicActivityInstanceEntities = wfService.getHistoryService().getHistoricActivityByBusinessKeyAndEntityNubmer(businessKey, entityNumber);
                if (CollectionUtil.isNotEmpty(historicActivityInstanceEntities)) {
                    for (HistoricActivityInstanceEntity historicActivityInstanceEntity : historicActivityInstanceEntities) {
                        if (!WfUtils.isNotEmpty(historicActivityInstanceEntity.getCalledProcessInstanceId())) continue;
                        callProcInstanceId = historicActivityInstanceEntity.getCalledProcessInstanceId();
                        break;
                    }
                }
            }
        }
        return callProcInstanceId;
    }
}

