/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.bizflow.util.BizFlowUtil;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecContext;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.BillTask;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.GraphicInfo;
import kd.bos.workflow.bpmn.model.ParticipatantModel;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.StartEvent;
import kd.bos.workflow.bpmn.model.SubProcess;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.engine.EntityNumberConstant;
import kd.bos.workflow.engine.HistoryService;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.RuntimeService;
import kd.bos.workflow.engine.TaskService;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.history.HistoricActivityInstance;
import kd.bos.workflow.engine.identity.SimpleUserInfo;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.VariableInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntityImpl;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.ParticipantHelper;
import kd.bos.workflow.engine.precomputor.IPreComputorRecord;
import kd.bos.workflow.engine.precomputor.IPreComputorRecordItem;
import kd.bos.workflow.engine.task.TaskDelegateUtil;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import org.dom4j.Element;
import org.dom4j.Node;

public class ViewFlowchartUtil {
    private static Log log = LogFactory.getLog(ViewFlowchartUtil.class);
    private static WorkflowService service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
    public static final String GRAPHXML = "graph_xml";
    public static final String FLOWTYPE = "flowType";
    private static final String ISPRECOMPUTATOR = "isPreComputator";

    public static Map<String, Object> getFlowchartInitData(Long procInstId) {
        return ViewFlowchartUtil.getFlowchartInitData(procInstId, Boolean.FALSE, Boolean.FALSE);
    }

    public static Map<String, Object> getFlowchartInitData(Long procInstId, Boolean isPreComputator, Boolean isImmediate) {
        List<HistoricActivityInstanceEntity> entities = service.getHistoryService().getHistoricActivityByProcessInstanceId(procInstId);
        if (entities == null || entities.isEmpty()) {
            return null;
        }
        Long procDefId = entities.get(0).getProcessDefinitionId();
        BpmnModel model = service.getRepositoryService().getBpmnModel(procDefId, procInstId);
        List<SubProcess> subProcesses = model.getMainProcess().findFlowElementsOfType(SubProcess.class);
        GraphCodecContext context = new GraphCodecContext(model);
        ViewFlowchartUtil.getContextConfig(context);
        context.setProcInstId(procInstId);
        context.setCommentMap(ViewFlowchartUtil.getLatestActComment(procInstId));
        context.setHangupNodeIds(service.getRuntimeService().getProcessHangUpNodeIds(context.getProcInstId()));
        context.setManualHangUpNodeIds(service.getRuntimeService().getProcessManualHangUpNodeIds(context.getProcInstId()));
        return ViewFlowchartUtil.getInitData(context, procDefId, model, entities, subProcesses, isPreComputator, isImmediate);
    }

    public static Map<String, Object> getFlowchartInitDataByprocDefId(Long procDefId) {
        return ViewFlowchartUtil.getFlowchartInitDataByprocDefId(procDefId, null);
    }

    public static Map<String, Object> getFlowchartInitDataByprocDefId(Long procDefId, DynamicObject billObj) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        RepositoryService repositoryService = service.getRepositoryService();
        if (repositoryService != null) {
            Long schemeId = repositoryService.getSchemeIdByProcDefIdAndDym(procDefId, billObj);
            BpmnModel model = repositoryService.getBpmnModel(procDefId, schemeId, null);
            GraphCodecContext context = new GraphCodecContext(model);
            if (billObj != null) {
                ViewFlowchartUtil.initContext(context, procDefId, schemeId, billObj);
            }
            ViewFlowchartUtil.getContextConfig(context);
            Node node = GraphCodecUtils.convertBpmnModelToNode(model, context);
            ViewFlowchartUtil.adjustFlowSequence(model, node, context.getPreEdgeIds());
            result.put(GRAPHXML, node.asXML());
            Object error = context.getOtherInfo("tips");
            if (error != null) {
                result.put("tips", error);
            }
        }
        return result;
    }

    private static void getContextConfig(GraphCodecContext context) {
        context.setViewFlowchart(true);
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("gridEnabled", false);
        context.setConfig(config);
    }

    private static Map<String, Object> getInitData(GraphCodecContext context, Long procDefId, BpmnModel model, List<HistoricActivityInstanceEntity> entities, List<SubProcess> subProcesses, Boolean isPreComputator, Boolean isImeediate) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (subProcesses == null || subProcesses.isEmpty()) {
            ViewFlowchartUtil.initContext(context, model, entities, isPreComputator, isImeediate);
        } else {
            SubProcess subProcess = ViewFlowchartUtil.initContextWithSubProcesses(context, procDefId, model, entities, subProcesses);
            if (subProcess != null) {
                context.setSubProcessId(subProcess.getId());
                result.put("autoSizeCellId", subProcess.getId());
            }
        }
        Node node = GraphCodecUtils.convertBpmnModelToNode(model, context);
        ViewFlowchartUtil.adjustFlowSequence(model, node, context.getTraversedEdgeIds());
        ViewFlowchartUtil.adjustFlowSequence(model, node, context.getPreEdgeIds());
        result.put(GRAPHXML, node.asXML());
        if (!context.getCurrentNodeIds().isEmpty()) {
            result.put("currentCellId", context.getCurrentNodeIds().iterator().next());
        }
        result.put("time", String.valueOf(WfUtils.now().getTime()));
        result.put(FLOWTYPE, ViewFlowchartUtil.getWorkFlowType(context.getProcInstId()));
        result.put("tips", context.getOtherInfo("tips"));
        return result;
    }

    private static void initContext(GraphCodecContext context, BpmnModel model, List<HistoricActivityInstanceEntity> entities, Boolean isPreComputator, Boolean isImmediate) {
        CommentEntity comment = null;
        HashMap<String, List<HistoricActivityInstanceEntity>> entityMap = new HashMap<String, List<HistoricActivityInstanceEntity>>();
        int endEventCount = 0;
        int finishEndEvent = 0;
        HashMap<String, HistoricActivityInstanceEntity> skipNodeActMap = new HashMap<String, HistoricActivityInstanceEntity>(16);
        HashMap<String, String> actExecTypeMap = new HashMap<String, String>(1);
        ArrayList<HistoricActivityInstanceEntity> actInsts = null;
        HistoricProcessInstanceEntity procInst = (HistoricProcessInstanceEntity)service.getRepositoryService().findEntityById(context.getProcInstId(), "wf_hiprocinst", "endTime");
        boolean isEnded = procInst.getEndTime() != null;
        for (HistoricActivityInstanceEntity entity : entities) {
            ILocaleString assignee;
            String actType = entity.getActivityType();
            String string = entity.getActivityId();
            actInsts = (ArrayList<HistoricActivityInstanceEntity>)entityMap.get(string);
            if (actInsts == null) {
                actInsts = new ArrayList<HistoricActivityInstanceEntity>();
                entityMap.put(string, actInsts);
            }
            actInsts.add(entity);
            actExecTypeMap.put(string, entity.getExecutionType());
            if ("SequenceFlow".equals(actType)) {
                context.getTraversedEdgeIds().add(string);
            } else if (entity.getEndTime() == null && WfUtils.isEmpty(entity.getAssigneeId())) {
                context.getCurrentNodeIds().add(string);
            } else {
                context.getTraversedNodeIds().add(string);
                ViewFlowchartUtil.gatherSkipNodes(model, entity, context.getCurrentNodeIds(), skipNodeActMap);
            }
            if ("EndNoneEvent".equals(actType) || "EndTerminateEvent".equals(actType)) {
                ++endEventCount;
                if (entity.getEndTime() != null) {
                    ++finishEndEvent;
                }
            }
            if ((comment = context.getCommentMap().get(string)) == null || entity.getEndTime() == null || !WfUtils.isEmpty(comment.getAssignee()) || (assignee = entity.getAssignee()) == null || !WfUtils.isEmpty(assignee.toString())) continue;
            comment.setAssignee(entity.getAssignee());
        }
        context.getSkipNodeIds().addAll(skipNodeActMap.keySet());
        HistoricActivityInstanceEntity entity = null;
        List actEntities = null;
        for (Map.Entry entry : actExecTypeMap.entrySet()) {
            String actId = (String)entry.getKey();
            String execType = (String)entry.getValue();
            if ("cancel".equals(execType)) {
                actEntities = (List)entityMap.get(actId);
                entity = (HistoricActivityInstanceEntity)actEntities.get(0);
                context.getTraversedNodeIds().remove(entity.getActivityId());
                context.getCanceledNodeIds().add(entity.getActivityId());
                context.getCommentMap().remove(entity.getActivityId());
                continue;
            }
            if (execType == null || !"".equals(execType.trim())) continue;
            actEntities = (List)entityMap.get(actId);
            entity = (HistoricActivityInstanceEntity)actEntities.get(actEntities.size() - 1);
            ViewFlowchartUtil.removeSkipNodeIds(context, entity, skipNodeActMap);
        }
        if (BizFlowUtil.isBizFlow(model) && !entities.isEmpty()) {
            Long procInstId = entities.get(0).getProcessInstanceId();
            Map<String, Object> map = service.getHistoryService().getHistoricVariableByExecution(procInstId, new String[]{"bootNodeId"});
            String bootNodeId = (String)map.get("bootNodeId");
            if (WfUtils.isNotEmpty(bootNodeId)) {
                context.getSkipNodeIds().remove(bootNodeId);
            }
        }
        if (isPreComputator.booleanValue()) {
            Long p = context.getProcInstId();
            IPreComputorRecord iPreComputorRecord = ViewFlowchartUtil.getTaskService().fullViewFlowchar(p, isImmediate);
            ViewFlowchartUtil.initPrecomputationContext(context, iPreComputorRecord);
        }
        if (finishEndEvent > 0 && finishEndEvent == endEventCount && isEnded) {
            context.getCurrentNodeIds().clear();
        } else {
            context.setCurrentNodeUsersMap(ViewFlowchartUtil.getCurrentNodeUsersMap(context.getCurrentNodeIds(), entityMap));
            context.setCurrentNodeTaskMap(ViewFlowchartUtil.getCurrentNodeTaskMap(context.getCurrentNodeIds(), entityMap));
        }
    }

    private static void removeSkipNodeIds(GraphCodecContext context, HistoricActivityInstanceEntity entity, Map<String, HistoricActivityInstanceEntity> skipNodeActMap) {
        String actType = entity.getActivityType();
        if ("SequenceFlow".equals(actType)) {
            return;
        }
        if ("YunzhijiaTask".equals(actType)) {
            HistoricActivityInstanceEntity skippedAct = skipNodeActMap.get(entity.getActivityId());
            if (skippedAct == null) {
                return;
            }
            if (skippedAct.getParentTaskId() != null && !skippedAct.getParentTaskId().equals(entity.getParentTaskId())) {
                context.getSkipNodeIds().remove(entity.getActivityId());
            }
        } else {
            context.getSkipNodeIds().remove(entity.getActivityId());
        }
    }

    private static void initContext(GraphCodecContext context, Long procDefId, Long schemaId, DynamicObject billObj) {
        IPreComputorRecord precomputationProcess = ViewFlowchartUtil.getTaskService().precomputationProcess(procDefId, schemaId, billObj);
        ViewFlowchartUtil.initPrecomputationContext(context, precomputationProcess);
    }

    private static void initPrecomputationContext(GraphCodecContext context, IPreComputorRecord record) {
        CommentEntityImpl comment = null;
        List data = record.getPcrData();
        for (IPreComputorRecordItem node : data) {
            Boolean isnormal = node.getIsNormal();
            String nodeId = node.getNodeId();
            String nodeType = node.getNodeType();
            String status = node.getStatus();
            String errType = node.getErrType();
            LocaleString assignee = new LocaleString();
            String lang = RequestContext.get().getLang().toString();
            log.debug("initPrecomputationContext:" + nodeId);
            if (isnormal.booleanValue() || "participantError".equals(errType)) {
                ILocaleString ass;
                if (nodeType.contains("SequenceFlow")) {
                    context.getPreEdgeIds().add(nodeId);
                    continue;
                }
                context.getTraversedNodeIds().remove(nodeId);
                context.getSkipNodeIds().remove(nodeId);
                context.getCanceledNodeIds().remove(nodeId);
                comment = new CommentEntityImpl();
                assignee.setItem(lang, null);
                comment.setAssignee((ILocaleString)assignee);
                if ("skip".equals(status)) {
                    context.getSkipNodeIds().add(nodeId);
                } else if ("byAuto".equals(status)) {
                    ILocaleString assName;
                    String assigneeName;
                    context.getPreNodeIds().add(nodeId);
                    StringBuilder assBuilder = new StringBuilder();
                    ass = WfUtils.getPromptWordLocaleString("\u81ea\u52a8\u5ba1\u6279", "ViewFlowchartUtil_6", "bos-wf-engine");
                    if (ass != null) {
                        assBuilder.append((String)ass.get((Object)lang));
                        assBuilder.append(" ");
                    }
                    if (WfUtils.isNotEmpty(assigneeName = WfMultiLangUtils.getValueFromLocalString(node.getAssigneeName(), lang))) {
                        assName = WfUtils.getPromptWordLocaleString("\u9884\u4f30\u7684\u53c2\u4e0e\u4eba:", "ViewFlowchartUtil_4", "bos-wf-engine");
                        if (ass != null) {
                            assBuilder.append((String)assName.get((Object)lang));
                            assBuilder.append(assigneeName);
                        }
                    } else {
                        assName = WfUtils.getPromptWordLocaleString("\u672a\u8ba1\u7b97\u5230\u9884\u4f30\u7684\u53c2\u4e0e\u4eba\u3002", "ViewFlowchartUtil_5", "bos-wf-engine");
                        if (ass != null) {
                            assBuilder.append((String)assName.get((Object)lang));
                        }
                    }
                    assignee.setItem(lang, (Object)assBuilder.toString());
                    comment.setAssignee((ILocaleString)assignee);
                } else if ("autonode".equals(status)) {
                    context.getPreNodeIds().add(nodeId);
                } else {
                    context.getPreNodeIds().add(nodeId);
                    String assigneeName = WfMultiLangUtils.getValueFromLocalString(node.getAssigneeName(), lang);
                    if (WfUtils.isNotEmpty(assigneeName)) {
                        ass = WfUtils.getPromptWordLocaleString("\u9884\u4f30\u7684\u53c2\u4e0e\u4eba:", "ViewFlowchartUtil_4", "bos-wf-engine");
                        if (ass != null) {
                            assignee.setItem(lang, (Object)((String)ass.get((Object)lang) + assigneeName));
                        }
                        comment.setAssignee((ILocaleString)assignee);
                    } else {
                        ass = WfUtils.getPromptWordLocaleString("\u672a\u8ba1\u7b97\u5230\u9884\u4f30\u7684\u53c2\u4e0e\u4eba\u3002", "ViewFlowchartUtil_5", "bos-wf-engine");
                        if (ass != null) {
                            assignee.setItem(lang, ass.get((Object)lang));
                        }
                        comment.setAssignee((ILocaleString)assignee);
                    }
                }
                context.getCommentMap().put(nodeId, comment);
                continue;
            }
            context.setOtherInfos("tips", String.format(ResManager.loadKDString((String)"\u8282\u70b9%1$s\u9884\u6d4b\u5931\u8d25\uff1a%2$s", (String)"ViewFlowchartUtil_7", (String)"bos-wf-engine", (Object[])new Object[0]), node.getNodeName(), node.getErrMsg()));
            if (Integer.valueOf(1).equals(node.getLevel())) {
                context.setOtherInfos("tips", String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u9884\u6d4b\u7ed3\u675f\uff1a%1$s\u3002", (String)"ViewFlowchartUtil_8", (String)"bos-wf-engine", (Object[])new Object[0]), node.getErrMsg()));
            }
            log.debug(String.format("\u5728\u8ba1\u7b97%1$s\u65f6\u51fa\u73b0\u5f02\u5e38%2$s", node.getNodeName(), node.getExceptionMsg()));
            break;
        }
    }

    private static SubProcess initContextWithSubProcesses(GraphCodecContext context, Long procDefId, BpmnModel model, List<HistoricActivityInstanceEntity> entities, List<SubProcess> subProcesses) {
        int length = entities.size();
        HistoricActivityInstance entity = null;
        String actType = null;
        String actId = null;
        CommentEntity comment = null;
        String frozenNodeId = null;
        FlowNode frozenNode = null;
        String lastNodeExecType = null;
        Date lastNodeEndTime = null;
        Long subProcDefId = null;
        BaseElement subProcess = null;
        String thawNodeId = null;
        ArrayList<FlowNode> nodes = new ArrayList<FlowNode>();
        Set<String> currentNodeIds = context.getTraversedNodeIds();
        ArrayList<HistoricActivityInstance> actInsts = null;
        HashMap<String, List<HistoricActivityInstanceEntity>> entityMap = new HashMap<String, List<HistoricActivityInstanceEntity>>();
        HashMap<String, HistoricActivityInstanceEntity> skipNodeActMap = new HashMap<String, HistoricActivityInstanceEntity>(16);
        for (int i = 0; i < length - 1; ++i) {
            if (entity != null) {
                lastNodeExecType = entity.getExecutionType();
                lastNodeEndTime = entity.getEndTime();
            }
            if (null == (entity = entities.get(i))) continue;
            if (subProcDefId == null && !procDefId.equals(entity.getProcessDefinitionId())) {
                frozenNodeId = actId;
                frozenNode = (FlowNode)model.getFlowElement(frozenNodeId);
                nodes.add(frozenNode);
                if (lastNodeEndTime == null && WfUtils.isEmpty(lastNodeExecType)) {
                    thawNodeId = actId;
                }
                subProcDefId = entity.getProcessDefinitionId();
                subProcess = ViewFlowchartUtil.getSubProcess(subProcesses, subProcDefId);
                nodes.add((FlowNode)subProcess);
            }
            actType = entity.getActivityType();
            actId = entity.getActivityId();
            actInsts = (ArrayList<HistoricActivityInstance>)entityMap.get(actId);
            if (actInsts == null) {
                actInsts = new ArrayList<HistoricActivityInstance>();
                entityMap.put(actId, actInsts);
            }
            actInsts.add(entity);
            if (subProcDefId != null && subProcess != null && !subProcDefId.equals(entity.getProcessDefinitionId())) {
                context.getTraversedNodeIds().add(subProcess.getId());
                nodes.add((FlowNode)subProcess);
                nodes.add(frozenNode);
                subProcDefId = null;
                subProcess = null;
            }
            if ("SequenceFlow".equals(actType)) {
                context.getTraversedEdgeIds().add(actId);
            } else if (entity.getEndTime() == null) {
                currentNodeIds.add(actId);
            } else {
                context.getTraversedNodeIds().add(actId);
                ViewFlowchartUtil.gatherSkipNodes(model, (HistoricActivityInstanceEntity)entity, currentNodeIds, skipNodeActMap);
            }
            comment = context.getCommentMap().get(actId);
            if (comment == null || entity.getEndTime() == null) continue;
            ILocaleString assignee = entity.getAssignee();
            if (!WfUtils.isEmpty(comment.getAssignee()) || assignee == null || WfUtils.isEmpty(assignee.toString())) continue;
            comment.setAssignee(assignee);
        }
        context.getSkipNodeIds().addAll(skipNodeActMap.keySet());
        if (ViewFlowchartUtil.isProcessTerminale(context.getCurrentNodeIds(), entityMap)) {
            context.getTraversedNodeIds().addAll(context.getCurrentNodeIds());
            context.getCurrentNodeIds().clear();
        }
        if (thawNodeId != null) {
            if (!currentNodeIds.isEmpty()) {
                context.getTraversedNodeIds().addAll(currentNodeIds);
            }
            currentNodeIds.clear();
            currentNodeIds.add(thawNodeId);
            if (null != subProcess) {
                context.getTraversedNodeIds().add(subProcess.getId());
            }
            subProcess = null;
            subProcDefId = null;
        }
        if (!nodes.isEmpty()) {
            model = model.clone();
            ViewFlowchartUtil.addDynamicSequenceFlows(model, nodes);
            ViewFlowchartUtil.addSubProcessNodes(model, nodes, context.getProcInstId());
        }
        context.setCurrentNodeUsersMap(ViewFlowchartUtil.getCurrentNodeUsersMap(context.getCurrentNodeIds(), entityMap));
        return subProcess;
    }

    private static boolean isProcessTerminale(Set<String> currentNodeIds, Map<String, List<HistoricActivityInstanceEntity>> entityMap) {
        List<HistoricActivityInstanceEntity> entities = null;
        for (String nodeId : currentNodeIds) {
            entities = entityMap.get(nodeId);
            for (HistoricActivityInstanceEntity entity : entities) {
                if ("EndNoneEvent".equals(entity.getActivityType()) || "EndTerminateEvent".equals(entity.getActivityType())) continue;
                return false;
            }
        }
        return true;
    }

    private static Map<String, Long> getCurrentNodeTaskMap(Set<String> currentNodeIds, Map<String, List<HistoricActivityInstanceEntity>> entityMap) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        if (currentNodeIds == null || currentNodeIds.isEmpty()) {
            return map;
        }
        List<HistoricActivityInstanceEntity> entities = null;
        for (String nodeId : currentNodeIds) {
            entities = entityMap.get(nodeId);
            for (HistoricActivityInstanceEntity entity : entities) {
                map.put(entity.getActivityId(), WfUtils.isNotEmpty(entity.getParentTaskId()) ? entity.getParentTaskId() : entity.getTaskId());
            }
        }
        return map;
    }

    private static Map<String, List<SimpleUserInfo>> getCurrentNodeUsersMap(Set<String> currentNodeIds, Map<String, List<HistoricActivityInstanceEntity>> entityMap) {
        HashMap<String, List<SimpleUserInfo>> map = new HashMap<String, List<SimpleUserInfo>>();
        if (currentNodeIds == null || currentNodeIds.isEmpty()) {
            return map;
        }
        HashMap<Long, String> relation = new HashMap<Long, String>();
        StringBuilder taskIds = new StringBuilder();
        List<HistoricActivityInstanceEntity> entities = null;
        for (String nodeId : currentNodeIds) {
            entities = entityMap.get(nodeId);
            for (HistoricActivityInstanceEntity entity : entities) {
                relation.put(entity.getTaskId(), entity.getActivityId());
                taskIds.append(entity.getTaskId()).append(",");
            }
        }
        if (taskIds.length() > 1) {
            taskIds.deleteCharAt(taskIds.length() - 1);
        }
        Process process = null;
        if (entities != null && !entities.isEmpty()) {
            Long processInstanceId = entities.get(0).getProcessInstanceId();
            Long processDefinitionId = entities.get(0).getProcessDefinitionId();
            BpmnModel bpmnModel = service.getRepositoryService().getBpmnModel(processDefinitionId, processInstanceId);
            process = bpmnModel.getMainProcess();
        }
        String lang = RequestContext.get().getLang().toString();
        String userNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_participant", "p", "pl", "fusername", "name", "username");
        String userNameFormatSql = WfMultiLangUtils.getGeneralLangSQL("wf_participant", "p", "pl", "fusernameformatter", "usernameformatter", "usernameformatter");
        String trustNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_participant", "p", "pl", "ftrustname", "trustname", "trustname");
        String trusteeNameFormatSQL = WfMultiLangUtils.getGeneralLangSQL("wf_participant", "p", "pl", "ftrustnameformat", "trustnameformat", "trustnameformat");
        StringBuilder sql = new StringBuilder();
        sql.append("select p.fid,fuserid,fprocdefid,ftaskid,").append(userNameSQL).append(",").append(userNameFormatSql).append(",").append(trustNameSQL).append(",").append(trusteeNameFormatSQL);
        sql.append(" from t_wf_participant p left join t_wf_participant_l pl on p.fid = pl.fid and pl.flocaleid = ? ");
        sql.append(String.format(" where ftype = ? and ftaskid in (%s) and p.fdelegateId = 0  order by fid asc", taskIds));
        Object[] params = new Object[]{lang, "participant"};
        boolean isDisplaySetting = WfConfigurationUtil.isDisplaySetting();
        try (DataSet ds = DB.queryDataSet((String)"wf.engine.viewflowchart.getCurrentNodeUsers", (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])params);){
            Iterator iter = ds.iterator();
            ArrayList<SimpleUserInfo> userIds = null;
            while (iter.hasNext()) {
                UserTask userTask;
                ParticipatantModel participantModel;
                Row row = (Row)iter.next();
                Long userId = row.getLong("fuserid");
                Long taskId = row.getLong("ftaskid");
                String actId = (String)relation.get(taskId);
                userIds = (ArrayList<SimpleUserInfo>)map.get(actId);
                if (userIds == null) {
                    userIds = new ArrayList<SimpleUserInfo>();
                    map.put(actId, userIds);
                }
                String displayInfo = null;
                if (process != null && (participantModel = (userTask = (UserTask)process.getFlowElement(actId)).getParticipant()) != null) {
                    displayInfo = participantModel.getDisplayInfo();
                }
                String userNameFormatter = (String)row.get("usernameformatter");
                String userName = ParticipantHelper.getUserName(row.getString("name"), userNameFormatter);
                if (!isDisplaySetting && WfUtils.isEmpty(displayInfo)) {
                    userName = row.getString("name");
                }
                String trustNameFormat = row.getString("trustnameformat");
                String trustName = ParticipantHelper.getUserName(row.getString("trustname"), trustNameFormat);
                if (!isDisplaySetting && WfUtils.isEmpty(displayInfo)) {
                    trustName = row.getString("trustname");
                }
                if (!WfUtils.isEmpty(trustName)) {
                    userName = TaskDelegateUtil.getDelegateAssigneeName(userName, trustName, "entrust");
                }
                userIds.add(new SimpleUserInfo(userId, userName));
            }
        }
        return map;
    }

    private static Map<String, CommentEntity> getLatestActComment(Long procInstId) {
        List<CommentEntity> comments = service.getRepositoryService().getParticipantSettingCommentsByProcInstId(procInstId, "activityId,taskId,resultName,decisionType,assignee,userId,usernameformatter,ownerid,assignorname", "id asc");
        String yzjTaskNumber = String.format("\\w+%s\\d+$", "YunzhijiaTask");
        HashMap<String, CommentEntity> summaryComment = new HashMap<String, CommentEntity>(16);
        HashMap<String, CommentEntity> latestActComment = new HashMap<String, CommentEntity>(comments.size());
        for (CommentEntity commentEntity : comments) {
            String activityId = commentEntity.getActivityId();
            latestActComment.put(activityId, commentEntity);
            if (!WfUtils.isEmpty(commentEntity.getUserId()) || !activityId.matches(yzjTaskNumber)) continue;
            summaryComment.put(activityId, commentEntity);
        }
        if (!summaryComment.isEmpty()) {
            for (Map.Entry entry : summaryComment.entrySet()) {
                latestActComment.put((String)entry.getKey(), (CommentEntity)entry.getValue());
            }
        }
        return latestActComment;
    }

    private static void gatherSkipNodes(BpmnModel model, HistoricActivityInstanceEntity entity, Set<String> currentNodeIds, Map<String, HistoricActivityInstanceEntity> skipNodeActMap) {
        String actId = entity.getActivityId();
        if (currentNodeIds.contains(actId)) {
            return;
        }
        boolean isFirstUserTask = false;
        List<UserTask> firstUserTasks = BpmnModelUtil.getFirstUserTasks(model.getMainProcess());
        for (UserTask firstUserTask : firstUserTasks) {
            if (!actId.equals(firstUserTask.getId())) continue;
            isFirstUserTask = true;
            break;
        }
        if (("skip".equals(entity.getExecutionType()) || "jump".equals(entity.getExecutionType())) && !isFirstUserTask) {
            skipNodeActMap.put(actId, entity);
        }
        ViewFlowchartUtil.gatherBizFlowSkipNodes(model, entity, skipNodeActMap, actId, isFirstUserTask);
    }

    private static void gatherBizFlowSkipNodes(BpmnModel model, HistoricActivityInstanceEntity entity, Map<String, HistoricActivityInstanceEntity> skipNodeActMap, String actId, boolean isFirstUserTask) {
        if (isFirstUserTask && BizFlowUtil.isBizFlow(model)) {
            Map<String, Object> variables = service.getHistoryService().getHistoricVariableByExecution(entity.getProcessInstanceId(), new String[]{"bootNodePrevNodeIds"});
            if (variables == null || variables.isEmpty()) {
                return;
            }
            String prevNodeIds = (String)variables.get("bootNodePrevNodeIds");
            if (prevNodeIds != null && prevNodeIds.contains(actId)) {
                skipNodeActMap.put(actId, entity);
            }
        }
    }

    private static Node adjustFlowSequence(BpmnModel model, Node node, Set<String> edgeIds) {
        Node element = null;
        Element root = (Element)node.getDocument().getRootElement().selectSingleNode("/mxGraphModel/root");
        String id = null;
        try {
            Iterator<String> iterator = edgeIds.iterator();
            while (iterator.hasNext()) {
                String edgeId;
                id = edgeId = iterator.next();
                element = root.selectSingleNode("mxCell[@id='" + edgeId + "']");
                root.remove(element);
                root.add(element);
            }
        }
        catch (Exception e) {
            FlowElement flowElement = model.getFlowElement(id);
            String tip = null;
            if (flowElement instanceof SequenceFlow) {
                SequenceFlow flow = (SequenceFlow)flowElement;
                tip = String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u4ece\u201c%1$s\u201d\u8282\u70b9\u5230\u201c%2$s\u201d\u8282\u70b9\u7684\u8fde\u7ebf\u201c%3$s\u201d\u3002", (String)"ViewFlowchartUtil_1", (String)"bos-wf-engine", (Object[])new Object[0]), flow.getSourceFlowElement().getName(), flow.getTargetFlowElement().getName(), id);
            } else {
                tip = String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230ID\u4e3a\u201c%s\u201d\u7684\u8fde\u7ebf\u3002", (String)"ViewFlowchartUtil_2", (String)"bos-wf-engine", (Object[])new Object[0]), id);
            }
            log.warn(String.format("Error node XML: %s ", node.asXML()));
            throw new KDBizException(tip);
        }
        return node;
    }

    private static SequenceFlow addDynamicSequenceFlow(BpmnModel model, FlowNode source, FlowNode target) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("is_dynamic_node", true);
        SequenceFlow flow = (SequenceFlow)GraphCodecUtils.getDefaultElement(SequenceFlow.class, model, config);
        flow.setDynamic(true);
        flow.setSourceRef(source.getId());
        flow.setSourceFlowElement(source);
        flow.setTargetRef(target.getId());
        flow.setTargetFlowElement(target);
        source.getOutgoingFlows().add(flow);
        target.getIncomingFlows().add(flow);
        model.getMainProcess().addFlowElement(flow);
        return flow;
    }

    private static void addDynamicSequenceFlows(BpmnModel model, List<FlowNode> nodes) {
        for (int i = 0; i < nodes.size(); i += 2) {
            ViewFlowchartUtil.addDynamicSequenceFlow(model, nodes.get(i), nodes.get(i + 1));
        }
    }

    private static void addSubProcessNodes(BpmnModel model, List<FlowNode> nodes, Long procInstId) {
        SubProcess subProcess = null;
        HashSet<String> ids = new HashSet<String>();
        for (FlowNode node : nodes) {
            if (!(node instanceof SubProcess) || ids.contains((subProcess = (SubProcess)node).getId())) continue;
            ids.add(subProcess.getId());
            ViewFlowchartUtil.addSubProcessElements(model, subProcess, procInstId);
        }
    }

    private static SubProcess getSubProcess(List<SubProcess> subProcesses, Long subProcDefId) {
        for (SubProcess process : subProcesses) {
            if (!("" + subProcDefId).equals(process.getSubProcessId())) continue;
            return process;
        }
        return null;
    }

    private static void addSubProcessElements(BpmnModel model, SubProcess subProcess, Long procInstId) {
        Long subProcDefId = Long.parseLong(subProcess.getSubProcessId());
        BpmnModel subModel = service.getRepositoryService().getBpmnModel(subProcDefId, procInstId).clone();
        StartEvent start = subModel.getMainProcess().findFlowElementsOfType(StartEvent.class).get(0);
        GraphicInfo graphic = model.getGraphicInfo(subProcess.getId());
        Map<String, GraphicInfo> locationMap = subModel.getLocationMap();
        Double maxWidth = null;
        for (Map.Entry<String, GraphicInfo> entry : locationMap.entrySet()) {
            String key = entry.getKey();
            graphic = locationMap.get(key);
            if (maxWidth != null && !(maxWidth < graphic.getWidth())) continue;
            maxWidth = graphic.getWidth();
        }
        double shiftingY = subModel.getGraphicInfo(start.getId()).getY() - 10.0 - Double.parseDouble(GraphCodecUtils.getStyleValue(subProcess.getStyle(), "startSize", "40"));
        Process process = subModel.getMainProcess();
        process.setResourceId(subProcess.getId());
        for (FlowElement element : subModel.getMainProcess().getFlowElementList()) {
            model.getMainProcess().addFlowElement(element);
            model.getMainProcess().addFlowElementToMap(element);
            if (element instanceof SequenceFlow) {
                model.addFlowGraphicInfoList(element.getId(), subModel.getFlowLocationMap().get(element.getId()));
            } else if (element instanceof FlowNode) {
                graphic = subModel.getLocationMap().get(element.getId());
                graphic.setX(10.0 + (maxWidth - graphic.getWidth()) / 2.0);
                graphic.setY(graphic.getY() - shiftingY);
                model.addGraphicInfo(element.getId(), graphic);
            }
            element.setParentContainer(process);
        }
    }

    public static void showFlowchart(IFormView view, FormShowParameter parameter) {
        ViewFlowchartUtil.showFlowchart(view, parameter, null);
    }

    public static void showFlowchart(IFormView view, FormShowParameter parameter, OpenStyle style) {
        QFilter qFilter;
        DynamicObjectCollection cl;
        boolean isFromMobile;
        String procInstId = (String)parameter.getCustomParam("procInstId");
        String procDefId = (String)parameter.getCustomParam("procDefId");
        if (WfUtils.isEmpty(procInstId) && WfUtils.isEmpty(procDefId)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u7684\u6d41\u7a0b\u5b9e\u4f8bID\u4e3a\u7a7a\u4e14\u5355\u636e\u63d0\u4ea4\u5bfb\u5740\u672a\u627e\u5230\u6d41\u7a0b\uff0c\u65e0\u6cd5\u67e5\u770b\u6d41\u7a0b\u56fe\u3002", (String)"ViewFlowchartUtil_9", (String)"bos-wf-engine", (Object[])new Object[0]));
            return;
        }
        boolean bl = isFromMobile = parameter.getCustomParam("isFromMobile") == null ? Boolean.FALSE.booleanValue() : ((Boolean)parameter.getCustomParam("isFromMobile")).booleanValue();
        if (isFromMobile) {
            ViewFlowchartUtil.viewFlowChartOnMobile(view, procInstId);
            return;
        }
        String processType = (String)parameter.getCustomParam("processType");
        if (WfUtils.isNotEmpty(procInstId) && WfUtils.isEmpty(processType) && WfUtils.isNotEmptyForCollection((Collection)(cl = QueryServiceHelper.query((String)"wf_hiprocinst", (String)"processType,processdefinitionid", (QFilter[])new QFilter[]{qFilter = new QFilter("id", "=", (Object)Long.parseLong(procInstId))}, (String)"createdate asc", (int)1)))) {
            processType = ((DynamicObject)cl.get(0)).getString("processType");
        }
        if (ModelType.NoCodeFlow.name().equals(processType)) {
            parameter.setFormId("wf_nocode_viewflowchart");
        } else {
            parameter.setFormId("bpm_viewflowchart");
        }
        ViewFlowchartUtil.showOperatePageForWorkflow(view, parameter, style);
    }

    public static void showOperatePageForWorkflow(IFormView view, FormShowParameter parameter, OpenStyle style) {
        if (style != null && ShowType.InContainer.equals((Object)style.getShowType())) {
            parameter.setOpenStyle(style);
            view.showForm(parameter);
            return;
        }
        if (ShowType.NonModal.equals((Object)view.getFormShowParameter().getOpenStyle().getShowType())) {
            if (style != null) {
                parameter.setOpenStyle(style);
            } else {
                parameter.getOpenStyle().setShowType(ShowType.NonModal);
            }
            view.showForm(parameter);
        } else {
            if (style != null) {
                parameter.setOpenStyle(style);
            } else {
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            }
            view.showForm(parameter);
        }
    }

    public static IFormView getTabControlView(IFormView view) {
        if (view == null) {
            return null;
        }
        int count = 0;
        IFormView appView = null;
        IFormView parentView = view;
        IFormView mainView = view.getMainView();
        SessionManager sessionManager = SessionManager.getCurrent();
        if (mainView != null) {
            appView = sessionManager.getViewNoPlugin(view.getFormShowParameter().getAppId() + mainView.getPageId());
        } else {
            log.debug("mainView is null!");
        }
        while ((parentView = sessionManager.getViewNoPlugin(parentView.getFormShowParameter().getParentPageId())) != null && !"pc_main_console".equals(parentView.getFormShowParameter().getFormId())) {
            if (++count > 10) {
                return null;
            }
            Control control = parentView.getControl("_submaintab_");
            if (control != null && (appView == null || appView.getPageId().equals(parentView.getPageId()))) {
                return parentView;
            }
            OpenStyle openStyle = parentView.getFormShowParameter().getOpenStyle();
            if (openStyle == null || ShowType.NewWindow != openStyle.getShowType()) continue;
            log.debug(String.format("parentView '%s' opened with NewWindow.", parentView.getFormShowParameter().getFormId()));
            break;
        }
        if (appView != null && appView.getControl("_submaintab_") != null) {
            return appView;
        }
        log.debug("appView is null or no targetkey!");
        return null;
    }

    protected HistoryService getHistoryService() {
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        return wfService.getHistoryService();
    }

    protected static TaskService getTaskService() {
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        return wfService.getTaskService();
    }

    public static void viewFlowChartOnMobile(IFormView view, String procInstId) {
        ViewFlowchartUtil.viewFlowChartOnMobile(view, procInstId, false);
    }

    public static void viewFlowChartOnMobile(IFormView view, String procInstId, boolean preComputator) {
        if (StringUtils.isEmpty((CharSequence)procInstId)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8b\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ViewFlowchartUtil_3", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setFormId("wf_viewflowchartmobile");
        parameter.setCustomParam("device", (Object)"mobile");
        parameter.setClientParam("procInstId", (Object)procInstId);
        parameter.setClientParam("preComputator", (Object)preComputator);
        if (preComputator) {
            parameter.setCaption(WFMultiLangConstants.getPreComputatorName());
        }
        view.showForm(parameter);
    }

    public static boolean isTerminate(Long procInstId) {
        Object entity = WfUtils.getWfService().getRepositoryService().findEntityById(procInstId, "wf_hiprocinst");
        HistoricProcessInstanceEntity procInstEntity = (HistoricProcessInstanceEntity)entity;
        return procInstEntity.getEndTime() != null;
    }

    public static boolean isAutoTest(Long procInstId) {
        HistoricProcessInstanceEntity procInstEntity = (HistoricProcessInstanceEntity)WfUtils.getWfService().getRepositoryService().findEntityById(procInstId, "wf_hiprocinst", "testingPlanId");
        if (procInstEntity == null) {
            return false;
        }
        return WfUtils.isNotEmpty(procInstEntity.getTestingPlanId());
    }

    public static String getYzjTeamMemberNamesFromVariable(Long parentTaskId, RuntimeService runtimeService, BaseElement element) {
        try {
            String text;
            VariableInstanceEntity VariableInstanceEntity2;
            HashMap<String, Object> parameter = new HashMap<String, Object>();
            parameter.put("taskId", parentTaskId);
            Map<String, VariableInstanceEntity> variableInstances = ParticipantHelper.getVariableInstancesForFormat(parentTaskId, runtimeService, parameter);
            if (variableInstances == null || variableInstances.isEmpty()) {
                return null;
            }
            String diplayInfo = null;
            YunzhijiaTask userTask = (YunzhijiaTask)element;
            ParticipatantModel participantModel = userTask.getParticipant();
            if (participantModel != null) {
                diplayInfo = participantModel.getDisplayInfo();
            }
            if ((VariableInstanceEntity2 = variableInstances.get("teamMemberNamesFormat")) == null || !WfConfigurationUtil.isDisplaySetting() && WfUtils.isEmpty(diplayInfo)) {
                VariableInstanceEntity2 = variableInstances.get("teamMemberNames");
            }
            if (WfUtils.isNotEmpty(text = VariableInstanceEntity2.getTextValue())) {
                String lang = RequestContext.get().getLang().toString();
                ILocaleString localeNames = (ILocaleString)SerializationUtils.fromJsonString((String)text, LocaleString.class);
                String names = (String)localeNames.get((Object)lang);
                if (names != null) {
                    return names.replaceAll(",", "\u3001");
                }
            }
        }
        catch (Exception e) {
            log.error(WfUtils.getExceptionStacktrace(e));
        }
        return null;
    }

    public static boolean isAutoTestVersion(Long procInstId) {
        HistoricProcessInstanceEntity procInstEntity = (HistoricProcessInstanceEntity)WfUtils.getWfService().getRepositoryService().findEntityById(procInstId, "wf_hiprocinst", "processDefinitionId");
        if (procInstEntity == null) {
            return false;
        }
        Long defId = procInstEntity.getProcessDefinitionId();
        ProcessDefinitionEntity procDefEntiy = (ProcessDefinitionEntity)WfUtils.getWfService().getRepositoryService().findEntityById(defId, "wf_processdefinition", "enable");
        return "testing".equals(procDefEntiy.getEnable());
    }

    public static String getWorkFlowType(Long procInstId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)procInstId, (String)EntityNumberConstant.getHiProcInstEntityNumber());
        String procdefId = dynamicObject.getString("processDefinitionId");
        DynamicObject procdefObject = BusinessDataServiceHelper.loadSingle((Object)procdefId, (String)"wf_processdefinition");
        return procdefObject.getString("type");
    }

    public static String getWorkFlowType(Long processInstanceId, Long processDefinitionId) {
        if (WfUtils.isEmpty(processDefinitionId)) {
            return ViewFlowchartUtil.getWorkFlowType(processInstanceId);
        }
        DynamicObject procdefObject = BusinessDataServiceHelper.loadSingle((Object)processDefinitionId, (String)"wf_processdefinition");
        return procdefObject.getString("type");
    }

    public static String getBizFlowBillSummary(BpmnModel bpmnModel, FlowElement flowElement, String entitynumber) {
        String flowEntityNumber = ViewFlowchartUtil.getFlowElementEntityNumber(flowElement);
        if (flowEntityNumber != null && flowEntityNumber.equals(entitynumber)) {
            return ViewFlowchartUtil.getFlowElementBizFlowbillSummary(flowElement);
        }
        return ViewFlowchartUtil.getSourceFlowElementBizFlowSummary(bpmnModel, flowElement, entitynumber);
    }

    private static String getFlowElementBizFlowbillSummary(FlowElement flowElement) {
        if (flowElement instanceof UserTask) {
            return ((UserTask)flowElement).getBizFlowBillSummary();
        }
        if (flowElement instanceof CallActivity) {
            return ((CallActivity)flowElement).getBizFlowbillSummary();
        }
        return null;
    }

    private static String getFlowElementEntityNumber(FlowElement flowElement) {
        if (flowElement instanceof UserTask) {
            return ((UserTask)flowElement).getEntityNumber();
        }
        if (flowElement instanceof CallActivity) {
            return ((CallActivity)flowElement).getEntityNumber();
        }
        return null;
    }

    private static String getSourceFlowElementBizFlowSummary(BpmnModel bpmnModel, FlowElement flowElement, String entitynumber) {
        if (!(flowElement instanceof FlowNode)) {
            return null;
        }
        List<SequenceFlow> incomingFlows = ((FlowNode)flowElement).getIncomingFlows();
        if (CollectionUtil.isEmpty(incomingFlows)) {
            return null;
        }
        Iterator<SequenceFlow> iterator = incomingFlows.iterator();
        if (iterator.hasNext()) {
            SequenceFlow incomingFlow = iterator.next();
            FlowElement sourceflowElement = bpmnModel.getFlowElement(incomingFlow.getSourceRef());
            if (sourceflowElement == null) {
                return null;
            }
            String flowEntityNumber = ViewFlowchartUtil.getFlowElementEntityNumber(sourceflowElement);
            if (flowEntityNumber != null && flowEntityNumber.equals(entitynumber)) {
                return ViewFlowchartUtil.getFlowElementBizFlowbillSummary(sourceflowElement);
            }
            return ViewFlowchartUtil.getSourceFlowElementBizFlowSummary(bpmnModel, sourceflowElement, entitynumber);
        }
        return null;
    }

    public static List<String> getFilterEntityNumbers(Long procInstId, String cellId) {
        ArrayList<String> filterEntityNumbers = new ArrayList<String>(4);
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        BpmnModel bpmnModel = wfService.getRepositoryService().getBpmnModel(null, procInstId);
        FlowElement flowElement = bpmnModel.getFlowElement(cellId);
        if (flowElement instanceof BillTask) {
            filterEntityNumbers.add(((BillTask)flowElement).getEntityNumber());
        } else if (flowElement instanceof UserTask) {
            filterEntityNumbers.add(((UserTask)flowElement).getEntityNumber());
        } else if (flowElement instanceof CallActivity) {
            filterEntityNumbers.add(((CallActivity)flowElement).getEntityNumber());
        }
        return filterEntityNumbers;
    }
}

