/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.util;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.api.AgentTask;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.OperationLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.OperationLogEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;

public class WfOperationLogUtil {
    private static final Log log = LogFactory.getLog(WfOperationLogUtil.class);

    public static void recordOperationLogFromComment(CommandContext commandContext, CommentEntity comment, ILocaleString note, ILocaleString bizNote) {
        if (null == comment) {
            return;
        }
        OperationLogEntityImpl operationLog = new OperationLogEntityImpl();
        operationLog.setCommentId(comment.getId());
        operationLog.setTaskId(comment.getTaskId());
        operationLog.setCreateDate(comment.getTime());
        operationLog.setTerminalWay(comment.getTerminalWay());
        WfOperationLogUtil.buildCommentType(comment, operationLog);
        operationLog.setNOpinion(comment.getCommentMessage());
        operationLog.setNote(note);
        operationLog.setBizNote(bizNote);
        operationLog.setResultNumber(comment.getResultNumber());
        operationLog.setResultName(comment.getCommentResult());
        operationLog.setDecisionType(comment.getDecisionType());
        operationLog.setIsPublic(comment.getIsPublic());
        operationLog.setNote(note);
        WfOperationLogUtil.recordOperationLog(commandContext, operationLog);
    }

    public static void recordOperationLogFromTaskHandle(CommandContext commandContext, TaskHandleLogEntity taskHandleLog, ILocaleString note, ILocaleString bizNote) {
        if (null == taskHandleLog) {
            return;
        }
        OperationLogEntityImpl operationLog = new OperationLogEntityImpl();
        operationLog.setTaskId(taskHandleLog.getTaskId());
        operationLog.setCreateDate(taskHandleLog.getCreateDate());
        operationLog.setTerminalWay(taskHandleLog.getTerminalWay());
        WfOperationLogUtil.buildHandleLogType(taskHandleLog, operationLog);
        operationLog.setNOpinion(taskHandleLog.getOpinion());
        operationLog.setNote(WfUtils.isNotEmpty(note) ? note : taskHandleLog.getNote());
        operationLog.setBizNote(bizNote);
        WfOperationLogUtil.recordOperationLog(commandContext, operationLog);
    }

    public static void recordOperationLog(CommandContext commandContext, OperationLogEntity operationLog) {
        if (null == operationLog) {
            return;
        }
        if (!commandContext.getProcessEngineConfiguration().isEnableOperationLogging()) {
            return;
        }
        if (WfUtils.isEmpty(operationLog.getTerminalWay())) {
            operationLog.setTerminalWay(RequestContext.get().getClient());
        }
        WfOperationLogUtil.buildTaskInfo(commandContext, operationLog);
        operationLog.setAssigneeId(WfUtils.subStringForMax(operationLog.getAssigneeId(), 2000));
        operationLog.setAssignee(WfUtils.subILocaleString(operationLog.getAssignee(), 2000));
        Long procInstId = operationLog.getProcInstId();
        if (WfUtils.isNotEmpty(procInstId)) {
            operationLog.setStep(commandContext.getOperationLogEntityManager().calculateLogStep(procInstId));
        }
        commandContext.getOperationLogEntityManager().insert(operationLog);
    }

    public static void recordOperationLogByIdAndType(CommandContext commandContext, OperationLogEntity operationLog, Long processInstanceId, String type) {
        Date date = commandContext.getProcessEngineConfiguration().getClock().getCurrentTime();
        operationLog.setCreateDate(date);
        operationLog.setProcInstId(processInstanceId);
        operationLog.setType(type);
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        operationLog.setOwnerId(userId);
        operationLog.setOwner(WfUtils.findUserName(userId));
        WfOperationLogUtil.recordOperationLog(commandContext, operationLog);
    }

    private static void buildTaskInfo(CommandContext commandContext, OperationLogEntity operationLog) {
        TaskEntity task = null;
        if (null != operationLog) {
            if (WfUtils.isNotEmpty(operationLog.getTaskId())) {
                Long taskId = operationLog.getTaskId();
                task = (TaskEntity)commandContext.getTaskEntityManager().findById(taskId);
                if (null != task) {
                    if (task.getSource().equalsIgnoreCase("wf")) {
                        BpmnModel bpmnModel;
                        try {
                            bpmnModel = ProcessDefinitionUtil.getBpmnModel(task.getProcessDefinitionId(), task.getProcessInstanceId());
                        }
                        catch (Exception e) {
                            log.error(WfUtils.getExceptionStacktrace(e));
                            return;
                        }
                        FlowElement element = bpmnModel.getFlowElement(task.getTaskDefinitionKey());
                        operationLog.setBizIdentifyKey(element.getBizIdentifyKey());
                    }
                    operationLog.setActivityId(task.getTaskDefinitionKey());
                    operationLog.setActivityName(task.getName());
                    operationLog.setProcDefId(task.getProcessDefinitionId());
                    operationLog.setProcInstId(task.getProcessInstanceId());
                    operationLog.setBusinessKey(task.getBusinessKey());
                    operationLog.setBillNo(task.getBillNo());
                } else {
                    HistoricTaskInstanceEntity hiTask = (HistoricTaskInstanceEntity)commandContext.getHistoricTaskInstanceEntityManager().findById(taskId);
                    if (null != hiTask) {
                        if (hiTask.getSource().equalsIgnoreCase("wf")) {
                            BpmnModel bpmnModel;
                            try {
                                bpmnModel = ProcessDefinitionUtil.getBpmnModel(hiTask.getProcessDefinitionId(), hiTask.getProcessInstanceId());
                            }
                            catch (Exception e) {
                                log.error(WfUtils.getExceptionStacktrace(e));
                                return;
                            }
                            FlowElement element = bpmnModel.getFlowElement(hiTask.getTaskDefinitionKey());
                            operationLog.setBizIdentifyKey(element.getBizIdentifyKey());
                        }
                        operationLog.setActivityId(hiTask.getTaskDefinitionKey());
                        operationLog.setActivityName(hiTask.getName());
                        operationLog.setProcDefId(hiTask.getProcessDefinitionId());
                        operationLog.setProcInstId(hiTask.getProcessInstanceId());
                        operationLog.setBusinessKey(hiTask.getBusinessKey());
                        operationLog.setBillNo(hiTask.getBillNo());
                    }
                }
            } else {
                HistoricProcessInstanceEntity obj = (HistoricProcessInstanceEntity)commandContext.getHistoricProcessInstanceEntityManager().findById(operationLog.getProcInstId());
                if (null != obj) {
                    operationLog.setProcDefId(obj.getProcessDefinitionId());
                    operationLog.setBusinessKey(obj.getBusinessKey());
                    operationLog.setBillNo(obj.getBillNo());
                }
            }
        }
    }

    private static void buildCommentType(CommentEntity comment, OperationLogEntity operationLog) {
        operationLog.setOwnerId(comment.getUserId());
        operationLog.setOwner(WfUtils.findUserName(comment.getUserId()));
        String type = comment.getType();
        if ("comment".equals(type)) {
            operationLog.setType("comment");
            operationLog.setAssignee(comment.getTaskAssignee());
        } else if ("coordinate".equals(type)) {
            operationLog.setType("coordinateReply");
            operationLog.setAssigneeId(String.valueOf(comment.getOwnerId()));
            operationLog.setAssignee(WfUtils.findUserName(comment.getOwnerId()));
        } else if ("suggestion".equals(type)) {
            operationLog.setType("addComment");
        } else if ("converted".equals(type)) {
            operationLog.setType("converted");
        }
    }

    private static void buildHandleLogType(TaskHandleLogEntity taskHandleLog, OperationLogEntity operationLog) {
        if ("transfer".equals(taskHandleLog.getType())) {
            operationLog.setType("transfer");
        }
        if ("coordinate".equals(taskHandleLog.getType())) {
            operationLog.setType("coordinateRequest");
        }
        if ("circulation".equals(taskHandleLog.getType())) {
            operationLog.setType("circulation");
        }
        operationLog.setOwnerId(taskHandleLog.getOwnerId());
        operationLog.setOwner(WfUtils.findUserName(taskHandleLog.getOwnerId()));
        operationLog.setAssigneeId(String.valueOf(taskHandleLog.getAssigneeid()));
        operationLog.setAssignee(taskHandleLog.getAssignee());
    }

    public static OperationLogEntity recordOperationLogForSendLinkMsg(List<Long> assigneeIds, ILocaleString opinion, Date createDate, DelegateExecution execution) {
        if (null == assigneeIds || assigneeIds.isEmpty() || null == execution) {
            return null;
        }
        StringBuilder assigneeIdSb = new StringBuilder();
        for (Long userId : assigneeIds) {
            if (null == userId || userId == 0L) continue;
            assigneeIdSb.append(userId).append(",");
        }
        if (0 == assigneeIdSb.length()) {
            return null;
        }
        OperationLogEntityImpl operationLog = new OperationLogEntityImpl();
        operationLog.setAssigneeId(assigneeIdSb.substring(0, assigneeIdSb.length() - 1));
        operationLog.setAssignee((ILocaleString)new LocaleString(WfUtils.getUsersName(assigneeIds)));
        operationLog.setNOpinion(opinion);
        operationLog.setCreateDate(createDate);
        operationLog.setType("textMessage");
        Long currentUserId = Long.valueOf(RequestContext.get().getUserId());
        operationLog.setOwnerId(currentUserId);
        operationLog.setOwner(WfUtils.findUserName(currentUserId));
        Long processInstanceId = execution.getProcessInstanceId();
        operationLog.setProcInstId(processInstanceId);
        ILocaleString nodeName = null;
        AgentTask currentTask = execution.getCurrentTask();
        if (null == currentTask) {
            JSONObject multiLangDatas = BpmnModelUtil.getMultiLangDatas(processInstanceId);
            FlowElement flowElement = execution.getCurrentFlowElement();
            nodeName = BpmnModelUtil.getMultiLangFieldValue(multiLangDatas, flowElement.getId() + ".name", flowElement.getName());
        } else {
            nodeName = currentTask.getName();
            operationLog.setTaskId(currentTask.getId());
        }
        operationLog.setActivityName(nodeName);
        operationLog.setActivityId(execution.getCurrentActivityId());
        return operationLog;
    }
}

