/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.util;

import java.util.List;
import kd.bos.exception.KDException;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFException;

public class WithdrawTaskUtil {
    private WithdrawTaskUtil() {
    }

    public static ExecutionEntity getExecutionEntity(CommandContext commandContext, String businessKey) {
        ExecutionEntity execution = null;
        EntityQueryBuilder eb = commandContext.getExecutionEntityManager().createQueryBuilder();
        eb.addFilter("businessKey", businessKey);
        List list = commandContext.getExecutionEntityManager().findByQueryBuilder(eb);
        for (ExecutionEntity entity : list) {
            if (!entity.isActive() || entity.isScope()) continue;
            execution = entity;
            break;
        }
        if (execution != null && execution.getActivityId().contains("YunzhijiaTask")) {
            HistoricActivityInstanceEntityManager hiactManager = commandContext.getHistoricActivityInstanceEntityManager();
            List<HistoricActivityInstanceEntity> haiEntiys = hiactManager.findByActivityId(execution.getProcessInstanceId(), execution.getActivityId());
            if (haiEntiys == null || haiEntiys.isEmpty()) {
                throw new KDException(WFErrorCode.processSuspendSimple(), new Object[0]);
            }
            Long targetId = ((HistoricActivityInstanceEntity)hiactManager.findById(haiEntiys.get(0).getSourceElementId())).getTargetElementId();
            HistoricActivityInstanceEntity currentActInst = null;
            for (HistoricActivityInstanceEntity i : haiEntiys) {
                if (i.getId().longValue() != targetId.longValue()) continue;
                currentActInst = i;
                break;
            }
            if (currentActInst == null) {
                throw new KDException(WFErrorCode.processSuspendSimple(), new Object[0]);
            }
            execution = null;
            for (ExecutionEntity e : list) {
                if (!WfUtils.isNotEmpty(e.getCurrentActInstId()) || e.getCurrentActInstId().longValue() != currentActInst.getId().longValue()) continue;
                execution = e;
                break;
            }
        }
        return execution;
    }

    public static boolean isProcessPause(CommandContext commandContext, Long processInstanceId) {
        HistoricActivityInstanceEntity lastOne;
        boolean pause = false;
        List<HistoricActivityInstanceEntity> list = commandContext.getHistoricActivityInstanceEntityManager().findByProcessInstanceId(processInstanceId);
        if (!list.isEmpty() && ((lastOne = list.get(list.size() - 1)).getActivityType().equals("UserTask") || lastOne.getActivityType().equals("AuditTask") || lastOne.getActivityType().equals("YunzhijiaTask")) && WfUtils.isEmpty(lastOne.getExecutionType())) {
            pause = true;
        }
        return pause;
    }

    public static boolean checkPreNode(CommandContext commandContext, HistoricActivityInstanceEntity hisActInst) {
        boolean first = false;
        HistoricActivityInstanceEntityManager hisActivityManager = commandContext.getHistoricActivityInstanceEntityManager();
        List<HistoricActivityInstanceEntity> seqNodes = hisActivityManager.findByTargetId(hisActInst.getProcessInstanceId(), hisActInst.getId());
        block0: for (HistoricActivityInstanceEntity seqInst : seqNodes) {
            List<HistoricActivityInstanceEntity> preNodes = hisActivityManager.findByTargetId(hisActInst.getProcessInstanceId(), seqInst.getId());
            for (HistoricActivityInstanceEntity nodeInst : preNodes) {
                if (!nodeInst.getActivityType().equals("StartSignalEvent")) continue;
                first = true;
                continue block0;
            }
        }
        return first;
    }

    public static HistoricActivityInstanceEntity getHistoricActivityByCurActInstId(CommandContext commandContext, Long currentActInstId) {
        HistoricActivityInstanceEntity curHisActInst;
        boolean canRecall = true;
        HistoricActivityInstanceEntityManager hisActivityManager = commandContext.getHistoricActivityInstanceEntityManager();
        List<HistoricActivityInstanceEntity> seqNodes = hisActivityManager.findByTargetId((curHisActInst = (HistoricActivityInstanceEntity)hisActivityManager.findById(currentActInstId)).getProcessInstanceId(), curHisActInst.getId());
        if (seqNodes == null || seqNodes.isEmpty()) {
            throw new WFException(WFErrorCode.findPreActivitInstance(), curHisActInst.getActivityId());
        }
        for (HistoricActivityInstanceEntity seqInst : seqNodes) {
            List<HistoricActivityInstanceEntity> preNodes = hisActivityManager.findByTargetId(curHisActInst.getProcessInstanceId(), seqInst.getId());
            if (preNodes.size() <= 0) continue;
            HistoricActivityInstanceEntity nodeInst = preNodes.get(0);
            switch (nodeInst.getActivityType()) {
                case "UserTask": {
                    boolean first = WithdrawTaskUtil.checkPreNode(commandContext, nodeInst);
                    if (!first && nodeInst.getAssigneeId() != null) {
                        canRecall = false;
                        break;
                    }
                    return nodeInst;
                }
                case "AuditTask": {
                    if (nodeInst.getExecutionType().equals("byAuto") || nodeInst.getExecutionType().equals("skip")) {
                        return WithdrawTaskUtil.getHistoricActivityByCurActInstId(commandContext, nodeInst.getId());
                    }
                    canRecall = false;
                    break;
                }
                case "AutoTask": {
                    return WithdrawTaskUtil.getHistoricActivityByCurActInstId(commandContext, nodeInst.getId());
                }
                case "YunzhijiaTask": {
                    if ("skip".equals(nodeInst.getExecutionType())) {
                        return WithdrawTaskUtil.getHistoricActivityByCurActInstId(commandContext, nodeInst.getId());
                    }
                    canRecall = false;
                    break;
                }
            }
        }
        if (!canRecall) {
            throw new WFException(WFErrorCode.withdrawError(), new Object[0]);
        }
        return null;
    }
}

