/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.util.condition;

import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.workflow.bpmn.model.BillTask;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.engine.MultiLangEnumBridge;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;

public enum ConditionType {
    ADDRESS("address", Domain.PROCESS, new MultiLangEnumBridge("\u6d41\u7a0b\u542f\u52a8\u6761\u4ef6", "ConditionType_1", "bos-wf-engine"), false, true),
    SCHEMA("addressScheme", Domain.SCHEMA, new MultiLangEnumBridge("\u65b9\u6848\u9002\u7528\u6761\u4ef6", "ConditionType_2", "bos-wf-engine"), false, true),
    ENV_ADDRESS_PROCESS("addressProcess", Domain.PROCESS, new MultiLangEnumBridge("\u6d41\u7a0b\u542f\u52a8\u6761\u4ef6\uff08\u6309\u4e8b\u4ef6\u542f\u52a8\uff09", "ConditionType_1_1", "bos-wf-engine"), false, true),
    BIZ_FLOW_CLOSE_RULE("bizFlow-close-rule", Domain.NODE, new MultiLangEnumBridge("\u5355\u636e\u5173\u95ed\u6761\u4ef6\uff08\u4efb\u52a1\u5173\u95ed\u6761\u4ef6\uff09", "ConditionType_3", "bos-wf-engine"), false, true),
    BIZ_BILL_CLOSE("bizFlow-billCloseCondition-", Domain.NODE, new MultiLangEnumBridge("\u5355\u636e\u5173\u95ed\u6761\u4ef6\uff08\u4efb\u52a1\u5173\u95ed\u6761\u4ef6\uff09", "ConditionType_4", "bos-wf-engine"), false, true),
    BiZ_SKIP("-billCloseConfig-closeEvent-condition", Domain.NODE, new MultiLangEnumBridge("\u5355\u636e\u5173\u95ed\u6761\u4ef6\uff08\u6d41\u7a0b\u5185\u4e8b\u4ef6\u8df3\u51fa\u6761\u4ef6\uff09", "ConditionType_5", "bos-wf-engine"), false, true),
    SKIP("skip", Domain.NODE, new MultiLangEnumBridge("\u8df3\u8fc7\u6761\u4ef6", "ConditionType_6", "bos-wf-engine"), false, true),
    AUTO_AUDIT("autoAudit", Domain.NODE, new MultiLangEnumBridge("\u81ea\u52a8\u5ba1\u6279\u6761\u4ef6", "ConditionType_7", "bos-wf-engine"), false, true),
    BATCH_OP_RULE("batchOpRule", Domain.NODE, new MultiLangEnumBridge("\u6279\u91cf\u540c\u610f|\u9a73\u56de\u6761\u4ef6", "ConditionType_8", "bos-wf-engine"), false, true),
    PARTICIPANT("participant", Domain.NODE, new MultiLangEnumBridge("\u53c2\u4e0e\u4eba\u6761\u4ef6", "ConditionType_9", "bos-wf-engine"), true, true),
    PARTICIPANT_CONDITION_AUTO_CIRCULATE("participantAutoCirculate", Domain.NODE, new MultiLangEnumBridge("\u53c2\u4e0e\u4eba\u6761\u4ef6\uff08\u81ea\u52a8\u4f20\u9605\uff09", "ConditionType_9_1", "bos-wf-engine"), true, true),
    PARTICIPANT_CONDITION_AUTO_COORDINATOR("participantAutoCoordinator", Domain.NODE, new MultiLangEnumBridge("\u53c2\u4e0e\u4eba\u6761\u4ef6\uff08\u81ea\u52a8\u534f\u529e\uff09", "ConditionType_9_2", "bos-wf-engine"), true, true),
    AUDIT_POINT("auditPoint", Domain.NODE, new MultiLangEnumBridge("\u5ba1\u6279\u8981\u70b9\u6761\u4ef6", "ConditionType_10", "bos-wf-engine"), false, true),
    BILL_SUBJECT_PC("billSubjectPc", Domain.NODE, new MultiLangEnumBridge("\u5355\u636e\u6d41\u7a0b\u5c5e\u6027-\u4efb\u52a1\u4e3b\u9898", "ConditionType_11", "bos-wf-engine"), false, true),
    BILL_SUBJECT_MOBIL("billSubjectMobil", Domain.NODE, new MultiLangEnumBridge("\u5355\u636e\u6d41\u7a0b\u5c5e\u6027-\u79fb\u52a8\u7aef\u5355\u636e\u4e3b\u9898", "ConditionType_12", "bos-wf-engine"), false, true),
    TIMING_WAIT("timingWait", Domain.NODE, new MultiLangEnumBridge("\u7b49\u5f85\u8282\u70b9\u8df3\u51fa\u6761\u4ef6", "ConditionType_13", "bos-wf-engine"), false, true),
    EVENT_WAIT_SKIP("eventWaitSkip", Domain.NODE, new MultiLangEnumBridge("\u8df3\u51fa\u6761\u4ef6", "ConditionType_13_1", "bos-wf-engine"), false, true),
    EVENT_BILL_SKIP("eventBillSkip", Domain.NODE, new MultiLangEnumBridge("\u5355\u636e\u5173\u95ed\u6761\u4ef6\uff08\u6d41\u7a0b\u5185\u4e8b\u4ef6\u8df3\u51fa\u6761\u4ef6\uff09", "ConditionType_13_2", "bos-wf-engine"), false, true),
    EVENT_TIMING_WAIT("EVENT-WAIT-CONDITION", Domain.NODE, new MultiLangEnumBridge("\u8df3\u51fa\u6761\u4ef6", "ConditionType_14", "bos-wf-engine"), false, true),
    MSG("msg", Domain.MSG, new MultiLangEnumBridge("\u6d88\u606f\u901a\u77e5\u53d1\u9001\u6761\u4ef6", "ConditionType_15", "bos-wf-engine"), false, true),
    SEQUENCE_FLOW("SequenceFlow", Domain.SEQUENCE, new MultiLangEnumBridge("\u8fde\u63a5\u7ebf\u6d41\u8f6c\u6761\u4ef6", "ConditionType_16", "bos-wf-engine"), false, true),
    TASK_AUTO_RULE("taskAutoRule", Domain.OTHERS, new MultiLangEnumBridge("TASK_AUTO_RULE", "", ""), false, false),
    TASK_SUBJECT_CONDITION("taskSubject", Domain.NODE, new MultiLangEnumBridge("\u4efb\u52a1\u4e3b\u9898\u6761\u4ef6", "ConditionType_17", "bos-wf-engine"), false, true),
    CLOSE_PROCESS("closeProcess", Domain.NODE, new MultiLangEnumBridge("\u4e1a\u52a1\u6d41\u5173\u95ed\u6761\u4ef6", "ConditionType_18", "bos-wf-engine"), false, true),
    SUPPORT_TOOLS_TEST("support-tools-test", Domain.OTHERS, new MultiLangEnumBridge("SUPPORT_TOOLS_TEST", "", ""), false, false),
    DELEGATE_SETTING("delegateSetting", Domain.OTHERS, new MultiLangEnumBridge("DELEGATE_SETTING", "", ""), false, false),
    OTHERS("others", Domain.OTHERS, new MultiLangEnumBridge("OTHERS", "", ""), false, false);

    public static final String ITEM_NAME = "ConditionType::itemName";
    public static final String CONDITION_KEY = "CONDITION_KEY";
    public static final String OP_DESC = "ConditionType::opDesc";
    public static final String DEFAULT_SEQ_VALUE = "${ auditNumber IN \"Consent\" }";
    public static final Pattern PATTERN;
    private final String type;
    private final Domain domain;
    private final MultiLangEnumBridge desc;
    private final boolean logRuntime;
    private final boolean selected;

    public static ConditionType calNodeType(String typeStr) {
        ConditionType[] values;
        for (ConditionType value : values = ConditionType.values()) {
            if (!Objects.equals(value.getType(), typeStr)) continue;
            return value;
        }
        return OTHERS;
    }

    private ConditionType(String type, Domain domain, MultiLangEnumBridge desc, boolean logRuntime, boolean selected) {
        this.type = type;
        this.domain = domain;
        this.desc = desc;
        this.logRuntime = logRuntime;
        this.selected = selected;
    }

    public boolean getSelected() {
        return this.selected;
    }

    public String getDesc() {
        return this.desc.loadKDString();
    }

    public boolean logRuntime() {
        return this.logRuntime;
    }

    public String getType() {
        return this.type;
    }

    public static ConditionType valueOf(String key, boolean byKey) {
        if (!byKey) {
            try {
                return ConditionType.valueOf(key);
            }
            catch (IllegalArgumentException e) {
                return OTHERS;
            }
        }
        if (key.startsWith("AuditFlow:") || key.startsWith("BizFlow:")) {
            return ADDRESS;
        }
        if (key.startsWith("addressScheme")) {
            return SCHEMA;
        }
        if (key.startsWith("bizFlow-close-rule")) {
            return BIZ_FLOW_CLOSE_RULE;
        }
        if (key.startsWith("bizFlow-billCloseCondition-")) {
            return BIZ_BILL_CLOSE;
        }
        if (key.startsWith("closeProcess")) {
            return CLOSE_PROCESS;
        }
        if (key.startsWith("SequenceFlow")) {
            return SEQUENCE_FLOW;
        }
        if (key.startsWith("addressProcess")) {
            return ENV_ADDRESS_PROCESS;
        }
        int strikethroughIndex = key.indexOf(45);
        int underscoreIndex = key.lastIndexOf(95);
        if (underscoreIndex < 0) {
            underscoreIndex = key.length();
        }
        String substring = "";
        if (strikethroughIndex >= 0) {
            substring = key.substring(strikethroughIndex, underscoreIndex);
        }
        if ("-billCloseConfig-closeEvent-condition".equals(substring)) {
            return BiZ_SKIP;
        }
        Matcher matcher = PATTERN.matcher(key);
        if (!matcher.find()) {
            return OTHERS;
        }
        String group = matcher.group();
        return ConditionType.calNodeType(group);
    }

    public Domain getDomain() {
        return this.domain;
    }

    public static String logOpDesc(ConditionalRuleEntity express) {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext == null) {
            return "";
        }
        if (express == null || express.getShowtext() == null || express.getShowtext().getLocaleValue() == null) {
            commandContext.addAttribute(OP_DESC, "");
            return "";
        }
        commandContext.addAttribute(OP_DESC, express.getShowtext().getLocaleValue());
        return express.getShowtext().getLocaleValue();
    }

    public static String logOpDesc(String showText) {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext == null || StringUtils.isEmpty((CharSequence)showText)) {
            return "";
        }
        commandContext.addAttribute(OP_DESC, showText);
        return showText;
    }

    public static String logSeqName(SequenceFlow sequenceFlow) {
        return ConditionType.logItemName(sequenceFlow);
    }

    public static String getSeqName() {
        return ConditionType.getItemName();
    }

    public static String getItemName() {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext == null) {
            return "";
        }
        String attribute = (String)commandContext.getAttribute(ITEM_NAME);
        if (StringUtils.isEmpty((CharSequence)attribute)) {
            return "";
        }
        commandContext.removeAttribute(ITEM_NAME);
        return attribute;
    }

    public static String getOpDesc() {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext == null) {
            return "";
        }
        String tips = Optional.ofNullable((String)commandContext.getAttribute(OP_DESC)).orElse("");
        commandContext.removeAttribute(OP_DESC);
        return tips;
    }

    public static String logItemName(FlowElement node) {
        String name;
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext == null || node == null) {
            return "";
        }
        if (StringUtils.isEmpty((CharSequence)node.getName())) {
            name = node.getNumber();
        } else {
            String number = node instanceof BillTask ? node.getId() : node.getNumber();
            name = node.getName() + "(" + number + ")";
        }
        commandContext.addAttribute(ITEM_NAME, name);
        return name;
    }

    public static String logConditionKey(String key) {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext == null || StringUtils.isEmpty((CharSequence)key)) {
            return "";
        }
        commandContext.addAttribute(CONDITION_KEY, key);
        return key;
    }

    public static String getConditionKey() {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext == null) {
            return "";
        }
        return Optional.ofNullable((String)commandContext.getAttribute(CONDITION_KEY)).orElse("");
    }

    public static void removeConditionKey() {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext == null) {
            return;
        }
        commandContext.removeAttribute(CONDITION_KEY);
    }

    static {
        PATTERN = Pattern.compile("(?<=\\[)(.+?)(?=\\])");
    }

    public static enum Domain {
        PROCESS,
        SCHEMA,
        NODE,
        SEQUENCE,
        MSG,
        OTHERS;

    }
}

